///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEJSExtPropertyDeclarer_h
#define ICEJSExtPropertyDeclarer_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
	CEJSExtPropertyAttr_None = 0,
	CEJSExtPropertyAttr_ReadOnly = 1<<0,
	CEJSExtPropertyAttr_Const = 1<<1
} CEJSExtPropertyAttr;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEJSExtPropertyDeclarer ICEJSExtPropertyDeclarer
 * @{
 */

/*!
 * ID of ICEJSExtPropertyDeclarer
 */
#define CEComIID_ICEJSExtPropertyDeclarer 0x2f0741a5


/*!
 * ICEJSExtPropertyDeclarer
 */
typedef struct ICEJSExtPropertyDeclarer
{
	const struct ICEJSExtPropertyDeclarer_vtbl* _vtbl;
} ICEJSExtPropertyDeclarer;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iJSExtPropertyDeclarer	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEJSExtPropertyDeclarer_queryInterface) (ICEJSExtPropertyDeclarer* iJSExtPropertyDeclarer, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSExtPropertyDeclarer_addRef) (ICEJSExtPropertyDeclarer* iJSExtPropertyDeclarer);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSExtPropertyDeclarer_release) (ICEJSExtPropertyDeclarer* iJSExtPropertyDeclarer);

typedef CEHResult (*iCEJSExtPropertyDeclarer_declareProperty) (ICEJSExtPropertyDeclarer* iJSExtPropertyDeclarer, INT32 propertyId, const UTF16CHAR* pPropertyName, UINT32 numOfChars16, UINT32 attr);

typedef CEHResult (*iCEJSExtPropertyDeclarer_declareMethod) (ICEJSExtPropertyDeclarer* iJSExtPropertyDeclarer, INT32 methodId, const UTF16CHAR* pMethodName, UINT32 numOfChars16, UINT32 attr, UINT32 argCount);

/*!
 * V-table of ICEJSExtPropertyDeclarer
 */
struct ICEJSExtPropertyDeclarer_vtbl
{
	iCEJSExtPropertyDeclarer_queryInterface	_queryInterface;	//!< Query interface.
	iCEJSExtPropertyDeclarer_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEJSExtPropertyDeclarer_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEJSExtPropertyDeclarer_declareProperty	_declareProperty;
	iCEJSExtPropertyDeclarer_declareMethod	_declareMethod;
};

/*! @}
 * end of ICEJSExtPropertyDeclarer
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEJSExtPropertyDeclarerRef CEComICEJSExtPropertyDeclarerRef
 * @{
 */

class CEComICEJSExtPropertyDeclarerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEJSExtPropertyDeclarerRef() : _iJSExtPropertyDeclarer(0) {}
	CEComICEJSExtPropertyDeclarerRef(ICEJSExtPropertyDeclarer* iOther) : _iJSExtPropertyDeclarer(0)
	{
		if (iOther)
		{
			_iJSExtPropertyDeclarer = iOther;
			_iJSExtPropertyDeclarer->_vtbl->_addRef(_iJSExtPropertyDeclarer);
		}
	}

	CEComICEJSExtPropertyDeclarerRef(const CEComICEJSExtPropertyDeclarerRef& other) : _iJSExtPropertyDeclarer(0)
	{
		if (other._iJSExtPropertyDeclarer)
		{
			_iJSExtPropertyDeclarer = other._iJSExtPropertyDeclarer;
			_iJSExtPropertyDeclarer->_vtbl->_addRef(_iJSExtPropertyDeclarer);
		}
	}

	~CEComICEJSExtPropertyDeclarerRef()
	{
		if (_iJSExtPropertyDeclarer)
		{
			ICEJSExtPropertyDeclarer* tmp = _iJSExtPropertyDeclarer;
			_iJSExtPropertyDeclarer = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEJSExtPropertyDeclarer* iJSExtPropertyDeclarer;
				void* _ptr;
			} uIntf;
			uIntf.iJSExtPropertyDeclarer = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEJSExtPropertyDeclarer, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iJSExtPropertyDeclarer)
				{
					ICEJSExtPropertyDeclarer* tmp = _iJSExtPropertyDeclarer;
					_iJSExtPropertyDeclarer = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iJSExtPropertyDeclarer = uIntf.iJSExtPropertyDeclarer;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEJSExtPropertyDeclarer* object() const	{ return _iJSExtPropertyDeclarer; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEJSExtPropertyDeclarer* iOther)
	{
		if (_iJSExtPropertyDeclarer)
		{
			ICEJSExtPropertyDeclarer* tmp = _iJSExtPropertyDeclarer;
			_iJSExtPropertyDeclarer = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iJSExtPropertyDeclarer = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEJSExtPropertyDeclarer* detach()
	{
		ICEJSExtPropertyDeclarer* iIntf = _iJSExtPropertyDeclarer;
		_iJSExtPropertyDeclarer = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEJSExtPropertyDeclarer* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iJSExtPropertyDeclarer;
		if (_iJSExtPropertyDeclarer)
		{
			_iJSExtPropertyDeclarer->_vtbl->_addRef(_iJSExtPropertyDeclarer);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEJSExtPropertyDeclarer*() const	{ return _iJSExtPropertyDeclarer; }
	FORCEINLINE_WITHOUT_DEBUG ICEJSExtPropertyDeclarer& operator*() const	{ return *_iJSExtPropertyDeclarer; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iJSExtPropertyDeclarer == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEJSExtPropertyDeclarer* iOther) const	{ return (_iJSExtPropertyDeclarer != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEJSExtPropertyDeclarer* iOther) const	{ return (_iJSExtPropertyDeclarer == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEJSExtPropertyDeclarerRef& operator=(const CEComICEJSExtPropertyDeclarerRef& other)	{ return operator=(other._iJSExtPropertyDeclarer); }

	CEComICEJSExtPropertyDeclarerRef& operator=(const ICEJSExtPropertyDeclarer* iOther)
	{
		if (_iJSExtPropertyDeclarer != iOther)
		{
			if (_iJSExtPropertyDeclarer)
			{
				ICEJSExtPropertyDeclarer* tmp = _iJSExtPropertyDeclarer;
				_iJSExtPropertyDeclarer = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iJSExtPropertyDeclarer = const_cast<ICEJSExtPropertyDeclarer*>(iOther);
			if (_iJSExtPropertyDeclarer)
			{
				_iJSExtPropertyDeclarer->_vtbl->_addRef(_iJSExtPropertyDeclarer);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEJSExtPropertyDeclarer** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEJSExtPropertyDeclarerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iJSExtPropertyDeclarer && "has a com object reference. clear first.");
		return & _iJSExtPropertyDeclarer; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEJSExtPropertyDeclarerRef& other)
	{
		bool result = false;
		if (_iJSExtPropertyDeclarer)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iJSExtPropertyDeclarer);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iJSExtPropertyDeclarer ? _iJSExtPropertyDeclarer->_vtbl->_queryInterface(_iJSExtPropertyDeclarer, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iJSExtPropertyDeclarer) { _iJSExtPropertyDeclarer->_vtbl->_addRef(_iJSExtPropertyDeclarer); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iJSExtPropertyDeclarer) { _iJSExtPropertyDeclarer->_vtbl->_release(_iJSExtPropertyDeclarer); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult declareProperty(INT32 propertyId, const UTF16CHAR* pPropertyName, UINT32 numOfChars16, UINT32 attr)	{ return _iJSExtPropertyDeclarer ? _iJSExtPropertyDeclarer->_vtbl->_declareProperty(_iJSExtPropertyDeclarer, propertyId, pPropertyName, numOfChars16, attr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult declareMethod(INT32 methodId, const UTF16CHAR* pMethodName, UINT32 numOfChars16, UINT32 attr, UINT32 argCount)	{ return _iJSExtPropertyDeclarer ? _iJSExtPropertyDeclarer->_vtbl->_declareMethod(_iJSExtPropertyDeclarer, methodId, pMethodName, numOfChars16, attr, argCount) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEJSExtPropertyDeclarer* _iJSExtPropertyDeclarer;
};

/*! @}
 * end of CEComICEJSExtPropertyDeclarerRef
 */

#endif // __cplusplus

#endif
