///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlWindowWidget_h
#define ICEHtmlWindowWidget_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "ICEUIFocusFrame.h"
#include "CEUITypes.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlWindowWidget ICEHtmlWindowWidget
 * @{
 */

/*!
 * ID of ICEHtmlWindowWidget
 */
#define CEComIID_ICEHtmlWindowWidget 0x2f9de5a5


/*!
 * ICEHtmlWindowWidget
 */
typedef struct ICEHtmlWindowWidget
{
	const struct ICEHtmlWindowWidget_vtbl* _vtbl;
} ICEHtmlWindowWidget;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iWindowWidget	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlWindowWidget_queryInterface) (ICEHtmlWindowWidget* iWindowWidget, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWindowWidget_addRef) (ICEHtmlWindowWidget* iWindowWidget);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWindowWidget_release) (ICEHtmlWindowWidget* iWindowWidget);

typedef CEHResult (*iCEHtmlWindowWidget_setWindowBlitting) (ICEHtmlWindowWidget* iWindowWidget, bool blitting);

typedef CEHResult (*iCEHtmlWindowWidget_invalidateLayout) (ICEHtmlWindowWidget* iWindowWidget);

typedef CEHResult (*iCEHtmlWindowWidget_setLocation) (ICEHtmlWindowWidget* iWindowWidget, const CEPointBase* location, bool isRelative);

typedef CEHResult (*iCEHtmlWindowWidget_getLocation) (ICEHtmlWindowWidget* iWindowWidget, CEPointBase *const locationOut);

typedef CEHResult (*iCEHtmlWindowWidget_setSize) (ICEHtmlWindowWidget* iWindowWidget, const CEDim* size, bool isRelative);

typedef CEHResult (*iCEHtmlWindowWidget_setVisible) (ICEHtmlWindowWidget* iWindowWidget, const bool visible);

typedef CEHResult (*iCEHtmlWindowWidget_invalidateRect) (ICEHtmlWindowWidget* iWindowWidget, const CERect* rect, bool repaintImmediate);

typedef CEHResult (*iCEHtmlWindowWidget_setBounds) (ICEHtmlWindowWidget* iWindowWidget, const CERect* rect);

typedef CEHResult (*iCEHtmlWindowWidget_getBounds) (ICEHtmlWindowWidget* iWindowWidget, CERect *const rectOut);

typedef CEHResult (*iCEHtmlWindowWidget_ensureFocus) (ICEHtmlWindowWidget* iWindowWidget);

typedef CEHResult (*iCEHtmlWindowWidget_clearFocus) (ICEHtmlWindowWidget* iWindowWidget);

typedef CEHResult (*iCEHtmlWindowWidget_getFocusFrameFactory) (ICEHtmlWindowWidget* iWindowWidget, struct ICEUIFocusFrameFactory* *const iFocusFrameFactoryOut);

typedef CEHResult (*iCEHtmlWindowWidget_setRGBAColor) (ICEHtmlWindowWidget* iWindowWidget, const CERGBAColor* bgColor, bool isBgColor, bool callRepaint);

typedef CEHResult (*iCEHtmlWindowWidget_paintComponent) (ICEHtmlWindowWidget* iWindowWidget, struct ICEUIGraphicsContext* iGc);

typedef CEHResult (*iCEHtmlWindowWidget_getCursorPosition) (ICEHtmlWindowWidget* iWindowWidget, CEPointBase *const positionOut);

/*!
 * V-table of ICEHtmlWindowWidget
 */
struct ICEHtmlWindowWidget_vtbl
{
	iCEHtmlWindowWidget_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlWindowWidget_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlWindowWidget_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlWindowWidget_setWindowBlitting	_setWindowBlitting;
	iCEHtmlWindowWidget_invalidateLayout	_invalidateLayout;
	iCEHtmlWindowWidget_setLocation	_setLocation;
	iCEHtmlWindowWidget_getLocation	_getLocation;
	iCEHtmlWindowWidget_setSize	_setSize;
	iCEHtmlWindowWidget_setVisible	_setVisible;
	iCEHtmlWindowWidget_invalidateRect	_invalidateRect;
	iCEHtmlWindowWidget_setBounds	_setBounds;
	iCEHtmlWindowWidget_getBounds	_getBounds;
	iCEHtmlWindowWidget_ensureFocus	_ensureFocus;
	iCEHtmlWindowWidget_clearFocus	_clearFocus;
	iCEHtmlWindowWidget_getFocusFrameFactory	_getFocusFrameFactory;
	iCEHtmlWindowWidget_setRGBAColor	_setRGBAColor;
	iCEHtmlWindowWidget_paintComponent	_paintComponent;
	iCEHtmlWindowWidget_getCursorPosition	_getCursorPosition;
};

/*! @}
 * end of ICEHtmlWindowWidget
 */

/*! \defgroup ICEHtmlWidgetInvalidator ICEHtmlWidgetInvalidator
 * @{
 */

/*!
 * ID of ICEHtmlWidgetInvalidator
 */
#define CEComIID_ICEHtmlWidgetInvalidator 0x734f4df3

/*!
 * ICEHtmlWidgetInvalidator
 */
typedef struct ICEHtmlWidgetInvalidator
{
	const struct ICEHtmlWidgetInvalidator_vtbl* _vtbl;
} ICEHtmlWidgetInvalidator;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iWidgetInvalidator	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlWidgetInvalidator_queryInterface) (ICEHtmlWidgetInvalidator* iWidgetInvalidator, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWidgetInvalidator_addRef) (ICEHtmlWidgetInvalidator* iWidgetInvalidator);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWidgetInvalidator_release) (ICEHtmlWidgetInvalidator* iWidgetInvalidator);

typedef CEHResult (*iCEHtmlWidgetInvalidator_invalidateLayout) (ICEHtmlWidgetInvalidator* iWidgetInvalidator);

typedef CEHResult (*iCEHtmlWidgetInvalidator_invalidateRect) (ICEHtmlWidgetInvalidator* iWidgetInvalidator, const CERect* rect, bool repaintImmediate);

typedef CEHResult (*iCEHtmlWidgetInvalidator_setBounds) (ICEHtmlWidgetInvalidator* iWidgetInvalidator, const CERect* rect);

typedef CEHResult (*iCEHtmlWidgetInvalidator_setSize) (ICEHtmlWidgetInvalidator* iWidgetInvalidator, const CEDim* size, bool isRelative);

typedef CEHResult (*iCEHtmlWidgetInvalidator_setVisible) (ICEHtmlWidgetInvalidator* iWidgetInvalidator, const bool visible);

typedef CEHResult (*iCEHtmlWidgetInvalidator_setLocation) (ICEHtmlWidgetInvalidator* iWidgetInvalidator, const CEPointBase* location, bool isRelative);

/*!
 * V-table of ICEHtmlWidgetInvalidator
 */
struct ICEHtmlWidgetInvalidator_vtbl
{
	iCEHtmlWidgetInvalidator_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlWidgetInvalidator_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlWidgetInvalidator_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlWidgetInvalidator_invalidateLayout	_invalidateLayout;
	iCEHtmlWidgetInvalidator_invalidateRect	_invalidateRect;
	iCEHtmlWidgetInvalidator_setBounds	_setBounds;
	iCEHtmlWidgetInvalidator_setSize	_setSize;
	iCEHtmlWidgetInvalidator_setVisible	_setVisible;
	iCEHtmlWidgetInvalidator_setLocation	_setLocation;
};

/*! @}
 * end of ICEHtmlWidgetInvalidator
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlWindowWidgetRef CEComICEHtmlWindowWidgetRef
 * @{
 */

class CEComICEHtmlWindowWidgetRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlWindowWidgetRef() : _iWindowWidget(0) {}
	CEComICEHtmlWindowWidgetRef(ICEHtmlWindowWidget* iOther) : _iWindowWidget(0)
	{
		if (iOther)
		{
			_iWindowWidget = iOther;
			_iWindowWidget->_vtbl->_addRef(_iWindowWidget);
		}
	}

	CEComICEHtmlWindowWidgetRef(const CEComICEHtmlWindowWidgetRef& other) : _iWindowWidget(0)
	{
		if (other._iWindowWidget)
		{
			_iWindowWidget = other._iWindowWidget;
			_iWindowWidget->_vtbl->_addRef(_iWindowWidget);
		}
	}

	~CEComICEHtmlWindowWidgetRef()
	{
		if (_iWindowWidget)
		{
			ICEHtmlWindowWidget* tmp = _iWindowWidget;
			_iWindowWidget = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlWindowWidget* iWindowWidget;
				void* _ptr;
			} uIntf;
			uIntf.iWindowWidget = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlWindowWidget, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iWindowWidget)
				{
					ICEHtmlWindowWidget* tmp = _iWindowWidget;
					_iWindowWidget = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iWindowWidget = uIntf.iWindowWidget;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWindowWidget* object() const	{ return _iWindowWidget; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlWindowWidget* iOther)
	{
		if (_iWindowWidget)
		{
			ICEHtmlWindowWidget* tmp = _iWindowWidget;
			_iWindowWidget = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iWindowWidget = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlWindowWidget* detach()
	{
		ICEHtmlWindowWidget* iIntf = _iWindowWidget;
		_iWindowWidget = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlWindowWidget* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iWindowWidget;
		if (_iWindowWidget)
		{
			_iWindowWidget->_vtbl->_addRef(_iWindowWidget);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlWindowWidget*() const	{ return _iWindowWidget; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWindowWidget& operator*() const	{ return *_iWindowWidget; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iWindowWidget == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlWindowWidget* iOther) const	{ return (_iWindowWidget != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlWindowWidget* iOther) const	{ return (_iWindowWidget == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlWindowWidgetRef& operator=(const CEComICEHtmlWindowWidgetRef& other)	{ return operator=(other._iWindowWidget); }

	CEComICEHtmlWindowWidgetRef& operator=(const ICEHtmlWindowWidget* iOther)
	{
		if (_iWindowWidget != iOther)
		{
			if (_iWindowWidget)
			{
				ICEHtmlWindowWidget* tmp = _iWindowWidget;
				_iWindowWidget = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iWindowWidget = const_cast<ICEHtmlWindowWidget*>(iOther);
			if (_iWindowWidget)
			{
				_iWindowWidget->_vtbl->_addRef(_iWindowWidget);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWindowWidget** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlWindowWidgetRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iWindowWidget && "has a com object reference. clear first.");
		return & _iWindowWidget; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlWindowWidgetRef& other)
	{
		bool result = false;
		if (_iWindowWidget)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iWindowWidget);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iWindowWidget ? _iWindowWidget->_vtbl->_queryInterface(_iWindowWidget, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iWindowWidget) { _iWindowWidget->_vtbl->_addRef(_iWindowWidget); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iWindowWidget) { _iWindowWidget->_vtbl->_release(_iWindowWidget); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setWindowBlitting(bool blitting)	{ return _iWindowWidget ? _iWindowWidget->_vtbl->_setWindowBlitting(_iWindowWidget, blitting) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult invalidateLayout()	{ return _iWindowWidget ? _iWindowWidget->_vtbl->_invalidateLayout(_iWindowWidget) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setLocation(const CEPointBase* location, bool isRelative)	{ return _iWindowWidget ? _iWindowWidget->_vtbl->_setLocation(_iWindowWidget, location, isRelative) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getLocation(CEPointBase *const locationOut)	{ return _iWindowWidget ? _iWindowWidget->_vtbl->_getLocation(_iWindowWidget, locationOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setSize(const CEDim* size, bool isRelative)	{ return _iWindowWidget ? _iWindowWidget->_vtbl->_setSize(_iWindowWidget, size, isRelative) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setVisible(const bool visible)	{ return _iWindowWidget ? _iWindowWidget->_vtbl->_setVisible(_iWindowWidget, visible) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult invalidateRect(const CERect* rect, bool repaintImmediate)	{ return _iWindowWidget ? _iWindowWidget->_vtbl->_invalidateRect(_iWindowWidget, rect, repaintImmediate) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setBounds(const CERect* rect)	{ return _iWindowWidget ? _iWindowWidget->_vtbl->_setBounds(_iWindowWidget, rect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBounds(CERect *const rectOut)	{ return _iWindowWidget ? _iWindowWidget->_vtbl->_getBounds(_iWindowWidget, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureFocus()	{ return _iWindowWidget ? _iWindowWidget->_vtbl->_ensureFocus(_iWindowWidget) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult clearFocus()	{ return _iWindowWidget ? _iWindowWidget->_vtbl->_clearFocus(_iWindowWidget) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFocusFrameFactory(struct ICEUIFocusFrameFactory* *const iFocusFrameFactoryOut)	{ return _iWindowWidget ? _iWindowWidget->_vtbl->_getFocusFrameFactory(_iWindowWidget, iFocusFrameFactoryOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setRGBAColor(const CERGBAColor* bgColor, bool isBgColor, bool callRepaint)	{ return _iWindowWidget ? _iWindowWidget->_vtbl->_setRGBAColor(_iWindowWidget, bgColor, isBgColor, callRepaint) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult paintComponent(struct ICEUIGraphicsContext* iGc)	{ return _iWindowWidget ? _iWindowWidget->_vtbl->_paintComponent(_iWindowWidget, iGc) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCursorPosition(CEPointBase *const positionOut)	{ return _iWindowWidget ? _iWindowWidget->_vtbl->_getCursorPosition(_iWindowWidget, positionOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlWindowWidget* _iWindowWidget;
};

/*! @}
 * end of CEComICEHtmlWindowWidgetRef
 */

/*! \defgroup CEComICEHtmlWidgetInvalidatorRef CEComICEHtmlWidgetInvalidatorRef
 * @{
 */

class CEComICEHtmlWidgetInvalidatorRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlWidgetInvalidatorRef() : _iWidgetInvalidator(0) {}
	CEComICEHtmlWidgetInvalidatorRef(ICEHtmlWidgetInvalidator* iOther) : _iWidgetInvalidator(0)
	{
		if (iOther)
		{
			_iWidgetInvalidator = iOther;
			_iWidgetInvalidator->_vtbl->_addRef(_iWidgetInvalidator);
		}
	}

	CEComICEHtmlWidgetInvalidatorRef(const CEComICEHtmlWidgetInvalidatorRef& other) : _iWidgetInvalidator(0)
	{
		if (other._iWidgetInvalidator)
		{
			_iWidgetInvalidator = other._iWidgetInvalidator;
			_iWidgetInvalidator->_vtbl->_addRef(_iWidgetInvalidator);
		}
	}

	~CEComICEHtmlWidgetInvalidatorRef()
	{
		if (_iWidgetInvalidator)
		{
			ICEHtmlWidgetInvalidator* tmp = _iWidgetInvalidator;
			_iWidgetInvalidator = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlWidgetInvalidator* iWidgetInvalidator;
				void* _ptr;
			} uIntf;
			uIntf.iWidgetInvalidator = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlWidgetInvalidator, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iWidgetInvalidator)
				{
					ICEHtmlWidgetInvalidator* tmp = _iWidgetInvalidator;
					_iWidgetInvalidator = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iWidgetInvalidator = uIntf.iWidgetInvalidator;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWidgetInvalidator* object() const	{ return _iWidgetInvalidator; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlWidgetInvalidator* iOther)
	{
		if (_iWidgetInvalidator)
		{
			ICEHtmlWidgetInvalidator* tmp = _iWidgetInvalidator;
			_iWidgetInvalidator = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iWidgetInvalidator = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlWidgetInvalidator* detach()
	{
		ICEHtmlWidgetInvalidator* iIntf = _iWidgetInvalidator;
		_iWidgetInvalidator = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlWidgetInvalidator* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iWidgetInvalidator;
		if (_iWidgetInvalidator)
		{
			_iWidgetInvalidator->_vtbl->_addRef(_iWidgetInvalidator);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlWidgetInvalidator*() const	{ return _iWidgetInvalidator; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWidgetInvalidator& operator*() const	{ return *_iWidgetInvalidator; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iWidgetInvalidator == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlWidgetInvalidator* iOther) const	{ return (_iWidgetInvalidator != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlWidgetInvalidator* iOther) const	{ return (_iWidgetInvalidator == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlWidgetInvalidatorRef& operator=(const CEComICEHtmlWidgetInvalidatorRef& other)	{ return operator=(other._iWidgetInvalidator); }

	CEComICEHtmlWidgetInvalidatorRef& operator=(const ICEHtmlWidgetInvalidator* iOther)
	{
		if (_iWidgetInvalidator != iOther)
		{
			if (_iWidgetInvalidator)
			{
				ICEHtmlWidgetInvalidator* tmp = _iWidgetInvalidator;
				_iWidgetInvalidator = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iWidgetInvalidator = const_cast<ICEHtmlWidgetInvalidator*>(iOther);
			if (_iWidgetInvalidator)
			{
				_iWidgetInvalidator->_vtbl->_addRef(_iWidgetInvalidator);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWidgetInvalidator** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlWidgetInvalidatorRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iWidgetInvalidator && "has a com object reference. clear first.");
		return & _iWidgetInvalidator; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlWidgetInvalidatorRef& other)
	{
		bool result = false;
		if (_iWidgetInvalidator)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iWidgetInvalidator);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iWidgetInvalidator ? _iWidgetInvalidator->_vtbl->_queryInterface(_iWidgetInvalidator, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iWidgetInvalidator) { _iWidgetInvalidator->_vtbl->_addRef(_iWidgetInvalidator); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iWidgetInvalidator) { _iWidgetInvalidator->_vtbl->_release(_iWidgetInvalidator); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult invalidateLayout()	{ return _iWidgetInvalidator ? _iWidgetInvalidator->_vtbl->_invalidateLayout(_iWidgetInvalidator) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult invalidateRect(const CERect* rect, bool repaintImmediate)	{ return _iWidgetInvalidator ? _iWidgetInvalidator->_vtbl->_invalidateRect(_iWidgetInvalidator, rect, repaintImmediate) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setBounds(const CERect* rect)	{ return _iWidgetInvalidator ? _iWidgetInvalidator->_vtbl->_setBounds(_iWidgetInvalidator, rect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setSize(const CEDim* size, bool isRelative)	{ return _iWidgetInvalidator ? _iWidgetInvalidator->_vtbl->_setSize(_iWidgetInvalidator, size, isRelative) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setVisible(const bool visible)	{ return _iWidgetInvalidator ? _iWidgetInvalidator->_vtbl->_setVisible(_iWidgetInvalidator, visible) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setLocation(const CEPointBase* location, bool isRelative)	{ return _iWidgetInvalidator ? _iWidgetInvalidator->_vtbl->_setLocation(_iWidgetInvalidator, location, isRelative) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlWidgetInvalidator* _iWidgetInvalidator;
};

/*! @}
 * end of CEComICEHtmlWidgetInvalidatorRef
 */

#endif // __cplusplus

#endif
