///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlPluginConfirmation_h
#define ICEHtmlPluginConfirmation_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlPluginConfirmation ICEHtmlPluginConfirmation
 * @{
 */

/*!
 * ID of ICEHtmlPluginConfirmation
 */
#define CEComIID_ICEHtmlPluginConfirmation 0x1238fd45

/*!
 * ICEHtmlPluginConfirmation
 */
typedef struct ICEHtmlPluginConfirmation
{
	const struct ICEHtmlPluginConfirmation_vtbl* _vtbl;
} ICEHtmlPluginConfirmation;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iPluginConfirmation	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlPluginConfirmation_queryInterface) (ICEHtmlPluginConfirmation* iPluginConfirmation, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlPluginConfirmation_addRef) (ICEHtmlPluginConfirmation* iPluginConfirmation);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlPluginConfirmation_release) (ICEHtmlPluginConfirmation* iPluginConfirmation);

typedef CEHResult (*iCEHtmlPluginConfirmation_requestConfirmPlugin) (ICEHtmlPluginConfirmation* iPluginConfirmation, void *const cData);

/*!
 * V-table of ICEHtmlPluginConfirmation
 */
struct ICEHtmlPluginConfirmation_vtbl
{
	iCEHtmlPluginConfirmation_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlPluginConfirmation_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlPluginConfirmation_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlPluginConfirmation_requestConfirmPlugin	_requestConfirmPlugin;
};

/*! @}
 * end of ICEHtmlPluginConfirmation
 */

/*! \defgroup ICEHtmlPluginConfirmationPeer ICEHtmlPluginConfirmationPeer
 * @{
 */

/*!
 * ID of ICEHtmlPluginConfirmationPeer
 */
#define CEComIID_ICEHtmlPluginConfirmationPeer 0x9f054d38

/*!
 * ICEHtmlPluginConfirmationPeer
 */
typedef struct ICEHtmlPluginConfirmationPeer
{
	const struct ICEHtmlPluginConfirmationPeer_vtbl* _vtbl;
} ICEHtmlPluginConfirmationPeer;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iPluginConfirmationPeer	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlPluginConfirmationPeer_queryInterface) (ICEHtmlPluginConfirmationPeer* iPluginConfirmationPeer, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlPluginConfirmationPeer_addRef) (ICEHtmlPluginConfirmationPeer* iPluginConfirmationPeer);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlPluginConfirmationPeer_release) (ICEHtmlPluginConfirmationPeer* iPluginConfirmationPeer);

typedef CEHResult (*iCEHtmlPluginConfirmationPeer_replyConfirmPlugin) (ICEHtmlPluginConfirmationPeer* iPluginConfirmationPeer, bool result, bool keepResult, void *const cData);

/*!
 * V-table of ICEHtmlPluginConfirmationPeer
 */
struct ICEHtmlPluginConfirmationPeer_vtbl
{
	iCEHtmlPluginConfirmationPeer_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlPluginConfirmationPeer_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlPluginConfirmationPeer_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlPluginConfirmationPeer_replyConfirmPlugin	_replyConfirmPlugin;
};

/*! @}
 * end of ICEHtmlPluginConfirmationPeer
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlPluginConfirmationRef CEComICEHtmlPluginConfirmationRef
 * @{
 */

class CEComICEHtmlPluginConfirmationRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlPluginConfirmationRef() : _iPluginConfirmation(0) {}
	CEComICEHtmlPluginConfirmationRef(ICEHtmlPluginConfirmation* iOther) : _iPluginConfirmation(0)
	{
		if (iOther)
		{
			_iPluginConfirmation = iOther;
			_iPluginConfirmation->_vtbl->_addRef(_iPluginConfirmation);
		}
	}

	CEComICEHtmlPluginConfirmationRef(const CEComICEHtmlPluginConfirmationRef& other) : _iPluginConfirmation(0)
	{
		if (other._iPluginConfirmation)
		{
			_iPluginConfirmation = other._iPluginConfirmation;
			_iPluginConfirmation->_vtbl->_addRef(_iPluginConfirmation);
		}
	}

	~CEComICEHtmlPluginConfirmationRef()
	{
		if (_iPluginConfirmation)
		{
			ICEHtmlPluginConfirmation* tmp = _iPluginConfirmation;
			_iPluginConfirmation = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlPluginConfirmation* iPluginConfirmation;
				void* _ptr;
			} uIntf;
			uIntf.iPluginConfirmation = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlPluginConfirmation, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iPluginConfirmation)
				{
					ICEHtmlPluginConfirmation* tmp = _iPluginConfirmation;
					_iPluginConfirmation = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iPluginConfirmation = uIntf.iPluginConfirmation;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPluginConfirmation* object() const	{ return _iPluginConfirmation; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlPluginConfirmation* iOther)
	{
		if (_iPluginConfirmation)
		{
			ICEHtmlPluginConfirmation* tmp = _iPluginConfirmation;
			_iPluginConfirmation = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iPluginConfirmation = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlPluginConfirmation* detach()
	{
		ICEHtmlPluginConfirmation* iIntf = _iPluginConfirmation;
		_iPluginConfirmation = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlPluginConfirmation* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iPluginConfirmation;
		if (_iPluginConfirmation)
		{
			_iPluginConfirmation->_vtbl->_addRef(_iPluginConfirmation);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlPluginConfirmation*() const	{ return _iPluginConfirmation; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPluginConfirmation& operator*() const	{ return *_iPluginConfirmation; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iPluginConfirmation == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlPluginConfirmation* iOther) const	{ return (_iPluginConfirmation != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlPluginConfirmation* iOther) const	{ return (_iPluginConfirmation == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlPluginConfirmationRef& operator=(const CEComICEHtmlPluginConfirmationRef& other)	{ return operator=(other._iPluginConfirmation); }

	CEComICEHtmlPluginConfirmationRef& operator=(const ICEHtmlPluginConfirmation* iOther)
	{
		if (_iPluginConfirmation != iOther)
		{
			if (_iPluginConfirmation)
			{
				ICEHtmlPluginConfirmation* tmp = _iPluginConfirmation;
				_iPluginConfirmation = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iPluginConfirmation = const_cast<ICEHtmlPluginConfirmation*>(iOther);
			if (_iPluginConfirmation)
			{
				_iPluginConfirmation->_vtbl->_addRef(_iPluginConfirmation);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPluginConfirmation** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlPluginConfirmationRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iPluginConfirmation && "has a com object reference. clear first.");
		return & _iPluginConfirmation; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlPluginConfirmationRef& other)
	{
		bool result = false;
		if (_iPluginConfirmation)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iPluginConfirmation);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iPluginConfirmation ? _iPluginConfirmation->_vtbl->_queryInterface(_iPluginConfirmation, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iPluginConfirmation) { _iPluginConfirmation->_vtbl->_addRef(_iPluginConfirmation); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iPluginConfirmation) { _iPluginConfirmation->_vtbl->_release(_iPluginConfirmation); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult requestConfirmPlugin(void *const cData)	{ return _iPluginConfirmation ? _iPluginConfirmation->_vtbl->_requestConfirmPlugin(_iPluginConfirmation, cData) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlPluginConfirmation* _iPluginConfirmation;
};

/*! @}
 * end of CEComICEHtmlPluginConfirmationRef
 */

/*! \defgroup CEComICEHtmlPluginConfirmationPeerRef CEComICEHtmlPluginConfirmationPeerRef
 * @{
 */

class CEComICEHtmlPluginConfirmationPeerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlPluginConfirmationPeerRef() : _iPluginConfirmationPeer(0) {}
	CEComICEHtmlPluginConfirmationPeerRef(ICEHtmlPluginConfirmationPeer* iOther) : _iPluginConfirmationPeer(0)
	{
		if (iOther)
		{
			_iPluginConfirmationPeer = iOther;
			_iPluginConfirmationPeer->_vtbl->_addRef(_iPluginConfirmationPeer);
		}
	}

	CEComICEHtmlPluginConfirmationPeerRef(const CEComICEHtmlPluginConfirmationPeerRef& other) : _iPluginConfirmationPeer(0)
	{
		if (other._iPluginConfirmationPeer)
		{
			_iPluginConfirmationPeer = other._iPluginConfirmationPeer;
			_iPluginConfirmationPeer->_vtbl->_addRef(_iPluginConfirmationPeer);
		}
	}

	~CEComICEHtmlPluginConfirmationPeerRef()
	{
		if (_iPluginConfirmationPeer)
		{
			ICEHtmlPluginConfirmationPeer* tmp = _iPluginConfirmationPeer;
			_iPluginConfirmationPeer = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlPluginConfirmationPeer* iPluginConfirmationPeer;
				void* _ptr;
			} uIntf;
			uIntf.iPluginConfirmationPeer = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlPluginConfirmationPeer, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iPluginConfirmationPeer)
				{
					ICEHtmlPluginConfirmationPeer* tmp = _iPluginConfirmationPeer;
					_iPluginConfirmationPeer = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iPluginConfirmationPeer = uIntf.iPluginConfirmationPeer;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPluginConfirmationPeer* object() const	{ return _iPluginConfirmationPeer; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlPluginConfirmationPeer* iOther)
	{
		if (_iPluginConfirmationPeer)
		{
			ICEHtmlPluginConfirmationPeer* tmp = _iPluginConfirmationPeer;
			_iPluginConfirmationPeer = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iPluginConfirmationPeer = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlPluginConfirmationPeer* detach()
	{
		ICEHtmlPluginConfirmationPeer* iIntf = _iPluginConfirmationPeer;
		_iPluginConfirmationPeer = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlPluginConfirmationPeer* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iPluginConfirmationPeer;
		if (_iPluginConfirmationPeer)
		{
			_iPluginConfirmationPeer->_vtbl->_addRef(_iPluginConfirmationPeer);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlPluginConfirmationPeer*() const	{ return _iPluginConfirmationPeer; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPluginConfirmationPeer& operator*() const	{ return *_iPluginConfirmationPeer; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iPluginConfirmationPeer == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlPluginConfirmationPeer* iOther) const	{ return (_iPluginConfirmationPeer != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlPluginConfirmationPeer* iOther) const	{ return (_iPluginConfirmationPeer == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlPluginConfirmationPeerRef& operator=(const CEComICEHtmlPluginConfirmationPeerRef& other)	{ return operator=(other._iPluginConfirmationPeer); }

	CEComICEHtmlPluginConfirmationPeerRef& operator=(const ICEHtmlPluginConfirmationPeer* iOther)
	{
		if (_iPluginConfirmationPeer != iOther)
		{
			if (_iPluginConfirmationPeer)
			{
				ICEHtmlPluginConfirmationPeer* tmp = _iPluginConfirmationPeer;
				_iPluginConfirmationPeer = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iPluginConfirmationPeer = const_cast<ICEHtmlPluginConfirmationPeer*>(iOther);
			if (_iPluginConfirmationPeer)
			{
				_iPluginConfirmationPeer->_vtbl->_addRef(_iPluginConfirmationPeer);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPluginConfirmationPeer** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlPluginConfirmationPeerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iPluginConfirmationPeer && "has a com object reference. clear first.");
		return & _iPluginConfirmationPeer; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlPluginConfirmationPeerRef& other)
	{
		bool result = false;
		if (_iPluginConfirmationPeer)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iPluginConfirmationPeer);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iPluginConfirmationPeer ? _iPluginConfirmationPeer->_vtbl->_queryInterface(_iPluginConfirmationPeer, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iPluginConfirmationPeer) { _iPluginConfirmationPeer->_vtbl->_addRef(_iPluginConfirmationPeer); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iPluginConfirmationPeer) { _iPluginConfirmationPeer->_vtbl->_release(_iPluginConfirmationPeer); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult replyConfirmPlugin(bool result, bool keepResult, void *const cData)	{ return _iPluginConfirmationPeer ? _iPluginConfirmationPeer->_vtbl->_replyConfirmPlugin(_iPluginConfirmationPeer, result, keepResult, cData) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlPluginConfirmationPeer* _iPluginConfirmationPeer;
};

/*! @}
 * end of CEComICEHtmlPluginConfirmationPeerRef
 */

#endif // __cplusplus

#endif
