///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlNavigationHistoryStore_h
#define ICEHtmlNavigationHistoryStore_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "URL.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlNavigationHistoryHandler ICEHtmlNavigationHistoryHandler
 * @{
 */

/*!
 * ID of ICEHtmlNavigationHistoryHandler
 */
#define CEComIID_ICEHtmlNavigationHistoryHandler 0xa8e4e3ea

/*!
 * ICEHtmlNavigationHistoryHandler
 */
typedef struct ICEHtmlNavigationHistoryHandler
{
	const struct ICEHtmlNavigationHistoryHandler_vtbl* _vtbl;
} ICEHtmlNavigationHistoryHandler;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iNavigationHistoryHandler	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlNavigationHistoryHandler_queryInterface) (ICEHtmlNavigationHistoryHandler* iNavigationHistoryHandler, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlNavigationHistoryHandler_addRef) (ICEHtmlNavigationHistoryHandler* iNavigationHistoryHandler);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlNavigationHistoryHandler_release) (ICEHtmlNavigationHistoryHandler* iNavigationHistoryHandler);

typedef CEHResult (*iCEHtmlNavigationHistoryHandler_receive) (ICEHtmlNavigationHistoryHandler* iNavigationHistoryHandler, struct ICEURL* iUrl, INT32 accessTime, struct ICEUString* iTitle);

/*!
 * V-table of ICEHtmlNavigationHistoryHandler
 */
struct ICEHtmlNavigationHistoryHandler_vtbl
{
	iCEHtmlNavigationHistoryHandler_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlNavigationHistoryHandler_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlNavigationHistoryHandler_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlNavigationHistoryHandler_receive	_receive;
};

/*! @}
 * end of ICEHtmlNavigationHistoryHandler
 */

/*! \defgroup ICEHtmlNavigationHistoryStore ICEHtmlNavigationHistoryStore
 * @{
 */

/*!
 * ID of ICEHtmlNavigationHistoryStore
 */
#define CEComIID_ICEHtmlNavigationHistoryStore 0xa4c7a653

/*!
 * ICEHtmlNavigationHistoryStore
 */
typedef struct ICEHtmlNavigationHistoryStore
{
	const struct ICEHtmlNavigationHistoryStore_vtbl* _vtbl;
} ICEHtmlNavigationHistoryStore;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iNavigationHistoryStore	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlNavigationHistoryStore_queryInterface) (ICEHtmlNavigationHistoryStore* iNavigationHistoryStore, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlNavigationHistoryStore_addRef) (ICEHtmlNavigationHistoryStore* iNavigationHistoryStore);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlNavigationHistoryStore_release) (ICEHtmlNavigationHistoryStore* iNavigationHistoryStore);

typedef CEHResult (*iCEHtmlNavigationHistoryStore_setMaxSize) (ICEHtmlNavigationHistoryStore* iNavigationHistoryStore, const UINT32 size);

typedef CEHResult (*iCEHtmlNavigationHistoryStore_getMaxSize) (ICEHtmlNavigationHistoryStore* iNavigationHistoryStore, UINT32 *const sizeOut);

typedef CEHResult (*iCEHtmlNavigationHistoryStore_enumerate) (ICEHtmlNavigationHistoryStore* iNavigationHistoryStore, struct ICEHtmlNavigationHistoryHandler* iHistoryHandler);

typedef CEHResult (*iCEHtmlNavigationHistoryStore_deleteAllHistory) (ICEHtmlNavigationHistoryStore* iNavigationHistoryStore);

typedef CEHResult (*iCEHtmlNavigationHistoryStore_deleteForURL) (ICEHtmlNavigationHistoryStore* iNavigationHistoryStore, struct ICEURL* iUrl);

/*!
 * V-table of ICEHtmlNavigationHistoryStore
 */
struct ICEHtmlNavigationHistoryStore_vtbl
{
	iCEHtmlNavigationHistoryStore_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlNavigationHistoryStore_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlNavigationHistoryStore_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlNavigationHistoryStore_setMaxSize	_setMaxSize;
	iCEHtmlNavigationHistoryStore_getMaxSize	_getMaxSize;
	iCEHtmlNavigationHistoryStore_enumerate	_enumerate;
	iCEHtmlNavigationHistoryStore_deleteAllHistory	_deleteAllHistory;
	iCEHtmlNavigationHistoryStore_deleteForURL	_deleteForURL;
};

/*! @}
 * end of ICEHtmlNavigationHistoryStore
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlNavigationHistoryHandlerRef CEComICEHtmlNavigationHistoryHandlerRef
 * @{
 */

class CEComICEHtmlNavigationHistoryHandlerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlNavigationHistoryHandlerRef() : _iNavigationHistoryHandler(0) {}
	CEComICEHtmlNavigationHistoryHandlerRef(ICEHtmlNavigationHistoryHandler* iOther) : _iNavigationHistoryHandler(0)
	{
		if (iOther)
		{
			_iNavigationHistoryHandler = iOther;
			_iNavigationHistoryHandler->_vtbl->_addRef(_iNavigationHistoryHandler);
		}
	}

	CEComICEHtmlNavigationHistoryHandlerRef(const CEComICEHtmlNavigationHistoryHandlerRef& other) : _iNavigationHistoryHandler(0)
	{
		if (other._iNavigationHistoryHandler)
		{
			_iNavigationHistoryHandler = other._iNavigationHistoryHandler;
			_iNavigationHistoryHandler->_vtbl->_addRef(_iNavigationHistoryHandler);
		}
	}

	~CEComICEHtmlNavigationHistoryHandlerRef()
	{
		if (_iNavigationHistoryHandler)
		{
			ICEHtmlNavigationHistoryHandler* tmp = _iNavigationHistoryHandler;
			_iNavigationHistoryHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlNavigationHistoryHandler* iNavigationHistoryHandler;
				void* _ptr;
			} uIntf;
			uIntf.iNavigationHistoryHandler = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlNavigationHistoryHandler, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iNavigationHistoryHandler)
				{
					ICEHtmlNavigationHistoryHandler* tmp = _iNavigationHistoryHandler;
					_iNavigationHistoryHandler = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iNavigationHistoryHandler = uIntf.iNavigationHistoryHandler;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlNavigationHistoryHandler* object() const	{ return _iNavigationHistoryHandler; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlNavigationHistoryHandler* iOther)
	{
		if (_iNavigationHistoryHandler)
		{
			ICEHtmlNavigationHistoryHandler* tmp = _iNavigationHistoryHandler;
			_iNavigationHistoryHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iNavigationHistoryHandler = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlNavigationHistoryHandler* detach()
	{
		ICEHtmlNavigationHistoryHandler* iIntf = _iNavigationHistoryHandler;
		_iNavigationHistoryHandler = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlNavigationHistoryHandler* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iNavigationHistoryHandler;
		if (_iNavigationHistoryHandler)
		{
			_iNavigationHistoryHandler->_vtbl->_addRef(_iNavigationHistoryHandler);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlNavigationHistoryHandler*() const	{ return _iNavigationHistoryHandler; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlNavigationHistoryHandler& operator*() const	{ return *_iNavigationHistoryHandler; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iNavigationHistoryHandler == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlNavigationHistoryHandler* iOther) const	{ return (_iNavigationHistoryHandler != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlNavigationHistoryHandler* iOther) const	{ return (_iNavigationHistoryHandler == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlNavigationHistoryHandlerRef& operator=(const CEComICEHtmlNavigationHistoryHandlerRef& other)	{ return operator=(other._iNavigationHistoryHandler); }

	CEComICEHtmlNavigationHistoryHandlerRef& operator=(const ICEHtmlNavigationHistoryHandler* iOther)
	{
		if (_iNavigationHistoryHandler != iOther)
		{
			if (_iNavigationHistoryHandler)
			{
				ICEHtmlNavigationHistoryHandler* tmp = _iNavigationHistoryHandler;
				_iNavigationHistoryHandler = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iNavigationHistoryHandler = const_cast<ICEHtmlNavigationHistoryHandler*>(iOther);
			if (_iNavigationHistoryHandler)
			{
				_iNavigationHistoryHandler->_vtbl->_addRef(_iNavigationHistoryHandler);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlNavigationHistoryHandler** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlNavigationHistoryHandlerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iNavigationHistoryHandler && "has a com object reference. clear first.");
		return & _iNavigationHistoryHandler; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlNavigationHistoryHandlerRef& other)
	{
		bool result = false;
		if (_iNavigationHistoryHandler)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iNavigationHistoryHandler);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iNavigationHistoryHandler ? _iNavigationHistoryHandler->_vtbl->_queryInterface(_iNavigationHistoryHandler, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iNavigationHistoryHandler) { _iNavigationHistoryHandler->_vtbl->_addRef(_iNavigationHistoryHandler); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iNavigationHistoryHandler) { _iNavigationHistoryHandler->_vtbl->_release(_iNavigationHistoryHandler); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult receive(struct ICEURL* iUrl, INT32 accessTime, struct ICEUString* iTitle)	{ return _iNavigationHistoryHandler ? _iNavigationHistoryHandler->_vtbl->_receive(_iNavigationHistoryHandler, iUrl, accessTime, iTitle) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlNavigationHistoryHandler* _iNavigationHistoryHandler;
};

/*! @}
 * end of CEComICEHtmlNavigationHistoryHandlerRef
 */

/*! \defgroup CEComICEHtmlNavigationHistoryStoreRef CEComICEHtmlNavigationHistoryStoreRef
 * @{
 */

class CEComICEHtmlNavigationHistoryStoreRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlNavigationHistoryStoreRef() : _iNavigationHistoryStore(0) {}
	CEComICEHtmlNavigationHistoryStoreRef(ICEHtmlNavigationHistoryStore* iOther) : _iNavigationHistoryStore(0)
	{
		if (iOther)
		{
			_iNavigationHistoryStore = iOther;
			_iNavigationHistoryStore->_vtbl->_addRef(_iNavigationHistoryStore);
		}
	}

	CEComICEHtmlNavigationHistoryStoreRef(const CEComICEHtmlNavigationHistoryStoreRef& other) : _iNavigationHistoryStore(0)
	{
		if (other._iNavigationHistoryStore)
		{
			_iNavigationHistoryStore = other._iNavigationHistoryStore;
			_iNavigationHistoryStore->_vtbl->_addRef(_iNavigationHistoryStore);
		}
	}

	~CEComICEHtmlNavigationHistoryStoreRef()
	{
		if (_iNavigationHistoryStore)
		{
			ICEHtmlNavigationHistoryStore* tmp = _iNavigationHistoryStore;
			_iNavigationHistoryStore = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlNavigationHistoryStore* iNavigationHistoryStore;
				void* _ptr;
			} uIntf;
			uIntf.iNavigationHistoryStore = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlNavigationHistoryStore, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iNavigationHistoryStore)
				{
					ICEHtmlNavigationHistoryStore* tmp = _iNavigationHistoryStore;
					_iNavigationHistoryStore = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iNavigationHistoryStore = uIntf.iNavigationHistoryStore;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlNavigationHistoryStore* object() const	{ return _iNavigationHistoryStore; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlNavigationHistoryStore* iOther)
	{
		if (_iNavigationHistoryStore)
		{
			ICEHtmlNavigationHistoryStore* tmp = _iNavigationHistoryStore;
			_iNavigationHistoryStore = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iNavigationHistoryStore = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlNavigationHistoryStore* detach()
	{
		ICEHtmlNavigationHistoryStore* iIntf = _iNavigationHistoryStore;
		_iNavigationHistoryStore = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlNavigationHistoryStore* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iNavigationHistoryStore;
		if (_iNavigationHistoryStore)
		{
			_iNavigationHistoryStore->_vtbl->_addRef(_iNavigationHistoryStore);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlNavigationHistoryStore*() const	{ return _iNavigationHistoryStore; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlNavigationHistoryStore& operator*() const	{ return *_iNavigationHistoryStore; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iNavigationHistoryStore == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlNavigationHistoryStore* iOther) const	{ return (_iNavigationHistoryStore != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlNavigationHistoryStore* iOther) const	{ return (_iNavigationHistoryStore == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlNavigationHistoryStoreRef& operator=(const CEComICEHtmlNavigationHistoryStoreRef& other)	{ return operator=(other._iNavigationHistoryStore); }

	CEComICEHtmlNavigationHistoryStoreRef& operator=(const ICEHtmlNavigationHistoryStore* iOther)
	{
		if (_iNavigationHistoryStore != iOther)
		{
			if (_iNavigationHistoryStore)
			{
				ICEHtmlNavigationHistoryStore* tmp = _iNavigationHistoryStore;
				_iNavigationHistoryStore = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iNavigationHistoryStore = const_cast<ICEHtmlNavigationHistoryStore*>(iOther);
			if (_iNavigationHistoryStore)
			{
				_iNavigationHistoryStore->_vtbl->_addRef(_iNavigationHistoryStore);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlNavigationHistoryStore** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlNavigationHistoryStoreRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iNavigationHistoryStore && "has a com object reference. clear first.");
		return & _iNavigationHistoryStore; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlNavigationHistoryStoreRef& other)
	{
		bool result = false;
		if (_iNavigationHistoryStore)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iNavigationHistoryStore);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iNavigationHistoryStore ? _iNavigationHistoryStore->_vtbl->_queryInterface(_iNavigationHistoryStore, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iNavigationHistoryStore) { _iNavigationHistoryStore->_vtbl->_addRef(_iNavigationHistoryStore); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iNavigationHistoryStore) { _iNavigationHistoryStore->_vtbl->_release(_iNavigationHistoryStore); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setMaxSize(const UINT32 size)	{ return _iNavigationHistoryStore ? _iNavigationHistoryStore->_vtbl->_setMaxSize(_iNavigationHistoryStore, size) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getMaxSize(UINT32 *const sizeOut)	{ return _iNavigationHistoryStore ? _iNavigationHistoryStore->_vtbl->_getMaxSize(_iNavigationHistoryStore, sizeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult enumerate(struct ICEHtmlNavigationHistoryHandler* iHistoryHandler)	{ return _iNavigationHistoryStore ? _iNavigationHistoryStore->_vtbl->_enumerate(_iNavigationHistoryStore, iHistoryHandler) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult deleteAllHistory()	{ return _iNavigationHistoryStore ? _iNavigationHistoryStore->_vtbl->_deleteAllHistory(_iNavigationHistoryStore) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult deleteForURL(struct ICEURL* iUrl)	{ return _iNavigationHistoryStore ? _iNavigationHistoryStore->_vtbl->_deleteForURL(_iNavigationHistoryStore, iUrl) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlNavigationHistoryStore* _iNavigationHistoryStore;
};

/*! @}
 * end of CEComICEHtmlNavigationHistoryStoreRef
 */

#endif // __cplusplus

#endif
