///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlElementEventHandler_h
#define ICEHtmlElementEventHandler_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "ICEHtmlWindowWidget.h"
#include "ICEHtmlElement.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
    CEHtmlEventStage_Unknown = 0,
    CEHtmlEventStage_Occurance = 1, // may on UI thread
    CEHtmlEventStage_Dispatching= 2, // must on HTML thread
    CEHtmlEventStage_Handling = 3,
    CEHtmlEventStage_Handled = 4,
    CEHtmlEventStage_Dispatched = 5,
    CEHtmlEventStage_NumOfStages
} CEHtmlEventStage;

typedef enum
{
    CEHtmlLinkType_None = 0,

    // w3c standard
    CEHtmlLinkType_Alternate = 1 << 0,
    CEHtmlLinkType_Stylesheet = 1 << 1,
    CEHtmlLinkType_Start = 1 << 2,
    CEHtmlLinkType_Next = 1 << 3,
    CEHtmlLinkType_Prev = 1 << 4,
    CEHtmlLinkType_Contents = 1 << 5,
    CEHtmlLinkType_Index = 1 << 6,
    CEHtmlLinkType_Glossary = 1 << 7,
    CEHtmlLinkType_Copyright = 1 << 8,
    CEHtmlLinkType_Chapter = 1 << 9,
    CEHtmlLinkType_Section = 1 << 10,
    CEHtmlLinkType_Subsection = 1 << 11,
    CEHtmlLinkType_Appendix = 1 << 12,
    CEHtmlLinkType_Help = 1 << 13,
    CEHtmlLinkType_Bookmark = 1 << 14,

    // non-standard
    CEHtmlLinkType_Icon = 1 << 15,
} CEHtmlLinkType;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlElementEventConfiguration ICEHtmlElementEventConfiguration
 * @{
 */

/*!
 * ID of ICEHtmlElementEventConfiguration
 */
#define CEComIID_ICEHtmlElementEventConfiguration 0xf65b8c0e


/*!
 * ICEHtmlElementEventConfiguration
 */
typedef struct ICEHtmlElementEventConfiguration
{
	const struct ICEHtmlElementEventConfiguration_vtbl* _vtbl;
} ICEHtmlElementEventConfiguration;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iElementEventConfiguration	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlElementEventConfiguration_queryInterface) (ICEHtmlElementEventConfiguration* iElementEventConfiguration, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlElementEventConfiguration_addRef) (ICEHtmlElementEventConfiguration* iElementEventConfiguration);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlElementEventConfiguration_release) (ICEHtmlElementEventConfiguration* iElementEventConfiguration);

typedef CEHResult (*iCEHtmlElementEventConfiguration_setHtmlEventMask) (ICEHtmlElementEventConfiguration* iElementEventConfiguration, const CEHtmlEventStage stage, const CEHtmlEventId eventId, bool enable);

typedef CEHResult (*iCEHtmlElementEventConfiguration_getHtmlEventMask) (ICEHtmlElementEventConfiguration* iElementEventConfiguration, const CEHtmlEventStage stage, const CEHtmlEventId eventId, bool *const enableOut);

typedef CEHResult (*iCEHtmlElementEventConfiguration_setLinkMask) (ICEHtmlElementEventConfiguration* iElementEventConfiguration, const UINT32 linkTypeMask, bool enable);

typedef CEHResult (*iCEHtmlElementEventConfiguration_getLinkMask) (ICEHtmlElementEventConfiguration* iElementEventConfiguration, const UINT32 linkTypeMask, bool *const enableOut);

/*!
 * V-table of ICEHtmlElementEventConfiguration
 */
struct ICEHtmlElementEventConfiguration_vtbl
{
	iCEHtmlElementEventConfiguration_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlElementEventConfiguration_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlElementEventConfiguration_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlElementEventConfiguration_setHtmlEventMask	_setHtmlEventMask;
	iCEHtmlElementEventConfiguration_getHtmlEventMask	_getHtmlEventMask;
	iCEHtmlElementEventConfiguration_setLinkMask	_setLinkMask;
	iCEHtmlElementEventConfiguration_getLinkMask	_getLinkMask;
};

/*! @}
 * end of ICEHtmlElementEventConfiguration
 */

/*! \defgroup ICEHtmlElementEventHandler ICEHtmlElementEventHandler
 * @{
 */

/*!
 * ID of ICEHtmlElementEventHandler
 */
#define CEComIID_ICEHtmlElementEventHandler 0x6f0a8b8c


/*!
 * ICEHtmlElementEventHandler
 */
typedef struct ICEHtmlElementEventHandler
{
	const struct ICEHtmlElementEventHandler_vtbl* _vtbl;
} ICEHtmlElementEventHandler;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iElementEventHandler	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlElementEventHandler_queryInterface) (ICEHtmlElementEventHandler* iElementEventHandler, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlElementEventHandler_addRef) (ICEHtmlElementEventHandler* iElementEventHandler);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlElementEventHandler_release) (ICEHtmlElementEventHandler* iElementEventHandler);

typedef CEHResult (*iCEHtmlElementEventHandler_onHtmlEvent) (ICEHtmlElementEventHandler* iElementEventHandler, struct ICEHtmlElementBaseProxy* iElement, const CEHtmlEventStage stage, const CEHtmlEventId eventId, bool* resultOut);

typedef CEHResult (*iCEHtmlElementEventHandler_onLinkAvailable) (ICEHtmlElementEventHandler* iElementEventHandler, struct ICEHtmlElementBaseProxy* iElement, const UINT32 relTypeMask, const UINT32 revTypeMask, struct ICEUString* iHref, struct ICEUString* iType);

/*!
 * V-table of ICEHtmlElementEventHandler
 */
struct ICEHtmlElementEventHandler_vtbl
{
	iCEHtmlElementEventHandler_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlElementEventHandler_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlElementEventHandler_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlElementEventHandler_onHtmlEvent	_onHtmlEvent;
	iCEHtmlElementEventHandler_onLinkAvailable	_onLinkAvailable;
};

/*! @}
 * end of ICEHtmlElementEventHandler
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlElementEventConfigurationRef CEComICEHtmlElementEventConfigurationRef
 * @{
 */

class CEComICEHtmlElementEventConfigurationRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlElementEventConfigurationRef() : _iElementEventConfiguration(0) {}
	CEComICEHtmlElementEventConfigurationRef(ICEHtmlElementEventConfiguration* iOther) : _iElementEventConfiguration(0)
	{
		if (iOther)
		{
			_iElementEventConfiguration = iOther;
			_iElementEventConfiguration->_vtbl->_addRef(_iElementEventConfiguration);
		}
	}

	CEComICEHtmlElementEventConfigurationRef(const CEComICEHtmlElementEventConfigurationRef& other) : _iElementEventConfiguration(0)
	{
		if (other._iElementEventConfiguration)
		{
			_iElementEventConfiguration = other._iElementEventConfiguration;
			_iElementEventConfiguration->_vtbl->_addRef(_iElementEventConfiguration);
		}
	}

	~CEComICEHtmlElementEventConfigurationRef()
	{
		if (_iElementEventConfiguration)
		{
			ICEHtmlElementEventConfiguration* tmp = _iElementEventConfiguration;
			_iElementEventConfiguration = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlElementEventConfiguration* iElementEventConfiguration;
				void* _ptr;
			} uIntf;
			uIntf.iElementEventConfiguration = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlElementEventConfiguration, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iElementEventConfiguration)
				{
					ICEHtmlElementEventConfiguration* tmp = _iElementEventConfiguration;
					_iElementEventConfiguration = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iElementEventConfiguration = uIntf.iElementEventConfiguration;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlElementEventConfiguration* object() const	{ return _iElementEventConfiguration; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlElementEventConfiguration* iOther)
	{
		if (_iElementEventConfiguration)
		{
			ICEHtmlElementEventConfiguration* tmp = _iElementEventConfiguration;
			_iElementEventConfiguration = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iElementEventConfiguration = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlElementEventConfiguration* detach()
	{
		ICEHtmlElementEventConfiguration* iIntf = _iElementEventConfiguration;
		_iElementEventConfiguration = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlElementEventConfiguration* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iElementEventConfiguration;
		if (_iElementEventConfiguration)
		{
			_iElementEventConfiguration->_vtbl->_addRef(_iElementEventConfiguration);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlElementEventConfiguration*() const	{ return _iElementEventConfiguration; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlElementEventConfiguration& operator*() const	{ return *_iElementEventConfiguration; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iElementEventConfiguration == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlElementEventConfiguration* iOther) const	{ return (_iElementEventConfiguration != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlElementEventConfiguration* iOther) const	{ return (_iElementEventConfiguration == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlElementEventConfigurationRef& operator=(const CEComICEHtmlElementEventConfigurationRef& other)	{ return operator=(other._iElementEventConfiguration); }

	CEComICEHtmlElementEventConfigurationRef& operator=(const ICEHtmlElementEventConfiguration* iOther)
	{
		if (_iElementEventConfiguration != iOther)
		{
			if (_iElementEventConfiguration)
			{
				ICEHtmlElementEventConfiguration* tmp = _iElementEventConfiguration;
				_iElementEventConfiguration = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iElementEventConfiguration = const_cast<ICEHtmlElementEventConfiguration*>(iOther);
			if (_iElementEventConfiguration)
			{
				_iElementEventConfiguration->_vtbl->_addRef(_iElementEventConfiguration);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlElementEventConfiguration** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlElementEventConfigurationRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iElementEventConfiguration && "has a com object reference. clear first.");
		return & _iElementEventConfiguration; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlElementEventConfigurationRef& other)
	{
		bool result = false;
		if (_iElementEventConfiguration)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iElementEventConfiguration);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iElementEventConfiguration ? _iElementEventConfiguration->_vtbl->_queryInterface(_iElementEventConfiguration, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iElementEventConfiguration) { _iElementEventConfiguration->_vtbl->_addRef(_iElementEventConfiguration); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iElementEventConfiguration) { _iElementEventConfiguration->_vtbl->_release(_iElementEventConfiguration); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setHtmlEventMask(const CEHtmlEventStage stage, const CEHtmlEventId eventId, bool enable)	{ return _iElementEventConfiguration ? _iElementEventConfiguration->_vtbl->_setHtmlEventMask(_iElementEventConfiguration, stage, eventId, enable) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getHtmlEventMask(const CEHtmlEventStage stage, const CEHtmlEventId eventId, bool *const enableOut)	{ return _iElementEventConfiguration ? _iElementEventConfiguration->_vtbl->_getHtmlEventMask(_iElementEventConfiguration, stage, eventId, enableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setLinkMask(const UINT32 linkTypeMask, bool enable)	{ return _iElementEventConfiguration ? _iElementEventConfiguration->_vtbl->_setLinkMask(_iElementEventConfiguration, linkTypeMask, enable) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getLinkMask(const UINT32 linkTypeMask, bool *const enableOut)	{ return _iElementEventConfiguration ? _iElementEventConfiguration->_vtbl->_getLinkMask(_iElementEventConfiguration, linkTypeMask, enableOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlElementEventConfiguration* _iElementEventConfiguration;
};

/*! @}
 * end of CEComICEHtmlElementEventConfigurationRef
 */

/*! \defgroup CEComICEHtmlElementEventHandlerRef CEComICEHtmlElementEventHandlerRef
 * @{
 */

class CEComICEHtmlElementEventHandlerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlElementEventHandlerRef() : _iElementEventHandler(0) {}
	CEComICEHtmlElementEventHandlerRef(ICEHtmlElementEventHandler* iOther) : _iElementEventHandler(0)
	{
		if (iOther)
		{
			_iElementEventHandler = iOther;
			_iElementEventHandler->_vtbl->_addRef(_iElementEventHandler);
		}
	}

	CEComICEHtmlElementEventHandlerRef(const CEComICEHtmlElementEventHandlerRef& other) : _iElementEventHandler(0)
	{
		if (other._iElementEventHandler)
		{
			_iElementEventHandler = other._iElementEventHandler;
			_iElementEventHandler->_vtbl->_addRef(_iElementEventHandler);
		}
	}

	~CEComICEHtmlElementEventHandlerRef()
	{
		if (_iElementEventHandler)
		{
			ICEHtmlElementEventHandler* tmp = _iElementEventHandler;
			_iElementEventHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlElementEventHandler* iElementEventHandler;
				void* _ptr;
			} uIntf;
			uIntf.iElementEventHandler = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlElementEventHandler, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iElementEventHandler)
				{
					ICEHtmlElementEventHandler* tmp = _iElementEventHandler;
					_iElementEventHandler = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iElementEventHandler = uIntf.iElementEventHandler;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlElementEventHandler* object() const	{ return _iElementEventHandler; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlElementEventHandler* iOther)
	{
		if (_iElementEventHandler)
		{
			ICEHtmlElementEventHandler* tmp = _iElementEventHandler;
			_iElementEventHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iElementEventHandler = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlElementEventHandler* detach()
	{
		ICEHtmlElementEventHandler* iIntf = _iElementEventHandler;
		_iElementEventHandler = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlElementEventHandler* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iElementEventHandler;
		if (_iElementEventHandler)
		{
			_iElementEventHandler->_vtbl->_addRef(_iElementEventHandler);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlElementEventHandler*() const	{ return _iElementEventHandler; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlElementEventHandler& operator*() const	{ return *_iElementEventHandler; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iElementEventHandler == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlElementEventHandler* iOther) const	{ return (_iElementEventHandler != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlElementEventHandler* iOther) const	{ return (_iElementEventHandler == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlElementEventHandlerRef& operator=(const CEComICEHtmlElementEventHandlerRef& other)	{ return operator=(other._iElementEventHandler); }

	CEComICEHtmlElementEventHandlerRef& operator=(const ICEHtmlElementEventHandler* iOther)
	{
		if (_iElementEventHandler != iOther)
		{
			if (_iElementEventHandler)
			{
				ICEHtmlElementEventHandler* tmp = _iElementEventHandler;
				_iElementEventHandler = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iElementEventHandler = const_cast<ICEHtmlElementEventHandler*>(iOther);
			if (_iElementEventHandler)
			{
				_iElementEventHandler->_vtbl->_addRef(_iElementEventHandler);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlElementEventHandler** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlElementEventHandlerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iElementEventHandler && "has a com object reference. clear first.");
		return & _iElementEventHandler; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlElementEventHandlerRef& other)
	{
		bool result = false;
		if (_iElementEventHandler)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iElementEventHandler);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iElementEventHandler ? _iElementEventHandler->_vtbl->_queryInterface(_iElementEventHandler, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iElementEventHandler) { _iElementEventHandler->_vtbl->_addRef(_iElementEventHandler); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iElementEventHandler) { _iElementEventHandler->_vtbl->_release(_iElementEventHandler); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult onHtmlEvent(struct ICEHtmlElementBaseProxy* iElement, const CEHtmlEventStage stage, const CEHtmlEventId eventId, bool* resultOut)	{ return _iElementEventHandler ? _iElementEventHandler->_vtbl->_onHtmlEvent(_iElementEventHandler, iElement, stage, eventId, resultOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult onLinkAvailable(struct ICEHtmlElementBaseProxy* iElement, const UINT32 relTypeMask, const UINT32 revTypeMask, struct ICEUString* iHref, struct ICEUString* iType)	{ return _iElementEventHandler ? _iElementEventHandler->_vtbl->_onLinkAvailable(_iElementEventHandler, iElement, relTypeMask, revTypeMask, iHref, iType) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlElementEventHandler* _iElementEventHandler;
};

/*! @}
 * end of CEComICEHtmlElementEventHandlerRef
 */

#endif // __cplusplus

#endif
