///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlElement_h
#define ICEHtmlElement_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "ICEUIGraphicsContext.h"
#include "ICEUIFont.h"
#include "URL.h"
#include "ICEScriptable.h"
#include "CEUITypes.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------

struct ICEHtmlPluginInstance;
struct ICEHtmlDocument;

//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
    CEHtmlShutdownType_Stop,
    CEHtmlShutdownType_Deactivate,
    CEHtmlShutdownType_Destuct,
    CEHtmlShutdownType_Detach,
} CEHtmlShutdownType;

typedef enum
{
	CEHtmlElementId__Unknown = 0,

	CEHtmlElementId_A = 1,
	CEHtmlElementId_ACRONYM = 2, 
	CEHtmlElementId_ADDRESS = 3,
	CEHtmlElementId_APPLET = 4,
	CEHtmlElementId_AREA = 5,
	CEHtmlElementId_B = 6,
	CEHtmlElementId_BASE = 7,
	CEHtmlElementId_BASEFONT = 8,
	CEHtmlElementId_BGSOUND = 9,
	CEHtmlElementId_BIG = 10,
	CEHtmlElementId_BLINK = 11,  
	CEHtmlElementId_BLOCKQUOTE = 12,
	CEHtmlElementId_BODY = 13,
	CEHtmlElementId_BR = 14,
	CEHtmlElementId_BUTTON = 15, 
	CEHtmlElementId_CAPTION = 16,
	CEHtmlElementId_CENTER = 17,
	CEHtmlElementId_CITE = 18,
	CEHtmlElementId_CODE = 19,
	CEHtmlElementId_COL = 20,
	CEHtmlElementId_COLGROUP = 21,
	CEHtmlElementId_COMMENT = 22,
	CEHtmlElementId_DD = 23,
	CEHtmlElementId_DEL = 24,
	CEHtmlElementId_DFN = 25,
	CEHtmlElementId_DIR = 26,
	CEHtmlElementId_DIV = 27,
	CEHtmlElementId_DL = 28,
	CEHtmlElementId_DT = 29,
	CEHtmlElementId_EM = 30,
	CEHtmlElementId_EMBED = 31, 
	CEHtmlElementId_EVENT = 32, 
	CEHtmlElementId_FIELDSET = 33, 
	CEHtmlElementId_FONT = 34,
	CEHtmlElementId_FORM = 35,
	CEHtmlElementId_FRAME = 36,
	CEHtmlElementId_FRAMESET = 37,
	CEHtmlElementId_H1 = 38,
	CEHtmlElementId_H2 = 39,
	CEHtmlElementId_H3 = 40,
	CEHtmlElementId_H4 = 41,
	CEHtmlElementId_H5 = 42,
	CEHtmlElementId_H6 = 43,
	CEHtmlElementId_HEAD = 44,
	CEHtmlElementId_HR = 45,
	CEHtmlElementId_HTML = 46,
	CEHtmlElementId_I = 47,
	CEHtmlElementId_IFRAME = 48,
	CEHtmlElementId_IMG = 49,
	CEHtmlElementId_INPUT = 50,
	CEHtmlElementId_INS = 51,
	CEHtmlElementId_ISINDEX = 52,
	CEHtmlElementId_KBD = 53,
	CEHtmlElementId_LABEL = 54,
	CEHtmlElementId_LEGEND = 55,  
	CEHtmlElementId_LI = 56,
	CEHtmlElementId_LINK = 57,
	CEHtmlElementId_LISTING = 58,
	CEHtmlElementId_MAP = 59,
	CEHtmlElementId_MARQUEE = 60, 
	CEHtmlElementId_MENU = 61,
	CEHtmlElementId_META = 62,
	CEHtmlElementId_NOBR = 63,
	CEHtmlElementId_NOEMBED = 64,  
	CEHtmlElementId_NOFRAMES = 65,
	CEHtmlElementId_NOSCRIPT = 66, 
	CEHtmlElementId_OBJECT = 67, 
	CEHtmlElementId_OL = 68,
	CEHtmlElementId_OPTION = 69,
	CEHtmlElementId_P = 70,
	CEHtmlElementId_PARAM = 71,
	CEHtmlElementId_PLAINTEXT = 72,
	CEHtmlElementId_PRE = 73,
	CEHtmlElementId_Q = 74, 
	CEHtmlElementId_S = 75,
	CEHtmlElementId_SAMP = 76,
	CEHtmlElementId_SCRIPT = 77,
	CEHtmlElementId_SELECT = 78,
	CEHtmlElementId_SMALL = 79,
	CEHtmlElementId_SPAN = 80,
	CEHtmlElementId_STRIKE = 81,
	CEHtmlElementId_STRONG = 82,
	CEHtmlElementId_STYLE = 83,
	CEHtmlElementId_SUB = 84,
	CEHtmlElementId_SUP = 85,
	CEHtmlElementId_TABLE = 86,
	CEHtmlElementId_TBODY = 87,
	CEHtmlElementId_TD = 88,
	CEHtmlElementId_TEXTAREA = 89,
	CEHtmlElementId_TFOOT = 90,
	CEHtmlElementId_TH = 91,
	CEHtmlElementId_THEAD = 92,
	CEHtmlElementId_TITLE = 93,
	CEHtmlElementId_TR = 94,
	CEHtmlElementId_TT = 95,
	CEHtmlElementId_U = 96,
	CEHtmlElementId_UL = 97,
	CEHtmlElementId_VAR = 98,
	CEHtmlElementId_WBR = 99,
	CEHtmlElementId_XMP = 100,

	// Bug 13918 2008.3.21
	CEHtmlElementId_BDO = 101,
} CEHtmlElementId;


/*!
 * CEHtmlAttributeId
 */
typedef enum
{
	CEHtmlAttributeId__Unknown = 0,
	CEHtmlAttributeId_BLOCK_ALIGN = 1,
	CEHtmlAttributeId_TABLE_ALIGN = 2,
	CEHtmlAttributeId_INLINE_ALIGN = 3,
	CEHtmlAttributeId_CAPTION_ALIGN = 4,
	CEHtmlAttributeId_WIDTH = 5,
	CEHtmlAttributeId_HEIGHT = 6,
	CEHtmlAttributeId_SIZE = 7,
	CEHtmlAttributeId_HRSIZE = 8,
	CEHtmlAttributeId_FONTSIZE = 9,
	CEHtmlAttributeId_HREF = 10,
	CEHtmlAttributeId_NAME = 11,
	CEHtmlAttributeId_SRC = 12,
	CEHtmlAttributeId_IMAGE_BORDER = 13,
	CEHtmlAttributeId_TABLE_BORDER = 14,
	CEHtmlAttributeId_ALT = 15,
	CEHtmlAttributeId_TARGET = 16,
	CEHtmlAttributeId_TITLE = 17,
	CEHtmlAttributeId_REL = 18,
	CEHtmlAttributeId_REV = 19,
	CEHtmlAttributeId_HSPACE = 20,
	CEHtmlAttributeId_VSPACE = 21,
	CEHtmlAttributeId_CODE = 22,
	CEHtmlAttributeId_CODEBASE = 23,
	CEHtmlAttributeId_FACE = 24,
	CEHtmlAttributeId_COLOR = 25,
	CEHtmlAttributeId_BGCOLOR = 26,
	CEHtmlAttributeId_BACKGROUND = 27,
	CEHtmlAttributeId_NOWRAP = 28,
	CEHtmlAttributeId_AUTOCOMPLETE = 29,
	CEHtmlAttributeId_LOWSRC = 30,
	CEHtmlAttributeId_DYNSRC = 31,
	CEHtmlAttributeId_LOOP = 32,
	CEHtmlAttributeId_VALUE = 33,
	CEHtmlAttributeId_READONLY = 34,
	CEHtmlAttributeId_DISABLED = 35,
	CEHtmlAttributeId_FOR = 36,
	CEHtmlAttributeId_MEDIA = 37,
	CEHtmlAttributeId_WRAP = 38,
	CEHtmlAttributeId_ROWS = 39,
	CEHtmlAttributeId_COLS = 40,
	CEHtmlAttributeId_BORDERCOLOR = 41,
	CEHtmlAttributeId_BORDERCOLORLIGHT = 42,
	CEHtmlAttributeId_BORDERCOLORDARK = 43,
	CEHtmlAttributeId_VALIGN = 44,
	CEHtmlAttributeId_LIST_TYPE = 45,
	CEHtmlAttributeId_CLASS = 46,
	CEHtmlAttributeId_ID = 47,
	CEHtmlAttributeId_STYLE = 48,
	CEHtmlAttributeId_TABINDEX = 49,
	CEHtmlAttributeId_TEXT = 50,
	CEHtmlAttributeId_LINK = 51,
	CEHtmlAttributeId_VLINK = 52,
	CEHtmlAttributeId_ALINK = 53,
	CEHtmlAttributeId_BOTTOMMARGIN = 54,
	CEHtmlAttributeId_LEFTMARGIN = 55,
	CEHtmlAttributeId_RIGHTMARGIN = 56,
	CEHtmlAttributeId_TOPMARGIN = 57,
	CEHtmlAttributeId_BGPROPERTIES = 58,
	CEHtmlAttributeId_SCROLL = 59,
	CEHtmlAttributeId_NOSHADE = 60,
	CEHtmlAttributeId_CLEAR = 61,
	CEHtmlAttributeId_METHODS = 62,
	CEHtmlAttributeId_URN = 63,
	CEHtmlAttributeId_USEMAP = 64,
	CEHtmlAttributeId_ISMAP = 65,
	CEHtmlAttributeId_COMPACT = 66,
	CEHtmlAttributeId_START = 67,
	CEHtmlAttributeId_LI_VALUE = 68,
	CEHtmlAttributeId_CELLSPACING = 69,
	CEHtmlAttributeId_CELLPADDING = 70,
	CEHtmlAttributeId_RULES = 71,
	CEHtmlAttributeId_FRAME = 72,
	CEHtmlAttributeId_DATAPAGESIZE = 73,
	CEHtmlAttributeId_ROWSPAN = 74,
	CEHtmlAttributeId_COLSPAN = 75,
	CEHtmlAttributeId_SHAPE = 76,
	CEHtmlAttributeId_COORDS = 77,
	CEHtmlAttributeId_NOHREF = 78,
	CEHtmlAttributeId_ACTION = 79,
	CEHtmlAttributeId_METHOD = 80,
	CEHtmlAttributeId_ENCTYPE = 81,
	CEHtmlAttributeId_PROMPT = 82,
	CEHtmlAttributeId_HTTPEQUIV = 83,
	CEHtmlAttributeId_CONTENT = 84,
	CEHtmlAttributeId_CHARSET = 85,
	CEHtmlAttributeId_MULTIPLE = 86,
	CEHtmlAttributeId_SELECTED = 87,
	CEHtmlAttributeId_INPUT_TYPE = 88,
	CEHtmlAttributeId_CHECKED = 89,
	CEHtmlAttributeId_MAXLENGTH = 90,
	CEHtmlAttributeId_ACCEPT = 91,
	CEHtmlAttributeId_BUTTON_TYPE = 92,
	CEHtmlAttributeId_TEXTCONTENT = 93,
	CEHtmlAttributeId_SPAN = 94,
	CEHtmlAttributeId_XMLNS = 95,
	CEHtmlAttributeId_STYLE_TYPE_obsolute = 96,
	CEHtmlAttributeId_LANGUAGE = 97,
	CEHtmlAttributeId_DEFER = 98,
	CEHtmlAttributeId_EVENT = 99,
	CEHtmlAttributeId_FRAMESET_COLS = 100,
	CEHtmlAttributeId_FRAMESET_ROWS = 101,
	CEHtmlAttributeId_FRAMEBORDER = 102,
	CEHtmlAttributeId_FRAMESPACING = 103,
	CEHtmlAttributeId_MARGINWIDTH = 104,
	CEHtmlAttributeId_MARGINHEIGHT = 105,
	CEHtmlAttributeId_SCROLLING = 106,
	CEHtmlAttributeId_NORESIZE = 107,
	CEHtmlAttributeId_DECLARE = 108,
	CEHtmlAttributeId_CLASSID = 109,
	CEHtmlAttributeId_DATA = 110,
	CEHtmlAttributeId_OBJECT_DATA_TYPE = 111,
	CEHtmlAttributeId_CODETYPE = 112,
	CEHtmlAttributeId_ARCHIVE = 113,
	CEHtmlAttributeId_STANDBY = 114,
	CEHtmlAttributeId_PARAM_TYPE = 115,
	CEHtmlAttributeId_PARAM_VALUETYPE = 116,
	CEHtmlAttributeId_PLUGINPAGE = 117,
	CEHtmlAttributeId_PLUGINURL = 118,
	CEHtmlAttributeId_ONBEFOREUNLOAD = 119,
	CEHtmlAttributeId_ONBLUR = 120,
	CEHtmlAttributeId_ONCHANGE = 121,
	CEHtmlAttributeId_ONCLICK = 122,
	CEHtmlAttributeId_ONDBLCLICK = 123,
	CEHtmlAttributeId_ONERROR = 124,
	CEHtmlAttributeId_ONFOCUS = 125,
	CEHtmlAttributeId_ONKEYDOWN = 126,
	CEHtmlAttributeId_ONKEYPRESS = 127,
	CEHtmlAttributeId_ONKEYUP = 128,
	CEHtmlAttributeId_ONLOAD = 129,
	CEHtmlAttributeId_ONMOUSEDOWN = 130,
	CEHtmlAttributeId_ONMOUSEMOVE = 131,
	CEHtmlAttributeId_ONMOUSEOUT = 132,
	CEHtmlAttributeId_ONMOUSEOVER = 133,
	CEHtmlAttributeId_ONMOUSEUP = 134,
	CEHtmlAttributeId_ONRESET = 135,
	CEHtmlAttributeId_ONSELECT = 136,
	CEHtmlAttributeId_ONSUBMIT = 137,
	CEHtmlAttributeId_ONUNLOAD = 138,

	// adhoc for Bug 6034.
	CEHtmlAttributeId_INNERTEXT = 139,
} CEHtmlAttributeId;

typedef enum
{
    CEHtmlEventId_Unknown,
    CEHtmlEventId_ONBEFOREUNLOAD,
    CEHtmlEventId_ONBLUR,
    CEHtmlEventId_ONBOUNCE,
    CEHtmlEventId_ONCHANGE,
    CEHtmlEventId_ONCLICK,
    CEHtmlEventId_ONDBLCLICK,
    CEHtmlEventId_ONERROR,
    CEHtmlEventId_ONFINISH,
    CEHtmlEventId_ONFOCUS,
    CEHtmlEventId_ONKEYDOWN,
    CEHtmlEventId_ONKEYPRESS,
    CEHtmlEventId_ONKEYUP,
    CEHtmlEventId_ONLOAD,
    CEHtmlEventId_ONMOUSEDOWN,
    CEHtmlEventId_ONMOUSEMOVE,
    CEHtmlEventId_ONMOUSEOUT,
    CEHtmlEventId_ONMOUSEOVER,
    CEHtmlEventId_ONMOUSEUP,
    CEHtmlEventId_ONRESET,
    CEHtmlEventId_ONRESIZE,
    CEHtmlEventId_ONSELECT,
    CEHtmlEventId_ONSTART,
    CEHtmlEventId_ONSUBMIT,
    CEHtmlEventId_ONUNLOAD,
} CEHtmlEventId;

typedef enum
{
    CEHtmlElementBoxType_Border,
    CEHtmlElementBoxType_Padding,
} CEHtmlElementBoxType;

typedef enum
{
    CEHtmlColorType_Foreground,
    CEHtmlColorType_Background,
} CEHtmlElementColorType;

typedef enum
{
    CEHtmlLengthType_Normal,
    CEHtmlLengthType_Max,
} CEHtmlElementLengthType;

typedef enum
{
    CEHtmlElementRectType_Content,
    CEHtmlElementRectType_Padding,
    CEHtmlElementRectType_Border,
    CEHtmlElementRectType_Margin
} CEHtmlElementRectType;

typedef enum
{
	CEHtmlRepeat_Repeat,
	CEHtmlRepeat_RepeatX,
	CEHtmlRepeat_RepeatY,
	CEHtmlRepeat_Norepeat
} CEHtmlElementRepeatType;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

typedef struct CEHtmlTLStyle
{
	eCEHDirection hDirection;
	CEHorizontalAlignType hAlign;
	eCEUnicodeBiDi unicodeBiDi;
	bool textOverflowEllipsis;
} CEHtmlTLStyle;

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlElementBaseProxy ICEHtmlElementBaseProxy
 * @{
 */

/*!
 * ID of ICEHtmlElementBaseProxy
 */
#define CEComIID_ICEHtmlElementBaseProxy 0x77968174


/*!
 * ICEHtmlElementProxy
 */
typedef struct ICEHtmlElementBaseProxy
{
	const struct ICEHtmlElementBaseProxy_vtbl* _vtbl;
} ICEHtmlElementBaseProxy;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iElementBaseProxy	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlElementBaseProxy_queryInterface) (ICEHtmlElementBaseProxy* iElementBaseProxy, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlElementBaseProxy_addRef) (ICEHtmlElementBaseProxy* iElementBaseProxy);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlElementBaseProxy_release) (ICEHtmlElementBaseProxy* iElementBaseProxy);

typedef CEHResult (*iCEHtmlElementBaseProxy_getElementId) (ICEHtmlElementBaseProxy* iElementBaseProxy, CEHtmlElementId* elemIdOut);

typedef CEHResult (*iCEHtmlElementBaseProxy_getAttributeString) (ICEHtmlElementBaseProxy* iElementBaseProxy, CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut);

typedef CEHResult (*iCEHtmlElementBaseProxy_getDocument) (ICEHtmlElementBaseProxy* iElementBaseProxy, struct ICEHtmlDocument* *const iDocumentOut);

typedef CEHResult (*iCEHtmlElementBaseProxy_isAvailable) (ICEHtmlElementBaseProxy* iElementBaseProxy, bool *const isAvailableOut);

/*!
 * V-table of ICEHtmlElementBaseProxy
 */
struct ICEHtmlElementBaseProxy_vtbl
{
	iCEHtmlElementBaseProxy_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlElementBaseProxy_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlElementBaseProxy_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlElementBaseProxy_getElementId	_getElementId;
	iCEHtmlElementBaseProxy_getAttributeString	_getAttributeString;
	iCEHtmlElementBaseProxy_getDocument	_getDocument;
	iCEHtmlElementBaseProxy_isAvailable	_isAvailable;
};

/*! @}
 * end of ICEHtmlElementBaseProxy
 */

/*! \defgroup ICEHtmlResolvedElementProxy ICEHtmlResolvedElementProxy
 * @{
 */

/*!
 * ID of ICEHtmlResolvedElementProxy
 */
#define CEComIID_ICEHtmlResolvedElementProxy 0x181709c4

/*!
 * ICEHtmlResolvedElementProxy
 */
typedef struct ICEHtmlResolvedElementProxy
{
	const struct ICEHtmlResolvedElementProxy_vtbl* _vtbl;
} ICEHtmlResolvedElementProxy;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iResolvedElementProxy	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlResolvedElementProxy_queryInterface) (ICEHtmlResolvedElementProxy* iResolvedElementProxy, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlResolvedElementProxy_addRef) (ICEHtmlResolvedElementProxy* iResolvedElementProxy);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlResolvedElementProxy_release) (ICEHtmlResolvedElementProxy* iResolvedElementProxy);

typedef CEHResult (*iCEHtmlResolvedElementProxy_getElementId) (ICEHtmlResolvedElementProxy* iResolvedElementProxy, CEHtmlElementId* elemIdOut);

typedef CEHResult (*iCEHtmlResolvedElementProxy_getAttributeString) (ICEHtmlResolvedElementProxy* iResolvedElementProxy, CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut);

typedef CEHResult (*iCEHtmlResolvedElementProxy_getDocument) (ICEHtmlResolvedElementProxy* iResolvedElementProxy, struct ICEHtmlDocument* *const iDocumentOut);

typedef CEHResult (*iCEHtmlResolvedElementProxy_isAvailable) (ICEHtmlResolvedElementProxy* iResolvedElementProxy, bool *const isAvailableOut);

typedef CEHResult (*iCEHtmlResolvedElementProxy_getColor) (ICEHtmlResolvedElementProxy* iResolvedElementProxy, CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut);

typedef CEHResult (*iCEHtmlResolvedElementProxy_isBackgroundTransparent) (ICEHtmlResolvedElementProxy* iResolvedElementProxy, bool *const transparentOut);

typedef CEHResult (*iCEHtmlResolvedElementProxy_getBoxValue) (ICEHtmlResolvedElementProxy* iResolvedElementProxy, CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut);

typedef CEHResult (*iCEHtmlResolvedElementProxy_getCharacterType) (ICEHtmlResolvedElementProxy* iResolvedElementProxy, characterTypeValue* charTypeOut, imeModeValue* imeModeOut);

typedef CEHResult (*iCEHtmlResolvedElementProxy_getFont) (ICEHtmlResolvedElementProxy* iResolvedElementProxy, struct ICEUICompositeFont* *const iFontOut);

typedef CEHResult (*iCEHtmlResolvedElementProxy_getRect) (ICEHtmlResolvedElementProxy* iResolvedElementProxy, CEHtmlElementRectType rectType, CERect *const rectOut);

typedef CEHResult (*iCEHtmlResolvedElementProxy_isVisible) (ICEHtmlResolvedElementProxy* iResolvedElementProxy, bool *const visibleOut);

typedef CEHResult (*iCEHtmlResolvedElementProxy_calculateBoundingRectangle) (ICEHtmlResolvedElementProxy* iResolvedElementProxy, CERect *const rectOut);

typedef CEHResult (*iCEHtmlResolvedElementProxy_getBackgroundRepeat) (ICEHtmlResolvedElementProxy* iResolvedElementProxy, CEHtmlElementRepeatType *const repeatOut);

typedef CEHResult (*iCEHtmlResolvedElementProxy_getTLStyles) (ICEHtmlResolvedElementProxy* iResolvedElementProxy, CEHtmlTLStyle *const tlStyleOut);

/*!
 * V-table of ICEHtmlResolvedElementProxy
 */
struct ICEHtmlResolvedElementProxy_vtbl
{
	iCEHtmlResolvedElementProxy_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlResolvedElementProxy_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlResolvedElementProxy_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlResolvedElementProxy_getElementId	_getElementId;
	iCEHtmlResolvedElementProxy_getAttributeString	_getAttributeString;
	iCEHtmlResolvedElementProxy_getDocument	_getDocument;
	iCEHtmlResolvedElementProxy_isAvailable	_isAvailable;
	iCEHtmlResolvedElementProxy_getColor	_getColor;
	iCEHtmlResolvedElementProxy_isBackgroundTransparent	_isBackgroundTransparent;
	iCEHtmlResolvedElementProxy_getBoxValue	_getBoxValue;
	iCEHtmlResolvedElementProxy_getCharacterType	_getCharacterType;
	iCEHtmlResolvedElementProxy_getFont	_getFont;
	iCEHtmlResolvedElementProxy_getRect	_getRect;
	iCEHtmlResolvedElementProxy_isVisible	_isVisible;
	iCEHtmlResolvedElementProxy_calculateBoundingRectangle	_calculateBoundingRectangle;
	iCEHtmlResolvedElementProxy_getBackgroundRepeat	_getBackgroundRepeat;
	iCEHtmlResolvedElementProxy_getTLStyles	_getTLStyles;
};

/*! @}
 * end of ICEHtmlResolvedElementProxy
 */

/*! \defgroup ICEHtmlHierarchicalFocusElementProxy ICEHtmlHierarchicalFocusElementProxy
 * @{
 */

/*!
 * ID of ICEHtmlHierarchicalFocusElementProxy
 */
#define CEComIID_ICEHtmlHierarchicalFocusElementProxy 0x6a82aa81

/*!
 * ICEHtmlHierarchicalFocusElementProxy
 */
typedef struct ICEHtmlHierarchicalFocusElementProxy
{
	const struct ICEHtmlHierarchicalFocusElementProxy_vtbl* _vtbl;
} ICEHtmlHierarchicalFocusElementProxy;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iHierarchicalFocusElementProxy	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlHierarchicalFocusElementProxy_queryInterface) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlHierarchicalFocusElementProxy_addRef) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlHierarchicalFocusElementProxy_release) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy);

typedef CEHResult (*iCEHtmlHierarchicalFocusElementProxy_getElementId) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy, CEHtmlElementId* elemIdOut);

typedef CEHResult (*iCEHtmlHierarchicalFocusElementProxy_getAttributeString) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy, CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut);

typedef CEHResult (*iCEHtmlHierarchicalFocusElementProxy_getDocument) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy, struct ICEHtmlDocument* *const iDocumentOut);

typedef CEHResult (*iCEHtmlHierarchicalFocusElementProxy_isAvailable) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy, bool *const isAvailableOut);

typedef CEHResult (*iCEHtmlHierarchicalFocusElementProxy_getColor) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy, CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut);

typedef CEHResult (*iCEHtmlHierarchicalFocusElementProxy_isBackgroundTransparent) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy, bool *const transparentOut);

typedef CEHResult (*iCEHtmlHierarchicalFocusElementProxy_getBoxValue) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy, CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut);

typedef CEHResult (*iCEHtmlHierarchicalFocusElementProxy_getCharacterType) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy, characterTypeValue* charTypeOut, imeModeValue* imeModeOut);

typedef CEHResult (*iCEHtmlHierarchicalFocusElementProxy_getFont) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy, struct ICEUICompositeFont* *const iFontOut);

typedef CEHResult (*iCEHtmlHierarchicalFocusElementProxy_getRect) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy, CEHtmlElementRectType rectType, CERect *const rectOut);

typedef CEHResult (*iCEHtmlHierarchicalFocusElementProxy_isVisible) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy, bool *const visibleOut);

typedef CEHResult (*iCEHtmlHierarchicalFocusElementProxy_calculateBoundingRectangle) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy, CERect *const rectOut);

typedef CEHResult (*iCEHtmlHierarchicalFocusElementProxy_getBackgroundRepeat) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy, CEHtmlElementRepeatType *const repeatOut);

typedef CEHResult (*iCEHtmlHierarchicalFocusElementProxy_getTLStyles) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy, CEHtmlTLStyle *const tlStyleOut);

typedef CEHResult (*iCEHtmlHierarchicalFocusElementProxy_ensureEditMode) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy);

typedef CEHResult (*iCEHtmlHierarchicalFocusElementProxy_exitEditMode) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy);

typedef CEHResult (*iCEHtmlHierarchicalFocusElementProxy_ensureFocus) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy);

typedef CEHResult (*iCEHtmlHierarchicalFocusElementProxy_loseFocus) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy);

typedef CEHResult (*iCEHtmlHierarchicalFocusElementProxy_isEditMode) (ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy, bool *const isEditModeOut);

/*!
 * V-table of ICEHtmlHierarchicalFocusElementProxy
 */
struct ICEHtmlHierarchicalFocusElementProxy_vtbl
{
	iCEHtmlHierarchicalFocusElementProxy_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlHierarchicalFocusElementProxy_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlHierarchicalFocusElementProxy_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlHierarchicalFocusElementProxy_getElementId	_getElementId;
	iCEHtmlHierarchicalFocusElementProxy_getAttributeString	_getAttributeString;
	iCEHtmlHierarchicalFocusElementProxy_getDocument	_getDocument;
	iCEHtmlHierarchicalFocusElementProxy_isAvailable	_isAvailable;
	iCEHtmlHierarchicalFocusElementProxy_getColor	_getColor;
	iCEHtmlHierarchicalFocusElementProxy_isBackgroundTransparent	_isBackgroundTransparent;
	iCEHtmlHierarchicalFocusElementProxy_getBoxValue	_getBoxValue;
	iCEHtmlHierarchicalFocusElementProxy_getCharacterType	_getCharacterType;
	iCEHtmlHierarchicalFocusElementProxy_getFont	_getFont;
	iCEHtmlHierarchicalFocusElementProxy_getRect	_getRect;
	iCEHtmlHierarchicalFocusElementProxy_isVisible	_isVisible;
	iCEHtmlHierarchicalFocusElementProxy_calculateBoundingRectangle	_calculateBoundingRectangle;
	iCEHtmlHierarchicalFocusElementProxy_getBackgroundRepeat	_getBackgroundRepeat;
	iCEHtmlHierarchicalFocusElementProxy_getTLStyles	_getTLStyles;
	iCEHtmlHierarchicalFocusElementProxy_ensureEditMode	_ensureEditMode;
	iCEHtmlHierarchicalFocusElementProxy_exitEditMode	_exitEditMode;
	iCEHtmlHierarchicalFocusElementProxy_ensureFocus	_ensureFocus;
	iCEHtmlHierarchicalFocusElementProxy_loseFocus	_loseFocus;
	iCEHtmlHierarchicalFocusElementProxy_isEditMode	_isEditMode;
};

/*! @}
 * end of ICEHtmlHierarchicalFocusElementProxy
 */

/*! \defgroup ICEHtmlRadioGroup ICEHtmlRadioGroup
 * @{
 */

/*!
 * ID of ICEHtmlRadioGroup
 */
#define CEComIID_ICEHtmlRadioGroup 0x1f47e803


/*!
 * ICEHtmlRadioGroup
 */
typedef struct ICEHtmlRadioGroup
{
	const struct ICEHtmlRadioGroup_vtbl* _vtbl;
} ICEHtmlRadioGroup;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iRadioGroup	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlRadioGroup_queryInterface) (ICEHtmlRadioGroup* iRadioGroup, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlRadioGroup_addRef) (ICEHtmlRadioGroup* iRadioGroup);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlRadioGroup_release) (ICEHtmlRadioGroup* iRadioGroup);

/*!
 * V-table of ICEHtmlRadioGroup
 */
struct ICEHtmlRadioGroup_vtbl
{
	iCEHtmlRadioGroup_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlRadioGroup_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlRadioGroup_release	_release;	//!< Decrease the reference count of the specified interface pointer.
};

/*! @}
 * end of ICEHtmlRadioGroup
 */

/*! \defgroup ICEHtmlFormElementProxy ICEHtmlFormElementProxy
 * @{
 */

/*!
 * ID of ICEHtmlFormElementProxy
 */
#define CEComIID_ICEHtmlFormElementProxy 0x225cbfd0


/*!
 * ICEHtmlFormElementProxy
 */
typedef struct ICEHtmlFormElementProxy
{
	const struct ICEHtmlFormElementProxy_vtbl* _vtbl;
} ICEHtmlFormElementProxy;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iFormElementProxy	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlFormElementProxy_queryInterface) (ICEHtmlFormElementProxy* iFormElementProxy, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFormElementProxy_addRef) (ICEHtmlFormElementProxy* iFormElementProxy);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFormElementProxy_release) (ICEHtmlFormElementProxy* iFormElementProxy);

typedef CEHResult (*iCEHtmlFormElementProxy_getElementId) (ICEHtmlFormElementProxy* iFormElementProxy, CEHtmlElementId* elemIdOut);

typedef CEHResult (*iCEHtmlFormElementProxy_getAttributeString) (ICEHtmlFormElementProxy* iFormElementProxy, CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut);

typedef CEHResult (*iCEHtmlFormElementProxy_getDocument) (ICEHtmlFormElementProxy* iFormElementProxy, struct ICEHtmlDocument* *const iDocumentOut);

typedef CEHResult (*iCEHtmlFormElementProxy_isAvailable) (ICEHtmlFormElementProxy* iFormElementProxy, bool *const isAvailableOut);

typedef CEHResult (*iCEHtmlFormElementProxy_getColor) (ICEHtmlFormElementProxy* iFormElementProxy, CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut);

typedef CEHResult (*iCEHtmlFormElementProxy_isBackgroundTransparent) (ICEHtmlFormElementProxy* iFormElementProxy, bool *const transparentOut);

typedef CEHResult (*iCEHtmlFormElementProxy_getBoxValue) (ICEHtmlFormElementProxy* iFormElementProxy, CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut);

typedef CEHResult (*iCEHtmlFormElementProxy_getCharacterType) (ICEHtmlFormElementProxy* iFormElementProxy, characterTypeValue* charTypeOut, imeModeValue* imeModeOut);

typedef CEHResult (*iCEHtmlFormElementProxy_getFont) (ICEHtmlFormElementProxy* iFormElementProxy, struct ICEUICompositeFont* *const iFontOut);

typedef CEHResult (*iCEHtmlFormElementProxy_getRect) (ICEHtmlFormElementProxy* iFormElementProxy, CEHtmlElementRectType rectType, CERect *const rectOut);

typedef CEHResult (*iCEHtmlFormElementProxy_isVisible) (ICEHtmlFormElementProxy* iFormElementProxy, bool *const visibleOut);

typedef CEHResult (*iCEHtmlFormElementProxy_calculateBoundingRectangle) (ICEHtmlFormElementProxy* iFormElementProxy, CERect *const rectOut);

typedef CEHResult (*iCEHtmlFormElementProxy_getBackgroundRepeat) (ICEHtmlFormElementProxy* iFormElementProxy, CEHtmlElementRepeatType *const repeatOut);

typedef CEHResult (*iCEHtmlFormElementProxy_getTLStyles) (ICEHtmlFormElementProxy* iFormElementProxy, CEHtmlTLStyle *const tlStyleOut);

typedef CEHResult (*iCEHtmlFormElementProxy_getRadioGroupFromName) (ICEHtmlFormElementProxy* iFormElementProxy, struct ICEUString* iName, struct ICEHtmlRadioGroup* *const iRadioGroupOut);

typedef CEHResult (*iCEHtmlFormElementProxy_addRadioGroupFromName) (ICEHtmlFormElementProxy* iFormElementProxy, struct ICEUString* iName, struct ICEHtmlRadioGroup* iRadioGroup);

typedef CEHResult (*iCEHtmlFormElementProxy_updateRadioGroup) (ICEHtmlFormElementProxy* iFormElementProxy, struct ICEHtmlRadioGroup* iRadioGroup);

typedef CEHResult (*iCEHtmlFormElementProxy_submit) (ICEHtmlFormElementProxy* iFormElementProxy);

typedef CEHResult (*iCEHtmlFormElementProxy_reset) (ICEHtmlFormElementProxy* iFormElementProxy);

/*!
 * V-table of ICEHtmlFormElementProxy
 */
struct ICEHtmlFormElementProxy_vtbl
{
	iCEHtmlFormElementProxy_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlFormElementProxy_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlFormElementProxy_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlFormElementProxy_getElementId	_getElementId;
	iCEHtmlFormElementProxy_getAttributeString	_getAttributeString;
	iCEHtmlFormElementProxy_getDocument	_getDocument;
	iCEHtmlFormElementProxy_isAvailable	_isAvailable;
	iCEHtmlFormElementProxy_getColor	_getColor;
	iCEHtmlFormElementProxy_isBackgroundTransparent	_isBackgroundTransparent;
	iCEHtmlFormElementProxy_getBoxValue	_getBoxValue;
	iCEHtmlFormElementProxy_getCharacterType	_getCharacterType;
	iCEHtmlFormElementProxy_getFont	_getFont;
	iCEHtmlFormElementProxy_getRect	_getRect;
	iCEHtmlFormElementProxy_isVisible	_isVisible;
	iCEHtmlFormElementProxy_calculateBoundingRectangle	_calculateBoundingRectangle;
	iCEHtmlFormElementProxy_getBackgroundRepeat	_getBackgroundRepeat;
	iCEHtmlFormElementProxy_getTLStyles	_getTLStyles;
	iCEHtmlFormElementProxy_getRadioGroupFromName	_getRadioGroupFromName;
	iCEHtmlFormElementProxy_addRadioGroupFromName	_addRadioGroupFromName;
	iCEHtmlFormElementProxy_updateRadioGroup	_updateRadioGroup;
	iCEHtmlFormElementProxy_submit	_submit;
	iCEHtmlFormElementProxy_reset	_reset;
};

/*! @}
 * end of ICEHtmlFormElementProxy
 */

/*! \defgroup ICEHtmlFormControlElementProxy ICEHtmlFormControlElementProxy
 * @{
 */

/*!
 * ID of ICEHtmlFormControlElementProxy
 */
#define CEComIID_ICEHtmlFormControlElementProxy 0x9d7755eb


/*!
 * ICEHtmlFormControlElementProxy
 */
typedef struct ICEHtmlFormControlElementProxy
{
	const struct ICEHtmlFormControlElementProxy_vtbl* _vtbl;
} ICEHtmlFormControlElementProxy;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iFormControlElementProxy	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlFormControlElementProxy_queryInterface) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFormControlElementProxy_addRef) (ICEHtmlFormControlElementProxy* iFormControlElementProxy);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFormControlElementProxy_release) (ICEHtmlFormControlElementProxy* iFormControlElementProxy);

typedef CEHResult (*iCEHtmlFormControlElementProxy_getElementId) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, CEHtmlElementId* elemIdOut);

typedef CEHResult (*iCEHtmlFormControlElementProxy_getAttributeString) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut);

typedef CEHResult (*iCEHtmlFormControlElementProxy_getDocument) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, struct ICEHtmlDocument* *const iDocumentOut);

typedef CEHResult (*iCEHtmlFormControlElementProxy_isAvailable) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, bool *const isAvailableOut);

typedef CEHResult (*iCEHtmlFormControlElementProxy_getColor) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut);

typedef CEHResult (*iCEHtmlFormControlElementProxy_isBackgroundTransparent) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, bool *const transparentOut);

typedef CEHResult (*iCEHtmlFormControlElementProxy_getBoxValue) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut);

typedef CEHResult (*iCEHtmlFormControlElementProxy_getCharacterType) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, characterTypeValue* charTypeOut, imeModeValue* imeModeOut);

typedef CEHResult (*iCEHtmlFormControlElementProxy_getFont) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, struct ICEUICompositeFont* *const iFontOut);

typedef CEHResult (*iCEHtmlFormControlElementProxy_getRect) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, CEHtmlElementRectType rectType, CERect *const rectOut);

typedef CEHResult (*iCEHtmlFormControlElementProxy_isVisible) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, bool *const visibleOut);

typedef CEHResult (*iCEHtmlFormControlElementProxy_calculateBoundingRectangle) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, CERect *const rectOut);

typedef CEHResult (*iCEHtmlFormControlElementProxy_getBackgroundRepeat) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, CEHtmlElementRepeatType *const repeatOut);

typedef CEHResult (*iCEHtmlFormControlElementProxy_getTLStyles) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, CEHtmlTLStyle *const tlStyleOut);

typedef CEHResult (*iCEHtmlFormControlElementProxy_ensureEditMode) (ICEHtmlFormControlElementProxy* iFormControlElementProxy);

typedef CEHResult (*iCEHtmlFormControlElementProxy_exitEditMode) (ICEHtmlFormControlElementProxy* iFormControlElementProxy);

typedef CEHResult (*iCEHtmlFormControlElementProxy_ensureFocus) (ICEHtmlFormControlElementProxy* iFormControlElementProxy);

typedef CEHResult (*iCEHtmlFormControlElementProxy_loseFocus) (ICEHtmlFormControlElementProxy* iFormControlElementProxy);

typedef CEHResult (*iCEHtmlFormControlElementProxy_isEditMode) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, bool *const isEditModeOut);

typedef CEHResult (*iCEHtmlFormControlElementProxy_renderBorder) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, struct ICEUIGraphicsContext* iGC, CERect* borderRect);

typedef CEHResult (*iCEHtmlFormControlElementProxy_getFormElement) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, struct ICEHtmlFormElementProxy* *const iFormElement);

typedef CEHResult (*iCEHtmlFormControlElementProxy_genericEvent) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, CEHtmlEventId eventId);

typedef CEHResult (*iCEHtmlFormControlElementProxy_setFormValue) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, struct ICEUString* iFormStr);

typedef CEHResult (*iCEHtmlFormControlElementProxy_getFormValue) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, bool isDefault, struct ICEUString* *const iFormStrOut);

typedef CEHResult (*iCEHtmlFormControlElementProxy_isDisabled) (ICEHtmlFormControlElementProxy* iFormControlElementProxy, bool *const disabledOut);

/*!
 * V-table of ICEHtmlFormControlElementProxy
 */
struct ICEHtmlFormControlElementProxy_vtbl
{
	iCEHtmlFormControlElementProxy_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlFormControlElementProxy_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlFormControlElementProxy_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlFormControlElementProxy_getElementId	_getElementId;
	iCEHtmlFormControlElementProxy_getAttributeString	_getAttributeString;
	iCEHtmlFormControlElementProxy_getDocument	_getDocument;
	iCEHtmlFormControlElementProxy_isAvailable	_isAvailable;
	iCEHtmlFormControlElementProxy_getColor	_getColor;
	iCEHtmlFormControlElementProxy_isBackgroundTransparent	_isBackgroundTransparent;
	iCEHtmlFormControlElementProxy_getBoxValue	_getBoxValue;
	iCEHtmlFormControlElementProxy_getCharacterType	_getCharacterType;
	iCEHtmlFormControlElementProxy_getFont	_getFont;
	iCEHtmlFormControlElementProxy_getRect	_getRect;
	iCEHtmlFormControlElementProxy_isVisible	_isVisible;
	iCEHtmlFormControlElementProxy_calculateBoundingRectangle	_calculateBoundingRectangle;
	iCEHtmlFormControlElementProxy_getBackgroundRepeat	_getBackgroundRepeat;
	iCEHtmlFormControlElementProxy_getTLStyles	_getTLStyles;
	iCEHtmlFormControlElementProxy_ensureEditMode	_ensureEditMode;
	iCEHtmlFormControlElementProxy_exitEditMode	_exitEditMode;
	iCEHtmlFormControlElementProxy_ensureFocus	_ensureFocus;
	iCEHtmlFormControlElementProxy_loseFocus	_loseFocus;
	iCEHtmlFormControlElementProxy_isEditMode	_isEditMode;
	iCEHtmlFormControlElementProxy_renderBorder	_renderBorder;
	iCEHtmlFormControlElementProxy_getFormElement	_getFormElement;
	iCEHtmlFormControlElementProxy_genericEvent	_genericEvent;
	iCEHtmlFormControlElementProxy_setFormValue	_setFormValue;
	iCEHtmlFormControlElementProxy_getFormValue	_getFormValue;
	iCEHtmlFormControlElementProxy_isDisabled	_isDisabled;
};

/*! @}
 * end of ICEHtmlFormControlElementProxy
 */

/*! \defgroup ICEHtmlButtonElementProxy ICEHtmlButtonElementProxy
 * @{
 */

/*!
 * ID of ICEHtmlButtonElementProxy
 */
#define CEComIID_ICEHtmlButtonElementProxy 0x0372292b


/*!
 * ICEHtmlButtonElementProxy
 */
typedef struct ICEHtmlButtonElementProxy
{
	const struct ICEHtmlButtonElementProxy_vtbl* _vtbl;
} ICEHtmlButtonElementProxy;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iButtonElementProxy	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlButtonElementProxy_queryInterface) (ICEHtmlButtonElementProxy* iButtonElementProxy, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlButtonElementProxy_addRef) (ICEHtmlButtonElementProxy* iButtonElementProxy);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlButtonElementProxy_release) (ICEHtmlButtonElementProxy* iButtonElementProxy);

typedef CEHResult (*iCEHtmlButtonElementProxy_getElementId) (ICEHtmlButtonElementProxy* iButtonElementProxy, CEHtmlElementId* elemIdOut);

typedef CEHResult (*iCEHtmlButtonElementProxy_getAttributeString) (ICEHtmlButtonElementProxy* iButtonElementProxy, CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut);

typedef CEHResult (*iCEHtmlButtonElementProxy_getDocument) (ICEHtmlButtonElementProxy* iButtonElementProxy, struct ICEHtmlDocument* *const iDocumentOut);

typedef CEHResult (*iCEHtmlButtonElementProxy_isAvailable) (ICEHtmlButtonElementProxy* iButtonElementProxy, bool *const isAvailableOut);

typedef CEHResult (*iCEHtmlButtonElementProxy_getColor) (ICEHtmlButtonElementProxy* iButtonElementProxy, CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut);

typedef CEHResult (*iCEHtmlButtonElementProxy_isBackgroundTransparent) (ICEHtmlButtonElementProxy* iButtonElementProxy, bool *const transparentOut);

typedef CEHResult (*iCEHtmlButtonElementProxy_getBoxValue) (ICEHtmlButtonElementProxy* iButtonElementProxy, CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut);

typedef CEHResult (*iCEHtmlButtonElementProxy_getCharacterType) (ICEHtmlButtonElementProxy* iButtonElementProxy, characterTypeValue* charTypeOut, imeModeValue* imeModeOut);

typedef CEHResult (*iCEHtmlButtonElementProxy_getFont) (ICEHtmlButtonElementProxy* iButtonElementProxy, struct ICEUICompositeFont* *const iFontOut);

typedef CEHResult (*iCEHtmlButtonElementProxy_getRect) (ICEHtmlButtonElementProxy* iButtonElementProxy, CEHtmlElementRectType rectType, CERect *const rectOut);

typedef CEHResult (*iCEHtmlButtonElementProxy_isVisible) (ICEHtmlButtonElementProxy* iButtonElementProxy, bool *const visibleOut);

typedef CEHResult (*iCEHtmlButtonElementProxy_calculateBoundingRectangle) (ICEHtmlButtonElementProxy* iButtonElementProxy, CERect *const rectOut);

typedef CEHResult (*iCEHtmlButtonElementProxy_getBackgroundRepeat) (ICEHtmlButtonElementProxy* iButtonElementProxy, CEHtmlElementRepeatType *const repeatOut);

typedef CEHResult (*iCEHtmlButtonElementProxy_getTLStyles) (ICEHtmlButtonElementProxy* iButtonElementProxy, CEHtmlTLStyle *const tlStyleOut);

typedef CEHResult (*iCEHtmlButtonElementProxy_ensureEditMode) (ICEHtmlButtonElementProxy* iButtonElementProxy);

typedef CEHResult (*iCEHtmlButtonElementProxy_exitEditMode) (ICEHtmlButtonElementProxy* iButtonElementProxy);

typedef CEHResult (*iCEHtmlButtonElementProxy_ensureFocus) (ICEHtmlButtonElementProxy* iButtonElementProxy);

typedef CEHResult (*iCEHtmlButtonElementProxy_loseFocus) (ICEHtmlButtonElementProxy* iButtonElementProxy);

typedef CEHResult (*iCEHtmlButtonElementProxy_isEditMode) (ICEHtmlButtonElementProxy* iButtonElementProxy, bool *const isEditModeOut);

typedef CEHResult (*iCEHtmlButtonElementProxy_renderBorder) (ICEHtmlButtonElementProxy* iButtonElementProxy, struct ICEUIGraphicsContext* iGC, CERect* borderRect);

typedef CEHResult (*iCEHtmlButtonElementProxy_getFormElement) (ICEHtmlButtonElementProxy* iButtonElementProxy, struct ICEHtmlFormElementProxy* *const iFormElement);

typedef CEHResult (*iCEHtmlButtonElementProxy_genericEvent) (ICEHtmlButtonElementProxy* iButtonElementProxy, CEHtmlEventId eventId);

typedef CEHResult (*iCEHtmlButtonElementProxy_setFormValue) (ICEHtmlButtonElementProxy* iButtonElementProxy, struct ICEUString* iFormStr);

typedef CEHResult (*iCEHtmlButtonElementProxy_getFormValue) (ICEHtmlButtonElementProxy* iButtonElementProxy, bool isDefault, struct ICEUString* *const iFormStrOut);

typedef CEHResult (*iCEHtmlButtonElementProxy_isDisabled) (ICEHtmlButtonElementProxy* iButtonElementProxy, bool *const disabledOut);

typedef CEHResult (*iCEHtmlButtonElementProxy_renderButton) (ICEHtmlButtonElementProxy* iButtonElementProxy, struct ICEUIGraphicsContext* iGC, bool isButtonDown);

/*!
 * V-table of ICEHtmlButtonElementProxy
 */
struct ICEHtmlButtonElementProxy_vtbl
{
	iCEHtmlButtonElementProxy_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlButtonElementProxy_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlButtonElementProxy_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlButtonElementProxy_getElementId	_getElementId;
	iCEHtmlButtonElementProxy_getAttributeString	_getAttributeString;
	iCEHtmlButtonElementProxy_getDocument	_getDocument;
	iCEHtmlButtonElementProxy_isAvailable	_isAvailable;
	iCEHtmlButtonElementProxy_getColor	_getColor;
	iCEHtmlButtonElementProxy_isBackgroundTransparent	_isBackgroundTransparent;
	iCEHtmlButtonElementProxy_getBoxValue	_getBoxValue;
	iCEHtmlButtonElementProxy_getCharacterType	_getCharacterType;
	iCEHtmlButtonElementProxy_getFont	_getFont;
	iCEHtmlButtonElementProxy_getRect	_getRect;
	iCEHtmlButtonElementProxy_isVisible	_isVisible;
	iCEHtmlButtonElementProxy_calculateBoundingRectangle	_calculateBoundingRectangle;
	iCEHtmlButtonElementProxy_getBackgroundRepeat	_getBackgroundRepeat;
	iCEHtmlButtonElementProxy_getTLStyles	_getTLStyles;
	iCEHtmlButtonElementProxy_ensureEditMode	_ensureEditMode;
	iCEHtmlButtonElementProxy_exitEditMode	_exitEditMode;
	iCEHtmlButtonElementProxy_ensureFocus	_ensureFocus;
	iCEHtmlButtonElementProxy_loseFocus	_loseFocus;
	iCEHtmlButtonElementProxy_isEditMode	_isEditMode;
	iCEHtmlButtonElementProxy_renderBorder	_renderBorder;
	iCEHtmlButtonElementProxy_getFormElement	_getFormElement;
	iCEHtmlButtonElementProxy_genericEvent	_genericEvent;
	iCEHtmlButtonElementProxy_setFormValue	_setFormValue;
	iCEHtmlButtonElementProxy_getFormValue	_getFormValue;
	iCEHtmlButtonElementProxy_isDisabled	_isDisabled;
	iCEHtmlButtonElementProxy_renderButton	_renderButton;
};

/*! @}
 * end of ICEHtmlButtonElementProxy
 */

/*! \defgroup ICEHtmlTextControlElementProxy ICEHtmlTextControlElementProxy
 * @{
 */

/*!
 * ID of ICEHtmlTextControlElementProxy
 */
#define CEComIID_ICEHtmlTextControlElementProxy 0x8820478a

/*!
 * ICEHtmlTextControlElementProxy
 */
typedef struct ICEHtmlTextControlElementProxy
{
	const struct ICEHtmlTextControlElementProxy_vtbl* _vtbl;
} ICEHtmlTextControlElementProxy;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iTextControlElementProxy	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlTextControlElementProxy_queryInterface) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlTextControlElementProxy_addRef) (ICEHtmlTextControlElementProxy* iTextControlElementProxy);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlTextControlElementProxy_release) (ICEHtmlTextControlElementProxy* iTextControlElementProxy);

typedef CEHResult (*iCEHtmlTextControlElementProxy_getElementId) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, CEHtmlElementId* elemIdOut);

typedef CEHResult (*iCEHtmlTextControlElementProxy_getAttributeString) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut);

typedef CEHResult (*iCEHtmlTextControlElementProxy_getDocument) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, struct ICEHtmlDocument* *const iDocumentOut);

typedef CEHResult (*iCEHtmlTextControlElementProxy_isAvailable) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, bool *const isAvailableOut);

typedef CEHResult (*iCEHtmlTextControlElementProxy_getColor) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut);

typedef CEHResult (*iCEHtmlTextControlElementProxy_isBackgroundTransparent) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, bool *const transparentOut);

typedef CEHResult (*iCEHtmlTextControlElementProxy_getBoxValue) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut);

typedef CEHResult (*iCEHtmlTextControlElementProxy_getCharacterType) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, characterTypeValue* charTypeOut, imeModeValue* imeModeOut);

typedef CEHResult (*iCEHtmlTextControlElementProxy_getFont) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, struct ICEUICompositeFont* *const iFontOut);

typedef CEHResult (*iCEHtmlTextControlElementProxy_getRect) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, CEHtmlElementRectType rectType, CERect *const rectOut);

typedef CEHResult (*iCEHtmlTextControlElementProxy_isVisible) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, bool *const visibleOut);

typedef CEHResult (*iCEHtmlTextControlElementProxy_calculateBoundingRectangle) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, CERect *const rectOut);

typedef CEHResult (*iCEHtmlTextControlElementProxy_getBackgroundRepeat) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, CEHtmlElementRepeatType *const repeatOut);

typedef CEHResult (*iCEHtmlTextControlElementProxy_getTLStyles) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, CEHtmlTLStyle *const tlStyleOut);

typedef CEHResult (*iCEHtmlTextControlElementProxy_ensureEditMode) (ICEHtmlTextControlElementProxy* iTextControlElementProxy);

typedef CEHResult (*iCEHtmlTextControlElementProxy_exitEditMode) (ICEHtmlTextControlElementProxy* iTextControlElementProxy);

typedef CEHResult (*iCEHtmlTextControlElementProxy_ensureFocus) (ICEHtmlTextControlElementProxy* iTextControlElementProxy);

typedef CEHResult (*iCEHtmlTextControlElementProxy_loseFocus) (ICEHtmlTextControlElementProxy* iTextControlElementProxy);

typedef CEHResult (*iCEHtmlTextControlElementProxy_isEditMode) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, bool *const isEditModeOut);

typedef CEHResult (*iCEHtmlTextControlElementProxy_renderBorder) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, struct ICEUIGraphicsContext* iGC, CERect* borderRect);

typedef CEHResult (*iCEHtmlTextControlElementProxy_getFormElement) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, struct ICEHtmlFormElementProxy* *const iFormElement);

typedef CEHResult (*iCEHtmlTextControlElementProxy_genericEvent) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, CEHtmlEventId eventId);

typedef CEHResult (*iCEHtmlTextControlElementProxy_setFormValue) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, struct ICEUString* iFormStr);

typedef CEHResult (*iCEHtmlTextControlElementProxy_getFormValue) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, bool isDefault, struct ICEUString* *const iFormStrOut);

typedef CEHResult (*iCEHtmlTextControlElementProxy_isDisabled) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, bool *const disabledOut);

typedef CEHResult (*iCEHtmlTextControlElementProxy_cut) (ICEHtmlTextControlElementProxy* iTextControlElementProxy);

typedef CEHResult (*iCEHtmlTextControlElementProxy_copy) (ICEHtmlTextControlElementProxy* iTextControlElementProxy);

typedef CEHResult (*iCEHtmlTextControlElementProxy_paste) (ICEHtmlTextControlElementProxy* iTextControlElementProxy);

typedef CEHResult (*iCEHtmlTextControlElementProxy_selectAll) (ICEHtmlTextControlElementProxy* iTextControlElementProxy);

typedef CEHResult (*iCEHtmlTextControlElementProxy_isReadOnly) (ICEHtmlTextControlElementProxy* iTextControlElementProxy, bool *const readOnlyOut);

/*!
 * V-table of ICEHtmlTextControlElementProxy
 */
struct ICEHtmlTextControlElementProxy_vtbl
{
	iCEHtmlTextControlElementProxy_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlTextControlElementProxy_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlTextControlElementProxy_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlTextControlElementProxy_getElementId	_getElementId;
	iCEHtmlTextControlElementProxy_getAttributeString	_getAttributeString;
	iCEHtmlTextControlElementProxy_getDocument	_getDocument;
	iCEHtmlTextControlElementProxy_isAvailable	_isAvailable;
	iCEHtmlTextControlElementProxy_getColor	_getColor;
	iCEHtmlTextControlElementProxy_isBackgroundTransparent	_isBackgroundTransparent;
	iCEHtmlTextControlElementProxy_getBoxValue	_getBoxValue;
	iCEHtmlTextControlElementProxy_getCharacterType	_getCharacterType;
	iCEHtmlTextControlElementProxy_getFont	_getFont;
	iCEHtmlTextControlElementProxy_getRect	_getRect;
	iCEHtmlTextControlElementProxy_isVisible	_isVisible;
	iCEHtmlTextControlElementProxy_calculateBoundingRectangle	_calculateBoundingRectangle;
	iCEHtmlTextControlElementProxy_getBackgroundRepeat	_getBackgroundRepeat;
	iCEHtmlTextControlElementProxy_getTLStyles	_getTLStyles;
	iCEHtmlTextControlElementProxy_ensureEditMode	_ensureEditMode;
	iCEHtmlTextControlElementProxy_exitEditMode	_exitEditMode;
	iCEHtmlTextControlElementProxy_ensureFocus	_ensureFocus;
	iCEHtmlTextControlElementProxy_loseFocus	_loseFocus;
	iCEHtmlTextControlElementProxy_isEditMode	_isEditMode;
	iCEHtmlTextControlElementProxy_renderBorder	_renderBorder;
	iCEHtmlTextControlElementProxy_getFormElement	_getFormElement;
	iCEHtmlTextControlElementProxy_genericEvent	_genericEvent;
	iCEHtmlTextControlElementProxy_setFormValue	_setFormValue;
	iCEHtmlTextControlElementProxy_getFormValue	_getFormValue;
	iCEHtmlTextControlElementProxy_isDisabled	_isDisabled;
	iCEHtmlTextControlElementProxy_cut	_cut;
	iCEHtmlTextControlElementProxy_copy	_copy;
	iCEHtmlTextControlElementProxy_paste	_paste;
	iCEHtmlTextControlElementProxy_selectAll	_selectAll;
	iCEHtmlTextControlElementProxy_isReadOnly	_isReadOnly;
};

/*! @}
 * end of ICEHtmlTextControlElementProxy
 */

/*! \defgroup ICEHtmlInputTextElementProxy ICEHtmlInputTextElementProxy
 * @{
 */

/*!
 * ID of ICEHtmlInputTextElementProxy
 */
#define CEComIID_ICEHtmlInputTextElementProxy 0xce62f722


/*!
 * ICEHtmlInputTextElementProxy
 */
typedef struct ICEHtmlInputTextElementProxy
{
	const struct ICEHtmlInputTextElementProxy_vtbl* _vtbl;
} ICEHtmlInputTextElementProxy;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iInputTextElementProxy	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlInputTextElementProxy_queryInterface) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlInputTextElementProxy_addRef) (ICEHtmlInputTextElementProxy* iInputTextElementProxy);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlInputTextElementProxy_release) (ICEHtmlInputTextElementProxy* iInputTextElementProxy);

typedef CEHResult (*iCEHtmlInputTextElementProxy_getElementId) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, CEHtmlElementId* elemIdOut);

typedef CEHResult (*iCEHtmlInputTextElementProxy_getAttributeString) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut);

typedef CEHResult (*iCEHtmlInputTextElementProxy_getDocument) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, struct ICEHtmlDocument* *const iDocumentOut);

typedef CEHResult (*iCEHtmlInputTextElementProxy_isAvailable) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, bool *const isAvailableOut);

typedef CEHResult (*iCEHtmlInputTextElementProxy_getColor) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut);

typedef CEHResult (*iCEHtmlInputTextElementProxy_isBackgroundTransparent) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, bool *const transparentOut);

typedef CEHResult (*iCEHtmlInputTextElementProxy_getBoxValue) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut);

typedef CEHResult (*iCEHtmlInputTextElementProxy_getCharacterType) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, characterTypeValue* charTypeOut, imeModeValue* imeModeOut);

typedef CEHResult (*iCEHtmlInputTextElementProxy_getFont) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, struct ICEUICompositeFont* *const iFontOut);

typedef CEHResult (*iCEHtmlInputTextElementProxy_getRect) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, CEHtmlElementRectType rectType, CERect *const rectOut);

typedef CEHResult (*iCEHtmlInputTextElementProxy_isVisible) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, bool *const visibleOut);

typedef CEHResult (*iCEHtmlInputTextElementProxy_calculateBoundingRectangle) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, CERect *const rectOut);

typedef CEHResult (*iCEHtmlInputTextElementProxy_getBackgroundRepeat) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, CEHtmlElementRepeatType *const repeatOut);

typedef CEHResult (*iCEHtmlInputTextElementProxy_getTLStyles) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, CEHtmlTLStyle *const tlStyleOut);

typedef CEHResult (*iCEHtmlInputTextElementProxy_ensureEditMode) (ICEHtmlInputTextElementProxy* iInputTextElementProxy);

typedef CEHResult (*iCEHtmlInputTextElementProxy_exitEditMode) (ICEHtmlInputTextElementProxy* iInputTextElementProxy);

typedef CEHResult (*iCEHtmlInputTextElementProxy_ensureFocus) (ICEHtmlInputTextElementProxy* iInputTextElementProxy);

typedef CEHResult (*iCEHtmlInputTextElementProxy_loseFocus) (ICEHtmlInputTextElementProxy* iInputTextElementProxy);

typedef CEHResult (*iCEHtmlInputTextElementProxy_isEditMode) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, bool *const isEditModeOut);

typedef CEHResult (*iCEHtmlInputTextElementProxy_renderBorder) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, struct ICEUIGraphicsContext* iGC, CERect* borderRect);

typedef CEHResult (*iCEHtmlInputTextElementProxy_getFormElement) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, struct ICEHtmlFormElementProxy* *const iFormElement);

typedef CEHResult (*iCEHtmlInputTextElementProxy_genericEvent) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, CEHtmlEventId eventId);

typedef CEHResult (*iCEHtmlInputTextElementProxy_setFormValue) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, struct ICEUString* iFormStr);

typedef CEHResult (*iCEHtmlInputTextElementProxy_getFormValue) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, bool isDefault, struct ICEUString* *const iFormStrOut);

typedef CEHResult (*iCEHtmlInputTextElementProxy_isDisabled) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, bool *const disabledOut);

typedef CEHResult (*iCEHtmlInputTextElementProxy_cut) (ICEHtmlInputTextElementProxy* iInputTextElementProxy);

typedef CEHResult (*iCEHtmlInputTextElementProxy_copy) (ICEHtmlInputTextElementProxy* iInputTextElementProxy);

typedef CEHResult (*iCEHtmlInputTextElementProxy_paste) (ICEHtmlInputTextElementProxy* iInputTextElementProxy);

typedef CEHResult (*iCEHtmlInputTextElementProxy_selectAll) (ICEHtmlInputTextElementProxy* iInputTextElementProxy);

typedef CEHResult (*iCEHtmlInputTextElementProxy_isReadOnly) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, bool *const readOnlyOut);

typedef CEHResult (*iCEHtmlInputTextElementProxy_getTextLength) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, CEHtmlElementLengthType lengthType, INT32 *const lenOut, bool *const undefinedOut);

typedef CEHResult (*iCEHtmlInputTextElementProxy_isPasswordMode) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, bool *const passwordModeOut);

typedef CEHResult (*iCEHtmlInputTextElementProxy_setVisibleText) (ICEHtmlInputTextElementProxy* iInputTextElementProxy, struct ICEUString* visibleText);

/*!
 * V-table of ICEHtmlInputTextElementProxy
 */
struct ICEHtmlInputTextElementProxy_vtbl
{
	iCEHtmlInputTextElementProxy_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlInputTextElementProxy_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlInputTextElementProxy_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlInputTextElementProxy_getElementId	_getElementId;
	iCEHtmlInputTextElementProxy_getAttributeString	_getAttributeString;
	iCEHtmlInputTextElementProxy_getDocument	_getDocument;
	iCEHtmlInputTextElementProxy_isAvailable	_isAvailable;
	iCEHtmlInputTextElementProxy_getColor	_getColor;
	iCEHtmlInputTextElementProxy_isBackgroundTransparent	_isBackgroundTransparent;
	iCEHtmlInputTextElementProxy_getBoxValue	_getBoxValue;
	iCEHtmlInputTextElementProxy_getCharacterType	_getCharacterType;
	iCEHtmlInputTextElementProxy_getFont	_getFont;
	iCEHtmlInputTextElementProxy_getRect	_getRect;
	iCEHtmlInputTextElementProxy_isVisible	_isVisible;
	iCEHtmlInputTextElementProxy_calculateBoundingRectangle	_calculateBoundingRectangle;
	iCEHtmlInputTextElementProxy_getBackgroundRepeat	_getBackgroundRepeat;
	iCEHtmlInputTextElementProxy_getTLStyles	_getTLStyles;
	iCEHtmlInputTextElementProxy_ensureEditMode	_ensureEditMode;
	iCEHtmlInputTextElementProxy_exitEditMode	_exitEditMode;
	iCEHtmlInputTextElementProxy_ensureFocus	_ensureFocus;
	iCEHtmlInputTextElementProxy_loseFocus	_loseFocus;
	iCEHtmlInputTextElementProxy_isEditMode	_isEditMode;
	iCEHtmlInputTextElementProxy_renderBorder	_renderBorder;
	iCEHtmlInputTextElementProxy_getFormElement	_getFormElement;
	iCEHtmlInputTextElementProxy_genericEvent	_genericEvent;
	iCEHtmlInputTextElementProxy_setFormValue	_setFormValue;
	iCEHtmlInputTextElementProxy_getFormValue	_getFormValue;
	iCEHtmlInputTextElementProxy_isDisabled	_isDisabled;
	iCEHtmlInputTextElementProxy_cut	_cut;
	iCEHtmlInputTextElementProxy_copy	_copy;
	iCEHtmlInputTextElementProxy_paste	_paste;
	iCEHtmlInputTextElementProxy_selectAll	_selectAll;
	iCEHtmlInputTextElementProxy_isReadOnly	_isReadOnly;
	iCEHtmlInputTextElementProxy_getTextLength	_getTextLength;
	iCEHtmlInputTextElementProxy_isPasswordMode	_isPasswordMode;
	iCEHtmlInputTextElementProxy_setVisibleText	_setVisibleText;
};

/*! @}
 * end of ICEHtmlInputTextElementProxy
 */

/*! \defgroup ICEHtmlInputButtonElementProxy ICEHtmlInputButtonElementProxy
 * @{
 */

/*!
 * ID of ICEHtmlInputButtonElementProxy
 */
#define CEComIID_ICEHtmlInputButtonElementProxy 0x9a7e8416


/*!
 * ICEHtmlInputButtonElementProxy
 */
typedef struct ICEHtmlInputButtonElementProxy
{
	const struct ICEHtmlInputButtonElementProxy_vtbl* _vtbl;
} ICEHtmlInputButtonElementProxy;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iInputButtonElementProxy	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlInputButtonElementProxy_queryInterface) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlInputButtonElementProxy_addRef) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlInputButtonElementProxy_release) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_getElementId) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, CEHtmlElementId* elemIdOut);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_getAttributeString) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_getDocument) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, struct ICEHtmlDocument* *const iDocumentOut);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_isAvailable) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, bool *const isAvailableOut);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_getColor) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_isBackgroundTransparent) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, bool *const transparentOut);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_getBoxValue) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_getCharacterType) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, characterTypeValue* charTypeOut, imeModeValue* imeModeOut);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_getFont) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, struct ICEUICompositeFont* *const iFontOut);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_getRect) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, CEHtmlElementRectType rectType, CERect *const rectOut);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_isVisible) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, bool *const visibleOut);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_calculateBoundingRectangle) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, CERect *const rectOut);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_getBackgroundRepeat) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, CEHtmlElementRepeatType *const repeatOut);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_getTLStyles) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, CEHtmlTLStyle *const tlStyleOut);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_ensureEditMode) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_exitEditMode) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_ensureFocus) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_loseFocus) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_isEditMode) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, bool *const isEditModeOut);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_renderBorder) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, struct ICEUIGraphicsContext* iGC, CERect* borderRect);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_getFormElement) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, struct ICEHtmlFormElementProxy* *const iFormElement);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_genericEvent) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, CEHtmlEventId eventId);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_setFormValue) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, struct ICEUString* iFormStr);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_getFormValue) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, bool isDefault, struct ICEUString* *const iFormStrOut);

typedef CEHResult (*iCEHtmlInputButtonElementProxy_isDisabled) (ICEHtmlInputButtonElementProxy* iInputButtonElementProxy, bool *const disabledOut);

/*!
 * V-table of ICEHtmlInputButtonElementProxy
 */
struct ICEHtmlInputButtonElementProxy_vtbl
{
	iCEHtmlInputButtonElementProxy_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlInputButtonElementProxy_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlInputButtonElementProxy_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlInputButtonElementProxy_getElementId	_getElementId;
	iCEHtmlInputButtonElementProxy_getAttributeString	_getAttributeString;
	iCEHtmlInputButtonElementProxy_getDocument	_getDocument;
	iCEHtmlInputButtonElementProxy_isAvailable	_isAvailable;
	iCEHtmlInputButtonElementProxy_getColor	_getColor;
	iCEHtmlInputButtonElementProxy_isBackgroundTransparent	_isBackgroundTransparent;
	iCEHtmlInputButtonElementProxy_getBoxValue	_getBoxValue;
	iCEHtmlInputButtonElementProxy_getCharacterType	_getCharacterType;
	iCEHtmlInputButtonElementProxy_getFont	_getFont;
	iCEHtmlInputButtonElementProxy_getRect	_getRect;
	iCEHtmlInputButtonElementProxy_isVisible	_isVisible;
	iCEHtmlInputButtonElementProxy_calculateBoundingRectangle	_calculateBoundingRectangle;
	iCEHtmlInputButtonElementProxy_getBackgroundRepeat	_getBackgroundRepeat;
	iCEHtmlInputButtonElementProxy_getTLStyles	_getTLStyles;
	iCEHtmlInputButtonElementProxy_ensureEditMode	_ensureEditMode;
	iCEHtmlInputButtonElementProxy_exitEditMode	_exitEditMode;
	iCEHtmlInputButtonElementProxy_ensureFocus	_ensureFocus;
	iCEHtmlInputButtonElementProxy_loseFocus	_loseFocus;
	iCEHtmlInputButtonElementProxy_isEditMode	_isEditMode;
	iCEHtmlInputButtonElementProxy_renderBorder	_renderBorder;
	iCEHtmlInputButtonElementProxy_getFormElement	_getFormElement;
	iCEHtmlInputButtonElementProxy_genericEvent	_genericEvent;
	iCEHtmlInputButtonElementProxy_setFormValue	_setFormValue;
	iCEHtmlInputButtonElementProxy_getFormValue	_getFormValue;
	iCEHtmlInputButtonElementProxy_isDisabled	_isDisabled;
};

/*! @}
 * end of ICEHtmlInputButtonElementProxy
 */

/*! \defgroup ICEHtmlFileSelectElementProxy ICEHtmlFileSelectElementProxy
 * @{
 */

/*!
 * ID of ICEHtmlFileSelectElementProxy
 */
#define CEComIID_ICEHtmlFileSelectElementProxy 0x2e874e88


/*!
 * ICEHtmlFileSelectElementProxy
 */
typedef struct ICEHtmlFileSelectElementProxy
{
	const struct ICEHtmlFileSelectElementProxy_vtbl* _vtbl;
} ICEHtmlFileSelectElementProxy;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iFileSelectElementProxy	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlFileSelectElementProxy_queryInterface) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFileSelectElementProxy_addRef) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFileSelectElementProxy_release) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_getElementId) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, CEHtmlElementId* elemIdOut);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_getAttributeString) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_getDocument) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, struct ICEHtmlDocument* *const iDocumentOut);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_isAvailable) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, bool *const isAvailableOut);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_getColor) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_isBackgroundTransparent) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, bool *const transparentOut);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_getBoxValue) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_getCharacterType) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, characterTypeValue* charTypeOut, imeModeValue* imeModeOut);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_getFont) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, struct ICEUICompositeFont* *const iFontOut);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_getRect) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, CEHtmlElementRectType rectType, CERect *const rectOut);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_isVisible) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, bool *const visibleOut);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_calculateBoundingRectangle) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, CERect *const rectOut);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_getBackgroundRepeat) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, CEHtmlElementRepeatType *const repeatOut);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_getTLStyles) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, CEHtmlTLStyle *const tlStyleOut);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_ensureEditMode) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_exitEditMode) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_ensureFocus) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_loseFocus) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_isEditMode) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, bool *const isEditModeOut);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_renderBorder) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, struct ICEUIGraphicsContext* iGC, CERect* borderRect);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_getFormElement) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, struct ICEHtmlFormElementProxy* *const iFormElement);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_genericEvent) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, CEHtmlEventId eventId);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_setFormValue) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, struct ICEUString* iFormStr);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_getFormValue) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, bool isDefault, struct ICEUString* *const iFormStrOut);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_isDisabled) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, bool *const disabledOut);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_cut) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_copy) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_paste) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_selectAll) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_isReadOnly) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, bool *const readOnlyOut);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_getTextLength) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, CEHtmlElementLengthType lengthType, INT32 *const lenOut, bool *const undefinedOut);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_isPasswordMode) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, bool *const passwordModeOut);

typedef CEHResult (*iCEHtmlFileSelectElementProxy_setVisibleText) (ICEHtmlFileSelectElementProxy* iFileSelectElementProxy, struct ICEUString* visibleText);

/*!
 * V-table of ICEHtmlFileSelectElementProxy
 */
struct ICEHtmlFileSelectElementProxy_vtbl
{
	iCEHtmlFileSelectElementProxy_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlFileSelectElementProxy_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlFileSelectElementProxy_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlFileSelectElementProxy_getElementId	_getElementId;
	iCEHtmlFileSelectElementProxy_getAttributeString	_getAttributeString;
	iCEHtmlFileSelectElementProxy_getDocument	_getDocument;
	iCEHtmlFileSelectElementProxy_isAvailable	_isAvailable;
	iCEHtmlFileSelectElementProxy_getColor	_getColor;
	iCEHtmlFileSelectElementProxy_isBackgroundTransparent	_isBackgroundTransparent;
	iCEHtmlFileSelectElementProxy_getBoxValue	_getBoxValue;
	iCEHtmlFileSelectElementProxy_getCharacterType	_getCharacterType;
	iCEHtmlFileSelectElementProxy_getFont	_getFont;
	iCEHtmlFileSelectElementProxy_getRect	_getRect;
	iCEHtmlFileSelectElementProxy_isVisible	_isVisible;
	iCEHtmlFileSelectElementProxy_calculateBoundingRectangle	_calculateBoundingRectangle;
	iCEHtmlFileSelectElementProxy_getBackgroundRepeat	_getBackgroundRepeat;
	iCEHtmlFileSelectElementProxy_getTLStyles	_getTLStyles;
	iCEHtmlFileSelectElementProxy_ensureEditMode	_ensureEditMode;
	iCEHtmlFileSelectElementProxy_exitEditMode	_exitEditMode;
	iCEHtmlFileSelectElementProxy_ensureFocus	_ensureFocus;
	iCEHtmlFileSelectElementProxy_loseFocus	_loseFocus;
	iCEHtmlFileSelectElementProxy_isEditMode	_isEditMode;
	iCEHtmlFileSelectElementProxy_renderBorder	_renderBorder;
	iCEHtmlFileSelectElementProxy_getFormElement	_getFormElement;
	iCEHtmlFileSelectElementProxy_genericEvent	_genericEvent;
	iCEHtmlFileSelectElementProxy_setFormValue	_setFormValue;
	iCEHtmlFileSelectElementProxy_getFormValue	_getFormValue;
	iCEHtmlFileSelectElementProxy_isDisabled	_isDisabled;
	iCEHtmlFileSelectElementProxy_cut	_cut;
	iCEHtmlFileSelectElementProxy_copy	_copy;
	iCEHtmlFileSelectElementProxy_paste	_paste;
	iCEHtmlFileSelectElementProxy_selectAll	_selectAll;
	iCEHtmlFileSelectElementProxy_isReadOnly	_isReadOnly;
	iCEHtmlFileSelectElementProxy_getTextLength	_getTextLength;
	iCEHtmlFileSelectElementProxy_isPasswordMode	_isPasswordMode;
	iCEHtmlFileSelectElementProxy_setVisibleText	_setVisibleText;
};

/*! @}
 * end of ICEHtmlFileSelectElementProxy
 */

/*! \defgroup ICEHtmlTextAreaElementProxy ICEHtmlTextAreaElementProxy
 * @{
 */

/*!
 * ID of ICEHtmlTextAreaElementProxy
 */
#define CEComIID_ICEHtmlTextAreaElementProxy 0xf14e9385


/*!
 * ICEHtmlTextAreaElementProxy
 */
typedef struct ICEHtmlTextAreaElementProxy
{
	const struct ICEHtmlTextAreaElementProxy_vtbl* _vtbl;
} ICEHtmlTextAreaElementProxy;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iTextAreaElementProxy	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlTextAreaElementProxy_queryInterface) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlTextAreaElementProxy_addRef) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlTextAreaElementProxy_release) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_getElementId) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, CEHtmlElementId* elemIdOut);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_getAttributeString) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_getDocument) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, struct ICEHtmlDocument* *const iDocumentOut);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_isAvailable) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, bool *const isAvailableOut);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_getColor) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_isBackgroundTransparent) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, bool *const transparentOut);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_getBoxValue) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_getCharacterType) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, characterTypeValue* charTypeOut, imeModeValue* imeModeOut);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_getFont) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, struct ICEUICompositeFont* *const iFontOut);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_getRect) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, CEHtmlElementRectType rectType, CERect *const rectOut);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_isVisible) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, bool *const visibleOut);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_calculateBoundingRectangle) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, CERect *const rectOut);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_getBackgroundRepeat) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, CEHtmlElementRepeatType *const repeatOut);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_getTLStyles) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, CEHtmlTLStyle *const tlStyleOut);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_ensureEditMode) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_exitEditMode) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_ensureFocus) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_loseFocus) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_isEditMode) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, bool *const isEditModeOut);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_renderBorder) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, struct ICEUIGraphicsContext* iGC, CERect* borderRect);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_getFormElement) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, struct ICEHtmlFormElementProxy* *const iFormElement);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_genericEvent) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, CEHtmlEventId eventId);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_setFormValue) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, struct ICEUString* iFormStr);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_getFormValue) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, bool isDefault, struct ICEUString* *const iFormStrOut);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_isDisabled) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, bool *const disabledOut);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_cut) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_copy) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_paste) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_selectAll) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_isReadOnly) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, bool *const readOnlyOut);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_getDimension) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, CEDim *const dimOut);

typedef CEHResult (*iCEHtmlTextAreaElementProxy_isWrapMode) (ICEHtmlTextAreaElementProxy* iTextAreaElementProxy, bool *const isWrapModeOut);

/*!
 * V-table of ICEHtmlTextAreaElementProxy
 */
struct ICEHtmlTextAreaElementProxy_vtbl
{
	iCEHtmlTextAreaElementProxy_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlTextAreaElementProxy_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlTextAreaElementProxy_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlTextAreaElementProxy_getElementId	_getElementId;
	iCEHtmlTextAreaElementProxy_getAttributeString	_getAttributeString;
	iCEHtmlTextAreaElementProxy_getDocument	_getDocument;
	iCEHtmlTextAreaElementProxy_isAvailable	_isAvailable;
	iCEHtmlTextAreaElementProxy_getColor	_getColor;
	iCEHtmlTextAreaElementProxy_isBackgroundTransparent	_isBackgroundTransparent;
	iCEHtmlTextAreaElementProxy_getBoxValue	_getBoxValue;
	iCEHtmlTextAreaElementProxy_getCharacterType	_getCharacterType;
	iCEHtmlTextAreaElementProxy_getFont	_getFont;
	iCEHtmlTextAreaElementProxy_getRect	_getRect;
	iCEHtmlTextAreaElementProxy_isVisible	_isVisible;
	iCEHtmlTextAreaElementProxy_calculateBoundingRectangle	_calculateBoundingRectangle;
	iCEHtmlTextAreaElementProxy_getBackgroundRepeat	_getBackgroundRepeat;
	iCEHtmlTextAreaElementProxy_getTLStyles	_getTLStyles;
	iCEHtmlTextAreaElementProxy_ensureEditMode	_ensureEditMode;
	iCEHtmlTextAreaElementProxy_exitEditMode	_exitEditMode;
	iCEHtmlTextAreaElementProxy_ensureFocus	_ensureFocus;
	iCEHtmlTextAreaElementProxy_loseFocus	_loseFocus;
	iCEHtmlTextAreaElementProxy_isEditMode	_isEditMode;
	iCEHtmlTextAreaElementProxy_renderBorder	_renderBorder;
	iCEHtmlTextAreaElementProxy_getFormElement	_getFormElement;
	iCEHtmlTextAreaElementProxy_genericEvent	_genericEvent;
	iCEHtmlTextAreaElementProxy_setFormValue	_setFormValue;
	iCEHtmlTextAreaElementProxy_getFormValue	_getFormValue;
	iCEHtmlTextAreaElementProxy_isDisabled	_isDisabled;
	iCEHtmlTextAreaElementProxy_cut	_cut;
	iCEHtmlTextAreaElementProxy_copy	_copy;
	iCEHtmlTextAreaElementProxy_paste	_paste;
	iCEHtmlTextAreaElementProxy_selectAll	_selectAll;
	iCEHtmlTextAreaElementProxy_isReadOnly	_isReadOnly;
	iCEHtmlTextAreaElementProxy_getDimension	_getDimension;
	iCEHtmlTextAreaElementProxy_isWrapMode	_isWrapMode;
};

/*! @}
 * end of ICEHtmlTextAreaElementProxy
 */

/*! \defgroup ICEHtmlFormSelectableElementProxy ICEHtmlFormSelectableElementProxy
 * @{
 */

/*!
 * ID of ICEHtmlFormSelectableElementProxy
 */
#define CEComIID_ICEHtmlFormSelectableElementProxy 0xe1863bfd


/*!
 * ICEHtmlFormSelectableElementProxy
 */
typedef struct ICEHtmlFormSelectableElementProxy
{
	const struct ICEHtmlFormSelectableElementProxy_vtbl* _vtbl;
} ICEHtmlFormSelectableElementProxy;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iFormSelectableElementProxy	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlFormSelectableElementProxy_queryInterface) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFormSelectableElementProxy_addRef) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFormSelectableElementProxy_release) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_getElementId) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, CEHtmlElementId* elemIdOut);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_getAttributeString) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_getDocument) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, struct ICEHtmlDocument* *const iDocumentOut);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_isAvailable) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, bool *const isAvailableOut);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_getColor) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_isBackgroundTransparent) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, bool *const transparentOut);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_getBoxValue) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_getCharacterType) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, characterTypeValue* charTypeOut, imeModeValue* imeModeOut);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_getFont) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, struct ICEUICompositeFont* *const iFontOut);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_getRect) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, CEHtmlElementRectType rectType, CERect *const rectOut);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_isVisible) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, bool *const visibleOut);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_calculateBoundingRectangle) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, CERect *const rectOut);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_getBackgroundRepeat) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, CEHtmlElementRepeatType *const repeatOut);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_getTLStyles) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, CEHtmlTLStyle *const tlStyleOut);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_ensureEditMode) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_exitEditMode) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_ensureFocus) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_loseFocus) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_isEditMode) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, bool *const isEditModeOut);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_renderBorder) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, struct ICEUIGraphicsContext* iGC, CERect* borderRect);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_getFormElement) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, struct ICEHtmlFormElementProxy* *const iFormElement);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_genericEvent) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, CEHtmlEventId eventId);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_setFormValue) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, struct ICEUString* iFormStr);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_getFormValue) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, bool isDefault, struct ICEUString* *const iFormStrOut);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_isDisabled) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, bool *const disabledOut);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_isSelected) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, bool bDefault, bool *const isSelectedOut);

typedef CEHResult (*iCEHtmlFormSelectableElementProxy_setSelected) (ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy, bool bIsSelected);

/*!
 * V-table of ICEHtmlFormSelectableElementProxy
 */
struct ICEHtmlFormSelectableElementProxy_vtbl
{
	iCEHtmlFormSelectableElementProxy_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlFormSelectableElementProxy_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlFormSelectableElementProxy_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlFormSelectableElementProxy_getElementId	_getElementId;
	iCEHtmlFormSelectableElementProxy_getAttributeString	_getAttributeString;
	iCEHtmlFormSelectableElementProxy_getDocument	_getDocument;
	iCEHtmlFormSelectableElementProxy_isAvailable	_isAvailable;
	iCEHtmlFormSelectableElementProxy_getColor	_getColor;
	iCEHtmlFormSelectableElementProxy_isBackgroundTransparent	_isBackgroundTransparent;
	iCEHtmlFormSelectableElementProxy_getBoxValue	_getBoxValue;
	iCEHtmlFormSelectableElementProxy_getCharacterType	_getCharacterType;
	iCEHtmlFormSelectableElementProxy_getFont	_getFont;
	iCEHtmlFormSelectableElementProxy_getRect	_getRect;
	iCEHtmlFormSelectableElementProxy_isVisible	_isVisible;
	iCEHtmlFormSelectableElementProxy_calculateBoundingRectangle	_calculateBoundingRectangle;
	iCEHtmlFormSelectableElementProxy_getBackgroundRepeat	_getBackgroundRepeat;
	iCEHtmlFormSelectableElementProxy_getTLStyles	_getTLStyles;
	iCEHtmlFormSelectableElementProxy_ensureEditMode	_ensureEditMode;
	iCEHtmlFormSelectableElementProxy_exitEditMode	_exitEditMode;
	iCEHtmlFormSelectableElementProxy_ensureFocus	_ensureFocus;
	iCEHtmlFormSelectableElementProxy_loseFocus	_loseFocus;
	iCEHtmlFormSelectableElementProxy_isEditMode	_isEditMode;
	iCEHtmlFormSelectableElementProxy_renderBorder	_renderBorder;
	iCEHtmlFormSelectableElementProxy_getFormElement	_getFormElement;
	iCEHtmlFormSelectableElementProxy_genericEvent	_genericEvent;
	iCEHtmlFormSelectableElementProxy_setFormValue	_setFormValue;
	iCEHtmlFormSelectableElementProxy_getFormValue	_getFormValue;
	iCEHtmlFormSelectableElementProxy_isDisabled	_isDisabled;
	iCEHtmlFormSelectableElementProxy_isSelected	_isSelected;
	iCEHtmlFormSelectableElementProxy_setSelected	_setSelected;
};

/*! @}
 * end of ICEHtmlFormSelectableElementProxy
 */

/*! \defgroup ICEHtmlOptionElementProxy ICEHtmlOptionElementProxy
 * @{
 */

/*!
 * ID of ICEHtmlOptionElementProxy
 */
#define CEComIID_ICEHtmlOptionElementProxy 0x56f44106


/*!
 * ICEHtmlOptionElementProxy
 */
typedef struct ICEHtmlOptionElementProxy
{
	const struct ICEHtmlOptionElementProxy_vtbl* _vtbl;
} ICEHtmlOptionElementProxy;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iOptionElementProxy	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlOptionElementProxy_queryInterface) (ICEHtmlOptionElementProxy* iOptionElementProxy, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlOptionElementProxy_addRef) (ICEHtmlOptionElementProxy* iOptionElementProxy);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlOptionElementProxy_release) (ICEHtmlOptionElementProxy* iOptionElementProxy);

typedef CEHResult (*iCEHtmlOptionElementProxy_getElementId) (ICEHtmlOptionElementProxy* iOptionElementProxy, CEHtmlElementId* elemIdOut);

typedef CEHResult (*iCEHtmlOptionElementProxy_getAttributeString) (ICEHtmlOptionElementProxy* iOptionElementProxy, CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut);

typedef CEHResult (*iCEHtmlOptionElementProxy_getDocument) (ICEHtmlOptionElementProxy* iOptionElementProxy, struct ICEHtmlDocument* *const iDocumentOut);

typedef CEHResult (*iCEHtmlOptionElementProxy_isAvailable) (ICEHtmlOptionElementProxy* iOptionElementProxy, bool *const isAvailableOut);

typedef CEHResult (*iCEHtmlOptionElementProxy_getColor) (ICEHtmlOptionElementProxy* iOptionElementProxy, CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut);

typedef CEHResult (*iCEHtmlOptionElementProxy_isBackgroundTransparent) (ICEHtmlOptionElementProxy* iOptionElementProxy, bool *const transparentOut);

typedef CEHResult (*iCEHtmlOptionElementProxy_getBoxValue) (ICEHtmlOptionElementProxy* iOptionElementProxy, CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut);

typedef CEHResult (*iCEHtmlOptionElementProxy_getCharacterType) (ICEHtmlOptionElementProxy* iOptionElementProxy, characterTypeValue* charTypeOut, imeModeValue* imeModeOut);

typedef CEHResult (*iCEHtmlOptionElementProxy_getFont) (ICEHtmlOptionElementProxy* iOptionElementProxy, struct ICEUICompositeFont* *const iFontOut);

typedef CEHResult (*iCEHtmlOptionElementProxy_getRect) (ICEHtmlOptionElementProxy* iOptionElementProxy, CEHtmlElementRectType rectType, CERect *const rectOut);

typedef CEHResult (*iCEHtmlOptionElementProxy_isVisible) (ICEHtmlOptionElementProxy* iOptionElementProxy, bool *const visibleOut);

typedef CEHResult (*iCEHtmlOptionElementProxy_calculateBoundingRectangle) (ICEHtmlOptionElementProxy* iOptionElementProxy, CERect *const rectOut);

typedef CEHResult (*iCEHtmlOptionElementProxy_getBackgroundRepeat) (ICEHtmlOptionElementProxy* iOptionElementProxy, CEHtmlElementRepeatType *const repeatOut);

typedef CEHResult (*iCEHtmlOptionElementProxy_getTLStyles) (ICEHtmlOptionElementProxy* iOptionElementProxy, CEHtmlTLStyle *const tlStyleOut);

typedef CEHResult (*iCEHtmlOptionElementProxy_ensureEditMode) (ICEHtmlOptionElementProxy* iOptionElementProxy);

typedef CEHResult (*iCEHtmlOptionElementProxy_exitEditMode) (ICEHtmlOptionElementProxy* iOptionElementProxy);

typedef CEHResult (*iCEHtmlOptionElementProxy_ensureFocus) (ICEHtmlOptionElementProxy* iOptionElementProxy);

typedef CEHResult (*iCEHtmlOptionElementProxy_loseFocus) (ICEHtmlOptionElementProxy* iOptionElementProxy);

typedef CEHResult (*iCEHtmlOptionElementProxy_isEditMode) (ICEHtmlOptionElementProxy* iOptionElementProxy, bool *const isEditModeOut);

typedef CEHResult (*iCEHtmlOptionElementProxy_renderBorder) (ICEHtmlOptionElementProxy* iOptionElementProxy, struct ICEUIGraphicsContext* iGC, CERect* borderRect);

typedef CEHResult (*iCEHtmlOptionElementProxy_getFormElement) (ICEHtmlOptionElementProxy* iOptionElementProxy, struct ICEHtmlFormElementProxy* *const iFormElement);

typedef CEHResult (*iCEHtmlOptionElementProxy_genericEvent) (ICEHtmlOptionElementProxy* iOptionElementProxy, CEHtmlEventId eventId);

typedef CEHResult (*iCEHtmlOptionElementProxy_setFormValue) (ICEHtmlOptionElementProxy* iOptionElementProxy, struct ICEUString* iFormStr);

typedef CEHResult (*iCEHtmlOptionElementProxy_getFormValue) (ICEHtmlOptionElementProxy* iOptionElementProxy, bool isDefault, struct ICEUString* *const iFormStrOut);

typedef CEHResult (*iCEHtmlOptionElementProxy_isDisabled) (ICEHtmlOptionElementProxy* iOptionElementProxy, bool *const disabledOut);

typedef CEHResult (*iCEHtmlOptionElementProxy_isSelected) (ICEHtmlOptionElementProxy* iOptionElementProxy, bool bDefault, bool *const isSelectedOut);

typedef CEHResult (*iCEHtmlOptionElementProxy_setSelected) (ICEHtmlOptionElementProxy* iOptionElementProxy, bool bIsSelected);

typedef CEHResult (*iCEHtmlOptionElementProxy_getNextOption) (ICEHtmlOptionElementProxy* iOptionElementProxy, struct ICEHtmlOptionElementProxy* *const iOptionElementOut);

/*!
 * V-table of ICEHtmlOptionElementProxy
 */
struct ICEHtmlOptionElementProxy_vtbl
{
	iCEHtmlOptionElementProxy_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlOptionElementProxy_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlOptionElementProxy_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlOptionElementProxy_getElementId	_getElementId;
	iCEHtmlOptionElementProxy_getAttributeString	_getAttributeString;
	iCEHtmlOptionElementProxy_getDocument	_getDocument;
	iCEHtmlOptionElementProxy_isAvailable	_isAvailable;
	iCEHtmlOptionElementProxy_getColor	_getColor;
	iCEHtmlOptionElementProxy_isBackgroundTransparent	_isBackgroundTransparent;
	iCEHtmlOptionElementProxy_getBoxValue	_getBoxValue;
	iCEHtmlOptionElementProxy_getCharacterType	_getCharacterType;
	iCEHtmlOptionElementProxy_getFont	_getFont;
	iCEHtmlOptionElementProxy_getRect	_getRect;
	iCEHtmlOptionElementProxy_isVisible	_isVisible;
	iCEHtmlOptionElementProxy_calculateBoundingRectangle	_calculateBoundingRectangle;
	iCEHtmlOptionElementProxy_getBackgroundRepeat	_getBackgroundRepeat;
	iCEHtmlOptionElementProxy_getTLStyles	_getTLStyles;
	iCEHtmlOptionElementProxy_ensureEditMode	_ensureEditMode;
	iCEHtmlOptionElementProxy_exitEditMode	_exitEditMode;
	iCEHtmlOptionElementProxy_ensureFocus	_ensureFocus;
	iCEHtmlOptionElementProxy_loseFocus	_loseFocus;
	iCEHtmlOptionElementProxy_isEditMode	_isEditMode;
	iCEHtmlOptionElementProxy_renderBorder	_renderBorder;
	iCEHtmlOptionElementProxy_getFormElement	_getFormElement;
	iCEHtmlOptionElementProxy_genericEvent	_genericEvent;
	iCEHtmlOptionElementProxy_setFormValue	_setFormValue;
	iCEHtmlOptionElementProxy_getFormValue	_getFormValue;
	iCEHtmlOptionElementProxy_isDisabled	_isDisabled;
	iCEHtmlOptionElementProxy_isSelected	_isSelected;
	iCEHtmlOptionElementProxy_setSelected	_setSelected;
	iCEHtmlOptionElementProxy_getNextOption	_getNextOption;
};

/*! @}
 * end of ICEHtmlOptionElementProxy
 */

/*! \defgroup ICEHtmlSelectElementProxy ICEHtmlSelectElementProxy
 * @{
 */

/*!
 * ID of ICEHtmlSelectElementProxy
 */
#define CEComIID_ICEHtmlSelectElementProxy 0x99bde371


/*!
 * ICEHtmlSelectElementProxy
 */
typedef struct ICEHtmlSelectElementProxy
{
	const struct ICEHtmlSelectElementProxy_vtbl* _vtbl;
} ICEHtmlSelectElementProxy;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iSelectElementProxy	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlSelectElementProxy_queryInterface) (ICEHtmlSelectElementProxy* iSelectElementProxy, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlSelectElementProxy_addRef) (ICEHtmlSelectElementProxy* iSelectElementProxy);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlSelectElementProxy_release) (ICEHtmlSelectElementProxy* iSelectElementProxy);

typedef CEHResult (*iCEHtmlSelectElementProxy_getElementId) (ICEHtmlSelectElementProxy* iSelectElementProxy, CEHtmlElementId* elemIdOut);

typedef CEHResult (*iCEHtmlSelectElementProxy_getAttributeString) (ICEHtmlSelectElementProxy* iSelectElementProxy, CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut);

typedef CEHResult (*iCEHtmlSelectElementProxy_getDocument) (ICEHtmlSelectElementProxy* iSelectElementProxy, struct ICEHtmlDocument* *const iDocumentOut);

typedef CEHResult (*iCEHtmlSelectElementProxy_isAvailable) (ICEHtmlSelectElementProxy* iSelectElementProxy, bool *const isAvailableOut);

typedef CEHResult (*iCEHtmlSelectElementProxy_getColor) (ICEHtmlSelectElementProxy* iSelectElementProxy, CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut);

typedef CEHResult (*iCEHtmlSelectElementProxy_isBackgroundTransparent) (ICEHtmlSelectElementProxy* iSelectElementProxy, bool *const transparentOut);

typedef CEHResult (*iCEHtmlSelectElementProxy_getBoxValue) (ICEHtmlSelectElementProxy* iSelectElementProxy, CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut);

typedef CEHResult (*iCEHtmlSelectElementProxy_getCharacterType) (ICEHtmlSelectElementProxy* iSelectElementProxy, characterTypeValue* charTypeOut, imeModeValue* imeModeOut);

typedef CEHResult (*iCEHtmlSelectElementProxy_getFont) (ICEHtmlSelectElementProxy* iSelectElementProxy, struct ICEUICompositeFont* *const iFontOut);

typedef CEHResult (*iCEHtmlSelectElementProxy_getRect) (ICEHtmlSelectElementProxy* iSelectElementProxy, CEHtmlElementRectType rectType, CERect *const rectOut);

typedef CEHResult (*iCEHtmlSelectElementProxy_isVisible) (ICEHtmlSelectElementProxy* iSelectElementProxy, bool *const visibleOut);

typedef CEHResult (*iCEHtmlSelectElementProxy_calculateBoundingRectangle) (ICEHtmlSelectElementProxy* iSelectElementProxy, CERect *const rectOut);

typedef CEHResult (*iCEHtmlSelectElementProxy_getBackgroundRepeat) (ICEHtmlSelectElementProxy* iSelectElementProxy, CEHtmlElementRepeatType *const repeatOut);

typedef CEHResult (*iCEHtmlSelectElementProxy_getTLStyles) (ICEHtmlSelectElementProxy* iSelectElementProxy, CEHtmlTLStyle *const tlStyleOut);

typedef CEHResult (*iCEHtmlSelectElementProxy_ensureEditMode) (ICEHtmlSelectElementProxy* iSelectElementProxy);

typedef CEHResult (*iCEHtmlSelectElementProxy_exitEditMode) (ICEHtmlSelectElementProxy* iSelectElementProxy);

typedef CEHResult (*iCEHtmlSelectElementProxy_ensureFocus) (ICEHtmlSelectElementProxy* iSelectElementProxy);

typedef CEHResult (*iCEHtmlSelectElementProxy_loseFocus) (ICEHtmlSelectElementProxy* iSelectElementProxy);

typedef CEHResult (*iCEHtmlSelectElementProxy_isEditMode) (ICEHtmlSelectElementProxy* iSelectElementProxy, bool *const isEditModeOut);

typedef CEHResult (*iCEHtmlSelectElementProxy_renderBorder) (ICEHtmlSelectElementProxy* iSelectElementProxy, struct ICEUIGraphicsContext* iGC, CERect* borderRect);

typedef CEHResult (*iCEHtmlSelectElementProxy_getFormElement) (ICEHtmlSelectElementProxy* iSelectElementProxy, struct ICEHtmlFormElementProxy* *const iFormElement);

typedef CEHResult (*iCEHtmlSelectElementProxy_genericEvent) (ICEHtmlSelectElementProxy* iSelectElementProxy, CEHtmlEventId eventId);

typedef CEHResult (*iCEHtmlSelectElementProxy_setFormValue) (ICEHtmlSelectElementProxy* iSelectElementProxy, struct ICEUString* iFormStr);

typedef CEHResult (*iCEHtmlSelectElementProxy_getFormValue) (ICEHtmlSelectElementProxy* iSelectElementProxy, bool isDefault, struct ICEUString* *const iFormStrOut);

typedef CEHResult (*iCEHtmlSelectElementProxy_isDisabled) (ICEHtmlSelectElementProxy* iSelectElementProxy, bool *const disabledOut);

typedef CEHResult (*iCEHtmlSelectElementProxy_getListSize) (ICEHtmlSelectElementProxy* iSelectElementProxy, INT32 *const listSizeOut);

typedef CEHResult (*iCEHtmlSelectElementProxy_isMultiple) (ICEHtmlSelectElementProxy* iSelectElementProxy, bool *const isMultipleOut);

typedef CEHResult (*iCEHtmlSelectElementProxy_getFirstOptionElement) (ICEHtmlSelectElementProxy* iSelectElementProxy, struct ICEHtmlOptionElementProxy* *const iOptionElementOut);

/*!
 * V-table of ICEHtmlSelectElementProxy
 */
struct ICEHtmlSelectElementProxy_vtbl
{
	iCEHtmlSelectElementProxy_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlSelectElementProxy_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlSelectElementProxy_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlSelectElementProxy_getElementId	_getElementId;
	iCEHtmlSelectElementProxy_getAttributeString	_getAttributeString;
	iCEHtmlSelectElementProxy_getDocument	_getDocument;
	iCEHtmlSelectElementProxy_isAvailable	_isAvailable;
	iCEHtmlSelectElementProxy_getColor	_getColor;
	iCEHtmlSelectElementProxy_isBackgroundTransparent	_isBackgroundTransparent;
	iCEHtmlSelectElementProxy_getBoxValue	_getBoxValue;
	iCEHtmlSelectElementProxy_getCharacterType	_getCharacterType;
	iCEHtmlSelectElementProxy_getFont	_getFont;
	iCEHtmlSelectElementProxy_getRect	_getRect;
	iCEHtmlSelectElementProxy_isVisible	_isVisible;
	iCEHtmlSelectElementProxy_calculateBoundingRectangle	_calculateBoundingRectangle;
	iCEHtmlSelectElementProxy_getBackgroundRepeat	_getBackgroundRepeat;
	iCEHtmlSelectElementProxy_getTLStyles	_getTLStyles;
	iCEHtmlSelectElementProxy_ensureEditMode	_ensureEditMode;
	iCEHtmlSelectElementProxy_exitEditMode	_exitEditMode;
	iCEHtmlSelectElementProxy_ensureFocus	_ensureFocus;
	iCEHtmlSelectElementProxy_loseFocus	_loseFocus;
	iCEHtmlSelectElementProxy_isEditMode	_isEditMode;
	iCEHtmlSelectElementProxy_renderBorder	_renderBorder;
	iCEHtmlSelectElementProxy_getFormElement	_getFormElement;
	iCEHtmlSelectElementProxy_genericEvent	_genericEvent;
	iCEHtmlSelectElementProxy_setFormValue	_setFormValue;
	iCEHtmlSelectElementProxy_getFormValue	_getFormValue;
	iCEHtmlSelectElementProxy_isDisabled	_isDisabled;
	iCEHtmlSelectElementProxy_getListSize	_getListSize;
	iCEHtmlSelectElementProxy_isMultiple	_isMultiple;
	iCEHtmlSelectElementProxy_getFirstOptionElement	_getFirstOptionElement;
};

/*! @}
 * end of ICEHtmlSelectElementProxy
 */

/*! \defgroup ICEHtmlSelectListElementProxy ICEHtmlSelectListElementProxy
 * @{
 */

/*!
 * ID of ICEHtmlSelectListElementProxy
 */
#define CEComIID_ICEHtmlSelectListElementProxy 0x7c0d2d73

/*!
 * ICEHtmlSelectListElementProxy
 */
typedef struct ICEHtmlSelectListElementProxy
{
	const struct ICEHtmlSelectListElementProxy_vtbl* _vtbl;
} ICEHtmlSelectListElementProxy;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iSelectListElementProxy	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlSelectListElementProxy_queryInterface) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlSelectListElementProxy_addRef) (ICEHtmlSelectListElementProxy* iSelectListElementProxy);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlSelectListElementProxy_release) (ICEHtmlSelectListElementProxy* iSelectListElementProxy);

typedef CEHResult (*iCEHtmlSelectListElementProxy_getElementId) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, CEHtmlElementId* elemIdOut);

typedef CEHResult (*iCEHtmlSelectListElementProxy_getAttributeString) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut);

typedef CEHResult (*iCEHtmlSelectListElementProxy_getDocument) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, struct ICEHtmlDocument* *const iDocumentOut);

typedef CEHResult (*iCEHtmlSelectListElementProxy_isAvailable) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, bool *const isAvailableOut);

typedef CEHResult (*iCEHtmlSelectListElementProxy_getColor) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut);

typedef CEHResult (*iCEHtmlSelectListElementProxy_isBackgroundTransparent) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, bool *const transparentOut);

typedef CEHResult (*iCEHtmlSelectListElementProxy_getBoxValue) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut);

typedef CEHResult (*iCEHtmlSelectListElementProxy_getCharacterType) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, characterTypeValue* charTypeOut, imeModeValue* imeModeOut);

typedef CEHResult (*iCEHtmlSelectListElementProxy_getFont) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, struct ICEUICompositeFont* *const iFontOut);

typedef CEHResult (*iCEHtmlSelectListElementProxy_getRect) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, CEHtmlElementRectType rectType, CERect *const rectOut);

typedef CEHResult (*iCEHtmlSelectListElementProxy_isVisible) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, bool *const visibleOut);

typedef CEHResult (*iCEHtmlSelectListElementProxy_calculateBoundingRectangle) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, CERect *const rectOut);

typedef CEHResult (*iCEHtmlSelectListElementProxy_getBackgroundRepeat) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, CEHtmlElementRepeatType *const repeatOut);

typedef CEHResult (*iCEHtmlSelectListElementProxy_getTLStyles) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, CEHtmlTLStyle *const tlStyleOut);

typedef CEHResult (*iCEHtmlSelectListElementProxy_ensureEditMode) (ICEHtmlSelectListElementProxy* iSelectListElementProxy);

typedef CEHResult (*iCEHtmlSelectListElementProxy_exitEditMode) (ICEHtmlSelectListElementProxy* iSelectListElementProxy);

typedef CEHResult (*iCEHtmlSelectListElementProxy_ensureFocus) (ICEHtmlSelectListElementProxy* iSelectListElementProxy);

typedef CEHResult (*iCEHtmlSelectListElementProxy_loseFocus) (ICEHtmlSelectListElementProxy* iSelectListElementProxy);

typedef CEHResult (*iCEHtmlSelectListElementProxy_isEditMode) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, bool *const isEditModeOut);

typedef CEHResult (*iCEHtmlSelectListElementProxy_renderBorder) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, struct ICEUIGraphicsContext* iGC, CERect* borderRect);

typedef CEHResult (*iCEHtmlSelectListElementProxy_getFormElement) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, struct ICEHtmlFormElementProxy* *const iFormElement);

typedef CEHResult (*iCEHtmlSelectListElementProxy_genericEvent) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, CEHtmlEventId eventId);

typedef CEHResult (*iCEHtmlSelectListElementProxy_setFormValue) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, struct ICEUString* iFormStr);

typedef CEHResult (*iCEHtmlSelectListElementProxy_getFormValue) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, bool isDefault, struct ICEUString* *const iFormStrOut);

typedef CEHResult (*iCEHtmlSelectListElementProxy_isDisabled) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, bool *const disabledOut);

typedef CEHResult (*iCEHtmlSelectListElementProxy_getListSize) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, INT32 *const listSizeOut);

typedef CEHResult (*iCEHtmlSelectListElementProxy_isMultiple) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, bool *const isMultipleOut);

typedef CEHResult (*iCEHtmlSelectListElementProxy_getFirstOptionElement) (ICEHtmlSelectListElementProxy* iSelectListElementProxy, struct ICEHtmlOptionElementProxy* *const iOptionElementOut);

/*!
 * V-table of ICEHtmlSelectListElementProxy
 */
struct ICEHtmlSelectListElementProxy_vtbl
{
	iCEHtmlSelectListElementProxy_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlSelectListElementProxy_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlSelectListElementProxy_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlSelectListElementProxy_getElementId	_getElementId;
	iCEHtmlSelectListElementProxy_getAttributeString	_getAttributeString;
	iCEHtmlSelectListElementProxy_getDocument	_getDocument;
	iCEHtmlSelectListElementProxy_isAvailable	_isAvailable;
	iCEHtmlSelectListElementProxy_getColor	_getColor;
	iCEHtmlSelectListElementProxy_isBackgroundTransparent	_isBackgroundTransparent;
	iCEHtmlSelectListElementProxy_getBoxValue	_getBoxValue;
	iCEHtmlSelectListElementProxy_getCharacterType	_getCharacterType;
	iCEHtmlSelectListElementProxy_getFont	_getFont;
	iCEHtmlSelectListElementProxy_getRect	_getRect;
	iCEHtmlSelectListElementProxy_isVisible	_isVisible;
	iCEHtmlSelectListElementProxy_calculateBoundingRectangle	_calculateBoundingRectangle;
	iCEHtmlSelectListElementProxy_getBackgroundRepeat	_getBackgroundRepeat;
	iCEHtmlSelectListElementProxy_getTLStyles	_getTLStyles;
	iCEHtmlSelectListElementProxy_ensureEditMode	_ensureEditMode;
	iCEHtmlSelectListElementProxy_exitEditMode	_exitEditMode;
	iCEHtmlSelectListElementProxy_ensureFocus	_ensureFocus;
	iCEHtmlSelectListElementProxy_loseFocus	_loseFocus;
	iCEHtmlSelectListElementProxy_isEditMode	_isEditMode;
	iCEHtmlSelectListElementProxy_renderBorder	_renderBorder;
	iCEHtmlSelectListElementProxy_getFormElement	_getFormElement;
	iCEHtmlSelectListElementProxy_genericEvent	_genericEvent;
	iCEHtmlSelectListElementProxy_setFormValue	_setFormValue;
	iCEHtmlSelectListElementProxy_getFormValue	_getFormValue;
	iCEHtmlSelectListElementProxy_isDisabled	_isDisabled;
	iCEHtmlSelectListElementProxy_getListSize	_getListSize;
	iCEHtmlSelectListElementProxy_isMultiple	_isMultiple;
	iCEHtmlSelectListElementProxy_getFirstOptionElement	_getFirstOptionElement;
};

/*! @}
 * end of ICEHtmlSelectListElementProxy
 */

/*! \defgroup ICEHtmlSelectComboElementProxy ICEHtmlSelectComboElementProxy
 * @{
 */

/*!
 * ID of ICEHtmlSelectComboElementProxy
 */
#define CEComIID_ICEHtmlSelectComboElementProxy 0xb5b49079

/*!
 * ICEHtmlSelectComboElementProxy
 */
typedef struct ICEHtmlSelectComboElementProxy
{
	const struct ICEHtmlSelectComboElementProxy_vtbl* _vtbl;
} ICEHtmlSelectComboElementProxy;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iSelectComboElementProxy	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlSelectComboElementProxy_queryInterface) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlSelectComboElementProxy_addRef) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlSelectComboElementProxy_release) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_getElementId) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, CEHtmlElementId* elemIdOut);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_getAttributeString) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_getDocument) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, struct ICEHtmlDocument* *const iDocumentOut);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_isAvailable) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, bool *const isAvailableOut);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_getColor) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_isBackgroundTransparent) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, bool *const transparentOut);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_getBoxValue) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_getCharacterType) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, characterTypeValue* charTypeOut, imeModeValue* imeModeOut);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_getFont) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, struct ICEUICompositeFont* *const iFontOut);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_getRect) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, CEHtmlElementRectType rectType, CERect *const rectOut);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_isVisible) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, bool *const visibleOut);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_calculateBoundingRectangle) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, CERect *const rectOut);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_getBackgroundRepeat) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, CEHtmlElementRepeatType *const repeatOut);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_getTLStyles) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, CEHtmlTLStyle *const tlStyleOut);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_ensureEditMode) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_exitEditMode) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_ensureFocus) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_loseFocus) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_isEditMode) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, bool *const isEditModeOut);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_renderBorder) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, struct ICEUIGraphicsContext* iGC, CERect* borderRect);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_getFormElement) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, struct ICEHtmlFormElementProxy* *const iFormElement);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_genericEvent) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, CEHtmlEventId eventId);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_setFormValue) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, struct ICEUString* iFormStr);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_getFormValue) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, bool isDefault, struct ICEUString* *const iFormStrOut);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_isDisabled) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, bool *const disabledOut);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_getListSize) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, INT32 *const listSizeOut);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_isMultiple) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, bool *const isMultipleOut);

typedef CEHResult (*iCEHtmlSelectComboElementProxy_getFirstOptionElement) (ICEHtmlSelectComboElementProxy* iSelectComboElementProxy, struct ICEHtmlOptionElementProxy* *const iOptionElementOut);

/*!
 * V-table of ICEHtmlSelectComboElementProxy
 */
struct ICEHtmlSelectComboElementProxy_vtbl
{
	iCEHtmlSelectComboElementProxy_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlSelectComboElementProxy_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlSelectComboElementProxy_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlSelectComboElementProxy_getElementId	_getElementId;
	iCEHtmlSelectComboElementProxy_getAttributeString	_getAttributeString;
	iCEHtmlSelectComboElementProxy_getDocument	_getDocument;
	iCEHtmlSelectComboElementProxy_isAvailable	_isAvailable;
	iCEHtmlSelectComboElementProxy_getColor	_getColor;
	iCEHtmlSelectComboElementProxy_isBackgroundTransparent	_isBackgroundTransparent;
	iCEHtmlSelectComboElementProxy_getBoxValue	_getBoxValue;
	iCEHtmlSelectComboElementProxy_getCharacterType	_getCharacterType;
	iCEHtmlSelectComboElementProxy_getFont	_getFont;
	iCEHtmlSelectComboElementProxy_getRect	_getRect;
	iCEHtmlSelectComboElementProxy_isVisible	_isVisible;
	iCEHtmlSelectComboElementProxy_calculateBoundingRectangle	_calculateBoundingRectangle;
	iCEHtmlSelectComboElementProxy_getBackgroundRepeat	_getBackgroundRepeat;
	iCEHtmlSelectComboElementProxy_getTLStyles	_getTLStyles;
	iCEHtmlSelectComboElementProxy_ensureEditMode	_ensureEditMode;
	iCEHtmlSelectComboElementProxy_exitEditMode	_exitEditMode;
	iCEHtmlSelectComboElementProxy_ensureFocus	_ensureFocus;
	iCEHtmlSelectComboElementProxy_loseFocus	_loseFocus;
	iCEHtmlSelectComboElementProxy_isEditMode	_isEditMode;
	iCEHtmlSelectComboElementProxy_renderBorder	_renderBorder;
	iCEHtmlSelectComboElementProxy_getFormElement	_getFormElement;
	iCEHtmlSelectComboElementProxy_genericEvent	_genericEvent;
	iCEHtmlSelectComboElementProxy_setFormValue	_setFormValue;
	iCEHtmlSelectComboElementProxy_getFormValue	_getFormValue;
	iCEHtmlSelectComboElementProxy_isDisabled	_isDisabled;
	iCEHtmlSelectComboElementProxy_getListSize	_getListSize;
	iCEHtmlSelectComboElementProxy_isMultiple	_isMultiple;
	iCEHtmlSelectComboElementProxy_getFirstOptionElement	_getFirstOptionElement;
};

/*! @}
 * end of ICEHtmlSelectComboElementProxy
 */

/*! \defgroup ICEHtmlCheckBoxElementProxy ICEHtmlCheckBoxElementProxy
 * @{
 */

/*!
 * ID of ICEHtmlCheckBoxElementProxy
 */
#define CEComIID_ICEHtmlCheckBoxElementProxy 0x846a4cc9


/*!
 * ICEHtmlCheckBoxElementProxy
 */
typedef struct ICEHtmlCheckBoxElementProxy
{
	const struct ICEHtmlCheckBoxElementProxy_vtbl* _vtbl;
} ICEHtmlCheckBoxElementProxy;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iCheckBoxElementProxy	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlCheckBoxElementProxy_queryInterface) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlCheckBoxElementProxy_addRef) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlCheckBoxElementProxy_release) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_getElementId) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, CEHtmlElementId* elemIdOut);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_getAttributeString) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_getDocument) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, struct ICEHtmlDocument* *const iDocumentOut);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_isAvailable) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, bool *const isAvailableOut);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_getColor) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_isBackgroundTransparent) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, bool *const transparentOut);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_getBoxValue) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_getCharacterType) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, characterTypeValue* charTypeOut, imeModeValue* imeModeOut);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_getFont) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, struct ICEUICompositeFont* *const iFontOut);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_getRect) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, CEHtmlElementRectType rectType, CERect *const rectOut);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_isVisible) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, bool *const visibleOut);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_calculateBoundingRectangle) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, CERect *const rectOut);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_getBackgroundRepeat) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, CEHtmlElementRepeatType *const repeatOut);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_getTLStyles) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, CEHtmlTLStyle *const tlStyleOut);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_ensureEditMode) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_exitEditMode) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_ensureFocus) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_loseFocus) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_isEditMode) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, bool *const isEditModeOut);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_renderBorder) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, struct ICEUIGraphicsContext* iGC, CERect* borderRect);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_getFormElement) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, struct ICEHtmlFormElementProxy* *const iFormElement);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_genericEvent) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, CEHtmlEventId eventId);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_setFormValue) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, struct ICEUString* iFormStr);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_getFormValue) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, bool isDefault, struct ICEUString* *const iFormStrOut);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_isDisabled) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, bool *const disabledOut);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_isSelected) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, bool bDefault, bool *const isSelectedOut);

typedef CEHResult (*iCEHtmlCheckBoxElementProxy_setSelected) (ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy, bool bIsSelected);

/*!
 * V-table of ICEHtmlCheckBoxElementProxy
 */
struct ICEHtmlCheckBoxElementProxy_vtbl
{
	iCEHtmlCheckBoxElementProxy_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlCheckBoxElementProxy_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlCheckBoxElementProxy_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlCheckBoxElementProxy_getElementId	_getElementId;
	iCEHtmlCheckBoxElementProxy_getAttributeString	_getAttributeString;
	iCEHtmlCheckBoxElementProxy_getDocument	_getDocument;
	iCEHtmlCheckBoxElementProxy_isAvailable	_isAvailable;
	iCEHtmlCheckBoxElementProxy_getColor	_getColor;
	iCEHtmlCheckBoxElementProxy_isBackgroundTransparent	_isBackgroundTransparent;
	iCEHtmlCheckBoxElementProxy_getBoxValue	_getBoxValue;
	iCEHtmlCheckBoxElementProxy_getCharacterType	_getCharacterType;
	iCEHtmlCheckBoxElementProxy_getFont	_getFont;
	iCEHtmlCheckBoxElementProxy_getRect	_getRect;
	iCEHtmlCheckBoxElementProxy_isVisible	_isVisible;
	iCEHtmlCheckBoxElementProxy_calculateBoundingRectangle	_calculateBoundingRectangle;
	iCEHtmlCheckBoxElementProxy_getBackgroundRepeat	_getBackgroundRepeat;
	iCEHtmlCheckBoxElementProxy_getTLStyles	_getTLStyles;
	iCEHtmlCheckBoxElementProxy_ensureEditMode	_ensureEditMode;
	iCEHtmlCheckBoxElementProxy_exitEditMode	_exitEditMode;
	iCEHtmlCheckBoxElementProxy_ensureFocus	_ensureFocus;
	iCEHtmlCheckBoxElementProxy_loseFocus	_loseFocus;
	iCEHtmlCheckBoxElementProxy_isEditMode	_isEditMode;
	iCEHtmlCheckBoxElementProxy_renderBorder	_renderBorder;
	iCEHtmlCheckBoxElementProxy_getFormElement	_getFormElement;
	iCEHtmlCheckBoxElementProxy_genericEvent	_genericEvent;
	iCEHtmlCheckBoxElementProxy_setFormValue	_setFormValue;
	iCEHtmlCheckBoxElementProxy_getFormValue	_getFormValue;
	iCEHtmlCheckBoxElementProxy_isDisabled	_isDisabled;
	iCEHtmlCheckBoxElementProxy_isSelected	_isSelected;
	iCEHtmlCheckBoxElementProxy_setSelected	_setSelected;
};

/*! @}
 * end of ICEHtmlCheckBoxElementProxy
 */

/*! \defgroup ICEHtmlRadioElementProxy ICEHtmlRadioElementProxy
 * @{
 */

/*!
 * ID of ICEHtmlRadioElementProxy
 */
#define CEComIID_ICEHtmlRadioElementProxy 0x0a63b688


/*!
 * ICEHtmlRadioElementProxy
 */
typedef struct ICEHtmlRadioElementProxy
{
	const struct ICEHtmlRadioElementProxy_vtbl* _vtbl;
} ICEHtmlRadioElementProxy;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iRadioElementProxy	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlRadioElementProxy_queryInterface) (ICEHtmlRadioElementProxy* iRadioElementProxy, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlRadioElementProxy_addRef) (ICEHtmlRadioElementProxy* iRadioElementProxy);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlRadioElementProxy_release) (ICEHtmlRadioElementProxy* iRadioElementProxy);

typedef CEHResult (*iCEHtmlRadioElementProxy_getElementId) (ICEHtmlRadioElementProxy* iRadioElementProxy, CEHtmlElementId* elemIdOut);

typedef CEHResult (*iCEHtmlRadioElementProxy_getAttributeString) (ICEHtmlRadioElementProxy* iRadioElementProxy, CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut);

typedef CEHResult (*iCEHtmlRadioElementProxy_getDocument) (ICEHtmlRadioElementProxy* iRadioElementProxy, struct ICEHtmlDocument* *const iDocumentOut);

typedef CEHResult (*iCEHtmlRadioElementProxy_isAvailable) (ICEHtmlRadioElementProxy* iRadioElementProxy, bool *const isAvailableOut);

typedef CEHResult (*iCEHtmlRadioElementProxy_getColor) (ICEHtmlRadioElementProxy* iRadioElementProxy, CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut);

typedef CEHResult (*iCEHtmlRadioElementProxy_isBackgroundTransparent) (ICEHtmlRadioElementProxy* iRadioElementProxy, bool *const transparentOut);

typedef CEHResult (*iCEHtmlRadioElementProxy_getBoxValue) (ICEHtmlRadioElementProxy* iRadioElementProxy, CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut);

typedef CEHResult (*iCEHtmlRadioElementProxy_getCharacterType) (ICEHtmlRadioElementProxy* iRadioElementProxy, characterTypeValue* charTypeOut, imeModeValue* imeModeOut);

typedef CEHResult (*iCEHtmlRadioElementProxy_getFont) (ICEHtmlRadioElementProxy* iRadioElementProxy, struct ICEUICompositeFont* *const iFontOut);

typedef CEHResult (*iCEHtmlRadioElementProxy_getRect) (ICEHtmlRadioElementProxy* iRadioElementProxy, CEHtmlElementRectType rectType, CERect *const rectOut);

typedef CEHResult (*iCEHtmlRadioElementProxy_isVisible) (ICEHtmlRadioElementProxy* iRadioElementProxy, bool *const visibleOut);

typedef CEHResult (*iCEHtmlRadioElementProxy_calculateBoundingRectangle) (ICEHtmlRadioElementProxy* iRadioElementProxy, CERect *const rectOut);

typedef CEHResult (*iCEHtmlRadioElementProxy_getBackgroundRepeat) (ICEHtmlRadioElementProxy* iRadioElementProxy, CEHtmlElementRepeatType *const repeatOut);

typedef CEHResult (*iCEHtmlRadioElementProxy_getTLStyles) (ICEHtmlRadioElementProxy* iRadioElementProxy, CEHtmlTLStyle *const tlStyleOut);

typedef CEHResult (*iCEHtmlRadioElementProxy_ensureEditMode) (ICEHtmlRadioElementProxy* iRadioElementProxy);

typedef CEHResult (*iCEHtmlRadioElementProxy_exitEditMode) (ICEHtmlRadioElementProxy* iRadioElementProxy);

typedef CEHResult (*iCEHtmlRadioElementProxy_ensureFocus) (ICEHtmlRadioElementProxy* iRadioElementProxy);

typedef CEHResult (*iCEHtmlRadioElementProxy_loseFocus) (ICEHtmlRadioElementProxy* iRadioElementProxy);

typedef CEHResult (*iCEHtmlRadioElementProxy_isEditMode) (ICEHtmlRadioElementProxy* iRadioElementProxy, bool *const isEditModeOut);

typedef CEHResult (*iCEHtmlRadioElementProxy_renderBorder) (ICEHtmlRadioElementProxy* iRadioElementProxy, struct ICEUIGraphicsContext* iGC, CERect* borderRect);

typedef CEHResult (*iCEHtmlRadioElementProxy_getFormElement) (ICEHtmlRadioElementProxy* iRadioElementProxy, struct ICEHtmlFormElementProxy* *const iFormElement);

typedef CEHResult (*iCEHtmlRadioElementProxy_genericEvent) (ICEHtmlRadioElementProxy* iRadioElementProxy, CEHtmlEventId eventId);

typedef CEHResult (*iCEHtmlRadioElementProxy_setFormValue) (ICEHtmlRadioElementProxy* iRadioElementProxy, struct ICEUString* iFormStr);

typedef CEHResult (*iCEHtmlRadioElementProxy_getFormValue) (ICEHtmlRadioElementProxy* iRadioElementProxy, bool isDefault, struct ICEUString* *const iFormStrOut);

typedef CEHResult (*iCEHtmlRadioElementProxy_isDisabled) (ICEHtmlRadioElementProxy* iRadioElementProxy, bool *const disabledOut);

typedef CEHResult (*iCEHtmlRadioElementProxy_isSelected) (ICEHtmlRadioElementProxy* iRadioElementProxy, bool bDefault, bool *const isSelectedOut);

typedef CEHResult (*iCEHtmlRadioElementProxy_setSelected) (ICEHtmlRadioElementProxy* iRadioElementProxy, bool bIsSelected);

typedef CEHResult (*iCEHtmlRadioElementProxy_getName) (ICEHtmlRadioElementProxy* iRadioElementProxy, struct ICEUString* *const iNameOut);

/*!
 * V-table of ICEHtmlRadioElementProxy
 */
struct ICEHtmlRadioElementProxy_vtbl
{
	iCEHtmlRadioElementProxy_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlRadioElementProxy_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlRadioElementProxy_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlRadioElementProxy_getElementId	_getElementId;
	iCEHtmlRadioElementProxy_getAttributeString	_getAttributeString;
	iCEHtmlRadioElementProxy_getDocument	_getDocument;
	iCEHtmlRadioElementProxy_isAvailable	_isAvailable;
	iCEHtmlRadioElementProxy_getColor	_getColor;
	iCEHtmlRadioElementProxy_isBackgroundTransparent	_isBackgroundTransparent;
	iCEHtmlRadioElementProxy_getBoxValue	_getBoxValue;
	iCEHtmlRadioElementProxy_getCharacterType	_getCharacterType;
	iCEHtmlRadioElementProxy_getFont	_getFont;
	iCEHtmlRadioElementProxy_getRect	_getRect;
	iCEHtmlRadioElementProxy_isVisible	_isVisible;
	iCEHtmlRadioElementProxy_calculateBoundingRectangle	_calculateBoundingRectangle;
	iCEHtmlRadioElementProxy_getBackgroundRepeat	_getBackgroundRepeat;
	iCEHtmlRadioElementProxy_getTLStyles	_getTLStyles;
	iCEHtmlRadioElementProxy_ensureEditMode	_ensureEditMode;
	iCEHtmlRadioElementProxy_exitEditMode	_exitEditMode;
	iCEHtmlRadioElementProxy_ensureFocus	_ensureFocus;
	iCEHtmlRadioElementProxy_loseFocus	_loseFocus;
	iCEHtmlRadioElementProxy_isEditMode	_isEditMode;
	iCEHtmlRadioElementProxy_renderBorder	_renderBorder;
	iCEHtmlRadioElementProxy_getFormElement	_getFormElement;
	iCEHtmlRadioElementProxy_genericEvent	_genericEvent;
	iCEHtmlRadioElementProxy_setFormValue	_setFormValue;
	iCEHtmlRadioElementProxy_getFormValue	_getFormValue;
	iCEHtmlRadioElementProxy_isDisabled	_isDisabled;
	iCEHtmlRadioElementProxy_isSelected	_isSelected;
	iCEHtmlRadioElementProxy_setSelected	_setSelected;
	iCEHtmlRadioElementProxy_getName	_getName;
};

/*! @}
 * end of ICEHtmlRadioElementProxy
 */

/*! \defgroup ICEHtmlPluginElementProxy ICEHtmlPluginElementProxy
 * @{
 */

/*!
 * ID of ICEHtmlPluginElementProxy
 */
#define CEComIID_ICEHtmlPluginElementProxy 0x9b6168a5


/*!
 * ICEHtmPluginElementProxy
 */
typedef struct ICEHtmlPluginElementProxy
{
	const struct ICEHtmlPluginElementProxy_vtbl* _vtbl;
} ICEHtmlPluginElementProxy;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iPluginElementProxy	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlPluginElementProxy_queryInterface) (ICEHtmlPluginElementProxy* iPluginElementProxy, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlPluginElementProxy_addRef) (ICEHtmlPluginElementProxy* iPluginElementProxy);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlPluginElementProxy_release) (ICEHtmlPluginElementProxy* iPluginElementProxy);

typedef CEHResult (*iCEHtmlPluginElementProxy_getElementId) (ICEHtmlPluginElementProxy* iPluginElementProxy, CEHtmlElementId* elemIdOut);

typedef CEHResult (*iCEHtmlPluginElementProxy_getAttributeString) (ICEHtmlPluginElementProxy* iPluginElementProxy, CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut);

typedef CEHResult (*iCEHtmlPluginElementProxy_getDocument) (ICEHtmlPluginElementProxy* iPluginElementProxy, struct ICEHtmlDocument* *const iDocumentOut);

typedef CEHResult (*iCEHtmlPluginElementProxy_isAvailable) (ICEHtmlPluginElementProxy* iPluginElementProxy, bool *const isAvailableOut);

typedef CEHResult (*iCEHtmlPluginElementProxy_getColor) (ICEHtmlPluginElementProxy* iPluginElementProxy, CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut);

typedef CEHResult (*iCEHtmlPluginElementProxy_isBackgroundTransparent) (ICEHtmlPluginElementProxy* iPluginElementProxy, bool *const transparentOut);

typedef CEHResult (*iCEHtmlPluginElementProxy_getBoxValue) (ICEHtmlPluginElementProxy* iPluginElementProxy, CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut);

typedef CEHResult (*iCEHtmlPluginElementProxy_getCharacterType) (ICEHtmlPluginElementProxy* iPluginElementProxy, characterTypeValue* charTypeOut, imeModeValue* imeModeOut);

typedef CEHResult (*iCEHtmlPluginElementProxy_getFont) (ICEHtmlPluginElementProxy* iPluginElementProxy, struct ICEUICompositeFont* *const iFontOut);

typedef CEHResult (*iCEHtmlPluginElementProxy_getRect) (ICEHtmlPluginElementProxy* iPluginElementProxy, CEHtmlElementRectType rectType, CERect *const rectOut);

typedef CEHResult (*iCEHtmlPluginElementProxy_isVisible) (ICEHtmlPluginElementProxy* iPluginElementProxy, bool *const visibleOut);

typedef CEHResult (*iCEHtmlPluginElementProxy_calculateBoundingRectangle) (ICEHtmlPluginElementProxy* iPluginElementProxy, CERect *const rectOut);

typedef CEHResult (*iCEHtmlPluginElementProxy_getBackgroundRepeat) (ICEHtmlPluginElementProxy* iPluginElementProxy, CEHtmlElementRepeatType *const repeatOut);

typedef CEHResult (*iCEHtmlPluginElementProxy_getTLStyles) (ICEHtmlPluginElementProxy* iPluginElementProxy, CEHtmlTLStyle *const tlStyleOut);

typedef CEHResult (*iCEHtmlPluginElementProxy_ensureEditMode) (ICEHtmlPluginElementProxy* iPluginElementProxy);

typedef CEHResult (*iCEHtmlPluginElementProxy_exitEditMode) (ICEHtmlPluginElementProxy* iPluginElementProxy);

typedef CEHResult (*iCEHtmlPluginElementProxy_ensureFocus) (ICEHtmlPluginElementProxy* iPluginElementProxy);

typedef CEHResult (*iCEHtmlPluginElementProxy_loseFocus) (ICEHtmlPluginElementProxy* iPluginElementProxy);

typedef CEHResult (*iCEHtmlPluginElementProxy_isEditMode) (ICEHtmlPluginElementProxy* iPluginElementProxy, bool *const isEditModeOut);

typedef CEHResult (*iCEHtmlPluginElementProxy_getPluginInstance) (ICEHtmlPluginElementProxy* iPluginElementProxy, struct ICEHtmlPluginInstance* *const iPluginInstance);

typedef CEHResult (*iCEHtmlPluginElementProxy_getWindowScriptable) (ICEHtmlPluginElementProxy* iPluginElementProxy, struct ICEScriptable* *const iScriptableOut);

typedef CEHResult (*iCEHtmlPluginElementProxy_getScriptContext) (ICEHtmlPluginElementProxy* iPluginElementProxy, struct ICEScriptContext* *const iScriptContextOut);

typedef CEHResult (*iCEHtmlPluginElementProxy_getJSContext) (ICEHtmlPluginElementProxy* iPluginElementProxy, struct ICEJSContext* *const iJSContextOut);

typedef CEHResult (*iCEHtmlPluginElementProxy_postMessage) (ICEHtmlPluginElementProxy* iPluginElementProxy, struct ICEUnknown* iUnknown);

typedef CEHResult (*iCEHtmlPluginElementProxy_getScriptable) (ICEHtmlPluginElementProxy* iPluginElementProxy, struct ICEScriptable* *const iScriptableOut);

/*!
 * V-table of ICEHtmlPluginElementProxy
 */
struct ICEHtmlPluginElementProxy_vtbl
{
	iCEHtmlPluginElementProxy_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlPluginElementProxy_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlPluginElementProxy_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlPluginElementProxy_getElementId	_getElementId;
	iCEHtmlPluginElementProxy_getAttributeString	_getAttributeString;
	iCEHtmlPluginElementProxy_getDocument	_getDocument;
	iCEHtmlPluginElementProxy_isAvailable	_isAvailable;
	iCEHtmlPluginElementProxy_getColor	_getColor;
	iCEHtmlPluginElementProxy_isBackgroundTransparent	_isBackgroundTransparent;
	iCEHtmlPluginElementProxy_getBoxValue	_getBoxValue;
	iCEHtmlPluginElementProxy_getCharacterType	_getCharacterType;
	iCEHtmlPluginElementProxy_getFont	_getFont;
	iCEHtmlPluginElementProxy_getRect	_getRect;
	iCEHtmlPluginElementProxy_isVisible	_isVisible;
	iCEHtmlPluginElementProxy_calculateBoundingRectangle	_calculateBoundingRectangle;
	iCEHtmlPluginElementProxy_getBackgroundRepeat	_getBackgroundRepeat;
	iCEHtmlPluginElementProxy_getTLStyles	_getTLStyles;
	iCEHtmlPluginElementProxy_ensureEditMode	_ensureEditMode;
	iCEHtmlPluginElementProxy_exitEditMode	_exitEditMode;
	iCEHtmlPluginElementProxy_ensureFocus	_ensureFocus;
	iCEHtmlPluginElementProxy_loseFocus	_loseFocus;
	iCEHtmlPluginElementProxy_isEditMode	_isEditMode;
	iCEHtmlPluginElementProxy_getPluginInstance	_getPluginInstance;
	iCEHtmlPluginElementProxy_getWindowScriptable	_getWindowScriptable;
	iCEHtmlPluginElementProxy_getScriptContext	_getScriptContext;
	iCEHtmlPluginElementProxy_getJSContext	_getJSContext;
	iCEHtmlPluginElementProxy_postMessage	_postMessage;
	iCEHtmlPluginElementProxy_getScriptable	_getScriptable;
};

/*! @}
 * end of ICEHtmlPluginElementProxy
 */

/*! \defgroup ICEHtmlPluginElementJoint ICEHtmlPluginElementJoint
 * @{
 */

/*!
 * ID of ICEHtmlPluginElementJoint
 */
#define CEComIID_ICEHtmlPluginElementJoint 0x4002667a


/*!
 * ICEHtmlPluginElementJoint
 */
typedef struct ICEHtmlPluginElementJoint
{
	const struct ICEHtmlPluginElementJoint_vtbl* _vtbl;
} ICEHtmlPluginElementJoint;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iPluginElementJoint	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlPluginElementJoint_queryInterface) (ICEHtmlPluginElementJoint* iPluginElementJoint, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlPluginElementJoint_addRef) (ICEHtmlPluginElementJoint* iPluginElementJoint);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlPluginElementJoint_release) (ICEHtmlPluginElementJoint* iPluginElementJoint);

typedef CEHResult (*iCEHtmlPluginElementJoint_onShutdown) (ICEHtmlPluginElementJoint* iPluginElementJoint, CEHtmlShutdownType type);

/*!
 * V-table of ICEHtmlPluginElementJoint
 */
struct ICEHtmlPluginElementJoint_vtbl
{
	iCEHtmlPluginElementJoint_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlPluginElementJoint_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlPluginElementJoint_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlPluginElementJoint_onShutdown	_onShutdown;
};

/*! @}
 * end of ICEHtmlPluginElementJoint
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlElementBaseProxyRef CEComICEHtmlElementBaseProxyRef
 * @{
 */

class CEComICEHtmlElementBaseProxyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlElementBaseProxyRef() : _iElementBaseProxy(0) {}
	CEComICEHtmlElementBaseProxyRef(ICEHtmlElementBaseProxy* iOther) : _iElementBaseProxy(0)
	{
		if (iOther)
		{
			_iElementBaseProxy = iOther;
			_iElementBaseProxy->_vtbl->_addRef(_iElementBaseProxy);
		}
	}

	CEComICEHtmlElementBaseProxyRef(const CEComICEHtmlElementBaseProxyRef& other) : _iElementBaseProxy(0)
	{
		if (other._iElementBaseProxy)
		{
			_iElementBaseProxy = other._iElementBaseProxy;
			_iElementBaseProxy->_vtbl->_addRef(_iElementBaseProxy);
		}
	}

	~CEComICEHtmlElementBaseProxyRef()
	{
		if (_iElementBaseProxy)
		{
			ICEHtmlElementBaseProxy* tmp = _iElementBaseProxy;
			_iElementBaseProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlElementBaseProxy* iElementBaseProxy;
				void* _ptr;
			} uIntf;
			uIntf.iElementBaseProxy = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlElementBaseProxy, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iElementBaseProxy)
				{
					ICEHtmlElementBaseProxy* tmp = _iElementBaseProxy;
					_iElementBaseProxy = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iElementBaseProxy = uIntf.iElementBaseProxy;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlElementBaseProxy* object() const	{ return _iElementBaseProxy; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlElementBaseProxy* iOther)
	{
		if (_iElementBaseProxy)
		{
			ICEHtmlElementBaseProxy* tmp = _iElementBaseProxy;
			_iElementBaseProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iElementBaseProxy = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlElementBaseProxy* detach()
	{
		ICEHtmlElementBaseProxy* iIntf = _iElementBaseProxy;
		_iElementBaseProxy = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlElementBaseProxy* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iElementBaseProxy;
		if (_iElementBaseProxy)
		{
			_iElementBaseProxy->_vtbl->_addRef(_iElementBaseProxy);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlElementBaseProxy*() const	{ return _iElementBaseProxy; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlElementBaseProxy& operator*() const	{ return *_iElementBaseProxy; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iElementBaseProxy == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlElementBaseProxy* iOther) const	{ return (_iElementBaseProxy != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlElementBaseProxy* iOther) const	{ return (_iElementBaseProxy == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlElementBaseProxyRef& operator=(const CEComICEHtmlElementBaseProxyRef& other)	{ return operator=(other._iElementBaseProxy); }

	CEComICEHtmlElementBaseProxyRef& operator=(const ICEHtmlElementBaseProxy* iOther)
	{
		if (_iElementBaseProxy != iOther)
		{
			if (_iElementBaseProxy)
			{
				ICEHtmlElementBaseProxy* tmp = _iElementBaseProxy;
				_iElementBaseProxy = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iElementBaseProxy = const_cast<ICEHtmlElementBaseProxy*>(iOther);
			if (_iElementBaseProxy)
			{
				_iElementBaseProxy->_vtbl->_addRef(_iElementBaseProxy);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlElementBaseProxy** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlElementBaseProxyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iElementBaseProxy && "has a com object reference. clear first.");
		return & _iElementBaseProxy; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlElementBaseProxyRef& other)
	{
		bool result = false;
		if (_iElementBaseProxy)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iElementBaseProxy);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iElementBaseProxy ? _iElementBaseProxy->_vtbl->_queryInterface(_iElementBaseProxy, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iElementBaseProxy) { _iElementBaseProxy->_vtbl->_addRef(_iElementBaseProxy); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iElementBaseProxy) { _iElementBaseProxy->_vtbl->_release(_iElementBaseProxy); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementId(CEHtmlElementId* elemIdOut)	{ return _iElementBaseProxy ? _iElementBaseProxy->_vtbl->_getElementId(_iElementBaseProxy, elemIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAttributeString(CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut)	{ return _iElementBaseProxy ? _iElementBaseProxy->_vtbl->_getAttributeString(_iElementBaseProxy, attrId, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDocument(struct ICEHtmlDocument* *const iDocumentOut)	{ return _iElementBaseProxy ? _iElementBaseProxy->_vtbl->_getDocument(_iElementBaseProxy, iDocumentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isAvailable(bool *const isAvailableOut)	{ return _iElementBaseProxy ? _iElementBaseProxy->_vtbl->_isAvailable(_iElementBaseProxy, isAvailableOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlElementBaseProxy* _iElementBaseProxy;
};

/*! @}
 * end of CEComICEHtmlElementBaseProxyRef
 */

/*! \defgroup CEComICEHtmlResolvedElementProxyRef CEComICEHtmlResolvedElementProxyRef
 * @{
 */

class CEComICEHtmlResolvedElementProxyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlResolvedElementProxyRef() : _iResolvedElementProxy(0) {}
	CEComICEHtmlResolvedElementProxyRef(ICEHtmlResolvedElementProxy* iOther) : _iResolvedElementProxy(0)
	{
		if (iOther)
		{
			_iResolvedElementProxy = iOther;
			_iResolvedElementProxy->_vtbl->_addRef(_iResolvedElementProxy);
		}
	}

	CEComICEHtmlResolvedElementProxyRef(const CEComICEHtmlResolvedElementProxyRef& other) : _iResolvedElementProxy(0)
	{
		if (other._iResolvedElementProxy)
		{
			_iResolvedElementProxy = other._iResolvedElementProxy;
			_iResolvedElementProxy->_vtbl->_addRef(_iResolvedElementProxy);
		}
	}

	~CEComICEHtmlResolvedElementProxyRef()
	{
		if (_iResolvedElementProxy)
		{
			ICEHtmlResolvedElementProxy* tmp = _iResolvedElementProxy;
			_iResolvedElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlResolvedElementProxy* iResolvedElementProxy;
				void* _ptr;
			} uIntf;
			uIntf.iResolvedElementProxy = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlResolvedElementProxy, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iResolvedElementProxy)
				{
					ICEHtmlResolvedElementProxy* tmp = _iResolvedElementProxy;
					_iResolvedElementProxy = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iResolvedElementProxy = uIntf.iResolvedElementProxy;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlResolvedElementProxy* object() const	{ return _iResolvedElementProxy; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlResolvedElementProxy* iOther)
	{
		if (_iResolvedElementProxy)
		{
			ICEHtmlResolvedElementProxy* tmp = _iResolvedElementProxy;
			_iResolvedElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iResolvedElementProxy = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlResolvedElementProxy* detach()
	{
		ICEHtmlResolvedElementProxy* iIntf = _iResolvedElementProxy;
		_iResolvedElementProxy = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlResolvedElementProxy* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iResolvedElementProxy;
		if (_iResolvedElementProxy)
		{
			_iResolvedElementProxy->_vtbl->_addRef(_iResolvedElementProxy);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlResolvedElementProxy*() const	{ return _iResolvedElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlResolvedElementProxy& operator*() const	{ return *_iResolvedElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iResolvedElementProxy == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlResolvedElementProxy* iOther) const	{ return (_iResolvedElementProxy != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlResolvedElementProxy* iOther) const	{ return (_iResolvedElementProxy == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlResolvedElementProxyRef& operator=(const CEComICEHtmlResolvedElementProxyRef& other)	{ return operator=(other._iResolvedElementProxy); }

	CEComICEHtmlResolvedElementProxyRef& operator=(const ICEHtmlResolvedElementProxy* iOther)
	{
		if (_iResolvedElementProxy != iOther)
		{
			if (_iResolvedElementProxy)
			{
				ICEHtmlResolvedElementProxy* tmp = _iResolvedElementProxy;
				_iResolvedElementProxy = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iResolvedElementProxy = const_cast<ICEHtmlResolvedElementProxy*>(iOther);
			if (_iResolvedElementProxy)
			{
				_iResolvedElementProxy->_vtbl->_addRef(_iResolvedElementProxy);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlResolvedElementProxy** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlResolvedElementProxyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iResolvedElementProxy && "has a com object reference. clear first.");
		return & _iResolvedElementProxy; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlResolvedElementProxyRef& other)
	{
		bool result = false;
		if (_iResolvedElementProxy)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iResolvedElementProxy);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iResolvedElementProxy ? _iResolvedElementProxy->_vtbl->_queryInterface(_iResolvedElementProxy, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iResolvedElementProxy) { _iResolvedElementProxy->_vtbl->_addRef(_iResolvedElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iResolvedElementProxy) { _iResolvedElementProxy->_vtbl->_release(_iResolvedElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementId(CEHtmlElementId* elemIdOut)	{ return _iResolvedElementProxy ? _iResolvedElementProxy->_vtbl->_getElementId(_iResolvedElementProxy, elemIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAttributeString(CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut)	{ return _iResolvedElementProxy ? _iResolvedElementProxy->_vtbl->_getAttributeString(_iResolvedElementProxy, attrId, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDocument(struct ICEHtmlDocument* *const iDocumentOut)	{ return _iResolvedElementProxy ? _iResolvedElementProxy->_vtbl->_getDocument(_iResolvedElementProxy, iDocumentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isAvailable(bool *const isAvailableOut)	{ return _iResolvedElementProxy ? _iResolvedElementProxy->_vtbl->_isAvailable(_iResolvedElementProxy, isAvailableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getColor(CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut)	{ return _iResolvedElementProxy ? _iResolvedElementProxy->_vtbl->_getColor(_iResolvedElementProxy, colorType, colorOut, undefinedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isBackgroundTransparent(bool *const transparentOut)	{ return _iResolvedElementProxy ? _iResolvedElementProxy->_vtbl->_isBackgroundTransparent(_iResolvedElementProxy, transparentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBoxValue(CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut)	{ return _iResolvedElementProxy ? _iResolvedElementProxy->_vtbl->_getBoxValue(_iResolvedElementProxy, type, useRenderingVTPathId, insetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCharacterType(characterTypeValue* charTypeOut, imeModeValue* imeModeOut)	{ return _iResolvedElementProxy ? _iResolvedElementProxy->_vtbl->_getCharacterType(_iResolvedElementProxy, charTypeOut, imeModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFont(struct ICEUICompositeFont* *const iFontOut)	{ return _iResolvedElementProxy ? _iResolvedElementProxy->_vtbl->_getFont(_iResolvedElementProxy, iFontOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRect(CEHtmlElementRectType rectType, CERect *const rectOut)	{ return _iResolvedElementProxy ? _iResolvedElementProxy->_vtbl->_getRect(_iResolvedElementProxy, rectType, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isVisible(bool *const visibleOut)	{ return _iResolvedElementProxy ? _iResolvedElementProxy->_vtbl->_isVisible(_iResolvedElementProxy, visibleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult calculateBoundingRectangle(CERect *const rectOut)	{ return _iResolvedElementProxy ? _iResolvedElementProxy->_vtbl->_calculateBoundingRectangle(_iResolvedElementProxy, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBackgroundRepeat(CEHtmlElementRepeatType *const repeatOut)	{ return _iResolvedElementProxy ? _iResolvedElementProxy->_vtbl->_getBackgroundRepeat(_iResolvedElementProxy, repeatOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTLStyles(CEHtmlTLStyle *const tlStyleOut)	{ return _iResolvedElementProxy ? _iResolvedElementProxy->_vtbl->_getTLStyles(_iResolvedElementProxy, tlStyleOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlResolvedElementProxy* _iResolvedElementProxy;
};

/*! @}
 * end of CEComICEHtmlResolvedElementProxyRef
 */

/*! \defgroup CEComICEHtmlHierarchicalFocusElementProxyRef CEComICEHtmlHierarchicalFocusElementProxyRef
 * @{
 */

class CEComICEHtmlHierarchicalFocusElementProxyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlHierarchicalFocusElementProxyRef() : _iHierarchicalFocusElementProxy(0) {}
	CEComICEHtmlHierarchicalFocusElementProxyRef(ICEHtmlHierarchicalFocusElementProxy* iOther) : _iHierarchicalFocusElementProxy(0)
	{
		if (iOther)
		{
			_iHierarchicalFocusElementProxy = iOther;
			_iHierarchicalFocusElementProxy->_vtbl->_addRef(_iHierarchicalFocusElementProxy);
		}
	}

	CEComICEHtmlHierarchicalFocusElementProxyRef(const CEComICEHtmlHierarchicalFocusElementProxyRef& other) : _iHierarchicalFocusElementProxy(0)
	{
		if (other._iHierarchicalFocusElementProxy)
		{
			_iHierarchicalFocusElementProxy = other._iHierarchicalFocusElementProxy;
			_iHierarchicalFocusElementProxy->_vtbl->_addRef(_iHierarchicalFocusElementProxy);
		}
	}

	~CEComICEHtmlHierarchicalFocusElementProxyRef()
	{
		if (_iHierarchicalFocusElementProxy)
		{
			ICEHtmlHierarchicalFocusElementProxy* tmp = _iHierarchicalFocusElementProxy;
			_iHierarchicalFocusElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlHierarchicalFocusElementProxy* iHierarchicalFocusElementProxy;
				void* _ptr;
			} uIntf;
			uIntf.iHierarchicalFocusElementProxy = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlHierarchicalFocusElementProxy, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iHierarchicalFocusElementProxy)
				{
					ICEHtmlHierarchicalFocusElementProxy* tmp = _iHierarchicalFocusElementProxy;
					_iHierarchicalFocusElementProxy = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iHierarchicalFocusElementProxy = uIntf.iHierarchicalFocusElementProxy;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlHierarchicalFocusElementProxy* object() const	{ return _iHierarchicalFocusElementProxy; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlHierarchicalFocusElementProxy* iOther)
	{
		if (_iHierarchicalFocusElementProxy)
		{
			ICEHtmlHierarchicalFocusElementProxy* tmp = _iHierarchicalFocusElementProxy;
			_iHierarchicalFocusElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iHierarchicalFocusElementProxy = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlHierarchicalFocusElementProxy* detach()
	{
		ICEHtmlHierarchicalFocusElementProxy* iIntf = _iHierarchicalFocusElementProxy;
		_iHierarchicalFocusElementProxy = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlHierarchicalFocusElementProxy* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iHierarchicalFocusElementProxy;
		if (_iHierarchicalFocusElementProxy)
		{
			_iHierarchicalFocusElementProxy->_vtbl->_addRef(_iHierarchicalFocusElementProxy);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlHierarchicalFocusElementProxy*() const	{ return _iHierarchicalFocusElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlHierarchicalFocusElementProxy& operator*() const	{ return *_iHierarchicalFocusElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iHierarchicalFocusElementProxy == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlHierarchicalFocusElementProxy* iOther) const	{ return (_iHierarchicalFocusElementProxy != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlHierarchicalFocusElementProxy* iOther) const	{ return (_iHierarchicalFocusElementProxy == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlHierarchicalFocusElementProxyRef& operator=(const CEComICEHtmlHierarchicalFocusElementProxyRef& other)	{ return operator=(other._iHierarchicalFocusElementProxy); }

	CEComICEHtmlHierarchicalFocusElementProxyRef& operator=(const ICEHtmlHierarchicalFocusElementProxy* iOther)
	{
		if (_iHierarchicalFocusElementProxy != iOther)
		{
			if (_iHierarchicalFocusElementProxy)
			{
				ICEHtmlHierarchicalFocusElementProxy* tmp = _iHierarchicalFocusElementProxy;
				_iHierarchicalFocusElementProxy = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iHierarchicalFocusElementProxy = const_cast<ICEHtmlHierarchicalFocusElementProxy*>(iOther);
			if (_iHierarchicalFocusElementProxy)
			{
				_iHierarchicalFocusElementProxy->_vtbl->_addRef(_iHierarchicalFocusElementProxy);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlHierarchicalFocusElementProxy** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlHierarchicalFocusElementProxyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iHierarchicalFocusElementProxy && "has a com object reference. clear first.");
		return & _iHierarchicalFocusElementProxy; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlHierarchicalFocusElementProxyRef& other)
	{
		bool result = false;
		if (_iHierarchicalFocusElementProxy)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iHierarchicalFocusElementProxy);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iHierarchicalFocusElementProxy ? _iHierarchicalFocusElementProxy->_vtbl->_queryInterface(_iHierarchicalFocusElementProxy, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iHierarchicalFocusElementProxy) { _iHierarchicalFocusElementProxy->_vtbl->_addRef(_iHierarchicalFocusElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iHierarchicalFocusElementProxy) { _iHierarchicalFocusElementProxy->_vtbl->_release(_iHierarchicalFocusElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementId(CEHtmlElementId* elemIdOut)	{ return _iHierarchicalFocusElementProxy ? _iHierarchicalFocusElementProxy->_vtbl->_getElementId(_iHierarchicalFocusElementProxy, elemIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAttributeString(CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut)	{ return _iHierarchicalFocusElementProxy ? _iHierarchicalFocusElementProxy->_vtbl->_getAttributeString(_iHierarchicalFocusElementProxy, attrId, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDocument(struct ICEHtmlDocument* *const iDocumentOut)	{ return _iHierarchicalFocusElementProxy ? _iHierarchicalFocusElementProxy->_vtbl->_getDocument(_iHierarchicalFocusElementProxy, iDocumentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isAvailable(bool *const isAvailableOut)	{ return _iHierarchicalFocusElementProxy ? _iHierarchicalFocusElementProxy->_vtbl->_isAvailable(_iHierarchicalFocusElementProxy, isAvailableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getColor(CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut)	{ return _iHierarchicalFocusElementProxy ? _iHierarchicalFocusElementProxy->_vtbl->_getColor(_iHierarchicalFocusElementProxy, colorType, colorOut, undefinedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isBackgroundTransparent(bool *const transparentOut)	{ return _iHierarchicalFocusElementProxy ? _iHierarchicalFocusElementProxy->_vtbl->_isBackgroundTransparent(_iHierarchicalFocusElementProxy, transparentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBoxValue(CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut)	{ return _iHierarchicalFocusElementProxy ? _iHierarchicalFocusElementProxy->_vtbl->_getBoxValue(_iHierarchicalFocusElementProxy, type, useRenderingVTPathId, insetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCharacterType(characterTypeValue* charTypeOut, imeModeValue* imeModeOut)	{ return _iHierarchicalFocusElementProxy ? _iHierarchicalFocusElementProxy->_vtbl->_getCharacterType(_iHierarchicalFocusElementProxy, charTypeOut, imeModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFont(struct ICEUICompositeFont* *const iFontOut)	{ return _iHierarchicalFocusElementProxy ? _iHierarchicalFocusElementProxy->_vtbl->_getFont(_iHierarchicalFocusElementProxy, iFontOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRect(CEHtmlElementRectType rectType, CERect *const rectOut)	{ return _iHierarchicalFocusElementProxy ? _iHierarchicalFocusElementProxy->_vtbl->_getRect(_iHierarchicalFocusElementProxy, rectType, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isVisible(bool *const visibleOut)	{ return _iHierarchicalFocusElementProxy ? _iHierarchicalFocusElementProxy->_vtbl->_isVisible(_iHierarchicalFocusElementProxy, visibleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult calculateBoundingRectangle(CERect *const rectOut)	{ return _iHierarchicalFocusElementProxy ? _iHierarchicalFocusElementProxy->_vtbl->_calculateBoundingRectangle(_iHierarchicalFocusElementProxy, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBackgroundRepeat(CEHtmlElementRepeatType *const repeatOut)	{ return _iHierarchicalFocusElementProxy ? _iHierarchicalFocusElementProxy->_vtbl->_getBackgroundRepeat(_iHierarchicalFocusElementProxy, repeatOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTLStyles(CEHtmlTLStyle *const tlStyleOut)	{ return _iHierarchicalFocusElementProxy ? _iHierarchicalFocusElementProxy->_vtbl->_getTLStyles(_iHierarchicalFocusElementProxy, tlStyleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureEditMode()	{ return _iHierarchicalFocusElementProxy ? _iHierarchicalFocusElementProxy->_vtbl->_ensureEditMode(_iHierarchicalFocusElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult exitEditMode()	{ return _iHierarchicalFocusElementProxy ? _iHierarchicalFocusElementProxy->_vtbl->_exitEditMode(_iHierarchicalFocusElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureFocus()	{ return _iHierarchicalFocusElementProxy ? _iHierarchicalFocusElementProxy->_vtbl->_ensureFocus(_iHierarchicalFocusElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult loseFocus()	{ return _iHierarchicalFocusElementProxy ? _iHierarchicalFocusElementProxy->_vtbl->_loseFocus(_iHierarchicalFocusElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isEditMode(bool *const isEditModeOut)	{ return _iHierarchicalFocusElementProxy ? _iHierarchicalFocusElementProxy->_vtbl->_isEditMode(_iHierarchicalFocusElementProxy, isEditModeOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlHierarchicalFocusElementProxy* _iHierarchicalFocusElementProxy;
};

/*! @}
 * end of CEComICEHtmlHierarchicalFocusElementProxyRef
 */

/*! \defgroup CEComICEHtmlRadioGroupRef CEComICEHtmlRadioGroupRef
 * @{
 */

class CEComICEHtmlRadioGroupRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlRadioGroupRef() : _iRadioGroup(0) {}
	CEComICEHtmlRadioGroupRef(ICEHtmlRadioGroup* iOther) : _iRadioGroup(0)
	{
		if (iOther)
		{
			_iRadioGroup = iOther;
			_iRadioGroup->_vtbl->_addRef(_iRadioGroup);
		}
	}

	CEComICEHtmlRadioGroupRef(const CEComICEHtmlRadioGroupRef& other) : _iRadioGroup(0)
	{
		if (other._iRadioGroup)
		{
			_iRadioGroup = other._iRadioGroup;
			_iRadioGroup->_vtbl->_addRef(_iRadioGroup);
		}
	}

	~CEComICEHtmlRadioGroupRef()
	{
		if (_iRadioGroup)
		{
			ICEHtmlRadioGroup* tmp = _iRadioGroup;
			_iRadioGroup = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlRadioGroup* iRadioGroup;
				void* _ptr;
			} uIntf;
			uIntf.iRadioGroup = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlRadioGroup, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iRadioGroup)
				{
					ICEHtmlRadioGroup* tmp = _iRadioGroup;
					_iRadioGroup = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iRadioGroup = uIntf.iRadioGroup;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlRadioGroup* object() const	{ return _iRadioGroup; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlRadioGroup* iOther)
	{
		if (_iRadioGroup)
		{
			ICEHtmlRadioGroup* tmp = _iRadioGroup;
			_iRadioGroup = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iRadioGroup = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlRadioGroup* detach()
	{
		ICEHtmlRadioGroup* iIntf = _iRadioGroup;
		_iRadioGroup = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlRadioGroup* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iRadioGroup;
		if (_iRadioGroup)
		{
			_iRadioGroup->_vtbl->_addRef(_iRadioGroup);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlRadioGroup*() const	{ return _iRadioGroup; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlRadioGroup& operator*() const	{ return *_iRadioGroup; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iRadioGroup == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlRadioGroup* iOther) const	{ return (_iRadioGroup != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlRadioGroup* iOther) const	{ return (_iRadioGroup == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlRadioGroupRef& operator=(const CEComICEHtmlRadioGroupRef& other)	{ return operator=(other._iRadioGroup); }

	CEComICEHtmlRadioGroupRef& operator=(const ICEHtmlRadioGroup* iOther)
	{
		if (_iRadioGroup != iOther)
		{
			if (_iRadioGroup)
			{
				ICEHtmlRadioGroup* tmp = _iRadioGroup;
				_iRadioGroup = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iRadioGroup = const_cast<ICEHtmlRadioGroup*>(iOther);
			if (_iRadioGroup)
			{
				_iRadioGroup->_vtbl->_addRef(_iRadioGroup);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlRadioGroup** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlRadioGroupRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iRadioGroup && "has a com object reference. clear first.");
		return & _iRadioGroup; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlRadioGroupRef& other)
	{
		bool result = false;
		if (_iRadioGroup)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iRadioGroup);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iRadioGroup ? _iRadioGroup->_vtbl->_queryInterface(_iRadioGroup, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iRadioGroup) { _iRadioGroup->_vtbl->_addRef(_iRadioGroup); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iRadioGroup) { _iRadioGroup->_vtbl->_release(_iRadioGroup); } }


private:
	ICEHtmlRadioGroup* _iRadioGroup;
};

/*! @}
 * end of CEComICEHtmlRadioGroupRef
 */

/*! \defgroup CEComICEHtmlFormElementProxyRef CEComICEHtmlFormElementProxyRef
 * @{
 */

class CEComICEHtmlFormElementProxyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlFormElementProxyRef() : _iFormElementProxy(0) {}
	CEComICEHtmlFormElementProxyRef(ICEHtmlFormElementProxy* iOther) : _iFormElementProxy(0)
	{
		if (iOther)
		{
			_iFormElementProxy = iOther;
			_iFormElementProxy->_vtbl->_addRef(_iFormElementProxy);
		}
	}

	CEComICEHtmlFormElementProxyRef(const CEComICEHtmlFormElementProxyRef& other) : _iFormElementProxy(0)
	{
		if (other._iFormElementProxy)
		{
			_iFormElementProxy = other._iFormElementProxy;
			_iFormElementProxy->_vtbl->_addRef(_iFormElementProxy);
		}
	}

	~CEComICEHtmlFormElementProxyRef()
	{
		if (_iFormElementProxy)
		{
			ICEHtmlFormElementProxy* tmp = _iFormElementProxy;
			_iFormElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlFormElementProxy* iFormElementProxy;
				void* _ptr;
			} uIntf;
			uIntf.iFormElementProxy = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlFormElementProxy, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iFormElementProxy)
				{
					ICEHtmlFormElementProxy* tmp = _iFormElementProxy;
					_iFormElementProxy = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iFormElementProxy = uIntf.iFormElementProxy;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFormElementProxy* object() const	{ return _iFormElementProxy; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlFormElementProxy* iOther)
	{
		if (_iFormElementProxy)
		{
			ICEHtmlFormElementProxy* tmp = _iFormElementProxy;
			_iFormElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iFormElementProxy = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlFormElementProxy* detach()
	{
		ICEHtmlFormElementProxy* iIntf = _iFormElementProxy;
		_iFormElementProxy = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlFormElementProxy* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iFormElementProxy;
		if (_iFormElementProxy)
		{
			_iFormElementProxy->_vtbl->_addRef(_iFormElementProxy);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlFormElementProxy*() const	{ return _iFormElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFormElementProxy& operator*() const	{ return *_iFormElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iFormElementProxy == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlFormElementProxy* iOther) const	{ return (_iFormElementProxy != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlFormElementProxy* iOther) const	{ return (_iFormElementProxy == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlFormElementProxyRef& operator=(const CEComICEHtmlFormElementProxyRef& other)	{ return operator=(other._iFormElementProxy); }

	CEComICEHtmlFormElementProxyRef& operator=(const ICEHtmlFormElementProxy* iOther)
	{
		if (_iFormElementProxy != iOther)
		{
			if (_iFormElementProxy)
			{
				ICEHtmlFormElementProxy* tmp = _iFormElementProxy;
				_iFormElementProxy = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iFormElementProxy = const_cast<ICEHtmlFormElementProxy*>(iOther);
			if (_iFormElementProxy)
			{
				_iFormElementProxy->_vtbl->_addRef(_iFormElementProxy);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFormElementProxy** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlFormElementProxyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iFormElementProxy && "has a com object reference. clear first.");
		return & _iFormElementProxy; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlFormElementProxyRef& other)
	{
		bool result = false;
		if (_iFormElementProxy)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iFormElementProxy);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iFormElementProxy ? _iFormElementProxy->_vtbl->_queryInterface(_iFormElementProxy, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iFormElementProxy) { _iFormElementProxy->_vtbl->_addRef(_iFormElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iFormElementProxy) { _iFormElementProxy->_vtbl->_release(_iFormElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementId(CEHtmlElementId* elemIdOut)	{ return _iFormElementProxy ? _iFormElementProxy->_vtbl->_getElementId(_iFormElementProxy, elemIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAttributeString(CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut)	{ return _iFormElementProxy ? _iFormElementProxy->_vtbl->_getAttributeString(_iFormElementProxy, attrId, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDocument(struct ICEHtmlDocument* *const iDocumentOut)	{ return _iFormElementProxy ? _iFormElementProxy->_vtbl->_getDocument(_iFormElementProxy, iDocumentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isAvailable(bool *const isAvailableOut)	{ return _iFormElementProxy ? _iFormElementProxy->_vtbl->_isAvailable(_iFormElementProxy, isAvailableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getColor(CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut)	{ return _iFormElementProxy ? _iFormElementProxy->_vtbl->_getColor(_iFormElementProxy, colorType, colorOut, undefinedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isBackgroundTransparent(bool *const transparentOut)	{ return _iFormElementProxy ? _iFormElementProxy->_vtbl->_isBackgroundTransparent(_iFormElementProxy, transparentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBoxValue(CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut)	{ return _iFormElementProxy ? _iFormElementProxy->_vtbl->_getBoxValue(_iFormElementProxy, type, useRenderingVTPathId, insetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCharacterType(characterTypeValue* charTypeOut, imeModeValue* imeModeOut)	{ return _iFormElementProxy ? _iFormElementProxy->_vtbl->_getCharacterType(_iFormElementProxy, charTypeOut, imeModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFont(struct ICEUICompositeFont* *const iFontOut)	{ return _iFormElementProxy ? _iFormElementProxy->_vtbl->_getFont(_iFormElementProxy, iFontOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRect(CEHtmlElementRectType rectType, CERect *const rectOut)	{ return _iFormElementProxy ? _iFormElementProxy->_vtbl->_getRect(_iFormElementProxy, rectType, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isVisible(bool *const visibleOut)	{ return _iFormElementProxy ? _iFormElementProxy->_vtbl->_isVisible(_iFormElementProxy, visibleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult calculateBoundingRectangle(CERect *const rectOut)	{ return _iFormElementProxy ? _iFormElementProxy->_vtbl->_calculateBoundingRectangle(_iFormElementProxy, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBackgroundRepeat(CEHtmlElementRepeatType *const repeatOut)	{ return _iFormElementProxy ? _iFormElementProxy->_vtbl->_getBackgroundRepeat(_iFormElementProxy, repeatOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTLStyles(CEHtmlTLStyle *const tlStyleOut)	{ return _iFormElementProxy ? _iFormElementProxy->_vtbl->_getTLStyles(_iFormElementProxy, tlStyleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRadioGroupFromName(struct ICEUString* iName, struct ICEHtmlRadioGroup* *const iRadioGroupOut)	{ return _iFormElementProxy ? _iFormElementProxy->_vtbl->_getRadioGroupFromName(_iFormElementProxy, iName, iRadioGroupOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult addRadioGroupFromName(struct ICEUString* iName, struct ICEHtmlRadioGroup* iRadioGroup)	{ return _iFormElementProxy ? _iFormElementProxy->_vtbl->_addRadioGroupFromName(_iFormElementProxy, iName, iRadioGroup) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult updateRadioGroup(struct ICEHtmlRadioGroup* iRadioGroup)	{ return _iFormElementProxy ? _iFormElementProxy->_vtbl->_updateRadioGroup(_iFormElementProxy, iRadioGroup) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult submit()	{ return _iFormElementProxy ? _iFormElementProxy->_vtbl->_submit(_iFormElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult reset()	{ return _iFormElementProxy ? _iFormElementProxy->_vtbl->_reset(_iFormElementProxy) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlFormElementProxy* _iFormElementProxy;
};

/*! @}
 * end of CEComICEHtmlFormElementProxyRef
 */

/*! \defgroup CEComICEHtmlFormControlElementProxyRef CEComICEHtmlFormControlElementProxyRef
 * @{
 */

class CEComICEHtmlFormControlElementProxyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlFormControlElementProxyRef() : _iFormControlElementProxy(0) {}
	CEComICEHtmlFormControlElementProxyRef(ICEHtmlFormControlElementProxy* iOther) : _iFormControlElementProxy(0)
	{
		if (iOther)
		{
			_iFormControlElementProxy = iOther;
			_iFormControlElementProxy->_vtbl->_addRef(_iFormControlElementProxy);
		}
	}

	CEComICEHtmlFormControlElementProxyRef(const CEComICEHtmlFormControlElementProxyRef& other) : _iFormControlElementProxy(0)
	{
		if (other._iFormControlElementProxy)
		{
			_iFormControlElementProxy = other._iFormControlElementProxy;
			_iFormControlElementProxy->_vtbl->_addRef(_iFormControlElementProxy);
		}
	}

	~CEComICEHtmlFormControlElementProxyRef()
	{
		if (_iFormControlElementProxy)
		{
			ICEHtmlFormControlElementProxy* tmp = _iFormControlElementProxy;
			_iFormControlElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlFormControlElementProxy* iFormControlElementProxy;
				void* _ptr;
			} uIntf;
			uIntf.iFormControlElementProxy = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlFormControlElementProxy, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iFormControlElementProxy)
				{
					ICEHtmlFormControlElementProxy* tmp = _iFormControlElementProxy;
					_iFormControlElementProxy = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iFormControlElementProxy = uIntf.iFormControlElementProxy;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFormControlElementProxy* object() const	{ return _iFormControlElementProxy; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlFormControlElementProxy* iOther)
	{
		if (_iFormControlElementProxy)
		{
			ICEHtmlFormControlElementProxy* tmp = _iFormControlElementProxy;
			_iFormControlElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iFormControlElementProxy = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlFormControlElementProxy* detach()
	{
		ICEHtmlFormControlElementProxy* iIntf = _iFormControlElementProxy;
		_iFormControlElementProxy = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlFormControlElementProxy* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iFormControlElementProxy;
		if (_iFormControlElementProxy)
		{
			_iFormControlElementProxy->_vtbl->_addRef(_iFormControlElementProxy);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlFormControlElementProxy*() const	{ return _iFormControlElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFormControlElementProxy& operator*() const	{ return *_iFormControlElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iFormControlElementProxy == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlFormControlElementProxy* iOther) const	{ return (_iFormControlElementProxy != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlFormControlElementProxy* iOther) const	{ return (_iFormControlElementProxy == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlFormControlElementProxyRef& operator=(const CEComICEHtmlFormControlElementProxyRef& other)	{ return operator=(other._iFormControlElementProxy); }

	CEComICEHtmlFormControlElementProxyRef& operator=(const ICEHtmlFormControlElementProxy* iOther)
	{
		if (_iFormControlElementProxy != iOther)
		{
			if (_iFormControlElementProxy)
			{
				ICEHtmlFormControlElementProxy* tmp = _iFormControlElementProxy;
				_iFormControlElementProxy = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iFormControlElementProxy = const_cast<ICEHtmlFormControlElementProxy*>(iOther);
			if (_iFormControlElementProxy)
			{
				_iFormControlElementProxy->_vtbl->_addRef(_iFormControlElementProxy);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFormControlElementProxy** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlFormControlElementProxyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iFormControlElementProxy && "has a com object reference. clear first.");
		return & _iFormControlElementProxy; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlFormControlElementProxyRef& other)
	{
		bool result = false;
		if (_iFormControlElementProxy)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iFormControlElementProxy);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_queryInterface(_iFormControlElementProxy, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iFormControlElementProxy) { _iFormControlElementProxy->_vtbl->_addRef(_iFormControlElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iFormControlElementProxy) { _iFormControlElementProxy->_vtbl->_release(_iFormControlElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementId(CEHtmlElementId* elemIdOut)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_getElementId(_iFormControlElementProxy, elemIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAttributeString(CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_getAttributeString(_iFormControlElementProxy, attrId, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDocument(struct ICEHtmlDocument* *const iDocumentOut)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_getDocument(_iFormControlElementProxy, iDocumentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isAvailable(bool *const isAvailableOut)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_isAvailable(_iFormControlElementProxy, isAvailableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getColor(CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_getColor(_iFormControlElementProxy, colorType, colorOut, undefinedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isBackgroundTransparent(bool *const transparentOut)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_isBackgroundTransparent(_iFormControlElementProxy, transparentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBoxValue(CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_getBoxValue(_iFormControlElementProxy, type, useRenderingVTPathId, insetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCharacterType(characterTypeValue* charTypeOut, imeModeValue* imeModeOut)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_getCharacterType(_iFormControlElementProxy, charTypeOut, imeModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFont(struct ICEUICompositeFont* *const iFontOut)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_getFont(_iFormControlElementProxy, iFontOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRect(CEHtmlElementRectType rectType, CERect *const rectOut)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_getRect(_iFormControlElementProxy, rectType, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isVisible(bool *const visibleOut)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_isVisible(_iFormControlElementProxy, visibleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult calculateBoundingRectangle(CERect *const rectOut)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_calculateBoundingRectangle(_iFormControlElementProxy, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBackgroundRepeat(CEHtmlElementRepeatType *const repeatOut)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_getBackgroundRepeat(_iFormControlElementProxy, repeatOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTLStyles(CEHtmlTLStyle *const tlStyleOut)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_getTLStyles(_iFormControlElementProxy, tlStyleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureEditMode()	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_ensureEditMode(_iFormControlElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult exitEditMode()	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_exitEditMode(_iFormControlElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureFocus()	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_ensureFocus(_iFormControlElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult loseFocus()	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_loseFocus(_iFormControlElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isEditMode(bool *const isEditModeOut)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_isEditMode(_iFormControlElementProxy, isEditModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult renderBorder(struct ICEUIGraphicsContext* iGC, CERect* borderRect)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_renderBorder(_iFormControlElementProxy, iGC, borderRect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormElement(struct ICEHtmlFormElementProxy* *const iFormElement)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_getFormElement(_iFormControlElementProxy, iFormElement) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult genericEvent(CEHtmlEventId eventId)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_genericEvent(_iFormControlElementProxy, eventId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFormValue(struct ICEUString* iFormStr)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_setFormValue(_iFormControlElementProxy, iFormStr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormValue(bool isDefault, struct ICEUString* *const iFormStrOut)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_getFormValue(_iFormControlElementProxy, isDefault, iFormStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isDisabled(bool *const disabledOut)	{ return _iFormControlElementProxy ? _iFormControlElementProxy->_vtbl->_isDisabled(_iFormControlElementProxy, disabledOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlFormControlElementProxy* _iFormControlElementProxy;
};

/*! @}
 * end of CEComICEHtmlFormControlElementProxyRef
 */

/*! \defgroup CEComICEHtmlButtonElementProxyRef CEComICEHtmlButtonElementProxyRef
 * @{
 */

class CEComICEHtmlButtonElementProxyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlButtonElementProxyRef() : _iButtonElementProxy(0) {}
	CEComICEHtmlButtonElementProxyRef(ICEHtmlButtonElementProxy* iOther) : _iButtonElementProxy(0)
	{
		if (iOther)
		{
			_iButtonElementProxy = iOther;
			_iButtonElementProxy->_vtbl->_addRef(_iButtonElementProxy);
		}
	}

	CEComICEHtmlButtonElementProxyRef(const CEComICEHtmlButtonElementProxyRef& other) : _iButtonElementProxy(0)
	{
		if (other._iButtonElementProxy)
		{
			_iButtonElementProxy = other._iButtonElementProxy;
			_iButtonElementProxy->_vtbl->_addRef(_iButtonElementProxy);
		}
	}

	~CEComICEHtmlButtonElementProxyRef()
	{
		if (_iButtonElementProxy)
		{
			ICEHtmlButtonElementProxy* tmp = _iButtonElementProxy;
			_iButtonElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlButtonElementProxy* iButtonElementProxy;
				void* _ptr;
			} uIntf;
			uIntf.iButtonElementProxy = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlButtonElementProxy, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iButtonElementProxy)
				{
					ICEHtmlButtonElementProxy* tmp = _iButtonElementProxy;
					_iButtonElementProxy = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iButtonElementProxy = uIntf.iButtonElementProxy;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlButtonElementProxy* object() const	{ return _iButtonElementProxy; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlButtonElementProxy* iOther)
	{
		if (_iButtonElementProxy)
		{
			ICEHtmlButtonElementProxy* tmp = _iButtonElementProxy;
			_iButtonElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iButtonElementProxy = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlButtonElementProxy* detach()
	{
		ICEHtmlButtonElementProxy* iIntf = _iButtonElementProxy;
		_iButtonElementProxy = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlButtonElementProxy* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iButtonElementProxy;
		if (_iButtonElementProxy)
		{
			_iButtonElementProxy->_vtbl->_addRef(_iButtonElementProxy);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlButtonElementProxy*() const	{ return _iButtonElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlButtonElementProxy& operator*() const	{ return *_iButtonElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iButtonElementProxy == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlButtonElementProxy* iOther) const	{ return (_iButtonElementProxy != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlButtonElementProxy* iOther) const	{ return (_iButtonElementProxy == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlButtonElementProxyRef& operator=(const CEComICEHtmlButtonElementProxyRef& other)	{ return operator=(other._iButtonElementProxy); }

	CEComICEHtmlButtonElementProxyRef& operator=(const ICEHtmlButtonElementProxy* iOther)
	{
		if (_iButtonElementProxy != iOther)
		{
			if (_iButtonElementProxy)
			{
				ICEHtmlButtonElementProxy* tmp = _iButtonElementProxy;
				_iButtonElementProxy = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iButtonElementProxy = const_cast<ICEHtmlButtonElementProxy*>(iOther);
			if (_iButtonElementProxy)
			{
				_iButtonElementProxy->_vtbl->_addRef(_iButtonElementProxy);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlButtonElementProxy** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlButtonElementProxyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iButtonElementProxy && "has a com object reference. clear first.");
		return & _iButtonElementProxy; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlButtonElementProxyRef& other)
	{
		bool result = false;
		if (_iButtonElementProxy)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iButtonElementProxy);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_queryInterface(_iButtonElementProxy, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iButtonElementProxy) { _iButtonElementProxy->_vtbl->_addRef(_iButtonElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iButtonElementProxy) { _iButtonElementProxy->_vtbl->_release(_iButtonElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementId(CEHtmlElementId* elemIdOut)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_getElementId(_iButtonElementProxy, elemIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAttributeString(CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_getAttributeString(_iButtonElementProxy, attrId, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDocument(struct ICEHtmlDocument* *const iDocumentOut)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_getDocument(_iButtonElementProxy, iDocumentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isAvailable(bool *const isAvailableOut)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_isAvailable(_iButtonElementProxy, isAvailableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getColor(CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_getColor(_iButtonElementProxy, colorType, colorOut, undefinedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isBackgroundTransparent(bool *const transparentOut)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_isBackgroundTransparent(_iButtonElementProxy, transparentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBoxValue(CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_getBoxValue(_iButtonElementProxy, type, useRenderingVTPathId, insetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCharacterType(characterTypeValue* charTypeOut, imeModeValue* imeModeOut)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_getCharacterType(_iButtonElementProxy, charTypeOut, imeModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFont(struct ICEUICompositeFont* *const iFontOut)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_getFont(_iButtonElementProxy, iFontOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRect(CEHtmlElementRectType rectType, CERect *const rectOut)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_getRect(_iButtonElementProxy, rectType, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isVisible(bool *const visibleOut)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_isVisible(_iButtonElementProxy, visibleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult calculateBoundingRectangle(CERect *const rectOut)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_calculateBoundingRectangle(_iButtonElementProxy, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBackgroundRepeat(CEHtmlElementRepeatType *const repeatOut)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_getBackgroundRepeat(_iButtonElementProxy, repeatOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTLStyles(CEHtmlTLStyle *const tlStyleOut)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_getTLStyles(_iButtonElementProxy, tlStyleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureEditMode()	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_ensureEditMode(_iButtonElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult exitEditMode()	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_exitEditMode(_iButtonElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureFocus()	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_ensureFocus(_iButtonElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult loseFocus()	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_loseFocus(_iButtonElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isEditMode(bool *const isEditModeOut)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_isEditMode(_iButtonElementProxy, isEditModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult renderBorder(struct ICEUIGraphicsContext* iGC, CERect* borderRect)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_renderBorder(_iButtonElementProxy, iGC, borderRect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormElement(struct ICEHtmlFormElementProxy* *const iFormElement)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_getFormElement(_iButtonElementProxy, iFormElement) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult genericEvent(CEHtmlEventId eventId)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_genericEvent(_iButtonElementProxy, eventId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFormValue(struct ICEUString* iFormStr)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_setFormValue(_iButtonElementProxy, iFormStr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormValue(bool isDefault, struct ICEUString* *const iFormStrOut)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_getFormValue(_iButtonElementProxy, isDefault, iFormStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isDisabled(bool *const disabledOut)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_isDisabled(_iButtonElementProxy, disabledOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult renderButton(struct ICEUIGraphicsContext* iGC, bool isButtonDown)	{ return _iButtonElementProxy ? _iButtonElementProxy->_vtbl->_renderButton(_iButtonElementProxy, iGC, isButtonDown) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlButtonElementProxy* _iButtonElementProxy;
};

/*! @}
 * end of CEComICEHtmlButtonElementProxyRef
 */

/*! \defgroup CEComICEHtmlTextControlElementProxyRef CEComICEHtmlTextControlElementProxyRef
 * @{
 */

class CEComICEHtmlTextControlElementProxyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlTextControlElementProxyRef() : _iTextControlElementProxy(0) {}
	CEComICEHtmlTextControlElementProxyRef(ICEHtmlTextControlElementProxy* iOther) : _iTextControlElementProxy(0)
	{
		if (iOther)
		{
			_iTextControlElementProxy = iOther;
			_iTextControlElementProxy->_vtbl->_addRef(_iTextControlElementProxy);
		}
	}

	CEComICEHtmlTextControlElementProxyRef(const CEComICEHtmlTextControlElementProxyRef& other) : _iTextControlElementProxy(0)
	{
		if (other._iTextControlElementProxy)
		{
			_iTextControlElementProxy = other._iTextControlElementProxy;
			_iTextControlElementProxy->_vtbl->_addRef(_iTextControlElementProxy);
		}
	}

	~CEComICEHtmlTextControlElementProxyRef()
	{
		if (_iTextControlElementProxy)
		{
			ICEHtmlTextControlElementProxy* tmp = _iTextControlElementProxy;
			_iTextControlElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlTextControlElementProxy* iTextControlElementProxy;
				void* _ptr;
			} uIntf;
			uIntf.iTextControlElementProxy = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlTextControlElementProxy, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iTextControlElementProxy)
				{
					ICEHtmlTextControlElementProxy* tmp = _iTextControlElementProxy;
					_iTextControlElementProxy = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iTextControlElementProxy = uIntf.iTextControlElementProxy;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlTextControlElementProxy* object() const	{ return _iTextControlElementProxy; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlTextControlElementProxy* iOther)
	{
		if (_iTextControlElementProxy)
		{
			ICEHtmlTextControlElementProxy* tmp = _iTextControlElementProxy;
			_iTextControlElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iTextControlElementProxy = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlTextControlElementProxy* detach()
	{
		ICEHtmlTextControlElementProxy* iIntf = _iTextControlElementProxy;
		_iTextControlElementProxy = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlTextControlElementProxy* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iTextControlElementProxy;
		if (_iTextControlElementProxy)
		{
			_iTextControlElementProxy->_vtbl->_addRef(_iTextControlElementProxy);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlTextControlElementProxy*() const	{ return _iTextControlElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlTextControlElementProxy& operator*() const	{ return *_iTextControlElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iTextControlElementProxy == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlTextControlElementProxy* iOther) const	{ return (_iTextControlElementProxy != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlTextControlElementProxy* iOther) const	{ return (_iTextControlElementProxy == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlTextControlElementProxyRef& operator=(const CEComICEHtmlTextControlElementProxyRef& other)	{ return operator=(other._iTextControlElementProxy); }

	CEComICEHtmlTextControlElementProxyRef& operator=(const ICEHtmlTextControlElementProxy* iOther)
	{
		if (_iTextControlElementProxy != iOther)
		{
			if (_iTextControlElementProxy)
			{
				ICEHtmlTextControlElementProxy* tmp = _iTextControlElementProxy;
				_iTextControlElementProxy = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iTextControlElementProxy = const_cast<ICEHtmlTextControlElementProxy*>(iOther);
			if (_iTextControlElementProxy)
			{
				_iTextControlElementProxy->_vtbl->_addRef(_iTextControlElementProxy);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlTextControlElementProxy** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlTextControlElementProxyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iTextControlElementProxy && "has a com object reference. clear first.");
		return & _iTextControlElementProxy; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlTextControlElementProxyRef& other)
	{
		bool result = false;
		if (_iTextControlElementProxy)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iTextControlElementProxy);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_queryInterface(_iTextControlElementProxy, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iTextControlElementProxy) { _iTextControlElementProxy->_vtbl->_addRef(_iTextControlElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iTextControlElementProxy) { _iTextControlElementProxy->_vtbl->_release(_iTextControlElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementId(CEHtmlElementId* elemIdOut)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_getElementId(_iTextControlElementProxy, elemIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAttributeString(CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_getAttributeString(_iTextControlElementProxy, attrId, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDocument(struct ICEHtmlDocument* *const iDocumentOut)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_getDocument(_iTextControlElementProxy, iDocumentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isAvailable(bool *const isAvailableOut)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_isAvailable(_iTextControlElementProxy, isAvailableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getColor(CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_getColor(_iTextControlElementProxy, colorType, colorOut, undefinedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isBackgroundTransparent(bool *const transparentOut)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_isBackgroundTransparent(_iTextControlElementProxy, transparentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBoxValue(CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_getBoxValue(_iTextControlElementProxy, type, useRenderingVTPathId, insetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCharacterType(characterTypeValue* charTypeOut, imeModeValue* imeModeOut)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_getCharacterType(_iTextControlElementProxy, charTypeOut, imeModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFont(struct ICEUICompositeFont* *const iFontOut)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_getFont(_iTextControlElementProxy, iFontOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRect(CEHtmlElementRectType rectType, CERect *const rectOut)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_getRect(_iTextControlElementProxy, rectType, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isVisible(bool *const visibleOut)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_isVisible(_iTextControlElementProxy, visibleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult calculateBoundingRectangle(CERect *const rectOut)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_calculateBoundingRectangle(_iTextControlElementProxy, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBackgroundRepeat(CEHtmlElementRepeatType *const repeatOut)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_getBackgroundRepeat(_iTextControlElementProxy, repeatOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTLStyles(CEHtmlTLStyle *const tlStyleOut)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_getTLStyles(_iTextControlElementProxy, tlStyleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureEditMode()	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_ensureEditMode(_iTextControlElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult exitEditMode()	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_exitEditMode(_iTextControlElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureFocus()	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_ensureFocus(_iTextControlElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult loseFocus()	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_loseFocus(_iTextControlElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isEditMode(bool *const isEditModeOut)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_isEditMode(_iTextControlElementProxy, isEditModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult renderBorder(struct ICEUIGraphicsContext* iGC, CERect* borderRect)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_renderBorder(_iTextControlElementProxy, iGC, borderRect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormElement(struct ICEHtmlFormElementProxy* *const iFormElement)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_getFormElement(_iTextControlElementProxy, iFormElement) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult genericEvent(CEHtmlEventId eventId)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_genericEvent(_iTextControlElementProxy, eventId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFormValue(struct ICEUString* iFormStr)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_setFormValue(_iTextControlElementProxy, iFormStr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormValue(bool isDefault, struct ICEUString* *const iFormStrOut)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_getFormValue(_iTextControlElementProxy, isDefault, iFormStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isDisabled(bool *const disabledOut)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_isDisabled(_iTextControlElementProxy, disabledOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult cut()	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_cut(_iTextControlElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult copy()	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_copy(_iTextControlElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult paste()	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_paste(_iTextControlElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult selectAll()	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_selectAll(_iTextControlElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isReadOnly(bool *const readOnlyOut)	{ return _iTextControlElementProxy ? _iTextControlElementProxy->_vtbl->_isReadOnly(_iTextControlElementProxy, readOnlyOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlTextControlElementProxy* _iTextControlElementProxy;
};

/*! @}
 * end of CEComICEHtmlTextControlElementProxyRef
 */

/*! \defgroup CEComICEHtmlInputTextElementProxyRef CEComICEHtmlInputTextElementProxyRef
 * @{
 */

class CEComICEHtmlInputTextElementProxyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlInputTextElementProxyRef() : _iInputTextElementProxy(0) {}
	CEComICEHtmlInputTextElementProxyRef(ICEHtmlInputTextElementProxy* iOther) : _iInputTextElementProxy(0)
	{
		if (iOther)
		{
			_iInputTextElementProxy = iOther;
			_iInputTextElementProxy->_vtbl->_addRef(_iInputTextElementProxy);
		}
	}

	CEComICEHtmlInputTextElementProxyRef(const CEComICEHtmlInputTextElementProxyRef& other) : _iInputTextElementProxy(0)
	{
		if (other._iInputTextElementProxy)
		{
			_iInputTextElementProxy = other._iInputTextElementProxy;
			_iInputTextElementProxy->_vtbl->_addRef(_iInputTextElementProxy);
		}
	}

	~CEComICEHtmlInputTextElementProxyRef()
	{
		if (_iInputTextElementProxy)
		{
			ICEHtmlInputTextElementProxy* tmp = _iInputTextElementProxy;
			_iInputTextElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlInputTextElementProxy* iInputTextElementProxy;
				void* _ptr;
			} uIntf;
			uIntf.iInputTextElementProxy = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlInputTextElementProxy, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iInputTextElementProxy)
				{
					ICEHtmlInputTextElementProxy* tmp = _iInputTextElementProxy;
					_iInputTextElementProxy = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iInputTextElementProxy = uIntf.iInputTextElementProxy;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlInputTextElementProxy* object() const	{ return _iInputTextElementProxy; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlInputTextElementProxy* iOther)
	{
		if (_iInputTextElementProxy)
		{
			ICEHtmlInputTextElementProxy* tmp = _iInputTextElementProxy;
			_iInputTextElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iInputTextElementProxy = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlInputTextElementProxy* detach()
	{
		ICEHtmlInputTextElementProxy* iIntf = _iInputTextElementProxy;
		_iInputTextElementProxy = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlInputTextElementProxy* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iInputTextElementProxy;
		if (_iInputTextElementProxy)
		{
			_iInputTextElementProxy->_vtbl->_addRef(_iInputTextElementProxy);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlInputTextElementProxy*() const	{ return _iInputTextElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlInputTextElementProxy& operator*() const	{ return *_iInputTextElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iInputTextElementProxy == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlInputTextElementProxy* iOther) const	{ return (_iInputTextElementProxy != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlInputTextElementProxy* iOther) const	{ return (_iInputTextElementProxy == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlInputTextElementProxyRef& operator=(const CEComICEHtmlInputTextElementProxyRef& other)	{ return operator=(other._iInputTextElementProxy); }

	CEComICEHtmlInputTextElementProxyRef& operator=(const ICEHtmlInputTextElementProxy* iOther)
	{
		if (_iInputTextElementProxy != iOther)
		{
			if (_iInputTextElementProxy)
			{
				ICEHtmlInputTextElementProxy* tmp = _iInputTextElementProxy;
				_iInputTextElementProxy = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iInputTextElementProxy = const_cast<ICEHtmlInputTextElementProxy*>(iOther);
			if (_iInputTextElementProxy)
			{
				_iInputTextElementProxy->_vtbl->_addRef(_iInputTextElementProxy);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlInputTextElementProxy** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlInputTextElementProxyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iInputTextElementProxy && "has a com object reference. clear first.");
		return & _iInputTextElementProxy; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlInputTextElementProxyRef& other)
	{
		bool result = false;
		if (_iInputTextElementProxy)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iInputTextElementProxy);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_queryInterface(_iInputTextElementProxy, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iInputTextElementProxy) { _iInputTextElementProxy->_vtbl->_addRef(_iInputTextElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iInputTextElementProxy) { _iInputTextElementProxy->_vtbl->_release(_iInputTextElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementId(CEHtmlElementId* elemIdOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_getElementId(_iInputTextElementProxy, elemIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAttributeString(CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_getAttributeString(_iInputTextElementProxy, attrId, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDocument(struct ICEHtmlDocument* *const iDocumentOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_getDocument(_iInputTextElementProxy, iDocumentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isAvailable(bool *const isAvailableOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_isAvailable(_iInputTextElementProxy, isAvailableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getColor(CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_getColor(_iInputTextElementProxy, colorType, colorOut, undefinedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isBackgroundTransparent(bool *const transparentOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_isBackgroundTransparent(_iInputTextElementProxy, transparentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBoxValue(CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_getBoxValue(_iInputTextElementProxy, type, useRenderingVTPathId, insetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCharacterType(characterTypeValue* charTypeOut, imeModeValue* imeModeOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_getCharacterType(_iInputTextElementProxy, charTypeOut, imeModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFont(struct ICEUICompositeFont* *const iFontOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_getFont(_iInputTextElementProxy, iFontOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRect(CEHtmlElementRectType rectType, CERect *const rectOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_getRect(_iInputTextElementProxy, rectType, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isVisible(bool *const visibleOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_isVisible(_iInputTextElementProxy, visibleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult calculateBoundingRectangle(CERect *const rectOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_calculateBoundingRectangle(_iInputTextElementProxy, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBackgroundRepeat(CEHtmlElementRepeatType *const repeatOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_getBackgroundRepeat(_iInputTextElementProxy, repeatOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTLStyles(CEHtmlTLStyle *const tlStyleOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_getTLStyles(_iInputTextElementProxy, tlStyleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureEditMode()	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_ensureEditMode(_iInputTextElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult exitEditMode()	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_exitEditMode(_iInputTextElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureFocus()	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_ensureFocus(_iInputTextElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult loseFocus()	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_loseFocus(_iInputTextElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isEditMode(bool *const isEditModeOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_isEditMode(_iInputTextElementProxy, isEditModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult renderBorder(struct ICEUIGraphicsContext* iGC, CERect* borderRect)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_renderBorder(_iInputTextElementProxy, iGC, borderRect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormElement(struct ICEHtmlFormElementProxy* *const iFormElement)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_getFormElement(_iInputTextElementProxy, iFormElement) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult genericEvent(CEHtmlEventId eventId)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_genericEvent(_iInputTextElementProxy, eventId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFormValue(struct ICEUString* iFormStr)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_setFormValue(_iInputTextElementProxy, iFormStr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormValue(bool isDefault, struct ICEUString* *const iFormStrOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_getFormValue(_iInputTextElementProxy, isDefault, iFormStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isDisabled(bool *const disabledOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_isDisabled(_iInputTextElementProxy, disabledOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult cut()	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_cut(_iInputTextElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult copy()	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_copy(_iInputTextElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult paste()	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_paste(_iInputTextElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult selectAll()	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_selectAll(_iInputTextElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isReadOnly(bool *const readOnlyOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_isReadOnly(_iInputTextElementProxy, readOnlyOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTextLength(CEHtmlElementLengthType lengthType, INT32 *const lenOut, bool *const undefinedOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_getTextLength(_iInputTextElementProxy, lengthType, lenOut, undefinedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isPasswordMode(bool *const passwordModeOut)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_isPasswordMode(_iInputTextElementProxy, passwordModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setVisibleText(struct ICEUString* visibleText)	{ return _iInputTextElementProxy ? _iInputTextElementProxy->_vtbl->_setVisibleText(_iInputTextElementProxy, visibleText) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlInputTextElementProxy* _iInputTextElementProxy;
};

/*! @}
 * end of CEComICEHtmlInputTextElementProxyRef
 */

/*! \defgroup CEComICEHtmlInputButtonElementProxyRef CEComICEHtmlInputButtonElementProxyRef
 * @{
 */

class CEComICEHtmlInputButtonElementProxyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlInputButtonElementProxyRef() : _iInputButtonElementProxy(0) {}
	CEComICEHtmlInputButtonElementProxyRef(ICEHtmlInputButtonElementProxy* iOther) : _iInputButtonElementProxy(0)
	{
		if (iOther)
		{
			_iInputButtonElementProxy = iOther;
			_iInputButtonElementProxy->_vtbl->_addRef(_iInputButtonElementProxy);
		}
	}

	CEComICEHtmlInputButtonElementProxyRef(const CEComICEHtmlInputButtonElementProxyRef& other) : _iInputButtonElementProxy(0)
	{
		if (other._iInputButtonElementProxy)
		{
			_iInputButtonElementProxy = other._iInputButtonElementProxy;
			_iInputButtonElementProxy->_vtbl->_addRef(_iInputButtonElementProxy);
		}
	}

	~CEComICEHtmlInputButtonElementProxyRef()
	{
		if (_iInputButtonElementProxy)
		{
			ICEHtmlInputButtonElementProxy* tmp = _iInputButtonElementProxy;
			_iInputButtonElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlInputButtonElementProxy* iInputButtonElementProxy;
				void* _ptr;
			} uIntf;
			uIntf.iInputButtonElementProxy = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlInputButtonElementProxy, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iInputButtonElementProxy)
				{
					ICEHtmlInputButtonElementProxy* tmp = _iInputButtonElementProxy;
					_iInputButtonElementProxy = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iInputButtonElementProxy = uIntf.iInputButtonElementProxy;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlInputButtonElementProxy* object() const	{ return _iInputButtonElementProxy; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlInputButtonElementProxy* iOther)
	{
		if (_iInputButtonElementProxy)
		{
			ICEHtmlInputButtonElementProxy* tmp = _iInputButtonElementProxy;
			_iInputButtonElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iInputButtonElementProxy = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlInputButtonElementProxy* detach()
	{
		ICEHtmlInputButtonElementProxy* iIntf = _iInputButtonElementProxy;
		_iInputButtonElementProxy = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlInputButtonElementProxy* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iInputButtonElementProxy;
		if (_iInputButtonElementProxy)
		{
			_iInputButtonElementProxy->_vtbl->_addRef(_iInputButtonElementProxy);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlInputButtonElementProxy*() const	{ return _iInputButtonElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlInputButtonElementProxy& operator*() const	{ return *_iInputButtonElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iInputButtonElementProxy == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlInputButtonElementProxy* iOther) const	{ return (_iInputButtonElementProxy != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlInputButtonElementProxy* iOther) const	{ return (_iInputButtonElementProxy == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlInputButtonElementProxyRef& operator=(const CEComICEHtmlInputButtonElementProxyRef& other)	{ return operator=(other._iInputButtonElementProxy); }

	CEComICEHtmlInputButtonElementProxyRef& operator=(const ICEHtmlInputButtonElementProxy* iOther)
	{
		if (_iInputButtonElementProxy != iOther)
		{
			if (_iInputButtonElementProxy)
			{
				ICEHtmlInputButtonElementProxy* tmp = _iInputButtonElementProxy;
				_iInputButtonElementProxy = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iInputButtonElementProxy = const_cast<ICEHtmlInputButtonElementProxy*>(iOther);
			if (_iInputButtonElementProxy)
			{
				_iInputButtonElementProxy->_vtbl->_addRef(_iInputButtonElementProxy);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlInputButtonElementProxy** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlInputButtonElementProxyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iInputButtonElementProxy && "has a com object reference. clear first.");
		return & _iInputButtonElementProxy; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlInputButtonElementProxyRef& other)
	{
		bool result = false;
		if (_iInputButtonElementProxy)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iInputButtonElementProxy);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_queryInterface(_iInputButtonElementProxy, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iInputButtonElementProxy) { _iInputButtonElementProxy->_vtbl->_addRef(_iInputButtonElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iInputButtonElementProxy) { _iInputButtonElementProxy->_vtbl->_release(_iInputButtonElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementId(CEHtmlElementId* elemIdOut)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_getElementId(_iInputButtonElementProxy, elemIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAttributeString(CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_getAttributeString(_iInputButtonElementProxy, attrId, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDocument(struct ICEHtmlDocument* *const iDocumentOut)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_getDocument(_iInputButtonElementProxy, iDocumentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isAvailable(bool *const isAvailableOut)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_isAvailable(_iInputButtonElementProxy, isAvailableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getColor(CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_getColor(_iInputButtonElementProxy, colorType, colorOut, undefinedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isBackgroundTransparent(bool *const transparentOut)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_isBackgroundTransparent(_iInputButtonElementProxy, transparentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBoxValue(CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_getBoxValue(_iInputButtonElementProxy, type, useRenderingVTPathId, insetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCharacterType(characterTypeValue* charTypeOut, imeModeValue* imeModeOut)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_getCharacterType(_iInputButtonElementProxy, charTypeOut, imeModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFont(struct ICEUICompositeFont* *const iFontOut)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_getFont(_iInputButtonElementProxy, iFontOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRect(CEHtmlElementRectType rectType, CERect *const rectOut)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_getRect(_iInputButtonElementProxy, rectType, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isVisible(bool *const visibleOut)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_isVisible(_iInputButtonElementProxy, visibleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult calculateBoundingRectangle(CERect *const rectOut)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_calculateBoundingRectangle(_iInputButtonElementProxy, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBackgroundRepeat(CEHtmlElementRepeatType *const repeatOut)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_getBackgroundRepeat(_iInputButtonElementProxy, repeatOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTLStyles(CEHtmlTLStyle *const tlStyleOut)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_getTLStyles(_iInputButtonElementProxy, tlStyleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureEditMode()	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_ensureEditMode(_iInputButtonElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult exitEditMode()	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_exitEditMode(_iInputButtonElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureFocus()	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_ensureFocus(_iInputButtonElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult loseFocus()	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_loseFocus(_iInputButtonElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isEditMode(bool *const isEditModeOut)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_isEditMode(_iInputButtonElementProxy, isEditModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult renderBorder(struct ICEUIGraphicsContext* iGC, CERect* borderRect)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_renderBorder(_iInputButtonElementProxy, iGC, borderRect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormElement(struct ICEHtmlFormElementProxy* *const iFormElement)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_getFormElement(_iInputButtonElementProxy, iFormElement) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult genericEvent(CEHtmlEventId eventId)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_genericEvent(_iInputButtonElementProxy, eventId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFormValue(struct ICEUString* iFormStr)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_setFormValue(_iInputButtonElementProxy, iFormStr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormValue(bool isDefault, struct ICEUString* *const iFormStrOut)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_getFormValue(_iInputButtonElementProxy, isDefault, iFormStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isDisabled(bool *const disabledOut)	{ return _iInputButtonElementProxy ? _iInputButtonElementProxy->_vtbl->_isDisabled(_iInputButtonElementProxy, disabledOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlInputButtonElementProxy* _iInputButtonElementProxy;
};

/*! @}
 * end of CEComICEHtmlInputButtonElementProxyRef
 */

/*! \defgroup CEComICEHtmlFileSelectElementProxyRef CEComICEHtmlFileSelectElementProxyRef
 * @{
 */

class CEComICEHtmlFileSelectElementProxyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlFileSelectElementProxyRef() : _iFileSelectElementProxy(0) {}
	CEComICEHtmlFileSelectElementProxyRef(ICEHtmlFileSelectElementProxy* iOther) : _iFileSelectElementProxy(0)
	{
		if (iOther)
		{
			_iFileSelectElementProxy = iOther;
			_iFileSelectElementProxy->_vtbl->_addRef(_iFileSelectElementProxy);
		}
	}

	CEComICEHtmlFileSelectElementProxyRef(const CEComICEHtmlFileSelectElementProxyRef& other) : _iFileSelectElementProxy(0)
	{
		if (other._iFileSelectElementProxy)
		{
			_iFileSelectElementProxy = other._iFileSelectElementProxy;
			_iFileSelectElementProxy->_vtbl->_addRef(_iFileSelectElementProxy);
		}
	}

	~CEComICEHtmlFileSelectElementProxyRef()
	{
		if (_iFileSelectElementProxy)
		{
			ICEHtmlFileSelectElementProxy* tmp = _iFileSelectElementProxy;
			_iFileSelectElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlFileSelectElementProxy* iFileSelectElementProxy;
				void* _ptr;
			} uIntf;
			uIntf.iFileSelectElementProxy = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlFileSelectElementProxy, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iFileSelectElementProxy)
				{
					ICEHtmlFileSelectElementProxy* tmp = _iFileSelectElementProxy;
					_iFileSelectElementProxy = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iFileSelectElementProxy = uIntf.iFileSelectElementProxy;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFileSelectElementProxy* object() const	{ return _iFileSelectElementProxy; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlFileSelectElementProxy* iOther)
	{
		if (_iFileSelectElementProxy)
		{
			ICEHtmlFileSelectElementProxy* tmp = _iFileSelectElementProxy;
			_iFileSelectElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iFileSelectElementProxy = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlFileSelectElementProxy* detach()
	{
		ICEHtmlFileSelectElementProxy* iIntf = _iFileSelectElementProxy;
		_iFileSelectElementProxy = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlFileSelectElementProxy* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iFileSelectElementProxy;
		if (_iFileSelectElementProxy)
		{
			_iFileSelectElementProxy->_vtbl->_addRef(_iFileSelectElementProxy);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlFileSelectElementProxy*() const	{ return _iFileSelectElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFileSelectElementProxy& operator*() const	{ return *_iFileSelectElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iFileSelectElementProxy == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlFileSelectElementProxy* iOther) const	{ return (_iFileSelectElementProxy != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlFileSelectElementProxy* iOther) const	{ return (_iFileSelectElementProxy == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlFileSelectElementProxyRef& operator=(const CEComICEHtmlFileSelectElementProxyRef& other)	{ return operator=(other._iFileSelectElementProxy); }

	CEComICEHtmlFileSelectElementProxyRef& operator=(const ICEHtmlFileSelectElementProxy* iOther)
	{
		if (_iFileSelectElementProxy != iOther)
		{
			if (_iFileSelectElementProxy)
			{
				ICEHtmlFileSelectElementProxy* tmp = _iFileSelectElementProxy;
				_iFileSelectElementProxy = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iFileSelectElementProxy = const_cast<ICEHtmlFileSelectElementProxy*>(iOther);
			if (_iFileSelectElementProxy)
			{
				_iFileSelectElementProxy->_vtbl->_addRef(_iFileSelectElementProxy);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFileSelectElementProxy** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlFileSelectElementProxyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iFileSelectElementProxy && "has a com object reference. clear first.");
		return & _iFileSelectElementProxy; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlFileSelectElementProxyRef& other)
	{
		bool result = false;
		if (_iFileSelectElementProxy)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iFileSelectElementProxy);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_queryInterface(_iFileSelectElementProxy, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iFileSelectElementProxy) { _iFileSelectElementProxy->_vtbl->_addRef(_iFileSelectElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iFileSelectElementProxy) { _iFileSelectElementProxy->_vtbl->_release(_iFileSelectElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementId(CEHtmlElementId* elemIdOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_getElementId(_iFileSelectElementProxy, elemIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAttributeString(CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_getAttributeString(_iFileSelectElementProxy, attrId, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDocument(struct ICEHtmlDocument* *const iDocumentOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_getDocument(_iFileSelectElementProxy, iDocumentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isAvailable(bool *const isAvailableOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_isAvailable(_iFileSelectElementProxy, isAvailableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getColor(CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_getColor(_iFileSelectElementProxy, colorType, colorOut, undefinedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isBackgroundTransparent(bool *const transparentOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_isBackgroundTransparent(_iFileSelectElementProxy, transparentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBoxValue(CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_getBoxValue(_iFileSelectElementProxy, type, useRenderingVTPathId, insetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCharacterType(characterTypeValue* charTypeOut, imeModeValue* imeModeOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_getCharacterType(_iFileSelectElementProxy, charTypeOut, imeModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFont(struct ICEUICompositeFont* *const iFontOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_getFont(_iFileSelectElementProxy, iFontOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRect(CEHtmlElementRectType rectType, CERect *const rectOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_getRect(_iFileSelectElementProxy, rectType, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isVisible(bool *const visibleOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_isVisible(_iFileSelectElementProxy, visibleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult calculateBoundingRectangle(CERect *const rectOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_calculateBoundingRectangle(_iFileSelectElementProxy, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBackgroundRepeat(CEHtmlElementRepeatType *const repeatOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_getBackgroundRepeat(_iFileSelectElementProxy, repeatOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTLStyles(CEHtmlTLStyle *const tlStyleOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_getTLStyles(_iFileSelectElementProxy, tlStyleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureEditMode()	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_ensureEditMode(_iFileSelectElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult exitEditMode()	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_exitEditMode(_iFileSelectElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureFocus()	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_ensureFocus(_iFileSelectElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult loseFocus()	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_loseFocus(_iFileSelectElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isEditMode(bool *const isEditModeOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_isEditMode(_iFileSelectElementProxy, isEditModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult renderBorder(struct ICEUIGraphicsContext* iGC, CERect* borderRect)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_renderBorder(_iFileSelectElementProxy, iGC, borderRect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormElement(struct ICEHtmlFormElementProxy* *const iFormElement)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_getFormElement(_iFileSelectElementProxy, iFormElement) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult genericEvent(CEHtmlEventId eventId)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_genericEvent(_iFileSelectElementProxy, eventId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFormValue(struct ICEUString* iFormStr)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_setFormValue(_iFileSelectElementProxy, iFormStr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormValue(bool isDefault, struct ICEUString* *const iFormStrOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_getFormValue(_iFileSelectElementProxy, isDefault, iFormStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isDisabled(bool *const disabledOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_isDisabled(_iFileSelectElementProxy, disabledOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult cut()	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_cut(_iFileSelectElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult copy()	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_copy(_iFileSelectElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult paste()	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_paste(_iFileSelectElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult selectAll()	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_selectAll(_iFileSelectElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isReadOnly(bool *const readOnlyOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_isReadOnly(_iFileSelectElementProxy, readOnlyOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTextLength(CEHtmlElementLengthType lengthType, INT32 *const lenOut, bool *const undefinedOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_getTextLength(_iFileSelectElementProxy, lengthType, lenOut, undefinedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isPasswordMode(bool *const passwordModeOut)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_isPasswordMode(_iFileSelectElementProxy, passwordModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setVisibleText(struct ICEUString* visibleText)	{ return _iFileSelectElementProxy ? _iFileSelectElementProxy->_vtbl->_setVisibleText(_iFileSelectElementProxy, visibleText) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlFileSelectElementProxy* _iFileSelectElementProxy;
};

/*! @}
 * end of CEComICEHtmlFileSelectElementProxyRef
 */

/*! \defgroup CEComICEHtmlTextAreaElementProxyRef CEComICEHtmlTextAreaElementProxyRef
 * @{
 */

class CEComICEHtmlTextAreaElementProxyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlTextAreaElementProxyRef() : _iTextAreaElementProxy(0) {}
	CEComICEHtmlTextAreaElementProxyRef(ICEHtmlTextAreaElementProxy* iOther) : _iTextAreaElementProxy(0)
	{
		if (iOther)
		{
			_iTextAreaElementProxy = iOther;
			_iTextAreaElementProxy->_vtbl->_addRef(_iTextAreaElementProxy);
		}
	}

	CEComICEHtmlTextAreaElementProxyRef(const CEComICEHtmlTextAreaElementProxyRef& other) : _iTextAreaElementProxy(0)
	{
		if (other._iTextAreaElementProxy)
		{
			_iTextAreaElementProxy = other._iTextAreaElementProxy;
			_iTextAreaElementProxy->_vtbl->_addRef(_iTextAreaElementProxy);
		}
	}

	~CEComICEHtmlTextAreaElementProxyRef()
	{
		if (_iTextAreaElementProxy)
		{
			ICEHtmlTextAreaElementProxy* tmp = _iTextAreaElementProxy;
			_iTextAreaElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlTextAreaElementProxy* iTextAreaElementProxy;
				void* _ptr;
			} uIntf;
			uIntf.iTextAreaElementProxy = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlTextAreaElementProxy, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iTextAreaElementProxy)
				{
					ICEHtmlTextAreaElementProxy* tmp = _iTextAreaElementProxy;
					_iTextAreaElementProxy = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iTextAreaElementProxy = uIntf.iTextAreaElementProxy;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlTextAreaElementProxy* object() const	{ return _iTextAreaElementProxy; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlTextAreaElementProxy* iOther)
	{
		if (_iTextAreaElementProxy)
		{
			ICEHtmlTextAreaElementProxy* tmp = _iTextAreaElementProxy;
			_iTextAreaElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iTextAreaElementProxy = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlTextAreaElementProxy* detach()
	{
		ICEHtmlTextAreaElementProxy* iIntf = _iTextAreaElementProxy;
		_iTextAreaElementProxy = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlTextAreaElementProxy* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iTextAreaElementProxy;
		if (_iTextAreaElementProxy)
		{
			_iTextAreaElementProxy->_vtbl->_addRef(_iTextAreaElementProxy);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlTextAreaElementProxy*() const	{ return _iTextAreaElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlTextAreaElementProxy& operator*() const	{ return *_iTextAreaElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iTextAreaElementProxy == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlTextAreaElementProxy* iOther) const	{ return (_iTextAreaElementProxy != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlTextAreaElementProxy* iOther) const	{ return (_iTextAreaElementProxy == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlTextAreaElementProxyRef& operator=(const CEComICEHtmlTextAreaElementProxyRef& other)	{ return operator=(other._iTextAreaElementProxy); }

	CEComICEHtmlTextAreaElementProxyRef& operator=(const ICEHtmlTextAreaElementProxy* iOther)
	{
		if (_iTextAreaElementProxy != iOther)
		{
			if (_iTextAreaElementProxy)
			{
				ICEHtmlTextAreaElementProxy* tmp = _iTextAreaElementProxy;
				_iTextAreaElementProxy = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iTextAreaElementProxy = const_cast<ICEHtmlTextAreaElementProxy*>(iOther);
			if (_iTextAreaElementProxy)
			{
				_iTextAreaElementProxy->_vtbl->_addRef(_iTextAreaElementProxy);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlTextAreaElementProxy** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlTextAreaElementProxyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iTextAreaElementProxy && "has a com object reference. clear first.");
		return & _iTextAreaElementProxy; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlTextAreaElementProxyRef& other)
	{
		bool result = false;
		if (_iTextAreaElementProxy)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iTextAreaElementProxy);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_queryInterface(_iTextAreaElementProxy, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iTextAreaElementProxy) { _iTextAreaElementProxy->_vtbl->_addRef(_iTextAreaElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iTextAreaElementProxy) { _iTextAreaElementProxy->_vtbl->_release(_iTextAreaElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementId(CEHtmlElementId* elemIdOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_getElementId(_iTextAreaElementProxy, elemIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAttributeString(CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_getAttributeString(_iTextAreaElementProxy, attrId, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDocument(struct ICEHtmlDocument* *const iDocumentOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_getDocument(_iTextAreaElementProxy, iDocumentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isAvailable(bool *const isAvailableOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_isAvailable(_iTextAreaElementProxy, isAvailableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getColor(CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_getColor(_iTextAreaElementProxy, colorType, colorOut, undefinedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isBackgroundTransparent(bool *const transparentOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_isBackgroundTransparent(_iTextAreaElementProxy, transparentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBoxValue(CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_getBoxValue(_iTextAreaElementProxy, type, useRenderingVTPathId, insetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCharacterType(characterTypeValue* charTypeOut, imeModeValue* imeModeOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_getCharacterType(_iTextAreaElementProxy, charTypeOut, imeModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFont(struct ICEUICompositeFont* *const iFontOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_getFont(_iTextAreaElementProxy, iFontOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRect(CEHtmlElementRectType rectType, CERect *const rectOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_getRect(_iTextAreaElementProxy, rectType, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isVisible(bool *const visibleOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_isVisible(_iTextAreaElementProxy, visibleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult calculateBoundingRectangle(CERect *const rectOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_calculateBoundingRectangle(_iTextAreaElementProxy, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBackgroundRepeat(CEHtmlElementRepeatType *const repeatOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_getBackgroundRepeat(_iTextAreaElementProxy, repeatOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTLStyles(CEHtmlTLStyle *const tlStyleOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_getTLStyles(_iTextAreaElementProxy, tlStyleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureEditMode()	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_ensureEditMode(_iTextAreaElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult exitEditMode()	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_exitEditMode(_iTextAreaElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureFocus()	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_ensureFocus(_iTextAreaElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult loseFocus()	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_loseFocus(_iTextAreaElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isEditMode(bool *const isEditModeOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_isEditMode(_iTextAreaElementProxy, isEditModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult renderBorder(struct ICEUIGraphicsContext* iGC, CERect* borderRect)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_renderBorder(_iTextAreaElementProxy, iGC, borderRect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormElement(struct ICEHtmlFormElementProxy* *const iFormElement)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_getFormElement(_iTextAreaElementProxy, iFormElement) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult genericEvent(CEHtmlEventId eventId)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_genericEvent(_iTextAreaElementProxy, eventId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFormValue(struct ICEUString* iFormStr)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_setFormValue(_iTextAreaElementProxy, iFormStr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormValue(bool isDefault, struct ICEUString* *const iFormStrOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_getFormValue(_iTextAreaElementProxy, isDefault, iFormStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isDisabled(bool *const disabledOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_isDisabled(_iTextAreaElementProxy, disabledOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult cut()	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_cut(_iTextAreaElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult copy()	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_copy(_iTextAreaElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult paste()	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_paste(_iTextAreaElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult selectAll()	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_selectAll(_iTextAreaElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isReadOnly(bool *const readOnlyOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_isReadOnly(_iTextAreaElementProxy, readOnlyOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDimension(CEDim *const dimOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_getDimension(_iTextAreaElementProxy, dimOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isWrapMode(bool *const isWrapModeOut)	{ return _iTextAreaElementProxy ? _iTextAreaElementProxy->_vtbl->_isWrapMode(_iTextAreaElementProxy, isWrapModeOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlTextAreaElementProxy* _iTextAreaElementProxy;
};

/*! @}
 * end of CEComICEHtmlTextAreaElementProxyRef
 */

/*! \defgroup CEComICEHtmlFormSelectableElementProxyRef CEComICEHtmlFormSelectableElementProxyRef
 * @{
 */

class CEComICEHtmlFormSelectableElementProxyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlFormSelectableElementProxyRef() : _iFormSelectableElementProxy(0) {}
	CEComICEHtmlFormSelectableElementProxyRef(ICEHtmlFormSelectableElementProxy* iOther) : _iFormSelectableElementProxy(0)
	{
		if (iOther)
		{
			_iFormSelectableElementProxy = iOther;
			_iFormSelectableElementProxy->_vtbl->_addRef(_iFormSelectableElementProxy);
		}
	}

	CEComICEHtmlFormSelectableElementProxyRef(const CEComICEHtmlFormSelectableElementProxyRef& other) : _iFormSelectableElementProxy(0)
	{
		if (other._iFormSelectableElementProxy)
		{
			_iFormSelectableElementProxy = other._iFormSelectableElementProxy;
			_iFormSelectableElementProxy->_vtbl->_addRef(_iFormSelectableElementProxy);
		}
	}

	~CEComICEHtmlFormSelectableElementProxyRef()
	{
		if (_iFormSelectableElementProxy)
		{
			ICEHtmlFormSelectableElementProxy* tmp = _iFormSelectableElementProxy;
			_iFormSelectableElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlFormSelectableElementProxy* iFormSelectableElementProxy;
				void* _ptr;
			} uIntf;
			uIntf.iFormSelectableElementProxy = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlFormSelectableElementProxy, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iFormSelectableElementProxy)
				{
					ICEHtmlFormSelectableElementProxy* tmp = _iFormSelectableElementProxy;
					_iFormSelectableElementProxy = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iFormSelectableElementProxy = uIntf.iFormSelectableElementProxy;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFormSelectableElementProxy* object() const	{ return _iFormSelectableElementProxy; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlFormSelectableElementProxy* iOther)
	{
		if (_iFormSelectableElementProxy)
		{
			ICEHtmlFormSelectableElementProxy* tmp = _iFormSelectableElementProxy;
			_iFormSelectableElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iFormSelectableElementProxy = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlFormSelectableElementProxy* detach()
	{
		ICEHtmlFormSelectableElementProxy* iIntf = _iFormSelectableElementProxy;
		_iFormSelectableElementProxy = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlFormSelectableElementProxy* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iFormSelectableElementProxy;
		if (_iFormSelectableElementProxy)
		{
			_iFormSelectableElementProxy->_vtbl->_addRef(_iFormSelectableElementProxy);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlFormSelectableElementProxy*() const	{ return _iFormSelectableElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFormSelectableElementProxy& operator*() const	{ return *_iFormSelectableElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iFormSelectableElementProxy == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlFormSelectableElementProxy* iOther) const	{ return (_iFormSelectableElementProxy != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlFormSelectableElementProxy* iOther) const	{ return (_iFormSelectableElementProxy == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlFormSelectableElementProxyRef& operator=(const CEComICEHtmlFormSelectableElementProxyRef& other)	{ return operator=(other._iFormSelectableElementProxy); }

	CEComICEHtmlFormSelectableElementProxyRef& operator=(const ICEHtmlFormSelectableElementProxy* iOther)
	{
		if (_iFormSelectableElementProxy != iOther)
		{
			if (_iFormSelectableElementProxy)
			{
				ICEHtmlFormSelectableElementProxy* tmp = _iFormSelectableElementProxy;
				_iFormSelectableElementProxy = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iFormSelectableElementProxy = const_cast<ICEHtmlFormSelectableElementProxy*>(iOther);
			if (_iFormSelectableElementProxy)
			{
				_iFormSelectableElementProxy->_vtbl->_addRef(_iFormSelectableElementProxy);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFormSelectableElementProxy** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlFormSelectableElementProxyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iFormSelectableElementProxy && "has a com object reference. clear first.");
		return & _iFormSelectableElementProxy; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlFormSelectableElementProxyRef& other)
	{
		bool result = false;
		if (_iFormSelectableElementProxy)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iFormSelectableElementProxy);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_queryInterface(_iFormSelectableElementProxy, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iFormSelectableElementProxy) { _iFormSelectableElementProxy->_vtbl->_addRef(_iFormSelectableElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iFormSelectableElementProxy) { _iFormSelectableElementProxy->_vtbl->_release(_iFormSelectableElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementId(CEHtmlElementId* elemIdOut)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_getElementId(_iFormSelectableElementProxy, elemIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAttributeString(CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_getAttributeString(_iFormSelectableElementProxy, attrId, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDocument(struct ICEHtmlDocument* *const iDocumentOut)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_getDocument(_iFormSelectableElementProxy, iDocumentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isAvailable(bool *const isAvailableOut)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_isAvailable(_iFormSelectableElementProxy, isAvailableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getColor(CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_getColor(_iFormSelectableElementProxy, colorType, colorOut, undefinedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isBackgroundTransparent(bool *const transparentOut)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_isBackgroundTransparent(_iFormSelectableElementProxy, transparentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBoxValue(CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_getBoxValue(_iFormSelectableElementProxy, type, useRenderingVTPathId, insetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCharacterType(characterTypeValue* charTypeOut, imeModeValue* imeModeOut)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_getCharacterType(_iFormSelectableElementProxy, charTypeOut, imeModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFont(struct ICEUICompositeFont* *const iFontOut)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_getFont(_iFormSelectableElementProxy, iFontOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRect(CEHtmlElementRectType rectType, CERect *const rectOut)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_getRect(_iFormSelectableElementProxy, rectType, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isVisible(bool *const visibleOut)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_isVisible(_iFormSelectableElementProxy, visibleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult calculateBoundingRectangle(CERect *const rectOut)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_calculateBoundingRectangle(_iFormSelectableElementProxy, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBackgroundRepeat(CEHtmlElementRepeatType *const repeatOut)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_getBackgroundRepeat(_iFormSelectableElementProxy, repeatOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTLStyles(CEHtmlTLStyle *const tlStyleOut)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_getTLStyles(_iFormSelectableElementProxy, tlStyleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureEditMode()	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_ensureEditMode(_iFormSelectableElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult exitEditMode()	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_exitEditMode(_iFormSelectableElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureFocus()	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_ensureFocus(_iFormSelectableElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult loseFocus()	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_loseFocus(_iFormSelectableElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isEditMode(bool *const isEditModeOut)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_isEditMode(_iFormSelectableElementProxy, isEditModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult renderBorder(struct ICEUIGraphicsContext* iGC, CERect* borderRect)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_renderBorder(_iFormSelectableElementProxy, iGC, borderRect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormElement(struct ICEHtmlFormElementProxy* *const iFormElement)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_getFormElement(_iFormSelectableElementProxy, iFormElement) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult genericEvent(CEHtmlEventId eventId)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_genericEvent(_iFormSelectableElementProxy, eventId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFormValue(struct ICEUString* iFormStr)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_setFormValue(_iFormSelectableElementProxy, iFormStr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormValue(bool isDefault, struct ICEUString* *const iFormStrOut)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_getFormValue(_iFormSelectableElementProxy, isDefault, iFormStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isDisabled(bool *const disabledOut)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_isDisabled(_iFormSelectableElementProxy, disabledOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isSelected(bool bDefault, bool *const isSelectedOut)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_isSelected(_iFormSelectableElementProxy, bDefault, isSelectedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setSelected(bool bIsSelected)	{ return _iFormSelectableElementProxy ? _iFormSelectableElementProxy->_vtbl->_setSelected(_iFormSelectableElementProxy, bIsSelected) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlFormSelectableElementProxy* _iFormSelectableElementProxy;
};

/*! @}
 * end of CEComICEHtmlFormSelectableElementProxyRef
 */

/*! \defgroup CEComICEHtmlOptionElementProxyRef CEComICEHtmlOptionElementProxyRef
 * @{
 */

class CEComICEHtmlOptionElementProxyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlOptionElementProxyRef() : _iOptionElementProxy(0) {}
	CEComICEHtmlOptionElementProxyRef(ICEHtmlOptionElementProxy* iOther) : _iOptionElementProxy(0)
	{
		if (iOther)
		{
			_iOptionElementProxy = iOther;
			_iOptionElementProxy->_vtbl->_addRef(_iOptionElementProxy);
		}
	}

	CEComICEHtmlOptionElementProxyRef(const CEComICEHtmlOptionElementProxyRef& other) : _iOptionElementProxy(0)
	{
		if (other._iOptionElementProxy)
		{
			_iOptionElementProxy = other._iOptionElementProxy;
			_iOptionElementProxy->_vtbl->_addRef(_iOptionElementProxy);
		}
	}

	~CEComICEHtmlOptionElementProxyRef()
	{
		if (_iOptionElementProxy)
		{
			ICEHtmlOptionElementProxy* tmp = _iOptionElementProxy;
			_iOptionElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlOptionElementProxy* iOptionElementProxy;
				void* _ptr;
			} uIntf;
			uIntf.iOptionElementProxy = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlOptionElementProxy, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iOptionElementProxy)
				{
					ICEHtmlOptionElementProxy* tmp = _iOptionElementProxy;
					_iOptionElementProxy = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iOptionElementProxy = uIntf.iOptionElementProxy;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlOptionElementProxy* object() const	{ return _iOptionElementProxy; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlOptionElementProxy* iOther)
	{
		if (_iOptionElementProxy)
		{
			ICEHtmlOptionElementProxy* tmp = _iOptionElementProxy;
			_iOptionElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iOptionElementProxy = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlOptionElementProxy* detach()
	{
		ICEHtmlOptionElementProxy* iIntf = _iOptionElementProxy;
		_iOptionElementProxy = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlOptionElementProxy* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iOptionElementProxy;
		if (_iOptionElementProxy)
		{
			_iOptionElementProxy->_vtbl->_addRef(_iOptionElementProxy);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlOptionElementProxy*() const	{ return _iOptionElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlOptionElementProxy& operator*() const	{ return *_iOptionElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iOptionElementProxy == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlOptionElementProxy* iOther) const	{ return (_iOptionElementProxy != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlOptionElementProxy* iOther) const	{ return (_iOptionElementProxy == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlOptionElementProxyRef& operator=(const CEComICEHtmlOptionElementProxyRef& other)	{ return operator=(other._iOptionElementProxy); }

	CEComICEHtmlOptionElementProxyRef& operator=(const ICEHtmlOptionElementProxy* iOther)
	{
		if (_iOptionElementProxy != iOther)
		{
			if (_iOptionElementProxy)
			{
				ICEHtmlOptionElementProxy* tmp = _iOptionElementProxy;
				_iOptionElementProxy = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iOptionElementProxy = const_cast<ICEHtmlOptionElementProxy*>(iOther);
			if (_iOptionElementProxy)
			{
				_iOptionElementProxy->_vtbl->_addRef(_iOptionElementProxy);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlOptionElementProxy** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlOptionElementProxyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iOptionElementProxy && "has a com object reference. clear first.");
		return & _iOptionElementProxy; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlOptionElementProxyRef& other)
	{
		bool result = false;
		if (_iOptionElementProxy)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iOptionElementProxy);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_queryInterface(_iOptionElementProxy, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iOptionElementProxy) { _iOptionElementProxy->_vtbl->_addRef(_iOptionElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iOptionElementProxy) { _iOptionElementProxy->_vtbl->_release(_iOptionElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementId(CEHtmlElementId* elemIdOut)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_getElementId(_iOptionElementProxy, elemIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAttributeString(CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_getAttributeString(_iOptionElementProxy, attrId, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDocument(struct ICEHtmlDocument* *const iDocumentOut)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_getDocument(_iOptionElementProxy, iDocumentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isAvailable(bool *const isAvailableOut)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_isAvailable(_iOptionElementProxy, isAvailableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getColor(CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_getColor(_iOptionElementProxy, colorType, colorOut, undefinedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isBackgroundTransparent(bool *const transparentOut)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_isBackgroundTransparent(_iOptionElementProxy, transparentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBoxValue(CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_getBoxValue(_iOptionElementProxy, type, useRenderingVTPathId, insetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCharacterType(characterTypeValue* charTypeOut, imeModeValue* imeModeOut)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_getCharacterType(_iOptionElementProxy, charTypeOut, imeModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFont(struct ICEUICompositeFont* *const iFontOut)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_getFont(_iOptionElementProxy, iFontOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRect(CEHtmlElementRectType rectType, CERect *const rectOut)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_getRect(_iOptionElementProxy, rectType, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isVisible(bool *const visibleOut)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_isVisible(_iOptionElementProxy, visibleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult calculateBoundingRectangle(CERect *const rectOut)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_calculateBoundingRectangle(_iOptionElementProxy, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBackgroundRepeat(CEHtmlElementRepeatType *const repeatOut)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_getBackgroundRepeat(_iOptionElementProxy, repeatOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTLStyles(CEHtmlTLStyle *const tlStyleOut)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_getTLStyles(_iOptionElementProxy, tlStyleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureEditMode()	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_ensureEditMode(_iOptionElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult exitEditMode()	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_exitEditMode(_iOptionElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureFocus()	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_ensureFocus(_iOptionElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult loseFocus()	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_loseFocus(_iOptionElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isEditMode(bool *const isEditModeOut)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_isEditMode(_iOptionElementProxy, isEditModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult renderBorder(struct ICEUIGraphicsContext* iGC, CERect* borderRect)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_renderBorder(_iOptionElementProxy, iGC, borderRect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormElement(struct ICEHtmlFormElementProxy* *const iFormElement)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_getFormElement(_iOptionElementProxy, iFormElement) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult genericEvent(CEHtmlEventId eventId)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_genericEvent(_iOptionElementProxy, eventId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFormValue(struct ICEUString* iFormStr)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_setFormValue(_iOptionElementProxy, iFormStr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormValue(bool isDefault, struct ICEUString* *const iFormStrOut)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_getFormValue(_iOptionElementProxy, isDefault, iFormStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isDisabled(bool *const disabledOut)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_isDisabled(_iOptionElementProxy, disabledOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isSelected(bool bDefault, bool *const isSelectedOut)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_isSelected(_iOptionElementProxy, bDefault, isSelectedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setSelected(bool bIsSelected)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_setSelected(_iOptionElementProxy, bIsSelected) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getNextOption(struct ICEHtmlOptionElementProxy* *const iOptionElementOut)	{ return _iOptionElementProxy ? _iOptionElementProxy->_vtbl->_getNextOption(_iOptionElementProxy, iOptionElementOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlOptionElementProxy* _iOptionElementProxy;
};

/*! @}
 * end of CEComICEHtmlOptionElementProxyRef
 */

/*! \defgroup CEComICEHtmlSelectElementProxyRef CEComICEHtmlSelectElementProxyRef
 * @{
 */

class CEComICEHtmlSelectElementProxyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlSelectElementProxyRef() : _iSelectElementProxy(0) {}
	CEComICEHtmlSelectElementProxyRef(ICEHtmlSelectElementProxy* iOther) : _iSelectElementProxy(0)
	{
		if (iOther)
		{
			_iSelectElementProxy = iOther;
			_iSelectElementProxy->_vtbl->_addRef(_iSelectElementProxy);
		}
	}

	CEComICEHtmlSelectElementProxyRef(const CEComICEHtmlSelectElementProxyRef& other) : _iSelectElementProxy(0)
	{
		if (other._iSelectElementProxy)
		{
			_iSelectElementProxy = other._iSelectElementProxy;
			_iSelectElementProxy->_vtbl->_addRef(_iSelectElementProxy);
		}
	}

	~CEComICEHtmlSelectElementProxyRef()
	{
		if (_iSelectElementProxy)
		{
			ICEHtmlSelectElementProxy* tmp = _iSelectElementProxy;
			_iSelectElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlSelectElementProxy* iSelectElementProxy;
				void* _ptr;
			} uIntf;
			uIntf.iSelectElementProxy = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlSelectElementProxy, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iSelectElementProxy)
				{
					ICEHtmlSelectElementProxy* tmp = _iSelectElementProxy;
					_iSelectElementProxy = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iSelectElementProxy = uIntf.iSelectElementProxy;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlSelectElementProxy* object() const	{ return _iSelectElementProxy; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlSelectElementProxy* iOther)
	{
		if (_iSelectElementProxy)
		{
			ICEHtmlSelectElementProxy* tmp = _iSelectElementProxy;
			_iSelectElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iSelectElementProxy = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlSelectElementProxy* detach()
	{
		ICEHtmlSelectElementProxy* iIntf = _iSelectElementProxy;
		_iSelectElementProxy = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlSelectElementProxy* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iSelectElementProxy;
		if (_iSelectElementProxy)
		{
			_iSelectElementProxy->_vtbl->_addRef(_iSelectElementProxy);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlSelectElementProxy*() const	{ return _iSelectElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlSelectElementProxy& operator*() const	{ return *_iSelectElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iSelectElementProxy == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlSelectElementProxy* iOther) const	{ return (_iSelectElementProxy != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlSelectElementProxy* iOther) const	{ return (_iSelectElementProxy == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlSelectElementProxyRef& operator=(const CEComICEHtmlSelectElementProxyRef& other)	{ return operator=(other._iSelectElementProxy); }

	CEComICEHtmlSelectElementProxyRef& operator=(const ICEHtmlSelectElementProxy* iOther)
	{
		if (_iSelectElementProxy != iOther)
		{
			if (_iSelectElementProxy)
			{
				ICEHtmlSelectElementProxy* tmp = _iSelectElementProxy;
				_iSelectElementProxy = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iSelectElementProxy = const_cast<ICEHtmlSelectElementProxy*>(iOther);
			if (_iSelectElementProxy)
			{
				_iSelectElementProxy->_vtbl->_addRef(_iSelectElementProxy);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlSelectElementProxy** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlSelectElementProxyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iSelectElementProxy && "has a com object reference. clear first.");
		return & _iSelectElementProxy; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlSelectElementProxyRef& other)
	{
		bool result = false;
		if (_iSelectElementProxy)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iSelectElementProxy);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_queryInterface(_iSelectElementProxy, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iSelectElementProxy) { _iSelectElementProxy->_vtbl->_addRef(_iSelectElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iSelectElementProxy) { _iSelectElementProxy->_vtbl->_release(_iSelectElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementId(CEHtmlElementId* elemIdOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_getElementId(_iSelectElementProxy, elemIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAttributeString(CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_getAttributeString(_iSelectElementProxy, attrId, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDocument(struct ICEHtmlDocument* *const iDocumentOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_getDocument(_iSelectElementProxy, iDocumentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isAvailable(bool *const isAvailableOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_isAvailable(_iSelectElementProxy, isAvailableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getColor(CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_getColor(_iSelectElementProxy, colorType, colorOut, undefinedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isBackgroundTransparent(bool *const transparentOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_isBackgroundTransparent(_iSelectElementProxy, transparentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBoxValue(CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_getBoxValue(_iSelectElementProxy, type, useRenderingVTPathId, insetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCharacterType(characterTypeValue* charTypeOut, imeModeValue* imeModeOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_getCharacterType(_iSelectElementProxy, charTypeOut, imeModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFont(struct ICEUICompositeFont* *const iFontOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_getFont(_iSelectElementProxy, iFontOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRect(CEHtmlElementRectType rectType, CERect *const rectOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_getRect(_iSelectElementProxy, rectType, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isVisible(bool *const visibleOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_isVisible(_iSelectElementProxy, visibleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult calculateBoundingRectangle(CERect *const rectOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_calculateBoundingRectangle(_iSelectElementProxy, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBackgroundRepeat(CEHtmlElementRepeatType *const repeatOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_getBackgroundRepeat(_iSelectElementProxy, repeatOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTLStyles(CEHtmlTLStyle *const tlStyleOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_getTLStyles(_iSelectElementProxy, tlStyleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureEditMode()	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_ensureEditMode(_iSelectElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult exitEditMode()	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_exitEditMode(_iSelectElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureFocus()	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_ensureFocus(_iSelectElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult loseFocus()	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_loseFocus(_iSelectElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isEditMode(bool *const isEditModeOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_isEditMode(_iSelectElementProxy, isEditModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult renderBorder(struct ICEUIGraphicsContext* iGC, CERect* borderRect)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_renderBorder(_iSelectElementProxy, iGC, borderRect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormElement(struct ICEHtmlFormElementProxy* *const iFormElement)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_getFormElement(_iSelectElementProxy, iFormElement) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult genericEvent(CEHtmlEventId eventId)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_genericEvent(_iSelectElementProxy, eventId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFormValue(struct ICEUString* iFormStr)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_setFormValue(_iSelectElementProxy, iFormStr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormValue(bool isDefault, struct ICEUString* *const iFormStrOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_getFormValue(_iSelectElementProxy, isDefault, iFormStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isDisabled(bool *const disabledOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_isDisabled(_iSelectElementProxy, disabledOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getListSize(INT32 *const listSizeOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_getListSize(_iSelectElementProxy, listSizeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isMultiple(bool *const isMultipleOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_isMultiple(_iSelectElementProxy, isMultipleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFirstOptionElement(struct ICEHtmlOptionElementProxy* *const iOptionElementOut)	{ return _iSelectElementProxy ? _iSelectElementProxy->_vtbl->_getFirstOptionElement(_iSelectElementProxy, iOptionElementOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlSelectElementProxy* _iSelectElementProxy;
};

/*! @}
 * end of CEComICEHtmlSelectElementProxyRef
 */

/*! \defgroup CEComICEHtmlSelectListElementProxyRef CEComICEHtmlSelectListElementProxyRef
 * @{
 */

class CEComICEHtmlSelectListElementProxyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlSelectListElementProxyRef() : _iSelectListElementProxy(0) {}
	CEComICEHtmlSelectListElementProxyRef(ICEHtmlSelectListElementProxy* iOther) : _iSelectListElementProxy(0)
	{
		if (iOther)
		{
			_iSelectListElementProxy = iOther;
			_iSelectListElementProxy->_vtbl->_addRef(_iSelectListElementProxy);
		}
	}

	CEComICEHtmlSelectListElementProxyRef(const CEComICEHtmlSelectListElementProxyRef& other) : _iSelectListElementProxy(0)
	{
		if (other._iSelectListElementProxy)
		{
			_iSelectListElementProxy = other._iSelectListElementProxy;
			_iSelectListElementProxy->_vtbl->_addRef(_iSelectListElementProxy);
		}
	}

	~CEComICEHtmlSelectListElementProxyRef()
	{
		if (_iSelectListElementProxy)
		{
			ICEHtmlSelectListElementProxy* tmp = _iSelectListElementProxy;
			_iSelectListElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlSelectListElementProxy* iSelectListElementProxy;
				void* _ptr;
			} uIntf;
			uIntf.iSelectListElementProxy = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlSelectListElementProxy, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iSelectListElementProxy)
				{
					ICEHtmlSelectListElementProxy* tmp = _iSelectListElementProxy;
					_iSelectListElementProxy = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iSelectListElementProxy = uIntf.iSelectListElementProxy;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlSelectListElementProxy* object() const	{ return _iSelectListElementProxy; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlSelectListElementProxy* iOther)
	{
		if (_iSelectListElementProxy)
		{
			ICEHtmlSelectListElementProxy* tmp = _iSelectListElementProxy;
			_iSelectListElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iSelectListElementProxy = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlSelectListElementProxy* detach()
	{
		ICEHtmlSelectListElementProxy* iIntf = _iSelectListElementProxy;
		_iSelectListElementProxy = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlSelectListElementProxy* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iSelectListElementProxy;
		if (_iSelectListElementProxy)
		{
			_iSelectListElementProxy->_vtbl->_addRef(_iSelectListElementProxy);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlSelectListElementProxy*() const	{ return _iSelectListElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlSelectListElementProxy& operator*() const	{ return *_iSelectListElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iSelectListElementProxy == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlSelectListElementProxy* iOther) const	{ return (_iSelectListElementProxy != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlSelectListElementProxy* iOther) const	{ return (_iSelectListElementProxy == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlSelectListElementProxyRef& operator=(const CEComICEHtmlSelectListElementProxyRef& other)	{ return operator=(other._iSelectListElementProxy); }

	CEComICEHtmlSelectListElementProxyRef& operator=(const ICEHtmlSelectListElementProxy* iOther)
	{
		if (_iSelectListElementProxy != iOther)
		{
			if (_iSelectListElementProxy)
			{
				ICEHtmlSelectListElementProxy* tmp = _iSelectListElementProxy;
				_iSelectListElementProxy = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iSelectListElementProxy = const_cast<ICEHtmlSelectListElementProxy*>(iOther);
			if (_iSelectListElementProxy)
			{
				_iSelectListElementProxy->_vtbl->_addRef(_iSelectListElementProxy);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlSelectListElementProxy** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlSelectListElementProxyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iSelectListElementProxy && "has a com object reference. clear first.");
		return & _iSelectListElementProxy; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlSelectListElementProxyRef& other)
	{
		bool result = false;
		if (_iSelectListElementProxy)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iSelectListElementProxy);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_queryInterface(_iSelectListElementProxy, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iSelectListElementProxy) { _iSelectListElementProxy->_vtbl->_addRef(_iSelectListElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iSelectListElementProxy) { _iSelectListElementProxy->_vtbl->_release(_iSelectListElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementId(CEHtmlElementId* elemIdOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_getElementId(_iSelectListElementProxy, elemIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAttributeString(CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_getAttributeString(_iSelectListElementProxy, attrId, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDocument(struct ICEHtmlDocument* *const iDocumentOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_getDocument(_iSelectListElementProxy, iDocumentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isAvailable(bool *const isAvailableOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_isAvailable(_iSelectListElementProxy, isAvailableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getColor(CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_getColor(_iSelectListElementProxy, colorType, colorOut, undefinedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isBackgroundTransparent(bool *const transparentOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_isBackgroundTransparent(_iSelectListElementProxy, transparentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBoxValue(CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_getBoxValue(_iSelectListElementProxy, type, useRenderingVTPathId, insetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCharacterType(characterTypeValue* charTypeOut, imeModeValue* imeModeOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_getCharacterType(_iSelectListElementProxy, charTypeOut, imeModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFont(struct ICEUICompositeFont* *const iFontOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_getFont(_iSelectListElementProxy, iFontOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRect(CEHtmlElementRectType rectType, CERect *const rectOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_getRect(_iSelectListElementProxy, rectType, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isVisible(bool *const visibleOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_isVisible(_iSelectListElementProxy, visibleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult calculateBoundingRectangle(CERect *const rectOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_calculateBoundingRectangle(_iSelectListElementProxy, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBackgroundRepeat(CEHtmlElementRepeatType *const repeatOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_getBackgroundRepeat(_iSelectListElementProxy, repeatOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTLStyles(CEHtmlTLStyle *const tlStyleOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_getTLStyles(_iSelectListElementProxy, tlStyleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureEditMode()	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_ensureEditMode(_iSelectListElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult exitEditMode()	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_exitEditMode(_iSelectListElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureFocus()	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_ensureFocus(_iSelectListElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult loseFocus()	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_loseFocus(_iSelectListElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isEditMode(bool *const isEditModeOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_isEditMode(_iSelectListElementProxy, isEditModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult renderBorder(struct ICEUIGraphicsContext* iGC, CERect* borderRect)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_renderBorder(_iSelectListElementProxy, iGC, borderRect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormElement(struct ICEHtmlFormElementProxy* *const iFormElement)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_getFormElement(_iSelectListElementProxy, iFormElement) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult genericEvent(CEHtmlEventId eventId)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_genericEvent(_iSelectListElementProxy, eventId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFormValue(struct ICEUString* iFormStr)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_setFormValue(_iSelectListElementProxy, iFormStr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormValue(bool isDefault, struct ICEUString* *const iFormStrOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_getFormValue(_iSelectListElementProxy, isDefault, iFormStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isDisabled(bool *const disabledOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_isDisabled(_iSelectListElementProxy, disabledOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getListSize(INT32 *const listSizeOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_getListSize(_iSelectListElementProxy, listSizeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isMultiple(bool *const isMultipleOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_isMultiple(_iSelectListElementProxy, isMultipleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFirstOptionElement(struct ICEHtmlOptionElementProxy* *const iOptionElementOut)	{ return _iSelectListElementProxy ? _iSelectListElementProxy->_vtbl->_getFirstOptionElement(_iSelectListElementProxy, iOptionElementOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlSelectListElementProxy* _iSelectListElementProxy;
};

/*! @}
 * end of CEComICEHtmlSelectListElementProxyRef
 */

/*! \defgroup CEComICEHtmlSelectComboElementProxyRef CEComICEHtmlSelectComboElementProxyRef
 * @{
 */

class CEComICEHtmlSelectComboElementProxyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlSelectComboElementProxyRef() : _iSelectComboElementProxy(0) {}
	CEComICEHtmlSelectComboElementProxyRef(ICEHtmlSelectComboElementProxy* iOther) : _iSelectComboElementProxy(0)
	{
		if (iOther)
		{
			_iSelectComboElementProxy = iOther;
			_iSelectComboElementProxy->_vtbl->_addRef(_iSelectComboElementProxy);
		}
	}

	CEComICEHtmlSelectComboElementProxyRef(const CEComICEHtmlSelectComboElementProxyRef& other) : _iSelectComboElementProxy(0)
	{
		if (other._iSelectComboElementProxy)
		{
			_iSelectComboElementProxy = other._iSelectComboElementProxy;
			_iSelectComboElementProxy->_vtbl->_addRef(_iSelectComboElementProxy);
		}
	}

	~CEComICEHtmlSelectComboElementProxyRef()
	{
		if (_iSelectComboElementProxy)
		{
			ICEHtmlSelectComboElementProxy* tmp = _iSelectComboElementProxy;
			_iSelectComboElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlSelectComboElementProxy* iSelectComboElementProxy;
				void* _ptr;
			} uIntf;
			uIntf.iSelectComboElementProxy = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlSelectComboElementProxy, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iSelectComboElementProxy)
				{
					ICEHtmlSelectComboElementProxy* tmp = _iSelectComboElementProxy;
					_iSelectComboElementProxy = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iSelectComboElementProxy = uIntf.iSelectComboElementProxy;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlSelectComboElementProxy* object() const	{ return _iSelectComboElementProxy; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlSelectComboElementProxy* iOther)
	{
		if (_iSelectComboElementProxy)
		{
			ICEHtmlSelectComboElementProxy* tmp = _iSelectComboElementProxy;
			_iSelectComboElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iSelectComboElementProxy = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlSelectComboElementProxy* detach()
	{
		ICEHtmlSelectComboElementProxy* iIntf = _iSelectComboElementProxy;
		_iSelectComboElementProxy = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlSelectComboElementProxy* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iSelectComboElementProxy;
		if (_iSelectComboElementProxy)
		{
			_iSelectComboElementProxy->_vtbl->_addRef(_iSelectComboElementProxy);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlSelectComboElementProxy*() const	{ return _iSelectComboElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlSelectComboElementProxy& operator*() const	{ return *_iSelectComboElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iSelectComboElementProxy == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlSelectComboElementProxy* iOther) const	{ return (_iSelectComboElementProxy != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlSelectComboElementProxy* iOther) const	{ return (_iSelectComboElementProxy == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlSelectComboElementProxyRef& operator=(const CEComICEHtmlSelectComboElementProxyRef& other)	{ return operator=(other._iSelectComboElementProxy); }

	CEComICEHtmlSelectComboElementProxyRef& operator=(const ICEHtmlSelectComboElementProxy* iOther)
	{
		if (_iSelectComboElementProxy != iOther)
		{
			if (_iSelectComboElementProxy)
			{
				ICEHtmlSelectComboElementProxy* tmp = _iSelectComboElementProxy;
				_iSelectComboElementProxy = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iSelectComboElementProxy = const_cast<ICEHtmlSelectComboElementProxy*>(iOther);
			if (_iSelectComboElementProxy)
			{
				_iSelectComboElementProxy->_vtbl->_addRef(_iSelectComboElementProxy);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlSelectComboElementProxy** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlSelectComboElementProxyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iSelectComboElementProxy && "has a com object reference. clear first.");
		return & _iSelectComboElementProxy; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlSelectComboElementProxyRef& other)
	{
		bool result = false;
		if (_iSelectComboElementProxy)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iSelectComboElementProxy);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_queryInterface(_iSelectComboElementProxy, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iSelectComboElementProxy) { _iSelectComboElementProxy->_vtbl->_addRef(_iSelectComboElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iSelectComboElementProxy) { _iSelectComboElementProxy->_vtbl->_release(_iSelectComboElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementId(CEHtmlElementId* elemIdOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_getElementId(_iSelectComboElementProxy, elemIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAttributeString(CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_getAttributeString(_iSelectComboElementProxy, attrId, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDocument(struct ICEHtmlDocument* *const iDocumentOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_getDocument(_iSelectComboElementProxy, iDocumentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isAvailable(bool *const isAvailableOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_isAvailable(_iSelectComboElementProxy, isAvailableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getColor(CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_getColor(_iSelectComboElementProxy, colorType, colorOut, undefinedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isBackgroundTransparent(bool *const transparentOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_isBackgroundTransparent(_iSelectComboElementProxy, transparentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBoxValue(CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_getBoxValue(_iSelectComboElementProxy, type, useRenderingVTPathId, insetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCharacterType(characterTypeValue* charTypeOut, imeModeValue* imeModeOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_getCharacterType(_iSelectComboElementProxy, charTypeOut, imeModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFont(struct ICEUICompositeFont* *const iFontOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_getFont(_iSelectComboElementProxy, iFontOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRect(CEHtmlElementRectType rectType, CERect *const rectOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_getRect(_iSelectComboElementProxy, rectType, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isVisible(bool *const visibleOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_isVisible(_iSelectComboElementProxy, visibleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult calculateBoundingRectangle(CERect *const rectOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_calculateBoundingRectangle(_iSelectComboElementProxy, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBackgroundRepeat(CEHtmlElementRepeatType *const repeatOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_getBackgroundRepeat(_iSelectComboElementProxy, repeatOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTLStyles(CEHtmlTLStyle *const tlStyleOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_getTLStyles(_iSelectComboElementProxy, tlStyleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureEditMode()	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_ensureEditMode(_iSelectComboElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult exitEditMode()	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_exitEditMode(_iSelectComboElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureFocus()	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_ensureFocus(_iSelectComboElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult loseFocus()	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_loseFocus(_iSelectComboElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isEditMode(bool *const isEditModeOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_isEditMode(_iSelectComboElementProxy, isEditModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult renderBorder(struct ICEUIGraphicsContext* iGC, CERect* borderRect)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_renderBorder(_iSelectComboElementProxy, iGC, borderRect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormElement(struct ICEHtmlFormElementProxy* *const iFormElement)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_getFormElement(_iSelectComboElementProxy, iFormElement) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult genericEvent(CEHtmlEventId eventId)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_genericEvent(_iSelectComboElementProxy, eventId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFormValue(struct ICEUString* iFormStr)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_setFormValue(_iSelectComboElementProxy, iFormStr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormValue(bool isDefault, struct ICEUString* *const iFormStrOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_getFormValue(_iSelectComboElementProxy, isDefault, iFormStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isDisabled(bool *const disabledOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_isDisabled(_iSelectComboElementProxy, disabledOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getListSize(INT32 *const listSizeOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_getListSize(_iSelectComboElementProxy, listSizeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isMultiple(bool *const isMultipleOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_isMultiple(_iSelectComboElementProxy, isMultipleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFirstOptionElement(struct ICEHtmlOptionElementProxy* *const iOptionElementOut)	{ return _iSelectComboElementProxy ? _iSelectComboElementProxy->_vtbl->_getFirstOptionElement(_iSelectComboElementProxy, iOptionElementOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlSelectComboElementProxy* _iSelectComboElementProxy;
};

/*! @}
 * end of CEComICEHtmlSelectComboElementProxyRef
 */

/*! \defgroup CEComICEHtmlCheckBoxElementProxyRef CEComICEHtmlCheckBoxElementProxyRef
 * @{
 */

class CEComICEHtmlCheckBoxElementProxyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlCheckBoxElementProxyRef() : _iCheckBoxElementProxy(0) {}
	CEComICEHtmlCheckBoxElementProxyRef(ICEHtmlCheckBoxElementProxy* iOther) : _iCheckBoxElementProxy(0)
	{
		if (iOther)
		{
			_iCheckBoxElementProxy = iOther;
			_iCheckBoxElementProxy->_vtbl->_addRef(_iCheckBoxElementProxy);
		}
	}

	CEComICEHtmlCheckBoxElementProxyRef(const CEComICEHtmlCheckBoxElementProxyRef& other) : _iCheckBoxElementProxy(0)
	{
		if (other._iCheckBoxElementProxy)
		{
			_iCheckBoxElementProxy = other._iCheckBoxElementProxy;
			_iCheckBoxElementProxy->_vtbl->_addRef(_iCheckBoxElementProxy);
		}
	}

	~CEComICEHtmlCheckBoxElementProxyRef()
	{
		if (_iCheckBoxElementProxy)
		{
			ICEHtmlCheckBoxElementProxy* tmp = _iCheckBoxElementProxy;
			_iCheckBoxElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlCheckBoxElementProxy* iCheckBoxElementProxy;
				void* _ptr;
			} uIntf;
			uIntf.iCheckBoxElementProxy = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlCheckBoxElementProxy, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iCheckBoxElementProxy)
				{
					ICEHtmlCheckBoxElementProxy* tmp = _iCheckBoxElementProxy;
					_iCheckBoxElementProxy = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iCheckBoxElementProxy = uIntf.iCheckBoxElementProxy;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlCheckBoxElementProxy* object() const	{ return _iCheckBoxElementProxy; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlCheckBoxElementProxy* iOther)
	{
		if (_iCheckBoxElementProxy)
		{
			ICEHtmlCheckBoxElementProxy* tmp = _iCheckBoxElementProxy;
			_iCheckBoxElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iCheckBoxElementProxy = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlCheckBoxElementProxy* detach()
	{
		ICEHtmlCheckBoxElementProxy* iIntf = _iCheckBoxElementProxy;
		_iCheckBoxElementProxy = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlCheckBoxElementProxy* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iCheckBoxElementProxy;
		if (_iCheckBoxElementProxy)
		{
			_iCheckBoxElementProxy->_vtbl->_addRef(_iCheckBoxElementProxy);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlCheckBoxElementProxy*() const	{ return _iCheckBoxElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlCheckBoxElementProxy& operator*() const	{ return *_iCheckBoxElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iCheckBoxElementProxy == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlCheckBoxElementProxy* iOther) const	{ return (_iCheckBoxElementProxy != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlCheckBoxElementProxy* iOther) const	{ return (_iCheckBoxElementProxy == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlCheckBoxElementProxyRef& operator=(const CEComICEHtmlCheckBoxElementProxyRef& other)	{ return operator=(other._iCheckBoxElementProxy); }

	CEComICEHtmlCheckBoxElementProxyRef& operator=(const ICEHtmlCheckBoxElementProxy* iOther)
	{
		if (_iCheckBoxElementProxy != iOther)
		{
			if (_iCheckBoxElementProxy)
			{
				ICEHtmlCheckBoxElementProxy* tmp = _iCheckBoxElementProxy;
				_iCheckBoxElementProxy = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iCheckBoxElementProxy = const_cast<ICEHtmlCheckBoxElementProxy*>(iOther);
			if (_iCheckBoxElementProxy)
			{
				_iCheckBoxElementProxy->_vtbl->_addRef(_iCheckBoxElementProxy);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlCheckBoxElementProxy** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlCheckBoxElementProxyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iCheckBoxElementProxy && "has a com object reference. clear first.");
		return & _iCheckBoxElementProxy; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlCheckBoxElementProxyRef& other)
	{
		bool result = false;
		if (_iCheckBoxElementProxy)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iCheckBoxElementProxy);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_queryInterface(_iCheckBoxElementProxy, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iCheckBoxElementProxy) { _iCheckBoxElementProxy->_vtbl->_addRef(_iCheckBoxElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iCheckBoxElementProxy) { _iCheckBoxElementProxy->_vtbl->_release(_iCheckBoxElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementId(CEHtmlElementId* elemIdOut)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_getElementId(_iCheckBoxElementProxy, elemIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAttributeString(CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_getAttributeString(_iCheckBoxElementProxy, attrId, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDocument(struct ICEHtmlDocument* *const iDocumentOut)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_getDocument(_iCheckBoxElementProxy, iDocumentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isAvailable(bool *const isAvailableOut)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_isAvailable(_iCheckBoxElementProxy, isAvailableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getColor(CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_getColor(_iCheckBoxElementProxy, colorType, colorOut, undefinedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isBackgroundTransparent(bool *const transparentOut)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_isBackgroundTransparent(_iCheckBoxElementProxy, transparentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBoxValue(CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_getBoxValue(_iCheckBoxElementProxy, type, useRenderingVTPathId, insetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCharacterType(characterTypeValue* charTypeOut, imeModeValue* imeModeOut)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_getCharacterType(_iCheckBoxElementProxy, charTypeOut, imeModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFont(struct ICEUICompositeFont* *const iFontOut)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_getFont(_iCheckBoxElementProxy, iFontOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRect(CEHtmlElementRectType rectType, CERect *const rectOut)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_getRect(_iCheckBoxElementProxy, rectType, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isVisible(bool *const visibleOut)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_isVisible(_iCheckBoxElementProxy, visibleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult calculateBoundingRectangle(CERect *const rectOut)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_calculateBoundingRectangle(_iCheckBoxElementProxy, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBackgroundRepeat(CEHtmlElementRepeatType *const repeatOut)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_getBackgroundRepeat(_iCheckBoxElementProxy, repeatOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTLStyles(CEHtmlTLStyle *const tlStyleOut)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_getTLStyles(_iCheckBoxElementProxy, tlStyleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureEditMode()	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_ensureEditMode(_iCheckBoxElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult exitEditMode()	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_exitEditMode(_iCheckBoxElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureFocus()	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_ensureFocus(_iCheckBoxElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult loseFocus()	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_loseFocus(_iCheckBoxElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isEditMode(bool *const isEditModeOut)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_isEditMode(_iCheckBoxElementProxy, isEditModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult renderBorder(struct ICEUIGraphicsContext* iGC, CERect* borderRect)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_renderBorder(_iCheckBoxElementProxy, iGC, borderRect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormElement(struct ICEHtmlFormElementProxy* *const iFormElement)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_getFormElement(_iCheckBoxElementProxy, iFormElement) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult genericEvent(CEHtmlEventId eventId)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_genericEvent(_iCheckBoxElementProxy, eventId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFormValue(struct ICEUString* iFormStr)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_setFormValue(_iCheckBoxElementProxy, iFormStr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormValue(bool isDefault, struct ICEUString* *const iFormStrOut)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_getFormValue(_iCheckBoxElementProxy, isDefault, iFormStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isDisabled(bool *const disabledOut)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_isDisabled(_iCheckBoxElementProxy, disabledOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isSelected(bool bDefault, bool *const isSelectedOut)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_isSelected(_iCheckBoxElementProxy, bDefault, isSelectedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setSelected(bool bIsSelected)	{ return _iCheckBoxElementProxy ? _iCheckBoxElementProxy->_vtbl->_setSelected(_iCheckBoxElementProxy, bIsSelected) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlCheckBoxElementProxy* _iCheckBoxElementProxy;
};

/*! @}
 * end of CEComICEHtmlCheckBoxElementProxyRef
 */

/*! \defgroup CEComICEHtmlRadioElementProxyRef CEComICEHtmlRadioElementProxyRef
 * @{
 */

class CEComICEHtmlRadioElementProxyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlRadioElementProxyRef() : _iRadioElementProxy(0) {}
	CEComICEHtmlRadioElementProxyRef(ICEHtmlRadioElementProxy* iOther) : _iRadioElementProxy(0)
	{
		if (iOther)
		{
			_iRadioElementProxy = iOther;
			_iRadioElementProxy->_vtbl->_addRef(_iRadioElementProxy);
		}
	}

	CEComICEHtmlRadioElementProxyRef(const CEComICEHtmlRadioElementProxyRef& other) : _iRadioElementProxy(0)
	{
		if (other._iRadioElementProxy)
		{
			_iRadioElementProxy = other._iRadioElementProxy;
			_iRadioElementProxy->_vtbl->_addRef(_iRadioElementProxy);
		}
	}

	~CEComICEHtmlRadioElementProxyRef()
	{
		if (_iRadioElementProxy)
		{
			ICEHtmlRadioElementProxy* tmp = _iRadioElementProxy;
			_iRadioElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlRadioElementProxy* iRadioElementProxy;
				void* _ptr;
			} uIntf;
			uIntf.iRadioElementProxy = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlRadioElementProxy, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iRadioElementProxy)
				{
					ICEHtmlRadioElementProxy* tmp = _iRadioElementProxy;
					_iRadioElementProxy = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iRadioElementProxy = uIntf.iRadioElementProxy;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlRadioElementProxy* object() const	{ return _iRadioElementProxy; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlRadioElementProxy* iOther)
	{
		if (_iRadioElementProxy)
		{
			ICEHtmlRadioElementProxy* tmp = _iRadioElementProxy;
			_iRadioElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iRadioElementProxy = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlRadioElementProxy* detach()
	{
		ICEHtmlRadioElementProxy* iIntf = _iRadioElementProxy;
		_iRadioElementProxy = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlRadioElementProxy* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iRadioElementProxy;
		if (_iRadioElementProxy)
		{
			_iRadioElementProxy->_vtbl->_addRef(_iRadioElementProxy);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlRadioElementProxy*() const	{ return _iRadioElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlRadioElementProxy& operator*() const	{ return *_iRadioElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iRadioElementProxy == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlRadioElementProxy* iOther) const	{ return (_iRadioElementProxy != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlRadioElementProxy* iOther) const	{ return (_iRadioElementProxy == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlRadioElementProxyRef& operator=(const CEComICEHtmlRadioElementProxyRef& other)	{ return operator=(other._iRadioElementProxy); }

	CEComICEHtmlRadioElementProxyRef& operator=(const ICEHtmlRadioElementProxy* iOther)
	{
		if (_iRadioElementProxy != iOther)
		{
			if (_iRadioElementProxy)
			{
				ICEHtmlRadioElementProxy* tmp = _iRadioElementProxy;
				_iRadioElementProxy = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iRadioElementProxy = const_cast<ICEHtmlRadioElementProxy*>(iOther);
			if (_iRadioElementProxy)
			{
				_iRadioElementProxy->_vtbl->_addRef(_iRadioElementProxy);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlRadioElementProxy** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlRadioElementProxyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iRadioElementProxy && "has a com object reference. clear first.");
		return & _iRadioElementProxy; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlRadioElementProxyRef& other)
	{
		bool result = false;
		if (_iRadioElementProxy)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iRadioElementProxy);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_queryInterface(_iRadioElementProxy, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iRadioElementProxy) { _iRadioElementProxy->_vtbl->_addRef(_iRadioElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iRadioElementProxy) { _iRadioElementProxy->_vtbl->_release(_iRadioElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementId(CEHtmlElementId* elemIdOut)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_getElementId(_iRadioElementProxy, elemIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAttributeString(CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_getAttributeString(_iRadioElementProxy, attrId, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDocument(struct ICEHtmlDocument* *const iDocumentOut)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_getDocument(_iRadioElementProxy, iDocumentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isAvailable(bool *const isAvailableOut)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_isAvailable(_iRadioElementProxy, isAvailableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getColor(CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_getColor(_iRadioElementProxy, colorType, colorOut, undefinedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isBackgroundTransparent(bool *const transparentOut)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_isBackgroundTransparent(_iRadioElementProxy, transparentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBoxValue(CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_getBoxValue(_iRadioElementProxy, type, useRenderingVTPathId, insetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCharacterType(characterTypeValue* charTypeOut, imeModeValue* imeModeOut)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_getCharacterType(_iRadioElementProxy, charTypeOut, imeModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFont(struct ICEUICompositeFont* *const iFontOut)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_getFont(_iRadioElementProxy, iFontOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRect(CEHtmlElementRectType rectType, CERect *const rectOut)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_getRect(_iRadioElementProxy, rectType, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isVisible(bool *const visibleOut)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_isVisible(_iRadioElementProxy, visibleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult calculateBoundingRectangle(CERect *const rectOut)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_calculateBoundingRectangle(_iRadioElementProxy, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBackgroundRepeat(CEHtmlElementRepeatType *const repeatOut)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_getBackgroundRepeat(_iRadioElementProxy, repeatOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTLStyles(CEHtmlTLStyle *const tlStyleOut)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_getTLStyles(_iRadioElementProxy, tlStyleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureEditMode()	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_ensureEditMode(_iRadioElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult exitEditMode()	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_exitEditMode(_iRadioElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureFocus()	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_ensureFocus(_iRadioElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult loseFocus()	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_loseFocus(_iRadioElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isEditMode(bool *const isEditModeOut)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_isEditMode(_iRadioElementProxy, isEditModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult renderBorder(struct ICEUIGraphicsContext* iGC, CERect* borderRect)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_renderBorder(_iRadioElementProxy, iGC, borderRect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormElement(struct ICEHtmlFormElementProxy* *const iFormElement)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_getFormElement(_iRadioElementProxy, iFormElement) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult genericEvent(CEHtmlEventId eventId)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_genericEvent(_iRadioElementProxy, eventId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFormValue(struct ICEUString* iFormStr)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_setFormValue(_iRadioElementProxy, iFormStr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFormValue(bool isDefault, struct ICEUString* *const iFormStrOut)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_getFormValue(_iRadioElementProxy, isDefault, iFormStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isDisabled(bool *const disabledOut)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_isDisabled(_iRadioElementProxy, disabledOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isSelected(bool bDefault, bool *const isSelectedOut)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_isSelected(_iRadioElementProxy, bDefault, isSelectedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setSelected(bool bIsSelected)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_setSelected(_iRadioElementProxy, bIsSelected) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getName(struct ICEUString* *const iNameOut)	{ return _iRadioElementProxy ? _iRadioElementProxy->_vtbl->_getName(_iRadioElementProxy, iNameOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlRadioElementProxy* _iRadioElementProxy;
};

/*! @}
 * end of CEComICEHtmlRadioElementProxyRef
 */

/*! \defgroup CEComICEHtmlPluginElementProxyRef CEComICEHtmlPluginElementProxyRef
 * @{
 */

class CEComICEHtmlPluginElementProxyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlPluginElementProxyRef() : _iPluginElementProxy(0) {}
	CEComICEHtmlPluginElementProxyRef(ICEHtmlPluginElementProxy* iOther) : _iPluginElementProxy(0)
	{
		if (iOther)
		{
			_iPluginElementProxy = iOther;
			_iPluginElementProxy->_vtbl->_addRef(_iPluginElementProxy);
		}
	}

	CEComICEHtmlPluginElementProxyRef(const CEComICEHtmlPluginElementProxyRef& other) : _iPluginElementProxy(0)
	{
		if (other._iPluginElementProxy)
		{
			_iPluginElementProxy = other._iPluginElementProxy;
			_iPluginElementProxy->_vtbl->_addRef(_iPluginElementProxy);
		}
	}

	~CEComICEHtmlPluginElementProxyRef()
	{
		if (_iPluginElementProxy)
		{
			ICEHtmlPluginElementProxy* tmp = _iPluginElementProxy;
			_iPluginElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlPluginElementProxy* iPluginElementProxy;
				void* _ptr;
			} uIntf;
			uIntf.iPluginElementProxy = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlPluginElementProxy, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iPluginElementProxy)
				{
					ICEHtmlPluginElementProxy* tmp = _iPluginElementProxy;
					_iPluginElementProxy = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iPluginElementProxy = uIntf.iPluginElementProxy;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPluginElementProxy* object() const	{ return _iPluginElementProxy; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlPluginElementProxy* iOther)
	{
		if (_iPluginElementProxy)
		{
			ICEHtmlPluginElementProxy* tmp = _iPluginElementProxy;
			_iPluginElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iPluginElementProxy = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlPluginElementProxy* detach()
	{
		ICEHtmlPluginElementProxy* iIntf = _iPluginElementProxy;
		_iPluginElementProxy = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlPluginElementProxy* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iPluginElementProxy;
		if (_iPluginElementProxy)
		{
			_iPluginElementProxy->_vtbl->_addRef(_iPluginElementProxy);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlPluginElementProxy*() const	{ return _iPluginElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPluginElementProxy& operator*() const	{ return *_iPluginElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iPluginElementProxy == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlPluginElementProxy* iOther) const	{ return (_iPluginElementProxy != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlPluginElementProxy* iOther) const	{ return (_iPluginElementProxy == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlPluginElementProxyRef& operator=(const CEComICEHtmlPluginElementProxyRef& other)	{ return operator=(other._iPluginElementProxy); }

	CEComICEHtmlPluginElementProxyRef& operator=(const ICEHtmlPluginElementProxy* iOther)
	{
		if (_iPluginElementProxy != iOther)
		{
			if (_iPluginElementProxy)
			{
				ICEHtmlPluginElementProxy* tmp = _iPluginElementProxy;
				_iPluginElementProxy = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iPluginElementProxy = const_cast<ICEHtmlPluginElementProxy*>(iOther);
			if (_iPluginElementProxy)
			{
				_iPluginElementProxy->_vtbl->_addRef(_iPluginElementProxy);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPluginElementProxy** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlPluginElementProxyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iPluginElementProxy && "has a com object reference. clear first.");
		return & _iPluginElementProxy; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlPluginElementProxyRef& other)
	{
		bool result = false;
		if (_iPluginElementProxy)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iPluginElementProxy);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_queryInterface(_iPluginElementProxy, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iPluginElementProxy) { _iPluginElementProxy->_vtbl->_addRef(_iPluginElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iPluginElementProxy) { _iPluginElementProxy->_vtbl->_release(_iPluginElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementId(CEHtmlElementId* elemIdOut)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_getElementId(_iPluginElementProxy, elemIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAttributeString(CEHtmlAttributeId attrId, struct ICEUString* *const iStrOut)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_getAttributeString(_iPluginElementProxy, attrId, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDocument(struct ICEHtmlDocument* *const iDocumentOut)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_getDocument(_iPluginElementProxy, iDocumentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isAvailable(bool *const isAvailableOut)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_isAvailable(_iPluginElementProxy, isAvailableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getColor(CEHtmlElementColorType colorType, CERGBColor *const colorOut, bool* undefinedOut)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_getColor(_iPluginElementProxy, colorType, colorOut, undefinedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isBackgroundTransparent(bool *const transparentOut)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_isBackgroundTransparent(_iPluginElementProxy, transparentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBoxValue(CEHtmlElementBoxType type, bool useRenderingVTPathId, CEInsetsBase *const insetOut)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_getBoxValue(_iPluginElementProxy, type, useRenderingVTPathId, insetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCharacterType(characterTypeValue* charTypeOut, imeModeValue* imeModeOut)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_getCharacterType(_iPluginElementProxy, charTypeOut, imeModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFont(struct ICEUICompositeFont* *const iFontOut)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_getFont(_iPluginElementProxy, iFontOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRect(CEHtmlElementRectType rectType, CERect *const rectOut)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_getRect(_iPluginElementProxy, rectType, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isVisible(bool *const visibleOut)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_isVisible(_iPluginElementProxy, visibleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult calculateBoundingRectangle(CERect *const rectOut)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_calculateBoundingRectangle(_iPluginElementProxy, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBackgroundRepeat(CEHtmlElementRepeatType *const repeatOut)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_getBackgroundRepeat(_iPluginElementProxy, repeatOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTLStyles(CEHtmlTLStyle *const tlStyleOut)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_getTLStyles(_iPluginElementProxy, tlStyleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureEditMode()	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_ensureEditMode(_iPluginElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult exitEditMode()	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_exitEditMode(_iPluginElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult ensureFocus()	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_ensureFocus(_iPluginElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult loseFocus()	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_loseFocus(_iPluginElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isEditMode(bool *const isEditModeOut)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_isEditMode(_iPluginElementProxy, isEditModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getPluginInstance(struct ICEHtmlPluginInstance* *const iPluginInstance)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_getPluginInstance(_iPluginElementProxy, iPluginInstance) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getWindowScriptable(struct ICEScriptable* *const iScriptableOut)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_getWindowScriptable(_iPluginElementProxy, iScriptableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getScriptContext(struct ICEScriptContext* *const iScriptContextOut)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_getScriptContext(_iPluginElementProxy, iScriptContextOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getJSContext(struct ICEJSContext* *const iJSContextOut)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_getJSContext(_iPluginElementProxy, iJSContextOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult postMessage(struct ICEUnknown* iUnknown)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_postMessage(_iPluginElementProxy, iUnknown) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getScriptable(struct ICEScriptable* *const iScriptableOut)	{ return _iPluginElementProxy ? _iPluginElementProxy->_vtbl->_getScriptable(_iPluginElementProxy, iScriptableOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlPluginElementProxy* _iPluginElementProxy;
};

/*! @}
 * end of CEComICEHtmlPluginElementProxyRef
 */

/*! \defgroup CEComICEHtmlPluginElementJointRef CEComICEHtmlPluginElementJointRef
 * @{
 */

class CEComICEHtmlPluginElementJointRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlPluginElementJointRef() : _iPluginElementJoint(0) {}
	CEComICEHtmlPluginElementJointRef(ICEHtmlPluginElementJoint* iOther) : _iPluginElementJoint(0)
	{
		if (iOther)
		{
			_iPluginElementJoint = iOther;
			_iPluginElementJoint->_vtbl->_addRef(_iPluginElementJoint);
		}
	}

	CEComICEHtmlPluginElementJointRef(const CEComICEHtmlPluginElementJointRef& other) : _iPluginElementJoint(0)
	{
		if (other._iPluginElementJoint)
		{
			_iPluginElementJoint = other._iPluginElementJoint;
			_iPluginElementJoint->_vtbl->_addRef(_iPluginElementJoint);
		}
	}

	~CEComICEHtmlPluginElementJointRef()
	{
		if (_iPluginElementJoint)
		{
			ICEHtmlPluginElementJoint* tmp = _iPluginElementJoint;
			_iPluginElementJoint = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlPluginElementJoint* iPluginElementJoint;
				void* _ptr;
			} uIntf;
			uIntf.iPluginElementJoint = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlPluginElementJoint, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iPluginElementJoint)
				{
					ICEHtmlPluginElementJoint* tmp = _iPluginElementJoint;
					_iPluginElementJoint = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iPluginElementJoint = uIntf.iPluginElementJoint;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPluginElementJoint* object() const	{ return _iPluginElementJoint; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlPluginElementJoint* iOther)
	{
		if (_iPluginElementJoint)
		{
			ICEHtmlPluginElementJoint* tmp = _iPluginElementJoint;
			_iPluginElementJoint = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iPluginElementJoint = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlPluginElementJoint* detach()
	{
		ICEHtmlPluginElementJoint* iIntf = _iPluginElementJoint;
		_iPluginElementJoint = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlPluginElementJoint* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iPluginElementJoint;
		if (_iPluginElementJoint)
		{
			_iPluginElementJoint->_vtbl->_addRef(_iPluginElementJoint);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlPluginElementJoint*() const	{ return _iPluginElementJoint; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPluginElementJoint& operator*() const	{ return *_iPluginElementJoint; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iPluginElementJoint == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlPluginElementJoint* iOther) const	{ return (_iPluginElementJoint != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlPluginElementJoint* iOther) const	{ return (_iPluginElementJoint == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlPluginElementJointRef& operator=(const CEComICEHtmlPluginElementJointRef& other)	{ return operator=(other._iPluginElementJoint); }

	CEComICEHtmlPluginElementJointRef& operator=(const ICEHtmlPluginElementJoint* iOther)
	{
		if (_iPluginElementJoint != iOther)
		{
			if (_iPluginElementJoint)
			{
				ICEHtmlPluginElementJoint* tmp = _iPluginElementJoint;
				_iPluginElementJoint = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iPluginElementJoint = const_cast<ICEHtmlPluginElementJoint*>(iOther);
			if (_iPluginElementJoint)
			{
				_iPluginElementJoint->_vtbl->_addRef(_iPluginElementJoint);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPluginElementJoint** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlPluginElementJointRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iPluginElementJoint && "has a com object reference. clear first.");
		return & _iPluginElementJoint; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlPluginElementJointRef& other)
	{
		bool result = false;
		if (_iPluginElementJoint)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iPluginElementJoint);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iPluginElementJoint ? _iPluginElementJoint->_vtbl->_queryInterface(_iPluginElementJoint, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iPluginElementJoint) { _iPluginElementJoint->_vtbl->_addRef(_iPluginElementJoint); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iPluginElementJoint) { _iPluginElementJoint->_vtbl->_release(_iPluginElementJoint); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult onShutdown(CEHtmlShutdownType type)	{ return _iPluginElementJoint ? _iPluginElementJoint->_vtbl->_onShutdown(_iPluginElementJoint, type) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlPluginElementJoint* _iPluginElementJoint;
};

/*! @}
 * end of CEComICEHtmlPluginElementJointRef
 */

#endif // __cplusplus

#endif
