///////////////////////////////////////////////////////////////////////////////
// Copyright 2004,2007,2008,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CESysConfigHydra_h__
#define __CESysConfigHydra_h__

////////////////////////////////////////////////
//  Syswrap System Facility Configurations
////////////////////////////////////////////////

//! InterlockedSList
//! if 0, portable InterlockedSList (using CAS) is used
//! if 1, platform dependent InterlockedSList is used
#if !defined(CE_HAVE_INTERLOCKEDSLIST)
#define CE_HAVE_INTERLOCKEDSLIST 0		// cross-platform
#endif

//! CAS(Compare-and-Swap) for 64bit type
//! if 0, CAS64 is not available on this platform
//! if 1, CAS64 is available on this platform
#if !defined(CE_HAVE_CAS64)
#define CE_HAVE_CAS64 0 
#endif


////////////////////////////////////////////////
//  Syswrap libc Configurations
////////////////////////////////////////////////

//! memcpy_s
//! if CE_HAVE_MEMCPY_S==1, platform's memcpy_s() is used.
//! Otherwise, portable memcpy_s() implementation is used
#if !defined(CE_HAVE_MEMCPY_S)
#define CE_HAVE_MEMCPY_S 0
#endif

//! memmove_s
//! if CE_HAVE_MEMMOVE_S==1, platform's memmove_s() is used.
//! Otherwise, portable memmove_s() implementation is used
#if !defined(CE_HAVE_MEMMOVE_S)
#define CE_HAVE_MEMMOVE_S 0
#endif

//! memcmp
//! if CE_HAVE_MEMCMP==1, platform's memcmp() is used.
//! Otherwise, portable memcmp() implementation is used
#if !defined(CE_HAVE_MEMCMP)
#define CE_HAVE_MEMCMP 0
#endif



//! bsearch
//! if CE_HAVE_BSEARCH_S==1, platform's bsearch_s() is used.
//! Otherwise, portable bsearch_s() implementation is used
#if !defined(CE_HAVE_BSEARCH_S)
#define CE_HAVE_BSEARCH_S 0
#endif

//! qsort
//! if CE_HAVE_QSORT_S==1, platform's qsort_s() is used.
//! Otherwise, portable qsort_s() implementation is used
#if !defined(CE_HAVE_QSORT_S)
#define CE_HAVE_QSORT_S 0
#endif


////////////////////////////////////////////////
//  Syswrap Statistics Configurations
////////////////////////////////////////////////

//! CESysMemory function call stat
//! if SYSMEMORY_FUNC_STAT==1, gather funcall stats
//! Otherwise, no stat gathered
#if !defined(SYSMEMORY_FUNC_STAT)
#define SYSMEMORY_FUNC_STAT 0
#endif

#endif // __CESysConfigHydra_h__
