///////////////////////////////////////////////////////////////////////////////
// Copyright 2004,2008,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CESysCondVar_h__
#define __CESysCondVar_h__

#include "CESysConfig.h"
#include "CESysConst.h"
#include "CESysCriticalSection.h"


#ifdef __cplusplus
extern "C"
{
#endif

	typedef struct _CESysCondVar
	{
		double reserved[7];
	} CESysCondVar;


	//! Initialize the condition variable with the critical section
	//! \param[in]  cs       the critical section to be used with the conditional variable
	//! \param[out] condvar  pointer to the condition variable to be initilized
	CE_DLL_EXPORT void CESysInitializeConditionVariableCS(CESysCriticalSection* cs, CESysCondVar* condvarOut);

	//! Delete the condition variable
	//! \param[in] condvar  the conditional variable to be deleted
	CE_DLL_EXPORT void CESysDeleteConditionVariable(CESysCondVar* condvar);

	//! Sleep until the condition variable signaled
	//! \param[in] condvar     the conditional variable
	//! \param[in] uscTimeout  specifies the timeout in microseconds
	//! \return true: if the conditional variable is signaled. 
	//!         false otherwise.
	//! \note if usecTimeout=0, this function behaves just like trylock.
	//!       if usecTimeout=eCESysUSecTimeout_Infinite, this function waits infinitely until signaled.
	//!
	//! \note Before you call CESysSleepConditionVariableCS, you have to call CESysEnterCriticalSection().
	CE_DLL_EXPORT bool CESysSleepConditionVariableCS(CESysCondVar* condvar, INT32 usecTimeout);

	//! Wakeup one condition variable waiting thread
	//! \param[in] condvar     the conditional variable
	CE_DLL_EXPORT void CESysWakeConditionVariable(CESysCondVar* condvar);

	//! Wakeup all condition variable waiting thread
	//! \param[in] condvar     the conditional variable
	CE_DLL_EXPORT void CESysWakeAllConditionVariable(CESysCondVar* condvar);


#ifdef __cplusplus
}
#endif

#endif // __CESysCondVar_h__
