///////////////////////////////////////////////////////////////////////////////
// Copyright 2008,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef CESysAtomicOpsHydra_h
#define CESysAtomicOpsHydra_h

#ifdef __cplusplus
extern "C"
{
#endif

#define CESYS_ATOMIC_UNLIKELY(x) (x)

#define CE_HAVE_NATIVE_CAS32 1
static CE_FORCEINLINE INT32 CESysInterlockedCompareExchange(CESysAtomicINT32* dest, INT32 newValue, INT32 expectedValue)
{
	INT32 old;
	do
	{
		old = __ldrex((volatile int*)dest);
		if ( old != expectedValue )
			break;
	} while ( CESYS_ATOMIC_UNLIKELY( 0 != __strex((unsigned int)newValue, (volatile int*)dest) ) );
	return old;
}

#define CE_HAVE_NATIVE_CAS64 1
static CE_FORCEINLINE INT64 CESysInterlockedCompareExchange64(CESysAtomicINT64* dest, INT64 newValue, INT64 expectedValue)
{
	INT64 old;
	do
	{
		old = __ldrexd((volatile long long*)dest);
		if ( old != expectedValue )
			break;
	} while ( CESYS_ATOMIC_UNLIKELY( 0 != __strexd((unsigned long long)newValue, (volatile long long*)dest) ) );
	return old;
}

#ifdef __cplusplus
};
#endif


#endif	// #ifndef CESysAtomicOpsHydra_h
