///////////////////////////////////////////////////////////////////////////////
// Copyright 2006 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CEPixelFormat_h__
#define __CEPixelFormat_h__


#define CEPixelFormatSeparatedSurfaces(fmt1, fmt2) ((fmt1) | ((fmt2)<<8))

typedef enum CEPixelFormat
{
    CEPixelFormat_FIRST,

    //
    // Indexed Color
    //
    CEPixelFormat_None = CEPixelFormat_FIRST,
    CEPixelFormat_P8 = CEPixelFormat_FIRST,
		
    //
    // Direct Color
    //

    // 16bit/pixel
    CEPixelFormat_X1R5G5B5,
    CEPixelFormat_A1R5G5B5,
    CEPixelFormat_R5G6B5,

    // 24bit/pixel
    CEPixelFormat_R8G8B8,

    // 32bit/pixel
    CEPixelFormat_X8R8G8B8,
    CEPixelFormat_A8R8G8B8,

	// platform endian, Pre-multiplied 32bit/pixel
	CEPixelFormat_PA8R8G8B8,

    //
    // Mask/Alpha
    //

    // 1bit/pixel
    CEPixelFormat_A1,

    // 8bit/pixel
    CEPixelFormat_A8,
	CEPixelFormat_L8,			// luminance
    CEPixelFormat_X1A7,

	CEPixelFormat_L8A8,

    CEPixelFormat_LAST = CEPixelFormat_L8A8,

    CEPixelFormat_Unknown,


    ////////////////////////////////////////////////
    //  Image pixel format for separated surfaces
    ////////////////////////////////////////////////

    CEPixelFormat_X1R5G5B5_A8	= CEPixelFormatSeparatedSurfaces(CEPixelFormat_X1R5G5B5, CEPixelFormat_A8),
    CEPixelFormat_R8G8B8_A8	= CEPixelFormatSeparatedSurfaces(CEPixelFormat_R8G8B8, CEPixelFormat_A8),

} CEPixelFormat;

typedef enum eCEGfxAlphaType
{
	eCEGfxAlphaType_MultiLevel = 0,	//!< all pixel can have any alpha values from 0.0 to 1.0
	eCEGfxAlphaType_ZeroOrOne,		//!< all pixel's alpha values are 0.0(transparent) or 1.0(opaque)
	eCEGfxAlphaType_One,			//!< all pixels are opaque
	eCEGfxAlphaType_Zero,			//!< all pixels are transparent (this image is perfectly invisible)
} eCEGfxAlphaType;

typedef enum eCEDXAlphaType
{
	eCEDXAlphaType_MultiLevel = 0,	//!< all pixel can have any alpha values from 0.0 to 1.0
	eCEDXAlphaType_ZeroOrOne,		//!< all pixel's alpha values are 0.0(transparent) or 1.0(opaque)
	eCEDXAlphaType_One,				//!< all pixels are opaque
	eCEDXAlphaType_Zero,			//!< all pixels are transparent (this image is perfectly invisible)
} eCEDXAlphaType;

#endif // __CEPixelFormat_h__
