///////////////////////////////////////////////////////////////////////////////
// Copyright 2006 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef CEHtmlWindowCommon_h
#define CEHtmlWindowCommon_h

///////////////////////////////////////////////////////////////////////
// Window Creation Flags 
///////////////////////////////////////////////////////////////////////
enum CEFrameWindowCreationFlag
{
	// window open parameters
	CEFrameWindowCreationFlag_HasToolBar			= 1 << 0, //! created window should have tool bar
	CEFrameWindowCreationFlag_HasMenuBar			= 1 << 1, //! created window should have menu bar
	CEFrameWindowCreationFlag_HasLocationBar		= 1 << 2, //! created window should have location bar
	CEFrameWindowCreationFlag_HasTitleBar			= 1 << 3, //! created window should have title bar
	CEFrameWindowCreationFlag_HasStatusBar			= 1 << 4, //! created window should have status bar
	CEFrameWindowCreationFlag_IsFullScreen			= 1 << 5, //! created window should be full screen mode
	CEFrameWindowCreationFlag_IsResizeable			= 1 << 6, //! created window should be resizable
	CEFrameWindowCreationFlag_HasScrollbars			= 1 << 7, //! created window should have scroll bars
};

///////////////////////////////////////////////////////////////////////
// Invoker Type
///////////////////////////////////////////////////////////////////////
enum CEHtmlInvokerType
{
	CEHtmlInvokerType_Unknown = 0, //! Unknown invoker
	CEHtmlInvokerType_System = 1, //! The operation is invoked by the browser core
	CEHtmlInvokerType_Application = 2, //! The operation is invoked by the application
	CEHtmlInvokerType_Html = 3, //! The operation is invoked by html
	CEHtmlInvokerType_Javascript = 4, //! The operation is invoked by javascript
};


///////////////////////////////////////////////////////////////////////
// Scrollbar setting
///////////////////////////////////////////////////////////////////////
enum HtmlFrameScrolling
{
	eHtmlFrameScrolling_Undefined = -1,
	eHtmlFrameScrolling_No = 0,                 //! 0000 0000 No scroll bars
	eHtmlFrameScrolling_Yes = 1,                //! 0000 0001 Scroll bars always appear
	eHtmlFrameScrolling_Auto = 2,               //! 0000 0010 Scroll bars appear if need

	eHtmlFrameScrolling_Vertical_No     = 0x04, //! 0000 0100 No vertical scroll bar
	eHtmlFrameScrolling_Vertical_Yes    = 0x08, //! 0000 1000 Vertical scrollbar always appears
	eHtmlFrameScrolling_Vertical_Auto   = 0x10, //! 0001 0000 Vertical scrollbar appears if need
	eHtmlFrameScrolling_Horizontal_No   = 0x20, //! 0010 0000 No horizontal scroll bar
	eHtmlFrameScrolling_Horizontal_Yes  = 0x40, //! 0100 0000 Horizontal scrollbar always appears
	eHtmlFrameScrolling_Horizontal_Auto = 0x80, //! 1000 0000 Horizontal scrollbar appears if need
};


////////////////////////////////////////////////////////////////
//security warnings
////////////////////////////////////////////////////////////////
enum CEHtmlApiSecurityWarningType
{
	SecurityWarningType_EnteredSecureSite = 0, //! Warn that the browser entered to secure site
	SecurityWarningType_LeavingSecureSite = 1, //! Warn that the browser entered to insecure site
	SecurityWarningType_PostingInsecureData = 2, //! Warn that the browser is about posting insecure data by post
	SecurityWarningType_PostingInsecureDataFromSecureSite = 3,  //! Warn that the browser is about posting insecure data from secure site
	SecurityWarningType_MixedSecurityContext = 4, //! Warn that the browser entered  to mixed security site
	SecurityWarningType_LowEncryption = 5,
	SecurityWarningType_SendingInsecureForm = 6, //! Warn that the browser is about sending insecure form data
	SecurityWarningType_SendingInsecureFormFromSecureSite = 7, //! Warn that the browser is about sending insecure form data from secure site
	SecurityWarningType_PostingFromCache = 8, //! Warn that the browser is about posting form data retrieved from the cache
	SecurityWarningType_LeavingSecureSiteAtRedirection = 9, //! Warn that the browser entered to insecure site when redirection occurred
};

#endif
