///////////////////////////////////////////////////////////////////////////////
// Copyright 2004,2005,2006,2007 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CEDXTypes_h__
#define __CEDXTypes_h__

#include "CESysDefs.h"
#include "CEPixelFormat.h"
#include "CEDXMathTypes.h"
#include "CECom.h"


//! surface descprition
struct CEDXSurfaceDesc
{
	////////////////////////////////////////////////////////////////
	// operator new, delete, new[] and delete[].
	////////////////////////////////////////////////////////////////
	CEALLOCATORS;

	CEPixelFormat	_format;		//!< pixel format
	UINT32			_width;			//!< in pixel
	UINT32			_height;		//!< in pixel
};

//! locked rectangle
struct CEDXLockedRect
{
	////////////////////////////////////////////////////////////////
	// operator new, delete, new[] and delete[].
	////////////////////////////////////////////////////////////////
	CEALLOCATORS;

	void*	_baseAddr;			//!< the origin of the locked rectangle.
	INT_PTR	_pitch;				//!< positive pitch means top to bottom. in bytes.
};


//! Shader program unique ID.
//! currently only pre-defined shader programs are supported.
//! TODO: [Bug 5610]  need to support more shaders.
typedef UINT32 CEDXShaderID;
#define CEDXShaderID_ColorOnly_VS		(0)
#define CEDXShaderID_ColorOnly_PS		(1)
#define CEDXShaderID_TextureOnly_VS		(2)
#define CEDXShaderID_TextureOnly_PS		(3)
#define CEDXShaderID_DrawText_VS		(4)
#define CEDXShaderID_DrawText_PS		(5)
#define CEDXShaderID_Palette_PS			(6)
#define CEDXShaderID_LAST				(7)

//! Shader's parameter ID type.
//! corresponding to CGparameter in Cg.
typedef void* CEDXShaderParameter;

//! Values for ICEDXDevice::setStreamSourceFreq's Setting parameter
//! those values are compatible with Direct3D. this is important for DX implemented on Direct3D.
#define CEDXStreamSource_IndexedData		(1<<30)
#define CEDXStreamSource_InstanceData		(2<<30)

// This is used to initialize the last vertex element in a vertex declaration array.
#define CEDXDECL_END() {0xFF,0,eCEDXDeclType_Unused,0,0,0}



enum eCEDpyWindowLevel
{
	eCEWindowLevel_Desktop = 0,	//!< 
	eCEWindowLevel_Default,		//!< 
	eCEWindowLevel_Modal,		//!< 
	eCEWindowLevel_Status,		//!< 
	eCEWindowLevel_LevelNum
};



#endif //__CEDXTypes_h__
