# -*- tab-width: 8 -*- 
########################################################################################################
### gencomcls.pl
########################################################################################################
use strict;

my(%CCD) = {};
my(%IDL) = {};
my(%CPPHEADER) = {};
my($FND_TRANS_FLAG) = 0;

require 'idlfuncs.pl';
require 'ccdfuncs.pl';

if (&getOSName() eq 'MSWin32')
{
    require 'mswinutil.pl';
}

#for JNI.
require 'classfuncs.pl';

# enable to test @@response_env_variable
#system("set");

{
    if (!@ARGV)
    {
	print(STDERR "Error: Specify input file name.\n");
	print(STDERR "----------------------------------------------------------\n");
	print(STDERR "Useage: gencomcls.pl [options] input.ccd\n");
	print(STDERR "Options:\n");
	print(STDERR "  -Iinclude_dir\tSpecify including path of IDL and header file.\n");
	print(STDERR "  \@\@response_envval_name\tOptional. environment variable name to specify a white space separated list of optional arguments.\n");
	print(STDERR "  -d directory\tSpecify output directory name.\n");
	exit;
    }

    my($CCD_FILE) = pop(@ARGV);
    if (!(-r $CCD_FILE))
    {
	die("Error: Can not open file '$CCD_FILE' as input\n");
    }

    my($PARAM);
    my(@INCLUDEPATHS);
    my($OUTDIR);
    my($RULE_FILE_FLAG) = 0;
    my($RULE_FILE_OUTDIR) = 0;
    my($CWDIR);
    push(@INCLUDEPATHS, getPath($CCD_FILE));

    &ceccdutil::parseArgs(\@ARGV, \@INCLUDEPATHS, \$OUTDIR, \$CWDIR, \$RULE_FILE_FLAG, \$RULE_FILE_OUTDIR);

    &readCcdFile(\%CCD, \%IDL, \%CPPHEADER, $CCD_FILE, 0, @INCLUDEPATHS);

    ### write fnd trans file
    $FND_TRANS_FLAG = &hasFndTransOption($CCD_FILE);
    if ($FND_TRANS_FLAG)
    {
	&setFndTransFlag($FND_TRANS_FLAG);
	&writeHeaderFile($CCD_FILE, $OUTDIR);
	&writeImplementationFile($CCD_FILE, $OUTDIR);
	&setFndTransFlag(0);
	$FND_TRANS_FLAG = 0;
    }
    else
    {
	&writeHeaderFile($CCD_FILE, $OUTDIR);
	&writeImplementationFile($CCD_FILE, $OUTDIR);
    }
    if ($RULE_FILE_FLAG)
    {
	if (!$RULE_FILE_OUTDIR)
	{
	    &writeRuleFile($CCD_FILE, $OUTDIR);
	}
	else
	{
	    &writeDepMakeFileWin($CCD_FILE, $OUTDIR, $CWDIR, $RULE_FILE_OUTDIR);
	}
    }
}

########################################################################################################
### write header file
########################################################################################################

sub writeHeaderFile
{
    my($CCD_FULLPATH, $OUTDIR) = @_;

    debugMode(0);

    my($H_FILE) = &getFileNameWithDir($CCD_FULLPATH, $OUTDIR, 'h');
    if ($H_FILE)
    {
 	open(FPW, ">$H_FILE") || die("Error: Can not open file $H_FILE as output\n");
    }

    &writeHeader($H_FILE);
    &writeString("\n");

    &writeDefine();

    my($CCD_FILE) = &deletePath($CCD_FULLPATH);
    &writeIncludeList(@{$CCD{$CCD_FILE}->{'include-h'}});
    &writeJNIHeader($CCD_FILE, @{$CCD{$CCD_FILE}->{'class'}});
    &writeString("\n");

    ### module at first
    if ($CCD{$CCD_FILE}->{'module'})
    {
	&writeModuleHeader($CCD{$CCD_FILE}->{'module'});
    }

    &writeBaseClassHeader(@{$CCD{$CCD_FILE}->{'class'}});

    &writeClassListHeader(@{$CCD{$CCD_FILE}->{'class'}});

    &writeSupportHeader($CCD{$CCD_FILE}, @{$CCD{$CCD_FILE}->{'class'}});

    &writeString("#endif\n");

    close(FPW);

    debugMode(0);
}

sub writeJNIHeader
{
    my($CCD_FILE, @CLASSES) = @_;
    my($CLASS_REF);
    my($USE_JNI);
    foreach $CLASS_REF (@CLASSES)
    {
	if ($CLASS_REF->{'java-to-c'})
	{
	    &writeString("#include <jni.h>\n");
	    last;
	}
    }
}

sub writeBaseClassHeader
{
    my(@CLASSES) = @_;
    my($CLASS_REF);
    foreach $CLASS_REF (@CLASSES)
    {
	#for JNI.
	my($USE_JNI) = $CLASS_REF->{'java-to-c'};
	my($USE_JNI_PEER) = $CLASS_REF->{'c-to-java'};

	my($REFERRED) = $CLASS_REF->{'referred'};
	if (!$REFERRED)
	{
	    my($MARSHAL) = $CLASS_REF->{'marshal'};
	    if ($MARSHAL eq ':ipc-marshal')
	    {
		&writeString("#include \"CERpcApi.h\"\n");
		&writeString("\n");
		&writeString("//----------------------------------------------------------------\n");
		&writeString("// base class of mashaller\n");
		&writeString("//----------------------------------------------------------------\n");
		&writeString("#ifndef class_CEIpcMarshallerBase\n");
		&writeString("#define class_CEIpcMarshallerBase\n");
		&writeString("\n");
		&writeString("class CEIpcMarshallerBase\n");
		&writeString("{\n");
		&writeAllocator($CLASS_REF->{'no-allocator'});
		&writeString("public:\n");

		if ($USE_JNI_PEER eq 0 and $USE_JNI eq 0)
		{
		    &writeString("\tvirtual ~CEIpcMarshallerBase() { _session = 0; }\n");
		    &writeString("\n");
		    &writeString("\tCERpcSession getSession() { return _session; }\n");
		    &writeString("\tvoid clearSession() { _session = 0; }\n");
		}
		else
		{
		    &writeString("\tvirtual ~CEIpcMarshallerBase() {}\n");
		}

		&writeString("\n");
		&writeString("protected:\n");
		&writeString("\tCEIpcMarshallerBase() {}\n");

		if ($USE_JNI_PEER eq 0 and $USE_JNI eq 0)
		{
		    &writeString("\tCEIpcMarshallerBase(CERpcSession session) : _session(session) {}\n");
		    &writeString("\n");
		    &writeString("private:\n");
		    &writeString("\tCERpcSession\t_session;\n");
		}

		&writeString("};\n");
		&writeString("\n");
		&writeString("#endif\n");
		&writeString("\n");
		last;
	    }
	}
    }
}

sub writeClassListHeader
{
    my(@CLASSES) = @_;
    my($CLASS_REF);
    foreach $CLASS_REF (@CLASSES)
    {
	my($REFERRED) = $CLASS_REF->{'referred'};
	if (!$REFERRED)
	{
	    my($NAME) = $CLASS_REF->{'name'};
	    if ($CLASS_REF->{'marshal'})
	    {
		$NAME = &getProxyClassName($CLASS_REF);
	    }

	    &writeString("//----------------------------------------------------------------\n");
	    &writeString("// $NAME.\n");
	    &writeString("//----------------------------------------------------------------\n");
	    &writeClassID($NAME);

	    my($INHERITANCE) = $CLASS_REF->{'inheritance'};
	    my($EMBED) = $CLASS_REF->{'embed'};
	    my($MARSHAL) = $CLASS_REF->{'marshal'};
	    my($MARSHAL_FACTORY) = $CLASS_REF->{'marshal-factory'};
	    my($FND_TRANS) = $CLASS_REF->{'fnd-trans'};
	    #for JNI.
	    my($USE_JNI) = $CLASS_REF->{'java-to-c'};
	    my($USE_JNI_PEER) = $CLASS_REF->{'c-to-java'};

	    my($FUNCTION_PREFIX) = 'Apm';
	    if ($CLASS_REF->{'function-prefix'})
	    {
		$FUNCTION_PREFIX = $CLASS_REF->{'function-prefix'};
	    }

	    my($SUBSTANCE);
	    if ($INHERITANCE)
	    {
		&writeString("class $NAME : public $INHERITANCE\n");
		$SUBSTANCE = $INHERITANCE;
	    }
	    elsif ($EMBED)
	    {
		&writeString("class $NAME\n");
		$SUBSTANCE = $EMBED;
	    }
	    elsif ($MARSHAL_FACTORY)
	    {
		my(%MODULE) = &getComModuleHash(\%CCD);
		my($ABST_FACTORY_NAME) = &getAbstractClassFactoryName($MODULE{'name'});
		&writeString("class $NAME : public $ABST_FACTORY_NAME\n");
		# keep $SUBSTANCE null
	    }
	    elsif ($MARSHAL)
	    {
		# keep $SUBSTANCE null
	    }
	    elsif ($FND_TRANS eq ':trans-from-fnd')
	    {
		&writeString("class $NAME\n");
	    }
	    else
	    {
		die("Error: :inherit or :embed or :*-marshal or :*-factory or :delegator-mirror should be specified.\n");
	    }
	    if ($SUBSTANCE || $MARSHAL_FACTORY)
	    {
		&writeString("{\n");
		&writeAllocator($CLASS_REF->{'no-allocator'});
		&writeConstructor($NAME, $CLASS_REF);

		&writeString("public:\n");
		&writeObjectMethod($NAME, $CLASS_REF);
		&writePointerInterfaceTranslationList($CLASS_REF, @{$CLASS_REF->{'interface'}});

		&writeString("private:\n");
		if ($SUBSTANCE)
		{
		    &writeClassMember($CLASS_REF);
		}
		elsif ($MARSHAL_FACTORY)
		{
		    &writeString("public:\n");
		    my($INTERFACE_REF) = $CLASS_REF->{'interface'}->[0];
		    &writeFunctionListWithInheritance(\%IDL, 'MARSHAL_FACTORY_FUNCTION_HEADER', $CLASS_REF, $INTERFACE_REF->{'name'}, 0, &getInterfaceHash(\%IDL, $INTERFACE_REF->{'name'}));

		}

		&writePointerToFunctionTable(@{$CLASS_REF->{'interface'}});
		&writeRefCount($CLASS_REF);
		&writeString("};\n");
		&writeString("\n");
	    }
	    elsif ($MARSHAL eq ':lw-marshal' || $MARSHAL eq ':std-marshal' || $MARSHAL eq ':ipc-marshal')
	    {
		## assume one interace per one impelentation class.
		## currently only lw.
		my($INTERFACE_COUNT) = 0;
		my($INTERFACES_REF) = $CLASS_REF->{'interface'};
		my($INTERFACE_REF);
		my($STUB_NAME);
		my($FIRST_INTERFACE_NAME);
		my($FIRST_ORIG_NAME);

		foreach $INTERFACE_REF (@{$INTERFACES_REF})
		{
		    if ($INTERFACE_COUNT == 0)
		    {
			## stub
			$STUB_NAME = &getStubClassName($CLASS_REF);
			$FIRST_INTERFACE_NAME = $INTERFACE_REF->{'name'};
			$FIRST_ORIG_NAME = &getStubOriginalInterfaceName($FIRST_INTERFACE_NAME);

			if ($MARSHAL eq ':ipc-marshal')
			{
			    &writeString("class $STUB_NAME : public CEIpcMarshallerBase\n");
			}
			else
			{
			    &writeString("class $STUB_NAME\n");
			}

			&writeString("{\n");
			&writeString("public:\n");

			if ($MARSHAL eq ':lw-marshal')
			{
			    &writeString("\t$STUB_NAME($FIRST_INTERFACE_NAME* orig) : $FIRST_ORIG_NAME(orig) {}\n");
			    &writeString("\t~$STUB_NAME()\n");
			    &writeString("\t{\n");
			    &writeString("\t\tCEComGlobalLock();\n");
			    &writeString("\t\t$FIRST_ORIG_NAME = 0;\n");
			    &writeString("\t\tCEComGlobalUnlock();\n");
			    &writeString("\t}\n");
			    
			}
			elsif ($MARSHAL eq ':std-marshal')
			{
			    &writeAllocator($CLASS_REF->{'no-allocator'});
			    &writeString("\t$STUB_NAME($FIRST_INTERFACE_NAME* orig) : $FIRST_ORIG_NAME(orig) {}\n");
			    &writeString("\t~$STUB_NAME()\n");
			    &writeString("\t{\n");
			    &writeString("\t\tCEASSERT(!$FIRST_ORIG_NAME);\n");
			    &writeString("\t}\n");
			}
			elsif ($MARSHAL eq ':ipc-marshal')
			{
			    &writeAllocator($CLASS_REF->{'no-allocator'});
			    my($IFACES_REF) = $CLASS_REF->{'interface'};
			    my($IFACE_REF);
			    foreach $IFACE_REF (@{$IFACES_REF})
			    {
				my($IFACE_NAME) = $IFACE_REF->{'name'};

				if ($USE_JNI_PEER)
				{
				    &writeString("\t$STUB_NAME($IFACE_NAME* orig)\n");
				}
				else
				{
				    &writeString("\t$STUB_NAME(CERpcSession session, $IFACE_NAME* orig) : CEIpcMarshallerBase(session)\n");
				}
				&writeString("\t{\n");
				my($QI_IFACES_REF) = $CLASS_REF->{'interface'};
				my($QI_IFACE_REF);
				foreach $QI_IFACE_REF (@{$QI_IFACES_REF})
				{
				    my($ORIG_NAME) = &getStubOriginalInterfaceName($QI_IFACE_REF->{'name'});
				    if ($USE_JNI_PEER)
				    {
					&writeString("\t\t${ORIG_NAME}JNI = (jobject) orig;\n");
				    }
				    else
				    {
					&writeString("\t\t$ORIG_NAME.initByQueryInterface(orig);\n");
				    }
				}
				&writeString("\t}\n");
			    }
			    &writeString("\t~$STUB_NAME() {}\n");
			}
			else
			{
			    die "Unknown type of marshaller: $MARSHAL\n";
			}
		    }
		    elsif ($MARSHAL ne ':ipc-marshal')
		    {
			last;
		    }
		    &writeString("\n");
		    &writeString("public:\n");

		    if ($MARSHAL ne ':ipc-marshal')
		    {
			my($IFACES_REF) = $CLASS_REF->{'interface'};
			my($IFACE_REF);
			foreach $IFACE_REF (@{$IFACES_REF})
			{
			    if ($MARSHAL eq ':lw-marshal')
			    {
				&writeFunctionListWithInheritance(\%IDL, 'LWSTUB_FUNCTION_HEADER', $CLASS_REF, $IFACE_REF->{'name'}, 0, &getInterfaceHash(\%IDL, $IFACE_REF->{'name'}));
			    }
			    elsif ($MARSHAL eq ':std-marshal')
			    {
				&writeFunctionListWithInheritance(\%IDL, 'STDSTUB_FUNCTION_HEADER', $CLASS_REF, $IFACE_REF->{'name'}, 0, &getInterfaceHash(\%IDL, $IFACE_REF->{'name'}));
			    }
			}
		    }
		    elsif ($MARSHAL eq ':ipc-marshal')
		    {
			&writeFunctionListWithInheritance(\%IDL, 'IPCSTUB_FUNCTION_HEADER', $CLASS_REF, $INTERFACE_REF->{'name'}, 0, &getInterfaceHash(\%IDL, $INTERFACE_REF->{'name'}));
		    }
		    else
		    {
			die "unknown marshal type: $MARSHAL";
		    }

		    &writeString("\n");
		    if ($MARSHAL eq ':std-marshal' || $MARSHAL eq ':ipc-marshal')
		    {
			my($IFACE_PREFIX);
			if ($MARSHAL eq ':ipc-marshal')
			{
			    $IFACE_PREFIX = $INTERFACE_REF->{'name'} . '_';
			}

			&writeEnumeratorAndStructures($IFACE_PREFIX, $INTERFACE_REF, $MARSHAL);

			&writeString("\tCEHResult invoke($IFACE_PREFIX" . "MethodId mid, void* param);\n");
			&writeString("\n");

			if ($MARSHAL ne ':ipc-marshal')
			{
			    &writeString("\tCEHResult static invoke_message_callback(UINT32 mid, void* param, void* userData)\n");
			    &writeString("\t{\n");
			    &writeString("\t\tCEASSERT(param && userData);\n");
			    &writeString("\t\t// only c style cast is allowed by vs.net\n");
			    &writeString("\t\treturn reinterpret_cast<$STUB_NAME*>(userData)->invoke((MethodId)mid, param);\n");
			    &writeString("\t}\n");
			}
		    }

		    my($INTERFACE_WRAPPER_NAME) = &getInterfaceWrapperName($INTERFACE_REF->{'name'});
		    my($ORIG_NAME) = &getStubOriginalInterfaceName($INTERFACE_REF->{'name'});
		    &writeString("public:\n");
		    &writeString("\t$INTERFACE_WRAPPER_NAME& get$INTERFACE_REF->{'name'}\(\) { return $ORIG_NAME; }\n");
		    &writeString("private:\n");
		    if ($USE_JNI_PEER)
		    {
			&writeString("\t$INTERFACE_WRAPPER_NAME $ORIG_NAME;\n");
			&writeString("\tjobject $ORIG_NAME" . "JNI;\n");
		    }
		    else
		    {
			&writeString("\t$INTERFACE_WRAPPER_NAME $ORIG_NAME;\n");
		    }
		    &writeString("\t\n");

		    $INTERFACE_COUNT++;
		}
		&writeString("};\n");
		&writeString("\n");

		{
		    ## proxy
		    my($PROXY_NAME) = &getProxyClassName($CLASS_REF);
		    my(%MODULE) = &getComModuleHash(\%CCD);

		    if ($MARSHAL eq ':lw-marshal' || $MARSHAL eq ':std-marshal')
		    {
			my($ABST_FACTORY_NAME) = &getAbstractClassFactoryName($MODULE{'name'});

			&writeString("class $PROXY_NAME : public ${ABST_FACTORY_NAME}::Object\n");
			&writeString("{\n");
			&writeString("public:\n");
			&writeString("\t$PROXY_NAME($ABST_FACTORY_NAME* pClazz, $FIRST_INTERFACE_NAME* orig, CEComICEApartmentRef apart);\n");
			&writeString("\t~$PROXY_NAME()\n");
			&writeString("\t{\n");
			&writeString("\t\t_apartment = 0;\n");
			&writeString("\t}\n");
		    }
		    elsif ($MARSHAL eq ':ipc-marshal')
		    {
			my($IID) = &getIIDName($FIRST_INTERFACE_NAME);
			my($STUB_NAME) = &getStubClassName($CLASS_REF);
			my($IFACE_PREFIX) = $FIRST_INTERFACE_NAME . '_';
			my($METHOD_ID) = "$STUB_NAME\:\:" . $IFACE_PREFIX . &getMethodIdName('release');
			&writeString("class $PROXY_NAME : public CEIpcMarshallerBase\n");
			&writeString("{\n");
			&writeString("public:\n");
			&writeAllocator($CLASS_REF->{'no-allocator'});
			&writeString("\t$PROXY_NAME(CERpcSession session, $STUB_NAME* stub);\n");
			&writeString("\t~$PROXY_NAME()\n");
			&writeString("\t{\n");
			&writeString("\t\t#if defined(MARSHALLER_DEBUG_PRINT)\n");
			&writeString("\t\tMARSHALLER_DEBUG_PRINT(\"$FIRST_INTERFACE_NAME\:\:release(proxy:%p  stub:%p)\\n\", this, _stub);\n");
			&writeString("\t\t#endif //defined(MARSHALLER_DEBUG_PRINT)\n");
			&writeString("\t\tCERpcInvokeRemote(getSession(), reinterpret_cast<UINT_PTR>(_stub), $IID, $METHOD_ID, 0, NULL);\n");
			&writeString("\t\tCERpcDisableProxy(getSession(), reinterpret_cast<UINT_PTR>(this));\n");
			&writeString("\t}\n");
		    }
		    else
		    {
			die "unknown marshalling type: $MARSHAL\n"
		    }

		    &writeString("\n");
		    &writePointerInterfaceTranslationList($CLASS_REF, @{$CLASS_REF->{'interface'}});
		    if ($MARSHAL eq ':lw-marshal' || $MARSHAL eq ':std-marshal')
		    {
			&writeString("\t$STUB_NAME& getStub() { return _stub; }\n");
			&writeString("\tICEApartment* getApartment() { return _apartment; }\n");
			&writeString("\n");
			&writeString("private:\n");
			&writeString("\t$STUB_NAME _stub;\n");
			&writeString("\tCEComICEApartmentRef _apartment;\n");
		    }
		    elsif ($MARSHAL eq ':ipc-marshal')
		    {
			&writeString("\t$STUB_NAME* getStub() { return _stub; }\n");
			&writeString("\t$STUB_NAME* _stub;\n");
			&writeRefCount($CLASS_REF);
		    }
		    &writePointerToFunctionTable(@{$CLASS_REF->{'interface'}});
		    &writeString("\t\n");

		    &writeString("};\n");
		    &writeString("\n");
		}
	    }
	    elsif ($FND_TRANS eq ':trans-from-fnd')
	    {
		&writeString("{\n");
		&writeAllocator($CLASS_REF->{'no-allocator'});
		&writeConstructor($NAME, $CLASS_REF);

		&writeString("public:\n");
		&writePointerInterfaceTranslationList($CLASS_REF, @{$CLASS_REF->{'interface'}});

		&writeString("private:\n");
		&writePointerToFunctionTable(@{$CLASS_REF->{'interface'}});
		&writeRefCount($CLASS_REF);
		
		my($REF) = "Ref";
		my($INTERFACES_REF) = $CLASS_REF->{'interface'};
		my($INTERFACE_REF);
		foreach $INTERFACE_REF (@{$INTERFACES_REF})
		{
		    my($INTERFACE_NAME) = $INTERFACE_REF->{'name'};
		    if (&isSpecialInterfaceForGenerator($INTERFACE_NAME))
		    {
			$INTERFACE_NAME = 'ICEUnknown';
		    }

		    my($FORCE_INLINE_GCC) = &getGccInlineOption();
		    my($SPX_INTERFACE_NAME) = &replaceIdlFilePrefixForPublic($INTERFACE_NAME);
		    my($SPX_INTERFACE_VALUE_NAME) = &getInterfaceValueName($SPX_INTERFACE_NAME);
		    my($SPX_PRIVATE_INTERFACE_VALUE_NAME) = &getPrivateInterfaceValueName($SPX_INTERFACE_NAME);
		    my($SPX_INTERFACE_WRAPPER_NAME) = &getInterfaceWrapperName($SPX_INTERFACE_NAME);
		    my($SPX_POINTER_VALUE_NAME) = &getPointerValueName($SPX_INTERFACE_NAME);
		    &writeString("public:\n");
		    &writeString("\t$FORCE_INLINE_GCC $SPX_INTERFACE_WRAPPER_NAME $SPX_POINTER_VALUE_NAME$REF() { return $SPX_PRIVATE_INTERFACE_VALUE_NAME$REF; }\n");
		    &writeString("private:\n");
		    &writeString("\t$SPX_INTERFACE_WRAPPER_NAME $SPX_PRIVATE_INTERFACE_VALUE_NAME$REF;\n");
		    &writeString("\n");
		}
		
		&writeString("};\n");
		&writeString("\n");
	    }
	    else
	    {
		die "Error: invalid option: $SUBSTANCE or $MARSHAL or nothing.";
	    }
	}
    }
}

sub writeClassID
{
    my($NAME) = @_;
    my($MD5) = &getMD5Last32($NAME);
    &writeString("#define CEComClassID_$NAME $MD5\n");
    &writeString("\n");
}

sub writeAllocator
{
    my($NO_ALLOCATOR) = @_;

    if (!$NO_ALLOCATOR)
    {
	&writeString("\t//----------------------------------------------------------------\n");
	&writeString("\t// operator new, delete, new[] and delete[].\n");
	&writeString("\t//----------------------------------------------------------------\n");
	&writeString("public:\n");
	&writeString("\tCEALLOCATORS;\n");
	&writeString("\n");
    }
}

sub writeConstructor
{
    my($CLASS, $CLASS_REF) = @_;
    &writeString("\t//----------------------------------------------------------------\n");
    &writeString("\t// constructor.\n");
    &writeString("\t//----------------------------------------------------------------\n");

    my($INHERITANCE) = $CLASS_REF->{'inheritance'};
    my($EMBED) = $CLASS_REF->{'embed'};
    my($MARSHAL_FACTORY) = $CLASS_REF->{'marshal-factory'};
    my($FND_TRANS) = $CLASS_REF->{'fnd-trans'};

    if ($INHERITANCE || $EMBED)
    {
	my($SUBSTANCE) = $INHERITANCE;
	if ($EMBED)
	{
	    $SUBSTANCE = $EMBED;
	}
	my(%CLASS_HASH) = &getClassHash(\%CPPHEADER, $SUBSTANCE);
	my($CONSTRUCTORS_REF) = $CLASS_HASH{'constructor'};
	if ($CONSTRUCTORS_REF)
	{
	    my($CONSTRUCTOR_REF);
	    foreach $CONSTRUCTOR_REF (@{$CONSTRUCTORS_REF})
	    {
		my(%CONSTRUCTOR) = %{$CONSTRUCTOR_REF};
		my(@IFDEFS) = @{$CONSTRUCTOR{'pre_ctor_ifdef'}};
		my($IFDEF);
		foreach $IFDEF (@IFDEFS)
		{
		    &writeString("$IFDEF");
		}


		my($ACCESS) = $CONSTRUCTOR{'access'};
		if ($ACCESS eq 'private' && $EMBED)
		{
		    $ACCESS = 'public';
		}

		if ($ACCESS ne 'private')
		{
		    &writeString("$ACCESS:\n");
		    &writeString("\t$CLASS($CONSTRUCTOR{'parameter'});\n");
		}

		@IFDEFS = @{$CONSTRUCTOR{'post_ctor_ifdef'}};
		foreach $IFDEF (@IFDEFS)
		{
		    &writeString("$IFDEF");
		}
	    }
	}

	my(@INTERFACES) = @{$CLASS_REF->{'interface'}};
	my($NUM_INTF) = $#INTERFACES;
	if ($NUM_INTF > - 1 && $INTERFACES[0]->{'vptr'})
	{
	    &writeString("\tvoid initVtbl();\n");
	}
    }
    elsif ($MARSHAL_FACTORY)
    {
	&writeString("public:\n");
	&writeString("\t$CLASS(UINT32 clsid);\n");
    }
    elsif ($FND_TRANS eq ':trans-from-fnd')
    {
	&writeString("public:\n");
	&writeString("\t$CLASS(ICEUnknown* iUnknown);\n");
    }
    else
    {
	die "Error: invalid implementation specifier";
    }

    &writeString("\n");
}

sub writeObjectMethod
{
    my($NAME, $CLASS_REF) = @_;

    my($FORCE_INLINE_GCC) = &getGccInlineOption();

    &writeString("\t//----------------------------------------------------------------\n");
    &writeString("\t// get instance.\n");
    &writeString("\t//----------------------------------------------------------------\n");

    my($EMBED) = $CLASS_REF->{'embed'};
    if ($EMBED)
    {
	my($VALUE) = &getSubstanceValueName($EMBED);
	&writeString("\t$FORCE_INLINE_GCC $EMBED* object() { return &$VALUE; }\n");
    }
    else
    {
	&writeString("\t$FORCE_INLINE_GCC $NAME* object() { return this; }\n");
    }
    &writeString("\n");
}
    
sub writePointerInterfaceTranslationList
{
    my($CLASS_REF, @INTERFACES) = @_;
    
    my($CLASS_NAME) = $CLASS_REF->{'name'};
    if ($CLASS_REF->{'marshal'})
    {
	$CLASS_NAME = &getProxyClassName($CLASS_REF);
    }
    
    my($INHERIT) = $CLASS_REF->{'inheritance'};
    my($EMBED) = $CLASS_REF->{'embed'};
    my($MARSHAL) = $CLASS_REF->{'marshal'};
    my($MARSHAL_FACTORY) = $CLASS_REF->{'marshal-factory'};
    my($FND_TRANS) = $CLASS_REF->{'fnd-trans'};

    my($SUBSTANCE);
    my($SUBSTANCE_VALUE);

    if ($INHERIT)
    {
	$SUBSTANCE = $INHERIT;
	$SUBSTANCE_VALUE = &getSubstanceValueName($INHERIT);
    }
    elsif ($EMBED)
    {
	$SUBSTANCE = $EMBED;
	$SUBSTANCE_VALUE = &getSubstanceValueName($EMBED);
    }
    elsif ($MARSHAL || $MARSHAL_FACTORY || ($FND_TRANS eq ':trans-from-fnd'))
    {
	# keep $SUBSTANCE null;
    }
    else
    {
	die "no available implementation option\n";
    }


    &writeString("\t//----------------------------------------------------------------\n");
    &writeString("\t// translate between interface pointer and instance.\n");
    &writeString("\t//----------------------------------------------------------------\n");

    my($VALUE) = &getPointerValueName($CLASS_NAME);

    if ($CLASS_REF->{'interface'}->[0]->{'name'} ne 'ICEUnknown')
    {
	&writeString("\tstatic ICEUnknown* toICEUnknown($CLASS_NAME* $VALUE);\n");
    }
    
    if ($SUBSTANCE)
    {
	$VALUE = &getPointerValueName($SUBSTANCE);
	&writeString("\tstatic $CLASS_NAME* toWrapper($SUBSTANCE* $VALUE);\n");
    }

    my($INTERFACE_REF);
    foreach $INTERFACE_REF (@INTERFACES)
    {
	&writePointerInterfaceTranslationSet($CLASS_NAME, $SUBSTANCE, $INTERFACE_REF->{'name'});

	if (&isFndNecessary($INTERFACE_REF->{'name'}))
	{
	    my($FND_INTERFACE_NAME) = &replaceInterfacePrefixForPublic($INTERFACE_REF->{'name'});
	    &writePointerInterfaceTranslationSet($CLASS_NAME, $SUBSTANCE, $FND_INTERFACE_NAME);
	}
	&writeString("\n");
    }
}

sub writePointerInterfaceTranslationSet
{
    my($CLASS_NAME, $SUBSTANCE, $INTERFACE_NAME) = @_;
    my($VALUE) = &getPointerValueName($CLASS_NAME);
    &writeString("\tstatic $INTERFACE_NAME* to$INTERFACE_NAME($CLASS_NAME* $VALUE);\n");
    if ($SUBSTANCE)
    {
	$VALUE = &getPointerValueName($SUBSTANCE);
	&writeString("\tstatic $INTERFACE_NAME* to$INTERFACE_NAME($SUBSTANCE* $VALUE);\n");
    }

    $VALUE = &getInterfaceValueName($INTERFACE_NAME);
    &writeString("\tstatic $CLASS_NAME* toInstance($INTERFACE_NAME* $VALUE);\n");
    if ($SUBSTANCE)
    {
	&writeString("\tstatic $SUBSTANCE* toSubstance($INTERFACE_NAME* $VALUE);\n");
    }
}

sub writeClassMember
{
    my($CLASS_REF) = @_;
    my($EMBED) = $CLASS_REF->{'embed'};
    if ($EMBED)
    {
	&writeString("\t//----------------------------------------------------------------\n");
	&writeString("\t// substance of instance.\n");
	&writeString("\t//----------------------------------------------------------------\n");

	my($VALUE) = &getSubstanceValueName($EMBED);
	&writeString("\t$EMBED $VALUE;\n");
	&writeString("\n");
    }
}

sub writeEnumeratorAndStructures
{
    my($IFACE_PREFIX, $INTERFACE_REF, $MARSHAL) = @_;

    # enum of method id
    &writeString("\tenum $IFACE_PREFIX" . "MethodId\n");
    &writeString("\t{\n");
    my(%INTERFACE_HASH) = &getInterfaceHash(\%IDL, $INTERFACE_REF->{'name'});
    my(@FUNCTIONS) = &getFunctionsIncludingInherit(\%IDL, \%INTERFACE_HASH);
    my($FUNCTION_REF);
    foreach $FUNCTION_REF (@FUNCTIONS)
    {
	my($FUNCTION_NAME) = $FUNCTION_REF->{'name'};
	if ($FUNCTION_NAME ne 'addRef' && ($MARSHAL ne ':ipc-marshal' || $FUNCTION_NAME ne 'queryInterface' ))
	{
	    my($METHOD_ID) = &getMethodIdName($FUNCTION_NAME);
	    if ($MARSHAL)
	    {
		&writeString("\t\t$IFACE_PREFIX" . "$METHOD_ID,\n");
	    }
	    else
	    {
		my($ENUMERATOR) = $IFACE_PREFIX . $METHOD_ID;
		my($MD5) = &getMD5Last32($ENUMERATOR);
		&writeString("\t\t$ENUMERATOR\t= $MD5,\n");
	    }
	}
    }
    &writeString("\t};\n");

    # struct for all method
    &writeString("\n#if defined(_MSC_VER)\n");
    &writeString("#pragma warning( disable : 4610 )  // disable warning:  C4610: struct 'XXXXX' can never be instantiated - user defined constructor required\n");
    &writeString("#endif // defined(_MSC_VER)\n");
    #@FUNCTIONS = &getFunctionsIncludingInherit(\%IDL, \%INTERFACE_HASH);
    foreach $FUNCTION_REF (@FUNCTIONS)
    {
	my($FUNC_NAME) = $FUNCTION_REF->{'name'};
	if ($FUNC_NAME ne 'addRef')
	{
	    my($PARAM) = $FUNCTION_REF->{'param'};
	    my(%VALUE_TYPE) = &getValueTypeMapFromAllParameter($PARAM);
	    my(@VALUES) = &getValuesFromAllParameter($PARAM);
	    my($METHOD_PARAM_NAME) = &getMethodParamName($FUNCTION_REF->{'name'});
	    &writeString("\tstruct $IFACE_PREFIX" . "$METHOD_PARAM_NAME\n");
	    &writeString("\t{\n");
	    my($VALUE);
	    foreach $VALUE (@VALUES)
	    {
		if ($MARSHAL eq ':std-marshal')
		{
		    &writeString("\t\t$VALUE_TYPE{$VALUE} $VALUE;\n");
		}
		elsif ($MARSHAL eq ':ipc-marshal')
		{
		    my($ORIGIN_TYPE) = $VALUE_TYPE{$VALUE};
		    if (&getInterfaceHash(\%IDL, $ORIGIN_TYPE))
		    {
			&writeString("\t\tvoid* $VALUE;\n");
		    }
		    else
		    {
			&writeString("\t\t$VALUE_TYPE{$VALUE} $VALUE;\n");
		    }
		}
		else
		{
			&writeString("\t\t$VALUE_TYPE{$VALUE} $VALUE;\n");
		}
	    }
	    &writeString("\t};\n");
	}
    }
    &writeString("#if defined(_MSC_VER)\n");
    &writeString("#pragma warning( default : 4610 )  // re-enable warning:  C4610: struct 'XXXXX' can never be instantiated - user defined constructor required\n");
    &writeString("#endif // defined(_MSC_VER)\n\n");
}

sub writeRefCount
{
    my($CLASS_REF) = @_;

    my($FORCE_INLINE_GCC) = &getGccInlineOption();

    my($EMBED) = $CLASS_REF->{'embed'};
    my($MARSHAL) = $CLASS_REF->{'marshal'};
    my($FND_TRANS) = $CLASS_REF->{'fnd-trans'};

    my($TYPE) = 'INT32';
    my($VALUE) = '_refCount';
#    my($LOCK, $UNLOCK);
    my($INC) = "++$VALUE";
    my($DEC) = "--$VALUE";
    my($CNT) = "$VALUE";

    if ($CLASS_REF->{'mt-safe'})
    {

	$INC = "CEComAtomicIncrement($VALUE)";
	$DEC = "CEComAtomicDecrement($VALUE)";
	$CNT = "CEComAtomicCount($VALUE)";
	$TYPE = 'CEATOMIC';

# 	$INC_WIN = "InterlockedIncrement(&$VALUE)";
# 	$DEC_WIN = "InterlockedDecrement(&$VALUE)";
# 	$INC_GCC_X86 = "asm volatile ( \"lock;\\n\" \"incl %0;\\n\" : \"=m\" ($VALUE) : \"m\" ($VALUE))";
# 	$DEC_GCC_X86 = "asm volatile ( \"lock;\\n\" \"decl %0;\\n\" : \"=m\" ($VALUE) : \"m\" ($VALUE))";
# 	$INC_GCC_PPC = "$TYPE tmp = 0; asm volatile ( \"L_%=:\\n\" \"lwarx %0,0,%2\\n\" \"addi %0,%0,1\\n\" \"stwcx. %0,0,%2\\n\" \"bne- L_%=\" : \"=r\" (tmp), \"=m\" ($VALUE) : \"r\" (&$VALUE), \"0\" (tmp) : \"cc\")";
# 	$DEC_GCC_PPC = "$TYPE tmp = 0; asm volatile ( \"L_%=:\\n\" \"lwarx %0,0,%2\\n\" \"addi %0,%0,-1\\n\" \"stwcx. %0,0,%2\\n\" \"bne- L_%=\" : \"=r\" (tmp), \"=m\" ($VALUE) : \"r\" (&$VALUE), \"0\" (tmp) : \"cc\")";
# 	#$INC_GCC_MIPS = "$TYPE tmp; asm volatile ( \"L_%=:\\n\" \"ll %1,%0\\n\" \"addi %1,%1,1\\n\" \"sc %1,%0\\n\" \"beqz %1,L_%=\\n\" \"nop\" : \"=m\" ($VALUE), \"=r\"(tmp) : \"m\" ($VALUE))";
# 	#$DEC_GCC_MIPS = "$TYPE tmp; asm volatile ( \"L_%=:\\n\" \"ll %1,%0\\n\" \"addi %1,%1,-1\\n\" \"sc %1,%0\\n\" \"beqz %1,L_%=\\n\" \"nop\" : \"=m\" ($VALUE), \"=r\"(tmp) : \"m\" ($VALUE))";
# 	$INC_GCC_MIPS = "$TYPE tmp; asm volatile ( \"L_%=:\\n\" \"ll %0,%1\\n\" \"addu %0,%2\\n\" \"sc %0,%1\\n\" \"beqz %0,L_%=\\n\" : \"=&r\" (tmp), \"=m\"($VALUE) : \"Ir\" (1), \"m\" ($VALUE) : \"cc\")";
# 	$DEC_GCC_MIPS = "$TYPE tmp; asm volatile ( \"L_%=:\\n\" \"ll %0,%1\\n\" \"subu %0,%2\\n\" \"sc %0,%1\\n\" \"beqz %0,L_%=\\n\" : \"=&r\" (tmp), \"=m\"($VALUE) : \"Ir\" (1), \"m\" ($VALUE) : \"cc\")";
# 	$INC_GCC_ARM = "$VALUE++";
# 	$DEC_GCC_ARM = "$VALUE--";
# 	$LOCK = 'CEComGlobalLock();';
# 	$UNLOCK = 'CEComGlobalUnlock();';
    }

    if ($EMBED || $MARSHAL || ($FND_TRANS eq ':trans-from-fnd'))
    {
	&writeString("\t//----------------------------------------------------------------\n");
	&writeString("\t// reference count.\n");
	&writeString("\t//----------------------------------------------------------------\n");
	&writeString("public:\n");
	&writeString("\t$FORCE_INLINE_GCC $TYPE RefCount() { return $CNT; }\n");
	&writeString("\n");

	&writeString("\tvoid AddRef()\n");
	&writeString("\t{\n");
	&writeString("\t\t$INC;\n");
	&writeString("\t}\n");
	&writeString("\n");

	&writeString("\tvoid Release()\n");
	&writeString("\t{\n");

	&writeString("\t\t$TYPE refCount = $DEC;\n");

	&writeString("\t\tif (refCount == 0)\n");
	&writeString("\t\t{\n");
	&writeString("\t\t\tdelete this;\n");
	&writeString("\t\t}\n");
	&writeString("\t}\n");
	&writeString("\n");

	&writeString("private:\n");
	&writeString("\t$TYPE $VALUE;\n");
	&writeString("\n");
    }
}

sub writePointerToFunctionTable
{
    my(@INTERFACES) = @_;

    &writeString("\t//----------------------------------------------------------------\n");
    &writeString("\t// pointer to function table.\n");
    &writeString("\t//----------------------------------------------------------------\n");

    my($INTERFACE_REF);
    foreach $INTERFACE_REF (@INTERFACES)
    {
	if (!$INTERFACE_REF->{'vptr'})
	{
	    my($INTERFACE_NAME) = $INTERFACE_REF->{'name'};
	    my($VPTR) = &getVptrName($INTERFACE_NAME);
	    &writeString("\tconst ${INTERFACE_NAME}_vtbl* $VPTR;\n");
	    
	    if (&isFndNecessary($INTERFACE_NAME))
	    {
		my($FND_INTERFACE_NAME) = &replaceInterfacePrefixForPublic($INTERFACE_NAME);
		my($FND_VPTR)           = &getVptrName($FND_INTERFACE_NAME);
		&writeString("\tconst ${FND_INTERFACE_NAME}_vtbl* $FND_VPTR;\n");
	    }
	}
    }
    &writeString("\n");
}

sub writeSupportHeader
{
    my($CCD_REF, @CLASSES) = @_;

    my(@SPLIT_FILENAME) = split(/\./, $CCD_REF->{'name'});
    my(@SPLIT_FILENAME) = split(/\//, $SPLIT_FILENAME[$#SPLIT_FILENAME - 1]);
    my($PREFIX) = $SPLIT_FILENAME[$#SPLIT_FILENAME];
    my($HAS_IPC_MARSHALLER) = 0;
    my($HAS_JNI) = 0;
    my($CLASS_REF);
    foreach $CLASS_REF (@CLASSES)
    {
	if ($CLASS_REF->{'marshal'} eq ':ipc-marshal')
	{
	    $HAS_IPC_MARSHALLER = 1;
	}
	if ($CLASS_REF->{'java-to-c'})
	{
	    $HAS_JNI = 1;
	}
    }

    if ($HAS_IPC_MARSHALLER)
    {
	if ($HAS_JNI eq 0)
	{
	    &writeCERpcMarshallerExportHeader($PREFIX)
	}
	else
        {
	    &writeString("#ifdef __cplusplus\n");
	    &writeString("extern \"C\"\n");
	    &writeString("{\n");
            &writeString("#endif\n");
	    &writeString("\n");

	    &writeStubToInterfaceHeader($PREFIX, \@CLASSES);
	    if ($HAS_JNI)
	    {
	        &writeCreateJNIHeader($PREFIX, \@CLASSES);
    	        &writeGetInterfaceFromJStubHeader($PREFIX, \@CLASSES);
	    }
	    &writeProxyToInterfaceHeader($PREFIX, \@CLASSES);
	    &writeCreateStubHeader($PREFIX, \@CLASSES);
	    &writeCreateProxyHeader($PREFIX, \@CLASSES);
	    &writeInvokeHeader($PREFIX, \@CLASSES);
	    &writeDestroyStubHeader($PREFIX);
	    &writeClearProxyHeader($PREFIX);
	    &writeString("#ifdef __cplusplus\n");
	    &writeString("}\n");
	    &writeString("#endif\n");
	    &writeString("\n");
        }
    }
}
sub writeCERpcMarshallerExportHeader()
{
    my($PREFIX) = @_;
    &writeString("#include \"CERpcMarshallerFuncs.h\"\n\n");
    &writeString("#ifdef __cplusplus\n");
    &writeString("extern \"C\"\n");
    &writeString("{\n");
    &writeString("#endif\n");
    &writeString("\n");
    &writeString("\tCE_DLL_EXPORT CERpcMarshallerFuncTbl* ${PREFIX}GetFuncTable();\n");
    &writeString("\n");
    &writeString("#ifdef __cplusplus\n");
    &writeString("}\n");
    &writeString("#endif\n");
    &writeString("\n");
}

sub writeSupportImplement
{
    my($CCD_REF, @CLASSES) = @_;

    my(@SPLIT_FILENAME) = split(/\./, $CCD_REF->{'name'});
    my(@SPLIT_FILENAME) = split(/\//, $SPLIT_FILENAME[$#SPLIT_FILENAME - 1]);
    my($PREFIX) = $SPLIT_FILENAME[$#SPLIT_FILENAME];
    my($HAS_IPC_MARSHALLER) = 0;
    my($HAS_JNI) = 0;
    my($CLASS_REF);
    foreach $CLASS_REF (@CLASSES)
    {
	if ($CLASS_REF->{'marshal'} eq ':ipc-marshal')
	{
	    $HAS_IPC_MARSHALLER = 1;
	}
	if ($CLASS_REF->{'java-to-c'})
	{
	    $HAS_JNI = 1;
	}
    }

    if ($HAS_IPC_MARSHALLER)
    {
	&writeStubToInterface($PREFIX, \@CLASSES);
	&writeProxyToInterface($PREFIX, \@CLASSES);
	&writeCreateStub($PREFIX, \@CLASSES);
	&writeCreateProxy($PREFIX, \@CLASSES);
	if ($HAS_JNI)
	{
	    &writeCreateJNI($PREFIX, \@CLASSES);
	    &writeGetInterfaceFromJStub($PREFIX, \@CLASSES);
	}
	&writeInvoke($PREFIX, \@CLASSES);
	&writeDestroyStub($PREFIX);
	&writeClearProxy($PREFIX);
	if ($HAS_JNI eq 0)
	{
		&writeMarshallerFuncTable($PREFIX);
		&writeGetMarshaller($PREFIX);
	}
    }
}
sub writeMarshallerFuncTable
{
    my($PREFIX) = @_;
    &writeString("static CERpcMarshallerFuncTbl g_MarshallerFuncTable =\n");
    &writeString("{\n");
    &writeString("\t${PREFIX}_stubToInterface,\n");
    &writeString("\t${PREFIX}_proxyToInterface,\n");
    &writeString("\t${PREFIX}_createStub,\n");
    &writeString("\t${PREFIX}_createProxy,\n");
    &writeString("\t${PREFIX}_invoke,\n");
    &writeString("\t${PREFIX}_destroyStub,\n");
    &writeString("\t${PREFIX}_clearProxy\n");
    &writeString("};\n");

}
sub writeGetMarshaller
{
    my($PREFIX) = @_;
    &writeString("CERpcMarshallerFuncTbl* ${PREFIX}GetFuncTable()\n");
    &writeString("{\n");
    &writeString("\treturn &g_MarshallerFuncTable;\n");
    &writeString("}\n");
}
sub writeStubToInterfaceHeader
{
    my($PREFIX, $CLASSES_REF) = @_;    
    &writeString("UINT_PTR ${PREFIX}_stubToInterface(UINT32 iid, UINT_PTR stub);\n");
    &writeString("\n");
}

sub writeStubToInterface
{
    my($PREFIX, $CLASSES_REF) = @_;    
    &writeString("UINT_PTR ${PREFIX}_stubToInterface(UINT32 iid, UINT_PTR stub)\n");
    &writeString("{\n");
    &writeString("\tUINT_PTR ifacePtr = 0;\n");
    &writeString("\tswitch (iid)\n");
    &writeString("\t{\n");
    my($CLASS_REF);
    foreach $CLASS_REF (@{$CLASSES_REF})
    {
	my($INTERFACES_REF) = $CLASS_REF->{'interface'};
	my($INTERFACE_REF);
	foreach $INTERFACE_REF (@{$INTERFACES_REF})
	{
	    my($INTERFACE_NAME) = $INTERFACE_REF->{'name'};
	    my($STUB) = &getStubClassName($CLASS_REF);
	    my($IID) = &getIIDName($INTERFACE_NAME);
	    &writeString("\tcase $IID:\n");
	    &writeString("\t\tifacePtr = reinterpret_cast<UINT_PTR>(reinterpret_cast<$STUB*>(stub)->get$INTERFACE_NAME().object());\n");
	    &writeString("\t\tbreak;\n");
	}
    }
    &writeString("\tcase CEComIID_ICEUnknown:\n");
    &writeString("\t\tbreak;\n");
    &writeString("\tdefault:\n");
    &writeString("\t\tCEASSERT(false);\n");
    &writeString("\t\tbreak;\n");
    &writeString("\t}\n");

    &writeString("\treturn ifacePtr;\n");
    &writeString("}\n");
}
sub writeProxyToInterfaceHeader
{
    my($PREFIX, $CLASSES_REF) = @_;
    &writeString("UINT_PTR ${PREFIX}_proxyToInterface(UINT32 iid, UINT_PTR proxy);\n");
    &writeString("\n");
}

sub writeProxyToInterface
{
    my($PREFIX, $CLASSES_REF) = @_;    
    &writeString("UINT_PTR ${PREFIX}_proxyToInterface(UINT32 iid, UINT_PTR proxy)\n");
    &writeString("{\n");
    &writeString("\tUINT_PTR ifacePtr = 0;\n");
    &writeString("\tswitch (iid)\n");
    &writeString("\t{\n");
    my($CLASS_REF);
    foreach $CLASS_REF (@{$CLASSES_REF})
    {
	my($INTERFACES_REF) = $CLASS_REF->{'interface'};
	my($INTERFACE_REF);
	foreach $INTERFACE_REF (@{$INTERFACES_REF})
	{
	    my($INTERFACE_NAME) = $INTERFACE_REF->{'name'};
	    my($PROXY) = &getProxyClassName($CLASS_REF);
	    my($IID) = &getIIDName($INTERFACE_NAME);
	    &writeString("\tcase $IID:\n");
	    &writeString("\t\tifacePtr = reinterpret_cast<UINT_PTR>($PROXY\:\:to$INTERFACE_NAME(reinterpret_cast<$PROXY*>(proxy)));\n");
	    &writeString("\t\tbreak;\n");
	}
    }
    &writeString("\tcase CEComIID_ICEUnknown:\n");
    &writeString("\t\tbreak;\n");
    &writeString("\tdefault:\n");
    &writeString("\t\tCEASSERT(false);\n");
    &writeString("\t\tbreak;\n");
    &writeString("\t}\n");

    &writeString("\treturn ifacePtr;\n");
    &writeString("}\n");
}

sub writeCreateStubHeader
{
    my($PREFIX, $CLASSES_REF) = @_;    
    &writeString("CEHResult ${PREFIX}_createStub(UINT32 iid, UINT_PTR ifacePtr, UINT_PTR* stubOut);\n");
    &writeString("\n");
}

sub writeCreateStub
{
    my($PREFIX, $CLASSES_REF) = @_;    
    &writeString("CEHResult ${PREFIX}_createStub(CERpcSession session, UINT32 iid, UINT_PTR ifacePtr, UINT_PTR* stubOut)\n");
    &writeString("{\n");
    &writeString("\tCEHResult hr = CE_S_OK;\n");
    &writeString("\tif (!stubOut) hr = CE_SILK_ERR_BADARGS;\n");
    &writeString("\tif (CESucceeded(hr))\n");
    &writeString("\t{\n");
    &writeString("\t\tswitch (iid)\n");
    &writeString("\t\t{\n");
    my($CLASS_REF);
    foreach $CLASS_REF (@{$CLASSES_REF})
    {
	my($INTERFACES_REF) = $CLASS_REF->{'interface'};
	my($INTERFACE_REF);
	foreach $INTERFACE_REF (@{$INTERFACES_REF})
	{
	    my($INTERFACE_NAME) = $INTERFACE_REF->{'name'};
	    my($STUB) = &getStubClassName($CLASS_REF);
	    my($IID) = &getIIDName($INTERFACE_NAME);
	    &writeString("\t\tcase $IID:\n");
	    &writeString("\t\t\t*stubOut = reinterpret_cast<UINT_PTR>(new $STUB(session, reinterpret_cast<$INTERFACE_NAME*>(ifacePtr)));\n");
	    &writeString("\t\t\tbreak;\n");
	}
    }
    &writeString("\t\tdefault:\n");
    &writeString("\t\t\thr = CE_SILK_ERR_NOTFOUND;\n");
    &writeString("\t\t\tbreak;\n");
    &writeString("\t\t}\n");
    &writeString("\t}\n");

    &writeString("\tif (CESucceeded(hr) && !*stubOut)\n");
    &writeString("\t{\n");
    &writeString("\t\thr = CE_SILK_ERR_MEMERR;\n");
    &writeString("\t}\n");

    &writeString("\treturn hr;\n");
    &writeString("}\n");
}

sub writeCreateProxyHeader
{
    my($PREFIX, $CLASSES_REF) = @_;    
    &writeString("CEHResult ${PREFIX}_createProxy(UINT32 iid, UINT_PTR stub, UINT_PTR* proxyOut);\n");
    &writeString("\n");
}

sub writeCreateProxy
{
    my($PREFIX, $CLASSES_REF) = @_;    
    &writeString("CEHResult ${PREFIX}_createProxy(CERpcSession session, UINT32 iid, UINT_PTR stub, UINT_PTR* proxyOut)\n");
    &writeString("{\n");
    &writeString("\tCEHResult hr = CE_S_OK;\n");
    &writeString("\tif (!proxyOut) hr = CE_SILK_ERR_BADARGS;\n");
    &writeString("\tif (CESucceeded(hr))\n");
    &writeString("\t{\n");
    &writeString("\t\tswitch (iid)\n");
    &writeString("\t\t{\n");
    my($CLASS_REF);
    foreach $CLASS_REF (@{$CLASSES_REF})
    {
	my($INTERFACES_REF) = $CLASS_REF->{'interface'};
	my($INTERFACE_REF);
	foreach $INTERFACE_REF (@{$INTERFACES_REF})
	{
	    my($PROXY) = &getProxyClassName($CLASS_REF);
	    my($STUB) = &getStubClassName($CLASS_REF);
	    my($IID) = &getIIDName($INTERFACE_REF->{'name'});
	    &writeString("\t\tcase $IID:\n");
	    &writeString("\t\t\t*proxyOut = reinterpret_cast<UINT_PTR>(new $PROXY(session, reinterpret_cast<$STUB*>(stub)));\n");
	    &writeString("\t\t\tbreak;\n");
	}
    }
    &writeString("\t\tdefault:\n");
    &writeString("\t\t\thr = CE_SILK_ERR_NOTFOUND;\n");
    &writeString("\t\t\tbreak;\n");
    &writeString("\t\t}\n");
    &writeString("\t}\n");

    &writeString("\tif (CESucceeded(hr) && !*proxyOut)\n");
    &writeString("\t{\n");
    &writeString("\t\thr = CE_SILK_ERR_MEMERR;\n");
    &writeString("\t}\n");

    &writeString("\treturn hr;\n");
    &writeString("}\n\n");
}

sub writeCreateJNIHeader
{
    my($PREFIX, $CLASSES_REF) = @_;
    &writeString("CEHResult ${PREFIX}_createJNI(UINT32 iid, UINT_PTR iface, jobject* jniface);\n");
    &writeString("\n");
}

sub writeCreateJNI
{
    my($PREFIX, $CLASSES_REF) = @_;

    &writeString("CEHResult ${PREFIX}_createJNI(UINT32 iid, UINT_PTR ifacePtr, jobject* jniface)\n");
    &writeString("{\n");
    &writeString("\tCEHResult err = CE_S_OK;\n");
    &writeString("\tif (!jniface)\n");
    &writeString("\t{\n");
    &writeString("\t\terr = CE_SILK_ERR_BADARGS;\n");
    &writeString("\t}\n");
    &writeString("\tif (CESucceeded(err))\n");
    &writeString("\t{\n");
    &writeString("\t\tJNIEnv* env = ApmGetJNIEnv();\n");
    &writeString("\t\tif (env)\n");
    &writeString("\t\t{\n");
    &writeString("\t\t\tjclass clazz = 0;\n");
    &writeString("\t\t\tjmethodID mid = 0;\n");
    &writeString("\t\t\tswitch (iid)\n");
    &writeString("\t\t\t{\n");

    my($CLASS_REF);
    foreach $CLASS_REF (@{$CLASSES_REF})
    {
	my($INTERFACES_REF) = $CLASS_REF->{'interface'};
	my($INTERFACE_REF);
	foreach $INTERFACE_REF (@{$INTERFACES_REF})
	{
	    my($INTERFACE_NAME) = $INTERFACE_REF->{'name'};
	    my($JNI_MARSHALLER_NAME) = &getJNIClassName($CLASS_REF);
	    my($IID_NAME) = &getIIDName($INTERFACE_NAME);
	    &writeString("\t\t\tcase ${IID_NAME}:\n");
	    &writeString("\t\t\t\tclazz = env->FindClass(\"${PREFIX}/$JNI_MARSHALLER_NAME\");\n");
	    &writeString("\t\t\t\tif (clazz)\n");
	    &writeString("\t\t\t\t{\n");
	    if($CLASS_REF->{'c-to-java'})
	    {
		&writeString("\t\t\t\t\tmid = env->GetMethodID(clazz, \"<init>\", \"(L${PREFIX}/$INTERFACE_NAME;)V\");\n");
	    }
	    else
	    {
		&writeString("\t\t\t\t\tmid = env->GetMethodID(clazz, \"<init>\", \"(I)V\");\n");
	    }
	    &writeString("\t\t\t\t\tif (mid)\n");
	    &writeString("\t\t\t\t\t{\n");
	    if($CLASS_REF->{'c-to-java'})
	    {
		&writeString("\t\t\t\t\t\tjobject obj = env->NewObject(clazz, mid, (jobject)ifacePtr);\n");
	    }
	    else
	    {
		&writeString("\t\t\t\t\t\tjobject obj = env->NewObject(clazz, mid, (jint)ifacePtr);\n");
	    }
	    &writeString("\t\t\t\t\t\tif (obj)\n");
	    &writeString("\t\t\t\t\t\t{\n");
	    &writeString("\t\t\t\t\t\t\t*jniface = env->NewGlobalRef(obj);\n");
	    my($ERR_INS_UNAVAIL) = "err = CE_SILK_ERR_INSTANCE_UNAVAILABLE\;";
	    my($INTERFACE_IID) = &getIIDName($INTERFACE_NAME);
	    my($INTERFACE_REF) = &getInterfaceWrapperName($INTERFACE_NAME);
	    if(!($CLASS_REF->{'c-to-java'}))
	    {
		&writeString("\t\t\t\t\t\t\tif (*jniface)\n");
		&writeString("\t\t\t\t\t\t\t{\n");
		&writeString("\t\t\t\t\t\t\t\t${INTERFACE_REF} interfaceRef = reinterpret_cast<$INTERFACE_NAME*>(${PREFIX}_proxyToInterface($INTERFACE_IID, ifacePtr));\n");
		&writeString("\t\t\t\t\t\t\t\tif (interfaceRef)\n");
		&writeString("\t\t\t\t\t\t\t\t{\n");
		&writeString("\t\t\t\t\t\t\t\t\tinterfaceRef.addRef();\n");
		&writeString("\t\t\t\t\t\t\t\t}\n");
		&writeString("\t\t\t\t\t\t\t\telse\n");
		&writeString("\t\t\t\t\t\t\t\t{\n");
		&writeString("\t\t\t\t\t\t\t\t\t${ERR_INS_UNAVAIL}\n");
		&writeString("\t\t\t\t\t\t\t\t}\n");
		&writeString("\t\t\t\t\t\t\t}\n");
		&writeString("\t\t\t\t\t\t\telse\n");
		&writeString("\t\t\t\t\t\t\t{\n");
		&writeString("\t\t\t\t\t\t\t\t${ERR_INS_UNAVAIL}\n");
		&writeString("\t\t\t\t\t\t\t}\n");
	    }
	    &writeString("\t\t\t\t\t\t}\n");
	    &writeString("\t\t\t\t\t\telse\n");
	    &writeString("\t\t\t\t\t\t{\n");
	    &writeString("\t\t\t\t\t\t\t${ERR_INS_UNAVAIL}\n");
	    &writeString("\t\t\t\t\t\t}\n");
	    &writeString("\t\t\t\t\t}\n");
	    &writeString("\t\t\t\t\telse\n");
	    &writeString("\t\t\t\t\t{\n");
	    &writeString("\t\t\t\t\t\t${ERR_INS_UNAVAIL}\n");
	    &writeString("\t\t\t\t\t}\n");
	    &writeString("\t\t\t\t}\n");
	    &writeString("\t\t\t\telse\n");
	    &writeString("\t\t\t\t{\n");
	    &writeString("\t\t\t\t\t${ERR_INS_UNAVAIL}\n");
	    &writeString("\t\t\t\t}\n");
	    &writeString("\t\t\t\tbreak;\n");
	}
    }
    &writeString("\t\t\tdefault:\n");
    &writeString("\t\t\t\terr = CE_SILK_ERR_NOTFOUND;\n");
    &writeString("\t\t\t\tbreak;\n");
    &writeString("\t\t\t}\n");
    &writeString("\t\t}\n");
    &writeString("\t}\n");

    &writeString("\tif (CESucceeded(err) && !*jniface)\n");
    &writeString("\t{\n");
    &writeString("\t\terr = CE_SILK_ERR_MEMERR;\n");
    &writeString("\t}\n");

    &writeString("\treturn err;\n");
    &writeString("}\n\n");
}

sub writeGetInterfaceFromJStubHeader
{
    my($PREFIX, $CLASSES_REF) = @_;
    &writeString("CEHResult ${PREFIX}_getInterfaceFromJStub(UINT32 iid, jobject stub, jobject* ifaceFromJStub);\n");
    &writeString("\n");
}

sub writeGetInterfaceFromJStub
{
    my($PREFIX, $CLASSES_REF) = @_;
    &writeString("CEHResult ${PREFIX}_getInterfaceFromJStub(UINT32 iid, jobject stub, jobject* ifaceFromJStub)\n");
    &writeString("{\n");
    &writeString("\tCEHResult err = CE_S_OK;\n");
    &writeString("\tif (!ifaceFromJStub)\n");
    &writeString("\t{\n");
    &writeString("\t\terr = CE_SILK_ERR_BADARGS;\n");
    &writeString("\t}\n");
    &writeString("\tif (CESucceeded(err))\n");
    &writeString("\t{\n");
    &writeString("\t\tJNIEnv* env = ApmGetJNIEnv();\n");
    &writeString("\t\tif(env)\n");
    &writeString("\t\t{\n");
    &writeString("\t\t\tjclass clazz = 0;\n");
#    &writeString("\t\t\tjmethodID mid = 0;\n");
    &writeString("\t\t\tswitch (iid)\n");
    &writeString("\t\t\t{\n");
    my($CLASS_REF);
    foreach $CLASS_REF (@{$CLASSES_REF})
    {
	if($CLASS_REF->{'c-to-java'})
	{
	    my($INTERFACES) = $CLASS_REF->{'interface'};
	    my($INTERFACE);
	    foreach $INTERFACE (@{$INTERFACES})
	    {
		my($INTERFACE_NAME) = $INTERFACE->{'name'};
		my($IID_NAME) = &getIIDName($INTERFACE_NAME);
		my($IFACE_INSTANCE_NAME) = &getJavaInterfaceInstanceName($INTERFACE_NAME);
		&writeString("\t\t\tcase $IID_NAME:\n");
		&writeString("\t\t\t\tclazz = env->GetObjectClass(stub);\n");
		&writeString("\t\t\t\tif(clazz)\n");
		&writeString("\t\t\t\t{\n");
		&writeString("\t\t\t\t\tjfieldID fid = env->GetFieldID(clazz, \"$IFACE_INSTANCE_NAME\", \"L${PREFIX}/${INTERFACE_NAME};\");\n");
		&writeString("\t\t\t\t\tif (fid)\n");
		&writeString("\t\t\t\t\t{\n")
		&writeString("\t\t\t\t\t\t*ifaceFromJStub  = env->GetObjectField(stub, fid);\n");
		&writeString("\t\t\t\t\t}\n");
		&writeString("\t\t\t\t\telse\n");
		&writeString("\t\t\t\t\t{\n");
		&writeString("\t\t\t\t\t\terr = CE_SILK_ERR_INSTANCE_UNAVAILABLE;\n");
		&writeString("\t\t\t\t\t}\n");
		&writeString("\t\t\t\t}\n");
		&writeString("\t\t\t\telse\n");
		&writeString("\t\t\t\t{\n");
		&writeString("\t\t\t\t\terr = CE_SILK_ERR_INSTANCE_UNAVAILABLE;\n");
		&writeString("\t\t\t\t}\n");
		&writeString("\t\t\t\tbreak;\n");
	    }
        }
    }
    &writeString("\t\t\tdefault:\n");
    &writeString("\t\t\t\terr = CE_SILK_ERR_NOTFOUND;\n");
    &writeString("\t\t\t\tbreak;\n");
    &writeString("\t\t\t}\n");
    &writeString("\t\t}\n");
    &writeString("\t}\n");

    &writeString("\tif (CESucceeded(err) && !*ifaceFromJStub)\n");
    &writeString("\t{\n");
    &writeString("\t\terr = CE_SILK_ERR_MEMERR;\n");
    &writeString("\t}\n");

    &writeString("\treturn err;\n");
    &writeString("}\n\n");
}

sub writeInvokeHeader
{
    my($PREFIX, $CLASSES_REF) = @_;
    &writeString("CEHResult ${PREFIX}_invoke(UINT_PTR stub, UINT32 iid, UINT32 mid, void* param);\n");
    &writeString("\n");
}

sub writeInvoke
{
    my($PREFIX, $CLASSES_REF) = @_;
    &writeString("CEHResult ${PREFIX}_invoke(UINT_PTR stub, UINT32 iid, UINT32 mid, void* param)\n");
    &writeString("{\n");
    &writeString("\tCEHResult hr = CE_S_OK;\n");
    &writeString("\tswitch (iid)\n");
    &writeString("\t{\n");
    my($CLASS_REF);
    foreach $CLASS_REF (@{$CLASSES_REF})
    {
	my($INTERFACES_REF) = $CLASS_REF->{'interface'};
	my($INTERFACE_REF);
	foreach $INTERFACE_REF (@{$INTERFACES_REF})
	{
	    my($INTERFACE_NAME) = $INTERFACE_REF->{'name'};
	    my($PROXY) = &getProxyClassName($CLASS_REF);
	    my($STUB) = &getStubClassName($CLASS_REF);
	    my($IID) = &getIIDName($INTERFACE_NAME);
	    &writeString("\tcase $IID:\n");
	    &writeString("\t\thr = reinterpret_cast<$STUB*>(stub)->invoke(static_cast<$STUB\:\:${INTERFACE_NAME}_MethodId>(mid), param);\n");
	    &writeString("\t\tbreak;\n");
	}
    }
    &writeString("\tdefault:\n");
    &writeString("\t\tCEASSERT(false);\n");
    &writeString("\t\thr = CE_SILK_ERR_OPERATION_FAILED;\n");
    &writeString("\t\tbreak;\n");
    &writeString("\t}\n");

    &writeString("\treturn hr;\n");
    &writeString("}\n\n");
}

sub writeDestroyStubHeader
{
    my($PREFIX) = @_;
    &writeString("void ${PREFIX}_destroyStub(UINT_PTR stub);\n");
    &writeString("\n");
}

sub writeClearProxyHeader
{
    my($PREFIX) = @_;
    &writeString("void ${PREFIX}_clearProxy(UINT_PTR proxy);\n");
    &writeString("\n");
}

sub writeDestroyStub
{
    my($PREFIX) = @_;
    &writeString("void ${PREFIX}_destroyStub(UINT_PTR stub)\n");
    &writeString("{\n");
    &writeString("\tif (stub)\n");
    &writeString("\t{\n");
    &writeString("\t\tdelete reinterpret_cast<CEIpcMarshallerBase*>(stub);\n");
    &writeString("\t}\n");
    &writeString("}\n");
}

sub writeClearProxy
{
    my($PREFIX) = @_;
    &writeString("void ${PREFIX}_clearProxy(UINT_PTR proxy)\n");
    &writeString("{\n");
    &writeString("\tif (proxy)\n");
    &writeString("\t{\n");
    &writeString("\t\treinterpret_cast<CEIpcMarshallerBase*>(proxy)->clearSession();\n");
    &writeString("\t}\n");
    &writeString("}\n");
}

########################################################################################################
### write implementation file
########################################################################################################

sub writeImplementationFile
{
    my($CCD_FULLPATH, $OUTDIR) = @_;

    debugMode(0);
    my($CPP_FILE) = &getFileNameWithDir($CCD_FULLPATH, $OUTDIR, 'cpp');
    if ($CPP_FILE)
    {
 	open(FPW, ">$CPP_FILE") || die("Error: Can not open file $CPP_FILE as output\n");
    }

    &writeCopyright();
    &writeString("\n");
    
    my($CCD_FILE) = &deletePath($CCD_FULLPATH);
    &writeIncludingHeaderImplementation($CCD_FILE, $CCD{$CCD_FILE}->{'precomp'}, @{$CCD{$CCD_FILE}->{'class'}});
    &writeIncludeList(@{$CCD{$CCD_FILE}->{'include-cpp'}});
    
    ### module at first
    if ($CCD{$CCD_FILE}->{'module'})
    {
	&writeModuleImplementation($CCD{$CCD_FILE}->{'module'});
    }
    &writeClassListImplementation($CCD_FILE, @{$CCD{$CCD_FILE}->{'class'}});
    close(FPW);
    debugMode(0);
}

sub writeIncludingHeaderImplementation
{
    my($CCD_FILE, $PRECOMP_H, @CLASSES) = @_;
    my($EXT) = 'ccd';
    if ($CCD_FILE =~ /\.csd$/)
    {
	$EXT = 'csd';
    }

    my($H_FILE) = &getFileName($CCD_FILE, $EXT, 'h');

    if ($PRECOMP_H)
    {
	&writeString("#include \"$PRECOMP_H\"\n");
	&writeString("\n");
    }
    &writeString("#include \"$H_FILE\"\n");
    &writeString("#include \"CESysMemory.h\"\n");
#    &writeString("#include \"CEApiErrorImpl.h\"\n");
    &writeString("#include \"CEApiMacro.h\"\n");

    my($CLASS_REF_USE_CHK);
    foreach $CLASS_REF_USE_CHK (@CLASSES)
    {
	if ($CLASS_REF_USE_CHK->{'fnd-trans'} eq ':trans-from-fnd')
	{
	    &writeString("#include \"ICEGenFoundationTranslator.h\"\n");
	    last;
	}
    }
	
    &writeString("\n");
}

sub writeClassListImplementation
{
    my($CCD_FILE, @CLASSES) = @_;

    my($CLASS_REF_USE_CHK);
    my(@FUNCTIONS);
    foreach $CLASS_REF_USE_CHK (@CLASSES)
    {
	my($REFERRED) = $CLASS_REF_USE_CHK->{'referred'};
	if (!$REFERRED)
	{
	    my($NAME) = $CLASS_REF_USE_CHK->{'name'};
	    my($INHERIT) = $CLASS_REF_USE_CHK->{'inheritance'};
	    my($EMBED) = $CLASS_REF_USE_CHK->{'embed'};
	    my($MARSHAL) = $CLASS_REF_USE_CHK->{'marshal'};
	    my($MARSHAL_FACTORY) = $CLASS_REF_USE_CHK->{'marshal-factory'};
	    my($FND_TRANS) = $CLASS_REF_USE_CHK->{'fnd-trans'};
	    my($FUNCTION_PREFIX) = 'Apm';
	    if ($CLASS_REF_USE_CHK->{'function-prefix'})
	    {
		$FUNCTION_PREFIX = $CLASS_REF_USE_CHK->{'function-prefix'};
	    }
	    
	    if ($INHERIT || $EMBED || $MARSHAL_FACTORY || ($FND_TRANS eq ':trans-from-fnd'))
	    {
		&writeString("//----------------------------------------------------------------\n");
		&writeString("// $NAME\n");
		&writeString("//----------------------------------------------------------------\n");
		&writeThreeSacredTreasures($NAME, $CLASS_REF_USE_CHK, @{$CLASS_REF_USE_CHK->{'interface'}});
		&writeToICEUnknown($CLASS_REF_USE_CHK);
		if (!($MARSHAL_FACTORY || ($FND_TRANS eq ':trans-from-fnd')))
		{
		    &writeToWrapper($CLASS_REF_USE_CHK);
		}
		my($INTERFACE_REF);
		foreach $INTERFACE_REF (@{$CLASS_REF_USE_CHK->{'interface'}})
		{
		    &writeInterfaceImplementation($CLASS_REF_USE_CHK, $INTERFACE_REF);
		}
		&writeConstructorImplementation($NAME, $CLASS_REF_USE_CHK, @{$CLASS_REF_USE_CHK->{'interface'}});
		if ($MARSHAL_FACTORY)
		{
		    my($FACTORY_INTERFACE_REF) = $CLASS_REF_USE_CHK->{'interface'}->[0];
		    if (&getInterfaceHash(\%IDL, $FACTORY_INTERFACE_REF->{'name'}))
		    {
			my(%FACTORY_INTERFACE_HASH) = &getInterfaceHash(\%IDL, $FACTORY_INTERFACE_REF->{'name'});
			my($FUNCTIONS_REF) = $FACTORY_INTERFACE_HASH{'function'};
			&writeFunctionList(\%IDL, 'MARSHAL_FACTORY_FUNCTION_IMPL', $CLASS_REF_USE_CHK, $FACTORY_INTERFACE_REF->{'name'}, 0, @{$FUNCTIONS_REF});
		    }
		    else
		    {
			die "Error: unknown factory interface: $FACTORY_INTERFACE_REF->{'name'}";
		    }
		}
	    }
	    elsif ($MARSHAL eq ':lw-marshal' || $MARSHAL eq ':std-marshal' || $MARSHAL eq ':ipc-marshal')
	    {
		if ($MARSHAL eq ':lw-marshal')
		{
		    &writeString("//----------------------------------------------------------------\n");
		    &writeString("// Light-Weight Marshaller ( only proxy here )\n");
		    &writeString("//----------------------------------------------------------------\n");
		    ## nothing for stub
		}
		elsif ($MARSHAL eq ':std-marshal' || $MARSHAL eq ':ipc-marshal')
		{
		    &writeString("//----------------------------------------------------------------\n");
		    &writeString("// Standard Marshaller\n");
		    &writeString("//----------------------------------------------------------------\n");
		    ## stub
		    my($INTERFACE_COUNT) = 0;
		    my($INTERFACES_REF)= $CLASS_REF_USE_CHK->{'interface'};
		    my($INTERFACE_REF);
		    foreach $INTERFACE_REF (@{$INTERFACES_REF})
		    {
			my($STUB_NAME) = &getStubClassName($CLASS_REF_USE_CHK);
			my($INTERFACE_NAME) = $INTERFACE_REF->{'name'};
			my($ORIG_OBJ) = &getStubOriginalInterfaceName($INTERFACE_NAME);
			my($ORIG_OBJ_JNI) = $ORIG_OBJ . "JNI";
			## invoke
			my($IFACE_PREFIX);
			if ($MARSHAL eq ':ipc-marshal')
			{
			    $IFACE_PREFIX = $INTERFACE_NAME . '_';
			}
			&writeString("CEHResult ${STUB_NAME}::invoke(${IFACE_PREFIX}MethodId mid, void* param)\n");
			&writeString("{\n");
			&writeString("\tCEHResult hr = CE_SILK_ERR_OPERATION_FAILED;\n");
			&writeString("\t// no check\n");
			if ($MARSHAL ne ':ipc-marshal')
			{
			    &writeString("\tCEASSERT(param);\n");
			}
			&writeString("\tswitch (mid)\n");
			&writeString("\t{\n");
			my(%INTERFACE_HASH) = &getInterfaceHash(\%IDL, $INTERFACE_NAME);
			my(@FUNCTIONS) = &getFunctionsIncludingInherit(\%IDL, \%INTERFACE_HASH);
			my($FUNCTION_REF);
			foreach $FUNCTION_REF (@FUNCTIONS)
			{
			    my($FUNCTION_NAME) = $FUNCTION_REF->{'name'};
			    if ($FUNCTION_NAME ne 'addRef' && $FUNCTION_NAME ne 'release' && ($MARSHAL ne ':ipc-marshal'  || $FUNCTION_NAME ne 'queryInterface'))
			    {
				my(@ALLOCATED_VARS);
				my($PARAM) = $FUNCTION_REF->{'param'};
				my(%VALUE_TYPE) = &getValueTypeMapFromAllParameter($PARAM);
				my(@VALUES) = &getValuesFromAllParameter($PARAM);
				my($METHOD_PARAM) = &getMethodParamName($FUNCTION_NAME);
				my($METHOD_ID) = &getMethodIdName($FUNCTION_NAME);
				&writeString("\tcase ${IFACE_PREFIX}${METHOD_ID}\:\n");
				&writeString("\t{\n");

				if ($MARSHAL ne ':ipc-marshal')
				{
				    &writeString("\t\thr = $ORIG_OBJ.$FUNCTION_NAME(\n");
				}
				else
				{
				    &writeString("\t\thr = CE_S_OK;\n");
				    if ($CLASS_REF_USE_CHK->{'c-to-java'})
				    {
					my($METHOD_ID) = &getMethodIdName($FUNCTION_NAME);
					&writeString("\t\tJNIEnv* env = ApmGetJNIEnv();\n");
				    }
				    my(@VALUES_TMP) = @VALUES;
				    my($VALUE);

				    if (@VALUES_TMP)
				    {
					&writeString("\t\tUINT8* buffer = reinterpret_cast<UINT8*>(param);\n");
					&writeString("\t\tint offset = 0;\n");
				    }
				    my($jobjectFlag) = 0;
				    while (@VALUES_TMP)
				    {
					$VALUE = shift(@VALUES_TMP);
					my($ORIGIN_TYPE) = &extractInterfaceWithStruct($VALUE_TYPE{$VALUE});
					if (&getInterfaceHash(\%IDL, $ORIGIN_TYPE ))
					{
					    if (($jobjectFlag eq 0) && ($CLASS_REF_USE_CHK->{'c-to-java'}))
					    {
						&writeString("\t\tjobject stubOut = NULL;\n");
						$jobjectFlag = 1;
					    }
					    my($IID) = &getIIDName($ORIGIN_TYPE);
					    my($ORIGIN_VALUE) = &getPointerValueName($ORIGIN_TYPE);
					    &writeString("\t\tCE_MAY_ALIAS_TYPE($ORIGIN_TYPE)* $ORIGIN_VALUE = NULL;\n");
					    &writeString("\t\tif (CESucceeded(hr))\n");
					    &writeString("\t\t{\n");

					    if ($CLASS_REF_USE_CHK->{'c-to-java'})
					    {
			       			&writeString("\t\t\thr = ${FUNCTION_PREFIX}GetProxy($IID, *reinterpret_cast<UINT_PTR*>(&buffer[offset]), reinterpret_cast<UINT_PTR*>(&$ORIGIN_VALUE));\n");
						&writeString("\t\t\tif (CESucceeded(hr))\n");
						&writeString("\t\t\t{\n");
						&writeString("\t\t\t\thr = ApmGetExternalJNI($IID, *reinterpret_cast<UINT_PTR*>(&buffer[offset]), &stubOut);\n");
						&writeString("\t\t\t}\n");
					    }
					    else
					    {
						&writeString("\t\t\thr = CERpcGetProxy(getSession(), $IID, *reinterpret_cast<UINT_PTR*>(&buffer[offset]), reinterpret_cast<UINT_PTR*>(&$ORIGIN_VALUE));\n");
					    }
					    &writeString("\t\t\toffset += sizeof(UINT_PTR);\n");
					    &writeString("\t\t}\n");
					}
					elsif ($VALUE_TYPE{$VALUE} =~ /STR_BUF\s*\*/)
					{
					    my($LEN) = shift(@VALUES_TMP);
					    my($TYPE) = $VALUE_TYPE{$VALUE};
					    &writeAssignment("\t\t", "STR_LEN", $LEN, "&buffer[offset]");
					    &writeString("\t\toffset += sizeof(STR_LEN);\n");
					    &writeAssignment("\t\t", "STR_BUF*", "origPtr$VALUE", "&buffer[offset]");
					    &writeString("\t\toffset += sizeof(STR_BUF*);\n");
					    &writeString("\t\tSTR_BUF* $VALUE = reinterpret_cast<STR_BUF*>(&buffer[offset]);\n");
					    &writeString("\t\toffset += $LEN * sizeof(STR_BUF);\n");
					    &writeString("\t\tif (!origPtr$VALUE)\n");
					    &writeString("\t\t{\n");
					    &writeString("\t\t\t$VALUE = NULL;\n");
					    &writeString("\t\t}\n");
					    if ($CLASS_REF_USE_CHK->{'c-to-java'})
					    {
						my($JStringObjectName) = "${VALUE}JStr";
						&writeString("\t\tjstring $JStringObjectName = NULL;\n");
						&writeString("\t\thr = NewJStringUTF(reinterpret_cast<char*>($VALUE), $LEN, &${JStringObjectName});\n");
					    }
					}
					elsif ($VALUE_TYPE{$VALUE} =~ /DATA_BUF/)
					{
					    my($LEN) = shift(@VALUES_TMP);
					    my($TYPE) = $VALUE_TYPE{$VALUE};
					    &writeAssignment("\t\t", "DATA_LEN", $LEN, "&buffer[offset]");
					    &writeString("\t\toffset += sizeof(DATA_LEN);\n");
					    &writeAssignment("\t\t", "DATA_BUF*", "origPtr$VALUE", "&buffer[offset]");
					    &writeString("\t\toffset += sizeof(DATA_BUF*);\n");
					    &writeString("\t\tDATA_BUF* $VALUE = reinterpret_cast<DATA_BUF*>(&buffer[offset]);\n");
					    &writeString("\t\toffset += $LEN * sizeof(DATA_BUF);\n");
					    &writeString("\t\tif (!origPtr$VALUE)\n");
					    &writeString("\t\t{\n");
					    &writeString("\t\t\t$VALUE = NULL;\n");
					    &writeString("\t\t}\n");
					    if ($CLASS_REF_USE_CHK->{'c-to-java'})
					    {
						my($JByteArray) = "${VALUE}JByteAry";
						&writeString("\t\tjbyteArray ${JByteArray} = NULL;\n");
						&writeString("\t\thr = createJByteArray((jbyte*)$VALUE, $LEN, &${JByteArray});\n");
					    }
					}
					elsif ($VALUE_TYPE{$VALUE} =~ /STRARRAY_BUF\s*\*/)
					{
					    my($LEN) = shift(@VALUES_TMP);
					    my($TYPE) = $VALUE_TYPE{$VALUE};

					    &writeAssignment("\t\t", "STRARRAY_LEN", $LEN, "&buffer[offset]");
					    &writeString("\t\toffset += sizeof(STRARRAY_LEN);\n");
					    &writeAssignment("\t\t", "STRARRAY_BUF*", "origPtr$VALUE", "&buffer[offset]");
					    &writeString("\t\toffset += sizeof(STRARRAY_BUF*);\n");
					    &writeString("\t\tSTRARRAY_BUF* tmp_$VALUE = reinterpret_cast<STRARRAY_BUF*>(&buffer[offset]);\n");
					    if ($CLASS_REF_USE_CHK->{'no-allocator'}) {
						&writeString("\t\tSTRARRAY_BUF* $VALUE = reinterpret_cast<STRARRAY_BUF *>(malloc(sizeof(STRARRAY_BUF)*$LEN));\n");
					    } else {
						&writeString("\t\tSTRARRAY_BUF* $VALUE = reinterpret_cast<STRARRAY_BUF *>(CEMALLOC(sizeof(STRARRAY_BUF)*$LEN));\n");
					    }
					    &writeString("\t\tUINT32 offset_$VALUE = 0;\n");
					    &writeString("\t\tif (!origPtr$VALUE)\n");
					    &writeString("\t\t{\n");
					    &writeString("\t\t\t$VALUE = NULL;\n");
					    &writeString("\t\t}\n");
					    &writeString("\t\telse\n");
					    &writeString("\t\t{\n");
					    &writeString("\t\t\tUINT32 index;\n");
					    &writeString("\t\t\tfor(index=0; $VALUE && index<$LEN; index++) {\n");
					    &writeString("\t\t\t\t$VALUE\[index\].buf = reinterpret_cast<STR_BUF*>(&tmp_$VALUE\[$LEN\]) + offset_$VALUE;\n");
					    &writeString("\t\t\t\t$VALUE\[index\].len = tmp_$VALUE\[index\].len;\n");
					    &writeString("\t\t\t\toffset_$VALUE += $VALUE\[index\].len;\n");
					    &writeString("\t\t\t}\n");
					    &writeString("\t\t}\n");
					    @ALLOCATED_VARS = $VALUE;
					    &writeString("\t\toffset += sizeof(STRARRAY_BUF)*$LEN + offset_$VALUE;\n");
					    if ($CLASS_REF_USE_CHK->{'c-to-java'})
					    {
						my($JByteArray) = "${VALUE}JByteAry";
						&writeString("\t\tjbyteArray ${JByteArray} = NULL;\n");
						&writeString("\t\thr = createJByteArray((jbyte*)$VALUE, $LEN*sizeof(STRARRAY_BUF), &${JByteArray});\n");
					    }
					}
					elsif ($VALUE_TYPE{$VALUE} =~ /UINT32ARRAY_BUF\s*\*/)
					{
					    my($LEN) = shift(@VALUES_TMP);
					    my($TYPE) = $VALUE_TYPE{$VALUE};
					    &writeAssignment("\t\t", "UINT32ARRAY_LEN", $LEN, "&buffer[offset]");
					    &writeString("\t\toffset += sizeof(UINT32ARRAY_LEN);\n");
					    &writeAssignment("\t\t", "UINT32ARRAY_BUF*", "origPtr$VALUE", "&buffer[offset]");
					    &writeString("\t\toffset += sizeof(UINT32ARRAY_BUF*);\n");
					    &writeString("\t\tUINT32ARRAY_BUF* $VALUE = reinterpret_cast<UINT32ARRAY_BUF*>(&buffer[offset]);\n");
					    &writeString("\t\toffset += $LEN * sizeof(UINT32ARRAY_BUF);\n");
					    &writeString("\t\tif (!origPtr$VALUE)\n");
					    &writeString("\t\t{\n");
					    &writeString("\t\t\t$VALUE = NULL;\n");
					    &writeString("\t\t}\n");
					    if ($CLASS_REF_USE_CHK->{'c-to-java'})
					    {
						my($JByteArray) = "${VALUE}JByteAry";
						&writeString("\t\tjbyteArray ${JByteArray} = NULL;\n");
						&writeString("\t\thr = createJByteArray((jbyte*)$VALUE, $LEN*sizeof(UINT32ARRAY_BUF), &${JByteArray});\n");
					    }
					}
					else
					{
					    my($TYPE) = $VALUE_TYPE{$VALUE};
					    $TYPE =~ s/const//;
					    &writeAssignment("\t\t", $TYPE, $VALUE, "&buffer[offset]");
					    &writeString("\t\toffset += sizeof($TYPE);\n");
					}
				    }
				    if ($CLASS_REF_USE_CHK->{'c-to-java'})
				    {
					my($METHOD_ID) = &getMethodIdName($FUNCTION_NAME);
					&writeString("\t\tif (CESucceeded(hr))\n");
					&writeString("\t\t{\n");
					&writeString("\t\t\tif (env)\n");
					&writeString("\t\t\t{\n");
				    }
				    else
				    {
					&writeString("\t\tif (CESucceeded(hr)) hr = $ORIG_OBJ.$FUNCTION_NAME(\n");
				    }
				}
				if ($CLASS_REF_USE_CHK->{'c-to-java'})
				{
				    my($ERR_INS_UNAVAIL) = "hr = CE_SILK_ERR_INSTANCE_UNAVAILABLE;";
				    my($JNI_METHOD_NAME) = &getJNIMethodName($CLASS_REF_USE_CHK, $FUNCTION_NAME);
				    &writeString("\t\t\t\tif($ORIG_OBJ_JNI)\n");
				    &writeString("\t\t\t\t{\n");
				    &writeString("\t\t\t\t\tjclass sysj = env->GetObjectClass($ORIG_OBJ_JNI);\n");
				    &writeString("\t\t\t\t\tif (sysj)\n");
				    &writeString("\t\t\t\t\t{\n");
				    &writeString("\t\t\t\t\t\tjmethodID mid = env->GetMethodID(sysj, \"$JNI_METHOD_NAME\", \"(");

				    my($COMMA);
				    my($VALUE);
 				    foreach $VALUE (@VALUES)
				    {
					my($PARAM_CONV) = &convertType($VALUE_TYPE{$VALUE});
					my($PARAM_CONV2) =  &convertSignature($PARAM_CONV);
					&writeString("$PARAM_CONV2");
				    }
				    &writeString(")I\");\n");
				    &writeString("\t\t\t\t\t\tif (mid)\n");
				    &writeString("\t\t\t\t\t\t{\n");
				    &writeString("\t\t\t\t\t\t\thr = static_cast<CEHResult>(env->CallIntMethod($ORIG_OBJ_JNI, mid ");
 				    foreach $VALUE (@VALUES)
				    {
					$COMMA = ',';
					my($ORIGIN_TYPE) = &extractInterfaceWithStruct($VALUE_TYPE{$VALUE});
					my($PARAM_CONV) = &convertType($ORIGIN_TYPE);
					my($PARAM_CONV2) = &convertNativeType($PARAM_CONV);
					if (&getInterfaceHash(\%IDL, $ORIGIN_TYPE ))
					{
					    &writeString("$COMMA stubOut");
					}
					elsif ($PARAM_CONV2 eq 'jstring')
					{
					    &writeString("$COMMA (jstring)${VALUE}JStr");
					}
					elsif ($PARAM_CONV2 eq 'jbyteArray')
					{
					    &writeString("$COMMA (jbyteArray)${VALUE}JByteAry");
					}
					else
					{
					    &writeString("$COMMA ($PARAM_CONV2)$VALUE");
					}
				    }
				    &writeString("));\n");
				    &writeString("\t\t\t\t\t\t}\n");
				    &writeString("\t\t\t\t\t\telse\n");
				    &writeString("\t\t\t\t\t\t{\n");
				    &writeString("\t\t\t\t\t\t\t$ERR_INS_UNAVAIL\n");
				    &writeString("\t\t\t\t\t\t}\n");
				    &writeString("\t\t\t\t\t}\n");
				    &writeString("\t\t\t\t\telse\n");
				    &writeString("\t\t\t\t\t{\n");
				    &writeString("\t\t\t\t\t\t$ERR_INS_UNAVAIL\n");
				    &writeString("\t\t\t\t\t}\n");
				    &writeString("\t\t\t\t}\n");
				    &writeString("\t\t\t\telse\n\t\t\t\t{\n");
				    &writeString("\t\t\t\t\t$ERR_INS_UNAVAIL\n");
				    &writeString("\t\t\t\t}\n");
				    &writeString("\t\t\t}\n");
				    &writeString("\t\t\telse\n\t\t\t{\n");
				    &writeString("\t\t\t\t$ERR_INS_UNAVAIL\n");
				    &writeString("\t\t\t}\n");
				    &writeString("\t\t}\n");
				    &writeString("\t\telse\n\t\t{\n");
				    &writeString("\t\t\t$ERR_INS_UNAVAIL\n");
				    &writeString("\t\t}\n");
				}
				else
				{
				    my($COMMA);
				    my($VALUE);
				    foreach $VALUE (@VALUES)
				    {
					if ($MARSHAL eq ':std-marshal')
					{
					    &writeString("\t\t\t$COMMA reinterpret_cast<${IFACE_PREFIX}${METHOD_PARAM}*>(param)->$VALUE\n");
					}
					elsif ($MARSHAL eq ':ipc-marshal')
					{
					    my($ORIGIN_TYPE) = &extractInterfaceWithStruct($VALUE_TYPE{$VALUE});
					    if (&getInterfaceHash(\%IDL, $ORIGIN_TYPE ))
					    {
						my($ORIGIN_VALUE) = &getPointerValueName($ORIGIN_TYPE);
						&writeString("\t\t\t$COMMA reinterpret_cast<$ORIGIN_TYPE*>($ORIGIN_VALUE)\n");
					    }
					    else
					    {
						&writeString("\t\t\t$COMMA $VALUE\n");
					    }
					}
					$COMMA = ', ';
				    }
				    &writeString("\t\t);\n");
 				 
				}
				my($ALLOCATED_VAR);
				foreach $ALLOCATED_VAR (@ALLOCATED_VARS)
				{
				    if ($CLASS_REF_USE_CHK->{'no-allocator'}) {
					&writeString("\t\tif($ALLOCATED_VAR) free($ALLOCATED_VAR);\n");
				    } else {
					&writeString("\t\tif($ALLOCATED_VAR) CEFREE($ALLOCATED_VAR);\n");
				    }
				}
				&writeString("\t\tbreak;\n");
				&writeString("\t}\n");
			    }
			    elsif ($FUNCTION_NAME eq 'release')
			    {
				my($METHOD_ID) = &getMethodIdName($FUNCTION_NAME);
				&writeString("\tcase ${IFACE_PREFIX}${METHOD_ID}\:\n");
				&writeString("\t{\n");
				if ($MARSHAL ne ':ipc-marshal')
				{
				    &writeString("\t\t$ORIG_OBJ.$FUNCTION_NAME();\n");
				    &writeString("\t\thr = CE_S_OK;\n");
				    &writeString("\t\t$ORIG_OBJ.detach();\n");
				}
				else
				{
				    &writeString("\t\tdelete this;\n");
				    &writeString("\t\thr = CE_S_OK;\n");
				}
				&writeString("\t\tbreak;\n");
				&writeString("\t}\n");
			    }
			}
			&writeString("\t}\n");
			&writeString("\treturn hr;\n");
			&writeString("}\n");

			$INTERFACE_COUNT++;
			if ($INTERFACE_COUNT != 0 && $MARSHAL ne ':ipc-marshal')
			{
			    last;
			}
		    }
		}
		## same proxy code for lw/std marshalling
		&writeThreeSacredTreasures($NAME, $CLASS_REF_USE_CHK, @{$CLASS_REF_USE_CHK->{'interface'}});

		&writeToICEUnknown($CLASS_REF_USE_CHK);

		my($STUB_NAME) = &getStubClassName($CLASS_REF_USE_CHK);
		my($ORIG_OBJ) = &getStubOriginalInterfaceName($NAME);

		my($INTERFACES_REF) = $CLASS_REF_USE_CHK->{'interface'};
		my($INTERFACE_REF);
		foreach $INTERFACE_REF (@{$INTERFACES_REF})
		{
		    &writeToInterface($CLASS_REF_USE_CHK, $INTERFACE_REF);
		    &writeToInstance($CLASS_REF_USE_CHK, $INTERFACE_REF);
		    &writeFunctionListWithInheritance(\%IDL, 'PROXY_FUNCTION_IMPL', $CLASS_REF_USE_CHK, $INTERFACE_REF->{'name'}, 0, &getInterfaceHash(\%IDL, $INTERFACE_REF->{'name'}));
		    &writeVtable($CLASS_REF_USE_CHK, 0, $INTERFACE_REF->{'name'});
		    
		}

		&writeConstructorImplementation($NAME, $CLASS_REF_USE_CHK, @{$CLASS_REF_USE_CHK->{'interface'}});
	    }
	    else
	    {
		die "Error: invalid option";
	    }
	}
    }
    #for JNI blocks.
    &writeJNIblock($CCD_FILE, @CLASSES);
    &writeSupportImplement($CCD{$CCD_FILE}, @{$CCD{$CCD_FILE}->{'class'}});
}
	
#for JNI.
sub writeJNIblock
{
    my($CCD_FILE, @CLASSES) = @_;
    my(@FUNCTIONS);

    my($USE_JNI) = 0;
    my($CLASS_REF_OL);
    foreach $CLASS_REF_OL (@CLASSES)
    {
	if ($CLASS_REF_OL->{'java-to-c'})
	{
	    $USE_JNI = 1;
	    last;
	}
    }
    if ($USE_JNI == 0)
    {
	return;
    }
    #JNI_OnLoad.
    my($pos_wk) = rindex $CCD_FILE, '.';
    my($MODULE_NAME) = substr $CCD_FILE, 0, $pos_wk;
    &writeString("JNIEXPORT jint JNICALL JNI_OnLoad_$MODULE_NAME(JavaVM *vm, void *reserved)\n");
    &writeString("{\n");
    &writeString("\tJNIEnv *env;\n");
    &writeString("\tjint ret = vm->GetEnv((void**)&env, JNI_VERSION_1_6);\n");
    &writeString("\tif (ret != JNI_OK)\n");
    &writeString("\t{\n");
    &writeString("\t\treturn 0;\n");
    &writeString("\t}\n");
    &writeString("\n");
    &writeString("\n");

    &writeString("\tjclass DefC = NULL;\n");
    foreach $CLASS_REF_OL (@CLASSES)
    {
	if ($CLASS_REF_OL->{'java-to-c'})
	{
	    &writeString("\tDefC = env->FindClass(\"$MODULE_NAME/$CLASS_REF_OL->{'name'}\");\n");
	    &writeString("\tif (DefC == NULL)\n");
	    &writeString("\t{\n");
	    &writeString("\t\tjthrowable ej = env->ExceptionOccurred();\n");
	    &writeString("\t\tif (ej != NULL)\n");
	    &writeString("\t\t{\n");
	    &writeString("\t\t\tenv->ExceptionDescribe();\n");
	    &writeString("\t\t\tenv->ExceptionClear();\n");
	    &writeString("\t\t}\n");
	    &writeString("\t\treturn 0;\n");
	    &writeString("\t}\n");
	    &writeString("\n");

	    my($INTERFACE_REF_OL);
	    my($INTERFACES_REF_OL)= $CLASS_REF_OL->{'interface'};
	    my($FUNCTION_REF_OL);

	    &writeString("\tJNINativeMethod mtd_$CLASS_REF_OL->{'name'}\[\] = \n");
	    &writeString("\t{\n");
	    foreach $INTERFACE_REF_OL (@{$INTERFACES_REF_OL})
	    {
		my($INTERFACE_NAME_OL) = $INTERFACE_REF_OL->{'name'};

		my(%INTERFACE_HASH_OL) = &getInterfaceHash(\%IDL, $INTERFACE_NAME_OL);
		@FUNCTIONS = &getFunctionsIncludingInherit(\%IDL, \%INTERFACE_HASH_OL);

		my($CLASS) = $CLASS_REF_OL->{'name'};
		if ($CLASS_REF_OL->{'marshal'})
		{
		    $CLASS = &getProxyClassName($CLASS_REF_OL);
		}
		foreach $FUNCTION_REF_OL (@FUNCTIONS)
		{
		    if (($FUNCTION_REF_OL->{'name'} ne "addRef") && ($FUNCTION_REF_OL->{'name'} ne "release"))
		    {
			my($FUNCTION_NAME) = $FUNCTION_REF_OL->{'name'};
			my($FUNC_IMPL_NAME);
			my($PARAM_NO_THIS) = $FUNCTION_REF_OL->{'param'};

			if ($FUNCTION_NAME eq "queryInterface")
			{
			    $FUNC_IMPL_NAME = &getImplementationMethodVtblName($CLASS, $FUNCTION_NAME) . "_$INTERFACE_NAME_OL" . "_JNI";
			}
			else
			{
			    $FUNC_IMPL_NAME = &getImplementationMethodVtblName($CLASS, $FUNCTION_NAME) . "_JNI";
			}
			my(@PARAMS) = split(/, /, $PARAM_NO_THIS);
			my($SIGNATURE_OL) = "(I";

			my($PARAM_CONV);
			foreach $PARAM_CONV (@PARAMS)
			{
			    my($PARAM_CONV_WK);
			    $PARAM_CONV_WK = &convertType($PARAM_CONV, $CLASS_REF_OL);
			    $PARAM_CONV_WK = &convertSignature($PARAM_CONV_WK);
			    $SIGNATURE_OL = $SIGNATURE_OL . $PARAM_CONV_WK;
			}
			if ($FUNCTION_REF_OL->{'return'} eq "void")
			{
			    $SIGNATURE_OL = $SIGNATURE_OL . ")V";
			}
			else
			{
			    $SIGNATURE_OL = $SIGNATURE_OL . ")I";
			}
			&writeString("\t\t{\n");
			&writeString("\t\t\tconst_cast<char*>(\"$FUNC_IMPL_NAME\"),\n");
			&writeString("\t\t\tconst_cast<char*>(\"$SIGNATURE_OL\"),\n");
			&writeString("\t\t\treinterpret_cast<void*>($FUNC_IMPL_NAME)\n");
			&writeString("\t\t},\n");
		    }
		}#function-loop-end.
	    }#interface-loop-end.
	    &writeString("\t};\n");
	    &writeString("\n");
	    &writeString("\tret = env->RegisterNatives(DefC, mtd_$CLASS_REF_OL->{'name'}, (sizeof(mtd_$CLASS_REF_OL->{'name'}) / sizeof(JNINativeMethod)));\n");
	    &writeString("\tif (ret != JNI_OK)\n");
	    &writeString("\t{\n");
	    &writeString("\t\treturn 0;\n");
	    &writeString("\t}\n");
	    &writeString("\n");
	    &writeString("\n");
	}#if-JNI
    }#class-loop-end.
    &writeString("\treturn JNI_VERSION_1_6;\n");
    &writeString("}\n");
}

sub writeThreeSacredTreasures
{
    my($NAME, $CLASS_REF, @INTERFACES) = @_;
    &writeString("//----------------------------------------------------------------\n");
    &writeString("// common implementation.\n");
    &writeString("//----------------------------------------------------------------\n");
 
    my($VALUE) = getPointerValueName($NAME);
    my($FND_TRANS) = $CLASS_REF->{'fnd-trans'};

    my($REFCOUNT_TARGET);
    if ($CLASS_REF->{'embed'} || $CLASS_REF->{'marshal'} || ($FND_TRANS eq ':trans-from-fnd'))
    {
	$REFCOUNT_TARGET = $VALUE;
    }
    else
    {
	$REFCOUNT_TARGET = "$VALUE->object()";
    }
    &writeAddRef($CLASS_REF, $VALUE, $REFCOUNT_TARGET);
    &writeRelease($CLASS_REF, $VALUE, $REFCOUNT_TARGET);
    &writeQueryInterface($CLASS_REF, $VALUE, @INTERFACES);
 }

sub writeAddRef
{
    my($CLASS_REF, $VALUE, $REFCOUNT_TARGET) = @_;
    my($CLASS) = $CLASS_REF->{'name'};
    if ($CLASS_REF->{'marshal'})
    {
	$CLASS = &getProxyClassName($CLASS_REF);
    }
    &writeString("static void _addRef($CLASS* $VALUE)\n");
    &writeString("{\n");
    &writeString("\t//CEASSERT($VALUE && \"$VALUE is 0\");\n");
    &writeString("\n");
    &writeString("\t$REFCOUNT_TARGET->AddRef();\n");
    &writeString("}\n");
    &writeString("\n");
}

sub writeRelease
{
    my($CLASS_REF, $VALUE, $REFCOUNT_TARGET) = @_;
    my($CLASS) = $CLASS_REF->{'name'};
    my($STUB_NAME);
    if ($CLASS_REF->{'marshal'})
    {
	$CLASS = &getProxyClassName($CLASS_REF);
	$STUB_NAME = &getStubClassName($CLASS_REF);
    }
    &writeString("static void _release($CLASS* $VALUE)\n");
    &writeString("{\n");
    &writeString("\t//CEASSERT($VALUE && \"$VALUE is 0\");\n");
    &writeString("\n");
    if ($CLASS_REF->{'marshal'} eq ':std-marshal' || $CLASS_REF->{'marshal'} eq ':lw-marshal')
    {
	&writeString("\tif ($REFCOUNT_TARGET->RefCount() == 1)\n");
	&writeString("\t{\n");
	my($INTERFACE_NAME) = $CLASS_REF->{'interface'}->[0]->{'name'};
	my($IID_NAME) = &getIIDName($INTERFACE_NAME);
	&writeString("\t\tCEComDiscardInterfacePointer($IID_NAME, ${CLASS}::to$INTERFACE_NAME($VALUE));\n");
	if ($CLASS_REF->{'marshal'} eq ':std-marshal')
	{
	    &writeString("\t\t${STUB_NAME}::release_param param = {};\n");
	    &writeString("\t\tCE_MAY_ALIAS_TYPE(ICEApartment)* apartment = 0;\n");
	    &writeString("\t\tCEHResult hr = CEComGetThreadContext(CEComIID_ICEApartment, reinterpret_cast<void**>(&apartment));\n");
	    &writeString("\t\tif (CESucceeded(hr))\n");
	    &writeString("\t\t{\n");
	    &writeString("\t\t\tCEComTransferApartment(apartment, $REFCOUNT_TARGET->getApartment());\n");
	    &writeString("\t\t\thr = CEComPostApartmentMessage($REFCOUNT_TARGET->getApartment(), apartment, (UINT32)${STUB_NAME}::MethodId_release, &param, &$REFCOUNT_TARGET->getStub(), ${STUB_NAME}::invoke_message_callback);\n");
	    &writeString("\t\t\tCEComTransferApartment($REFCOUNT_TARGET->getApartment(), apartment);\n");
	    &writeString("\t\t\tapartment->_vtbl->_release(apartment);\n");
	    &writeString("\t\t}\n");
	    &writeString("\t\tCEASSERT(CESucceeded(hr));\n");
	}
	&writeString("\t}\n");	
    }

    &writeString("\t$REFCOUNT_TARGET->Release();\n");
    &writeString("}\n");
    &writeString("\n");
}

sub writeQueryInterface
{
    my($CLASS_REF, $VALUE, @INTERFACES) = @_;
    my($CLASS) = $CLASS_REF->{'name'};
    if ($CLASS_REF->{'marshal'} eq ':lw-marshal' || $CLASS_REF->{'marshal'} eq ':std-marshal')
    {
	$CLASS = &getProxyClassName($CLASS_REF);
	if ($CLASS_REF->{'marshal'} eq ':lw-marshal')
	{
	    &writeString("static CEHResult _queryInterface($CLASS* $VALUE, const UINT32 iId, void* *const iOut)\n");
	}
	else
	{
	    &writeString("static CEHResult _queryInterface(ICEApartment* callerAparment, $CLASS* $VALUE, const UINT32 iId, void* *const iOut)\n");
	}
	&writeString("{\n");
	&writeString("\tCEASSERT($VALUE && \"$VALUE is 0\");\n");
	&writeString("\tCEASSERT(iOut && \"iOut is 0\");\n");
	&writeString("\n");

	&writeString("\tCEHResult hr = CE_SILK_ERR_OPERATION_FAILED;\n");
	my($FUNCTION_NAME) = &getStubFunctionName($CLASS_REF->{'marshal'}, 'queryInterface');
	
	if ($CLASS_REF->{'marshal'} eq ':lw-marshal')
	{
	    &writeString("\thr = $VALUE->getStub().$FUNCTION_NAME(iId, iOut);\n");
	}
	else
	{
	    my($STUB_NAME) = &getStubClassName($CLASS_REF);
	    my($METHOD_ID) = "$STUB_NAME\:\:" . &getMethodIdName('queryInterface');
	    my($METHOD_PARAM) = "$STUB_NAME\:\:" . &getMethodParamName('queryInterface');
	    &writeString("\t$METHOD_PARAM param = { iId, iOut };\n");
	    &writeString("\thr = CEComPostApartmentMessage($VALUE->getApartment(), callerAparment, (UINT32)$METHOD_ID, &param, &$VALUE->getStub(), $STUB_NAME\:\:invoke_message_callback);\n");
	}
	&writeString("\n");

	&writeString("\treturn hr;\n");
	&writeString("}\n");
	&writeString("\n");
    }
    else
    {
	if ($CLASS_REF->{'marshal'} eq ':ipc-marshal')
	{
	    $CLASS = &getProxyClassName($CLASS_REF);
	}
	&writeString("static CEHResult _queryInterface($CLASS* $VALUE, const UINT32 iId, void* *const iOut)\n");
	&writeString("{\n");
	&writeString("\t//CEASSERT($VALUE && \"$VALUE is 0\");\n");
	&writeString("\t//CEASSERT(iOut && \"iOut is 0\");\n");
	&writeString("\n");

	&writeString("\tCEHResult hr = CE_SILK_ERR_OPERATION_FAILED;\n");
	&writeString("\tswitch (iId)\n");
	&writeString("\t{\n");

	my($INTERFACE_REF);
	my($INTERFACE);
	my(@WROTE_INTERFACES);
	foreach $INTERFACE_REF (@INTERFACES)
	{
	    my($INTERFACE_NAME) = $INTERFACE_REF->{'name'};
	    @WROTE_INTERFACES = &writeSwitchCase($INTERFACE_NAME, @WROTE_INTERFACES);
	    if (!$FND_TRANS_FLAG)
	    {
		&writeString("\t{\n");
		&writeString("\t\t*iOut = ${CLASS}::to$INTERFACE_NAME($VALUE);\n");
		&writeString("\t\thr = CE_S_OK;\n");
		&writeString("\t\tbreak;\n");
		&writeString("\t}\n");
	    }
	    else
	    {
		my($FND_TRANS) = $CLASS_REF->{'fnd-trans'};

		if ($FND_TRANS eq ':trans-to-fnd')
		{
		    &writeString("\t{\n");
		    &writeString("\t\t*iOut = ${CLASS}::to$INTERFACE_NAME($VALUE);\n");
		    &writeString("\t\thr = CE_S_OK;\n");
		    &writeString("\t\tbreak;\n");
		    &writeString("\t}\n");
		}
		elsif ($FND_TRANS eq ':trans-from-fnd')
		{
		    if (!&isSpecialInterfaceForGenerator($INTERFACE_NAME))
		    {
			my($INTERFACE_VAR_CALL_METHOD) = &replaceInterfaceToVarCallMethodForPublic($INTERFACE_NAME);
			&writeString("\t{\n");
			&writeString("\t\tif ($VALUE->$INTERFACE_VAR_CALL_METHOD)\n");
			&writeString("\t\t{\n");
			&writeString("\t\t\t*iOut = ${CLASS}::to$INTERFACE_NAME($VALUE);\n");
			&writeString("\t\t\thr = CE_S_OK;\n");
			&writeString("\t\t}\n");
			&writeString("\t\telse\n");
			&writeString("\t\t{\n");
			&writeString("\t\t\thr = CE_SILK_ERR_NOTFOUND;\n");
			&writeString("\t\t}\n");
			&writeString("\t\tbreak;\n");
			&writeString("\t}\n");
		    }
		}
		else
		{
		    die("Error: Wrong type $FND_TRANS, stopped");
		}

		my($NEW_INTERFACE_NAME) = &replaceInterfacePrefixForPublic($INTERFACE_NAME);
		if (($NEW_INTERFACE_NAME ne $INTERFACE_NAME) || &isSpecialInterfaceForGenerator($INTERFACE_NAME))
		{
		    @WROTE_INTERFACES = &writeSwitchCase($NEW_INTERFACE_NAME, @WROTE_INTERFACES);
		    &writeString("\t{\n");
		    &writeString("\t\t*iOut = ${CLASS}::to$NEW_INTERFACE_NAME($VALUE);\n");
		    &writeString("\t\thr = CE_S_OK;\n");
		    &writeString("\t\tbreak;\n");
		    &writeString("\t}\n");
		}
	    }
	}

	&writeString("\tdefault:\n");
	&writeString("\t{\n");
	&writeString("\t\thr = CE_SILK_ERR_NOTFOUND;\n");
	&writeString("\t\tbreak;\n");
	&writeString("\t}\n");

	&writeString("\t}\n");
	&writeString("\n");
	
	&writeString("\tif (CESucceeded(hr))\n");
	&writeString("\t{\n");
	&writeString("\t\t_addRef($VALUE);\n");
	&writeString("\t}\n");
	&writeString("\n");

	&writeString("\treturn hr;\n");
	&writeString("}\n");
	&writeString("\n");
    }
}

sub writeToICEUnknown
{
    my($CLASS_REF) = @_;

    my($NAME) = $CLASS_REF->{'name'};
    if ($CLASS_REF->{'marshal'})
    {
	$NAME = &getProxyClassName($CLASS_REF);
    }
    my($VALUE) = &getPointerValueName($NAME);
    my($ICEUNKNOWN_INTERFACE_REF) = $CLASS_REF->{'interface'}->[0];
    if ($ICEUNKNOWN_INTERFACE_REF->{'name'} ne 'ICEUnknown')
    {
	my($VPTR) = $ICEUNKNOWN_INTERFACE_REF->{'vptr'};
	if (!$VPTR)
	{
	    $VPTR = &getVptrName($ICEUNKNOWN_INTERFACE_REF->{'name'});
	}
	if ($FND_TRANS_FLAG)
	{
	    $VPTR = &replaceVariablePrefixForPublic($VPTR);
	}

	&writeString("ICEUnknown* ${NAME}::toICEUnknown($NAME* $VALUE)\n");
	&writeString("{\n");
	&writeString("\treturn INSTANCE_TO_IPTR(ICEUnknown, $NAME, $VALUE, $VPTR);\n");
	&writeString("}\n");
    }
}

sub writeToWrapper
{
    my($CLASS_REF) = @_;

    my($NAME) = $CLASS_REF->{'name'};
    my($INHERIT) = $CLASS_REF->{'inheritance'};
    my($EMBED) = $CLASS_REF->{'embed'};

    if ($INHERIT)
    {
	my($VALUE) = &getPointerValueName($INHERIT);
	&writeString("$NAME* ${NAME}::toWrapper($INHERIT* $VALUE)\n");
	&writeString("{\n");
	&writeString("\treturn static_cast<$NAME*>($VALUE);\n");
	&writeString("}\n");
    }
    elsif ($EMBED)
    {
	my($VALUE) = &getPointerValueName($EMBED);
	my($SUBSTANCE_MEMBER) = &getSubstanceValueName($EMBED);
	&writeString("$NAME* ${NAME}::toWrapper($EMBED* $VALUE)\n");
	&writeString("{\n");
	&writeString("\treturn MEMBER_TO_INSTANCE($NAME, $VALUE, $SUBSTANCE_MEMBER);\n");
	&writeString("}\n");
    }
    else
    {
	die "no available implementation option to write wrapper convertion\n";
    }

}

sub writeInterfaceImplementation
{
    my($CLASS_REF, $INTERFACE_REF) = @_;

    &writeString("////\n");
    &writeString("// $INTERFACE_REF->{'name'}\n");
    &writeToInterface($CLASS_REF, $INTERFACE_REF);
    &writeToInstance($CLASS_REF, $INTERFACE_REF);

    &writeFunctionListWithInheritance(\%IDL, 'CLASS_FUNCTION_IMPL', $CLASS_REF, $INTERFACE_REF->{'name'}, 0, &getInterfaceHash(\%IDL, $INTERFACE_REF->{'name'}));
    &writeVtable($CLASS_REF, 0, $INTERFACE_REF->{'name'});
    if (&isFndNecessary($INTERFACE_REF->{'name'}))
    {
	&writeFunctionListWithInheritance(\%IDL, 'CLASS_FUNCTION_IMPL', $CLASS_REF, $INTERFACE_REF->{'name'}, 1, &getInterfaceHash(\%IDL, $INTERFACE_REF->{'name'}));
	&writeVtable($CLASS_REF, 1, $INTERFACE_REF->{'name'});
    }
}

sub writeToInterface
{
    my($CLASS_REF, $INTERFACE_REF) = @_;
    my($CLASS_NAME) = $CLASS_REF->{'name'};
    my($INHERIT) = $CLASS_REF->{'inheritance'};
    my($EMBED) = $CLASS_REF->{'embed'};
    my($MARSHAL) = $CLASS_REF->{'marshal'};
    my($MARSHAL_FACTORY) = $CLASS_REF->{'marshal-factory'};
    my($FND_TRANS) = $CLASS_REF->{'fnd-trans'};

    my($VALUE) = &getPointerValueName($CLASS_NAME);
    my($IFACE_NAME) = $INTERFACE_REF->{'name'};
    my($VPTR) = $INTERFACE_REF->{'vptr'};
    if (!$VPTR)
    {
	$VPTR = &getVptrName($IFACE_NAME);
    }
    if ($MARSHAL)
    {
	$CLASS_NAME = &getProxyClassName($CLASS_REF);
    }
    &writeString("$IFACE_NAME* ${CLASS_NAME}::to$IFACE_NAME($CLASS_NAME* $VALUE)\n");
    &writeString("{\n");
    &writeString("\treturn INSTANCE_TO_IPTR($IFACE_NAME, $CLASS_NAME, $VALUE, $VPTR);\n");
    &writeString("}\n");
    &writeString("\n");

    my($FND_IFACE_NAME);
    if (&isFndNecessary($IFACE_NAME))
    {
	$FND_IFACE_NAME = &replaceInterfacePrefixForPublic($IFACE_NAME);
	my($FND_VPTR)   = &replaceVariablePrefixForPublic($VPTR);
	&writeString("$FND_IFACE_NAME* ${CLASS_NAME}::to$FND_IFACE_NAME($CLASS_NAME* $VALUE)\n");
	&writeString("{\n");
	&writeString("\treturn INSTANCE_TO_IPTR($FND_IFACE_NAME, $CLASS_NAME, $VALUE, $FND_VPTR);\n");
	&writeString("}\n");
	&writeString("\n");
    }

    if ($INHERIT)
    {
	$VALUE = &getPointerValueName($CLASS_NAME);
	&writeString("$IFACE_NAME* ${CLASS_NAME}::to$IFACE_NAME($INHERIT* $VALUE)\n");
	&writeString("{\n");
	&writeString("\treturn to$IFACE_NAME(static_cast<$CLASS_NAME*>($VALUE));\n");
	&writeString("}\n");
	&writeString("\n");
	&writeString("\n");
    }
    elsif ($EMBED)
    {
	$VALUE = &getPointerValueName($EMBED);
	my($EMBED_VALUE) = &getSubstanceValueName($EMBED);
	&writeString("$IFACE_NAME* ${CLASS_NAME}::to$IFACE_NAME($EMBED* $VALUE)\n");
	&writeString("{\n");
	&writeString("\treturn to$IFACE_NAME(MEMBER_TO_INSTANCE($CLASS_NAME, $VALUE, $EMBED_VALUE));\n");
	&writeString("}\n");
	&writeString("\n");
	&writeString("\n");

	if (&isFndNecessary($IFACE_NAME))
	{
	    &writeString("$FND_IFACE_NAME* ${CLASS_NAME}::to$FND_IFACE_NAME($EMBED* $VALUE)\n");
	    &writeString("{\n");
	    &writeString("\treturn to$FND_IFACE_NAME(MEMBER_TO_INSTANCE($CLASS_NAME, $VALUE, $EMBED_VALUE));\n");
	    &writeString("}\n");
	    &writeString("\n");
	    &writeString("\n");
	}
    }
    elsif ($MARSHAL_FACTORY || $MARSHAL || ($FND_TRANS eq ':trans-from-fnd'))
    {
	## do nothing
    }
    else
    {
	die "no available implementation option to write interface convertion\n";
    }
}

sub writeToInstance
{
    my($CLASS_REF, $INTERFACE_REF) = @_;
    my($CLASS_NAME) = $CLASS_REF->{'name'};
    my($INHERIT) = $CLASS_REF->{'inheritance'};
    my($EMBED) = $CLASS_REF->{'embed'};
    my($MARSHAL) = $CLASS_REF->{'marshal'};
    my($MARSHAL_FACTORY) = $CLASS_REF->{'marshal-factory'};
    my($FND_TRANS) = $CLASS_REF->{'fnd-trans'};

    my($SUBSTANCE);
    if ($INHERIT)
    {
	$SUBSTANCE = $INHERIT;
    }
    elsif ($EMBED)
    {
	$SUBSTANCE = $EMBED;
    }
    elsif ($MARSHAL || $MARSHAL_FACTORY || ($FND_TRANS eq ':trans-from-fnd'))
    {
	## keep substance null
    }
    else
    {
	die "no available implementation option to write instance convertion\n";
    }

    if ($MARSHAL)
    {
	$CLASS_NAME = &getProxyClassName($CLASS_REF);
    }

    my($IFACE_NAME) = $INTERFACE_REF->{'name'};
    my($VALUE) = &getInterfaceValueName($IFACE_NAME);
    my($VPTR) = $INTERFACE_REF->{'vptr'};
    if (!$VPTR)
    {
	$VPTR = &getVptrName($IFACE_NAME);
    }
    &writeString("$CLASS_NAME* ${CLASS_NAME}::toInstance($IFACE_NAME* $VALUE)\n");
    &writeString("{\n");
    &writeString("\treturn IPTR_TO_INSTANCE($CLASS_NAME, $VALUE, $VPTR);\n");
    &writeString("}\n");
    &writeString("\n");

    my($FND_IFACE_NAME);
    my($FND_VPTR);
    my($FND_VALUE);
    if (&isFndNecessary($IFACE_NAME))
    {
	$FND_IFACE_NAME = &replaceInterfacePrefixForPublic($IFACE_NAME);
	$FND_VPTR       = &replaceVariablePrefixForPublic($VPTR);
	$FND_VALUE      = &getInterfaceValueName($FND_IFACE_NAME);

	&writeString("$CLASS_NAME* ${CLASS_NAME}::toInstance($FND_IFACE_NAME* $FND_VALUE)\n");
	&writeString("{\n");
	&writeString("\treturn IPTR_TO_INSTANCE($CLASS_NAME, $FND_VALUE, $FND_VPTR);\n");
	&writeString("}\n");
	&writeString("\n");
    }

    if ($SUBSTANCE)
    {
	&writeString("$SUBSTANCE* ${CLASS_NAME}::toSubstance($IFACE_NAME* $VALUE)\n");
	&writeString("{\n");
	&writeString("\treturn $VALUE? toInstance($VALUE)->object() : NULL;\n");
	&writeString("}\n");
	&writeString("\n");
	&writeString("\n");

	if (&isFndNecessary($IFACE_NAME))
	{
	    &writeString("$SUBSTANCE* ${CLASS_NAME}::toSubstance($FND_IFACE_NAME* $FND_VALUE)\n");
	    &writeString("{\n");
	    &writeString("\treturn $FND_VALUE? toInstance($FND_VALUE)->object() : NULL;\n");
	    &writeString("}\n");
	    &writeString("\n");
	    &writeString("\n");
	}
    }
}

sub writeSwitchCase
{
    my($INTERFACE, @WROTE_INTERFACES) = @_;

    my(%INTERFACE_HASH) = &getInterfaceHash(\%IDL, $INTERFACE);
    if ($INTERFACE_HASH{'inheritance'})
    {
	@WROTE_INTERFACES = &writeSwitchCase($INTERFACE_HASH{'inheritance'}, @WROTE_INTERFACES);
    }

    my($i);
    for ($i = 0; $i < $#WROTE_INTERFACES + 1; $i++)
    {
	if ($WROTE_INTERFACES[$i] eq $INTERFACE)
	{
	    last;
	}
    }

    if ($i >= $#WROTE_INTERFACES + 1)
    {
	my($IID) = &getIIDName($INTERFACE);
	&writeString("\tcase $IID:\n");
	push(@WROTE_INTERFACES, $INTERFACE);
    }

    return @WROTE_INTERFACES;
}

sub getVptrName
{
    my($TYPE) = @_;
    my($VALUE) = &getPointerValueName($TYPE);
    return '_' . $VALUE . 'Vptr';
}

sub writeVtable
{
    my($CLASS_REF, $WRITE_SPX, $INTERFACE) = @_;
    my($ORG_INTERFACE) = $INTERFACE;
    if ($FND_TRANS_FLAG && $WRITE_SPX)
    {
	$INTERFACE = &replaceInterfacePrefixForPublic($INTERFACE);
    }
    my($CLASS) = $CLASS_REF->{'name'};
    if ($CLASS_REF->{'marshal'})
    {
	$CLASS = &getProxyClassName($CLASS_REF);
    }
    my($VTBL) = &getVtableName($INTERFACE);
    my($VALUE) = &getVtableValueName($CLASS, $INTERFACE);
    if ($FND_TRANS_FLAG && $WRITE_SPX)
    {
	$VALUE = &replaceVariablePrefixForPublic($VALUE);
	$VTBL  = &replaceVtableFunctionNamePrefixForPublic($VTBL);
	$VTBL  = &replaceVariablePrefixForPublic($VTBL);
    }
    &writeString("static const $VTBL $VALUE =\n");
    &writeString("{\n");
    if ($FND_TRANS_FLAG && $WRITE_SPX)
    {
	&writeFunctionListWithInheritance(\%IDL, 'CLASS_VTABLE_IMPL', $CLASS_REF, $INTERFACE, $WRITE_SPX, &getInterfaceHash(\%IDL, $ORG_INTERFACE));
    }
    else
    {
	&writeFunctionListWithInheritance(\%IDL, 'CLASS_VTABLE_IMPL', $CLASS_REF, $INTERFACE, 0, &getInterfaceHash(\%IDL, $INTERFACE));
    }
    &writeString("};\n");
    &writeString("\n");
}

sub removeDefaultArgument
{
    my($WHOLE_PARAM) = @_;
    my(@PARAMS) = split(/\s*\,\s*/ , $WHOLE_PARAM);
    my(@RESULT_PARAMS);
    my($PARAM);
    foreach $PARAM (@PARAMS)
    {
	if ($PARAM =~ /(.*)\=.*$/)
	{
	    $PARAM = $1;
	}
	push(@RESULT_PARAMS, $PARAM);
    }
    return join(', ', @RESULT_PARAMS);
};

sub writeConstructorImplementation
{
    my($CLASS, $CLASS_REF, @INTERFACES) = @_;
    if ($CLASS_REF->{'marshal'})
    {
	$CLASS = &getProxyClassName($CLASS_REF);
    }
    &writeString("//----------------------------------------------------------------\n");
    &writeString("// constructor.\n");
    &writeString("//----------------------------------------------------------------\n");

    my($INHERITANCE) = $CLASS_REF->{'inheritance'};
    my($EMBED) = $CLASS_REF->{'embed'};
    my($MARSHAL) = $CLASS_REF->{'marshal'};
    my($MARSHAL_FACTORY) = $CLASS_REF->{'marshal-factory'};
    my($FND_TRANS) = $CLASS_REF->{'fnd-trans'};

    my($FIRST_VALUE, $LAST_INITIALIZE);
    if ($EMBED || ($FND_TRANS eq ':trans-from-fnd'))
    {
	$LAST_INITIALIZE = "_refCount(0)";
    }
    if ($EMBED)
    {
	$FIRST_VALUE = &getSubstanceValueName($EMBED);
    }
    else
    {
	$EMBED = $INHERITANCE;
	$FIRST_VALUE = $INHERITANCE;
    }


    if ($EMBED)
    {
	my(%CLASS_HASH) = &getClassHash(\%CPPHEADER, $EMBED);

	my(@CONSTRUCTORS) = @{$CLASS_HASH{'constructor'}};

	if (@CONSTRUCTORS)
	{
	    my($CONSTRUCTOR_REF);
	    foreach $CONSTRUCTOR_REF (@CONSTRUCTORS)
	    {
		my(%CONSTRUCTOR) = %{$CONSTRUCTOR_REF};
		my($PARAM) = &removeDefaultArgument($CONSTRUCTOR{'parameter'});

		my(@IFDEFS) = @{$CONSTRUCTOR{'pre_ctor_ifdef'}};
		my($IFDEF);
		foreach $IFDEF (@IFDEFS)
		{
		    &writeString("$IFDEF");
		}

		my($ACCESS) = $CONSTRUCTOR{'access'};
		if ($ACCESS ne 'private')
		{
		    &writeString("${CLASS}::$CLASS($PARAM)\n");
		    &writeConstructorInitializer($CLASS, $FIRST_VALUE, $LAST_INITIALIZE, $CONSTRUCTOR{'parameter'}, 0, @INTERFACES);
		}

		@IFDEFS = @{$CONSTRUCTOR{'post_ctor_ifdef'}};
		foreach $IFDEF (@IFDEFS)

		{
		    &writeString("$IFDEF");
		}
	    }
	}
    }
    elsif ($MARSHAL eq ':lw-marshal' || $MARSHAL eq ':std-marshal' || $MARSHAL eq ':ipc-marshal')
    {
	my(%MODULE) = &getComModuleHash(\%CCD);
	my($ORIGIN_INTERFACE) = $CLASS_REF->{'interface'}->[0];
	my($FIRST_VALUE);
	my($PARAM_LIST);
	my($CODE_IN_BLOCK);
	if ($MARSHAL eq ':lw-marshal' || $MARSHAL eq ':std-marshal')
	{
	    my($ABST_FACTORY_NAME) = &getAbstractClassFactoryName($MODULE{'name'});
	    &writeString("${CLASS}::$CLASS($ABST_FACTORY_NAME* pClazz, $ORIGIN_INTERFACE->{'name'}* iOrig, CEComICEApartmentRef apart)\n");
	    ## eek...
	    $FIRST_VALUE = $ABST_FACTORY_NAME . '::Object(pClazz), _stub';
	    $PARAM_LIST = 'iOrig';
	    $CODE_IN_BLOCK = "\t_apartment = apart;\n";
	}
	elsif ($MARSHAL eq ':ipc-marshal')
	{
	    my($STUB_NAME) = &getStubClassName($CLASS_REF);
	    &writeString("${CLASS}::$CLASS(CERpcSession session, $STUB_NAME* stub)\n");
	    $FIRST_VALUE = 'CEIpcMarshallerBase(session), _stub';
	    $PARAM_LIST = 'stub';
	    $CODE_IN_BLOCK = "\t_refCount = 0;\n";
	}

	&writeConstructorInitializer($CLASS, $FIRST_VALUE, $LAST_INITIALIZE, $PARAM_LIST, $CODE_IN_BLOCK, @INTERFACES);
    }
    elsif ($MARSHAL_FACTORY)
    {
	&writeString("${CLASS}::$CLASS(UINT32 clsid)\n");
	my(%MODULE) = &getComModuleHash(\%CCD);
	my($FIRST_VALUE) = &getAbstractClassFactoryName($MODULE{'name'});
	my($PARAM_LIST) = 'clsid';
	&writeConstructorInitializer($CLASS, $FIRST_VALUE, $LAST_INITIALIZE, $PARAM_LIST, 0, @INTERFACES);
    }
    elsif ($FND_TRANS eq ':trans-from-fnd')
    {
	&writeString("${CLASS}::$CLASS(ICEUnknown* iUnknown)\n");
	my($CODE_IN_BLOCK) = &writeInterfaceInitializer(@INTERFACES);
	&writeConstructorInitializer($CLASS, 0, $LAST_INITIALIZE, 0, $CODE_IN_BLOCK, @INTERFACES);
    }
    else
    {
	die "Error: no :inherit :embed or :*-marshal";
    }
}

sub writeConstructorInitializer
{
    my($CLASS, $FIRST_VALUE, $LAST_INITIALIZE, $PARAMETER, $CODE_IN_BLOCK, @INTERFACES) = @_;

    my($FORCE_INLINE_GCC) = &getGccInlineOption();

    my($INTERFACE_REF);
    my(@INITIALIZERS, @ASSIGNMENTS);

    if ($FIRST_VALUE)
    {
	my($PARAM_WO_DEFAULT) = &removeDefaultArgument($PARAMETER);
	my($VALUE_LIST) = join(', ', &getValuesFromAllParameter($PARAM_WO_DEFAULT));
	unshift(@INITIALIZERS, "$FIRST_VALUE($VALUE_LIST)");
    }

    foreach $INTERFACE_REF (@INTERFACES)
    {
	if ($INTERFACE_REF->{'vptr'})
	{
	    my($VPTR) = $INTERFACE_REF->{'vptr'};
	    my($VTBL) = &getVtableValueName($CLASS, $INTERFACE_REF->{'name'});
	    my($ASSIGNMENT) = "$VPTR = &$VTBL;";
	    push(@ASSIGNMENTS, $ASSIGNMENT);
	}
	else
	{
	    my($VPTR) = &getVptrName($INTERFACE_REF->{'name'});
	    my($VTBL) = &getVtableValueName($CLASS, $INTERFACE_REF->{'name'});
	    my($INTIALIZER) = "$VPTR(&$VTBL)";
	    push(@INITIALIZERS, $INTIALIZER);
	}

	if (&isFndNecessary($INTERFACE_REF->{'name'}))
	{
	    if ($INTERFACE_REF->{'vptr'})
	    {
		die ("Error: Not implemented yet\n");
		my($VPTR) = $INTERFACE_REF->{'vptr'};
		my($VTBL) = &getVtableValueName($CLASS, $INTERFACE_REF->{'name'});
		my($ASSIGNMENT) = "$VPTR = &$VTBL;";
		push(@ASSIGNMENTS, $ASSIGNMENT);
	    }
	    else
	    {
		my($VPTR) = &getVptrName($INTERFACE_REF->{'name'});
		my($VTBL) = &getVtableValueName($CLASS, $INTERFACE_REF->{'name'});
		$VPTR = &replaceVariablePrefixForPublic($VPTR);
		$VTBL = &replaceVtableFunctionNamePrefixForPublic($VTBL);
		$VTBL = &replaceVariablePrefixForPublic($VTBL);
		my($INTIALIZER) = "$VPTR(&$VTBL)";
		push(@INITIALIZERS, $INTIALIZER);
	    }
	}
    }

    my($INITIALIZER_LIST);
    if ($#INITIALIZERS > -1)
    {
	$INITIALIZER_LIST = join(', ', @INITIALIZERS);
	&writeString("\t: ");
	&writeString("$INITIALIZER_LIST\n");
    }

    &writeString("{\n");
    if ($LAST_INITIALIZE)
    {
	&writeString("\tCEComAtomicInit(_refCount);\n");
    }
    if ($CODE_IN_BLOCK)
    {
	&writeString("$CODE_IN_BLOCK");
    }
    if ($#ASSIGNMENTS > -1)
    {
	&writeString("\tinitVtbl();\n");
    }
    &writeString("}\n");

    if ($#ASSIGNMENTS > -1)
    {
	&writeString("void ${CLASS}::initVtbl()\n");
	&writeString("{\n");
	my($ASSIGNMENT);
	foreach $ASSIGNMENT (@ASSIGNMENTS)
	{
	    &writeString("\t$ASSIGNMENT\n");
	}
	&writeString("}\n");
    }

    &writeString("\n");
}

sub getVtableValueName
{
    my($CLASS, $TYPE) = @_;
    if ($TYPE)
    {
	my($VALUE) = &getPointerValueName($TYPE);
#	return '_' . $VALUE . 'Vtbl';
	return &getImplementationMethodVtblName($CLASS, $VALUE . 'Vtbl');
    }
}

sub getSubstanceValueName
{
    my($TYPE) = @_;
    if ($TYPE)
    {
	my($VALUE) = &getPointerValueName($TYPE);
	return '_' . $VALUE . 'Substance';
    }
}

sub writeInterfaceInitializer
{
    my(@INTERFACES) = @_;
    
    my($CODE_IN_BLOCK);

    $CODE_IN_BLOCK .= "\n";
    $CODE_IN_BLOCK .= "\tif (iUnknown)\n";
    $CODE_IN_BLOCK .= "\t{\n";
    $CODE_IN_BLOCK .= "\t\tCEHResult hr = CE_S_OK;\n";

    my($INTERFACE_REF);
    foreach $INTERFACE_REF (@INTERFACES)
    {
	if (&isSpecialInterfaceForGenerator($INTERFACE_REF->{'name'}))
	{
	    my($REF) = "Ref";
	    my($PRIVATE_INTERFACE_VALUE_NAME) = &getPrivateInterfaceValueName('ICEUnknown');

	    $CODE_IN_BLOCK .= "\t\t$PRIVATE_INTERFACE_VALUE_NAME$REF = iUnknown;\n";
	}
	else
	{
	    my($INTERFACE_VAR) = &replaceInterfaceToVarForPublic($INTERFACE_REF->{'name'});
	
	    $CODE_IN_BLOCK .= "\t\tif (CESucceeded(hr) || hr == CE_SILK_ERR_NOTFOUND)\n";
	    $CODE_IN_BLOCK .= "\t\t{\n";
	    $CODE_IN_BLOCK .= "\t\t\thr = $INTERFACE_VAR.initByQueryInterface(iUnknown);\n";
	    $CODE_IN_BLOCK .= "\t\t}\n";
	}
    }

    $CODE_IN_BLOCK .= "\t\tCEASSERT(CESucceeded(hr) || hr == CE_SILK_ERR_NOTFOUND);\n";
    $CODE_IN_BLOCK .= "\t}\n";

    return $CODE_IN_BLOCK;
}

sub isSpecialInterfaceForGenerator
{
    my($INTERFACE_NAME) = @_;
    return $INTERFACE_NAME =~ /^ICEGen\w+/;
}

########################################################################################################
### write module implementation
########################################################################################################

sub writeModuleHeader
{
    my($MODULE_REF) = @_;
    
    if (!$MODULE_REF->{'referred'})
    {
	my($MODULE_NAME) = $MODULE_REF->{'name'};

	&writeString("\n");
	&writeString("\n");
	my($MODULE_ENV_NAME) = $MODULE_NAME . 'ModuleEnv';
	my($ABST_CLASS_FACTORY_NAME) = &getAbstractClassFactoryName($MODULE_NAME);
	my($CLASS_FACTORY_NAME) = $MODULE_NAME . 'ClassFactoryImpl';

	&writeString("class $MODULE_ENV_NAME;\n");
	&writeString("typedef CEComAbstractClassFactoryT<$MODULE_ENV_NAME> $ABST_CLASS_FACTORY_NAME;\n");
	&writeString("class $MODULE_ENV_NAME\n");
	&writeString("{\n");
	&writeAllocator(0);
	&writeString("public:\n");
	&writeString("\tstatic bool isValidGuid(UINT32 clsid, UINT32 iid);\n");
	&writeString("\tstatic $ABST_CLASS_FACTORY_NAME* createClassFactory(UINT32 clsid, UINT32 iid, void** ppv);\n");
	&writeString("\tstatic void* toInterface($ABST_CLASS_FACTORY_NAME* pcf, UINT32 clsid, UINT32 iid);\n");
	&writeString("\t#if !defined(PLATFORM_DTT)\n");
	&writeString("\tstatic CEATOMIC incLoadCount() { return CEComAtomicIncrement(_count); }\n");
	&writeString("\tstatic CEATOMIC decLoadCount() { return CEComAtomicDecrement(_count); }\n");
	&writeString("\tstatic INT32 getLoadCount() { return CEComAtomicCount(_count); }\n");
	&writeString("private:\n");
	&writeString("\tstatic CEATOMIC _count;\n");
	&writeString("\t#else\n");
	&writeString("\tstatic INT32 incLoadCount() { return ++_count; }\n");
	&writeString("\tstatic INT32 decLoadCount() { return (_count > 1)? --_count : _count; }\n");
	&writeString("\tstatic INT32 getLoadCount() { return _count; }\n");
	&writeString("private:\n");
	&writeString("\tstatic INT32 _count;\n");
	&writeString("\t#endif\n");
	&writeString("};\n");
	&writeString("\n");
    }
    else
    {
	my(@MODULE_HEADER);
	push(@MODULE_HEADER, $MODULE_REF->{'header'});
	&writeIncludeList(@MODULE_HEADER);
    }
}

sub writeModuleImplementation
{
    my($MODULE_REF) = @_;

    if (!$MODULE_REF->{'referred'})
    {
	my($MODULE_NAME) = $MODULE_REF->{'name'};
	my($MODULE_ENV_NAME) = $MODULE_NAME . 'ModuleEnv';
	my($ABST_CLASS_FACTORY_NAME) = &getAbstractClassFactoryName($MODULE_NAME);
	my($CLASS_FACTORY_NAME) = $MODULE_NAME . 'ClassFactoryImpl';

	&writeString("\n");
	&writeString("bool ${MODULE_ENV_NAME}::isValidGuid(UINT32 clsid, UINT32 iid)\n");
	&writeString("{\n");

	my($CONDITION);
 	if ($MODULE_REF->{'validation'} eq ':factory-id-validation')
 	{
 	    my(@CONDITIONS) = &getFactoryClsidIidConditions($MODULE_REF, 'clsid' ,'iid');
 	    $CONDITION = 'return ' . join(' || ', @CONDITIONS) . ';';
 	}
 	elsif ($MODULE_REF->{'validation'} eq ':creatable-id-validation' || !$MODULE_REF->{'validation'})
	{
	    my(@CONDITIONS) = &getCreatableClsidIidConditions($MODULE_REF, 'clsid' ,'iid');
	    $CONDITION = 'return ' . join(' || ', @CONDITIONS) . ';';
	}
 	else
 	{
 	    die "unknown validation type: $MODULE_REF->{'validation_type'}\n";
 	}

	&writeString("\t$CONDITION\n");
	&writeString("}\n");

	&writeString("$ABST_CLASS_FACTORY_NAME* ${MODULE_ENV_NAME}::createClassFactory(UINT32 clsid, UINT32 iid, void** ppv)\n");    
	&writeString("{\n");
	&writeString("\t*ppv = 0;\n");    
	&writeString("\t$ABST_CLASS_FACTORY_NAME* ret = 0;\n");

	my($FACTORY_REF, $ELSE);
	foreach $FACTORY_REF (@{$MODULE_REF->{'factory'}})
	{
	    my($FACTORY_CLASS_REF) = $FACTORY_REF->{'class'};

	    my(@CLSIDS_FOR_DEFAULT_FACTORY);
	    if ($MODULE_REF->{'validation'} eq ':factory-id-validation')
	    {
		my($CLSID) = &getClsidName($FACTORY_CLASS_REF->{'name'});
		push(@CLSIDS_FOR_DEFAULT_FACTORY, $CLSID);
	    }
	    elsif ($MODULE_REF->{'validation'} eq ':creatable-id-validation' || !$MODULE_REF->{'validation'})
	    {
		@CLSIDS_FOR_DEFAULT_FACTORY = &getClassIdsForFactory($FACTORY_REF);
	    }
	    else
	    {
		die "unknown validation type: $MODULE_REF->{'validation_type'}\n";
	    }
	    
	    my(@CONDITIONS);
	    my($CLSID);
	    foreach $CLSID (@CLSIDS_FOR_DEFAULT_FACTORY)
	    {
		my($CONDITION) = 'clsid == ' . $CLSID;
		push(@CONDITIONS, $CONDITION);
	    }
	    my($CONDITION) = 'if (' . join(' || ', @CONDITIONS) . ')';
	    &writeString("\t$ELSE$CONDITION\n");
	    &writeString("\t{\n");
	    &writeString("\t\t$FACTORY_CLASS_REF->{'name'}* pClazz = new $FACTORY_CLASS_REF->{'name'}(clsid);\n");
	    &writeString("\t\tif (pClazz)\n");
	    &writeString("\t\t{\n");

	    my($PROXY_APARTMENT_VALUE) = 'proxyApartment';
	    my($THREAD_APARTMENT_VALUE) = 'threadApartment';
	    my($APARTMENT_IID) = &getApartmentIID($FACTORY_REF->{'apartment'});
	    my($FACTORY_INTERFACE_REF) = $FACTORY_REF->{'interface'};
	    my($FACTORY_INTERFACE_NAME) = $FACTORY_INTERFACE_REF->{'name'};

	    ## eek. assume first interface is factory
	    &writeString("\t\t\t*ppv = $FACTORY_CLASS_REF->{'name'}\:\:to$FACTORY_INTERFACE_NAME(pClazz);\n");
	    &writeString("\t\t\treinterpret_cast<ICEUnknown*>(*ppv)->_vtbl->_addRef(reinterpret_cast<ICEUnknown*>(*ppv));\n");

	    if ($APARTMENT_IID)
	    {
		&writeString("\t\t\tICEApartment* $PROXY_APARTMENT_VALUE = CEComGetApartment($APARTMENT_IID);\n");
		&writeString("\t\t\tCEComICEApartmentRef $THREAD_APARTMENT_VALUE = 0;\n");
		&writeString("\t\t\tCEHResult hr = CEComGetThreadContext(CEComIID_ICEApartment, reinterpret_cast<void**>(&$THREAD_APARTMENT_VALUE));\n");

		&writeString("\t\t\tif (CESucceeded(hr))\n");
		&writeString("\t\t\t{\n");
		my($FACTORY_IID) = &getIIDName($FACTORY_INTERFACE_NAME);
		&writeCreateHook(\%IDL, "\t\t\t\t", $PROXY_APARTMENT_VALUE, $THREAD_APARTMENT_VALUE, $FACTORY_IID, 'ppv', 'void', 0);
		&writeString("\t\t\t}\n");

		&writeString("\t\t\tif (CESucceeded(hr))\n");
		&writeString("\t\t\t{\n");
		&writeString("\t\t\t\tret = pClazz->object();\n");
		&writeString("\t\t\t}\n");
		&writeString("\t\t\telse\n");
		&writeString("\t\t\t{\n");
		&writeString("\t\t\t\tdelete pClazz;\n");
		&writeString("\t\t\t\tpClazz = 0;\n");
		&writeString("\t\t\t}\n");
	    }
	    else
	    {
		&writeString("\t\t\tret = pClazz->object();\n");
	    }

	    &writeString("\t\t}\n");
	    &writeString("\t}\n");
	    $ELSE = 'else ';
	}
	&writeString("\treturn ret;\n");    
	&writeString("}\n");

	## toInterface
	&writeString("\n");
	&writeString("void* ${MODULE_ENV_NAME}::toInterface($ABST_CLASS_FACTORY_NAME* pcf, UINT32 clsid, UINT32 iid)\n");
	&writeString("{\n");
	&writeString("\tvoid* ret = 0;\n");
	my($FACTORY_REF, $ELSE);
	foreach $FACTORY_REF (@{$MODULE_REF->{'factory'}})
	{
	    my($FACTORY_CLASS_REF) = $FACTORY_REF->{'class'};
	    my(@CLSIDS_FOR_DEFAULT_FACTORY);
	    if ($MODULE_REF->{'validation'} eq ':factory-id-validation')
	    {
		my($CLSID) = &getClsidName($FACTORY_CLASS_REF->{'name'});
		push(@CLSIDS_FOR_DEFAULT_FACTORY, $CLSID);
	    }
	    elsif ($MODULE_REF->{'validation'} eq ':creatable-id-validation' || !$MODULE_REF->{'validation'})
	    {
		@CLSIDS_FOR_DEFAULT_FACTORY = &getClassIdsForFactory($FACTORY_REF);
	    }
	    else
	    {
		die "unknown validation type: $MODULE_REF->{'validation_type'}\n";
	    }

	    my(@CONDITIONS);
	    my($CLSID);
	    foreach $CLSID (@CLSIDS_FOR_DEFAULT_FACTORY)
	    {
		my($CONDITION) = 'clsid == ' . $CLSID;
		push(@CONDITIONS, $CONDITION);
	    }
	    my($CONDITION) = 'if (' . join(' || ', @CONDITIONS) . ')';
	    &writeString("\t$ELSE$CONDITION\n");
	    &writeString("\t{\n");
	    &writeString("\t\t$FACTORY_CLASS_REF->{'name'}* pClazz = reinterpret_cast<$FACTORY_CLASS_REF->{'name'}*>(pcf);\n");
	    ## eek. assume first interface is factory
	    my($PROXY_APARTMENT_VALUE) = 'proxyApartment';
	    my($THREAD_APARTMENT_VALUE) = 'threadApartment';
	    my($APARTMENT_IID) = &getApartmentIID($FACTORY_REF->{'apartment'});
	    my($FACTORY_INTERFACE_REF) = $FACTORY_REF->{'interface'};
	    my($FACTORY_INTERFACE_NAME) = $FACTORY_INTERFACE_REF->{'name'};

	    &writeString("\t\tret = (void*)$FACTORY_CLASS_REF->{'name'}\:\:to$FACTORY_INTERFACE_NAME(pClazz);\n");
	    &writeString("\t\t\treinterpret_cast<ICEUnknown*>(ret)->_vtbl->_addRef(reinterpret_cast<ICEUnknown*>(ret));\n");

	    if ($APARTMENT_IID)
	    {
		&writeString("\t\tICEApartment* $PROXY_APARTMENT_VALUE = CEComGetApartment($APARTMENT_IID);\n");
		&writeString("\t\tCEComICEApartmentRef $THREAD_APARTMENT_VALUE = 0;\n");
		&writeString("\t\tCEHResult hr = CEComGetThreadContext(CEComIID_ICEApartment, reinterpret_cast<void**>(&$THREAD_APARTMENT_VALUE));\n");

		&writeString("\t\tif (CESucceeded(hr))\n");
		&writeString("\t\t{\n");
		&writeString("\t\t\tvoid** ppv = &ret;\n");
		my($FACTORY_IID) = &getIIDName($FACTORY_INTERFACE_NAME);
		&writeCreateHook(\%IDL, "\t\t\t", $PROXY_APARTMENT_VALUE, $THREAD_APARTMENT_VALUE, $FACTORY_IID, 'ppv', 'void', 0);
		&writeString("\t\t}\n");
	    }
	    &writeString("\t}\n");
	    $ELSE = 'else ';
	}
	&writeString("\treturn ret;\n");
	&writeString("}\n");

	&writeString("\t#if !defined(PLATFORM_DTT)\n");
	&writeString("CEATOMIC ${MODULE_ENV_NAME}::_count;\n");
	&writeString("\t#else\n");
	&writeString("INT32 ${MODULE_ENV_NAME}::_count;\n");
	&writeString("\t#endif\n");
    }
}

sub writeAssignment
{
    my($INDENT, $TARGET_TYPE, $TARGET_VALUE, $BUFFER_POINTER) = @_;
    &writeString("${INDENT}union { $TARGET_TYPE _$TARGET_VALUE; UINT8 _buf[sizeof($TARGET_TYPE)]; } u$TARGET_VALUE;\n");
    &writeString("${INDENT}(void)CESysCopyMemory(u$TARGET_VALUE._buf, (sizeof($TARGET_TYPE) * sizeof(UINT8)), $BUFFER_POINTER, sizeof($TARGET_TYPE));\n");
    &writeString("${INDENT}$TARGET_TYPE& $TARGET_VALUE = u$TARGET_VALUE._$TARGET_VALUE;\n");
}


########################################################################################################
### write rule file
########################################################################################################

sub writeDepMakeFileWin
{
    my($CCD_FULLPATH, $OUTDIR, $CWDIR, $RULE_FILE_OUTDIR) = @_;

    my(@ABSTARGETS);
    push(@ABSTARGETS, &getFileNameWithDir($CCD_FULLPATH, $OUTDIR, 'h'));
    push(@ABSTARGETS, &getFileNameWithDir($CCD_FULLPATH, $OUTDIR, 'cpp'));

    my(@DEPENDS);
    my($t);
    foreach $t (keys(%CCD))
    {
	push(@DEPENDS, $CCD{$t}->{'name'});
    }

    foreach $t (keys(%IDL))
    {
	push(@DEPENDS, $IDL{$t}->{'name'});
    }

    foreach $t (keys(%CPPHEADER))
    {
	push(@DEPENDS, $CPPHEADER{$t}->{'name'});
    }

    push(@DEPENDS, &getProgramName());
    &mswinutil::writeDepMakeFile($CWDIR, $RULE_FILE_OUTDIR, 
				 &getFileNameWithDir($CCD_FULLPATH, $RULE_FILE_OUTDIR, 'Pc.mak'),
				 \@ABSTARGETS, \@DEPENDS);
}

sub writeRuleFile
{
    my($CCD_FULLPATH, $OUTDIR) = @_;
    my($P_FILE) = &getFileNameWithDir($CCD_FULLPATH, $OUTDIR, 'Pc');
    if ($P_FILE)
    {
 	open(FPW, ">$P_FILE") || die("Error: Can not open file $P_FILE as output\n");
    }

    my($H_FILE) = &getFileNameWithDir($CCD_FULLPATH, $OUTDIR, 'h');
    my($CPP_FILE) = &getFileNameWithDir($CCD_FULLPATH, $OUTDIR, 'cpp');

    &writeString("$H_FILE $CPP_FILE: \\\n");

    my($CCD_FILE);
    foreach $CCD_FILE (keys(%CCD))
    {
	my($CCD_REF) = $CCD{$CCD_FILE};
	&writeString("  $CCD_REF->{'name'} \\\n");
    }

    my($IDL_FILE);
    foreach $IDL_FILE (keys(%IDL))
    {
	my($IDL_REF) = $IDL{$IDL_FILE};
	&writeString("  $IDL_REF->{'name'} \\\n");
    }

    my($CPPHEADER_FILE);
    foreach $CPPHEADER_FILE (keys(%CPPHEADER))
    {
	my($CPPHEADER_REF) = $CPPHEADER{$CPPHEADER_FILE};
	&writeString("  $CPPHEADER_REF->{'name'} \\\n");
    }

    my($PROGRAM) = &getProgramName();
    &writeString("  $PROGRAM\n");

    close(FPW);
}

sub getFileNameWithDir
{
    my($CCD_FULLPATH, $OUTDIR, $SUFFIX, $APPENDAGE) = @_;
    my($CCD_FILE) = &deletePath($CCD_FULLPATH);
    my($EXT) = 'ccd';
    if ($CCD_FILE =~ /\.csd$/)
    {
	$EXT = 'csd';
    }
    my($FILE_NAME) = &getFileName($CCD_FILE, $EXT, $SUFFIX, $APPENDAGE);
    if ($OUTDIR)
    {
	if ($OUTDIR =~ /\/$/)
	{
	    chop($OUTDIR);
	}

	$FILE_NAME = $OUTDIR . '/' . $FILE_NAME;
    }

    return $FILE_NAME;
}

sub getApartmentIID
{
    my($APARTMENT_NAME) = @_;
    my($APARTMENT_IID);
    if ($APARTMENT_NAME eq ':neutral')
    {
	$APARTMENT_IID = &getIIDName('ICENeutralApartment');
    }
    elsif ($APARTMENT_NAME eq ':singlethread')
    {
	$APARTMENT_IID = &getIIDName('ICESingleThreadApartment');
    }
    elsif ($APARTMENT_NAME eq ':singlethread')
    {
	$APARTMENT_IID = &getIIDName('ICEMultiThreadApartment');
    }
    else
    {
	## do nothing
    }
    return $APARTMENT_IID;
}

sub getCreatableClsidIidConditions
{
    my($MODULE_REF, $CLSID_VALUE, $IID_VALUE) = @_;

    my(@CONDITIONS);

    my($FACTORY_REF);
    foreach $FACTORY_REF (@{$MODULE_REF->{'factory'}})
    {
	my($CLASS_REF);
	foreach $CLASS_REF (@{$FACTORY_REF->{'creatable'}})
	{
	    my($INTERFACE_REF);
	    foreach $INTERFACE_REF (@{$CLASS_REF->{'interface'}})
	    {
		my($CLSID) = &getClsidName($CLASS_REF->{'name'});
		my($IID) = &getIIDName($INTERFACE_REF->{'name'});
		my($CONDITION) = '(' . $CLSID_VALUE . ' == ' . $CLSID . ' && ' . $IID_VALUE . ' == ' . $IID . ')';
		push(@CONDITIONS, $CONDITION);
	    }
	}
    }
    return @CONDITIONS;
}

sub getFactoryClsidIidConditions
{
    my($MODULE_REF, $CLSID_VALUE, $IID_VALUE) = @_;

    my(@CONDITIONS);

    my($FACTORY_REF);
    foreach $FACTORY_REF (@{$MODULE_REF->{'factory'}})
    {
	my($CLASS_REF) = $FACTORY_REF->{'class'};
	my($INTERFACE_REF);
	foreach $INTERFACE_REF (@{$CLASS_REF->{'interface'}})
	{
	    my($CLSID) = &getClsidName($CLASS_REF->{'name'});
	    my($IID) = &getIIDName($INTERFACE_REF->{'name'});
	    my($CONDITION) = '(' . $CLSID_VALUE . ' == ' . $CLSID . ' && ' . $IID_VALUE . ' == ' . $IID . ')';
	    push(@CONDITIONS, $CONDITION);
	}
    }
    return @CONDITIONS;
}

sub getClassIdsForFactory
{
    my($FACTORY_REF) = @_;
    my(@RETURN_ARRAY);

    my($CLASS_REF);
    foreach $CLASS_REF (@{$FACTORY_REF->{'creatable'}})
    {
	my($CLASS_ID) = getClsidName($CLASS_REF->{'name'});
	push(@RETURN_ARRAY, $CLASS_ID);
    }
    return @RETURN_ARRAY;
}

sub getImplementationClass
{
    my($INTERFACE_NAME) = @_;

    my($CCD_FILE);
    foreach $CCD_FILE (keys(%CCD))
    {
	my($CLASSES_REF) = $CCD{$CCD_FILE}->{'class'};
	my($CLASS_REF);
	foreach $CLASS_REF (@$CLASSES_REF)
	{
	    my($INTERFACES_REF) = $CLASS_REF->{'interface'};
	    my($INTERFACE_REF);
	    foreach $INTERFACE_REF (@{$INTERFACES_REF})
	    {
		if ($INTERFACE_REF->{'name'} eq $INTERFACE_NAME)
		{
		    return $CLASS_REF;
		}
	    }
	}
    }
    return 0;
}

sub getAbstractClassFactoryName
{
    my($MODULE_NAME) = @_;
    if (!$MODULE_NAME)
    {
	my($PKG0, $FILE0, $LINE0, $SUBROUTINE0) = caller(0);
	my($PKG1, $FILE1, $LINE1, $SUBROUTINE1) = caller(1);
	my($DEBUG_INFO) = ' <=== ' . $SUBROUTINE1 . ' at ' . $FILE0 . ':' . $LINE0 . ' in ' . $PKG0;
	die "module name should be specified $DEBUG_INFO\n\n";
    }
    return $MODULE_NAME . 'AbstractClassFactoryImpl';
}

########################################################################################################
### write fnd trans file
########################################################################################################
sub hasFndTransOption
{
    my($CCD_FULLPATH, $OUTDIR) = @_;
    my($HAS_FND_TRANS) = 0;
    my($CCD_FILE)      = &deletePath($CCD_FULLPATH);
    my($CLASSES_REF)   = $CCD{$CCD_FILE}->{'class'};
    my($CLASS_REF);
    foreach $CLASS_REF (@$CLASSES_REF)
    {
	if ($CLASS_REF->{'fnd-trans'})
	{
	    $HAS_FND_TRANS = 1;
	}
    }
    return $HAS_FND_TRANS;
}

sub isFndNecessary
{
    my($INTERFACE_NAME) = @_;
    my($FND_INTERFACE_NAME) = &replaceInterfacePrefixForPublic($INTERFACE_NAME);

    my($RESULT) = 0;
    if ($FND_TRANS_FLAG && $FND_INTERFACE_NAME ne $INTERFACE_NAME)
    {
	$RESULT = 1;
    }
    return $RESULT;
}
