///////////////////////////////////////////////////////////////////////////////
// Copyright 2009 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#include "WebKitSilkPrefix.h"

#include "CEJSPrivilegeExtObjectDeclaration.h"
#include "CEJSPrivilegeExtObjectDeclarationGlue.h"
#include "ICEHtmlBrowserManager.h"
#include "CEJSExternal.h"

//////////////////////////////////////////////////////////////////////////////
// CEJSPrivilegeExtObjectDeclaration
//////////////////////////////////////////////////////////////////////////////

CEHResult CEJSPrivilegeExtObjectDeclaration::create(
	JSC::ExecState* exec, JSExternal* external, CEJSPrivilegeExtObjectDeclaration*& rDeclarationOut)
{
	CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
	rDeclarationOut = new CEJSPrivilegeExtObjectDeclarationGlue();
	if (rDeclarationOut)
	{
		hr = rDeclarationOut->_init(exec, external);
		if (CEFailed(hr))
		{
			delete rDeclarationOut;
			rDeclarationOut = 0;
		}
	}
	else
	{
		hr = CE_SILK_ERR_MEMERR;
	}
	return hr;
}

CEJSPrivilegeExtObjectDeclaration::~CEJSPrivilegeExtObjectDeclaration()
{
    if (_isShutdownCompleted == false)
    {
        shutdown();
    }
}

CEHResult CEJSPrivilegeExtObjectDeclaration::_init(JSC::ExecState* exec, JSExternal* external)
{
	CEHResult hr = _declaredObjectHash.init(CEComGetAllocatorRec(), 8);
	if (CESucceeded(hr))
	{
		_isShutdownCompleted = false;
		_external = external;
		hr = CEJSExternalAppCallback::declarePrivilegeExtObj(exec, CEJSPrivilegeExtObjectDeclarationGlue::toICEJSPrivilegeExtObjectDeclarer(this));
	}
	return hr;
}

CEHResult CEJSPrivilegeExtObjectDeclaration::shutdown()
{
	CEASSERT(_isShutdownCompleted == false);
	CEHResult hr = CE_S_OK;
	CEUHashtableT<DeclaredObjectEntry, DeclaredObjectKey>::Iterator iter(_declaredObjectHash);
	DeclaredObjectEntry* pEntry;
	while ((pEntry = iter.nextElement()))
	{
		delete pEntry;
	}
	_declaredObjectHash.shutdown();
	_isShutdownCompleted = true;
	return hr;
}

////////////////////////////////
// operations 
////////////////////////////////
CEHResult CEJSPrivilegeExtObjectDeclaration::isDeclared(const JSC::Identifier& iPropName, INT32* classIdOut, UINT32* attrOut)
{
	CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
	DeclaredObjectKey key(iPropName);
	DeclaredObjectEntry* pEntry = NULL;
	if (_declaredObjectHash.find(key, pEntry))
	{
		hr = CE_S_OK;
		*classIdOut = pEntry->getClassId();
		*attrOut = pEntry->getAttr();
	}
    return hr;
}

////////////////////////////////////////////
//  ICEJSPrivilegeExtObjectDeclarer methods
////////////////////////////////////////////
CEHResult CEJSPrivilegeExtObjectDeclaration::declareObject(
	INT32 classId, const UTF16CHAR* pObjectName, UINT32 numOfChars16, UINT32 attr)
{
	CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
	if (pObjectName && numOfChars16 > 0 && _external)
	{
		JSC::ExecState* exec = _external->getDOMWindow()->globalExec();

		JSC::Identifier symbol(exec, reinterpret_cast<const UChar*>(pObjectName), numOfChars16);
		if( !symbol.isEmpty() )
		{
			DeclaredObjectKey key(symbol);
			DeclaredObjectEntry* pEntry = NULL;
			if (!_declaredObjectHash.find(key, pEntry))
			{
				pEntry = new DeclaredObjectEntry(symbol, classId, attr);
				if (pEntry)
				{
					hr = _declaredObjectHash.insert(pEntry);
				}
				else
				{
					hr = CE_SILK_ERR_MEMERR;
				}
			}
			else
			{
				hr = CE_SILK_ERR_OPERATION_FAILED;
			}
		}
	}
	return hr;
}
