///////////////////////////////////////////////////////////////////////////////
// Copyright 2009 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#ifndef __CEHtmlCredential_H__
#define __CEHtmlCredential_H__

#include "CESysDefs.h"
#include "ICEHtmlCredential.h"
#include "PlatformString.h"
#include "CEComAtomicSupport.h"
#include "../FrameLoaderClientSilk.h"

class CEWebKitDocumentLoader;
class JSExternal;
class CEHtmlCredential
{
public:
	////////////////////////////////////////////////////////////////
	// operator new, delete, new[] and delete[].
	////////////////////////////////////////////////////////////////
	CEALLOCATORS;

	////////////////////////////////
	//  constructor / destructor
	////////////////////////////////
private:
	CEHtmlCredential();

public:
	CEHtmlCredential(JSExternal* owner) :
		 _owner(owner),_isShutdownCompleted(false)
	{
		CEASSERT(_owner);
		_refCount = 0;
	}
	virtual ~CEHtmlCredential()
	{
		if (!_isShutdownCompleted) shutdown();
		CEASSERT(_refCount == 0);
	}

public:
	void AddRef()
	{
		CEComAtomicIncrement(_refCount);
	}

	void Release()
	{
		CEATOMIC refCount = CEComAtomicDecrement(_refCount);
		if (refCount == 0)
		{
			delete this;
		}
	}
private:
	CEATOMIC _refCount;

	/////////////////////////////////
	// initialize / shutdown
	/////////////////////////////////
	CEHResult shutdown() { _isShutdownCompleted = true; return CE_S_OK; }

	CEWebKitDocumentLoader* _getDocumentLoader();
	FrameLoaderClientSilk* _getFrameLoaderClient();


	////////////////////////////////
	//  ICEJSVariant methods
	////////////////////////////////
public:
	CEHResult getSSLMode(CEHtmlSSLMode* modeOut);
	CEHResult getSSLAlert(UINT32* alertOut);
	CEHResult getDomain(const UTF16CHAR **const pCharArray16Out, UINT32 *const numOfChars16Out);
	CEHResult getCertificate(const void** cert);

	////////////////////////////////
	//  data members
	////////////////////////////////
private:
	JSExternal* _owner;
	WebCore::String _hostname;
	bool _isShutdownCompleted : 1;
};

#endif // __CEHtmlCredential_H__
