///////////////////////////////////////////////////////////////////////////////
// Copyright 2009 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#include "WebKitSilkPrefix.h"
#include "CEHtmlCredential.h"
#include "CEJSExternal.h"

#include "JSDOMWindow.h"
#include "DOMWindow.h"
#include "Location.h"
#include "Frame.h"
#include "FrameLoader.h"
#include "ResourceResponse.h"
#include "CEWebKitDocumentLoader.h"


CEHResult CEHtmlCredential::getSSLMode(CEHtmlSSLMode* modeOut)
{
	CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
	if (!_isShutdownCompleted)
	{
		CEWebKitDocumentLoader* documentLoader = _getDocumentLoader();
		if (documentLoader && documentLoader->getDocumentLoaderClient())
		{
			WebCore::FrameLoader* frameLoader = documentLoader->frameLoader();
			if (documentLoader->isLoading() && frameLoader && frameLoader->isLoadingMainResource())
			{
				*modeOut = CEHtmlSSLMode_Loading;
				hr = CE_S_OK;
            }
			else
			{
				hr = documentLoader->getDocumentLoaderClient().getSSLMode(modeOut);
			}
		}
	}
	return hr;
}

CEHResult CEHtmlCredential::getSSLAlert(UINT32* alertOut)
{
	CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
	if (!_isShutdownCompleted)
	{
		CEWebKitDocumentLoader* documentLoader = _getDocumentLoader();
		if (documentLoader && documentLoader->getDocumentLoaderClient())
		{
			hr = documentLoader->getDocumentLoaderClient().getSSLAlert(alertOut);
		}
	}
	return hr;
}

CEHResult CEHtmlCredential::getDomain(const UTF16CHAR **const pCharArray16Out, UINT32 *const numOfChars16Out)
{
	CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
	if (!_isShutdownCompleted)
	{
		CEASSERT(_owner);
		if( _owner && _owner->getDOMWindow() )
		{
			WebCore::DOMWindow* domWindow = _owner->getDOMWindow()->impl();
			CEASSERT(domWindow && !domWindow->closed());
			if( domWindow && !domWindow->closed() )
			{
				WebCore::Location* location = domWindow->location();
				_hostname = location->hostname();
				*pCharArray16Out = _hostname.charactersSilk();
				*numOfChars16Out = static_cast<UINT32>(_hostname.length());
				hr = CE_S_OK;
			}
		}
	}
	return hr;
}

CEHResult CEHtmlCredential::getCertificate(const void** cert)
{
	CEHResult hr = CE_SILK_ERR_NOTIMPLEMENTED;
#if CE_OS(HYDRA) || CE_OS(XAI)
	if (!_isShutdownCompleted)
	{
		FrameLoaderClientSilk* client = _getFrameLoaderClient();
		if (client)
		{
			hr = client->getCertificate(cert);
		}
	}
#endif
	return hr;
}

FrameLoaderClientSilk* CEHtmlCredential::_getFrameLoaderClient()
{
	WebCore::FrameLoaderClient* frameloaderClient = NULL;
	if (_owner && _owner->getDOMWindow() && _owner->getDOMWindow()->impl())
	{
		WebCore::Frame* frame = _owner->getDOMWindow()->impl()->frame();
		if (frame && frame->loader())
		{
			frameloaderClient = frame->loader()->client();
		}
	}
	return static_cast<FrameLoaderClientSilk*>(frameloaderClient);
}

CEWebKitDocumentLoader* CEHtmlCredential::_getDocumentLoader()
{
	WebCore::DocumentLoader* documentLoader = NULL;
	if (_owner && _owner->getDOMWindow() && _owner->getDOMWindow()->impl())
	{
		WebCore::Frame* frame = _owner->getDOMWindow()->impl()->frame();
		if (frame && frame->loader() && frame->loader()->documentLoader())
		{
			documentLoader = frame->loader()->documentLoader();
		}
	}
	return static_cast<CEWebKitDocumentLoader*>(documentLoader);
}
