///////////////////////////////////////////////////////////////////////////////
// Copyright 2009,2010 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////

#include "WebKitSilkPrefix.h"
#include "CEWebKitSettingsImpl.h"
#include "CEWebKitImpl.h"

CEWebKitSettingsImpl::CEWebKitSettingsImpl(WebCore::Settings* settings)
	: _settings(settings)
    , bCEA2014Mode(false)
{
}

CEHResult CEWebKitSettingsImpl::setJavaScriptEnabled(bool enabled)
{
	_settings->setJavaScriptEnabled(enabled);
	return CE_S_OK;
}

CEHResult CEWebKitSettingsImpl::isJavaScriptEnabled(bool* enabledOut)
{
	*enabledOut = _settings->isJavaScriptEnabled();
	return CE_S_OK;
}

CEHResult CEWebKitSettingsImpl::userStyleSheetLocation(ICEURL** locationOut)
{
    const WebCore::KURL& kurl = _settings->userStyleSheetLocation();
    CEHResult err = kurl.createICEURL(locationOut);
    return err;
}

CEHResult CEWebKitSettingsImpl::setUserStyleSheetLocation(ICEURL* location)
{
    WebCore::KURL kurl;
    CEHResult err;
    err = WebCore::KURL::fromICEURL(kurl, location);
    if (!err)
    {
        _settings->setUserStyleSheetLocation(kurl);
    }
    return err;
}

CEHResult CEWebKitSettingsImpl::setCEA2014ModeEnabled(bool enabled)
{
    bCEA2014Mode = enabled;
    return CE_S_OK;
}

CEHResult CEWebKitSettingsImpl::isCEA2014ModeEnabled(bool* enabledOut)
{
    *enabledOut = bCEA2014Mode;
    return CE_S_OK;
}

CEHResult CEWebKitSettingsImpl::setDefaultFontSize(UINT32 size)
{
	_settings->setDefaultFontSize(size);
	return CE_S_OK;
}

CEHResult CEWebKitSettingsImpl::setDefaultFixedFontSize(UINT32 size)
{
	_settings->setDefaultFixedFontSize(size);
	return CE_S_OK;
}

CEHResult CEWebKitSettingsImpl::setAcceleratedCompositingEnabled(bool enabled)
{
#if USE(ACCELERATED_COMPOSITING)
	_settings->setAcceleratedCompositingEnabled(enabled);
#else //#if USE(ACCELERATED_COMPOSITING)
	_settings->setAcceleratedCompositingEnabled(false);
#endif //#if USE(ACCELERATED_COMPOSITING)
	return CE_S_OK;
}

CEHResult CEWebKitSettingsImpl::acceleratedCompositingEnabled(bool* enabledOut)
{
	*enabledOut = _settings->acceleratedCompositingEnabled();
	return CE_S_OK;
}

CEHResult CEWebKitSettingsImpl::setPluginEnabled(bool enabled)
{
	CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
	if(_settings)
	{
		if(_settings->arePluginsEnabled()!=enabled)
		{
			_settings->setPluginsEnabled(enabled);
		}
		if(enabled==true)
		{
			CEWebKitImpl* webKitImpl = CEWebKitImpl::getInstance();
			if(webKitImpl)
			{
				hr = webKitImpl->preparePluginInfo();
			}
		}
		else
		{
			hr = CE_S_OK;
		}
	}
	return hr;
}

