/*
 * Copyright (C) 2006 Apple Computer, Inc.  All rights reserved.
 * Copyright     2009 Sony Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef ResourceResponse_h
#define ResourceResponse_h

#include "ResourceResponseBase.h"

namespace WebCore {

class ResourceHandleInternal;
class ResourceResponse : public ResourceResponseBase {
public:
	ResourceResponse()
		: m_responseFired(false)
		, m_noContext(false)
		, m_redirected(false)
		, m_isSecure(false)
		, m_sslError(0) {
	}

	ResourceResponse(const KURL& url, const String& mimeType, long long expectedLength, const String& textEncodingName, const String& filename)
		: ResourceResponseBase(url, mimeType, expectedLength, textEncodingName, filename),
		  m_responseFired(false), m_redirected(false), m_internalData(NULL)
		, m_isSecure(false)
		, m_sslError(0) {
	}

	void setResponseFired(bool fired) { m_responseFired = fired; }
	bool responseFired() const { return m_responseFired; }

	void setNoContext(bool noContext) { m_noContext = noContext; }
	bool noContext() const { return m_noContext; }

	void setInternalData(ICEUnknown* internalData) { m_internalData = internalData; }
	ICEUnknown* getInternalData()const { return m_internalData; }

	void setRedirected(bool isRedirected) { m_redirected = isRedirected; m_isNull = !isRedirected; }

	void setSecureStatus(bool isSecure, UINT32 sslError) { m_isSecure = isSecure; m_sslError = sslError; }
	bool isSecure() const{ return m_isSecure; }
	UINT32 sslError() const{ return m_sslError; }
private:
	bool m_responseFired;
	bool m_noContext;
	bool m_redirected;
	bool m_isSecure;
	UINT32 m_sslError;
	CEComICEUnknownRef m_internalData;
};

} // namespace WebCore

#endif // ResourceResponse_h
