/*
 * Copyright (C) 2004, 2006 Apple Computer, Inc.  All rights reserved.
 * Copyright (C) 2005, 2006 Michael Emmel mike.emmel@gmail.com
 * All rights reserved.
 * Copyright     2011 Sony Corporation
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#if defined(USE_XAI)
#include "config.h"
#include "DNS.h"

#include "ResourceHandle.h"

#include "DocLoader.h"
#include "NotImplemented.h"
#include "ResourceHandleInternal.h"
#include "ResourceHandleManagerCore.h"

namespace WebCore {

WebCoreSynchronousLoader::WebCoreSynchronousLoader(ICEHtmlWebKitFrameWindowChromeClient* chromeclient) :
	m_chromeclient(chromeclient)
{
}

void WebCoreSynchronousLoader::didReceiveResponse(ResourceHandle* webCoreJob, const char* responseHeaderBuffer, UINT32 responseHeaderLen, const char* url, UINT32 httpCode, UINT32 expectedContentLength, bool noContext)
{
	ResourceHandleManager::_handleHeaderCallbackInternal(webCoreJob, responseHeaderBuffer, responseHeaderLen, url, httpCode, expectedContentLength, m_response);
}

void WebCoreSynchronousLoader::didReceiveData(ResourceHandle* webCoreJob, void* data, UINT32 size)
{
    m_data.append(reinterpret_cast<char*>(data), size);
}

void WebCoreSynchronousLoader::didFinishLoading(ResourceHandle* webCoreJob)
{
}

void WebCoreSynchronousLoader::didFail(ResourceHandle* webCoreJob)
{
}


static HashSet<String>& allowsAnyHTTPSCertificateHosts()
{
    static HashSet<String> hosts;

    return hosts;
}

ResourceHandleInternal::~ResourceHandleInternal()
{
	if (m_url)
	{
		free(m_url);
		m_url = NULL;
	}
}

ResourceHandle::~ResourceHandle()
{
    cancel();
}

bool ResourceHandle::start(Frame* frame)
{
    ASSERT(frame);
    ResourceHandleManager::sharedInstance()->add(this);
    return true;
}

void ResourceHandle::cancel()
{
    ResourceHandleManager::sharedInstance()->cancel(this);
}

PassRefPtr<SharedBuffer> ResourceHandle::bufferedData()
{
    return 0;
}

bool ResourceHandle::supportsBufferedData()
{
    return false;
}

void ResourceHandle::setDefersLoading(bool defers)
{
    if (d->m_defersLoading == defers)
        return;
}

bool ResourceHandle::willLoadFromCache(ResourceRequest&)
{

    notImplemented();
    return false;
}

bool ResourceHandle::loadsBlocked()
{
    notImplemented();
    return false;
}

void ResourceHandle::loadResourceSynchronously(const ResourceRequest& request, StoredCredentials storedCredentials, ResourceError& error, ResourceResponse& response, Vector<char>& data, Frame* frame)
{
	CEWebKitFrameWindowImpl* frameWindow = NULL;
	CEComICEHtmlWebKitFrameWindowChromeClientRef chromeclient = NULL;
	CEComICENetworkEventListenerRef networkListener = NULL;

	if (frame && frame->page())
	{
		frameWindow = kit(frame->page());
	}
	if (frameWindow)
		chromeclient = frameWindow->getChromeClient();

	CEHResult hr = networkListener.initByQueryInterface(chromeclient);

	if (CESucceeded(hr))
	{
		WebCoreSynchronousLoader syncLoader(networkListener);

		ResourceHandle handle(request, &syncLoader, true, false, true);

		ResourceHandleManager* manager = ResourceHandleManager::sharedInstance();

		manager->dispatchSynchronousJob(&handle);

		error = syncLoader.resourceError();
		data = syncLoader.data();
		response = syncLoader.resourceResponse();
	}
}

} // namespace WebCore
#endif // #if USE(XAI)
