/*
 * Copyright (C) 2006, 2007, 2008 Apple Inc.  All rights reserved.
 * Copyright     2008, 2009 Sony Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer. 
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 * 3.  Neither the name of Apple Computer, Inc. ("Apple") nor the names of
 *     its contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"

#if USE(SILK_CEUIFONT)
#include "SimpleFontData.h"
#include "Font.h"
#include "FontCache.h"
#include "FloatRect.h"
#include "FontDescription.h"
#include "PlatformString.h"
#include <wtf/MathExtras.h>
#include <unicode/uchar.h>
#include <unicode/unorm.h>

#include "ICEPFRasterizer.h"

namespace WebCore {
void SimpleFontData::platformInit()
{
	CEComICEUIPlatformFontRef pffont = platformData().pfFont();
	CEPFFaceInfo faceInfo;
	pffont.getFaceInfo(&faceInfo);
	m_unitsPerEm = faceInfo.unitsPerEm;  // TODO: required? like this low level info...

	// TODO: get the following informations from FT.
	INT32 v = 0;
	pffont.getValue(CEUIFontValueType_Ascent, &v);
	m_ascent = (int)v;
	pffont.getValue(CEUIFontValueType_Descent, &v);
	m_descent = (int)v;
	pffont.getValue(CEUIFontValueType_FontHeight, &v);
	m_lineGap = v - (m_ascent + m_descent);
	m_lineSpacing = v;
	pffont.getValue(CEUIFontValueType_xHeight, &v);
	m_xHeight = v;
}

void SimpleFontData::platformDestroy()
{
	if (m_smallCapsFontData)
		delete m_smallCapsFontData;
	m_smallCapsFontData = 0;
}

float SimpleFontData::platformWidthForGlyph(Glyph glyph) const
{
	float ret = 0;
	CEComICEUIPlatformFontRef pf = platformData().pfFont();
	if (pf) {
		INT32 w = 0;
		pf.getGlyphWidth(glyph, &w);
		ret = w;
	}
	else
	{
		//CEASSERT(0 && "fix this error");
	}
	return ret;
}


} //namespace

#else //#if !USE(SILK_CEUIFONT)
bad config.
#endif //#if !USE(SILK_CEUIFONT)
