/*
 * Copyright (C) 2006, 2007, 2008 Apple Computer, Inc.  All rights reserved.
 * Copyright (C) 2008 Eric Seidel <eric@webkit.org>
 * Copyright     2009 Sony Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */

#include "config.h"
#include "Pattern.h"

#include "TransformationMatrix.h"
#include "GraphicsContext.h"
#include "GraphicsContextPlatformPrivateSilk.h"
#include "ICEVG.h"
#include "CEImageBufferGraphicsContextImpl.h"

namespace WebCore {

ICEVGPattern* Pattern::createPlatformPattern(const TransformationMatrix& patternTransform) const
{
	CEComICEVGSurfaceRef vgSurface = tileImage()->nativeImageForCurrentFrame();

	if (!vgSurface.object())
		return 0;

	//get pixel-format & dimension.
	INT32 orgWidth = 0;
	INT32 orgHeight = 0;
	
	CEDim dim;
	CEHResult err = vgSurface.getDimension(&dim);
	if(!err)
	{
		orgWidth = dim._width;
		orgHeight = dim._height;
	}
	
	CEComICEVGFactoryRef vgFactory = GraphicsContextPlatformPrivate::Env::getVGFactory();
	CEComICEVGPatternRef pattern;
	vgFactory.createPattern(vgSurface, &pattern);

	// TODO: how to fix _requestRepaintOnDecodeEnd(m_source.getWebkitImage(), this) fake. ;-p

	// cairo merges pattern space and user space itself
	CEDXMatrix2DAffineD matrix = GraphicsContextPlatformPrivate::initCEDXMatrix2DAffineD(m_patternSpaceTransformation);
	vgFactory.invertMatrix2DAffine(&matrix);
	pattern.setMatrix2DAffine(&matrix);

	if (m_repeatX || m_repeatY)
		pattern.setExtend(eCEVGExtend_REPEAT);

	// returned pointer is addRef()ed already.
	// use attach() to set this value to reference variable.
	return pattern.detach();
}

}
