/*
 * Copyright (C) 2006, 2007, 2008 Apple Computer, Inc.  All rights reserved.
 * Copyright (C) 2007 Alp Toker <alp@atoker.com>
 * Copyright     2009 Sony Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */

#include "config.h"
#include "Gradient.h"
#include "GraphicsContext.h"
#include "GraphicsContextPlatformPrivateSilk.h"
#include "ICEVG.h"


namespace WebCore {

void Gradient::platformDestroy()
{
	if (m_gradient) {
		m_gradient->_vtbl->_release(m_gradient);
		m_gradient = 0;
	}
}

PlatformGradient Gradient::platformGradient()
{
	if (m_gradient)
		return m_gradient;

	CEComICEVGFactoryRef vgFactory = GraphicsContextPlatformPrivate::Env::getVGFactory();
	CEComICEVGPatternRef pattern;
	if (m_radial)
		vgFactory.createRadialPatternF(m_p0.x(), m_p0.y(), m_r0, m_p1.x(), m_p1.y(), m_r1, &pattern);
	else
		vgFactory.createLinearPatternF(m_p0.x(), m_p0.y(), m_p1.x(), m_p1.y(), &pattern);

	pattern.copyTo(&m_gradient);

	Vector<ColorStop>::iterator stopIterator = m_stops.begin();
	while (stopIterator != m_stops.end()) {
		pattern.addColorStopRGBAF(stopIterator->stop, stopIterator->red, stopIterator->green, stopIterator->blue, stopIterator->alpha);
		++stopIterator;
	}

	eCEVGExtend extend = eCEVGExtend_NONE;
	switch (m_spreadMethod) {
	case SpreadMethodPad:
		extend = eCEVGExtend_PAD;
		break;
	case SpreadMethodReflect:
		extend = eCEVGExtend_REFLECT;
		break;
	case SpreadMethodRepeat:
		extend = eCEVGExtend_REPEAT;
		break;
	}
	pattern.setExtend(extend);

	CEDXMatrix2DAffineD matrix = GraphicsContextPlatformPrivate::initCEDXMatrix2DAffineD(m_gradientSpaceTransformation);
	vgFactory.invertMatrix2DAffine(&matrix);
	pattern.setMatrix2DAffine(&matrix);

	return m_gradient;
}

void Gradient::fill(GraphicsContext* context, const FloatRect& rect)
{
	CEComICEVGContextRef vgc = context->platformContext();
	context->save();
	vgc.setSourcePattern(platformGradient());
	vgc.addRectangleF(rect.x(), rect.y(), rect.width(), rect.height());
	vgc.fill();
	context->restore();
}

} //namespace
