/*
 * Copyright (C) 2007, 2008 Apple Inc. All rights reserved.
 * Copyright 2008, 2009 Sony Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 */

#include "config.h"
#include "FontCustomPlatformData.h"

#if USE(SILK_CEUI_CUSTOM_FONT)
#include "SharedBuffer.h"
#include "ICETextSupport.h"
#include "ICEPFRasterizer.h"

namespace WebCore {
FontCustomPlatformData::~FontCustomPlatformData()
{
	if (m_pfface)
	{
		CEUIFontSupport::getCFFactory().unregisterCustomPlatformFontFace(m_name, m_pfface);
		m_pfface = 0;
	}
	m_name = 0;
}

FontPlatformData FontCustomPlatformData::fontPlatformData(int size, bool bold, bool italic, FontRenderingMode renderingMode)
{
	CEComICEI18nLocaleRef lang;
	CEUIFontSupport::getCFLang(lang);

	CEPFFontStyle style = CEPFFONTSTYLE_REGULAR;
	style.weightClass = (bold ? eCEPFFontStyleWeightClass_SemiBold : eCEPFFontStyleWeightClass_Normal);
	style.eCEPFFontStyleBits = italic ? (style.eCEPFFontStyleBits | eCEPFFontStyle_Italic) : style.eCEPFFontStyleBits;

	CEComICEUIPlatformFontRef pffont;
	CEHResult hr = CEUIFontSupport::getCFFactory().createPlatformFontBySizeInPixels(m_name, &style, size, &pffont);
	CEU_UNUSED(hr);
	return FontPlatformData(pffont, size, bold, italic);
}

FontCustomPlatformData* createFontCustomPlatformData(SharedBuffer* buffer)
{
	FontCustomPlatformData* ret = 0;
	static int seqid=0;
	CEComICEUStringRef str;
	ICEUStringCreateEmptyString(CEComStdClassID_CEUString, str);
	CEComISPrintf(str, "%d:cepf:memfont", seqid++);
	CEComICEUIFontFamilyRef family;
	CEUIFontSupport::toCEUIFontFamily(str, family);
	CEComICEPFFaceRef iface;
	CEHResult hr = CEUIFontSupport::getCFFactory().registerCustomPlatformFontFace((const UINT8*)buffer->data(), buffer->size(), family, &iface);
	if (CESucceeded(hr)) {
		ret = new FontCustomPlatformData(iface, family);
	}
	return ret;
}


} // namespace.

#else //#if USE(SILK_CEUI_CUSTOM_FONT)
#if USE(SILK_CEUIFONT)
#else //#if USE(SILK_CEUIFONT)
bad config.
#endif //#if USE(SILK_CEUIFONT)
#endif //#if USE(SILK_CEUI_CUSTOM_FONT)
