///////////////////////////////////////////////////////////////////////////////
// Copyright 2010 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#include "config.h"
#include "CEGLayerCallback.h"

#if USE(ACCELERATED_COMPOSITING)
#include "RenderLayerBacking.h"

using namespace WebCore;
CEHResult CEGLayerCallbackImpl::render(ICEVGContext* ivgc)
{
	GraphicsLayerSilk* gLayerSilk = _glayerSilk;
	ASSERT(gLayerSilk);
	CEU_ENSURE_PTR1(gLayerSilk, CE_SILK_ERR_BADSTATE);

	CEComICEVGContextRef vgc(ivgc);
	vgc.save();
	{		
		FloatRect layoutBounds(gLayerSilk->position(), gLayerSilk->size());
		if (gLayerSilk->client())
		{
			GraphicsContext gc(ivgc);
			FloatRect clipBounds;
			{
				float f[4];
				vgc.getClipExtents(&(f[0]), &(f[1]), &(f[2]), &(f[3]));
				clipBounds.setX(f[0]);
				clipBounds.setY(f[1]);
				clipBounds.setWidth(f[2]);
				clipBounds.setHeight(f[3]);
			}
			IntRect clip(enclosingIntRect(clipBounds));
			{
				if (!static_cast<RenderLayerBacking*>(gLayerSilk->client())->paintingGoesToWindow())
					gLayerSilk->paintGraphicsLayerContents(gc, clip);
			}
		}
	}
	vgc.restore();
	return CE_S_OK;
}

CEHResult CEGLayerCallbackImpl::syncChildren()
{
	if (_glayerSilk)
		_glayerSilk->_syncChildren();
	return CE_S_OK;
}

#else //#if USE(ACCELERATED_COMPOSITING)
CEHResult CEGLayerCallbackImpl::render(ICEVGContext* iVgc)
{
	return CE_S_OK;
}

CEHResult CEGLayerCallbackImpl::syncChildren()
{
	return CE_S_OK;
}

#endif //#if USE(ACCELERATED_COMPOSITING)
