///////////////////////////////////////////////////////////////////////////////
// Copyright 2004,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////
#ifndef __CEUSync_H__
#define __CEUSync_H__

// Maybe this will only temporarily be exposed ...

#include "CESysDefs.h"


typedef void* CEULockRef;
typedef void* CEUSemaphoreRef;



typedef CEHResult(*_ceulock_create)(CEULockRef*);
typedef CEHResult(*_ceulock_func)(CEULockRef);
typedef CEHResult(*_ceusemaphore_create)(CEUSemaphoreRef*, INT32);
typedef CEHResult(*_ceusemaphore_func)(CEUSemaphoreRef);

typedef struct _CEUSyncInterface
{
	_ceulock_create      lock_create;
	_ceulock_func        lock_destroy;
	_ceulock_func        lock_acquire;
	_ceulock_func        lock_release;
	_ceusemaphore_create sema_create;
	_ceusemaphore_func   sema_destroy;
	_ceusemaphore_func   sema_post;
	_ceusemaphore_func   sema_wait;
}CEUSyncInterface;

#define INFINITE_TIMEOUT 0xffffffff

#ifdef __cplusplus
extern "C"
{
#endif


CE_DLL_EXPORT
CEHResult CEULock_create(CEULockRef* outLock);

CE_DLL_EXPORT
CEHResult CEULock_destroy(CEULockRef lock);

CE_DLL_EXPORT
CEHResult CEULock_acquire(CEULockRef lock);

CE_DLL_EXPORT
CEHResult CEULock_tryToAcquire(CEULockRef lock);

CE_DLL_EXPORT
CEHResult CEULock_release(CEULockRef lock);

CE_DLL_EXPORT
CEHResult CEUSemaphore_create(CEUSemaphoreRef* outSema, INT32 initialValue);

CE_DLL_EXPORT
CEHResult CEUSemaphore_destroy(CEUSemaphoreRef sema);

CE_DLL_EXPORT
CEHResult CEUSemaphore_post(CEUSemaphoreRef sema);

CE_DLL_EXPORT
CEHResult CEUSemaphore_wait(CEUSemaphoreRef sema, UINT32 timeoutMilliSeconds);

#ifdef __cplusplus
}
#endif

#endif
