///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEJSPrivilegeExtObjectDeclarer_h
#define ICEJSPrivilegeExtObjectDeclarer_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
	CEJSPrivilegeExtObjectAttr_None = 0,
	CEJSPrivilegeExtObjectAttr_ReadOnly = 1<<0
} CEJSPrivilegeExtObjectAttr;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEJSPrivilegeExtObjectDeclarer ICEJSPrivilegeExtObjectDeclarer
 * @{
 */

/*!
 * ID of ICEJSPrivilegeExtObjectDeclarer
 */
#define CEComIID_ICEJSPrivilegeExtObjectDeclarer 0xe69842b3


/*!
 * ICEJSPrivilegeExtObjectDeclarer
 */
typedef struct ICEJSPrivilegeExtObjectDeclarer
{
	const struct ICEJSPrivilegeExtObjectDeclarer_vtbl* _vtbl;
} ICEJSPrivilegeExtObjectDeclarer;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iJSPrivilegeExtObjectDeclarer	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEJSPrivilegeExtObjectDeclarer_queryInterface) (ICEJSPrivilegeExtObjectDeclarer* iJSPrivilegeExtObjectDeclarer, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSPrivilegeExtObjectDeclarer_addRef) (ICEJSPrivilegeExtObjectDeclarer* iJSPrivilegeExtObjectDeclarer);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSPrivilegeExtObjectDeclarer_release) (ICEJSPrivilegeExtObjectDeclarer* iJSPrivilegeExtObjectDeclarer);

typedef CEHResult (*iCEJSPrivilegeExtObjectDeclarer_declareObject) (ICEJSPrivilegeExtObjectDeclarer* iJSPrivilegeExtObjectDeclarer, INT32 classId, const UTF16CHAR* pObjectName, UINT32 numOfChars16, UINT32 attr);

/*!
 * V-table of ICEJSPrivilegeExtObjectDeclarer
 */
struct ICEJSPrivilegeExtObjectDeclarer_vtbl
{
	iCEJSPrivilegeExtObjectDeclarer_queryInterface	_queryInterface;	//!< Query interface.
	iCEJSPrivilegeExtObjectDeclarer_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEJSPrivilegeExtObjectDeclarer_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEJSPrivilegeExtObjectDeclarer_declareObject	_declareObject;
};

/*! @}
 * end of ICEJSPrivilegeExtObjectDeclarer
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEJSPrivilegeExtObjectDeclarerRef CEComICEJSPrivilegeExtObjectDeclarerRef
 * @{
 */

class CEComICEJSPrivilegeExtObjectDeclarerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEJSPrivilegeExtObjectDeclarerRef() : _iJSPrivilegeExtObjectDeclarer(0) {}
	CEComICEJSPrivilegeExtObjectDeclarerRef(ICEJSPrivilegeExtObjectDeclarer* iOther) : _iJSPrivilegeExtObjectDeclarer(0)
	{
		if (iOther)
		{
			_iJSPrivilegeExtObjectDeclarer = iOther;
			_iJSPrivilegeExtObjectDeclarer->_vtbl->_addRef(_iJSPrivilegeExtObjectDeclarer);
		}
	}

	CEComICEJSPrivilegeExtObjectDeclarerRef(const CEComICEJSPrivilegeExtObjectDeclarerRef& other) : _iJSPrivilegeExtObjectDeclarer(0)
	{
		if (other._iJSPrivilegeExtObjectDeclarer)
		{
			_iJSPrivilegeExtObjectDeclarer = other._iJSPrivilegeExtObjectDeclarer;
			_iJSPrivilegeExtObjectDeclarer->_vtbl->_addRef(_iJSPrivilegeExtObjectDeclarer);
		}
	}

	~CEComICEJSPrivilegeExtObjectDeclarerRef()
	{
		if (_iJSPrivilegeExtObjectDeclarer)
		{
			ICEJSPrivilegeExtObjectDeclarer* tmp = _iJSPrivilegeExtObjectDeclarer;
			_iJSPrivilegeExtObjectDeclarer = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEJSPrivilegeExtObjectDeclarer* iJSPrivilegeExtObjectDeclarer;
				void* _ptr;
			} uIntf;
			uIntf.iJSPrivilegeExtObjectDeclarer = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEJSPrivilegeExtObjectDeclarer, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iJSPrivilegeExtObjectDeclarer)
				{
					ICEJSPrivilegeExtObjectDeclarer* tmp = _iJSPrivilegeExtObjectDeclarer;
					_iJSPrivilegeExtObjectDeclarer = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iJSPrivilegeExtObjectDeclarer = uIntf.iJSPrivilegeExtObjectDeclarer;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEJSPrivilegeExtObjectDeclarer* object() const	{ return _iJSPrivilegeExtObjectDeclarer; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEJSPrivilegeExtObjectDeclarer* iOther)
	{
		if (_iJSPrivilegeExtObjectDeclarer)
		{
			ICEJSPrivilegeExtObjectDeclarer* tmp = _iJSPrivilegeExtObjectDeclarer;
			_iJSPrivilegeExtObjectDeclarer = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iJSPrivilegeExtObjectDeclarer = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEJSPrivilegeExtObjectDeclarer* detach()
	{
		ICEJSPrivilegeExtObjectDeclarer* iIntf = _iJSPrivilegeExtObjectDeclarer;
		_iJSPrivilegeExtObjectDeclarer = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEJSPrivilegeExtObjectDeclarer* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iJSPrivilegeExtObjectDeclarer;
		if (_iJSPrivilegeExtObjectDeclarer)
		{
			_iJSPrivilegeExtObjectDeclarer->_vtbl->_addRef(_iJSPrivilegeExtObjectDeclarer);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEJSPrivilegeExtObjectDeclarer*() const	{ return _iJSPrivilegeExtObjectDeclarer; }
	FORCEINLINE_WITHOUT_DEBUG ICEJSPrivilegeExtObjectDeclarer& operator*() const	{ return *_iJSPrivilegeExtObjectDeclarer; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iJSPrivilegeExtObjectDeclarer == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEJSPrivilegeExtObjectDeclarer* iOther) const	{ return (_iJSPrivilegeExtObjectDeclarer != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEJSPrivilegeExtObjectDeclarer* iOther) const	{ return (_iJSPrivilegeExtObjectDeclarer == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEJSPrivilegeExtObjectDeclarerRef& operator=(const CEComICEJSPrivilegeExtObjectDeclarerRef& other)	{ return operator=(other._iJSPrivilegeExtObjectDeclarer); }

	CEComICEJSPrivilegeExtObjectDeclarerRef& operator=(const ICEJSPrivilegeExtObjectDeclarer* iOther)
	{
		if (_iJSPrivilegeExtObjectDeclarer != iOther)
		{
			if (_iJSPrivilegeExtObjectDeclarer)
			{
				ICEJSPrivilegeExtObjectDeclarer* tmp = _iJSPrivilegeExtObjectDeclarer;
				_iJSPrivilegeExtObjectDeclarer = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iJSPrivilegeExtObjectDeclarer = const_cast<ICEJSPrivilegeExtObjectDeclarer*>(iOther);
			if (_iJSPrivilegeExtObjectDeclarer)
			{
				_iJSPrivilegeExtObjectDeclarer->_vtbl->_addRef(_iJSPrivilegeExtObjectDeclarer);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEJSPrivilegeExtObjectDeclarer** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEJSPrivilegeExtObjectDeclarerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iJSPrivilegeExtObjectDeclarer && "has a com object reference. clear first.");
		return & _iJSPrivilegeExtObjectDeclarer; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEJSPrivilegeExtObjectDeclarerRef& other)
	{
		bool result = false;
		if (_iJSPrivilegeExtObjectDeclarer)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iJSPrivilegeExtObjectDeclarer);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iJSPrivilegeExtObjectDeclarer ? _iJSPrivilegeExtObjectDeclarer->_vtbl->_queryInterface(_iJSPrivilegeExtObjectDeclarer, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iJSPrivilegeExtObjectDeclarer) { _iJSPrivilegeExtObjectDeclarer->_vtbl->_addRef(_iJSPrivilegeExtObjectDeclarer); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iJSPrivilegeExtObjectDeclarer) { _iJSPrivilegeExtObjectDeclarer->_vtbl->_release(_iJSPrivilegeExtObjectDeclarer); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult declareObject(INT32 classId, const UTF16CHAR* pObjectName, UINT32 numOfChars16, UINT32 attr)	{ return _iJSPrivilegeExtObjectDeclarer ? _iJSPrivilegeExtObjectDeclarer->_vtbl->_declareObject(_iJSPrivilegeExtObjectDeclarer, classId, pObjectName, numOfChars16, attr) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEJSPrivilegeExtObjectDeclarer* _iJSPrivilegeExtObjectDeclarer;
};

/*! @}
 * end of CEComICEJSPrivilegeExtObjectDeclarerRef
 */

#endif // __cplusplus

#endif
