///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlWindowWidgetContainer_h
#define ICEHtmlWindowWidgetContainer_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "ICEHtmlWindowWidget.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------

struct ICEHtmlWindow;
struct ICEUStringWriter;

//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlWindowWidgetContainer ICEHtmlWindowWidgetContainer
 * @{
 */

/*!
 * ID of ICEHtmlWindowWidgetContainer
 */
#define CEComIID_ICEHtmlWindowWidgetContainer 0x831050c9


/*!
 * ICEHtmlWindowWidgetContainer
 */
typedef struct ICEHtmlWindowWidgetContainer
{
	const struct ICEHtmlWindowWidgetContainer_vtbl* _vtbl;
} ICEHtmlWindowWidgetContainer;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iWindowWidgetContainer	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlWindowWidgetContainer_queryInterface) (ICEHtmlWindowWidgetContainer* iWindowWidgetContainer, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWindowWidgetContainer_addRef) (ICEHtmlWindowWidgetContainer* iWindowWidgetContainer);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWindowWidgetContainer_release) (ICEHtmlWindowWidgetContainer* iWindowWidgetContainer);

typedef CEHResult (*iCEHtmlWindowWidgetContainer_addWidgetForWindow) (ICEHtmlWindowWidgetContainer* iWindowWidgetContainer, struct ICEHtmlWindow* iWindow);

typedef CEHResult (*iCEHtmlWindowWidgetContainer_removeWidgetForWindow) (ICEHtmlWindowWidgetContainer* iWindowWidgetContainer, struct ICEHtmlWindow* iWindow);

/*!
 * V-table of ICEHtmlWindowWidgetContainer
 */
struct ICEHtmlWindowWidgetContainer_vtbl
{
	iCEHtmlWindowWidgetContainer_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlWindowWidgetContainer_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlWindowWidgetContainer_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlWindowWidgetContainer_addWidgetForWindow	_addWidgetForWindow;
	iCEHtmlWindowWidgetContainer_removeWidgetForWindow	_removeWidgetForWindow;
};

/*! @}
 * end of ICEHtmlWindowWidgetContainer
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlWindowWidgetContainerRef CEComICEHtmlWindowWidgetContainerRef
 * @{
 */

class CEComICEHtmlWindowWidgetContainerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlWindowWidgetContainerRef() : _iWindowWidgetContainer(0) {}
	CEComICEHtmlWindowWidgetContainerRef(ICEHtmlWindowWidgetContainer* iOther) : _iWindowWidgetContainer(0)
	{
		if (iOther)
		{
			_iWindowWidgetContainer = iOther;
			_iWindowWidgetContainer->_vtbl->_addRef(_iWindowWidgetContainer);
		}
	}

	CEComICEHtmlWindowWidgetContainerRef(const CEComICEHtmlWindowWidgetContainerRef& other) : _iWindowWidgetContainer(0)
	{
		if (other._iWindowWidgetContainer)
		{
			_iWindowWidgetContainer = other._iWindowWidgetContainer;
			_iWindowWidgetContainer->_vtbl->_addRef(_iWindowWidgetContainer);
		}
	}

	~CEComICEHtmlWindowWidgetContainerRef()
	{
		if (_iWindowWidgetContainer)
		{
			ICEHtmlWindowWidgetContainer* tmp = _iWindowWidgetContainer;
			_iWindowWidgetContainer = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlWindowWidgetContainer* iWindowWidgetContainer;
				void* _ptr;
			} uIntf;
			uIntf.iWindowWidgetContainer = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlWindowWidgetContainer, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iWindowWidgetContainer)
				{
					ICEHtmlWindowWidgetContainer* tmp = _iWindowWidgetContainer;
					_iWindowWidgetContainer = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iWindowWidgetContainer = uIntf.iWindowWidgetContainer;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWindowWidgetContainer* object() const	{ return _iWindowWidgetContainer; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlWindowWidgetContainer* iOther)
	{
		if (_iWindowWidgetContainer)
		{
			ICEHtmlWindowWidgetContainer* tmp = _iWindowWidgetContainer;
			_iWindowWidgetContainer = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iWindowWidgetContainer = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlWindowWidgetContainer* detach()
	{
		ICEHtmlWindowWidgetContainer* iIntf = _iWindowWidgetContainer;
		_iWindowWidgetContainer = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlWindowWidgetContainer* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iWindowWidgetContainer;
		if (_iWindowWidgetContainer)
		{
			_iWindowWidgetContainer->_vtbl->_addRef(_iWindowWidgetContainer);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlWindowWidgetContainer*() const	{ return _iWindowWidgetContainer; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWindowWidgetContainer& operator*() const	{ return *_iWindowWidgetContainer; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iWindowWidgetContainer == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlWindowWidgetContainer* iOther) const	{ return (_iWindowWidgetContainer != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlWindowWidgetContainer* iOther) const	{ return (_iWindowWidgetContainer == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlWindowWidgetContainerRef& operator=(const CEComICEHtmlWindowWidgetContainerRef& other)	{ return operator=(other._iWindowWidgetContainer); }

	CEComICEHtmlWindowWidgetContainerRef& operator=(const ICEHtmlWindowWidgetContainer* iOther)
	{
		if (_iWindowWidgetContainer != iOther)
		{
			if (_iWindowWidgetContainer)
			{
				ICEHtmlWindowWidgetContainer* tmp = _iWindowWidgetContainer;
				_iWindowWidgetContainer = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iWindowWidgetContainer = const_cast<ICEHtmlWindowWidgetContainer*>(iOther);
			if (_iWindowWidgetContainer)
			{
				_iWindowWidgetContainer->_vtbl->_addRef(_iWindowWidgetContainer);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWindowWidgetContainer** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlWindowWidgetContainerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iWindowWidgetContainer && "has a com object reference. clear first.");
		return & _iWindowWidgetContainer; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlWindowWidgetContainerRef& other)
	{
		bool result = false;
		if (_iWindowWidgetContainer)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iWindowWidgetContainer);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iWindowWidgetContainer ? _iWindowWidgetContainer->_vtbl->_queryInterface(_iWindowWidgetContainer, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iWindowWidgetContainer) { _iWindowWidgetContainer->_vtbl->_addRef(_iWindowWidgetContainer); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iWindowWidgetContainer) { _iWindowWidgetContainer->_vtbl->_release(_iWindowWidgetContainer); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult addWidgetForWindow(struct ICEHtmlWindow* iWindow)	{ return _iWindowWidgetContainer ? _iWindowWidgetContainer->_vtbl->_addWidgetForWindow(_iWindowWidgetContainer, iWindow) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult removeWidgetForWindow(struct ICEHtmlWindow* iWindow)	{ return _iWindowWidgetContainer ? _iWindowWidgetContainer->_vtbl->_removeWidgetForWindow(_iWindowWidgetContainer, iWindow) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlWindowWidgetContainer* _iWindowWidgetContainer;
};

/*! @}
 * end of CEComICEHtmlWindowWidgetContainerRef
 */

#endif // __cplusplus

#endif
