///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlStatusbarWidget_h
#define ICEHtmlStatusbarWidget_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "ICEUString.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlStatusbarWidget ICEHtmlStatusbarWidget
 * @{
 */

/*!
 * ID of ICEHtmlStatusbarWidget
 */
#define CEComIID_ICEHtmlStatusbarWidget 0x65286d59


/*!
 * ICEHtmlStatusbarWidget
 */
typedef struct ICEHtmlStatusbarWidget
{
	const struct ICEHtmlStatusbarWidget_vtbl* _vtbl;
} ICEHtmlStatusbarWidget;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iStatusbarWidget	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlStatusbarWidget_queryInterface) (ICEHtmlStatusbarWidget* iStatusbarWidget, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlStatusbarWidget_addRef) (ICEHtmlStatusbarWidget* iStatusbarWidget);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlStatusbarWidget_release) (ICEHtmlStatusbarWidget* iStatusbarWidget);

typedef CEHResult (*iCEHtmlStatusbarWidget_getStatusbarMessage) (ICEHtmlStatusbarWidget* iStatusbarWidget, bool isDefault, struct ICEUString* *const strMessageOut);

typedef CEHResult (*iCEHtmlStatusbarWidget_setStatusbarMessage) (ICEHtmlStatusbarWidget* iStatusbarWidget, bool isDefault, struct ICEUString* strMessage);

/*!
 * V-table of ICEHtmlStatusbarWidget
 */
struct ICEHtmlStatusbarWidget_vtbl
{
	iCEHtmlStatusbarWidget_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlStatusbarWidget_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlStatusbarWidget_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlStatusbarWidget_getStatusbarMessage	_getStatusbarMessage;
	iCEHtmlStatusbarWidget_setStatusbarMessage	_setStatusbarMessage;
};

/*! @}
 * end of ICEHtmlStatusbarWidget
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlStatusbarWidgetRef CEComICEHtmlStatusbarWidgetRef
 * @{
 */

class CEComICEHtmlStatusbarWidgetRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlStatusbarWidgetRef() : _iStatusbarWidget(0) {}
	CEComICEHtmlStatusbarWidgetRef(ICEHtmlStatusbarWidget* iOther) : _iStatusbarWidget(0)
	{
		if (iOther)
		{
			_iStatusbarWidget = iOther;
			_iStatusbarWidget->_vtbl->_addRef(_iStatusbarWidget);
		}
	}

	CEComICEHtmlStatusbarWidgetRef(const CEComICEHtmlStatusbarWidgetRef& other) : _iStatusbarWidget(0)
	{
		if (other._iStatusbarWidget)
		{
			_iStatusbarWidget = other._iStatusbarWidget;
			_iStatusbarWidget->_vtbl->_addRef(_iStatusbarWidget);
		}
	}

	~CEComICEHtmlStatusbarWidgetRef()
	{
		if (_iStatusbarWidget)
		{
			ICEHtmlStatusbarWidget* tmp = _iStatusbarWidget;
			_iStatusbarWidget = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlStatusbarWidget* iStatusbarWidget;
				void* _ptr;
			} uIntf;
			uIntf.iStatusbarWidget = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlStatusbarWidget, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iStatusbarWidget)
				{
					ICEHtmlStatusbarWidget* tmp = _iStatusbarWidget;
					_iStatusbarWidget = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iStatusbarWidget = uIntf.iStatusbarWidget;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlStatusbarWidget* object() const	{ return _iStatusbarWidget; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlStatusbarWidget* iOther)
	{
		if (_iStatusbarWidget)
		{
			ICEHtmlStatusbarWidget* tmp = _iStatusbarWidget;
			_iStatusbarWidget = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iStatusbarWidget = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlStatusbarWidget* detach()
	{
		ICEHtmlStatusbarWidget* iIntf = _iStatusbarWidget;
		_iStatusbarWidget = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlStatusbarWidget* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iStatusbarWidget;
		if (_iStatusbarWidget)
		{
			_iStatusbarWidget->_vtbl->_addRef(_iStatusbarWidget);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlStatusbarWidget*() const	{ return _iStatusbarWidget; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlStatusbarWidget& operator*() const	{ return *_iStatusbarWidget; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iStatusbarWidget == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlStatusbarWidget* iOther) const	{ return (_iStatusbarWidget != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlStatusbarWidget* iOther) const	{ return (_iStatusbarWidget == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlStatusbarWidgetRef& operator=(const CEComICEHtmlStatusbarWidgetRef& other)	{ return operator=(other._iStatusbarWidget); }

	CEComICEHtmlStatusbarWidgetRef& operator=(const ICEHtmlStatusbarWidget* iOther)
	{
		if (_iStatusbarWidget != iOther)
		{
			if (_iStatusbarWidget)
			{
				ICEHtmlStatusbarWidget* tmp = _iStatusbarWidget;
				_iStatusbarWidget = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iStatusbarWidget = const_cast<ICEHtmlStatusbarWidget*>(iOther);
			if (_iStatusbarWidget)
			{
				_iStatusbarWidget->_vtbl->_addRef(_iStatusbarWidget);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlStatusbarWidget** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlStatusbarWidgetRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iStatusbarWidget && "has a com object reference. clear first.");
		return & _iStatusbarWidget; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlStatusbarWidgetRef& other)
	{
		bool result = false;
		if (_iStatusbarWidget)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iStatusbarWidget);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iStatusbarWidget ? _iStatusbarWidget->_vtbl->_queryInterface(_iStatusbarWidget, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iStatusbarWidget) { _iStatusbarWidget->_vtbl->_addRef(_iStatusbarWidget); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iStatusbarWidget) { _iStatusbarWidget->_vtbl->_release(_iStatusbarWidget); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getStatusbarMessage(bool isDefault, struct ICEUString* *const strMessageOut)	{ return _iStatusbarWidget ? _iStatusbarWidget->_vtbl->_getStatusbarMessage(_iStatusbarWidget, isDefault, strMessageOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setStatusbarMessage(bool isDefault, struct ICEUString* strMessage)	{ return _iStatusbarWidget ? _iStatusbarWidget->_vtbl->_setStatusbarMessage(_iStatusbarWidget, isDefault, strMessage) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlStatusbarWidget* _iStatusbarWidget;
};

/*! @}
 * end of CEComICEHtmlStatusbarWidgetRef
 */

#endif // __cplusplus

#endif
