///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlDocumentEventHandler_h
#define ICEHtmlDocumentEventHandler_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "ICEHtmlDocument.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
    CEHtmlDocumentEventType_Replaced,
    CEHtmlDocumentEventType_ReadyForLayout,
    CEHtmlDocumentEventType_InitialLayoutComplete,
    CEHtmlDocumentEventType_Complete,
    CEHtmlDocumentEventType_TitleChanged,
    CEHtmlDocumentEventType_Stopped,
    CEHtmlDocumentEventType_Destroyed,
    CEHtmlDocumentEventType_URLChanged,
} CEHtmlDocumentEventType;

typedef enum
{
    CEHtmlDocumentLayoutEventType_Invalid,
    CEHtmlDocumentLayoutEventType_Valid,
} CEHtmlDocumentLayoutEventType;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlDocumentEventHandler ICEHtmlDocumentEventHandler
 * @{
 */

/*!
 * ID of ICEHtmlDocumentEventHandler
 */
#define CEComIID_ICEHtmlDocumentEventHandler 0x6a080144


/*!
 * ICEHtmlDocumentEventHandler
 */
typedef struct ICEHtmlDocumentEventHandler
{
	const struct ICEHtmlDocumentEventHandler_vtbl* _vtbl;
} ICEHtmlDocumentEventHandler;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iDocumentEventHandler	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlDocumentEventHandler_queryInterface) (ICEHtmlDocumentEventHandler* iDocumentEventHandler, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlDocumentEventHandler_addRef) (ICEHtmlDocumentEventHandler* iDocumentEventHandler);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlDocumentEventHandler_release) (ICEHtmlDocumentEventHandler* iDocumentEventHandler);

typedef CEHResult (*iCEHtmlDocumentEventHandler_onActiveDocumentEvent) (ICEHtmlDocumentEventHandler* iDocumentEventHandler, struct ICEHtmlDocument* iDocument, CEHtmlDocumentEventType type);

typedef CEHResult (*iCEHtmlDocumentEventHandler_onDocumentLayoutEvent) (ICEHtmlDocumentEventHandler* iDocumentEventHandler, struct ICEHtmlDocument* iDocument, CEHtmlDocumentLayoutEventType type);

/*!
 * V-table of ICEHtmlDocumentEventHandler
 */
struct ICEHtmlDocumentEventHandler_vtbl
{
	iCEHtmlDocumentEventHandler_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlDocumentEventHandler_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlDocumentEventHandler_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlDocumentEventHandler_onActiveDocumentEvent	_onActiveDocumentEvent;
	iCEHtmlDocumentEventHandler_onDocumentLayoutEvent	_onDocumentLayoutEvent;
};

/*! @}
 * end of ICEHtmlDocumentEventHandler
 */

/*! \defgroup ICEHtmlScrollInDocumentEventHandler ICEHtmlScrollInDocumentEventHandler
 * @{
 */

/*!
 * ID of ICEHtmlScrollInDocumentEventHandler
 */
#define CEComIID_ICEHtmlScrollInDocumentEventHandler 0x625bc44d

/*!
 * ICEHtmlScrollInDocumentEventHandler
 */
typedef struct ICEHtmlScrollInDocumentEventHandler
{
	const struct ICEHtmlScrollInDocumentEventHandler_vtbl* _vtbl;
} ICEHtmlScrollInDocumentEventHandler;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iScrollInDocumentEventHandler	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlScrollInDocumentEventHandler_queryInterface) (ICEHtmlScrollInDocumentEventHandler* iScrollInDocumentEventHandler, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlScrollInDocumentEventHandler_addRef) (ICEHtmlScrollInDocumentEventHandler* iScrollInDocumentEventHandler);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlScrollInDocumentEventHandler_release) (ICEHtmlScrollInDocumentEventHandler* iScrollInDocumentEventHandler);

typedef CEHResult (*iCEHtmlScrollInDocumentEventHandler_onScrolled) (ICEHtmlScrollInDocumentEventHandler* iScrollInDocumentEventHandler, struct ICEHtmlDocument* iDocument);

/*!
 * V-table of ICEHtmlScrollInDocumentEventHandler
 */
struct ICEHtmlScrollInDocumentEventHandler_vtbl
{
	iCEHtmlScrollInDocumentEventHandler_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlScrollInDocumentEventHandler_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlScrollInDocumentEventHandler_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlScrollInDocumentEventHandler_onScrolled	_onScrolled;
};

/*! @}
 * end of ICEHtmlScrollInDocumentEventHandler
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlDocumentEventHandlerRef CEComICEHtmlDocumentEventHandlerRef
 * @{
 */

class CEComICEHtmlDocumentEventHandlerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlDocumentEventHandlerRef() : _iDocumentEventHandler(0) {}
	CEComICEHtmlDocumentEventHandlerRef(ICEHtmlDocumentEventHandler* iOther) : _iDocumentEventHandler(0)
	{
		if (iOther)
		{
			_iDocumentEventHandler = iOther;
			_iDocumentEventHandler->_vtbl->_addRef(_iDocumentEventHandler);
		}
	}

	CEComICEHtmlDocumentEventHandlerRef(const CEComICEHtmlDocumentEventHandlerRef& other) : _iDocumentEventHandler(0)
	{
		if (other._iDocumentEventHandler)
		{
			_iDocumentEventHandler = other._iDocumentEventHandler;
			_iDocumentEventHandler->_vtbl->_addRef(_iDocumentEventHandler);
		}
	}

	~CEComICEHtmlDocumentEventHandlerRef()
	{
		if (_iDocumentEventHandler)
		{
			ICEHtmlDocumentEventHandler* tmp = _iDocumentEventHandler;
			_iDocumentEventHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlDocumentEventHandler* iDocumentEventHandler;
				void* _ptr;
			} uIntf;
			uIntf.iDocumentEventHandler = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlDocumentEventHandler, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iDocumentEventHandler)
				{
					ICEHtmlDocumentEventHandler* tmp = _iDocumentEventHandler;
					_iDocumentEventHandler = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iDocumentEventHandler = uIntf.iDocumentEventHandler;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlDocumentEventHandler* object() const	{ return _iDocumentEventHandler; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlDocumentEventHandler* iOther)
	{
		if (_iDocumentEventHandler)
		{
			ICEHtmlDocumentEventHandler* tmp = _iDocumentEventHandler;
			_iDocumentEventHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iDocumentEventHandler = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlDocumentEventHandler* detach()
	{
		ICEHtmlDocumentEventHandler* iIntf = _iDocumentEventHandler;
		_iDocumentEventHandler = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlDocumentEventHandler* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iDocumentEventHandler;
		if (_iDocumentEventHandler)
		{
			_iDocumentEventHandler->_vtbl->_addRef(_iDocumentEventHandler);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlDocumentEventHandler*() const	{ return _iDocumentEventHandler; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlDocumentEventHandler& operator*() const	{ return *_iDocumentEventHandler; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iDocumentEventHandler == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlDocumentEventHandler* iOther) const	{ return (_iDocumentEventHandler != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlDocumentEventHandler* iOther) const	{ return (_iDocumentEventHandler == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlDocumentEventHandlerRef& operator=(const CEComICEHtmlDocumentEventHandlerRef& other)	{ return operator=(other._iDocumentEventHandler); }

	CEComICEHtmlDocumentEventHandlerRef& operator=(const ICEHtmlDocumentEventHandler* iOther)
	{
		if (_iDocumentEventHandler != iOther)
		{
			if (_iDocumentEventHandler)
			{
				ICEHtmlDocumentEventHandler* tmp = _iDocumentEventHandler;
				_iDocumentEventHandler = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iDocumentEventHandler = const_cast<ICEHtmlDocumentEventHandler*>(iOther);
			if (_iDocumentEventHandler)
			{
				_iDocumentEventHandler->_vtbl->_addRef(_iDocumentEventHandler);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlDocumentEventHandler** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlDocumentEventHandlerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iDocumentEventHandler && "has a com object reference. clear first.");
		return & _iDocumentEventHandler; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlDocumentEventHandlerRef& other)
	{
		bool result = false;
		if (_iDocumentEventHandler)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iDocumentEventHandler);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iDocumentEventHandler ? _iDocumentEventHandler->_vtbl->_queryInterface(_iDocumentEventHandler, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iDocumentEventHandler) { _iDocumentEventHandler->_vtbl->_addRef(_iDocumentEventHandler); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iDocumentEventHandler) { _iDocumentEventHandler->_vtbl->_release(_iDocumentEventHandler); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult onActiveDocumentEvent(struct ICEHtmlDocument* iDocument, CEHtmlDocumentEventType type)	{ return _iDocumentEventHandler ? _iDocumentEventHandler->_vtbl->_onActiveDocumentEvent(_iDocumentEventHandler, iDocument, type) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult onDocumentLayoutEvent(struct ICEHtmlDocument* iDocument, CEHtmlDocumentLayoutEventType type)	{ return _iDocumentEventHandler ? _iDocumentEventHandler->_vtbl->_onDocumentLayoutEvent(_iDocumentEventHandler, iDocument, type) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlDocumentEventHandler* _iDocumentEventHandler;
};

/*! @}
 * end of CEComICEHtmlDocumentEventHandlerRef
 */

/*! \defgroup CEComICEHtmlScrollInDocumentEventHandlerRef CEComICEHtmlScrollInDocumentEventHandlerRef
 * @{
 */

class CEComICEHtmlScrollInDocumentEventHandlerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlScrollInDocumentEventHandlerRef() : _iScrollInDocumentEventHandler(0) {}
	CEComICEHtmlScrollInDocumentEventHandlerRef(ICEHtmlScrollInDocumentEventHandler* iOther) : _iScrollInDocumentEventHandler(0)
	{
		if (iOther)
		{
			_iScrollInDocumentEventHandler = iOther;
			_iScrollInDocumentEventHandler->_vtbl->_addRef(_iScrollInDocumentEventHandler);
		}
	}

	CEComICEHtmlScrollInDocumentEventHandlerRef(const CEComICEHtmlScrollInDocumentEventHandlerRef& other) : _iScrollInDocumentEventHandler(0)
	{
		if (other._iScrollInDocumentEventHandler)
		{
			_iScrollInDocumentEventHandler = other._iScrollInDocumentEventHandler;
			_iScrollInDocumentEventHandler->_vtbl->_addRef(_iScrollInDocumentEventHandler);
		}
	}

	~CEComICEHtmlScrollInDocumentEventHandlerRef()
	{
		if (_iScrollInDocumentEventHandler)
		{
			ICEHtmlScrollInDocumentEventHandler* tmp = _iScrollInDocumentEventHandler;
			_iScrollInDocumentEventHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlScrollInDocumentEventHandler* iScrollInDocumentEventHandler;
				void* _ptr;
			} uIntf;
			uIntf.iScrollInDocumentEventHandler = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlScrollInDocumentEventHandler, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iScrollInDocumentEventHandler)
				{
					ICEHtmlScrollInDocumentEventHandler* tmp = _iScrollInDocumentEventHandler;
					_iScrollInDocumentEventHandler = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iScrollInDocumentEventHandler = uIntf.iScrollInDocumentEventHandler;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlScrollInDocumentEventHandler* object() const	{ return _iScrollInDocumentEventHandler; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlScrollInDocumentEventHandler* iOther)
	{
		if (_iScrollInDocumentEventHandler)
		{
			ICEHtmlScrollInDocumentEventHandler* tmp = _iScrollInDocumentEventHandler;
			_iScrollInDocumentEventHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iScrollInDocumentEventHandler = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlScrollInDocumentEventHandler* detach()
	{
		ICEHtmlScrollInDocumentEventHandler* iIntf = _iScrollInDocumentEventHandler;
		_iScrollInDocumentEventHandler = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlScrollInDocumentEventHandler* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iScrollInDocumentEventHandler;
		if (_iScrollInDocumentEventHandler)
		{
			_iScrollInDocumentEventHandler->_vtbl->_addRef(_iScrollInDocumentEventHandler);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlScrollInDocumentEventHandler*() const	{ return _iScrollInDocumentEventHandler; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlScrollInDocumentEventHandler& operator*() const	{ return *_iScrollInDocumentEventHandler; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iScrollInDocumentEventHandler == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlScrollInDocumentEventHandler* iOther) const	{ return (_iScrollInDocumentEventHandler != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlScrollInDocumentEventHandler* iOther) const	{ return (_iScrollInDocumentEventHandler == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlScrollInDocumentEventHandlerRef& operator=(const CEComICEHtmlScrollInDocumentEventHandlerRef& other)	{ return operator=(other._iScrollInDocumentEventHandler); }

	CEComICEHtmlScrollInDocumentEventHandlerRef& operator=(const ICEHtmlScrollInDocumentEventHandler* iOther)
	{
		if (_iScrollInDocumentEventHandler != iOther)
		{
			if (_iScrollInDocumentEventHandler)
			{
				ICEHtmlScrollInDocumentEventHandler* tmp = _iScrollInDocumentEventHandler;
				_iScrollInDocumentEventHandler = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iScrollInDocumentEventHandler = const_cast<ICEHtmlScrollInDocumentEventHandler*>(iOther);
			if (_iScrollInDocumentEventHandler)
			{
				_iScrollInDocumentEventHandler->_vtbl->_addRef(_iScrollInDocumentEventHandler);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlScrollInDocumentEventHandler** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlScrollInDocumentEventHandlerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iScrollInDocumentEventHandler && "has a com object reference. clear first.");
		return & _iScrollInDocumentEventHandler; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlScrollInDocumentEventHandlerRef& other)
	{
		bool result = false;
		if (_iScrollInDocumentEventHandler)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iScrollInDocumentEventHandler);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iScrollInDocumentEventHandler ? _iScrollInDocumentEventHandler->_vtbl->_queryInterface(_iScrollInDocumentEventHandler, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iScrollInDocumentEventHandler) { _iScrollInDocumentEventHandler->_vtbl->_addRef(_iScrollInDocumentEventHandler); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iScrollInDocumentEventHandler) { _iScrollInDocumentEventHandler->_vtbl->_release(_iScrollInDocumentEventHandler); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult onScrolled(struct ICEHtmlDocument* iDocument)	{ return _iScrollInDocumentEventHandler ? _iScrollInDocumentEventHandler->_vtbl->_onScrolled(_iScrollInDocumentEventHandler, iDocument) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlScrollInDocumentEventHandler* _iScrollInDocumentEventHandler;
};

/*! @}
 * end of CEComICEHtmlScrollInDocumentEventHandlerRef
 */

#endif // __cplusplus

#endif
