///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlDocument_h
#define ICEHtmlDocument_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "ICEHtmlElement.h"
#include "URL.h"
#include "ICEUIGraphicsContext.h"
#include "ICEUString.h"
#include "CEUITypes.h"
#include "CEComAtomicSupport.h"
#include "ICEHtmlScriptableProxy.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------

struct ICEHtmlWindow;

//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
    CEHtmlDocumentState_PreLayout,
	CEHtmlDocumentState_CanPaint,
    CEHtmlDocumentState_Ready,
    CEHtmlDocumentState_Deactivated,
} CEHtmlDocumentStateFlag;

typedef enum
{
    FocusNavDir_Up,
    FocusNavDir_Right,
    FocusNavDir_Down,
    FocusNavDir_Left,
	FocusNavDir_Tab_Forward,
	FocusNavDir_Tab_Backward
} FocusNavDir;

typedef enum
{
    eCompatibleMode_BackCompatible = 0,     // BackCompat
    eCompatibleMode_CSS1Compatible = 1			// CSS1Compat
} eCompatibleMode;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlDocumentPaintEvent ICEHtmlDocumentPaintEvent
 * @{
 */

/*!
 * ID of ICEHtmlDocumentPaintEvent
 */
#define CEComIID_ICEHtmlDocumentPaintEvent 0x081b0db0

/*!
 * ICEHtmlDocumentPaintEvent
 */
typedef struct ICEHtmlDocumentPaintEvent
{
	const struct ICEHtmlDocumentPaintEvent_vtbl* _vtbl;
} ICEHtmlDocumentPaintEvent;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iDocumentPaintEvent	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlDocumentPaintEvent_queryInterface) (ICEHtmlDocumentPaintEvent* iDocumentPaintEvent, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlDocumentPaintEvent_addRef) (ICEHtmlDocumentPaintEvent* iDocumentPaintEvent);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlDocumentPaintEvent_release) (ICEHtmlDocumentPaintEvent* iDocumentPaintEvent);

typedef CEHResult (*iCEHtmlDocumentPaintEvent_getGraphicsContext) (ICEHtmlDocumentPaintEvent* iDocumentPaintEvent, struct ICEUIGraphicsContext** iGCOut);

typedef CEHResult (*iCEHtmlDocumentPaintEvent_notifyStarted) (ICEHtmlDocumentPaintEvent* iDocumentPaintEvent);

typedef CEHResult (*iCEHtmlDocumentPaintEvent_notifyFinished) (ICEHtmlDocumentPaintEvent* iDocumentPaintEvent);

/*!
 * V-table of ICEHtmlDocumentPaintEvent
 */
struct ICEHtmlDocumentPaintEvent_vtbl
{
	iCEHtmlDocumentPaintEvent_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlDocumentPaintEvent_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlDocumentPaintEvent_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlDocumentPaintEvent_getGraphicsContext	_getGraphicsContext;
	iCEHtmlDocumentPaintEvent_notifyStarted	_notifyStarted;
	iCEHtmlDocumentPaintEvent_notifyFinished	_notifyFinished;
};

/*! @}
 * end of ICEHtmlDocumentPaintEvent
 */

/*! \defgroup ICEHtmlDocument ICEHtmlDocument
 * @{
 */

/*!
 * ID of ICEHtmlDocument
 */
#define CEComIID_ICEHtmlDocument 0x60207629


/*!
 * ICEHtmlDocument
 */
typedef struct ICEHtmlDocument
{
	const struct ICEHtmlDocument_vtbl* _vtbl;
} ICEHtmlDocument;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iDocument	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlDocument_queryInterface) (ICEHtmlDocument* iDocument, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlDocument_addRef) (ICEHtmlDocument* iDocument);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlDocument_release) (ICEHtmlDocument* iDocument);

typedef CEHResult (*iCEHtmlDocument_getState) (ICEHtmlDocument* iDocument, CEHtmlDocumentStateFlag state, bool *const stateOut);

typedef CEHResult (*iCEHtmlDocument_layout) (ICEHtmlDocument* iDocument, CEDim* desiredSize);

typedef CEHResult (*iCEHtmlDocument_renderViews) (ICEHtmlDocument* iDocument, struct ICEUIGraphicsContext* iGC);

typedef CEHResult (*iCEHtmlDocument_postRenderViews) (ICEHtmlDocument* iDocument, struct ICEHtmlDocumentPaintEvent* iPaintEvent);

typedef CEHResult (*iCEHtmlDocument_findString) (ICEHtmlDocument* iDocument, struct ICEUString* iSearchStr, bool doWrap, bool doMixedCase, bool bIsForward, bool *const foundOut);

typedef CEHResult (*iCEHtmlDocument_getWindow) (ICEHtmlDocument* iDocument, struct ICEHtmlWindow* *const iWindowOut);

typedef CEHResult (*iCEHtmlDocument_getURL) (ICEHtmlDocument* iDocument, struct ICEURL* *const iUrlOut);

typedef CEHResult (*iCEHtmlDocument_getTitle) (ICEHtmlDocument* iDocument, struct ICEUString* *const iTitleOut);

typedef CEHResult (*iCEHtmlDocument_getEncoding) (ICEHtmlDocument* iDocument, struct ICEI18nCharsetEncoding* *const encodingOut);

typedef CEHResult (*iCEHtmlDocument_getLanguage) (ICEHtmlDocument* iDocument, struct ICEI18nLocale* *const languageOut);

typedef CEHResult (*iCEHtmlDocument_getCompatibleMode) (ICEHtmlDocument* iDocument, eCompatibleMode *const compatModeOut);

typedef CEHResult (*iCEHtmlDocument_getSize) (ICEHtmlDocument* iDocument, CEDim *const dimOut);

typedef CEHResult (*iCEHtmlDocument_hasSelection) (ICEHtmlDocument* iDocument, bool* hasSelectionOut);

typedef CEHResult (*iCEHtmlDocument_getSelectionString) (ICEHtmlDocument* iDocument, struct ICEUString* *const iSelectionOut);

typedef CEHResult (*iCEHtmlDocument_cut) (ICEHtmlDocument* iDocument);

typedef CEHResult (*iCEHtmlDocument_paste) (ICEHtmlDocument* iDocument);

typedef CEHResult (*iCEHtmlDocument_selectAll) (ICEHtmlDocument* iDocument);

typedef CEHResult (*iCEHtmlDocument_resetSelection) (ICEHtmlDocument* iDocument);

typedef CEHResult (*iCEHtmlDocument_navigateFocus) (ICEHtmlDocument* iDocument, FocusNavDir aDirection, bool checkFocusNavigation, bool *const foundOut);

typedef CEHResult (*iCEHtmlDocument_getFocusedElement) (ICEHtmlDocument* iDocument, struct ICEHtmlElementBaseProxy* *const iElementOut);

typedef CEHResult (*iCEHtmlDocument_resolveURLString) (ICEHtmlDocument* iDocument, struct ICEUString* iUrlString, struct ICEURL* *const iUrlOut);

typedef CEHResult (*iCEHtmlDocument_handleAccessKey) (ICEHtmlDocument* iDocument, CEKeyboardEventParam* keyboardEventParam, bool* const consumedOut);

typedef CEHResult (*iCEHtmlDocument_getRootElement) (ICEHtmlDocument* iDocument, struct ICEHtmlScriptableElementProxy* *const iElementProxyOut);

typedef CEHResult (*iCEHtmlDocument_searchZoomRectAtPoint) (ICEHtmlDocument* iDocument, INT32 x, INT32 y, INT32 sufficientWidth, INT32 sufficientMinWidth, INT32 limitWidth, INT32* xOut, INT32* yOut, INT32* widthOut, INT32* heightOut);

typedef CEHResult (*iCEHtmlDocument_getViewRectAtPoint) (ICEHtmlDocument* iDocument, INT32 x, INT32 y, INT32* xOut, INT32* yOut, INT32* widthOut, INT32* heightOut);

typedef CEHResult (*iCEHtmlDocument_getElementRectAtPoint) (ICEHtmlDocument* iDocument, INT32 x, INT32 y, INT32* xOut, INT32* yOut, INT32* widthOut, INT32* heightOut);

typedef CEHResult (*iCEHtmlDocument_getRadioGroupFromName) (ICEHtmlDocument* iDocument, struct ICEUString* iName, struct ICEHtmlRadioGroup* *const iRadioGroupOut);

typedef CEHResult (*iCEHtmlDocument_addRadioGroupFromName) (ICEHtmlDocument* iDocument, struct ICEUString* iName, struct ICEHtmlRadioGroup* iRadioGroup);

typedef CEHResult (*iCEHtmlDocument_isRefreshZero) (ICEHtmlDocument* iDocument, bool* isRefreshZeroOut);

/*!
 * V-table of ICEHtmlDocument
 */
struct ICEHtmlDocument_vtbl
{
	iCEHtmlDocument_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlDocument_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlDocument_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlDocument_getState	_getState;
	iCEHtmlDocument_layout	_layout;
	iCEHtmlDocument_renderViews	_renderViews;
	iCEHtmlDocument_postRenderViews	_postRenderViews;
	iCEHtmlDocument_findString	_findString;
	iCEHtmlDocument_getWindow	_getWindow;
	iCEHtmlDocument_getURL	_getURL;
	iCEHtmlDocument_getTitle	_getTitle;
	iCEHtmlDocument_getEncoding	_getEncoding;
	iCEHtmlDocument_getLanguage	_getLanguage;
	iCEHtmlDocument_getCompatibleMode	_getCompatibleMode;
	iCEHtmlDocument_getSize	_getSize;
	iCEHtmlDocument_hasSelection	_hasSelection;
	iCEHtmlDocument_getSelectionString	_getSelectionString;
	iCEHtmlDocument_cut	_cut;
	iCEHtmlDocument_paste	_paste;
	iCEHtmlDocument_selectAll	_selectAll;
	iCEHtmlDocument_resetSelection	_resetSelection;
	iCEHtmlDocument_navigateFocus	_navigateFocus;
	iCEHtmlDocument_getFocusedElement	_getFocusedElement;
	iCEHtmlDocument_resolveURLString	_resolveURLString;
	iCEHtmlDocument_handleAccessKey	_handleAccessKey;
	iCEHtmlDocument_getRootElement	_getRootElement;
	iCEHtmlDocument_searchZoomRectAtPoint	_searchZoomRectAtPoint;
	iCEHtmlDocument_getViewRectAtPoint	_getViewRectAtPoint;
	iCEHtmlDocument_getElementRectAtPoint	_getElementRectAtPoint;
	iCEHtmlDocument_getRadioGroupFromName	_getRadioGroupFromName;
	iCEHtmlDocument_addRadioGroupFromName	_addRadioGroupFromName;
	iCEHtmlDocument_isRefreshZero	_isRefreshZero;
};

/*! @}
 * end of ICEHtmlDocument
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlDocumentPaintEventRef CEComICEHtmlDocumentPaintEventRef
 * @{
 */

class CEComICEHtmlDocumentPaintEventRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlDocumentPaintEventRef() : _iDocumentPaintEvent(0) {}
	CEComICEHtmlDocumentPaintEventRef(ICEHtmlDocumentPaintEvent* iOther) : _iDocumentPaintEvent(0)
	{
		if (iOther)
		{
			_iDocumentPaintEvent = iOther;
			_iDocumentPaintEvent->_vtbl->_addRef(_iDocumentPaintEvent);
		}
	}

	CEComICEHtmlDocumentPaintEventRef(const CEComICEHtmlDocumentPaintEventRef& other) : _iDocumentPaintEvent(0)
	{
		if (other._iDocumentPaintEvent)
		{
			_iDocumentPaintEvent = other._iDocumentPaintEvent;
			_iDocumentPaintEvent->_vtbl->_addRef(_iDocumentPaintEvent);
		}
	}

	~CEComICEHtmlDocumentPaintEventRef()
	{
		if (_iDocumentPaintEvent)
		{
			ICEHtmlDocumentPaintEvent* tmp = _iDocumentPaintEvent;
			_iDocumentPaintEvent = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlDocumentPaintEvent* iDocumentPaintEvent;
				void* _ptr;
			} uIntf;
			uIntf.iDocumentPaintEvent = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlDocumentPaintEvent, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iDocumentPaintEvent)
				{
					ICEHtmlDocumentPaintEvent* tmp = _iDocumentPaintEvent;
					_iDocumentPaintEvent = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iDocumentPaintEvent = uIntf.iDocumentPaintEvent;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlDocumentPaintEvent* object() const	{ return _iDocumentPaintEvent; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlDocumentPaintEvent* iOther)
	{
		if (_iDocumentPaintEvent)
		{
			ICEHtmlDocumentPaintEvent* tmp = _iDocumentPaintEvent;
			_iDocumentPaintEvent = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iDocumentPaintEvent = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlDocumentPaintEvent* detach()
	{
		ICEHtmlDocumentPaintEvent* iIntf = _iDocumentPaintEvent;
		_iDocumentPaintEvent = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlDocumentPaintEvent* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iDocumentPaintEvent;
		if (_iDocumentPaintEvent)
		{
			_iDocumentPaintEvent->_vtbl->_addRef(_iDocumentPaintEvent);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlDocumentPaintEvent*() const	{ return _iDocumentPaintEvent; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlDocumentPaintEvent& operator*() const	{ return *_iDocumentPaintEvent; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iDocumentPaintEvent == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlDocumentPaintEvent* iOther) const	{ return (_iDocumentPaintEvent != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlDocumentPaintEvent* iOther) const	{ return (_iDocumentPaintEvent == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlDocumentPaintEventRef& operator=(const CEComICEHtmlDocumentPaintEventRef& other)	{ return operator=(other._iDocumentPaintEvent); }

	CEComICEHtmlDocumentPaintEventRef& operator=(const ICEHtmlDocumentPaintEvent* iOther)
	{
		if (_iDocumentPaintEvent != iOther)
		{
			if (_iDocumentPaintEvent)
			{
				ICEHtmlDocumentPaintEvent* tmp = _iDocumentPaintEvent;
				_iDocumentPaintEvent = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iDocumentPaintEvent = const_cast<ICEHtmlDocumentPaintEvent*>(iOther);
			if (_iDocumentPaintEvent)
			{
				_iDocumentPaintEvent->_vtbl->_addRef(_iDocumentPaintEvent);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlDocumentPaintEvent** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlDocumentPaintEventRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iDocumentPaintEvent && "has a com object reference. clear first.");
		return & _iDocumentPaintEvent; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlDocumentPaintEventRef& other)
	{
		bool result = false;
		if (_iDocumentPaintEvent)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iDocumentPaintEvent);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iDocumentPaintEvent ? _iDocumentPaintEvent->_vtbl->_queryInterface(_iDocumentPaintEvent, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iDocumentPaintEvent) { _iDocumentPaintEvent->_vtbl->_addRef(_iDocumentPaintEvent); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iDocumentPaintEvent) { _iDocumentPaintEvent->_vtbl->_release(_iDocumentPaintEvent); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getGraphicsContext(struct ICEUIGraphicsContext** iGCOut)	{ return _iDocumentPaintEvent ? _iDocumentPaintEvent->_vtbl->_getGraphicsContext(_iDocumentPaintEvent, iGCOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyStarted()	{ return _iDocumentPaintEvent ? _iDocumentPaintEvent->_vtbl->_notifyStarted(_iDocumentPaintEvent) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyFinished()	{ return _iDocumentPaintEvent ? _iDocumentPaintEvent->_vtbl->_notifyFinished(_iDocumentPaintEvent) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlDocumentPaintEvent* _iDocumentPaintEvent;
};

/*! @}
 * end of CEComICEHtmlDocumentPaintEventRef
 */

/*! \defgroup CEComICEHtmlDocumentRef CEComICEHtmlDocumentRef
 * @{
 */

class CEComICEHtmlDocumentRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlDocumentRef() : _iDocument(0) {}
	CEComICEHtmlDocumentRef(ICEHtmlDocument* iOther) : _iDocument(0)
	{
		if (iOther)
		{
			_iDocument = iOther;
			_iDocument->_vtbl->_addRef(_iDocument);
		}
	}

	CEComICEHtmlDocumentRef(const CEComICEHtmlDocumentRef& other) : _iDocument(0)
	{
		if (other._iDocument)
		{
			_iDocument = other._iDocument;
			_iDocument->_vtbl->_addRef(_iDocument);
		}
	}

	~CEComICEHtmlDocumentRef()
	{
		if (_iDocument)
		{
			ICEHtmlDocument* tmp = _iDocument;
			_iDocument = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlDocument* iDocument;
				void* _ptr;
			} uIntf;
			uIntf.iDocument = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlDocument, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iDocument)
				{
					ICEHtmlDocument* tmp = _iDocument;
					_iDocument = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iDocument = uIntf.iDocument;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlDocument* object() const	{ return _iDocument; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlDocument* iOther)
	{
		if (_iDocument)
		{
			ICEHtmlDocument* tmp = _iDocument;
			_iDocument = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iDocument = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlDocument* detach()
	{
		ICEHtmlDocument* iIntf = _iDocument;
		_iDocument = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlDocument* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iDocument;
		if (_iDocument)
		{
			_iDocument->_vtbl->_addRef(_iDocument);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlDocument*() const	{ return _iDocument; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlDocument& operator*() const	{ return *_iDocument; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iDocument == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlDocument* iOther) const	{ return (_iDocument != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlDocument* iOther) const	{ return (_iDocument == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlDocumentRef& operator=(const CEComICEHtmlDocumentRef& other)	{ return operator=(other._iDocument); }

	CEComICEHtmlDocumentRef& operator=(const ICEHtmlDocument* iOther)
	{
		if (_iDocument != iOther)
		{
			if (_iDocument)
			{
				ICEHtmlDocument* tmp = _iDocument;
				_iDocument = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iDocument = const_cast<ICEHtmlDocument*>(iOther);
			if (_iDocument)
			{
				_iDocument->_vtbl->_addRef(_iDocument);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlDocument** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlDocumentRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iDocument && "has a com object reference. clear first.");
		return & _iDocument; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlDocumentRef& other)
	{
		bool result = false;
		if (_iDocument)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iDocument);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iDocument ? _iDocument->_vtbl->_queryInterface(_iDocument, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iDocument) { _iDocument->_vtbl->_addRef(_iDocument); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iDocument) { _iDocument->_vtbl->_release(_iDocument); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getState(CEHtmlDocumentStateFlag state, bool *const stateOut)	{ return _iDocument ? _iDocument->_vtbl->_getState(_iDocument, state, stateOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult layout(CEDim* desiredSize)	{ return _iDocument ? _iDocument->_vtbl->_layout(_iDocument, desiredSize) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult renderViews(struct ICEUIGraphicsContext* iGC)	{ return _iDocument ? _iDocument->_vtbl->_renderViews(_iDocument, iGC) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult postRenderViews(struct ICEHtmlDocumentPaintEvent* iPaintEvent)	{ return _iDocument ? _iDocument->_vtbl->_postRenderViews(_iDocument, iPaintEvent) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult findString(struct ICEUString* iSearchStr, bool doWrap, bool doMixedCase, bool bIsForward, bool *const foundOut)	{ return _iDocument ? _iDocument->_vtbl->_findString(_iDocument, iSearchStr, doWrap, doMixedCase, bIsForward, foundOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getWindow(struct ICEHtmlWindow* *const iWindowOut)	{ return _iDocument ? _iDocument->_vtbl->_getWindow(_iDocument, iWindowOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getURL(struct ICEURL* *const iUrlOut)	{ return _iDocument ? _iDocument->_vtbl->_getURL(_iDocument, iUrlOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTitle(struct ICEUString* *const iTitleOut)	{ return _iDocument ? _iDocument->_vtbl->_getTitle(_iDocument, iTitleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getEncoding(struct ICEI18nCharsetEncoding* *const encodingOut)	{ return _iDocument ? _iDocument->_vtbl->_getEncoding(_iDocument, encodingOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getLanguage(struct ICEI18nLocale* *const languageOut)	{ return _iDocument ? _iDocument->_vtbl->_getLanguage(_iDocument, languageOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCompatibleMode(eCompatibleMode *const compatModeOut)	{ return _iDocument ? _iDocument->_vtbl->_getCompatibleMode(_iDocument, compatModeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getSize(CEDim *const dimOut)	{ return _iDocument ? _iDocument->_vtbl->_getSize(_iDocument, dimOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult hasSelection(bool* hasSelectionOut)	{ return _iDocument ? _iDocument->_vtbl->_hasSelection(_iDocument, hasSelectionOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getSelectionString(struct ICEUString* *const iSelectionOut)	{ return _iDocument ? _iDocument->_vtbl->_getSelectionString(_iDocument, iSelectionOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult cut()	{ return _iDocument ? _iDocument->_vtbl->_cut(_iDocument) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult paste()	{ return _iDocument ? _iDocument->_vtbl->_paste(_iDocument) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult selectAll()	{ return _iDocument ? _iDocument->_vtbl->_selectAll(_iDocument) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult resetSelection()	{ return _iDocument ? _iDocument->_vtbl->_resetSelection(_iDocument) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult navigateFocus(FocusNavDir aDirection, bool checkFocusNavigation, bool *const foundOut)	{ return _iDocument ? _iDocument->_vtbl->_navigateFocus(_iDocument, aDirection, checkFocusNavigation, foundOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFocusedElement(struct ICEHtmlElementBaseProxy* *const iElementOut)	{ return _iDocument ? _iDocument->_vtbl->_getFocusedElement(_iDocument, iElementOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult resolveURLString(struct ICEUString* iUrlString, struct ICEURL* *const iUrlOut)	{ return _iDocument ? _iDocument->_vtbl->_resolveURLString(_iDocument, iUrlString, iUrlOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleAccessKey(CEKeyboardEventParam* keyboardEventParam, bool* const consumedOut)	{ return _iDocument ? _iDocument->_vtbl->_handleAccessKey(_iDocument, keyboardEventParam, consumedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRootElement(struct ICEHtmlScriptableElementProxy* *const iElementProxyOut)	{ return _iDocument ? _iDocument->_vtbl->_getRootElement(_iDocument, iElementProxyOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult searchZoomRectAtPoint(INT32 x, INT32 y, INT32 sufficientWidth, INT32 sufficientMinWidth, INT32 limitWidth, INT32* xOut, INT32* yOut, INT32* widthOut, INT32* heightOut)	{ return _iDocument ? _iDocument->_vtbl->_searchZoomRectAtPoint(_iDocument, x, y, sufficientWidth, sufficientMinWidth, limitWidth, xOut, yOut, widthOut, heightOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getViewRectAtPoint(INT32 x, INT32 y, INT32* xOut, INT32* yOut, INT32* widthOut, INT32* heightOut)	{ return _iDocument ? _iDocument->_vtbl->_getViewRectAtPoint(_iDocument, x, y, xOut, yOut, widthOut, heightOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementRectAtPoint(INT32 x, INT32 y, INT32* xOut, INT32* yOut, INT32* widthOut, INT32* heightOut)	{ return _iDocument ? _iDocument->_vtbl->_getElementRectAtPoint(_iDocument, x, y, xOut, yOut, widthOut, heightOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getRadioGroupFromName(struct ICEUString* iName, struct ICEHtmlRadioGroup* *const iRadioGroupOut)	{ return _iDocument ? _iDocument->_vtbl->_getRadioGroupFromName(_iDocument, iName, iRadioGroupOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult addRadioGroupFromName(struct ICEUString* iName, struct ICEHtmlRadioGroup* iRadioGroup)	{ return _iDocument ? _iDocument->_vtbl->_addRadioGroupFromName(_iDocument, iName, iRadioGroup) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isRefreshZero(bool* isRefreshZeroOut)	{ return _iDocument ? _iDocument->_vtbl->_isRefreshZero(_iDocument, isRefreshZeroOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlDocument* _iDocument;
};

/*! @}
 * end of CEComICEHtmlDocumentRef
 */

#endif // __cplusplus

#endif
