///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlClipboard_h
#define ICEHtmlClipboard_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlClipboard ICEHtmlClipboard
 * @{
 */

/*!
 * ID of ICEHtmlClipboard
 */
#define CEComIID_ICEHtmlClipboard 0xc582db50


/*!
 * ICEHtmlClipboard
 */
typedef struct ICEHtmlClipboard
{
	const struct ICEHtmlClipboard_vtbl* _vtbl;
} ICEHtmlClipboard;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iClipboard	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlClipboard_queryInterface) (ICEHtmlClipboard* iClipboard, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlClipboard_addRef) (ICEHtmlClipboard* iClipboard);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlClipboard_release) (ICEHtmlClipboard* iClipboard);


	/*!
	 * setString
	 */

typedef CEHResult (*iCEHtmlClipboard_setString) (ICEHtmlClipboard* iClipboard, struct ICEUString* iString);


	/*!
	 * reauestString(reserved).
	 */

typedef CEHResult (*iCEHtmlClipboard_requestString) (ICEHtmlClipboard* iClipboard, void *const cData);

/*!
 * V-table of ICEHtmlClipboard
 */
struct ICEHtmlClipboard_vtbl
{
	iCEHtmlClipboard_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlClipboard_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlClipboard_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlClipboard_setString	_setString;
	iCEHtmlClipboard_requestString	_requestString;
};

/*! @}
 * end of ICEHtmlClipboard
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlClipboardRef CEComICEHtmlClipboardRef
 * @{
 */

class CEComICEHtmlClipboardRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlClipboardRef() : _iClipboard(0) {}
	CEComICEHtmlClipboardRef(ICEHtmlClipboard* iOther) : _iClipboard(0)
	{
		if (iOther)
		{
			_iClipboard = iOther;
			_iClipboard->_vtbl->_addRef(_iClipboard);
		}
	}

	CEComICEHtmlClipboardRef(const CEComICEHtmlClipboardRef& other) : _iClipboard(0)
	{
		if (other._iClipboard)
		{
			_iClipboard = other._iClipboard;
			_iClipboard->_vtbl->_addRef(_iClipboard);
		}
	}

	~CEComICEHtmlClipboardRef()
	{
		if (_iClipboard)
		{
			ICEHtmlClipboard* tmp = _iClipboard;
			_iClipboard = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlClipboard* iClipboard;
				void* _ptr;
			} uIntf;
			uIntf.iClipboard = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlClipboard, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iClipboard)
				{
					ICEHtmlClipboard* tmp = _iClipboard;
					_iClipboard = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iClipboard = uIntf.iClipboard;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlClipboard* object() const	{ return _iClipboard; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlClipboard* iOther)
	{
		if (_iClipboard)
		{
			ICEHtmlClipboard* tmp = _iClipboard;
			_iClipboard = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iClipboard = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlClipboard* detach()
	{
		ICEHtmlClipboard* iIntf = _iClipboard;
		_iClipboard = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlClipboard* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iClipboard;
		if (_iClipboard)
		{
			_iClipboard->_vtbl->_addRef(_iClipboard);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlClipboard*() const	{ return _iClipboard; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlClipboard& operator*() const	{ return *_iClipboard; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iClipboard == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlClipboard* iOther) const	{ return (_iClipboard != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlClipboard* iOther) const	{ return (_iClipboard == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlClipboardRef& operator=(const CEComICEHtmlClipboardRef& other)	{ return operator=(other._iClipboard); }

	CEComICEHtmlClipboardRef& operator=(const ICEHtmlClipboard* iOther)
	{
		if (_iClipboard != iOther)
		{
			if (_iClipboard)
			{
				ICEHtmlClipboard* tmp = _iClipboard;
				_iClipboard = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iClipboard = const_cast<ICEHtmlClipboard*>(iOther);
			if (_iClipboard)
			{
				_iClipboard->_vtbl->_addRef(_iClipboard);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlClipboard** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlClipboardRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iClipboard && "has a com object reference. clear first.");
		return & _iClipboard; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlClipboardRef& other)
	{
		bool result = false;
		if (_iClipboard)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iClipboard);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iClipboard ? _iClipboard->_vtbl->_queryInterface(_iClipboard, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iClipboard) { _iClipboard->_vtbl->_addRef(_iClipboard); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iClipboard) { _iClipboard->_vtbl->_release(_iClipboard); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setString(struct ICEUString* iString)	{ return _iClipboard ? _iClipboard->_vtbl->_setString(_iClipboard, iString) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult requestString(void *const cData)	{ return _iClipboard ? _iClipboard->_vtbl->_requestString(_iClipboard, cData) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlClipboard* _iClipboard;
};

/*! @}
 * end of CEComICEHtmlClipboardRef
 */

#endif // __cplusplus

#endif
