///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlBrowserManagerInitalize_h
#define ICEHtmlBrowserManagerInitalize_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlBrowserManagerInitalize ICEHtmlBrowserManagerInitalize
 * @{
 */

/*!
 * ID of ICEHtmlBrowserManagerInitalize
 */
#define CEComIID_ICEHtmlBrowserManagerInitalize 0x465cda1f


/*!
 * ICEHtmlBrowserManager
 */
typedef struct ICEHtmlBrowserManagerInitalize
{
	const struct ICEHtmlBrowserManagerInitalize_vtbl* _vtbl;
} ICEHtmlBrowserManagerInitalize;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iBrowserManagerInitalize	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlBrowserManagerInitalize_queryInterface) (ICEHtmlBrowserManagerInitalize* iBrowserManagerInitalize, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlBrowserManagerInitalize_addRef) (ICEHtmlBrowserManagerInitalize* iBrowserManagerInitalize);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlBrowserManagerInitalize_release) (ICEHtmlBrowserManagerInitalize* iBrowserManagerInitalize);

typedef CEHResult (*iCEHtmlBrowserManagerInitalize_init) (ICEHtmlBrowserManagerInitalize* iBrowserManagerInitalize);

typedef CEHResult (*iCEHtmlBrowserManagerInitalize_active) (ICEHtmlBrowserManagerInitalize* iBrowserManagerInitalize);

typedef CEHResult (*iCEHtmlBrowserManagerInitalize_wait) (ICEHtmlBrowserManagerInitalize* iBrowserManagerInitalize);

typedef CEHResult (*iCEHtmlBrowserManagerInitalize_shutdown) (ICEHtmlBrowserManagerInitalize* iBrowserManagerInitalize);

/*!
 * V-table of ICEHtmlBrowserManagerInitalize
 */
struct ICEHtmlBrowserManagerInitalize_vtbl
{
	iCEHtmlBrowserManagerInitalize_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlBrowserManagerInitalize_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlBrowserManagerInitalize_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlBrowserManagerInitalize_init	_init;
	iCEHtmlBrowserManagerInitalize_active	_active;
	iCEHtmlBrowserManagerInitalize_wait	_wait;
	iCEHtmlBrowserManagerInitalize_shutdown	_shutdown;
};

/*! @}
 * end of ICEHtmlBrowserManagerInitalize
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlBrowserManagerInitalizeRef CEComICEHtmlBrowserManagerInitalizeRef
 * @{
 */

class CEComICEHtmlBrowserManagerInitalizeRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlBrowserManagerInitalizeRef() : _iBrowserManagerInitalize(0) {}
	CEComICEHtmlBrowserManagerInitalizeRef(ICEHtmlBrowserManagerInitalize* iOther) : _iBrowserManagerInitalize(0)
	{
		if (iOther)
		{
			_iBrowserManagerInitalize = iOther;
			_iBrowserManagerInitalize->_vtbl->_addRef(_iBrowserManagerInitalize);
		}
	}

	CEComICEHtmlBrowserManagerInitalizeRef(const CEComICEHtmlBrowserManagerInitalizeRef& other) : _iBrowserManagerInitalize(0)
	{
		if (other._iBrowserManagerInitalize)
		{
			_iBrowserManagerInitalize = other._iBrowserManagerInitalize;
			_iBrowserManagerInitalize->_vtbl->_addRef(_iBrowserManagerInitalize);
		}
	}

	~CEComICEHtmlBrowserManagerInitalizeRef()
	{
		if (_iBrowserManagerInitalize)
		{
			ICEHtmlBrowserManagerInitalize* tmp = _iBrowserManagerInitalize;
			_iBrowserManagerInitalize = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlBrowserManagerInitalize* iBrowserManagerInitalize;
				void* _ptr;
			} uIntf;
			uIntf.iBrowserManagerInitalize = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlBrowserManagerInitalize, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iBrowserManagerInitalize)
				{
					ICEHtmlBrowserManagerInitalize* tmp = _iBrowserManagerInitalize;
					_iBrowserManagerInitalize = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iBrowserManagerInitalize = uIntf.iBrowserManagerInitalize;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlBrowserManagerInitalize* object() const	{ return _iBrowserManagerInitalize; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlBrowserManagerInitalize* iOther)
	{
		if (_iBrowserManagerInitalize)
		{
			ICEHtmlBrowserManagerInitalize* tmp = _iBrowserManagerInitalize;
			_iBrowserManagerInitalize = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iBrowserManagerInitalize = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlBrowserManagerInitalize* detach()
	{
		ICEHtmlBrowserManagerInitalize* iIntf = _iBrowserManagerInitalize;
		_iBrowserManagerInitalize = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlBrowserManagerInitalize* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iBrowserManagerInitalize;
		if (_iBrowserManagerInitalize)
		{
			_iBrowserManagerInitalize->_vtbl->_addRef(_iBrowserManagerInitalize);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlBrowserManagerInitalize*() const	{ return _iBrowserManagerInitalize; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlBrowserManagerInitalize& operator*() const	{ return *_iBrowserManagerInitalize; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iBrowserManagerInitalize == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlBrowserManagerInitalize* iOther) const	{ return (_iBrowserManagerInitalize != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlBrowserManagerInitalize* iOther) const	{ return (_iBrowserManagerInitalize == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlBrowserManagerInitalizeRef& operator=(const CEComICEHtmlBrowserManagerInitalizeRef& other)	{ return operator=(other._iBrowserManagerInitalize); }

	CEComICEHtmlBrowserManagerInitalizeRef& operator=(const ICEHtmlBrowserManagerInitalize* iOther)
	{
		if (_iBrowserManagerInitalize != iOther)
		{
			if (_iBrowserManagerInitalize)
			{
				ICEHtmlBrowserManagerInitalize* tmp = _iBrowserManagerInitalize;
				_iBrowserManagerInitalize = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iBrowserManagerInitalize = const_cast<ICEHtmlBrowserManagerInitalize*>(iOther);
			if (_iBrowserManagerInitalize)
			{
				_iBrowserManagerInitalize->_vtbl->_addRef(_iBrowserManagerInitalize);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlBrowserManagerInitalize** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlBrowserManagerInitalizeRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iBrowserManagerInitalize && "has a com object reference. clear first.");
		return & _iBrowserManagerInitalize; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlBrowserManagerInitalizeRef& other)
	{
		bool result = false;
		if (_iBrowserManagerInitalize)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iBrowserManagerInitalize);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iBrowserManagerInitalize ? _iBrowserManagerInitalize->_vtbl->_queryInterface(_iBrowserManagerInitalize, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iBrowserManagerInitalize) { _iBrowserManagerInitalize->_vtbl->_addRef(_iBrowserManagerInitalize); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iBrowserManagerInitalize) { _iBrowserManagerInitalize->_vtbl->_release(_iBrowserManagerInitalize); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult init()	{ return _iBrowserManagerInitalize ? _iBrowserManagerInitalize->_vtbl->_init(_iBrowserManagerInitalize) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult active()	{ return _iBrowserManagerInitalize ? _iBrowserManagerInitalize->_vtbl->_active(_iBrowserManagerInitalize) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult wait()	{ return _iBrowserManagerInitalize ? _iBrowserManagerInitalize->_vtbl->_wait(_iBrowserManagerInitalize) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult shutdown()	{ return _iBrowserManagerInitalize ? _iBrowserManagerInitalize->_vtbl->_shutdown(_iBrowserManagerInitalize) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlBrowserManagerInitalize* _iBrowserManagerInitalize;
};

/*! @}
 * end of CEComICEHtmlBrowserManagerInitalizeRef
 */

#endif // __cplusplus

#endif
