///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlBrowserManager_h
#define ICEHtmlBrowserManager_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "ICEHtmlBrowserEnvironment.h"
#include "ICEApartment.h"
#include "ICEHtmlNavigationHistoryStore.h"
#include "ICEJSRuntimeEventListener.h"
#include "ICEJSPrivilegeExtObjectListener.h"
#include "ICEHtmlFrameWindow.h"
#include "ICENetwork.h"
#include "ICEHtmlWebKit.h"
#include "ICEHtmlBrowserManagerInitalize.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlBrowserManager ICEHtmlBrowserManager
 * @{
 */

/*!
 * ID of ICEHtmlBrowserManager
 */
#define CEComIID_ICEHtmlBrowserManager 0xb73a3612


/*!
 * ICEHtmlBrowserManager
 */
typedef struct ICEHtmlBrowserManager
{
	const struct ICEHtmlBrowserManager_vtbl* _vtbl;
} ICEHtmlBrowserManager;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iBrowserManager	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlBrowserManager_queryInterface) (ICEHtmlBrowserManager* iBrowserManager, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlBrowserManager_addRef) (ICEHtmlBrowserManager* iBrowserManager);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlBrowserManager_release) (ICEHtmlBrowserManager* iBrowserManager);

typedef CEHResult (*iCEHtmlBrowserManager_heartbeat) (ICEHtmlBrowserManager* iBrowserManager);

typedef CEHResult (*iCEHtmlBrowserManager_init) (ICEHtmlBrowserManager* iBrowserManager, struct ICEHtmlBrowserEnvironment* iBrowserEnvironment, struct ICEFSFileSystem* iFileSystem);

typedef CEHResult (*iCEHtmlBrowserManager_initWebCore) (ICEHtmlBrowserManager* iBrowserManager, struct ICEHtmlBrowserEnvironment* iBrowserEnvironment, struct ICEFSFileSystem* iFileSystem, struct ICENetwork* iCENetwork, struct ICEHtmlBrowserManagerInitalize* iInitalize);

typedef CEHResult (*iCEHtmlBrowserManager_prepareShutdown) (ICEHtmlBrowserManager* iBrowserManager);

typedef CEHResult (*iCEHtmlBrowserManager_shutdown) (ICEHtmlBrowserManager* iBrowserManager);

typedef CEHResult (*iCEHtmlBrowserManager_reset) (ICEHtmlBrowserManager* iBrowserManager, CEHtmlResetOperation resetOperation, struct ICEHtmlFrameWindow* iLatestFrameWindow);

typedef CEHResult (*iCEHtmlBrowserManager_getService) (ICEHtmlBrowserManager* iBrowserManager, const UINT32 iId, struct ICEUnknown* *const iUnknownOut);


    /*! 
     * temporary. 
     */

typedef CEHResult (*iCEHtmlBrowserManager_createURL) (ICEHtmlBrowserManager* iBrowserManager, struct ICEURL* *const iUrlOut);

typedef CEHResult (*iCEHtmlBrowserManager_addHelperAppMimeType) (ICEHtmlBrowserManager* iBrowserManager, struct ICEUString* iMimeTypeString);

typedef CEHResult (*iCEHtmlBrowserManager_removeHelperAppMimeType) (ICEHtmlBrowserManager* iBrowserManager, struct ICEUString* iMimeTypeString);

typedef CEHResult (*iCEHtmlBrowserManager_getNavigationHistoryStore) (ICEHtmlBrowserManager* iBrowserManager, struct ICEHtmlNavigationHistoryStore* *const iNavHistStoreOut);

typedef CEHResult (*iCEHtmlBrowserManager_postHeartbeat) (ICEHtmlBrowserManager* iBrowserManager);

typedef CEHResult (*iCEHtmlBrowserManager_postMessage) (ICEHtmlBrowserManager* iBrowserManager, struct ICEUnknown* unknown);

typedef CEHResult (*iCEHtmlBrowserManager_setJSRuntimeEventListener) (ICEHtmlBrowserManager* iBrowserManager, struct ICEJSRuntimeEventListener* listener);

typedef CEHResult (*iCEHtmlBrowserManager_setCacheAllMode) (ICEHtmlBrowserManager* iBrowserManager, bool cacheAll);

typedef CEHResult (*iCEHtmlBrowserManager_setUseAnythingMode) (ICEHtmlBrowserManager* iBrowserManager, bool useAnything);

typedef CEHResult (*iCEHtmlBrowserManager_setOfflineMode) (ICEHtmlBrowserManager* iBrowserManager, const bool enable);

typedef CEHResult (*iCEHtmlBrowserManager_getOfflineMode) (ICEHtmlBrowserManager* iBrowserManager, bool *const enabledOut);

typedef CEHResult (*iCEHtmlBrowserManager_setJSPrivilegeExtObjectListener) (ICEHtmlBrowserManager* iBrowserManager, struct ICEJSPrivilegeExtObjectListener* listener);

typedef CEHResult (*iCEHtmlBrowserManager_notifyTrendMicroServiceChanged) (ICEHtmlBrowserManager* iBrowserManager, INT32 service);

typedef CEHResult (*iCEHtmlBrowserManager_enableAcceptHttpRequestHeader) (ICEHtmlBrowserManager* iBrowserManager, bool enableIn);

typedef CEHResult (*iCEHtmlBrowserManager_netDeviceStateChanged) (ICEHtmlBrowserManager* iBrowserManager, bool isConnected);

typedef CEHResult (*iCEHtmlBrowserManager_replyNetDeviceWakeUp) (ICEHtmlBrowserManager* iBrowserManager, bool forceRequest);

typedef CEHResult (*iCEHtmlBrowserManager_setProxyImmediately) (ICEHtmlBrowserManager* iBrowserManager, struct ICEUString* proxyHost, UINT16 proxyPort);

typedef CEHResult (*iCEHtmlBrowserManager_setExtensionHeaderFields) (ICEHtmlBrowserManager* iBrowserManager, struct ICEUString* domain, struct ICEUString* path, struct ICEUString* fields);

typedef CEHResult (*iCEHtmlBrowserManager_unsetExtensionHeaderFields) (ICEHtmlBrowserManager* iBrowserManager, struct ICEUString* domain, struct ICEUString* path);

typedef CEHResult (*iCEHtmlBrowserManager_getFrameWindow) (ICEHtmlBrowserManager* iBrowserManager, struct ICEHtmlFrameWindow* *const iFrameWindowOut);

typedef CEHResult (*iCEHtmlBrowserManager_getWebKitFrameWindowWidget) (ICEHtmlBrowserManager* iBrowserManager, struct ICEHtmlWebKitFrameWindowWidget* *const iWebKitFrameWindowWidgetOut);

typedef CEHResult (*iCEHtmlBrowserManager_replyNetworkLibraryError) (ICEHtmlBrowserManager* iBrowserManager, bool result, struct ICEUString* errorPageStr);

/*!
 * V-table of ICEHtmlBrowserManager
 */
struct ICEHtmlBrowserManager_vtbl
{
	iCEHtmlBrowserManager_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlBrowserManager_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlBrowserManager_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlBrowserManager_heartbeat	_heartbeat;
	iCEHtmlBrowserManager_init	_init;
	iCEHtmlBrowserManager_initWebCore	_initWebCore;
	iCEHtmlBrowserManager_prepareShutdown	_prepareShutdown;
	iCEHtmlBrowserManager_shutdown	_shutdown;
	iCEHtmlBrowserManager_reset	_reset;
	iCEHtmlBrowserManager_getService	_getService;
	iCEHtmlBrowserManager_createURL	_createURL;
	iCEHtmlBrowserManager_addHelperAppMimeType	_addHelperAppMimeType;
	iCEHtmlBrowserManager_removeHelperAppMimeType	_removeHelperAppMimeType;
	iCEHtmlBrowserManager_getNavigationHistoryStore	_getNavigationHistoryStore;
	iCEHtmlBrowserManager_postHeartbeat	_postHeartbeat;
	iCEHtmlBrowserManager_postMessage	_postMessage;
	iCEHtmlBrowserManager_setJSRuntimeEventListener	_setJSRuntimeEventListener;
	iCEHtmlBrowserManager_setCacheAllMode	_setCacheAllMode;
	iCEHtmlBrowserManager_setUseAnythingMode	_setUseAnythingMode;
	iCEHtmlBrowserManager_setOfflineMode	_setOfflineMode;
	iCEHtmlBrowserManager_getOfflineMode	_getOfflineMode;
	iCEHtmlBrowserManager_setJSPrivilegeExtObjectListener	_setJSPrivilegeExtObjectListener;
	iCEHtmlBrowserManager_notifyTrendMicroServiceChanged	_notifyTrendMicroServiceChanged;
	iCEHtmlBrowserManager_enableAcceptHttpRequestHeader	_enableAcceptHttpRequestHeader;
	iCEHtmlBrowserManager_netDeviceStateChanged	_netDeviceStateChanged;
	iCEHtmlBrowserManager_replyNetDeviceWakeUp	_replyNetDeviceWakeUp;
	iCEHtmlBrowserManager_setProxyImmediately	_setProxyImmediately;
	iCEHtmlBrowserManager_setExtensionHeaderFields	_setExtensionHeaderFields;
	iCEHtmlBrowserManager_unsetExtensionHeaderFields	_unsetExtensionHeaderFields;
	iCEHtmlBrowserManager_getFrameWindow	_getFrameWindow;
	iCEHtmlBrowserManager_getWebKitFrameWindowWidget	_getWebKitFrameWindowWidget;
	iCEHtmlBrowserManager_replyNetworkLibraryError	_replyNetworkLibraryError;
};

/*! @}
 * end of ICEHtmlBrowserManager
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlBrowserManagerRef CEComICEHtmlBrowserManagerRef
 * @{
 */

class CEComICEHtmlBrowserManagerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlBrowserManagerRef() : _iBrowserManager(0) {}
	CEComICEHtmlBrowserManagerRef(ICEHtmlBrowserManager* iOther) : _iBrowserManager(0)
	{
		if (iOther)
		{
			_iBrowserManager = iOther;
			_iBrowserManager->_vtbl->_addRef(_iBrowserManager);
		}
	}

	CEComICEHtmlBrowserManagerRef(const CEComICEHtmlBrowserManagerRef& other) : _iBrowserManager(0)
	{
		if (other._iBrowserManager)
		{
			_iBrowserManager = other._iBrowserManager;
			_iBrowserManager->_vtbl->_addRef(_iBrowserManager);
		}
	}

	~CEComICEHtmlBrowserManagerRef()
	{
		if (_iBrowserManager)
		{
			ICEHtmlBrowserManager* tmp = _iBrowserManager;
			_iBrowserManager = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlBrowserManager* iBrowserManager;
				void* _ptr;
			} uIntf;
			uIntf.iBrowserManager = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlBrowserManager, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iBrowserManager)
				{
					ICEHtmlBrowserManager* tmp = _iBrowserManager;
					_iBrowserManager = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iBrowserManager = uIntf.iBrowserManager;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlBrowserManager* object() const	{ return _iBrowserManager; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlBrowserManager* iOther)
	{
		if (_iBrowserManager)
		{
			ICEHtmlBrowserManager* tmp = _iBrowserManager;
			_iBrowserManager = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iBrowserManager = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlBrowserManager* detach()
	{
		ICEHtmlBrowserManager* iIntf = _iBrowserManager;
		_iBrowserManager = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlBrowserManager* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iBrowserManager;
		if (_iBrowserManager)
		{
			_iBrowserManager->_vtbl->_addRef(_iBrowserManager);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlBrowserManager*() const	{ return _iBrowserManager; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlBrowserManager& operator*() const	{ return *_iBrowserManager; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iBrowserManager == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlBrowserManager* iOther) const	{ return (_iBrowserManager != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlBrowserManager* iOther) const	{ return (_iBrowserManager == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlBrowserManagerRef& operator=(const CEComICEHtmlBrowserManagerRef& other)	{ return operator=(other._iBrowserManager); }

	CEComICEHtmlBrowserManagerRef& operator=(const ICEHtmlBrowserManager* iOther)
	{
		if (_iBrowserManager != iOther)
		{
			if (_iBrowserManager)
			{
				ICEHtmlBrowserManager* tmp = _iBrowserManager;
				_iBrowserManager = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iBrowserManager = const_cast<ICEHtmlBrowserManager*>(iOther);
			if (_iBrowserManager)
			{
				_iBrowserManager->_vtbl->_addRef(_iBrowserManager);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlBrowserManager** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlBrowserManagerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iBrowserManager && "has a com object reference. clear first.");
		return & _iBrowserManager; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlBrowserManagerRef& other)
	{
		bool result = false;
		if (_iBrowserManager)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iBrowserManager);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_queryInterface(_iBrowserManager, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iBrowserManager) { _iBrowserManager->_vtbl->_addRef(_iBrowserManager); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iBrowserManager) { _iBrowserManager->_vtbl->_release(_iBrowserManager); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult heartbeat()	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_heartbeat(_iBrowserManager) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult init(struct ICEHtmlBrowserEnvironment* iBrowserEnvironment, struct ICEFSFileSystem* iFileSystem)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_init(_iBrowserManager, iBrowserEnvironment, iFileSystem) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult initWebCore(struct ICEHtmlBrowserEnvironment* iBrowserEnvironment, struct ICEFSFileSystem* iFileSystem, struct ICENetwork* iCENetwork, struct ICEHtmlBrowserManagerInitalize* iInitalize)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_initWebCore(_iBrowserManager, iBrowserEnvironment, iFileSystem, iCENetwork, iInitalize) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult prepareShutdown()	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_prepareShutdown(_iBrowserManager) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult shutdown()	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_shutdown(_iBrowserManager) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult reset(CEHtmlResetOperation resetOperation, struct ICEHtmlFrameWindow* iLatestFrameWindow)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_reset(_iBrowserManager, resetOperation, iLatestFrameWindow) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getService(const UINT32 iId, struct ICEUnknown* *const iUnknownOut)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_getService(_iBrowserManager, iId, iUnknownOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult createURL(struct ICEURL* *const iUrlOut)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_createURL(_iBrowserManager, iUrlOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult addHelperAppMimeType(struct ICEUString* iMimeTypeString)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_addHelperAppMimeType(_iBrowserManager, iMimeTypeString) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult removeHelperAppMimeType(struct ICEUString* iMimeTypeString)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_removeHelperAppMimeType(_iBrowserManager, iMimeTypeString) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getNavigationHistoryStore(struct ICEHtmlNavigationHistoryStore* *const iNavHistStoreOut)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_getNavigationHistoryStore(_iBrowserManager, iNavHistStoreOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult postHeartbeat()	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_postHeartbeat(_iBrowserManager) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult postMessage(struct ICEUnknown* unknown)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_postMessage(_iBrowserManager, unknown) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setJSRuntimeEventListener(struct ICEJSRuntimeEventListener* listener)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_setJSRuntimeEventListener(_iBrowserManager, listener) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setCacheAllMode(bool cacheAll)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_setCacheAllMode(_iBrowserManager, cacheAll) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setUseAnythingMode(bool useAnything)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_setUseAnythingMode(_iBrowserManager, useAnything) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setOfflineMode(const bool enable)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_setOfflineMode(_iBrowserManager, enable) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getOfflineMode(bool *const enabledOut)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_getOfflineMode(_iBrowserManager, enabledOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setJSPrivilegeExtObjectListener(struct ICEJSPrivilegeExtObjectListener* listener)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_setJSPrivilegeExtObjectListener(_iBrowserManager, listener) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyTrendMicroServiceChanged(INT32 service)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_notifyTrendMicroServiceChanged(_iBrowserManager, service) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult enableAcceptHttpRequestHeader(bool enableIn)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_enableAcceptHttpRequestHeader(_iBrowserManager, enableIn) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult netDeviceStateChanged(bool isConnected)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_netDeviceStateChanged(_iBrowserManager, isConnected) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult replyNetDeviceWakeUp(bool forceRequest)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_replyNetDeviceWakeUp(_iBrowserManager, forceRequest) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setProxyImmediately(struct ICEUString* proxyHost, UINT16 proxyPort)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_setProxyImmediately(_iBrowserManager, proxyHost, proxyPort) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setExtensionHeaderFields(struct ICEUString* domain, struct ICEUString* path, struct ICEUString* fields)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_setExtensionHeaderFields(_iBrowserManager, domain, path, fields) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult unsetExtensionHeaderFields(struct ICEUString* domain, struct ICEUString* path)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_unsetExtensionHeaderFields(_iBrowserManager, domain, path) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFrameWindow(struct ICEHtmlFrameWindow* *const iFrameWindowOut)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_getFrameWindow(_iBrowserManager, iFrameWindowOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getWebKitFrameWindowWidget(struct ICEHtmlWebKitFrameWindowWidget* *const iWebKitFrameWindowWidgetOut)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_getWebKitFrameWindowWidget(_iBrowserManager, iWebKitFrameWindowWidgetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult replyNetworkLibraryError(bool result, struct ICEUString* errorPageStr)	{ return _iBrowserManager ? _iBrowserManager->_vtbl->_replyNetworkLibraryError(_iBrowserManager, result, errorPageStr) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlBrowserManager* _iBrowserManager;
};

/*! @}
 * end of CEComICEHtmlBrowserManagerRef
 */

#endif // __cplusplus

#endif
