///////////////////////////////////////////////////////////////////////////////
// Copyright 2004,2007,2008,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CESysConfig_h__
#define __CESysConfig_h__

#include "CESysDefs.h"


////////////////////////////////////////////////////////////////
//  load platform-dependent configurations
////////////////////////////////////////////////////////////////

#include CESYSCONFIG_TARGET_H


////////////////////////////////////////////////////////////////
//  check config parameters
////////////////////////////////////////////////////////////////

////////////////////////////////////////////////
//  Syswrap System Facility Configurations
////////////////////////////////////////////////

//! Max number of threads
#if !defined(CE_MAX_THREADS)
#define CE_MAX_THREADS 32
#endif

//! CriticalSection default spin-count
//! if CESYS_CRISEC_DEFAULT_SPINCOUNT >=0, use spinlock with spin-count limit
//! if CESYS_CRISEC_DEFAULT_SPINCOUNT <0,  use CESysMutex. 
#if defined(CESYS_CRISEC_DEFAULT_SPINCOUNT)
#error CESYS_CRISEC_DEFAULT_SPINCOUNT is obsolete. 
#endif


////////////////////////////////////////////////
//  Syswrap libc Configurations
////////////////////////////////////////////////

//! memcpy_s
//! if HAVE_MEMCPY_S==1, platform's memcpy_s() is used.
//! Otherwise, portable memcpy_s() implementation is used
#if !defined(CE_HAVE_MEMCPY_S)
#error HAVE_MEMCPY_S should be defined in CESysConfig*.h
#endif

//! memmove_s
//! if HAVE_MEMMOVE_S==1, platform's memmove_s() is used.
//! Otherwise, portable memmove_s() implementation is used
#if !defined(CE_HAVE_MEMMOVE_S)
#error HAVE_MEMMOVE_S should be defined in CESysConfig*.h
#endif

//! memcmp
//! if HAVE_MEMCMP==1, platform's memcmp() is used.
//! Otherwise, portable memcmp() implementation is used
#if !defined(CE_HAVE_MEMCMP)
#error HAVE_MEMCMP should be defined in CESysConfig*.h
#endif



//! bsearch
//! if HAVE_BSEARCH_S==1, platform's bsearch_s() is used.
//! Otherwise, portable bsearch_s() implementation is used
#if !defined(CE_HAVE_BSEARCH_S)
#error HAVE_BSEARCH_S should be defined in CESysConfig*.h
#endif

//! qsort
//! if HAVE_QSORT_S==1, platform's qsort_s() is used.
//! Otherwise, portable qsort_s() implementation is used
#if !defined(CE_HAVE_QSORT_S)
#error HAVE_QSORT_S should be defined in CESysConfig*.h
#endif


////////////////////////////////////////////////
//  Syswrap Statistics Configurations
////////////////////////////////////////////////

//! CESysMemory function call stat
//! if SYSMEMORY_FUNC_STAT==1, gather funcall stats
//! Otherwise, no stat gathered
#if !defined(SYSMEMORY_FUNC_STAT)
#error SYSMEMORY_FUNC_STAT should be defined in CESysConfig*.h
#endif


#endif // __CESysConfig_h__
