///////////////////////////////////////////////////////////////////////////////
// Copyright 2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CESysDefsGCC_h__
#define __CESysDefsGCC_h__

/////////////////////////////////////////////
// Compiler name
/////////////////////////////////////////////

#define CE_COMPILER_GCC 1


/////////////////////////////////////
//  GCC version check helpers
/////////////////////////////////////

#define CE_GCC_VER_NUM(major, minor, patchlevel)  (((major)*100*100) + ((minor)*100) + (patchlevel))
#define CE_GCC_VER CE_GCC_VER_NUM(__GNUC__, __GNUC_MINOR__, __GNUC_PATCHLEVEL__)


/////////////////////////////////////
//  Type qualifiers
/////////////////////////////////////

#define CE_COMPILER_GCC 1
#define CE_GCC_VER_NUM(major, minor, patchlevel)  (((major)*100*100) + ((minor)*100) + (patchlevel))
#define CE_GCC_VER CE_GCC_VER_NUM(__GNUC__, __GNUC_MINOR__, __GNUC_PATCHLEVEL__)
#define CE_INLINE __inline__
#define CE_FORCEINLINE __inline__ __attribute__((always_inline))

#if (CE_GCC_VER >= CE_GCC_VER_NUM(3,3,0))
    #define CE_DLL_EXPORT __attribute__((visibility("default")))
#else
    #define CE_DLL_EXPORT
#endif

#define NORETURN  __attribute__((noreturn))

#if (CE_GCC_VER >= CE_GCC_VER_NUM(4,0,0))
    #define CE_MAY_ALIAS_TYPE(type) type __attribute__((__may_alias__))
#else
    #define CE_MAY_ALIAS_TYPE(type) type
#endif

#define CE_ALIGNED(x)	__attribute__((aligned(x)))


/////////////////////////////////////
//  Compiler predefined macros
/////////////////////////////////////

#if defined(i386) || defined(i686) || defined(armv41) || defined(mipsel) || defined(MIPSEL) || defined(x86_64) || defined(__ARMEL__)
    #define CE_LITTLE_ENDIAN 1
#elif defined(mips) || defined(powerpc) || defined(__powerpc64__)
    #define CE_LITTLE_ENDIAN 0
#else
    #error unknown cpu!
#endif

#define CEFUNCSIG __PRETTY_FUNCTION__


#endif // __CESysDefsGCC_h__
