# -*- tab-width: 8 -*- 
########################################################################################################
### mswinutil.pl
########################################################################################################
use strict;

package mswinutil;

sub _absPath
{
    my($PATHIN) = @_;
    $PATHIN =~ s:\\:/:g;

    my(@elms) = split("/", $PATHIN);
    my(@absElms) = ();
    my($t);
    foreach $t ( @elms ) {
	if ($t eq "..") {
	    pop @absElms;
	} else {
	    if ($t ne ".") {
		push ( @absElms, $t );
	    }
	}
    } 
    return join("/", @absElms);
}

sub toAbsPath
{
    my($strPath, $pwd) = @_;
    if ($strPath) {
	if ($pwd && index($strPath, ":") == -1) {
	    $strPath = $pwd . "/" . $strPath;
	}
	$strPath = &_absPath($strPath);
	$strPath =~ s:/:\\:g;
    }
    return $strPath;
}

sub toQAbsPath
{
    my($strPath) = toAbsPath(@_);
    return $strPath ? "\"" . $strPath . "\"" : "";
}

sub writeDepMakeFile
{
    my($CWDIR, $RULE_FILE_OUTDIR, $RULE_FILE_PATH, $ABSTARGETSREF, $DEPENDSREF ) = @_;
    my(@ABSTARGETS) = @{$ABSTARGETSREF};
    my(@DEPENDS) = @{$DEPENDSREF};
    
    if (!$CWDIR)
    {
	die "specify -cwd\n";
    }

    if (! -d $RULE_FILE_OUTDIR)
    {
	system("cmd /c mkdir $RULE_FILE_OUTDIR");
    }
    
    open(FPW, ">$RULE_FILE_PATH") || die("Error: Can not open file $RULE_FILE_PATH as output\n");
    
    my ($t);
    foreach $t (@ABSTARGETS)
    {
	printf(FPW "%s ", &mswinutil::toQAbsPath($t));
    }
    print(FPW " :\\\n");

    foreach $t (@DEPENDS)
    {
	printf(FPW "\t%s \\\n", &mswinutil::toQAbsPath($t, $CWDIR));
    }

    print(FPW " \n");
    printf(FPW "\tif exist \$@ del \$@\n");
    close(FPW);
}

1;

