///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEUIFocusFrame_h
#define ICEUIFocusFrame_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "CEUITypes.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEUIBoundary ICEUIBoundary
 * @{
 */

/*!
 * ID of ICEUIBoundary
 */
#define CEComIID_ICEUIBoundary 0xa2fd9716


/*!
 * ICEUIBoundary
 */
typedef struct ICEUIBoundary
{
	const struct ICEUIBoundary_vtbl* _vtbl;
} ICEUIBoundary;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iUIBoundary	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEUIBoundary_queryInterface) (ICEUIBoundary* iUIBoundary, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIBoundary_addRef) (ICEUIBoundary* iUIBoundary);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIBoundary_release) (ICEUIBoundary* iUIBoundary);

typedef CEHResult (*iCEUIBoundary_clear) (ICEUIBoundary* iUIBoundary);

typedef CEHResult (*iCEUIBoundary_getSurroundingRectangle) (ICEUIBoundary* iUIBoundary, CERect *const rectOut);

typedef CEHResult (*iCEUIBoundary_addRectangle) (ICEUIBoundary* iUIBoundary, CERect* rect);

typedef CEHResult (*iCEUIBoundary_addCircle) (ICEUIBoundary* iUIBoundary, INT32 x, INT32 y, INT32 radius);

typedef CEHResult (*iCEUIBoundary_addPolygon) (ICEUIBoundary* iUIBoundary, INT16* array, UINT32 points, INT32 baseX, INT32 baseY);

typedef CEHResult (*iCEUIBoundary_getLabelPoint) (ICEUIBoundary* iUIBoundary, CEPointBase *const pointOut);

/*!
 * V-table of ICEUIBoundary
 */
struct ICEUIBoundary_vtbl
{
	iCEUIBoundary_queryInterface	_queryInterface;	//!< Query interface.
	iCEUIBoundary_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEUIBoundary_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEUIBoundary_clear	_clear;
	iCEUIBoundary_getSurroundingRectangle	_getSurroundingRectangle;
	iCEUIBoundary_addRectangle	_addRectangle;
	iCEUIBoundary_addCircle	_addCircle;
	iCEUIBoundary_addPolygon	_addPolygon;
	iCEUIBoundary_getLabelPoint	_getLabelPoint;
};

/*! @}
 * end of ICEUIBoundary
 */

/*! \defgroup ICEUIFocusFrame ICEUIFocusFrame
 * @{
 */

/*!
 * ID of ICEUIFocusFrame
 */
#define CEComIID_ICEUIFocusFrame 0xb60d6f9a


/*!
 * ICEUIFocusFrame
 */
typedef struct ICEUIFocusFrame
{
	const struct ICEUIFocusFrame_vtbl* _vtbl;
} ICEUIFocusFrame;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iUIFocusFrame	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEUIFocusFrame_queryInterface) (ICEUIFocusFrame* iUIFocusFrame, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIFocusFrame_addRef) (ICEUIFocusFrame* iUIFocusFrame);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIFocusFrame_release) (ICEUIFocusFrame* iUIFocusFrame);

typedef CEHResult (*iCEUIFocusFrame_acquireBoundary) (ICEUIFocusFrame* iUIFocusFrame, struct ICEUIBoundary* *const iBoundaryOut, bool newBoundary);

typedef CEHResult (*iCEUIFocusFrame_releaseBoundary) (ICEUIFocusFrame* iUIFocusFrame, struct ICEUIBoundary* iBoundary, bool suppressInvalidation, bool rollback);

typedef CEHResult (*iCEUIFocusFrame_isEmpty) (ICEUIFocusFrame* iUIFocusFrame, bool *const isEmptyOut);

typedef CEHResult (*iCEUIFocusFrame_setClipRect) (ICEUIFocusFrame* iUIFocusFrame, CERect* clipRect);

/*!
 * V-table of ICEUIFocusFrame
 */
struct ICEUIFocusFrame_vtbl
{
	iCEUIFocusFrame_queryInterface	_queryInterface;	//!< Query interface.
	iCEUIFocusFrame_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEUIFocusFrame_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEUIFocusFrame_acquireBoundary	_acquireBoundary;
	iCEUIFocusFrame_releaseBoundary	_releaseBoundary;
	iCEUIFocusFrame_isEmpty	_isEmpty;
	iCEUIFocusFrame_setClipRect	_setClipRect;
};

/*! @}
 * end of ICEUIFocusFrame
 */

/*! \defgroup ICEUIFocusFrameFactory ICEUIFocusFrameFactory
 * @{
 */

/*!
 * ID of ICEUIFocusFrameFactory
 */
#define CEComIID_ICEUIFocusFrameFactory 0x49fd5461


/*!
 * ICEUIFocusFrameFactory
 */
typedef struct ICEUIFocusFrameFactory
{
	const struct ICEUIFocusFrameFactory_vtbl* _vtbl;
} ICEUIFocusFrameFactory;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iUIFocusFrameFactory	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEUIFocusFrameFactory_queryInterface) (ICEUIFocusFrameFactory* iUIFocusFrameFactory, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIFocusFrameFactory_addRef) (ICEUIFocusFrameFactory* iUIFocusFrameFactory);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIFocusFrameFactory_release) (ICEUIFocusFrameFactory* iUIFocusFrameFactory);

typedef CEHResult (*iCEUIFocusFrameFactory_create) (ICEUIFocusFrameFactory* iUIFocusFrameFactory, bool growOutward, bool availForDraw, struct ICEUIFocusFrame* *const iFocusFrameOut);

typedef CEHResult (*iCEUIFocusFrameFactory_destroy) (ICEUIFocusFrameFactory* iUIFocusFrameFactory, struct ICEUIFocusFrame* iFocusFrame);

/*!
 * V-table of ICEUIFocusFrameFactory
 */
struct ICEUIFocusFrameFactory_vtbl
{
	iCEUIFocusFrameFactory_queryInterface	_queryInterface;	//!< Query interface.
	iCEUIFocusFrameFactory_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEUIFocusFrameFactory_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEUIFocusFrameFactory_create	_create;
	iCEUIFocusFrameFactory_destroy	_destroy;
};

/*! @}
 * end of ICEUIFocusFrameFactory
 */

/*! \defgroup ICEUIMouseAttractBoundary ICEUIMouseAttractBoundary
 * @{
 */

/*!
 * ID of ICEUIMouseAttractBoundary
 */
#define CEComIID_ICEUIMouseAttractBoundary 0xa3df721d


/*!
 * ICEUIMouseAttractBoudary
 */
typedef struct ICEUIMouseAttractBoundary
{
	const struct ICEUIMouseAttractBoundary_vtbl* _vtbl;
} ICEUIMouseAttractBoundary;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iUIMouseAttractBoundary	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEUIMouseAttractBoundary_queryInterface) (ICEUIMouseAttractBoundary* iUIMouseAttractBoundary, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIMouseAttractBoundary_addRef) (ICEUIMouseAttractBoundary* iUIMouseAttractBoundary);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIMouseAttractBoundary_release) (ICEUIMouseAttractBoundary* iUIMouseAttractBoundary);

typedef CEHResult (*iCEUIMouseAttractBoundary_clear) (ICEUIMouseAttractBoundary* iUIMouseAttractBoundary);

typedef CEHResult (*iCEUIMouseAttractBoundary_getSurroundingRectangle) (ICEUIMouseAttractBoundary* iUIMouseAttractBoundary, CERect *const rectOut);

typedef CEHResult (*iCEUIMouseAttractBoundary_addRectangle) (ICEUIMouseAttractBoundary* iUIMouseAttractBoundary, CERect* rect);

typedef CEHResult (*iCEUIMouseAttractBoundary_addCircle) (ICEUIMouseAttractBoundary* iUIMouseAttractBoundary, INT32 x, INT32 y, INT32 radius);

typedef CEHResult (*iCEUIMouseAttractBoundary_addPolygon) (ICEUIMouseAttractBoundary* iUIMouseAttractBoundary, INT16* array, UINT32 points, INT32 baseX, INT32 baseY);

typedef CEHResult (*iCEUIMouseAttractBoundary_getLabelPoint) (ICEUIMouseAttractBoundary* iUIMouseAttractBoundary, CEPointBase *const pointOut);

typedef CEHResult (*iCEUIMouseAttractBoundary_setBasisPoint) (ICEUIMouseAttractBoundary* iUIMouseAttractBoundary, CEPointBase* point);

typedef CEHResult (*iCEUIMouseAttractBoundary_clearBasisPoint) (ICEUIMouseAttractBoundary* iUIMouseAttractBoundary);

/*!
 * V-table of ICEUIMouseAttractBoundary
 */
struct ICEUIMouseAttractBoundary_vtbl
{
	iCEUIMouseAttractBoundary_queryInterface	_queryInterface;	//!< Query interface.
	iCEUIMouseAttractBoundary_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEUIMouseAttractBoundary_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEUIMouseAttractBoundary_clear	_clear;
	iCEUIMouseAttractBoundary_getSurroundingRectangle	_getSurroundingRectangle;
	iCEUIMouseAttractBoundary_addRectangle	_addRectangle;
	iCEUIMouseAttractBoundary_addCircle	_addCircle;
	iCEUIMouseAttractBoundary_addPolygon	_addPolygon;
	iCEUIMouseAttractBoundary_getLabelPoint	_getLabelPoint;
	iCEUIMouseAttractBoundary_setBasisPoint	_setBasisPoint;
	iCEUIMouseAttractBoundary_clearBasisPoint	_clearBasisPoint;
};

/*! @}
 * end of ICEUIMouseAttractBoundary
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEUIBoundaryRef CEComICEUIBoundaryRef
 * @{
 */

class CEComICEUIBoundaryRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEUIBoundaryRef() : _iUIBoundary(0) {}
	CEComICEUIBoundaryRef(ICEUIBoundary* iOther) : _iUIBoundary(0)
	{
		if (iOther)
		{
			_iUIBoundary = iOther;
			_iUIBoundary->_vtbl->_addRef(_iUIBoundary);
		}
	}

	CEComICEUIBoundaryRef(const CEComICEUIBoundaryRef& other) : _iUIBoundary(0)
	{
		if (other._iUIBoundary)
		{
			_iUIBoundary = other._iUIBoundary;
			_iUIBoundary->_vtbl->_addRef(_iUIBoundary);
		}
	}

	~CEComICEUIBoundaryRef()
	{
		if (_iUIBoundary)
		{
			ICEUIBoundary* tmp = _iUIBoundary;
			_iUIBoundary = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEUIBoundary* iUIBoundary;
				void* _ptr;
			} uIntf;
			uIntf.iUIBoundary = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEUIBoundary, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iUIBoundary)
				{
					ICEUIBoundary* tmp = _iUIBoundary;
					_iUIBoundary = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iUIBoundary = uIntf.iUIBoundary;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEUIBoundary* object() const	{ return _iUIBoundary; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEUIBoundary* iOther)
	{
		if (_iUIBoundary)
		{
			ICEUIBoundary* tmp = _iUIBoundary;
			_iUIBoundary = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iUIBoundary = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEUIBoundary* detach()
	{
		ICEUIBoundary* iIntf = _iUIBoundary;
		_iUIBoundary = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEUIBoundary* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iUIBoundary;
		if (_iUIBoundary)
		{
			_iUIBoundary->_vtbl->_addRef(_iUIBoundary);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEUIBoundary*() const	{ return _iUIBoundary; }
	FORCEINLINE_WITHOUT_DEBUG ICEUIBoundary& operator*() const	{ return *_iUIBoundary; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iUIBoundary == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEUIBoundary* iOther) const	{ return (_iUIBoundary != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEUIBoundary* iOther) const	{ return (_iUIBoundary == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEUIBoundaryRef& operator=(const CEComICEUIBoundaryRef& other)	{ return operator=(other._iUIBoundary); }

	CEComICEUIBoundaryRef& operator=(const ICEUIBoundary* iOther)
	{
		if (_iUIBoundary != iOther)
		{
			if (_iUIBoundary)
			{
				ICEUIBoundary* tmp = _iUIBoundary;
				_iUIBoundary = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iUIBoundary = const_cast<ICEUIBoundary*>(iOther);
			if (_iUIBoundary)
			{
				_iUIBoundary->_vtbl->_addRef(_iUIBoundary);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEUIBoundary** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEUIBoundaryRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iUIBoundary && "has a com object reference. clear first.");
		return & _iUIBoundary; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEUIBoundaryRef& other)
	{
		bool result = false;
		if (_iUIBoundary)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iUIBoundary);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iUIBoundary ? _iUIBoundary->_vtbl->_queryInterface(_iUIBoundary, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iUIBoundary) { _iUIBoundary->_vtbl->_addRef(_iUIBoundary); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iUIBoundary) { _iUIBoundary->_vtbl->_release(_iUIBoundary); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult clear()	{ return _iUIBoundary ? _iUIBoundary->_vtbl->_clear(_iUIBoundary) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getSurroundingRectangle(CERect *const rectOut)	{ return _iUIBoundary ? _iUIBoundary->_vtbl->_getSurroundingRectangle(_iUIBoundary, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult addRectangle(CERect* rect)	{ return _iUIBoundary ? _iUIBoundary->_vtbl->_addRectangle(_iUIBoundary, rect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult addCircle(INT32 x, INT32 y, INT32 radius)	{ return _iUIBoundary ? _iUIBoundary->_vtbl->_addCircle(_iUIBoundary, x, y, radius) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult addPolygon(INT16* array, UINT32 points, INT32 baseX, INT32 baseY)	{ return _iUIBoundary ? _iUIBoundary->_vtbl->_addPolygon(_iUIBoundary, array, points, baseX, baseY) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getLabelPoint(CEPointBase *const pointOut)	{ return _iUIBoundary ? _iUIBoundary->_vtbl->_getLabelPoint(_iUIBoundary, pointOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEUIBoundary* _iUIBoundary;
};

/*! @}
 * end of CEComICEUIBoundaryRef
 */

/*! \defgroup CEComICEUIFocusFrameRef CEComICEUIFocusFrameRef
 * @{
 */

class CEComICEUIFocusFrameRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEUIFocusFrameRef() : _iUIFocusFrame(0) {}
	CEComICEUIFocusFrameRef(ICEUIFocusFrame* iOther) : _iUIFocusFrame(0)
	{
		if (iOther)
		{
			_iUIFocusFrame = iOther;
			_iUIFocusFrame->_vtbl->_addRef(_iUIFocusFrame);
		}
	}

	CEComICEUIFocusFrameRef(const CEComICEUIFocusFrameRef& other) : _iUIFocusFrame(0)
	{
		if (other._iUIFocusFrame)
		{
			_iUIFocusFrame = other._iUIFocusFrame;
			_iUIFocusFrame->_vtbl->_addRef(_iUIFocusFrame);
		}
	}

	~CEComICEUIFocusFrameRef()
	{
		if (_iUIFocusFrame)
		{
			ICEUIFocusFrame* tmp = _iUIFocusFrame;
			_iUIFocusFrame = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEUIFocusFrame* iUIFocusFrame;
				void* _ptr;
			} uIntf;
			uIntf.iUIFocusFrame = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEUIFocusFrame, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iUIFocusFrame)
				{
					ICEUIFocusFrame* tmp = _iUIFocusFrame;
					_iUIFocusFrame = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iUIFocusFrame = uIntf.iUIFocusFrame;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEUIFocusFrame* object() const	{ return _iUIFocusFrame; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEUIFocusFrame* iOther)
	{
		if (_iUIFocusFrame)
		{
			ICEUIFocusFrame* tmp = _iUIFocusFrame;
			_iUIFocusFrame = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iUIFocusFrame = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEUIFocusFrame* detach()
	{
		ICEUIFocusFrame* iIntf = _iUIFocusFrame;
		_iUIFocusFrame = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEUIFocusFrame* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iUIFocusFrame;
		if (_iUIFocusFrame)
		{
			_iUIFocusFrame->_vtbl->_addRef(_iUIFocusFrame);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEUIFocusFrame*() const	{ return _iUIFocusFrame; }
	FORCEINLINE_WITHOUT_DEBUG ICEUIFocusFrame& operator*() const	{ return *_iUIFocusFrame; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iUIFocusFrame == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEUIFocusFrame* iOther) const	{ return (_iUIFocusFrame != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEUIFocusFrame* iOther) const	{ return (_iUIFocusFrame == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEUIFocusFrameRef& operator=(const CEComICEUIFocusFrameRef& other)	{ return operator=(other._iUIFocusFrame); }

	CEComICEUIFocusFrameRef& operator=(const ICEUIFocusFrame* iOther)
	{
		if (_iUIFocusFrame != iOther)
		{
			if (_iUIFocusFrame)
			{
				ICEUIFocusFrame* tmp = _iUIFocusFrame;
				_iUIFocusFrame = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iUIFocusFrame = const_cast<ICEUIFocusFrame*>(iOther);
			if (_iUIFocusFrame)
			{
				_iUIFocusFrame->_vtbl->_addRef(_iUIFocusFrame);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEUIFocusFrame** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEUIFocusFrameRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iUIFocusFrame && "has a com object reference. clear first.");
		return & _iUIFocusFrame; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEUIFocusFrameRef& other)
	{
		bool result = false;
		if (_iUIFocusFrame)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iUIFocusFrame);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iUIFocusFrame ? _iUIFocusFrame->_vtbl->_queryInterface(_iUIFocusFrame, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iUIFocusFrame) { _iUIFocusFrame->_vtbl->_addRef(_iUIFocusFrame); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iUIFocusFrame) { _iUIFocusFrame->_vtbl->_release(_iUIFocusFrame); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult acquireBoundary(struct ICEUIBoundary* *const iBoundaryOut, bool newBoundary)	{ return _iUIFocusFrame ? _iUIFocusFrame->_vtbl->_acquireBoundary(_iUIFocusFrame, iBoundaryOut, newBoundary) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult releaseBoundary(struct ICEUIBoundary* iBoundary, bool suppressInvalidation, bool rollback)	{ return _iUIFocusFrame ? _iUIFocusFrame->_vtbl->_releaseBoundary(_iUIFocusFrame, iBoundary, suppressInvalidation, rollback) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isEmpty(bool *const isEmptyOut)	{ return _iUIFocusFrame ? _iUIFocusFrame->_vtbl->_isEmpty(_iUIFocusFrame, isEmptyOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setClipRect(CERect* clipRect)	{ return _iUIFocusFrame ? _iUIFocusFrame->_vtbl->_setClipRect(_iUIFocusFrame, clipRect) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEUIFocusFrame* _iUIFocusFrame;
};

/*! @}
 * end of CEComICEUIFocusFrameRef
 */

/*! \defgroup CEComICEUIFocusFrameFactoryRef CEComICEUIFocusFrameFactoryRef
 * @{
 */

class CEComICEUIFocusFrameFactoryRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEUIFocusFrameFactoryRef() : _iUIFocusFrameFactory(0) {}
	CEComICEUIFocusFrameFactoryRef(ICEUIFocusFrameFactory* iOther) : _iUIFocusFrameFactory(0)
	{
		if (iOther)
		{
			_iUIFocusFrameFactory = iOther;
			_iUIFocusFrameFactory->_vtbl->_addRef(_iUIFocusFrameFactory);
		}
	}

	CEComICEUIFocusFrameFactoryRef(const CEComICEUIFocusFrameFactoryRef& other) : _iUIFocusFrameFactory(0)
	{
		if (other._iUIFocusFrameFactory)
		{
			_iUIFocusFrameFactory = other._iUIFocusFrameFactory;
			_iUIFocusFrameFactory->_vtbl->_addRef(_iUIFocusFrameFactory);
		}
	}

	~CEComICEUIFocusFrameFactoryRef()
	{
		if (_iUIFocusFrameFactory)
		{
			ICEUIFocusFrameFactory* tmp = _iUIFocusFrameFactory;
			_iUIFocusFrameFactory = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEUIFocusFrameFactory* iUIFocusFrameFactory;
				void* _ptr;
			} uIntf;
			uIntf.iUIFocusFrameFactory = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEUIFocusFrameFactory, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iUIFocusFrameFactory)
				{
					ICEUIFocusFrameFactory* tmp = _iUIFocusFrameFactory;
					_iUIFocusFrameFactory = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iUIFocusFrameFactory = uIntf.iUIFocusFrameFactory;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEUIFocusFrameFactory* object() const	{ return _iUIFocusFrameFactory; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEUIFocusFrameFactory* iOther)
	{
		if (_iUIFocusFrameFactory)
		{
			ICEUIFocusFrameFactory* tmp = _iUIFocusFrameFactory;
			_iUIFocusFrameFactory = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iUIFocusFrameFactory = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEUIFocusFrameFactory* detach()
	{
		ICEUIFocusFrameFactory* iIntf = _iUIFocusFrameFactory;
		_iUIFocusFrameFactory = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEUIFocusFrameFactory* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iUIFocusFrameFactory;
		if (_iUIFocusFrameFactory)
		{
			_iUIFocusFrameFactory->_vtbl->_addRef(_iUIFocusFrameFactory);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEUIFocusFrameFactory*() const	{ return _iUIFocusFrameFactory; }
	FORCEINLINE_WITHOUT_DEBUG ICEUIFocusFrameFactory& operator*() const	{ return *_iUIFocusFrameFactory; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iUIFocusFrameFactory == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEUIFocusFrameFactory* iOther) const	{ return (_iUIFocusFrameFactory != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEUIFocusFrameFactory* iOther) const	{ return (_iUIFocusFrameFactory == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEUIFocusFrameFactoryRef& operator=(const CEComICEUIFocusFrameFactoryRef& other)	{ return operator=(other._iUIFocusFrameFactory); }

	CEComICEUIFocusFrameFactoryRef& operator=(const ICEUIFocusFrameFactory* iOther)
	{
		if (_iUIFocusFrameFactory != iOther)
		{
			if (_iUIFocusFrameFactory)
			{
				ICEUIFocusFrameFactory* tmp = _iUIFocusFrameFactory;
				_iUIFocusFrameFactory = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iUIFocusFrameFactory = const_cast<ICEUIFocusFrameFactory*>(iOther);
			if (_iUIFocusFrameFactory)
			{
				_iUIFocusFrameFactory->_vtbl->_addRef(_iUIFocusFrameFactory);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEUIFocusFrameFactory** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEUIFocusFrameFactoryRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iUIFocusFrameFactory && "has a com object reference. clear first.");
		return & _iUIFocusFrameFactory; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEUIFocusFrameFactoryRef& other)
	{
		bool result = false;
		if (_iUIFocusFrameFactory)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iUIFocusFrameFactory);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iUIFocusFrameFactory ? _iUIFocusFrameFactory->_vtbl->_queryInterface(_iUIFocusFrameFactory, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iUIFocusFrameFactory) { _iUIFocusFrameFactory->_vtbl->_addRef(_iUIFocusFrameFactory); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iUIFocusFrameFactory) { _iUIFocusFrameFactory->_vtbl->_release(_iUIFocusFrameFactory); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult create(bool growOutward, bool availForDraw, struct ICEUIFocusFrame* *const iFocusFrameOut)	{ return _iUIFocusFrameFactory ? _iUIFocusFrameFactory->_vtbl->_create(_iUIFocusFrameFactory, growOutward, availForDraw, iFocusFrameOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult destroy(struct ICEUIFocusFrame* iFocusFrame)	{ return _iUIFocusFrameFactory ? _iUIFocusFrameFactory->_vtbl->_destroy(_iUIFocusFrameFactory, iFocusFrame) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEUIFocusFrameFactory* _iUIFocusFrameFactory;
};

/*! @}
 * end of CEComICEUIFocusFrameFactoryRef
 */

/*! \defgroup CEComICEUIMouseAttractBoundaryRef CEComICEUIMouseAttractBoundaryRef
 * @{
 */

class CEComICEUIMouseAttractBoundaryRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEUIMouseAttractBoundaryRef() : _iUIMouseAttractBoundary(0) {}
	CEComICEUIMouseAttractBoundaryRef(ICEUIMouseAttractBoundary* iOther) : _iUIMouseAttractBoundary(0)
	{
		if (iOther)
		{
			_iUIMouseAttractBoundary = iOther;
			_iUIMouseAttractBoundary->_vtbl->_addRef(_iUIMouseAttractBoundary);
		}
	}

	CEComICEUIMouseAttractBoundaryRef(const CEComICEUIMouseAttractBoundaryRef& other) : _iUIMouseAttractBoundary(0)
	{
		if (other._iUIMouseAttractBoundary)
		{
			_iUIMouseAttractBoundary = other._iUIMouseAttractBoundary;
			_iUIMouseAttractBoundary->_vtbl->_addRef(_iUIMouseAttractBoundary);
		}
	}

	~CEComICEUIMouseAttractBoundaryRef()
	{
		if (_iUIMouseAttractBoundary)
		{
			ICEUIMouseAttractBoundary* tmp = _iUIMouseAttractBoundary;
			_iUIMouseAttractBoundary = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEUIMouseAttractBoundary* iUIMouseAttractBoundary;
				void* _ptr;
			} uIntf;
			uIntf.iUIMouseAttractBoundary = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEUIMouseAttractBoundary, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iUIMouseAttractBoundary)
				{
					ICEUIMouseAttractBoundary* tmp = _iUIMouseAttractBoundary;
					_iUIMouseAttractBoundary = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iUIMouseAttractBoundary = uIntf.iUIMouseAttractBoundary;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEUIMouseAttractBoundary* object() const	{ return _iUIMouseAttractBoundary; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEUIMouseAttractBoundary* iOther)
	{
		if (_iUIMouseAttractBoundary)
		{
			ICEUIMouseAttractBoundary* tmp = _iUIMouseAttractBoundary;
			_iUIMouseAttractBoundary = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iUIMouseAttractBoundary = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEUIMouseAttractBoundary* detach()
	{
		ICEUIMouseAttractBoundary* iIntf = _iUIMouseAttractBoundary;
		_iUIMouseAttractBoundary = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEUIMouseAttractBoundary* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iUIMouseAttractBoundary;
		if (_iUIMouseAttractBoundary)
		{
			_iUIMouseAttractBoundary->_vtbl->_addRef(_iUIMouseAttractBoundary);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEUIMouseAttractBoundary*() const	{ return _iUIMouseAttractBoundary; }
	FORCEINLINE_WITHOUT_DEBUG ICEUIMouseAttractBoundary& operator*() const	{ return *_iUIMouseAttractBoundary; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iUIMouseAttractBoundary == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEUIMouseAttractBoundary* iOther) const	{ return (_iUIMouseAttractBoundary != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEUIMouseAttractBoundary* iOther) const	{ return (_iUIMouseAttractBoundary == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEUIMouseAttractBoundaryRef& operator=(const CEComICEUIMouseAttractBoundaryRef& other)	{ return operator=(other._iUIMouseAttractBoundary); }

	CEComICEUIMouseAttractBoundaryRef& operator=(const ICEUIMouseAttractBoundary* iOther)
	{
		if (_iUIMouseAttractBoundary != iOther)
		{
			if (_iUIMouseAttractBoundary)
			{
				ICEUIMouseAttractBoundary* tmp = _iUIMouseAttractBoundary;
				_iUIMouseAttractBoundary = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iUIMouseAttractBoundary = const_cast<ICEUIMouseAttractBoundary*>(iOther);
			if (_iUIMouseAttractBoundary)
			{
				_iUIMouseAttractBoundary->_vtbl->_addRef(_iUIMouseAttractBoundary);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEUIMouseAttractBoundary** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEUIMouseAttractBoundaryRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iUIMouseAttractBoundary && "has a com object reference. clear first.");
		return & _iUIMouseAttractBoundary; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEUIMouseAttractBoundaryRef& other)
	{
		bool result = false;
		if (_iUIMouseAttractBoundary)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iUIMouseAttractBoundary);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iUIMouseAttractBoundary ? _iUIMouseAttractBoundary->_vtbl->_queryInterface(_iUIMouseAttractBoundary, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iUIMouseAttractBoundary) { _iUIMouseAttractBoundary->_vtbl->_addRef(_iUIMouseAttractBoundary); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iUIMouseAttractBoundary) { _iUIMouseAttractBoundary->_vtbl->_release(_iUIMouseAttractBoundary); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult clear()	{ return _iUIMouseAttractBoundary ? _iUIMouseAttractBoundary->_vtbl->_clear(_iUIMouseAttractBoundary) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getSurroundingRectangle(CERect *const rectOut)	{ return _iUIMouseAttractBoundary ? _iUIMouseAttractBoundary->_vtbl->_getSurroundingRectangle(_iUIMouseAttractBoundary, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult addRectangle(CERect* rect)	{ return _iUIMouseAttractBoundary ? _iUIMouseAttractBoundary->_vtbl->_addRectangle(_iUIMouseAttractBoundary, rect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult addCircle(INT32 x, INT32 y, INT32 radius)	{ return _iUIMouseAttractBoundary ? _iUIMouseAttractBoundary->_vtbl->_addCircle(_iUIMouseAttractBoundary, x, y, radius) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult addPolygon(INT16* array, UINT32 points, INT32 baseX, INT32 baseY)	{ return _iUIMouseAttractBoundary ? _iUIMouseAttractBoundary->_vtbl->_addPolygon(_iUIMouseAttractBoundary, array, points, baseX, baseY) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getLabelPoint(CEPointBase *const pointOut)	{ return _iUIMouseAttractBoundary ? _iUIMouseAttractBoundary->_vtbl->_getLabelPoint(_iUIMouseAttractBoundary, pointOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setBasisPoint(CEPointBase* point)	{ return _iUIMouseAttractBoundary ? _iUIMouseAttractBoundary->_vtbl->_setBasisPoint(_iUIMouseAttractBoundary, point) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult clearBasisPoint()	{ return _iUIMouseAttractBoundary ? _iUIMouseAttractBoundary->_vtbl->_clearBasisPoint(_iUIMouseAttractBoundary) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEUIMouseAttractBoundary* _iUIMouseAttractBoundary;
};

/*! @}
 * end of CEComICEUIMouseAttractBoundaryRef
 */

#endif // __cplusplus

#endif
