///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlBrowserEnvironment_h
#define ICEHtmlBrowserEnvironment_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "CEApiFSPathname.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
    CEHtmlBrowserPath_Application,
    CEHtmlBrowserPath_DBData,
    CEHtmlBrowserPath_CacheData,
    CEHtmlBrowserPath_CookieData,
    CEHtmlBrowserPath_HistoryData,
    CEHtmlBrowserPath_SSLCertDir,
    CEHtmlBrowserPath_SSLCRLDir,
    CEHtmlBrowserPath_PluginDir,
    CEHtmlBrowserPath_PermissionDir,
} CEHtmlBrowserPath;

typedef enum
{
    CEHtmlBrowserVendor_DB,
    CEHtmlBrowserVendor_SSL,
} CEHtmlBrowserVendor;

typedef enum
{
    CEHtmlResetOperation_None,
    CEHtmlResetOperation_ClearDomOnMemory,
    CEHtmlResetOperation_ClearDomBroken,
    CEHtmlResetOperation_AskForDestroy,
    CEHtmlResetOperation_ClearLatest,
    CEHtmlResetOperation_DestroyExceptLatest,
} CEHtmlResetOperation;

typedef enum
{
    CEHtmlFocusNavigationBehavior_None = 0,
    CEHtmlFocusNavigationBehavior_CSS3UINavDir = 1 << 0,
    CEHtmlFocusNavigationBehavior_Wraparound = 1 << 1,
    CEHtmlFocusNavigationBehavior_ScrollTracking = 1 << 2,
    CEHtmlFocusNavigationBehavior_CrossDocument = 1 << 3,
    CEHtmlFocusNavigationBehavior_AroundMouse = 1 << 4,
    CEHtmlFocusNavigationBehavior_FocusBoundaryChain = 1 << 5,
    CEHtmlFocusNavigationBehavior_ExitFrameByEscape = 1 << 6,
    CEHtmlFocusNavigationBehavior_DefaultFocus = 1 << 7,
    CEHtmlFocusNavigationBehavior_Disable = 1 << 8,
    CEHtmlFocusNavigationBehavior_MouseEmulation = 1 << 31,
} CEHtmlFocusNavigationBehavior;

typedef enum
{
	CEHtmlFocusNavigationType_DomOrder = 0,
	CEHtmlFocusNavigationType_Arrow = 1,
	CEHtmlFocusNavigationType_None = 2,
} CEHtmlFocusNavigationType;

typedef enum
{
    CEHtmlErrorHandlingMode_None = 0,
    CEHtmlErrorHandlingMode_StrictImageHandling = 1 << 0,
} CEHtmlErrorHandlingMode;

typedef enum
{
    CEHtmlSecureWarningPolicy_None = 0,
    CEHtmlSecureWarningPolicy_WarnInitialHttps = 1 << 0,
} CEHtmlSecureWarningPolicy;

typedef enum
{
    CEHtmlImageStingyMode_Normal,
    CEHtmlImageStingyMode_DetachSurface,
} CEHtmlImageStingyMode;

typedef enum
{
    CEHtmlPluginThreadMode_UI,
    CEHtmlPluginThreadMode_Scripting,
} CEHtmlPluginThreadMode;

typedef enum
{
    CEHtmlBrowserType_Unknown = -1,
    CEHtmlBrowserType_IE6 = 0,
    CEHtmlBrowserType_CEA2014 = 1,
} CEHtmlBrowserType;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlBrowserEnvironment ICEHtmlBrowserEnvironment
 * @{
 */

/*!
 * ID of ICEHtmlBrowserEnvironment
 */
#define CEComIID_ICEHtmlBrowserEnvironment 0xf4e7c3c2


/*!
 * ICEHtmlBrowserEnvironment
 */
typedef struct ICEHtmlBrowserEnvironment
{
	const struct ICEHtmlBrowserEnvironment_vtbl* _vtbl;
} ICEHtmlBrowserEnvironment;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iBrowserEnvironment	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlBrowserEnvironment_queryInterface) (ICEHtmlBrowserEnvironment* iBrowserEnvironment, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlBrowserEnvironment_addRef) (ICEHtmlBrowserEnvironment* iBrowserEnvironment);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlBrowserEnvironment_release) (ICEHtmlBrowserEnvironment* iBrowserEnvironment);

typedef CEHResult (*iCEHtmlBrowserEnvironment_getPath) (ICEHtmlBrowserEnvironment* iBrowserEnvironment, CEHtmlBrowserPath pathType, struct ICEFSPathname* *const iPathnameOut);


/*!
 * CEComIID_ICEFSFileSystem,
 * CEComIID_ICEUIGraphicsEnvironment,
 * CEComIID_ICEUIImageDecoderFactory,
 * CEComIID_ICEUIImageUtility,
 * CEComIID_ICEUIFontFamilyNameUtilily,
 * CEComIID_ICEHtmlFrameWindowWidgetManager,
 * CEComIID_ICEHtmlHelperAppFactory,
 * CEComIID_ICEHtmlResourceProvider,
 * CEComIID_ICEHtmlProxyEnvironment,
 * CEComIID_ICEPS2
 */

typedef CEHResult (*iCEHtmlBrowserEnvironment_getService) (ICEHtmlBrowserEnvironment* iBrowserEnvironment, const UINT32 iId, struct ICEUnknown* *const iUnknownOut);

typedef CEHResult (*iCEHtmlBrowserEnvironment_getClassId) (ICEHtmlBrowserEnvironment* iBrowserEnvironment, const UINT32 iId, UINT32 *const clsIdOut);

typedef CEHResult (*iCEHtmlBrowserEnvironment_getVendor) (ICEHtmlBrowserEnvironment* iBrowserEnvironment, CEHtmlBrowserVendor vendorType, INT32 *const vendorIdOut);

typedef CEHResult (*iCEHtmlBrowserEnvironment_notifyShutdown) (ICEHtmlBrowserEnvironment* iBrowserEnvironment);

typedef CEHResult (*iCEHtmlBrowserEnvironment_notifyResetFinished) (ICEHtmlBrowserEnvironment* iBrowserEnvironment, CEHtmlResetOperation resetOperation, bool resetOccurred);

typedef CEHResult (*iCEHtmlBrowserEnvironment_askForReset) (ICEHtmlBrowserEnvironment* iBrowserEnvironment, struct ICEHtmlFrameWindow* *const iFrameWindowOut);

typedef CEHResult (*iCEHtmlBrowserEnvironment_getFocusNavigatorBehavior) (ICEHtmlBrowserEnvironment* iBrowserEnvironment, UINT32 *const flagsOut);

typedef CEHResult (*iCEHtmlBrowserEnvironment_getFocusNavigationType) (ICEHtmlBrowserEnvironment* iBrowserEnvironment, UINT32 *const flagsOut);

typedef CEHResult (*iCEHtmlBrowserEnvironment_getErrorHandlingMode) (ICEHtmlBrowserEnvironment* iBrowserEnvironment, UINT32 *const flagsOut);

typedef CEHResult (*iCEHtmlBrowserEnvironment_getSecureWarningPolicy) (ICEHtmlBrowserEnvironment* iBrowserEnvironment, UINT32 *const flagsOut);

typedef CEHResult (*iCEHtmlBrowserEnvironment_getImageStingyMode) (ICEHtmlBrowserEnvironment* iBrowserEnvironment, CEHtmlImageStingyMode *const modeOut);

typedef CEHResult (*iCEHtmlBrowserEnvironment_getPluginThreadMode) (ICEHtmlBrowserEnvironment* iBrowserEnvironment, CEHtmlPluginThreadMode *const modeOut);

typedef CEHResult (*iCEHtmlBrowserEnvironment_getTimeoutAccuracy) (ICEHtmlBrowserEnvironment* iBrowserEnvironment, UINT32 *const accuracyMilliSecOut);

typedef CEHResult (*iCEHtmlBrowserEnvironment_getBrowserType) (ICEHtmlBrowserEnvironment* iBrowserEnvironment, CEHtmlBrowserType* typeOut);

typedef CEHResult (*iCEHtmlBrowserEnvironment_getKeepAliveEnable) (ICEHtmlBrowserEnvironment* iBrowserEnvironment, bool* enableOut);

typedef CEHResult (*iCEHtmlBrowserEnvironment_getEnablePlugin) (ICEHtmlBrowserEnvironment* iBrowserEnvironment, bool* enableOut);

typedef CEHResult (*iCEHtmlBrowserEnvironment_notifyLowMemory) (ICEHtmlBrowserEnvironment* iBrowserEnvironment);

/*!
 * V-table of ICEHtmlBrowserEnvironment
 */
struct ICEHtmlBrowserEnvironment_vtbl
{
	iCEHtmlBrowserEnvironment_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlBrowserEnvironment_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlBrowserEnvironment_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlBrowserEnvironment_getPath	_getPath;
	iCEHtmlBrowserEnvironment_getService	_getService;
	iCEHtmlBrowserEnvironment_getClassId	_getClassId;
	iCEHtmlBrowserEnvironment_getVendor	_getVendor;
	iCEHtmlBrowserEnvironment_notifyShutdown	_notifyShutdown;
	iCEHtmlBrowserEnvironment_notifyResetFinished	_notifyResetFinished;
	iCEHtmlBrowserEnvironment_askForReset	_askForReset;
	iCEHtmlBrowserEnvironment_getFocusNavigatorBehavior	_getFocusNavigatorBehavior;
	iCEHtmlBrowserEnvironment_getFocusNavigationType	_getFocusNavigationType;
	iCEHtmlBrowserEnvironment_getErrorHandlingMode	_getErrorHandlingMode;
	iCEHtmlBrowserEnvironment_getSecureWarningPolicy	_getSecureWarningPolicy;
	iCEHtmlBrowserEnvironment_getImageStingyMode	_getImageStingyMode;
	iCEHtmlBrowserEnvironment_getPluginThreadMode	_getPluginThreadMode;
	iCEHtmlBrowserEnvironment_getTimeoutAccuracy	_getTimeoutAccuracy;
	iCEHtmlBrowserEnvironment_getBrowserType	_getBrowserType;
	iCEHtmlBrowserEnvironment_getKeepAliveEnable	_getKeepAliveEnable;
	iCEHtmlBrowserEnvironment_getEnablePlugin	_getEnablePlugin;
	iCEHtmlBrowserEnvironment_notifyLowMemory	_notifyLowMemory;
};

/*! @}
 * end of ICEHtmlBrowserEnvironment
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlBrowserEnvironmentRef CEComICEHtmlBrowserEnvironmentRef
 * @{
 */

class CEComICEHtmlBrowserEnvironmentRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlBrowserEnvironmentRef() : _iBrowserEnvironment(0) {}
	CEComICEHtmlBrowserEnvironmentRef(ICEHtmlBrowserEnvironment* iOther) : _iBrowserEnvironment(0)
	{
		if (iOther)
		{
			_iBrowserEnvironment = iOther;
			_iBrowserEnvironment->_vtbl->_addRef(_iBrowserEnvironment);
		}
	}

	CEComICEHtmlBrowserEnvironmentRef(const CEComICEHtmlBrowserEnvironmentRef& other) : _iBrowserEnvironment(0)
	{
		if (other._iBrowserEnvironment)
		{
			_iBrowserEnvironment = other._iBrowserEnvironment;
			_iBrowserEnvironment->_vtbl->_addRef(_iBrowserEnvironment);
		}
	}

	~CEComICEHtmlBrowserEnvironmentRef()
	{
		if (_iBrowserEnvironment)
		{
			ICEHtmlBrowserEnvironment* tmp = _iBrowserEnvironment;
			_iBrowserEnvironment = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlBrowserEnvironment* iBrowserEnvironment;
				void* _ptr;
			} uIntf;
			uIntf.iBrowserEnvironment = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlBrowserEnvironment, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iBrowserEnvironment)
				{
					ICEHtmlBrowserEnvironment* tmp = _iBrowserEnvironment;
					_iBrowserEnvironment = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iBrowserEnvironment = uIntf.iBrowserEnvironment;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlBrowserEnvironment* object() const	{ return _iBrowserEnvironment; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlBrowserEnvironment* iOther)
	{
		if (_iBrowserEnvironment)
		{
			ICEHtmlBrowserEnvironment* tmp = _iBrowserEnvironment;
			_iBrowserEnvironment = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iBrowserEnvironment = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlBrowserEnvironment* detach()
	{
		ICEHtmlBrowserEnvironment* iIntf = _iBrowserEnvironment;
		_iBrowserEnvironment = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlBrowserEnvironment* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iBrowserEnvironment;
		if (_iBrowserEnvironment)
		{
			_iBrowserEnvironment->_vtbl->_addRef(_iBrowserEnvironment);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlBrowserEnvironment*() const	{ return _iBrowserEnvironment; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlBrowserEnvironment& operator*() const	{ return *_iBrowserEnvironment; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iBrowserEnvironment == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlBrowserEnvironment* iOther) const	{ return (_iBrowserEnvironment != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlBrowserEnvironment* iOther) const	{ return (_iBrowserEnvironment == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlBrowserEnvironmentRef& operator=(const CEComICEHtmlBrowserEnvironmentRef& other)	{ return operator=(other._iBrowserEnvironment); }

	CEComICEHtmlBrowserEnvironmentRef& operator=(const ICEHtmlBrowserEnvironment* iOther)
	{
		if (_iBrowserEnvironment != iOther)
		{
			if (_iBrowserEnvironment)
			{
				ICEHtmlBrowserEnvironment* tmp = _iBrowserEnvironment;
				_iBrowserEnvironment = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iBrowserEnvironment = const_cast<ICEHtmlBrowserEnvironment*>(iOther);
			if (_iBrowserEnvironment)
			{
				_iBrowserEnvironment->_vtbl->_addRef(_iBrowserEnvironment);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlBrowserEnvironment** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlBrowserEnvironmentRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iBrowserEnvironment && "has a com object reference. clear first.");
		return & _iBrowserEnvironment; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlBrowserEnvironmentRef& other)
	{
		bool result = false;
		if (_iBrowserEnvironment)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iBrowserEnvironment);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iBrowserEnvironment ? _iBrowserEnvironment->_vtbl->_queryInterface(_iBrowserEnvironment, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iBrowserEnvironment) { _iBrowserEnvironment->_vtbl->_addRef(_iBrowserEnvironment); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iBrowserEnvironment) { _iBrowserEnvironment->_vtbl->_release(_iBrowserEnvironment); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getPath(CEHtmlBrowserPath pathType, struct ICEFSPathname* *const iPathnameOut)	{ return _iBrowserEnvironment ? _iBrowserEnvironment->_vtbl->_getPath(_iBrowserEnvironment, pathType, iPathnameOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getService(const UINT32 iId, struct ICEUnknown* *const iUnknownOut)	{ return _iBrowserEnvironment ? _iBrowserEnvironment->_vtbl->_getService(_iBrowserEnvironment, iId, iUnknownOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getClassId(const UINT32 iId, UINT32 *const clsIdOut)	{ return _iBrowserEnvironment ? _iBrowserEnvironment->_vtbl->_getClassId(_iBrowserEnvironment, iId, clsIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getVendor(CEHtmlBrowserVendor vendorType, INT32 *const vendorIdOut)	{ return _iBrowserEnvironment ? _iBrowserEnvironment->_vtbl->_getVendor(_iBrowserEnvironment, vendorType, vendorIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyShutdown()	{ return _iBrowserEnvironment ? _iBrowserEnvironment->_vtbl->_notifyShutdown(_iBrowserEnvironment) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyResetFinished(CEHtmlResetOperation resetOperation, bool resetOccurred)	{ return _iBrowserEnvironment ? _iBrowserEnvironment->_vtbl->_notifyResetFinished(_iBrowserEnvironment, resetOperation, resetOccurred) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult askForReset(struct ICEHtmlFrameWindow* *const iFrameWindowOut)	{ return _iBrowserEnvironment ? _iBrowserEnvironment->_vtbl->_askForReset(_iBrowserEnvironment, iFrameWindowOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFocusNavigatorBehavior(UINT32 *const flagsOut)	{ return _iBrowserEnvironment ? _iBrowserEnvironment->_vtbl->_getFocusNavigatorBehavior(_iBrowserEnvironment, flagsOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFocusNavigationType(UINT32 *const flagsOut)	{ return _iBrowserEnvironment ? _iBrowserEnvironment->_vtbl->_getFocusNavigationType(_iBrowserEnvironment, flagsOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getErrorHandlingMode(UINT32 *const flagsOut)	{ return _iBrowserEnvironment ? _iBrowserEnvironment->_vtbl->_getErrorHandlingMode(_iBrowserEnvironment, flagsOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getSecureWarningPolicy(UINT32 *const flagsOut)	{ return _iBrowserEnvironment ? _iBrowserEnvironment->_vtbl->_getSecureWarningPolicy(_iBrowserEnvironment, flagsOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getImageStingyMode(CEHtmlImageStingyMode *const modeOut)	{ return _iBrowserEnvironment ? _iBrowserEnvironment->_vtbl->_getImageStingyMode(_iBrowserEnvironment, modeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getPluginThreadMode(CEHtmlPluginThreadMode *const modeOut)	{ return _iBrowserEnvironment ? _iBrowserEnvironment->_vtbl->_getPluginThreadMode(_iBrowserEnvironment, modeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTimeoutAccuracy(UINT32 *const accuracyMilliSecOut)	{ return _iBrowserEnvironment ? _iBrowserEnvironment->_vtbl->_getTimeoutAccuracy(_iBrowserEnvironment, accuracyMilliSecOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBrowserType(CEHtmlBrowserType* typeOut)	{ return _iBrowserEnvironment ? _iBrowserEnvironment->_vtbl->_getBrowserType(_iBrowserEnvironment, typeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getKeepAliveEnable(bool* enableOut)	{ return _iBrowserEnvironment ? _iBrowserEnvironment->_vtbl->_getKeepAliveEnable(_iBrowserEnvironment, enableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getEnablePlugin(bool* enableOut)	{ return _iBrowserEnvironment ? _iBrowserEnvironment->_vtbl->_getEnablePlugin(_iBrowserEnvironment, enableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyLowMemory()	{ return _iBrowserEnvironment ? _iBrowserEnvironment->_vtbl->_notifyLowMemory(_iBrowserEnvironment) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlBrowserEnvironment* _iBrowserEnvironment;
};

/*! @}
 * end of CEComICEHtmlBrowserEnvironmentRef
 */

#endif // __cplusplus

#endif
