///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEDXDithering_h
#define ICEDXDithering_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "CEImageType.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEDXDithering ICEDXDithering
 * @{
 */

/*!
 * ID of ICEDXDithering
 */
#define CEComIID_ICEDXDithering 0x5b3b9b0e


/*!
 * ICEDXDithering
 *
 * This is special interface for shoka.
 * Do not distribute except shoka.
 */
typedef struct ICEDXDithering
{
	const struct ICEDXDithering_vtbl* _vtbl;
} ICEDXDithering;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iDXDithering	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEDXDithering_queryInterface) (ICEDXDithering* iDXDithering, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDXDithering_addRef) (ICEDXDithering* iDXDithering);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDXDithering_release) (ICEDXDithering* iDXDithering);

typedef CEHResult (*iCEDXDithering_dither) (ICEDXDithering* iDXDithering, void* src, void* dst, INT32 src_width, INT32 src_height, INT32 src_pitch, INT32 dst_width, INT32 dst_height, INT32 dst_pitch, CEPixelFormat pixelFormat, eCECompressImageFormat imageFormat);

/*!
 * V-table of ICEDXDithering
 */
struct ICEDXDithering_vtbl
{
	iCEDXDithering_queryInterface	_queryInterface;	//!< Query interface.
	iCEDXDithering_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEDXDithering_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEDXDithering_dither	_dither;
};

/*! @}
 * end of ICEDXDithering
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEDXDitheringRef CEComICEDXDitheringRef
 * @{
 */

class CEComICEDXDitheringRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEDXDitheringRef() : _iDXDithering(0) {}
	CEComICEDXDitheringRef(ICEDXDithering* iOther) : _iDXDithering(0)
	{
		if (iOther)
		{
			_iDXDithering = iOther;
			_iDXDithering->_vtbl->_addRef(_iDXDithering);
		}
	}

	CEComICEDXDitheringRef(const CEComICEDXDitheringRef& other) : _iDXDithering(0)
	{
		if (other._iDXDithering)
		{
			_iDXDithering = other._iDXDithering;
			_iDXDithering->_vtbl->_addRef(_iDXDithering);
		}
	}

	~CEComICEDXDitheringRef()
	{
		if (_iDXDithering)
		{
			ICEDXDithering* tmp = _iDXDithering;
			_iDXDithering = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEDXDithering* iDXDithering;
				void* _ptr;
			} uIntf;
			uIntf.iDXDithering = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEDXDithering, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iDXDithering)
				{
					ICEDXDithering* tmp = _iDXDithering;
					_iDXDithering = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iDXDithering = uIntf.iDXDithering;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEDXDithering* object() const	{ return _iDXDithering; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEDXDithering* iOther)
	{
		if (_iDXDithering)
		{
			ICEDXDithering* tmp = _iDXDithering;
			_iDXDithering = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iDXDithering = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEDXDithering* detach()
	{
		ICEDXDithering* iIntf = _iDXDithering;
		_iDXDithering = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEDXDithering* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iDXDithering;
		if (_iDXDithering)
		{
			_iDXDithering->_vtbl->_addRef(_iDXDithering);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEDXDithering*() const	{ return _iDXDithering; }
	FORCEINLINE_WITHOUT_DEBUG ICEDXDithering& operator*() const	{ return *_iDXDithering; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iDXDithering == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEDXDithering* iOther) const	{ return (_iDXDithering != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEDXDithering* iOther) const	{ return (_iDXDithering == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEDXDitheringRef& operator=(const CEComICEDXDitheringRef& other)	{ return operator=(other._iDXDithering); }

	CEComICEDXDitheringRef& operator=(const ICEDXDithering* iOther)
	{
		if (_iDXDithering != iOther)
		{
			if (_iDXDithering)
			{
				ICEDXDithering* tmp = _iDXDithering;
				_iDXDithering = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iDXDithering = const_cast<ICEDXDithering*>(iOther);
			if (_iDXDithering)
			{
				_iDXDithering->_vtbl->_addRef(_iDXDithering);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEDXDithering** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEDXDitheringRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iDXDithering && "has a com object reference. clear first.");
		return & _iDXDithering; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEDXDitheringRef& other)
	{
		bool result = false;
		if (_iDXDithering)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iDXDithering);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iDXDithering ? _iDXDithering->_vtbl->_queryInterface(_iDXDithering, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iDXDithering) { _iDXDithering->_vtbl->_addRef(_iDXDithering); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iDXDithering) { _iDXDithering->_vtbl->_release(_iDXDithering); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult dither(void* src, void* dst, INT32 src_width, INT32 src_height, INT32 src_pitch, INT32 dst_width, INT32 dst_height, INT32 dst_pitch, CEPixelFormat pixelFormat, eCECompressImageFormat imageFormat)	{ return _iDXDithering ? _iDXDithering->_vtbl->_dither(_iDXDithering, src, dst, src_width, src_height, src_pitch, dst_width, dst_height, dst_pitch, pixelFormat, imageFormat) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEDXDithering* _iDXDithering;
};

/*! @}
 * end of CEComICEDXDitheringRef
 */

#endif // __cplusplus

#endif
