///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEApartment_h
#define ICEApartment_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CECom.h"
#include "CEApiUnknown.h"
#include "ceusync.h"
#include "CEComAtomicSupport.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------

struct ICEApartmentMessage;

//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEApartmentTransferHandler ICEApartmentTransferHandler
 * @{
 */

/*!
 * ID of ICEApartmentTransferHandler
 */
#define CEComIID_ICEApartmentTransferHandler 0xc97cd47e

/*!
 * ICEApartmentTransferHandler
 */
typedef struct ICEApartmentTransferHandler
{
	const struct ICEApartmentTransferHandler_vtbl* _vtbl;
} ICEApartmentTransferHandler;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iApartmentTransferHandler	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEApartmentTransferHandler_queryInterface) (ICEApartmentTransferHandler* iApartmentTransferHandler, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEApartmentTransferHandler_addRef) (ICEApartmentTransferHandler* iApartmentTransferHandler);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEApartmentTransferHandler_release) (ICEApartmentTransferHandler* iApartmentTransferHandler);

typedef CEHResult (*iCEApartmentTransferHandler_preTransfer) (ICEApartmentTransferHandler* iApartmentTransferHandler, struct ICEApartment* iFromApartment, struct ICEApartment* iToApartment);

typedef CEHResult (*iCEApartmentTransferHandler_postTransfer) (ICEApartmentTransferHandler* iApartmentTransferHandler, struct ICEApartment* iFromApartment, struct ICEApartment* iToApartment);

/*!
 * V-table of ICEApartmentTransferHandler
 */
struct ICEApartmentTransferHandler_vtbl
{
	iCEApartmentTransferHandler_queryInterface	_queryInterface;	//!< Query interface.
	iCEApartmentTransferHandler_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEApartmentTransferHandler_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEApartmentTransferHandler_preTransfer	_preTransfer;
	iCEApartmentTransferHandler_postTransfer	_postTransfer;
};

/*! @}
 * end of ICEApartmentTransferHandler
 */

/*! \defgroup ICEApartmentSupport ICEApartmentSupport
 * @{
 */

/*!
 * ID of ICEApartmentSupport
 */
#define CEComIID_ICEApartmentSupport 0x961be381

/*!
 * ICEApartmentSupport
 */
typedef struct ICEApartmentSupport
{
	const struct ICEApartmentSupport_vtbl* _vtbl;
} ICEApartmentSupport;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iApartmentSupport	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEApartmentSupport_queryInterface) (ICEApartmentSupport* iApartmentSupport, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEApartmentSupport_addRef) (ICEApartmentSupport* iApartmentSupport);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEApartmentSupport_release) (ICEApartmentSupport* iApartmentSupport);

typedef CEHResult (*iCEApartmentSupport_init) (ICEApartmentSupport* iApartmentSupport);

typedef CEHResult (*iCEApartmentSupport_shutdown) (ICEApartmentSupport* iApartmentSupport);

typedef CEHResult (*iCEApartmentSupport_createSemaphore) (ICEApartmentSupport* iApartmentSupport, CEUSemaphoreRef *const semaphoreOut);

typedef CEHResult (*iCEApartmentSupport_destroySemaphore) (ICEApartmentSupport* iApartmentSupport, CEUSemaphoreRef semaphore);

/*!
 * V-table of ICEApartmentSupport
 */
struct ICEApartmentSupport_vtbl
{
	iCEApartmentSupport_queryInterface	_queryInterface;	//!< Query interface.
	iCEApartmentSupport_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEApartmentSupport_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEApartmentSupport_init	_init;
	iCEApartmentSupport_shutdown	_shutdown;
	iCEApartmentSupport_createSemaphore	_createSemaphore;
	iCEApartmentSupport_destroySemaphore	_destroySemaphore;
};

/*! @}
 * end of ICEApartmentSupport
 */

/*! \defgroup ICEApartment ICEApartment
 * @{
 */

/*!
 * ID of ICEApartment
 */
#define CEComIID_ICEApartment 0xb70df812


/*!
* ICEApartment
*/
typedef struct ICEApartment
{
	const struct ICEApartment_vtbl* _vtbl;
} ICEApartment;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iApartment	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEApartment_queryInterface) (ICEApartment* iApartment, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEApartment_addRef) (ICEApartment* iApartment);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEApartment_release) (ICEApartment* iApartment);

typedef CEHResult (*iCEApartment_getApartmentSupport) (ICEApartment* iApartment, struct ICEApartmentSupport* *const iApartmentSupportOut);

typedef CEHResult (*iCEApartment_setApartmentSupport) (ICEApartment* iApartment, struct ICEApartmentSupport* iApartmentSupport);

typedef CEHResult (*iCEApartment_pushPendingMessage) (ICEApartment* iApartment, struct ICEApartmentMessage* iMessage);

typedef CEHResult (*iCEApartment_popPendingMessage) (ICEApartment* iApartment, struct ICEApartmentMessage* iMessage);

typedef CEHResult (*iCEApartment_getPendingMessage) (ICEApartment* iApartment, struct ICEApartmentMessage* *const iMessageOut);


/*!    
 * only for debug....
 */

typedef CEHResult (*iCEApartment_startLog) (ICEApartment* iApartment);

typedef CEHResult (*iCEApartment_stopLog) (ICEApartment* iApartment);

typedef CEHResult (*iCEApartment_log) (ICEApartment* iApartment, const char* info, UINT32 charLenInByte, UINT64 performanceCount);

/*!
 * V-table of ICEApartment
 */
struct ICEApartment_vtbl
{
	iCEApartment_queryInterface	_queryInterface;	//!< Query interface.
	iCEApartment_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEApartment_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEApartment_getApartmentSupport	_getApartmentSupport;
	iCEApartment_setApartmentSupport	_setApartmentSupport;
	iCEApartment_pushPendingMessage	_pushPendingMessage;
	iCEApartment_popPendingMessage	_popPendingMessage;
	iCEApartment_getPendingMessage	_getPendingMessage;
	iCEApartment_startLog	_startLog;
	iCEApartment_stopLog	_stopLog;
	iCEApartment_log	_log;
};

/*! @}
 * end of ICEApartment
 */

/*! \defgroup ICEHeartbeat ICEHeartbeat
 * @{
 */

/*!
 * ID of ICEHeartbeat
 */
#define CEComIID_ICEHeartbeat 0xa32a2eef

/*!
 * ICEHeartbeat
 */
typedef struct ICEHeartbeat
{
	const struct ICEHeartbeat_vtbl* _vtbl;
} ICEHeartbeat;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iHeartbeat	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHeartbeat_queryInterface) (ICEHeartbeat* iHeartbeat, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHeartbeat_addRef) (ICEHeartbeat* iHeartbeat);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHeartbeat_release) (ICEHeartbeat* iHeartbeat);

typedef CEHResult (*iCEHeartbeat_heartbeat) (ICEHeartbeat* iHeartbeat);

/*!
 * V-table of ICEHeartbeat
 */
struct ICEHeartbeat_vtbl
{
	iCEHeartbeat_queryInterface	_queryInterface;	//!< Query interface.
	iCEHeartbeat_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHeartbeat_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHeartbeat_heartbeat	_heartbeat;
};

/*! @}
 * end of ICEHeartbeat
 */

/*! \defgroup ICENeutralApartment ICENeutralApartment
 * @{
 */

/*!
 * ID of ICENeutralApartment
 */
#define CEComIID_ICENeutralApartment 0x4ebd8a0e

/*!
 * ICENeutralApartment
 */
typedef struct ICENeutralApartment
{
	const struct ICENeutralApartment_vtbl* _vtbl;
} ICENeutralApartment;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iNeutralApartment	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCENeutralApartment_queryInterface) (ICENeutralApartment* iNeutralApartment, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCENeutralApartment_addRef) (ICENeutralApartment* iNeutralApartment);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCENeutralApartment_release) (ICENeutralApartment* iNeutralApartment);

typedef CEHResult (*iCENeutralApartment_getApartmentSupport) (ICENeutralApartment* iNeutralApartment, struct ICEApartmentSupport* *const iApartmentSupportOut);

typedef CEHResult (*iCENeutralApartment_setApartmentSupport) (ICENeutralApartment* iNeutralApartment, struct ICEApartmentSupport* iApartmentSupport);

typedef CEHResult (*iCENeutralApartment_pushPendingMessage) (ICENeutralApartment* iNeutralApartment, struct ICEApartmentMessage* iMessage);

typedef CEHResult (*iCENeutralApartment_popPendingMessage) (ICENeutralApartment* iNeutralApartment, struct ICEApartmentMessage* iMessage);

typedef CEHResult (*iCENeutralApartment_getPendingMessage) (ICENeutralApartment* iNeutralApartment, struct ICEApartmentMessage* *const iMessageOut);


/*!    
 * only for debug....
 */

typedef CEHResult (*iCENeutralApartment_startLog) (ICENeutralApartment* iNeutralApartment);

typedef CEHResult (*iCENeutralApartment_stopLog) (ICENeutralApartment* iNeutralApartment);

typedef CEHResult (*iCENeutralApartment_log) (ICENeutralApartment* iNeutralApartment, const char* info, UINT32 charLenInByte, UINT64 performanceCount);

typedef CEHResult (*iCENeutralApartment_heartbeat) (ICENeutralApartment* iNeutralApartment);

typedef CEHResult (*iCENeutralApartment_setHeartbeat) (ICENeutralApartment* iNeutralApartment, struct ICEHeartbeat* iHeartbeat);

/*!
 * V-table of ICENeutralApartment
 */
struct ICENeutralApartment_vtbl
{
	iCENeutralApartment_queryInterface	_queryInterface;	//!< Query interface.
	iCENeutralApartment_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCENeutralApartment_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCENeutralApartment_getApartmentSupport	_getApartmentSupport;
	iCENeutralApartment_setApartmentSupport	_setApartmentSupport;
	iCENeutralApartment_pushPendingMessage	_pushPendingMessage;
	iCENeutralApartment_popPendingMessage	_popPendingMessage;
	iCENeutralApartment_getPendingMessage	_getPendingMessage;
	iCENeutralApartment_startLog	_startLog;
	iCENeutralApartment_stopLog	_stopLog;
	iCENeutralApartment_log	_log;
	iCENeutralApartment_heartbeat	_heartbeat;
	iCENeutralApartment_setHeartbeat	_setHeartbeat;
};

/*! @}
 * end of ICENeutralApartment
 */

/*! \defgroup ICEApartmentMessagePostHandler ICEApartmentMessagePostHandler
 * @{
 */

/*!
 * ID of ICEApartmentMessagePostHandler
 */
#define CEComIID_ICEApartmentMessagePostHandler 0x209e4f0e

/*!
 * ICEApartmentMessagePostHandler
 */
typedef struct ICEApartmentMessagePostHandler
{
	const struct ICEApartmentMessagePostHandler_vtbl* _vtbl;
} ICEApartmentMessagePostHandler;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iApartmentMessagePostHandler	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEApartmentMessagePostHandler_queryInterface) (ICEApartmentMessagePostHandler* iApartmentMessagePostHandler, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEApartmentMessagePostHandler_addRef) (ICEApartmentMessagePostHandler* iApartmentMessagePostHandler);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEApartmentMessagePostHandler_release) (ICEApartmentMessagePostHandler* iApartmentMessagePostHandler);

typedef CEHResult (*iCEApartmentMessagePostHandler_onPostMessage) (ICEApartmentMessagePostHandler* iApartmentMessagePostHandler);

typedef CEHResult (*iCEApartmentMessagePostHandler_pushMessageSemaphore) (ICEApartmentMessagePostHandler* iApartmentMessagePostHandler, CEUSemaphoreRef semaphore);

typedef CEHResult (*iCEApartmentMessagePostHandler_popMessageSemaphore) (ICEApartmentMessagePostHandler* iApartmentMessagePostHandler, CEUSemaphoreRef semaphore);

typedef CEHResult (*iCEApartmentMessagePostHandler_waitMessageSemaphore) (ICEApartmentMessagePostHandler* iApartmentMessagePostHandler, UINT32 timeoutMilliSeconds);

/*!
 * V-table of ICEApartmentMessagePostHandler
 */
struct ICEApartmentMessagePostHandler_vtbl
{
	iCEApartmentMessagePostHandler_queryInterface	_queryInterface;	//!< Query interface.
	iCEApartmentMessagePostHandler_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEApartmentMessagePostHandler_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEApartmentMessagePostHandler_onPostMessage	_onPostMessage;
	iCEApartmentMessagePostHandler_pushMessageSemaphore	_pushMessageSemaphore;
	iCEApartmentMessagePostHandler_popMessageSemaphore	_popMessageSemaphore;
	iCEApartmentMessagePostHandler_waitMessageSemaphore	_waitMessageSemaphore;
};

/*! @}
 * end of ICEApartmentMessagePostHandler
 */

/*! \defgroup ICEApartmentMessage ICEApartmentMessage
 * @{
 */

/*!
 * ID of ICEApartmentMessage
 */
#define CEComIID_ICEApartmentMessage 0xa816d96c

/*!
 * ICEApartmentMessage
 */
typedef struct ICEApartmentMessage
{
	const struct ICEApartmentMessage_vtbl* _vtbl;
} ICEApartmentMessage;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iApartmentMessage	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEApartmentMessage_queryInterface) (ICEApartmentMessage* iApartmentMessage, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEApartmentMessage_addRef) (ICEApartmentMessage* iApartmentMessage);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEApartmentMessage_release) (ICEApartmentMessage* iApartmentMessage);

typedef CEHResult (*iCEApartmentMessage_invokeSelf) (ICEApartmentMessage* iApartmentMessage);

typedef CEHResult (*iCEApartmentMessage_retry) (ICEApartmentMessage* iApartmentMessage, INT32 usec);

typedef CEHResult (*iCEApartmentMessage_retryRequested) (ICEApartmentMessage* iApartmentMessage, INT32 *const usecOut);

typedef CEHResult (*iCEApartmentMessage_wait) (ICEApartmentMessage* iApartmentMessage, UINT32 timeoutMilliSeconds);

typedef CEHResult (*iCEApartmentMessage_post) (ICEApartmentMessage* iApartmentMessage);

typedef CEHResult (*iCEApartmentMessage_getResult) (ICEApartmentMessage* iApartmentMessage, CEHResult *const errOut);

typedef CEHResult (*iCEApartmentMessage_notifyDefered) (ICEApartmentMessage* iApartmentMessage);

typedef CEHResult (*iCEApartmentMessage_deferedPost) (ICEApartmentMessage* iApartmentMessage);

typedef CEHResult (*iCEApartmentMessage_getParam) (ICEApartmentMessage* iApartmentMessage, void* *const paramOut);

typedef CEHResult (*iCEApartmentMessage_getConsumingCount) (ICEApartmentMessage* iApartmentMessage, CEATOMIC** consumingCountOut);

typedef CEHResult (*iCEApartmentMessage_notifyDepended) (ICEApartmentMessage* iApartmentMessage);

/*!
 * V-table of ICEApartmentMessage
 */
struct ICEApartmentMessage_vtbl
{
	iCEApartmentMessage_queryInterface	_queryInterface;	//!< Query interface.
	iCEApartmentMessage_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEApartmentMessage_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEApartmentMessage_invokeSelf	_invokeSelf;
	iCEApartmentMessage_retry	_retry;
	iCEApartmentMessage_retryRequested	_retryRequested;
	iCEApartmentMessage_wait	_wait;
	iCEApartmentMessage_post	_post;
	iCEApartmentMessage_getResult	_getResult;
	iCEApartmentMessage_notifyDefered	_notifyDefered;
	iCEApartmentMessage_deferedPost	_deferedPost;
	iCEApartmentMessage_getParam	_getParam;
	iCEApartmentMessage_getConsumingCount	_getConsumingCount;
	iCEApartmentMessage_notifyDepended	_notifyDepended;
};

/*! @}
 * end of ICEApartmentMessage
 */

/*! \defgroup ICEThreadOwnerApartment ICEThreadOwnerApartment
 * @{
 */

/*!
 * ID of ICEThreadOwnerApartment
 */
#define CEComIID_ICEThreadOwnerApartment 0x410b42d0

/*!
 * ICEThreadOwnerApartment
 */
typedef struct ICEThreadOwnerApartment
{
	const struct ICEThreadOwnerApartment_vtbl* _vtbl;
} ICEThreadOwnerApartment;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iThreadOwnerApartment	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEThreadOwnerApartment_queryInterface) (ICEThreadOwnerApartment* iThreadOwnerApartment, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEThreadOwnerApartment_addRef) (ICEThreadOwnerApartment* iThreadOwnerApartment);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEThreadOwnerApartment_release) (ICEThreadOwnerApartment* iThreadOwnerApartment);

typedef CEHResult (*iCEThreadOwnerApartment_getApartmentSupport) (ICEThreadOwnerApartment* iThreadOwnerApartment, struct ICEApartmentSupport* *const iApartmentSupportOut);

typedef CEHResult (*iCEThreadOwnerApartment_setApartmentSupport) (ICEThreadOwnerApartment* iThreadOwnerApartment, struct ICEApartmentSupport* iApartmentSupport);

typedef CEHResult (*iCEThreadOwnerApartment_pushPendingMessage) (ICEThreadOwnerApartment* iThreadOwnerApartment, struct ICEApartmentMessage* iMessage);

typedef CEHResult (*iCEThreadOwnerApartment_popPendingMessage) (ICEThreadOwnerApartment* iThreadOwnerApartment, struct ICEApartmentMessage* iMessage);

typedef CEHResult (*iCEThreadOwnerApartment_getPendingMessage) (ICEThreadOwnerApartment* iThreadOwnerApartment, struct ICEApartmentMessage* *const iMessageOut);


/*!    
 * only for debug....
 */

typedef CEHResult (*iCEThreadOwnerApartment_startLog) (ICEThreadOwnerApartment* iThreadOwnerApartment);

typedef CEHResult (*iCEThreadOwnerApartment_stopLog) (ICEThreadOwnerApartment* iThreadOwnerApartment);

typedef CEHResult (*iCEThreadOwnerApartment_log) (ICEThreadOwnerApartment* iThreadOwnerApartment, const char* info, UINT32 charLenInByte, UINT64 performanceCount);

typedef CEHResult (*iCEThreadOwnerApartment_setMessagePostHandler) (ICEThreadOwnerApartment* iThreadOwnerApartment, struct ICEApartmentMessagePostHandler* handler);

typedef CEHResult (*iCEThreadOwnerApartment_postMessage) (ICEThreadOwnerApartment* iThreadOwnerApartment, struct ICEApartment* callerApartment, UINT32 mid, void* param, void* userData, invoke_message_callback callback);

typedef CEHResult (*iCEThreadOwnerApartment_heartbeat) (ICEThreadOwnerApartment* iThreadOwnerApartment);

typedef CEHResult (*iCEThreadOwnerApartment_hasMessage) (ICEThreadOwnerApartment* iThreadOwnerApartment, bool* hasMessageOut);

typedef CEHResult (*iCEThreadOwnerApartment_getNumPendingMessages) (ICEThreadOwnerApartment* iThreadOwnerApartment, INT32* numOut);

typedef CEHResult (*iCEThreadOwnerApartment_getCurrentMessage) (ICEThreadOwnerApartment* iThreadOwnerApartment, struct ICEApartmentMessage* *const iMesageOut);

typedef CEHResult (*iCEThreadOwnerApartment_pushMessageSemaphore) (ICEThreadOwnerApartment* iThreadOwnerApartment, CEUSemaphoreRef semaphore);

typedef CEHResult (*iCEThreadOwnerApartment_popMessageSemaphore) (ICEThreadOwnerApartment* iThreadOwnerApartment, CEUSemaphoreRef semaphore);

typedef CEHResult (*iCEThreadOwnerApartment_waitMessageSemaphore) (ICEThreadOwnerApartment* iThreadOwnerApartment, UINT32 timeoutMilliSeconds);

/*!
 * V-table of ICEThreadOwnerApartment
 */
struct ICEThreadOwnerApartment_vtbl
{
	iCEThreadOwnerApartment_queryInterface	_queryInterface;	//!< Query interface.
	iCEThreadOwnerApartment_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEThreadOwnerApartment_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEThreadOwnerApartment_getApartmentSupport	_getApartmentSupport;
	iCEThreadOwnerApartment_setApartmentSupport	_setApartmentSupport;
	iCEThreadOwnerApartment_pushPendingMessage	_pushPendingMessage;
	iCEThreadOwnerApartment_popPendingMessage	_popPendingMessage;
	iCEThreadOwnerApartment_getPendingMessage	_getPendingMessage;
	iCEThreadOwnerApartment_startLog	_startLog;
	iCEThreadOwnerApartment_stopLog	_stopLog;
	iCEThreadOwnerApartment_log	_log;
	iCEThreadOwnerApartment_setMessagePostHandler	_setMessagePostHandler;
	iCEThreadOwnerApartment_postMessage	_postMessage;
	iCEThreadOwnerApartment_heartbeat	_heartbeat;
	iCEThreadOwnerApartment_hasMessage	_hasMessage;
	iCEThreadOwnerApartment_getNumPendingMessages	_getNumPendingMessages;
	iCEThreadOwnerApartment_getCurrentMessage	_getCurrentMessage;
	iCEThreadOwnerApartment_pushMessageSemaphore	_pushMessageSemaphore;
	iCEThreadOwnerApartment_popMessageSemaphore	_popMessageSemaphore;
	iCEThreadOwnerApartment_waitMessageSemaphore	_waitMessageSemaphore;
};

/*! @}
 * end of ICEThreadOwnerApartment
 */

/*! \defgroup ICESingleThreadApartment ICESingleThreadApartment
 * @{
 */

/*!
 * ID of ICESingleThreadApartment
 */
#define CEComIID_ICESingleThreadApartment 0xea9cb9ad

/*!
 * ICESingleThreadApartment
 */
typedef struct ICESingleThreadApartment
{
	const struct ICESingleThreadApartment_vtbl* _vtbl;
} ICESingleThreadApartment;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iSingleThreadApartment	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCESingleThreadApartment_queryInterface) (ICESingleThreadApartment* iSingleThreadApartment, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCESingleThreadApartment_addRef) (ICESingleThreadApartment* iSingleThreadApartment);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCESingleThreadApartment_release) (ICESingleThreadApartment* iSingleThreadApartment);

typedef CEHResult (*iCESingleThreadApartment_getApartmentSupport) (ICESingleThreadApartment* iSingleThreadApartment, struct ICEApartmentSupport* *const iApartmentSupportOut);

typedef CEHResult (*iCESingleThreadApartment_setApartmentSupport) (ICESingleThreadApartment* iSingleThreadApartment, struct ICEApartmentSupport* iApartmentSupport);

typedef CEHResult (*iCESingleThreadApartment_pushPendingMessage) (ICESingleThreadApartment* iSingleThreadApartment, struct ICEApartmentMessage* iMessage);

typedef CEHResult (*iCESingleThreadApartment_popPendingMessage) (ICESingleThreadApartment* iSingleThreadApartment, struct ICEApartmentMessage* iMessage);

typedef CEHResult (*iCESingleThreadApartment_getPendingMessage) (ICESingleThreadApartment* iSingleThreadApartment, struct ICEApartmentMessage* *const iMessageOut);


/*!    
 * only for debug....
 */

typedef CEHResult (*iCESingleThreadApartment_startLog) (ICESingleThreadApartment* iSingleThreadApartment);

typedef CEHResult (*iCESingleThreadApartment_stopLog) (ICESingleThreadApartment* iSingleThreadApartment);

typedef CEHResult (*iCESingleThreadApartment_log) (ICESingleThreadApartment* iSingleThreadApartment, const char* info, UINT32 charLenInByte, UINT64 performanceCount);

typedef CEHResult (*iCESingleThreadApartment_setMessagePostHandler) (ICESingleThreadApartment* iSingleThreadApartment, struct ICEApartmentMessagePostHandler* handler);

typedef CEHResult (*iCESingleThreadApartment_postMessage) (ICESingleThreadApartment* iSingleThreadApartment, struct ICEApartment* callerApartment, UINT32 mid, void* param, void* userData, invoke_message_callback callback);

typedef CEHResult (*iCESingleThreadApartment_heartbeat) (ICESingleThreadApartment* iSingleThreadApartment);

typedef CEHResult (*iCESingleThreadApartment_hasMessage) (ICESingleThreadApartment* iSingleThreadApartment, bool* hasMessageOut);

typedef CEHResult (*iCESingleThreadApartment_getNumPendingMessages) (ICESingleThreadApartment* iSingleThreadApartment, INT32* numOut);

typedef CEHResult (*iCESingleThreadApartment_getCurrentMessage) (ICESingleThreadApartment* iSingleThreadApartment, struct ICEApartmentMessage* *const iMesageOut);

typedef CEHResult (*iCESingleThreadApartment_pushMessageSemaphore) (ICESingleThreadApartment* iSingleThreadApartment, CEUSemaphoreRef semaphore);

typedef CEHResult (*iCESingleThreadApartment_popMessageSemaphore) (ICESingleThreadApartment* iSingleThreadApartment, CEUSemaphoreRef semaphore);

typedef CEHResult (*iCESingleThreadApartment_waitMessageSemaphore) (ICESingleThreadApartment* iSingleThreadApartment, UINT32 timeoutMilliSeconds);

/*!
 * V-table of ICESingleThreadApartment
 */
struct ICESingleThreadApartment_vtbl
{
	iCESingleThreadApartment_queryInterface	_queryInterface;	//!< Query interface.
	iCESingleThreadApartment_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCESingleThreadApartment_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCESingleThreadApartment_getApartmentSupport	_getApartmentSupport;
	iCESingleThreadApartment_setApartmentSupport	_setApartmentSupport;
	iCESingleThreadApartment_pushPendingMessage	_pushPendingMessage;
	iCESingleThreadApartment_popPendingMessage	_popPendingMessage;
	iCESingleThreadApartment_getPendingMessage	_getPendingMessage;
	iCESingleThreadApartment_startLog	_startLog;
	iCESingleThreadApartment_stopLog	_stopLog;
	iCESingleThreadApartment_log	_log;
	iCESingleThreadApartment_setMessagePostHandler	_setMessagePostHandler;
	iCESingleThreadApartment_postMessage	_postMessage;
	iCESingleThreadApartment_heartbeat	_heartbeat;
	iCESingleThreadApartment_hasMessage	_hasMessage;
	iCESingleThreadApartment_getNumPendingMessages	_getNumPendingMessages;
	iCESingleThreadApartment_getCurrentMessage	_getCurrentMessage;
	iCESingleThreadApartment_pushMessageSemaphore	_pushMessageSemaphore;
	iCESingleThreadApartment_popMessageSemaphore	_popMessageSemaphore;
	iCESingleThreadApartment_waitMessageSemaphore	_waitMessageSemaphore;
};

/*! @}
 * end of ICESingleThreadApartment
 */

/*! \defgroup ICEMultiThreadApartment ICEMultiThreadApartment
 * @{
 */

/*!
 * ID of ICEMultiThreadApartment
 */
#define CEComIID_ICEMultiThreadApartment 0x96e80c90

/*!
 * ICEMultiThreadApartment
 */
typedef struct ICEMultiThreadApartment
{
	const struct ICEMultiThreadApartment_vtbl* _vtbl;
} ICEMultiThreadApartment;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iMultiThreadApartment	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEMultiThreadApartment_queryInterface) (ICEMultiThreadApartment* iMultiThreadApartment, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEMultiThreadApartment_addRef) (ICEMultiThreadApartment* iMultiThreadApartment);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEMultiThreadApartment_release) (ICEMultiThreadApartment* iMultiThreadApartment);

typedef CEHResult (*iCEMultiThreadApartment_getApartmentSupport) (ICEMultiThreadApartment* iMultiThreadApartment, struct ICEApartmentSupport* *const iApartmentSupportOut);

typedef CEHResult (*iCEMultiThreadApartment_setApartmentSupport) (ICEMultiThreadApartment* iMultiThreadApartment, struct ICEApartmentSupport* iApartmentSupport);

typedef CEHResult (*iCEMultiThreadApartment_pushPendingMessage) (ICEMultiThreadApartment* iMultiThreadApartment, struct ICEApartmentMessage* iMessage);

typedef CEHResult (*iCEMultiThreadApartment_popPendingMessage) (ICEMultiThreadApartment* iMultiThreadApartment, struct ICEApartmentMessage* iMessage);

typedef CEHResult (*iCEMultiThreadApartment_getPendingMessage) (ICEMultiThreadApartment* iMultiThreadApartment, struct ICEApartmentMessage* *const iMessageOut);


/*!    
 * only for debug....
 */

typedef CEHResult (*iCEMultiThreadApartment_startLog) (ICEMultiThreadApartment* iMultiThreadApartment);

typedef CEHResult (*iCEMultiThreadApartment_stopLog) (ICEMultiThreadApartment* iMultiThreadApartment);

typedef CEHResult (*iCEMultiThreadApartment_log) (ICEMultiThreadApartment* iMultiThreadApartment, const char* info, UINT32 charLenInByte, UINT64 performanceCount);

typedef CEHResult (*iCEMultiThreadApartment_setMessagePostHandler) (ICEMultiThreadApartment* iMultiThreadApartment, struct ICEApartmentMessagePostHandler* handler);

typedef CEHResult (*iCEMultiThreadApartment_postMessage) (ICEMultiThreadApartment* iMultiThreadApartment, struct ICEApartment* callerApartment, UINT32 mid, void* param, void* userData, invoke_message_callback callback);

typedef CEHResult (*iCEMultiThreadApartment_heartbeat) (ICEMultiThreadApartment* iMultiThreadApartment);

typedef CEHResult (*iCEMultiThreadApartment_hasMessage) (ICEMultiThreadApartment* iMultiThreadApartment, bool* hasMessageOut);

typedef CEHResult (*iCEMultiThreadApartment_getNumPendingMessages) (ICEMultiThreadApartment* iMultiThreadApartment, INT32* numOut);

typedef CEHResult (*iCEMultiThreadApartment_getCurrentMessage) (ICEMultiThreadApartment* iMultiThreadApartment, struct ICEApartmentMessage* *const iMesageOut);

typedef CEHResult (*iCEMultiThreadApartment_pushMessageSemaphore) (ICEMultiThreadApartment* iMultiThreadApartment, CEUSemaphoreRef semaphore);

typedef CEHResult (*iCEMultiThreadApartment_popMessageSemaphore) (ICEMultiThreadApartment* iMultiThreadApartment, CEUSemaphoreRef semaphore);

typedef CEHResult (*iCEMultiThreadApartment_waitMessageSemaphore) (ICEMultiThreadApartment* iMultiThreadApartment, UINT32 timeoutMilliSeconds);

/*!
 * V-table of ICEMultiThreadApartment
 */
struct ICEMultiThreadApartment_vtbl
{
	iCEMultiThreadApartment_queryInterface	_queryInterface;	//!< Query interface.
	iCEMultiThreadApartment_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEMultiThreadApartment_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEMultiThreadApartment_getApartmentSupport	_getApartmentSupport;
	iCEMultiThreadApartment_setApartmentSupport	_setApartmentSupport;
	iCEMultiThreadApartment_pushPendingMessage	_pushPendingMessage;
	iCEMultiThreadApartment_popPendingMessage	_popPendingMessage;
	iCEMultiThreadApartment_getPendingMessage	_getPendingMessage;
	iCEMultiThreadApartment_startLog	_startLog;
	iCEMultiThreadApartment_stopLog	_stopLog;
	iCEMultiThreadApartment_log	_log;
	iCEMultiThreadApartment_setMessagePostHandler	_setMessagePostHandler;
	iCEMultiThreadApartment_postMessage	_postMessage;
	iCEMultiThreadApartment_heartbeat	_heartbeat;
	iCEMultiThreadApartment_hasMessage	_hasMessage;
	iCEMultiThreadApartment_getNumPendingMessages	_getNumPendingMessages;
	iCEMultiThreadApartment_getCurrentMessage	_getCurrentMessage;
	iCEMultiThreadApartment_pushMessageSemaphore	_pushMessageSemaphore;
	iCEMultiThreadApartment_popMessageSemaphore	_popMessageSemaphore;
	iCEMultiThreadApartment_waitMessageSemaphore	_waitMessageSemaphore;
};

/*! @}
 * end of ICEMultiThreadApartment
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEApartmentTransferHandlerRef CEComICEApartmentTransferHandlerRef
 * @{
 */

class CEComICEApartmentTransferHandlerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEApartmentTransferHandlerRef() : _iApartmentTransferHandler(0) {}
	CEComICEApartmentTransferHandlerRef(ICEApartmentTransferHandler* iOther) : _iApartmentTransferHandler(0)
	{
		if (iOther)
		{
			_iApartmentTransferHandler = iOther;
			_iApartmentTransferHandler->_vtbl->_addRef(_iApartmentTransferHandler);
		}
	}

	CEComICEApartmentTransferHandlerRef(const CEComICEApartmentTransferHandlerRef& other) : _iApartmentTransferHandler(0)
	{
		if (other._iApartmentTransferHandler)
		{
			_iApartmentTransferHandler = other._iApartmentTransferHandler;
			_iApartmentTransferHandler->_vtbl->_addRef(_iApartmentTransferHandler);
		}
	}

	~CEComICEApartmentTransferHandlerRef()
	{
		if (_iApartmentTransferHandler)
		{
			ICEApartmentTransferHandler* tmp = _iApartmentTransferHandler;
			_iApartmentTransferHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEApartmentTransferHandler* iApartmentTransferHandler;
				void* _ptr;
			} uIntf;
			uIntf.iApartmentTransferHandler = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEApartmentTransferHandler, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iApartmentTransferHandler)
				{
					ICEApartmentTransferHandler* tmp = _iApartmentTransferHandler;
					_iApartmentTransferHandler = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iApartmentTransferHandler = uIntf.iApartmentTransferHandler;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEApartmentTransferHandler* object() const	{ return _iApartmentTransferHandler; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEApartmentTransferHandler* iOther)
	{
		if (_iApartmentTransferHandler)
		{
			ICEApartmentTransferHandler* tmp = _iApartmentTransferHandler;
			_iApartmentTransferHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iApartmentTransferHandler = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEApartmentTransferHandler* detach()
	{
		ICEApartmentTransferHandler* iIntf = _iApartmentTransferHandler;
		_iApartmentTransferHandler = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEApartmentTransferHandler* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iApartmentTransferHandler;
		if (_iApartmentTransferHandler)
		{
			_iApartmentTransferHandler->_vtbl->_addRef(_iApartmentTransferHandler);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEApartmentTransferHandler*() const	{ return _iApartmentTransferHandler; }
	FORCEINLINE_WITHOUT_DEBUG ICEApartmentTransferHandler& operator*() const	{ return *_iApartmentTransferHandler; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iApartmentTransferHandler == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEApartmentTransferHandler* iOther) const	{ return (_iApartmentTransferHandler != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEApartmentTransferHandler* iOther) const	{ return (_iApartmentTransferHandler == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEApartmentTransferHandlerRef& operator=(const CEComICEApartmentTransferHandlerRef& other)	{ return operator=(other._iApartmentTransferHandler); }

	CEComICEApartmentTransferHandlerRef& operator=(const ICEApartmentTransferHandler* iOther)
	{
		if (_iApartmentTransferHandler != iOther)
		{
			if (_iApartmentTransferHandler)
			{
				ICEApartmentTransferHandler* tmp = _iApartmentTransferHandler;
				_iApartmentTransferHandler = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iApartmentTransferHandler = const_cast<ICEApartmentTransferHandler*>(iOther);
			if (_iApartmentTransferHandler)
			{
				_iApartmentTransferHandler->_vtbl->_addRef(_iApartmentTransferHandler);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEApartmentTransferHandler** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEApartmentTransferHandlerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iApartmentTransferHandler && "has a com object reference. clear first.");
		return & _iApartmentTransferHandler; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEApartmentTransferHandlerRef& other)
	{
		bool result = false;
		if (_iApartmentTransferHandler)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iApartmentTransferHandler);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iApartmentTransferHandler ? _iApartmentTransferHandler->_vtbl->_queryInterface(_iApartmentTransferHandler, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iApartmentTransferHandler) { _iApartmentTransferHandler->_vtbl->_addRef(_iApartmentTransferHandler); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iApartmentTransferHandler) { _iApartmentTransferHandler->_vtbl->_release(_iApartmentTransferHandler); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult preTransfer(struct ICEApartment* iFromApartment, struct ICEApartment* iToApartment)	{ return _iApartmentTransferHandler ? _iApartmentTransferHandler->_vtbl->_preTransfer(_iApartmentTransferHandler, iFromApartment, iToApartment) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult postTransfer(struct ICEApartment* iFromApartment, struct ICEApartment* iToApartment)	{ return _iApartmentTransferHandler ? _iApartmentTransferHandler->_vtbl->_postTransfer(_iApartmentTransferHandler, iFromApartment, iToApartment) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEApartmentTransferHandler* _iApartmentTransferHandler;
};

/*! @}
 * end of CEComICEApartmentTransferHandlerRef
 */

/*! \defgroup CEComICEApartmentSupportRef CEComICEApartmentSupportRef
 * @{
 */

class CEComICEApartmentSupportRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEApartmentSupportRef() : _iApartmentSupport(0) {}
	CEComICEApartmentSupportRef(ICEApartmentSupport* iOther) : _iApartmentSupport(0)
	{
		if (iOther)
		{
			_iApartmentSupport = iOther;
			_iApartmentSupport->_vtbl->_addRef(_iApartmentSupport);
		}
	}

	CEComICEApartmentSupportRef(const CEComICEApartmentSupportRef& other) : _iApartmentSupport(0)
	{
		if (other._iApartmentSupport)
		{
			_iApartmentSupport = other._iApartmentSupport;
			_iApartmentSupport->_vtbl->_addRef(_iApartmentSupport);
		}
	}

	~CEComICEApartmentSupportRef()
	{
		if (_iApartmentSupport)
		{
			ICEApartmentSupport* tmp = _iApartmentSupport;
			_iApartmentSupport = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEApartmentSupport* iApartmentSupport;
				void* _ptr;
			} uIntf;
			uIntf.iApartmentSupport = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEApartmentSupport, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iApartmentSupport)
				{
					ICEApartmentSupport* tmp = _iApartmentSupport;
					_iApartmentSupport = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iApartmentSupport = uIntf.iApartmentSupport;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEApartmentSupport* object() const	{ return _iApartmentSupport; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEApartmentSupport* iOther)
	{
		if (_iApartmentSupport)
		{
			ICEApartmentSupport* tmp = _iApartmentSupport;
			_iApartmentSupport = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iApartmentSupport = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEApartmentSupport* detach()
	{
		ICEApartmentSupport* iIntf = _iApartmentSupport;
		_iApartmentSupport = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEApartmentSupport* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iApartmentSupport;
		if (_iApartmentSupport)
		{
			_iApartmentSupport->_vtbl->_addRef(_iApartmentSupport);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEApartmentSupport*() const	{ return _iApartmentSupport; }
	FORCEINLINE_WITHOUT_DEBUG ICEApartmentSupport& operator*() const	{ return *_iApartmentSupport; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iApartmentSupport == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEApartmentSupport* iOther) const	{ return (_iApartmentSupport != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEApartmentSupport* iOther) const	{ return (_iApartmentSupport == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEApartmentSupportRef& operator=(const CEComICEApartmentSupportRef& other)	{ return operator=(other._iApartmentSupport); }

	CEComICEApartmentSupportRef& operator=(const ICEApartmentSupport* iOther)
	{
		if (_iApartmentSupport != iOther)
		{
			if (_iApartmentSupport)
			{
				ICEApartmentSupport* tmp = _iApartmentSupport;
				_iApartmentSupport = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iApartmentSupport = const_cast<ICEApartmentSupport*>(iOther);
			if (_iApartmentSupport)
			{
				_iApartmentSupport->_vtbl->_addRef(_iApartmentSupport);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEApartmentSupport** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEApartmentSupportRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iApartmentSupport && "has a com object reference. clear first.");
		return & _iApartmentSupport; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEApartmentSupportRef& other)
	{
		bool result = false;
		if (_iApartmentSupport)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iApartmentSupport);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iApartmentSupport ? _iApartmentSupport->_vtbl->_queryInterface(_iApartmentSupport, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iApartmentSupport) { _iApartmentSupport->_vtbl->_addRef(_iApartmentSupport); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iApartmentSupport) { _iApartmentSupport->_vtbl->_release(_iApartmentSupport); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult init()	{ return _iApartmentSupport ? _iApartmentSupport->_vtbl->_init(_iApartmentSupport) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult shutdown()	{ return _iApartmentSupport ? _iApartmentSupport->_vtbl->_shutdown(_iApartmentSupport) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult createSemaphore(CEUSemaphoreRef *const semaphoreOut)	{ return _iApartmentSupport ? _iApartmentSupport->_vtbl->_createSemaphore(_iApartmentSupport, semaphoreOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult destroySemaphore(CEUSemaphoreRef semaphore)	{ return _iApartmentSupport ? _iApartmentSupport->_vtbl->_destroySemaphore(_iApartmentSupport, semaphore) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEApartmentSupport* _iApartmentSupport;
};

/*! @}
 * end of CEComICEApartmentSupportRef
 */

/*! \defgroup CEComICEApartmentRef CEComICEApartmentRef
 * @{
 */

class CEComICEApartmentRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEApartmentRef() : _iApartment(0) {}
	CEComICEApartmentRef(ICEApartment* iOther) : _iApartment(0)
	{
		if (iOther)
		{
			_iApartment = iOther;
			_iApartment->_vtbl->_addRef(_iApartment);
		}
	}

	CEComICEApartmentRef(const CEComICEApartmentRef& other) : _iApartment(0)
	{
		if (other._iApartment)
		{
			_iApartment = other._iApartment;
			_iApartment->_vtbl->_addRef(_iApartment);
		}
	}

	~CEComICEApartmentRef()
	{
		if (_iApartment)
		{
			ICEApartment* tmp = _iApartment;
			_iApartment = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEApartment* iApartment;
				void* _ptr;
			} uIntf;
			uIntf.iApartment = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEApartment, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iApartment)
				{
					ICEApartment* tmp = _iApartment;
					_iApartment = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iApartment = uIntf.iApartment;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEApartment* object() const	{ return _iApartment; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEApartment* iOther)
	{
		if (_iApartment)
		{
			ICEApartment* tmp = _iApartment;
			_iApartment = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iApartment = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEApartment* detach()
	{
		ICEApartment* iIntf = _iApartment;
		_iApartment = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEApartment* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iApartment;
		if (_iApartment)
		{
			_iApartment->_vtbl->_addRef(_iApartment);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEApartment*() const	{ return _iApartment; }
	FORCEINLINE_WITHOUT_DEBUG ICEApartment& operator*() const	{ return *_iApartment; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iApartment == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEApartment* iOther) const	{ return (_iApartment != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEApartment* iOther) const	{ return (_iApartment == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEApartmentRef& operator=(const CEComICEApartmentRef& other)	{ return operator=(other._iApartment); }

	CEComICEApartmentRef& operator=(const ICEApartment* iOther)
	{
		if (_iApartment != iOther)
		{
			if (_iApartment)
			{
				ICEApartment* tmp = _iApartment;
				_iApartment = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iApartment = const_cast<ICEApartment*>(iOther);
			if (_iApartment)
			{
				_iApartment->_vtbl->_addRef(_iApartment);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEApartment** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEApartmentRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iApartment && "has a com object reference. clear first.");
		return & _iApartment; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEApartmentRef& other)
	{
		bool result = false;
		if (_iApartment)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iApartment);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iApartment ? _iApartment->_vtbl->_queryInterface(_iApartment, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iApartment) { _iApartment->_vtbl->_addRef(_iApartment); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iApartment) { _iApartment->_vtbl->_release(_iApartment); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getApartmentSupport(struct ICEApartmentSupport* *const iApartmentSupportOut)	{ return _iApartment ? _iApartment->_vtbl->_getApartmentSupport(_iApartment, iApartmentSupportOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setApartmentSupport(struct ICEApartmentSupport* iApartmentSupport)	{ return _iApartment ? _iApartment->_vtbl->_setApartmentSupport(_iApartment, iApartmentSupport) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult pushPendingMessage(struct ICEApartmentMessage* iMessage)	{ return _iApartment ? _iApartment->_vtbl->_pushPendingMessage(_iApartment, iMessage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult popPendingMessage(struct ICEApartmentMessage* iMessage)	{ return _iApartment ? _iApartment->_vtbl->_popPendingMessage(_iApartment, iMessage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getPendingMessage(struct ICEApartmentMessage* *const iMessageOut)	{ return _iApartment ? _iApartment->_vtbl->_getPendingMessage(_iApartment, iMessageOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult startLog()	{ return _iApartment ? _iApartment->_vtbl->_startLog(_iApartment) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult stopLog()	{ return _iApartment ? _iApartment->_vtbl->_stopLog(_iApartment) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult log(const char* info, UINT32 charLenInByte, UINT64 performanceCount)	{ return _iApartment ? _iApartment->_vtbl->_log(_iApartment, info, charLenInByte, performanceCount) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEApartment* _iApartment;
};

/*! @}
 * end of CEComICEApartmentRef
 */

/*! \defgroup CEComICEHeartbeatRef CEComICEHeartbeatRef
 * @{
 */

class CEComICEHeartbeatRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHeartbeatRef() : _iHeartbeat(0) {}
	CEComICEHeartbeatRef(ICEHeartbeat* iOther) : _iHeartbeat(0)
	{
		if (iOther)
		{
			_iHeartbeat = iOther;
			_iHeartbeat->_vtbl->_addRef(_iHeartbeat);
		}
	}

	CEComICEHeartbeatRef(const CEComICEHeartbeatRef& other) : _iHeartbeat(0)
	{
		if (other._iHeartbeat)
		{
			_iHeartbeat = other._iHeartbeat;
			_iHeartbeat->_vtbl->_addRef(_iHeartbeat);
		}
	}

	~CEComICEHeartbeatRef()
	{
		if (_iHeartbeat)
		{
			ICEHeartbeat* tmp = _iHeartbeat;
			_iHeartbeat = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHeartbeat* iHeartbeat;
				void* _ptr;
			} uIntf;
			uIntf.iHeartbeat = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHeartbeat, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iHeartbeat)
				{
					ICEHeartbeat* tmp = _iHeartbeat;
					_iHeartbeat = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iHeartbeat = uIntf.iHeartbeat;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHeartbeat* object() const	{ return _iHeartbeat; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHeartbeat* iOther)
	{
		if (_iHeartbeat)
		{
			ICEHeartbeat* tmp = _iHeartbeat;
			_iHeartbeat = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iHeartbeat = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHeartbeat* detach()
	{
		ICEHeartbeat* iIntf = _iHeartbeat;
		_iHeartbeat = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHeartbeat* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iHeartbeat;
		if (_iHeartbeat)
		{
			_iHeartbeat->_vtbl->_addRef(_iHeartbeat);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHeartbeat*() const	{ return _iHeartbeat; }
	FORCEINLINE_WITHOUT_DEBUG ICEHeartbeat& operator*() const	{ return *_iHeartbeat; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iHeartbeat == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHeartbeat* iOther) const	{ return (_iHeartbeat != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHeartbeat* iOther) const	{ return (_iHeartbeat == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHeartbeatRef& operator=(const CEComICEHeartbeatRef& other)	{ return operator=(other._iHeartbeat); }

	CEComICEHeartbeatRef& operator=(const ICEHeartbeat* iOther)
	{
		if (_iHeartbeat != iOther)
		{
			if (_iHeartbeat)
			{
				ICEHeartbeat* tmp = _iHeartbeat;
				_iHeartbeat = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iHeartbeat = const_cast<ICEHeartbeat*>(iOther);
			if (_iHeartbeat)
			{
				_iHeartbeat->_vtbl->_addRef(_iHeartbeat);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHeartbeat** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHeartbeatRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iHeartbeat && "has a com object reference. clear first.");
		return & _iHeartbeat; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHeartbeatRef& other)
	{
		bool result = false;
		if (_iHeartbeat)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iHeartbeat);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iHeartbeat ? _iHeartbeat->_vtbl->_queryInterface(_iHeartbeat, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iHeartbeat) { _iHeartbeat->_vtbl->_addRef(_iHeartbeat); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iHeartbeat) { _iHeartbeat->_vtbl->_release(_iHeartbeat); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult heartbeat()	{ return _iHeartbeat ? _iHeartbeat->_vtbl->_heartbeat(_iHeartbeat) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHeartbeat* _iHeartbeat;
};

/*! @}
 * end of CEComICEHeartbeatRef
 */

/*! \defgroup CEComICENeutralApartmentRef CEComICENeutralApartmentRef
 * @{
 */

class CEComICENeutralApartmentRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICENeutralApartmentRef() : _iNeutralApartment(0) {}
	CEComICENeutralApartmentRef(ICENeutralApartment* iOther) : _iNeutralApartment(0)
	{
		if (iOther)
		{
			_iNeutralApartment = iOther;
			_iNeutralApartment->_vtbl->_addRef(_iNeutralApartment);
		}
	}

	CEComICENeutralApartmentRef(const CEComICENeutralApartmentRef& other) : _iNeutralApartment(0)
	{
		if (other._iNeutralApartment)
		{
			_iNeutralApartment = other._iNeutralApartment;
			_iNeutralApartment->_vtbl->_addRef(_iNeutralApartment);
		}
	}

	~CEComICENeutralApartmentRef()
	{
		if (_iNeutralApartment)
		{
			ICENeutralApartment* tmp = _iNeutralApartment;
			_iNeutralApartment = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICENeutralApartment* iNeutralApartment;
				void* _ptr;
			} uIntf;
			uIntf.iNeutralApartment = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICENeutralApartment, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iNeutralApartment)
				{
					ICENeutralApartment* tmp = _iNeutralApartment;
					_iNeutralApartment = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iNeutralApartment = uIntf.iNeutralApartment;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICENeutralApartment* object() const	{ return _iNeutralApartment; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICENeutralApartment* iOther)
	{
		if (_iNeutralApartment)
		{
			ICENeutralApartment* tmp = _iNeutralApartment;
			_iNeutralApartment = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iNeutralApartment = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICENeutralApartment* detach()
	{
		ICENeutralApartment* iIntf = _iNeutralApartment;
		_iNeutralApartment = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICENeutralApartment* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iNeutralApartment;
		if (_iNeutralApartment)
		{
			_iNeutralApartment->_vtbl->_addRef(_iNeutralApartment);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICENeutralApartment*() const	{ return _iNeutralApartment; }
	FORCEINLINE_WITHOUT_DEBUG ICENeutralApartment& operator*() const	{ return *_iNeutralApartment; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iNeutralApartment == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICENeutralApartment* iOther) const	{ return (_iNeutralApartment != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICENeutralApartment* iOther) const	{ return (_iNeutralApartment == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICENeutralApartmentRef& operator=(const CEComICENeutralApartmentRef& other)	{ return operator=(other._iNeutralApartment); }

	CEComICENeutralApartmentRef& operator=(const ICENeutralApartment* iOther)
	{
		if (_iNeutralApartment != iOther)
		{
			if (_iNeutralApartment)
			{
				ICENeutralApartment* tmp = _iNeutralApartment;
				_iNeutralApartment = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iNeutralApartment = const_cast<ICENeutralApartment*>(iOther);
			if (_iNeutralApartment)
			{
				_iNeutralApartment->_vtbl->_addRef(_iNeutralApartment);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICENeutralApartment** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICENeutralApartmentRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iNeutralApartment && "has a com object reference. clear first.");
		return & _iNeutralApartment; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICENeutralApartmentRef& other)
	{
		bool result = false;
		if (_iNeutralApartment)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iNeutralApartment);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iNeutralApartment ? _iNeutralApartment->_vtbl->_queryInterface(_iNeutralApartment, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iNeutralApartment) { _iNeutralApartment->_vtbl->_addRef(_iNeutralApartment); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iNeutralApartment) { _iNeutralApartment->_vtbl->_release(_iNeutralApartment); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getApartmentSupport(struct ICEApartmentSupport* *const iApartmentSupportOut)	{ return _iNeutralApartment ? _iNeutralApartment->_vtbl->_getApartmentSupport(_iNeutralApartment, iApartmentSupportOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setApartmentSupport(struct ICEApartmentSupport* iApartmentSupport)	{ return _iNeutralApartment ? _iNeutralApartment->_vtbl->_setApartmentSupport(_iNeutralApartment, iApartmentSupport) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult pushPendingMessage(struct ICEApartmentMessage* iMessage)	{ return _iNeutralApartment ? _iNeutralApartment->_vtbl->_pushPendingMessage(_iNeutralApartment, iMessage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult popPendingMessage(struct ICEApartmentMessage* iMessage)	{ return _iNeutralApartment ? _iNeutralApartment->_vtbl->_popPendingMessage(_iNeutralApartment, iMessage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getPendingMessage(struct ICEApartmentMessage* *const iMessageOut)	{ return _iNeutralApartment ? _iNeutralApartment->_vtbl->_getPendingMessage(_iNeutralApartment, iMessageOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult startLog()	{ return _iNeutralApartment ? _iNeutralApartment->_vtbl->_startLog(_iNeutralApartment) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult stopLog()	{ return _iNeutralApartment ? _iNeutralApartment->_vtbl->_stopLog(_iNeutralApartment) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult log(const char* info, UINT32 charLenInByte, UINT64 performanceCount)	{ return _iNeutralApartment ? _iNeutralApartment->_vtbl->_log(_iNeutralApartment, info, charLenInByte, performanceCount) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult heartbeat()	{ return _iNeutralApartment ? _iNeutralApartment->_vtbl->_heartbeat(_iNeutralApartment) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setHeartbeat(struct ICEHeartbeat* iHeartbeat)	{ return _iNeutralApartment ? _iNeutralApartment->_vtbl->_setHeartbeat(_iNeutralApartment, iHeartbeat) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICENeutralApartment* _iNeutralApartment;
};

/*! @}
 * end of CEComICENeutralApartmentRef
 */

/*! \defgroup CEComICEApartmentMessagePostHandlerRef CEComICEApartmentMessagePostHandlerRef
 * @{
 */

class CEComICEApartmentMessagePostHandlerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEApartmentMessagePostHandlerRef() : _iApartmentMessagePostHandler(0) {}
	CEComICEApartmentMessagePostHandlerRef(ICEApartmentMessagePostHandler* iOther) : _iApartmentMessagePostHandler(0)
	{
		if (iOther)
		{
			_iApartmentMessagePostHandler = iOther;
			_iApartmentMessagePostHandler->_vtbl->_addRef(_iApartmentMessagePostHandler);
		}
	}

	CEComICEApartmentMessagePostHandlerRef(const CEComICEApartmentMessagePostHandlerRef& other) : _iApartmentMessagePostHandler(0)
	{
		if (other._iApartmentMessagePostHandler)
		{
			_iApartmentMessagePostHandler = other._iApartmentMessagePostHandler;
			_iApartmentMessagePostHandler->_vtbl->_addRef(_iApartmentMessagePostHandler);
		}
	}

	~CEComICEApartmentMessagePostHandlerRef()
	{
		if (_iApartmentMessagePostHandler)
		{
			ICEApartmentMessagePostHandler* tmp = _iApartmentMessagePostHandler;
			_iApartmentMessagePostHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEApartmentMessagePostHandler* iApartmentMessagePostHandler;
				void* _ptr;
			} uIntf;
			uIntf.iApartmentMessagePostHandler = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEApartmentMessagePostHandler, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iApartmentMessagePostHandler)
				{
					ICEApartmentMessagePostHandler* tmp = _iApartmentMessagePostHandler;
					_iApartmentMessagePostHandler = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iApartmentMessagePostHandler = uIntf.iApartmentMessagePostHandler;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEApartmentMessagePostHandler* object() const	{ return _iApartmentMessagePostHandler; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEApartmentMessagePostHandler* iOther)
	{
		if (_iApartmentMessagePostHandler)
		{
			ICEApartmentMessagePostHandler* tmp = _iApartmentMessagePostHandler;
			_iApartmentMessagePostHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iApartmentMessagePostHandler = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEApartmentMessagePostHandler* detach()
	{
		ICEApartmentMessagePostHandler* iIntf = _iApartmentMessagePostHandler;
		_iApartmentMessagePostHandler = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEApartmentMessagePostHandler* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iApartmentMessagePostHandler;
		if (_iApartmentMessagePostHandler)
		{
			_iApartmentMessagePostHandler->_vtbl->_addRef(_iApartmentMessagePostHandler);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEApartmentMessagePostHandler*() const	{ return _iApartmentMessagePostHandler; }
	FORCEINLINE_WITHOUT_DEBUG ICEApartmentMessagePostHandler& operator*() const	{ return *_iApartmentMessagePostHandler; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iApartmentMessagePostHandler == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEApartmentMessagePostHandler* iOther) const	{ return (_iApartmentMessagePostHandler != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEApartmentMessagePostHandler* iOther) const	{ return (_iApartmentMessagePostHandler == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEApartmentMessagePostHandlerRef& operator=(const CEComICEApartmentMessagePostHandlerRef& other)	{ return operator=(other._iApartmentMessagePostHandler); }

	CEComICEApartmentMessagePostHandlerRef& operator=(const ICEApartmentMessagePostHandler* iOther)
	{
		if (_iApartmentMessagePostHandler != iOther)
		{
			if (_iApartmentMessagePostHandler)
			{
				ICEApartmentMessagePostHandler* tmp = _iApartmentMessagePostHandler;
				_iApartmentMessagePostHandler = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iApartmentMessagePostHandler = const_cast<ICEApartmentMessagePostHandler*>(iOther);
			if (_iApartmentMessagePostHandler)
			{
				_iApartmentMessagePostHandler->_vtbl->_addRef(_iApartmentMessagePostHandler);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEApartmentMessagePostHandler** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEApartmentMessagePostHandlerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iApartmentMessagePostHandler && "has a com object reference. clear first.");
		return & _iApartmentMessagePostHandler; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEApartmentMessagePostHandlerRef& other)
	{
		bool result = false;
		if (_iApartmentMessagePostHandler)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iApartmentMessagePostHandler);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iApartmentMessagePostHandler ? _iApartmentMessagePostHandler->_vtbl->_queryInterface(_iApartmentMessagePostHandler, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iApartmentMessagePostHandler) { _iApartmentMessagePostHandler->_vtbl->_addRef(_iApartmentMessagePostHandler); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iApartmentMessagePostHandler) { _iApartmentMessagePostHandler->_vtbl->_release(_iApartmentMessagePostHandler); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult onPostMessage()	{ return _iApartmentMessagePostHandler ? _iApartmentMessagePostHandler->_vtbl->_onPostMessage(_iApartmentMessagePostHandler) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult pushMessageSemaphore(CEUSemaphoreRef semaphore)	{ return _iApartmentMessagePostHandler ? _iApartmentMessagePostHandler->_vtbl->_pushMessageSemaphore(_iApartmentMessagePostHandler, semaphore) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult popMessageSemaphore(CEUSemaphoreRef semaphore)	{ return _iApartmentMessagePostHandler ? _iApartmentMessagePostHandler->_vtbl->_popMessageSemaphore(_iApartmentMessagePostHandler, semaphore) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult waitMessageSemaphore(UINT32 timeoutMilliSeconds)	{ return _iApartmentMessagePostHandler ? _iApartmentMessagePostHandler->_vtbl->_waitMessageSemaphore(_iApartmentMessagePostHandler, timeoutMilliSeconds) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEApartmentMessagePostHandler* _iApartmentMessagePostHandler;
};

/*! @}
 * end of CEComICEApartmentMessagePostHandlerRef
 */

/*! \defgroup CEComICEApartmentMessageRef CEComICEApartmentMessageRef
 * @{
 */

class CEComICEApartmentMessageRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEApartmentMessageRef() : _iApartmentMessage(0) {}
	CEComICEApartmentMessageRef(ICEApartmentMessage* iOther) : _iApartmentMessage(0)
	{
		if (iOther)
		{
			_iApartmentMessage = iOther;
			_iApartmentMessage->_vtbl->_addRef(_iApartmentMessage);
		}
	}

	CEComICEApartmentMessageRef(const CEComICEApartmentMessageRef& other) : _iApartmentMessage(0)
	{
		if (other._iApartmentMessage)
		{
			_iApartmentMessage = other._iApartmentMessage;
			_iApartmentMessage->_vtbl->_addRef(_iApartmentMessage);
		}
	}

	~CEComICEApartmentMessageRef()
	{
		if (_iApartmentMessage)
		{
			ICEApartmentMessage* tmp = _iApartmentMessage;
			_iApartmentMessage = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEApartmentMessage* iApartmentMessage;
				void* _ptr;
			} uIntf;
			uIntf.iApartmentMessage = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEApartmentMessage, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iApartmentMessage)
				{
					ICEApartmentMessage* tmp = _iApartmentMessage;
					_iApartmentMessage = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iApartmentMessage = uIntf.iApartmentMessage;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEApartmentMessage* object() const	{ return _iApartmentMessage; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEApartmentMessage* iOther)
	{
		if (_iApartmentMessage)
		{
			ICEApartmentMessage* tmp = _iApartmentMessage;
			_iApartmentMessage = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iApartmentMessage = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEApartmentMessage* detach()
	{
		ICEApartmentMessage* iIntf = _iApartmentMessage;
		_iApartmentMessage = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEApartmentMessage* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iApartmentMessage;
		if (_iApartmentMessage)
		{
			_iApartmentMessage->_vtbl->_addRef(_iApartmentMessage);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEApartmentMessage*() const	{ return _iApartmentMessage; }
	FORCEINLINE_WITHOUT_DEBUG ICEApartmentMessage& operator*() const	{ return *_iApartmentMessage; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iApartmentMessage == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEApartmentMessage* iOther) const	{ return (_iApartmentMessage != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEApartmentMessage* iOther) const	{ return (_iApartmentMessage == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEApartmentMessageRef& operator=(const CEComICEApartmentMessageRef& other)	{ return operator=(other._iApartmentMessage); }

	CEComICEApartmentMessageRef& operator=(const ICEApartmentMessage* iOther)
	{
		if (_iApartmentMessage != iOther)
		{
			if (_iApartmentMessage)
			{
				ICEApartmentMessage* tmp = _iApartmentMessage;
				_iApartmentMessage = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iApartmentMessage = const_cast<ICEApartmentMessage*>(iOther);
			if (_iApartmentMessage)
			{
				_iApartmentMessage->_vtbl->_addRef(_iApartmentMessage);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEApartmentMessage** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEApartmentMessageRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iApartmentMessage && "has a com object reference. clear first.");
		return & _iApartmentMessage; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEApartmentMessageRef& other)
	{
		bool result = false;
		if (_iApartmentMessage)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iApartmentMessage);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iApartmentMessage ? _iApartmentMessage->_vtbl->_queryInterface(_iApartmentMessage, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iApartmentMessage) { _iApartmentMessage->_vtbl->_addRef(_iApartmentMessage); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iApartmentMessage) { _iApartmentMessage->_vtbl->_release(_iApartmentMessage); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult invokeSelf()	{ return _iApartmentMessage ? _iApartmentMessage->_vtbl->_invokeSelf(_iApartmentMessage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult retry(INT32 usec)	{ return _iApartmentMessage ? _iApartmentMessage->_vtbl->_retry(_iApartmentMessage, usec) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult retryRequested(INT32 *const usecOut)	{ return _iApartmentMessage ? _iApartmentMessage->_vtbl->_retryRequested(_iApartmentMessage, usecOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult wait(UINT32 timeoutMilliSeconds)	{ return _iApartmentMessage ? _iApartmentMessage->_vtbl->_wait(_iApartmentMessage, timeoutMilliSeconds) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult post()	{ return _iApartmentMessage ? _iApartmentMessage->_vtbl->_post(_iApartmentMessage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getResult(CEHResult *const errOut)	{ return _iApartmentMessage ? _iApartmentMessage->_vtbl->_getResult(_iApartmentMessage, errOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyDefered()	{ return _iApartmentMessage ? _iApartmentMessage->_vtbl->_notifyDefered(_iApartmentMessage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult deferedPost()	{ return _iApartmentMessage ? _iApartmentMessage->_vtbl->_deferedPost(_iApartmentMessage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getParam(void* *const paramOut)	{ return _iApartmentMessage ? _iApartmentMessage->_vtbl->_getParam(_iApartmentMessage, paramOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getConsumingCount(CEATOMIC** consumingCountOut)	{ return _iApartmentMessage ? _iApartmentMessage->_vtbl->_getConsumingCount(_iApartmentMessage, consumingCountOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyDepended()	{ return _iApartmentMessage ? _iApartmentMessage->_vtbl->_notifyDepended(_iApartmentMessage) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEApartmentMessage* _iApartmentMessage;
};

/*! @}
 * end of CEComICEApartmentMessageRef
 */

/*! \defgroup CEComICEThreadOwnerApartmentRef CEComICEThreadOwnerApartmentRef
 * @{
 */

class CEComICEThreadOwnerApartmentRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEThreadOwnerApartmentRef() : _iThreadOwnerApartment(0) {}
	CEComICEThreadOwnerApartmentRef(ICEThreadOwnerApartment* iOther) : _iThreadOwnerApartment(0)
	{
		if (iOther)
		{
			_iThreadOwnerApartment = iOther;
			_iThreadOwnerApartment->_vtbl->_addRef(_iThreadOwnerApartment);
		}
	}

	CEComICEThreadOwnerApartmentRef(const CEComICEThreadOwnerApartmentRef& other) : _iThreadOwnerApartment(0)
	{
		if (other._iThreadOwnerApartment)
		{
			_iThreadOwnerApartment = other._iThreadOwnerApartment;
			_iThreadOwnerApartment->_vtbl->_addRef(_iThreadOwnerApartment);
		}
	}

	~CEComICEThreadOwnerApartmentRef()
	{
		if (_iThreadOwnerApartment)
		{
			ICEThreadOwnerApartment* tmp = _iThreadOwnerApartment;
			_iThreadOwnerApartment = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEThreadOwnerApartment* iThreadOwnerApartment;
				void* _ptr;
			} uIntf;
			uIntf.iThreadOwnerApartment = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEThreadOwnerApartment, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iThreadOwnerApartment)
				{
					ICEThreadOwnerApartment* tmp = _iThreadOwnerApartment;
					_iThreadOwnerApartment = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iThreadOwnerApartment = uIntf.iThreadOwnerApartment;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEThreadOwnerApartment* object() const	{ return _iThreadOwnerApartment; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEThreadOwnerApartment* iOther)
	{
		if (_iThreadOwnerApartment)
		{
			ICEThreadOwnerApartment* tmp = _iThreadOwnerApartment;
			_iThreadOwnerApartment = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iThreadOwnerApartment = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEThreadOwnerApartment* detach()
	{
		ICEThreadOwnerApartment* iIntf = _iThreadOwnerApartment;
		_iThreadOwnerApartment = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEThreadOwnerApartment* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iThreadOwnerApartment;
		if (_iThreadOwnerApartment)
		{
			_iThreadOwnerApartment->_vtbl->_addRef(_iThreadOwnerApartment);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEThreadOwnerApartment*() const	{ return _iThreadOwnerApartment; }
	FORCEINLINE_WITHOUT_DEBUG ICEThreadOwnerApartment& operator*() const	{ return *_iThreadOwnerApartment; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iThreadOwnerApartment == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEThreadOwnerApartment* iOther) const	{ return (_iThreadOwnerApartment != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEThreadOwnerApartment* iOther) const	{ return (_iThreadOwnerApartment == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEThreadOwnerApartmentRef& operator=(const CEComICEThreadOwnerApartmentRef& other)	{ return operator=(other._iThreadOwnerApartment); }

	CEComICEThreadOwnerApartmentRef& operator=(const ICEThreadOwnerApartment* iOther)
	{
		if (_iThreadOwnerApartment != iOther)
		{
			if (_iThreadOwnerApartment)
			{
				ICEThreadOwnerApartment* tmp = _iThreadOwnerApartment;
				_iThreadOwnerApartment = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iThreadOwnerApartment = const_cast<ICEThreadOwnerApartment*>(iOther);
			if (_iThreadOwnerApartment)
			{
				_iThreadOwnerApartment->_vtbl->_addRef(_iThreadOwnerApartment);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEThreadOwnerApartment** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEThreadOwnerApartmentRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iThreadOwnerApartment && "has a com object reference. clear first.");
		return & _iThreadOwnerApartment; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEThreadOwnerApartmentRef& other)
	{
		bool result = false;
		if (_iThreadOwnerApartment)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iThreadOwnerApartment);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iThreadOwnerApartment ? _iThreadOwnerApartment->_vtbl->_queryInterface(_iThreadOwnerApartment, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iThreadOwnerApartment) { _iThreadOwnerApartment->_vtbl->_addRef(_iThreadOwnerApartment); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iThreadOwnerApartment) { _iThreadOwnerApartment->_vtbl->_release(_iThreadOwnerApartment); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getApartmentSupport(struct ICEApartmentSupport* *const iApartmentSupportOut)	{ return _iThreadOwnerApartment ? _iThreadOwnerApartment->_vtbl->_getApartmentSupport(_iThreadOwnerApartment, iApartmentSupportOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setApartmentSupport(struct ICEApartmentSupport* iApartmentSupport)	{ return _iThreadOwnerApartment ? _iThreadOwnerApartment->_vtbl->_setApartmentSupport(_iThreadOwnerApartment, iApartmentSupport) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult pushPendingMessage(struct ICEApartmentMessage* iMessage)	{ return _iThreadOwnerApartment ? _iThreadOwnerApartment->_vtbl->_pushPendingMessage(_iThreadOwnerApartment, iMessage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult popPendingMessage(struct ICEApartmentMessage* iMessage)	{ return _iThreadOwnerApartment ? _iThreadOwnerApartment->_vtbl->_popPendingMessage(_iThreadOwnerApartment, iMessage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getPendingMessage(struct ICEApartmentMessage* *const iMessageOut)	{ return _iThreadOwnerApartment ? _iThreadOwnerApartment->_vtbl->_getPendingMessage(_iThreadOwnerApartment, iMessageOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult startLog()	{ return _iThreadOwnerApartment ? _iThreadOwnerApartment->_vtbl->_startLog(_iThreadOwnerApartment) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult stopLog()	{ return _iThreadOwnerApartment ? _iThreadOwnerApartment->_vtbl->_stopLog(_iThreadOwnerApartment) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult log(const char* info, UINT32 charLenInByte, UINT64 performanceCount)	{ return _iThreadOwnerApartment ? _iThreadOwnerApartment->_vtbl->_log(_iThreadOwnerApartment, info, charLenInByte, performanceCount) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setMessagePostHandler(struct ICEApartmentMessagePostHandler* handler)	{ return _iThreadOwnerApartment ? _iThreadOwnerApartment->_vtbl->_setMessagePostHandler(_iThreadOwnerApartment, handler) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult postMessage(struct ICEApartment* callerApartment, UINT32 mid, void* param, void* userData, invoke_message_callback callback)	{ return _iThreadOwnerApartment ? _iThreadOwnerApartment->_vtbl->_postMessage(_iThreadOwnerApartment, callerApartment, mid, param, userData, callback) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult heartbeat()	{ return _iThreadOwnerApartment ? _iThreadOwnerApartment->_vtbl->_heartbeat(_iThreadOwnerApartment) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult hasMessage(bool* hasMessageOut)	{ return _iThreadOwnerApartment ? _iThreadOwnerApartment->_vtbl->_hasMessage(_iThreadOwnerApartment, hasMessageOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getNumPendingMessages(INT32* numOut)	{ return _iThreadOwnerApartment ? _iThreadOwnerApartment->_vtbl->_getNumPendingMessages(_iThreadOwnerApartment, numOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCurrentMessage(struct ICEApartmentMessage* *const iMesageOut)	{ return _iThreadOwnerApartment ? _iThreadOwnerApartment->_vtbl->_getCurrentMessage(_iThreadOwnerApartment, iMesageOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult pushMessageSemaphore(CEUSemaphoreRef semaphore)	{ return _iThreadOwnerApartment ? _iThreadOwnerApartment->_vtbl->_pushMessageSemaphore(_iThreadOwnerApartment, semaphore) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult popMessageSemaphore(CEUSemaphoreRef semaphore)	{ return _iThreadOwnerApartment ? _iThreadOwnerApartment->_vtbl->_popMessageSemaphore(_iThreadOwnerApartment, semaphore) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult waitMessageSemaphore(UINT32 timeoutMilliSeconds)	{ return _iThreadOwnerApartment ? _iThreadOwnerApartment->_vtbl->_waitMessageSemaphore(_iThreadOwnerApartment, timeoutMilliSeconds) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEThreadOwnerApartment* _iThreadOwnerApartment;
};

/*! @}
 * end of CEComICEThreadOwnerApartmentRef
 */

/*! \defgroup CEComICESingleThreadApartmentRef CEComICESingleThreadApartmentRef
 * @{
 */

class CEComICESingleThreadApartmentRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICESingleThreadApartmentRef() : _iSingleThreadApartment(0) {}
	CEComICESingleThreadApartmentRef(ICESingleThreadApartment* iOther) : _iSingleThreadApartment(0)
	{
		if (iOther)
		{
			_iSingleThreadApartment = iOther;
			_iSingleThreadApartment->_vtbl->_addRef(_iSingleThreadApartment);
		}
	}

	CEComICESingleThreadApartmentRef(const CEComICESingleThreadApartmentRef& other) : _iSingleThreadApartment(0)
	{
		if (other._iSingleThreadApartment)
		{
			_iSingleThreadApartment = other._iSingleThreadApartment;
			_iSingleThreadApartment->_vtbl->_addRef(_iSingleThreadApartment);
		}
	}

	~CEComICESingleThreadApartmentRef()
	{
		if (_iSingleThreadApartment)
		{
			ICESingleThreadApartment* tmp = _iSingleThreadApartment;
			_iSingleThreadApartment = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICESingleThreadApartment* iSingleThreadApartment;
				void* _ptr;
			} uIntf;
			uIntf.iSingleThreadApartment = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICESingleThreadApartment, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iSingleThreadApartment)
				{
					ICESingleThreadApartment* tmp = _iSingleThreadApartment;
					_iSingleThreadApartment = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iSingleThreadApartment = uIntf.iSingleThreadApartment;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICESingleThreadApartment* object() const	{ return _iSingleThreadApartment; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICESingleThreadApartment* iOther)
	{
		if (_iSingleThreadApartment)
		{
			ICESingleThreadApartment* tmp = _iSingleThreadApartment;
			_iSingleThreadApartment = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iSingleThreadApartment = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICESingleThreadApartment* detach()
	{
		ICESingleThreadApartment* iIntf = _iSingleThreadApartment;
		_iSingleThreadApartment = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICESingleThreadApartment* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iSingleThreadApartment;
		if (_iSingleThreadApartment)
		{
			_iSingleThreadApartment->_vtbl->_addRef(_iSingleThreadApartment);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICESingleThreadApartment*() const	{ return _iSingleThreadApartment; }
	FORCEINLINE_WITHOUT_DEBUG ICESingleThreadApartment& operator*() const	{ return *_iSingleThreadApartment; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iSingleThreadApartment == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICESingleThreadApartment* iOther) const	{ return (_iSingleThreadApartment != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICESingleThreadApartment* iOther) const	{ return (_iSingleThreadApartment == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICESingleThreadApartmentRef& operator=(const CEComICESingleThreadApartmentRef& other)	{ return operator=(other._iSingleThreadApartment); }

	CEComICESingleThreadApartmentRef& operator=(const ICESingleThreadApartment* iOther)
	{
		if (_iSingleThreadApartment != iOther)
		{
			if (_iSingleThreadApartment)
			{
				ICESingleThreadApartment* tmp = _iSingleThreadApartment;
				_iSingleThreadApartment = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iSingleThreadApartment = const_cast<ICESingleThreadApartment*>(iOther);
			if (_iSingleThreadApartment)
			{
				_iSingleThreadApartment->_vtbl->_addRef(_iSingleThreadApartment);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICESingleThreadApartment** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICESingleThreadApartmentRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iSingleThreadApartment && "has a com object reference. clear first.");
		return & _iSingleThreadApartment; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICESingleThreadApartmentRef& other)
	{
		bool result = false;
		if (_iSingleThreadApartment)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iSingleThreadApartment);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iSingleThreadApartment ? _iSingleThreadApartment->_vtbl->_queryInterface(_iSingleThreadApartment, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iSingleThreadApartment) { _iSingleThreadApartment->_vtbl->_addRef(_iSingleThreadApartment); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iSingleThreadApartment) { _iSingleThreadApartment->_vtbl->_release(_iSingleThreadApartment); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getApartmentSupport(struct ICEApartmentSupport* *const iApartmentSupportOut)	{ return _iSingleThreadApartment ? _iSingleThreadApartment->_vtbl->_getApartmentSupport(_iSingleThreadApartment, iApartmentSupportOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setApartmentSupport(struct ICEApartmentSupport* iApartmentSupport)	{ return _iSingleThreadApartment ? _iSingleThreadApartment->_vtbl->_setApartmentSupport(_iSingleThreadApartment, iApartmentSupport) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult pushPendingMessage(struct ICEApartmentMessage* iMessage)	{ return _iSingleThreadApartment ? _iSingleThreadApartment->_vtbl->_pushPendingMessage(_iSingleThreadApartment, iMessage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult popPendingMessage(struct ICEApartmentMessage* iMessage)	{ return _iSingleThreadApartment ? _iSingleThreadApartment->_vtbl->_popPendingMessage(_iSingleThreadApartment, iMessage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getPendingMessage(struct ICEApartmentMessage* *const iMessageOut)	{ return _iSingleThreadApartment ? _iSingleThreadApartment->_vtbl->_getPendingMessage(_iSingleThreadApartment, iMessageOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult startLog()	{ return _iSingleThreadApartment ? _iSingleThreadApartment->_vtbl->_startLog(_iSingleThreadApartment) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult stopLog()	{ return _iSingleThreadApartment ? _iSingleThreadApartment->_vtbl->_stopLog(_iSingleThreadApartment) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult log(const char* info, UINT32 charLenInByte, UINT64 performanceCount)	{ return _iSingleThreadApartment ? _iSingleThreadApartment->_vtbl->_log(_iSingleThreadApartment, info, charLenInByte, performanceCount) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setMessagePostHandler(struct ICEApartmentMessagePostHandler* handler)	{ return _iSingleThreadApartment ? _iSingleThreadApartment->_vtbl->_setMessagePostHandler(_iSingleThreadApartment, handler) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult postMessage(struct ICEApartment* callerApartment, UINT32 mid, void* param, void* userData, invoke_message_callback callback)	{ return _iSingleThreadApartment ? _iSingleThreadApartment->_vtbl->_postMessage(_iSingleThreadApartment, callerApartment, mid, param, userData, callback) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult heartbeat()	{ return _iSingleThreadApartment ? _iSingleThreadApartment->_vtbl->_heartbeat(_iSingleThreadApartment) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult hasMessage(bool* hasMessageOut)	{ return _iSingleThreadApartment ? _iSingleThreadApartment->_vtbl->_hasMessage(_iSingleThreadApartment, hasMessageOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getNumPendingMessages(INT32* numOut)	{ return _iSingleThreadApartment ? _iSingleThreadApartment->_vtbl->_getNumPendingMessages(_iSingleThreadApartment, numOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCurrentMessage(struct ICEApartmentMessage* *const iMesageOut)	{ return _iSingleThreadApartment ? _iSingleThreadApartment->_vtbl->_getCurrentMessage(_iSingleThreadApartment, iMesageOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult pushMessageSemaphore(CEUSemaphoreRef semaphore)	{ return _iSingleThreadApartment ? _iSingleThreadApartment->_vtbl->_pushMessageSemaphore(_iSingleThreadApartment, semaphore) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult popMessageSemaphore(CEUSemaphoreRef semaphore)	{ return _iSingleThreadApartment ? _iSingleThreadApartment->_vtbl->_popMessageSemaphore(_iSingleThreadApartment, semaphore) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult waitMessageSemaphore(UINT32 timeoutMilliSeconds)	{ return _iSingleThreadApartment ? _iSingleThreadApartment->_vtbl->_waitMessageSemaphore(_iSingleThreadApartment, timeoutMilliSeconds) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICESingleThreadApartment* _iSingleThreadApartment;
};

/*! @}
 * end of CEComICESingleThreadApartmentRef
 */

/*! \defgroup CEComICEMultiThreadApartmentRef CEComICEMultiThreadApartmentRef
 * @{
 */

class CEComICEMultiThreadApartmentRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEMultiThreadApartmentRef() : _iMultiThreadApartment(0) {}
	CEComICEMultiThreadApartmentRef(ICEMultiThreadApartment* iOther) : _iMultiThreadApartment(0)
	{
		if (iOther)
		{
			_iMultiThreadApartment = iOther;
			_iMultiThreadApartment->_vtbl->_addRef(_iMultiThreadApartment);
		}
	}

	CEComICEMultiThreadApartmentRef(const CEComICEMultiThreadApartmentRef& other) : _iMultiThreadApartment(0)
	{
		if (other._iMultiThreadApartment)
		{
			_iMultiThreadApartment = other._iMultiThreadApartment;
			_iMultiThreadApartment->_vtbl->_addRef(_iMultiThreadApartment);
		}
	}

	~CEComICEMultiThreadApartmentRef()
	{
		if (_iMultiThreadApartment)
		{
			ICEMultiThreadApartment* tmp = _iMultiThreadApartment;
			_iMultiThreadApartment = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEMultiThreadApartment* iMultiThreadApartment;
				void* _ptr;
			} uIntf;
			uIntf.iMultiThreadApartment = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEMultiThreadApartment, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iMultiThreadApartment)
				{
					ICEMultiThreadApartment* tmp = _iMultiThreadApartment;
					_iMultiThreadApartment = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iMultiThreadApartment = uIntf.iMultiThreadApartment;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEMultiThreadApartment* object() const	{ return _iMultiThreadApartment; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEMultiThreadApartment* iOther)
	{
		if (_iMultiThreadApartment)
		{
			ICEMultiThreadApartment* tmp = _iMultiThreadApartment;
			_iMultiThreadApartment = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iMultiThreadApartment = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEMultiThreadApartment* detach()
	{
		ICEMultiThreadApartment* iIntf = _iMultiThreadApartment;
		_iMultiThreadApartment = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEMultiThreadApartment* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iMultiThreadApartment;
		if (_iMultiThreadApartment)
		{
			_iMultiThreadApartment->_vtbl->_addRef(_iMultiThreadApartment);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEMultiThreadApartment*() const	{ return _iMultiThreadApartment; }
	FORCEINLINE_WITHOUT_DEBUG ICEMultiThreadApartment& operator*() const	{ return *_iMultiThreadApartment; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iMultiThreadApartment == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEMultiThreadApartment* iOther) const	{ return (_iMultiThreadApartment != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEMultiThreadApartment* iOther) const	{ return (_iMultiThreadApartment == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEMultiThreadApartmentRef& operator=(const CEComICEMultiThreadApartmentRef& other)	{ return operator=(other._iMultiThreadApartment); }

	CEComICEMultiThreadApartmentRef& operator=(const ICEMultiThreadApartment* iOther)
	{
		if (_iMultiThreadApartment != iOther)
		{
			if (_iMultiThreadApartment)
			{
				ICEMultiThreadApartment* tmp = _iMultiThreadApartment;
				_iMultiThreadApartment = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iMultiThreadApartment = const_cast<ICEMultiThreadApartment*>(iOther);
			if (_iMultiThreadApartment)
			{
				_iMultiThreadApartment->_vtbl->_addRef(_iMultiThreadApartment);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEMultiThreadApartment** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEMultiThreadApartmentRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iMultiThreadApartment && "has a com object reference. clear first.");
		return & _iMultiThreadApartment; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEMultiThreadApartmentRef& other)
	{
		bool result = false;
		if (_iMultiThreadApartment)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iMultiThreadApartment);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iMultiThreadApartment ? _iMultiThreadApartment->_vtbl->_queryInterface(_iMultiThreadApartment, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iMultiThreadApartment) { _iMultiThreadApartment->_vtbl->_addRef(_iMultiThreadApartment); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iMultiThreadApartment) { _iMultiThreadApartment->_vtbl->_release(_iMultiThreadApartment); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getApartmentSupport(struct ICEApartmentSupport* *const iApartmentSupportOut)	{ return _iMultiThreadApartment ? _iMultiThreadApartment->_vtbl->_getApartmentSupport(_iMultiThreadApartment, iApartmentSupportOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setApartmentSupport(struct ICEApartmentSupport* iApartmentSupport)	{ return _iMultiThreadApartment ? _iMultiThreadApartment->_vtbl->_setApartmentSupport(_iMultiThreadApartment, iApartmentSupport) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult pushPendingMessage(struct ICEApartmentMessage* iMessage)	{ return _iMultiThreadApartment ? _iMultiThreadApartment->_vtbl->_pushPendingMessage(_iMultiThreadApartment, iMessage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult popPendingMessage(struct ICEApartmentMessage* iMessage)	{ return _iMultiThreadApartment ? _iMultiThreadApartment->_vtbl->_popPendingMessage(_iMultiThreadApartment, iMessage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getPendingMessage(struct ICEApartmentMessage* *const iMessageOut)	{ return _iMultiThreadApartment ? _iMultiThreadApartment->_vtbl->_getPendingMessage(_iMultiThreadApartment, iMessageOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult startLog()	{ return _iMultiThreadApartment ? _iMultiThreadApartment->_vtbl->_startLog(_iMultiThreadApartment) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult stopLog()	{ return _iMultiThreadApartment ? _iMultiThreadApartment->_vtbl->_stopLog(_iMultiThreadApartment) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult log(const char* info, UINT32 charLenInByte, UINT64 performanceCount)	{ return _iMultiThreadApartment ? _iMultiThreadApartment->_vtbl->_log(_iMultiThreadApartment, info, charLenInByte, performanceCount) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setMessagePostHandler(struct ICEApartmentMessagePostHandler* handler)	{ return _iMultiThreadApartment ? _iMultiThreadApartment->_vtbl->_setMessagePostHandler(_iMultiThreadApartment, handler) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult postMessage(struct ICEApartment* callerApartment, UINT32 mid, void* param, void* userData, invoke_message_callback callback)	{ return _iMultiThreadApartment ? _iMultiThreadApartment->_vtbl->_postMessage(_iMultiThreadApartment, callerApartment, mid, param, userData, callback) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult heartbeat()	{ return _iMultiThreadApartment ? _iMultiThreadApartment->_vtbl->_heartbeat(_iMultiThreadApartment) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult hasMessage(bool* hasMessageOut)	{ return _iMultiThreadApartment ? _iMultiThreadApartment->_vtbl->_hasMessage(_iMultiThreadApartment, hasMessageOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getNumPendingMessages(INT32* numOut)	{ return _iMultiThreadApartment ? _iMultiThreadApartment->_vtbl->_getNumPendingMessages(_iMultiThreadApartment, numOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCurrentMessage(struct ICEApartmentMessage* *const iMesageOut)	{ return _iMultiThreadApartment ? _iMultiThreadApartment->_vtbl->_getCurrentMessage(_iMultiThreadApartment, iMesageOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult pushMessageSemaphore(CEUSemaphoreRef semaphore)	{ return _iMultiThreadApartment ? _iMultiThreadApartment->_vtbl->_pushMessageSemaphore(_iMultiThreadApartment, semaphore) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult popMessageSemaphore(CEUSemaphoreRef semaphore)	{ return _iMultiThreadApartment ? _iMultiThreadApartment->_vtbl->_popMessageSemaphore(_iMultiThreadApartment, semaphore) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult waitMessageSemaphore(UINT32 timeoutMilliSeconds)	{ return _iMultiThreadApartment ? _iMultiThreadApartment->_vtbl->_waitMessageSemaphore(_iMultiThreadApartment, timeoutMilliSeconds) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEMultiThreadApartment* _iMultiThreadApartment;
};

/*! @}
 * end of CEComICEMultiThreadApartmentRef
 */

#endif // __cplusplus

#endif
