///////////////////////////////////////////////////////////////////////////////
// Copyright 2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CEUITypes_h__
#define __CEUITypes_h__

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CESysDefs.h"

#ifdef __cplusplus
extern "C"	
{
#endif

//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

	enum CELineStyle
	{
		LineStyle_Solid = 0,
		LineStyle_Dotted = 1,
		LineStyle_Dashed = 2,
	};

	enum CEHorizontalAlignType
	{
		Align_Left = 0,
		Align_Center = 1,
		Align_Right = 2
	};

	enum CEVerticalAlignType
	{
		Align_Top = 0,
		Align_VCenter = 1,
		Align_Bottom = 2
	};

    /*
     * horizontal direction
     */
	enum eCEHDirection
	{
		eCEHDirection_ltr,
		eCEHDirection_rtl
	};

    /*
     * unicode-bidi
     */
	enum eCEUnicodeBiDi
	{
		eCEUnicodeBidi_Normal,
		eCEUnicodeBidi_Embed,
		eCEUnicodeBidi_BidiOverride
	};

    /*
     * character type values
     */
	enum characterTypeValue
	{
		eCharacterType_all = 0,
		eCharacterType_number = 1,
		eCharacterType_alphabet = 2,
		eCharacterType_hankaku = 3,
		eCharacterType_zenkaku = 4,
		eCharacterType_katakana = 5,
		eCharacterType_hiragana = 6
	};

	enum imeModeValue
	{
		eImeMode_auto = 0,
		eImeMode_active = 1,
		eImeMode_inactive = 2,
		eImeMode_disabled = 3
	};

    // SSL mode
	enum eCESSLMode
	{
		eCESSLMode_None = 0,
		eCESSLMode_NonSecured,
		eCESSLMode_Secured,
		eCESSLMode_Mixed
	};


    ///////////////////////////////////////////////////////////////////////////////
    // main event types supported by framework
    ///////////////////////////////////////////////////////////////////////////////

	enum eCEEventCategory
	{
		eCEEventCategory_Action					= 1 << 0,
		eCEEventCategory_Adjustment				= 1 << 1,
		eCEEventCategory_ComponentEvent			= 1 << 2,
		eCEEventCategory_ContainerEvent			= 1 << 3,
		eCEEventCategory_FocusEvent				= 1 << 4,
		eCEEventCategory_KeyEvent					= 1 << 5,
		eCEEventCategory_MouseEvent				= 1 << 6,		
		eCEEventCategory_PaintEvent				= 1 << 7,
		eCEEventCategory_WindowEvent				= 1 << 8,
		eCEEventCategory_ItemEvent					= 1 << 9,
		eCEEventCategory_TextChangeEvent			= 1 << 10,
		eCEEventCategory_PropertyChangeEvent		= 1 << 11,
		eCEEventCategory_ListDataEvent				= 1 << 12,
		eCEEventCategory_ListSelectionEvent		= 1 << 13,
		eCEEventCategory_ColumnHeaderEvent			= 1 << 14,
		eCEEventCategory_TreeModelEvent			= 1 << 15,
		eCEEventCategory_TreeSelectionEvent		= 1 << 16,
		eCEEventCategory_TreeCollapseExpandEvent	= 1 << 17,
		eCEEventCategory_TimerEvent				= 1 << 18,
		eCEEventCategory_MessageQueueEvent			= 1 << 19,
		eCEEventCategory_CallbackEvent				= 1 << 20,
		eCEEventCategory_ScreenEvent				= 1 << 22,
		eCEEventCategory_CustomEvent				= 1 << 31,
		eCEEventCategory_Mask						= 0xFFFFFFFF,
	};


	//////////////////////////////
	// keyboard event
	//////////////////////////////

    // keyboard event types
	enum eCEKeyboardEventType
	{
		eCEKeyboardEventType_KeyDown = 0,
		eCEKeyboardEventType_KeyUp = 1,
		eCEKeyboardEventType_KeyTyped = 2
	};

	enum  eCEKeyModifier
	{
		eCEKeyModifier_NONE		= 0,
		eCEKeyModifier_CTRL		= 1 << 0,
		eCEKeyModifier_SHIFT		= 1 << 1,
		eCEKeyModifier_ALT		= 1 << 2,
		eCEKeyModifier_NUMMODIFIERS = 3,
	};

	enum eCEVirtualKey
	{
		eCEVK_UNDEFINED			= 0,
		eCEVK_ENTER				= '\n',
		eCEVK_BACK_SPACE			= '\b',
		eCEVK_TAB				= '\t',
		eCEVK_CARRAIGE_RETURN	= '\r',
		eCEVK_CANCEL				= 0x03,
		eCEVK_CLEAR				= 0x0C,
		eCEVK_SHIFT				= 0x10,
		eCEVK_CONTROL			= 0x11,
		eCEVK_ALT				= 0x12,
		eCEVK_PAUSE				= 0x13,
		eCEVK_CAPS_LOCK			= 0x14,
		eCEVK_ESCAPE				= 0x1B,

		eCEVK_SPACE				= 0x20,
		eCEVK_PAGE_UP			= 0x21,
		eCEVK_PAGE_DOWN			= 0x22,
		eCEVK_END				= 0x23,
		eCEVK_HOME				= 0x24,
		eCEVK_LEFT				= 0x25,
		eCEVK_UP					= 0x26,
		eCEVK_RIGHT				= 0x27,
		eCEVK_DOWN				= 0x28,

		eCEVK_SELECT				= 0x29,
		eCEVK_PRINT				= 0x2A,
		eCEVK_EXECUTE			= 0x2B,
		eCEVK_SNAPSHOT			= 0x2C,
		eCEVK_INSERT				= 0x2D,
		eCEVK_DELETE				= 0x2E,
		eCEVK_HELP				= 0x2F,

		// ascii '0' thru '9' (0x30 - 0x39)
		eCEVK_0					= 0x30,
		eCEVK_1					= 0x31,
		eCEVK_2					= 0x32,
		eCEVK_3					= 0x33,
		eCEVK_4					= 0x34,
		eCEVK_5					= 0x35,
		eCEVK_6					= 0x36,
		eCEVK_7					= 0x37,
		eCEVK_8					= 0x38,
		eCEVK_9					= 0x39,

		// ascii 'A' thru 'Z' (0x41 - 0x5A)
		eCEVK_A					= 0x41,
		eCEVK_B					= 0x42,
		eCEVK_C					= 0x43,
		eCEVK_D					= 0x44,
		eCEVK_E					= 0x45,
		eCEVK_F					= 0x46,
		eCEVK_G					= 0x47,
		eCEVK_H					= 0x48,
		eCEVK_I					= 0x49,
		eCEVK_J					= 0x4A,
		eCEVK_K					= 0x4B,
		eCEVK_L					= 0x4C,
		eCEVK_M					= 0x4D,
		eCEVK_N					= 0x4E,
		eCEVK_O					= 0x4F,
		eCEVK_P					= 0x50,
		eCEVK_Q					= 0x51,
		eCEVK_R					= 0x52,
		eCEVK_S					= 0x53,
		eCEVK_T					= 0x54,
		eCEVK_U					= 0x55,
		eCEVK_V					= 0x56,
		eCEVK_W					= 0x57,
		eCEVK_X					= 0x58,
		eCEVK_Y					= 0x59,
		eCEVK_Z					= 0x5A,

		eCEVK_LWIN				= 0x5B,
		eCEVK_RWIN				= 0x5C,
		eCEVK_APPS				= 0x5D,

		eCEVK_NUMPAD0			= 0x60,
		eCEVK_NUMPAD1			= 0x61,
		eCEVK_NUMPAD2			= 0x62,
		eCEVK_NUMPAD3			= 0x63,
		eCEVK_NUMPAD4			= 0x64,
		eCEVK_NUMPAD5			= 0x65,
		eCEVK_NUMPAD6			= 0x66,
		eCEVK_NUMPAD7			= 0x67,
		eCEVK_NUMPAD8			= 0x68,
		eCEVK_NUMPAD9			= 0x69,
		eCEVK_MULTIPLY			= 0x6A,
		eCEVK_ADD				= 0x6B,
		eCEVK_SEPARATER			= 0x6C,
		eCEVK_SUBTRACT			= 0x6D,
		eCEVK_DECIMAL			= 0x6E,
		eCEVK_DIVIDE				= 0x6F,

		eCEVK_F1					= 0x70,
		eCEVK_F2					= 0x71,
		eCEVK_F3					= 0x72,
		eCEVK_F4					= 0x73,
		eCEVK_F5					= 0x74,
		eCEVK_F6					= 0x75,
		eCEVK_F7					= 0x76,
		eCEVK_F8					= 0x77,
		eCEVK_F9					= 0x78,
		eCEVK_F10				= 0x79,
		eCEVK_F11				= 0x7A,
		eCEVK_F12				= 0x7B,
		eCEVK_F13				= 0x7C,
		eCEVK_F14				= 0x7D,
		eCEVK_F15				= 0x7E,
		eCEVK_F16				= 0x7F,
		eCEVK_F17				= 0x80,
		eCEVK_F18				= 0x81,
		eCEVK_F19				= 0x82,
		eCEVK_F20				= 0x83,
		eCEVK_F21				= 0x84,
		eCEVK_F22				= 0x85,
		eCEVK_F23				= 0x86,
		eCEVK_F24				= 0x87,

		eCEVK_NUM_LOCK			= 0x90,
		eCEVK_SCROLL_LOCK		= 0x91,

		// following keys are available only on Japanese 106/109 keyboard
		eCEVK_KANA				= 0x15,		// Japanese Hiragana/Katakana key
		eCEVK_CONVERT			= 0x1C,		// Japanese IME Conversion key
		eCEVK_NONCONVERT			= 0x1D,		// Japanese IME Non-conversion key
		eCEVK_MODECHANGE			= 0x1F,		// Japanese Halfwidth/Fullwidth/Kanji key

		// CEA-2014
		eCEVK_FINAL						= 0x18,
		eCEVK_KANJI						= 0x19,
		eCEVK_ACCEPT					= 0x1E,
		eCEVK_COMMA						= 0x2C + 0x1000,
		eCEVK_PERIOD					= 0x2E + 0x1000,
		eCEVK_SLASH						= 0x2F + 0x1000,
		eCEVK_SEMICOLON					= 0x3B,
		eCEVK_EQUALS					= 0x3D,
		eCEVK_OPEN_BRACKET				= 0x5B + 0x1000,
		eCEVK_BACK_SLASH				= 0x5C + 0x1000,
		eCEVK_CLOSE_BRACKET				= 0x5D + 0x1000,
		eCEVK_PRINTSCREEN				= 0x9A,
		eCEVK_META						= 0x9D,
		eCEVK_BACK_QUOTE				= 0xC0,
		eCEVK_QUOTE						= 0xDE,
		eCEVK_RED						= 0x193,
		eCEVK_GREEN						= 0x194,
		eCEVK_YELLOW					= 0x195,
		eCEVK_BLUE						= 0x196,
		eCEVK_GREY						= 0x197,
		eCEVK_BROWN						= 0x198,
		eCEVK_POWER						= 0x199,
		eCEVK_DIMMER					= 0x19A,
		eCEVK_WINK						= 0x19B,
		eCEVK_REWIND					= 0x19C,
		eCEVK_STOP						= 0x19D,
		eCEVK_EJECT_TOGGLE				= 0x19E,
		eCEVK_PLAY						= 0x19F,
		eCEVK_RECORD					= 0x1A0,
		eCEVK_FAST_FWD					= 0x1A1,
		eCEVK_PLAY_SPEED_UP				= 0x1A2,
		eCEVK_PLAY_SPEED_DOWN			= 0x1A3,
		eCEVK_PLAY_SPEED_RESET			= 0x1A4,
		eCEVK_RECORD_SPEED_NEXT			= 0x1A5,
		eCEVK_GO_TO_START				= 0x1A6,
		eCEVK_GO_TO_END					= 0x1A7,
		eCEVK_TRACK_PREV				= 0x1A8,
		eCEVK_TRACK_NEXT				= 0x1A9,
		eCEVK_RANDOM_TOGGLE				= 0x1AA,
		eCEVK_CHANNEL_UP				= 0x1AB,
		eCEVK_CHANNEL_DOWN				= 0x1AC,
		eCEVK_STORE_FAVORITE_0			= 0x1AD,
		eCEVK_STORE_FAVORITE_1			= 0x1AE,
		eCEVK_STORE_FAVORITE_2			= 0x1AF,
		eCEVK_STORE_FAVORITE_3			= 0x1B0,
		eCEVK_RECALL_FAVORITE_0			= 0x1B1,
		eCEVK_RECALL_FAVORITE_1			= 0x1B2,
		eCEVK_RECALL_FAVORITE_2			= 0x1B3,
		eCEVK_RECALL_FAVORITE_3			= 0x1B4,
		eCEVK_CLEAR_FAVORITE_0			= 0x1B5,
		eCEVK_CLEAR_FAVORITE_1			= 0x1B6,
		eCEVK_CLEAR_FAVORITE_2			= 0x1B7,
		eCEVK_CLEAR_FAVORITE_3			= 0x1B8,
		eCEVK_SCAN_CHANNELS_TOGGLE		= 0x1B9,
		eCEVK_PINP_TOGGLE				= 0x1BA,
		eCEVK_SPLIT_SCREEN_TOGGLE		= 0x1BB,
		eCEVK_DISPLAY_SWAP				= 0x1BC,
		eCEVK_SCREEN_MODE_NEXT			= 0x1BD,
		eCEVK_VIDEO_MODE_NEXT			= 0x1BE,
		eCEVK_VOLUME_UP					= 0x1BF,
		eCEVK_VOLUME_DOWN				= 0x1C0,
		eCEVK_MUTE						= 0x1C1,
		eCEVK_SURROUND_MODE_NEXT		= 0x1C2,
		eCEVK_BALANCE_RIGHT				= 0x1C3,
		eCEVK_BALANCE_LEFT				= 0x1C4,
		eCEVK_FADER_FRONT				= 0x1C5,
		eCEVK_FADER_REAR				= 0x1C6,
		eCEVK_BASS_BOOST_UP				= 0x1C7,
		eCEVK_BASS_BOOST_DOWN			= 0x1C8,
		eCEVK_INFO						= 0x1C9,
		eCEVK_GUIDE						= 0x1CA,
		eCEVK_TELETEXT					= 0x1CB,
		eCEVK_SUBTITLE					= 0x1CC,
		eCEVK_BACK						= 0x1CD,
		eCEVK_MENU						= 0x1CE,
	};


	//////////////////////////////
	// mouse event
	//////////////////////////////

	enum eCEMouseEventType
	{
		eCEMouseEventType_ButtonDown = 0,
		eCEMouseEventType_ButtonUp = 1,
		eCEMouseEventType_ButtonDoubleClicked = 2,
		eCEMouseEventType_ButtonTripleClicked = 3,
		eCEMouseEventType_Moved = 4,
		eCEMouseEventType_Dragged = 5,
		eCEMouseEventType_Entered = 6,
		eCEMouseEventType_Exited = 7,
		eCEMouseEventType_WheelForward = 8,
		eCEMouseEventType_WheelBackward = 9,
		eCEMouseEventType_WheelRotated = 10			//!< used in the new window system in CEDpyMouseEventParam._type.
		//!< to support horizontal and vertical wheel at the same time,
		//!< eCEMouseEventType_WheelForward/Backward are insufficient.
	};

    enum eCEMouseButton
	{
		eCEMouseButton_DontCare = 0,
		eCEMouseButton_Left = 1,
		eCEMouseButton_Middle = 2,
		eCEMouseButton_Right = 3
	};


	//////////////////////////////
	// window event
	//////////////////////////////

	enum eCEWindowEventType
	{
		eCEWindowEventType_Activated = 0,
		eCEWindowEventType_DeActivated = 1,
		eCEWindowEventType_Restored = 2,
		eCEWindowEventType_Minimized = 3,
		eCEWindowEventType_Closing = 4,
		eCEWindowEventType_NonClientButtonDown = 5,
		eCEWindowEventType_ActivatedBySubWindow = 6,   // Only Wsys.
		eCEWindowEventType_DeActivatedBySubWindow = 7  // Only Wsys.
	};


	//////////////////////////////
	// focus event 
	//////////////////////////////

	enum eCEFocusEventType
	{
		eCEFocusEventType_FocusGained = 0,
		eCEFocusEventType_FocusLost = 1
	};

	//////////////////////////////
	// cursor type 
	//////////////////////////////

	enum eCECursorType
	{
		eCECursorType_Arrow = 0,
		eCECursorType_IBeam = 1,
		eCECursorType_Wait = 2,
		eCECursorType_Cross = 3,
		eCECursorType_UpArrow = 4,
		eCECursorType_SizeNWSE = 5,
		eCECursorType_SizeNESW = 6,
		eCECursorType_SizeWE = 7,
		eCECursorType_SizeNS = 8,
		eCECursorType_SizeAll = 9,
		eCECursorType_No = 10,
		eCECursorType_Hand = 11,
		eCECursorType_AppStarting = 12,
		eCECursorType_Help = 13
	};

    //----------------------------------------------------------------
    // Structures
    //----------------------------------------------------------------

	struct ICEUnknown;

	//////////////////////////////
	// FixedPoint-based types
	//////////////////////////////

	typedef INT32 CEFixed16d16;


	//////////////////////////////
	// Int-based types
	//////////////////////////////

	typedef struct _CERGBColor
	{
		union 
		{
			struct 
			{
				UINT8 red;
				UINT8 green;
				UINT8 blue;
				UINT8 padding;
			
			}	_components;

			INT32	_value;
		
		} _color;
	
	} CERGBColor;

	typedef struct _CERGBAColor
	{
		union 
		{
			struct 
			{
				UINT8 red;
				UINT8 green;
				UINT8 blue;
				UINT8 alpha;
			
			}	_components;

			INT32	_value;
		
		} _color;
	
	} CERGBAColor;

	typedef struct _CEPointBase
	{
		INT32 _x;
		INT32 _y;
		
	} CEPointBase;

	typedef struct _CEDim
	{
		INT32 _width;
		INT32 _height;
	} CEDim;

	typedef struct _CERect
	{
		INT32 _x;
		INT32 _y;
		INT32 _width;
		INT32 _height;
	
	} CERect;

	typedef struct _CEInsetsBase
	{
		INT32 _left;
		INT32 _right;
		INT32 _top;
		INT32 _bottom;
	} CEInsetsBase;

	// TODO: can we consolidate CEInsetBase and CEInsetBaseU?
	typedef struct _CEInsetsBaseU
	{
		UINT16 _top;
		UINT16 _left;
		UINT16 _bottom;
		UINT16 _right;
	} CEInsetsBaseU;

	// CERectSet represents a region as a set of disjoint rectangles
	// if the region is empty, _numOfRects and _rects should be 0.
	typedef struct _CERectSet
	{
		UINT32			_numOfRects;
		const CERect*	_rects;
	} CERectSet;

	typedef struct _CERawDataBuffer
	{
		UINT32 _length;
		UINT8* _data;
	} CERawDataBuffer;

	//////////////////////////////
	// Float-based types
	//////////////////////////////

	typedef struct _CEPointF
	{
		float _x;
		float _y;

	} CEPointF;

	typedef struct _CEDimF
	{
		float _width;
		float _height;
	} CEDimF;

	typedef struct _CERectF
	{
		float _x;
		float _y;
		float _width;
		float _height;
	} CERectF;


	//////////////////////////////
	// Event types
	//////////////////////////////

    /*!
     *  Action event parameter strcture.
     */
	struct CEActionEventParam
	{
		UINT16 id; //!< Action Event ID.
	};

    /*!
     *  Keyboard event parameter strcture.
     */
	struct CEKeyboardEventParam
	{
		eCEKeyboardEventType type;  //!< Keyboard event type.
		eCEVirtualKey virtualKey; //!< Virtual key code.
		UTCHAR keyChar;          //!< Key Charactor
		UINT32 modifiers;	 //!< Key Modifiers
	};

    /*!
     * Mouse Event Parameter Structure
     * This event parameter is given by FrameWindow, Dialog, List, Tab, ComboBox
     */
	struct CEMouseEventParam
	{
		eCEMouseEventType type; //!< mouse event type
		CEPointBase point;   //!< coordinate of the event
		eCEMouseButton button;  //!< mouse button of the event
		UINT32 modifiers;    //!< Key Modifiers
		INT32 wheelRotationX;
		INT32 wheelRotationY;
	};

    /*!
     * CEPaintEventParam
     */
	struct CEPaintEventParam
	{
		CEInsetsBaseU   rect;			//!< invalidate rect
		ICEUnknown*     graphicInterface;	//!< graphic interface
		CERectSet		region;	//!< locked region
	};

    /*!
     * CETimerEventParam
     */
	struct CETimerEventParam
	{
	};


#ifdef __cplusplus
}; // end of extern "C"
#endif

#endif // __CEUITypes_h__

