///////////////////////////////////////////////////////////////////////////////
// Copyright 2004,2008,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////
// Facility_System
////////////////////////////////////////////////////

CEHRESULT_FACILITY_START(SYS)
    CEHRESULT_ERR(SYS, EPERM)  // 0xa2010001
    CEHRESULT_ERR(SYS, ENOENT)  // 0xa2010002
    CEHRESULT_ERR(SYS, ESRCH)  // 0xa2010003
    CEHRESULT_ERR(SYS, EINTR)  // 0xa2010004
    CEHRESULT_ERR(SYS, EIO)  // 0xa2010005
    CEHRESULT_ERR(SYS, ENXIO)  // 0xa2010006
    CEHRESULT_ERR(SYS, E2BIG)  // 0xa2010007
    CEHRESULT_ERR(SYS, ENOEXEC)  // 0xa2010008
    CEHRESULT_ERR(SYS, EBADF)  // 0xa2010009
    CEHRESULT_ERR(SYS, ECHILD)  // 0xa201000a
    CEHRESULT_ERR(SYS, EAGAIN)  // 0xa201000b
    CEHRESULT_ERR(SYS, ENOMEM)  // 0xa201000c
    CEHRESULT_ERR(SYS, EACCES)  // 0xa201000d
    CEHRESULT_ERR(SYS, EFAULT)  // 0xa201000e
    CEHRESULT_ERR(SYS, EBUSY)  // 0xa201000f
    CEHRESULT_ERR(SYS, EEXIST)  // 0xa2010010
    CEHRESULT_ERR(SYS, EXDEV)  // 0xa2010011
    CEHRESULT_ERR(SYS, ENODEV)  // 0xa2010012
    CEHRESULT_ERR(SYS, ENOTDIR)  // 0xa2010013
    CEHRESULT_ERR(SYS, EISDIR)  // 0xa2010014
    CEHRESULT_ERR(SYS, EINVAL)  // 0xa2020015
    CEHRESULT_ERR(SYS, ENFILE)  // 0xa2010016
    CEHRESULT_ERR(SYS, EMFILE)  // 0xa2010017
    CEHRESULT_ERR(SYS, ENOTTY)  // 0xa2010018
    CEHRESULT_ERR(SYS, EFBIG)  // 0xa2010019
    CEHRESULT_ERR(SYS, ENOSPC)  // 0xa201001a
    CEHRESULT_ERR(SYS, ESPIPE)  // 0xa201001b
    CEHRESULT_ERR(SYS, EROFS)  // 0xa201001c
    CEHRESULT_ERR(SYS, EMLINK)  // 0xa201001d
    CEHRESULT_ERR(SYS, EPIPE)  // 0xa201001e
    CEHRESULT_ERR(SYS, EDOM)  // 0xa201001f
    CEHRESULT_ERR(SYS, EDEADLK)  // 0xa2010020
    CEHRESULT_ERR(SYS, ENAMETOOLONG)  // 0xa2010021
    CEHRESULT_ERR(SYS, ENOLCK)  // 0xa2010022
    CEHRESULT_ERR(SYS, ENOSYS)  // 0xa2010023
    CEHRESULT_ERR(SYS, ENOTEMPTY)  // 0xa2010024
CEHRESULT_FACILITY_END(SYS)


////////////////////////////////////////////////////
// Facility_FileSystem
////////////////////////////////////////////////////

CEHRESULT_FACILITY_START(FS)
    CEHRESULT_ERR(FS, EPERM)  // 0xa2020001  :  Operation not permitted. Only the owner of a file can do the operation.
    CEHRESULT_ERR(FS, ENOENT)  // 0xa2020002 :  No such file or directory
    CEHRESULT_ERR(FS, ESRCH)  // 0xa2020003
    CEHRESULT_ERR(FS, EINTR)  // 0xa2020004
    CEHRESULT_ERR(FS, EIO)  // 0xa2020005
    CEHRESULT_ERR(FS, ENXIO)  // 0xa2020006
    CEHRESULT_ERR(FS, E2BIG)  // 0xa2020007
    CEHRESULT_ERR(FS, ENOEXEC)  // 0xa2020008
    CEHRESULT_ERR(FS, EBADF)  // 0xa2020009
    CEHRESULT_ERR(FS, ECHILD)  // 0xa202000a
    CEHRESULT_ERR(FS, EAGAIN)  // 0xa202000b :  System resource temporary unavailable.
    CEHRESULT_ERR(FS, ENOMEM)  // 0xa202000c :  Out of memory
    CEHRESULT_ERR(FS, EACCES)  // 0xa202000d :  Permission denied.
    CEHRESULT_ERR(FS, EFAULT)  // 0xa202000e
    CEHRESULT_ERR(FS, EBUSY)  // 0xa202000f
    CEHRESULT_ERR(FS, EEXIST)  // 0xa2020010
    CEHRESULT_ERR(FS, EXDEV)  // 0xa2020011
    CEHRESULT_ERR(FS, ENODEV)  // 0xa2020012
    CEHRESULT_ERR(FS, ENOTDIR)  // 0xa2020013 :  File is not a directory, although the operation assumes a directory. 
    CEHRESULT_ERR(FS, EISDIR)  // 0xa2020014  :  File is a directory, although the operation assumes a normal file.
    CEHRESULT_ERR(FS, EINVAL)  // 0xa2020015
    CEHRESULT_ERR(FS, ENFILE)  // 0xa2020016
    CEHRESULT_ERR(FS, EMFILE)  // 0xa2020017
    CEHRESULT_ERR(FS, ENOTTY)  // 0xa2020018
    CEHRESULT_ERR(FS, EFBIG)  // 0xa2020019
    CEHRESULT_ERR(FS, ENOSPC)  // 0xa202001a
    CEHRESULT_ERR(FS, ESPIPE)  // 0xa202001b
    CEHRESULT_ERR(FS, EROFS)  // 0xa202001c
    CEHRESULT_ERR(FS, EMLINK)  // 0xa202001d
    CEHRESULT_ERR(FS, EPIPE)  // 0xa202001e
    CEHRESULT_ERR(FS, EDOM)  // 0xa202001f
    CEHRESULT_ERR(FS, EDEADLK)  // 0xa2020020
    CEHRESULT_ERR(FS, ENAMETOOLONG)  // 0xa2020021
    CEHRESULT_ERR(FS, ENOLCK)  // 0xa2020022
    CEHRESULT_ERR(FS, ENOSYS)  // 0xa2020023
    CEHRESULT_ERR(FS, ENOTEMPTY)  // 0xa2020024
    CEHRESULT_ERR(FS, EFPOS)  // 0xa2020025
    CEHRESULT_ERR(FS, ERANGE)  // 0xa2020026
    CEHRESULT_ERR(FS, EBADMSG)  // 0xa2020027
    CEHRESULT_ERR(FS, ECANCELED)  // 0xa2020028
    CEHRESULT_ERR(FS, EILSEQ)  // 0xa2020029
    CEHRESULT_ERR(FS, EINPROGRESS)  // 0xa202002a
    CEHRESULT_ERR(FS, EMSGSIZE)  // 0xa202002b
    CEHRESULT_ERR(FS, ENOTSUP)  // 0xa202002c
    CEHRESULT_ERR(FS, ETIMEDOUT)  // 0xa202002d
    CEHRESULT_ERR(FS, EFSSPECIFIC)  // 0xa202002e
    CEHRESULT_ERR(FS, EOVERFLOW)  // 0xa202002f
    CEHRESULT_ERR(FS, ENOTMOUNTED)  // 0xa2020030
CEHRESULT_FACILITY_END(FS)


////////////////////////////////////////////////////
// Facility_Socket
////////////////////////////////////////////////////

CEHRESULT_FACILITY_START(SOCKET)
    CEHRESULT_ERR(SOCKET, EINTR)  // 0xa2030001
    CEHRESULT_ERR(SOCKET, EBADF)  // 0xa2030002
    CEHRESULT_ERR(SOCKET, EACCES)  // 0xa2030003
    CEHRESULT_ERR(SOCKET, EFAULT)  // 0xa2030004
    CEHRESULT_ERR(SOCKET, EINVAL)  // 0xa2030005
    CEHRESULT_ERR(SOCKET, EMFILE)  // 0xa2030006
    CEHRESULT_ERR(SOCKET, EWOULDBLOCK)  // 0xa2030007
    CEHRESULT_ERR(SOCKET, EINPROGRESS)  // 0xa2030008
    CEHRESULT_ERR(SOCKET, EALREADY)  // 0xa2030009
    CEHRESULT_ERR(SOCKET, ENOTSOCK)  // 0xa203000a
    CEHRESULT_ERR(SOCKET, EDESTADDRREQ)  // 0xa203000b
    CEHRESULT_ERR(SOCKET, EMSGSIZE)  // 0xa203000c
    CEHRESULT_ERR(SOCKET, EPROTOTYPE)  // 0xa203000d
    CEHRESULT_ERR(SOCKET, ENOPROTOOPT)  // 0xa203000e
    CEHRESULT_ERR(SOCKET, EPROTONOSUPPORT)  // 0xa203000f
    CEHRESULT_ERR(SOCKET, ESOCKTNOSUPPORT)  // 0xa2030010
    CEHRESULT_ERR(SOCKET, EOPNOTSUPP)  // 0xa2030011
    CEHRESULT_ERR(SOCKET, EPFNOSUPPORT)  // 0xa2030012
    CEHRESULT_ERR(SOCKET, EAFNOSUPPORT)  // 0xa2030013
    CEHRESULT_ERR(SOCKET, EADDRINUSE)  // 0xa2030014
    CEHRESULT_ERR(SOCKET, EADDRNOTAVAIL)  // 0xa2030015
    CEHRESULT_ERR(SOCKET, ENETDOWN)  // 0xa2030016
    CEHRESULT_ERR(SOCKET, ENETUNREACH)  // 0xa2030017
    CEHRESULT_ERR(SOCKET, ENETRESET)  // 0xa2030018
    CEHRESULT_ERR(SOCKET, ECONNABORTED)  // 0xa2030019
    CEHRESULT_ERR(SOCKET, ECONNRESET)  // 0xa203001a
    CEHRESULT_ERR(SOCKET, ENOBUFS)  // 0xa203001b
    CEHRESULT_ERR(SOCKET, EISCONN)  // 0xa203001c
    CEHRESULT_ERR(SOCKET, ENOTCONN)  // 0xa203001d
    CEHRESULT_ERR(SOCKET, ESHUTDOWN)  // 0xa203001e
    CEHRESULT_ERR(SOCKET, ETOOMANYREFS)  // 0xa203001f
    CEHRESULT_ERR(SOCKET, ETIMEDOUT)  // 0xa2030020
    CEHRESULT_ERR(SOCKET, ECONNREFUSED)  // 0xa2030021
    CEHRESULT_ERR(SOCKET, ELOOP)  // 0xa2030022
    CEHRESULT_ERR(SOCKET, ENAMETOOLONG)  // 0xa2030023
    CEHRESULT_ERR(SOCKET, EHOSTDOWN)  // 0xa2030024
    CEHRESULT_ERR(SOCKET, EHOSTUNREACH)  // 0xa2030025
    CEHRESULT_ERR(SOCKET, ENOTEMPTY)  // 0xa2030026
    CEHRESULT_ERR(SOCKET, EPROCLIM)  // 0xa2030027
    CEHRESULT_ERR(SOCKET, EUSERS)  // 0xa2030028
    CEHRESULT_ERR(SOCKET, EDQUOT)  // 0xa2030029
    CEHRESULT_ERR(SOCKET, ESTALE)  // 0xa203002a
    CEHRESULT_ERR(SOCKET, EREMOTE)  // 0xa203002b         
CEHRESULT_FACILITY_END(SOCKET)

////////////////////////////////////////////////////
// Facility_DNS
////////////////////////////////////////////////////

CEHRESULT_FACILITY_START(DNS)
	CEHRESULT_ERR(DNS, EAI_AGAIN)              // 0xa2040001
	CEHRESULT_ERR(DNS, EAI_FAIL)               // 0xa2040002        
	CEHRESULT_ERR(DNS, EAI_NONAME)             // 0xa2040003
	CEHRESULT_ERR(DNS, EAI_NODATA)             // 0xa2040004
	CEHRESULT_ERR(DNS, EAI_BADFLAGS)           // 0xa2040005
	CEHRESULT_ERR(DNS, EAI_FAMILY)             // 0xa2040006
	CEHRESULT_ERR(DNS, EAI_MEMORY)             // 0xa2040007
	CEHRESULT_ERR(DNS, EAI_SERVICE)            // 0xa2040008
	CEHRESULT_ERR(DNS, EAI_SOCKTYPE)           // 0xa2040009
CEHRESULT_FACILITY_END(DNS)

////////////////////////////////////////////////////
// Facility_SSL
////////////////////////////////////////////////////

CEHRESULT_FACILITY_START(SSL)
	CEHRESULT_ERR(SSL, VERSION_ERR)              // 
	CEHRESULT_ERR(SSL, ALERT_HANDSHAKE)          // 
CEHRESULT_FACILITY_END(SSL)


////////////////////////////////////////////////////
// Facility_Silk
////////////////////////////////////////////////////
CEHRESULT_FACILITY_START(SILK)

	// general errors
	CEHRESULT_BLOCK_START(SILK, GENERAL, 0)
		CEHRESULT_ERR(SILK, GENERIC_ERROR)   //  0xa2400001
		CEHRESULT_ERR(SILK, MEMERR)	                //  0xa2400002 - out of memory
		CEHRESULT_ERR(SILK, READONLY)	                //  0xa2400003
		CEHRESULT_ERR(SILK, BADARGS)                  //  0xa2400004 - arguments are invalid 
        CEHRESULT_ERR(SILK, BADSTATE)  // 0xa2400005
        CEHRESULT_ERR(SILK, OUTOFDATA)  // 0xa2400006
        CEHRESULT_ERR(SILK, DUPLICATE)  // 0xa2400007
        CEHRESULT_ERR(SILK, UNINITIALIZED)  // 0xa2400008
        CEHRESULT_ERR(SILK, NOTFOUND)  // 0xa2400009
        CEHRESULT_ERR(SILK, BADARRAYINDEX)  // 0xa240000a
        CEHRESULT_ERR(SILK, NOPERMISSION)  // 0xa240000b
        CEHRESULT_ERR(SILK, WRONGTYPE)  // 0xa240000c
        CEHRESULT_ERR(SILK, NOTIMPLEMENTED)  // 0xa240000d
        CEHRESULT_ERR(SILK, TOOMANY)  // 0xa240000e
        CEHRESULT_ERR(SILK, VALUEINVALID)  // 0xa240000f
        CEHRESULT_ERR(SILK, TIMEOUT)  // 0xa2400010
        CEHRESULT_ERR(SILK, OPERATION_CANCELLED)  // 0xa2400011
		CEHRESULT_ERR(SILK, OPERATION_FAILED)	//  0xa2400012 - internal error. supposed not to be given to application
		CEHRESULT_ERR(SILK, OUTOFSPACE)	//  0xa2400013
		CEHRESULT_ERR(SILK, INVALID_CHAR)	//  0xa2400014
		CEHRESULT_ERR(SILK, POSTED_MESSAGE_CANCELLED)	//  0xa2400015 - posted message is canceled.
		CEHRESULT_ERR(SILK, INSTANCE_UNAVAILABLE)	//  0xa2400016 - the interface is forced to be unavailable
		CEHRESULT_ERR(SILK, POSTED_MESSAGE_DEFERRED)	//  0xa2400017 - posted message is deferred.
        CEHRESULT_ERR(SILK, INVALID_ADDRESS)  // 0xa2400018
        CEHRESULT_ERR(SILK, CONNECT_FAILED)  // 0xa2400019
        CEHRESULT_ERR(SILK, WRONGVERSION)  // 0xa240001a
        CEHRESULT_ERR(SILK, BUSY)  // 0xa240001b
		CEHRESULT_ERR(SILK, PURGED)	//  0xa240001c - memory was purged.

        CEHRESULT_ERR(SILK, PAGE_UNAVAILABLE)  // 0xa240001d
        CEHRESULT_ERR(SILK, RESPONSE_NOT_RECEIVED)  // 0xa240001e
        CEHRESULT_ERR(SILK, CANNOT_FIND_SERVER)  // 0xa240001f
        CEHRESULT_ERR(SILK, FIND_DNS_SERVER)  // 0xa2400020
        CEHRESULT_ERR(SILK, CANNOT_BE_DISPLAYED)  // 0xa2400021
        CEHRESULT_ERR(SILK, BAD_NETWORK_SETTING)  // 0xa2400022
	CEHRESULT_BLOCK_END(SILK, GENERAL)

	// file errors
	CEHRESULT_BLOCK_START(SILK, FILE, 1)
        CEHRESULT_ERR(SILK, FILEIO)  // 0xa2400101
        CEHRESULT_ERR(SILK, FILENOTOPEN)  // 0xa2400102
        CEHRESULT_ERR(SILK, FILESTILLOPEN)  // 0xa2400103
        CEHRESULT_ERR(SILK, BOF)  // 0xa2400104
		CEHRESULT_ERR(SILK, EOF)	// 0xa2400105
        CEHRESULT_ERR(SILK, FILEIOPENDING)  // 0xa2400106
        CEHRESULT_ERR(SILK, FILEFORMAT_BROKEN)  // 0xa2400107
        CEHRESULT_ERR(SILK, FILEFORMAT_VERSION_MISMATCH)  // 0xa2400108
	CEHRESULT_BLOCK_END(SILK, FILE)

	// database errors 
	CEHRESULT_BLOCK_START(SILK, DB, 2)
		CEHRESULT_ERR(SILK, NULL_FIELD)  // 0xa2400201
        CEHRESULT_ERR(SILK, DATABASE_OPERATION_FAILED)  // 0xa2400202
        CEHRESULT_ERR(SILK, NO_MORE_DATA)  // 0xa2400203
        CEHRESULT_ERR(SILK, UNSUPPORTED_FILE_FORMAT_VERSION)  // 0xa2400204
        CEHRESULT_ERR(SILK, DATABASE_BROKEN)  // 0xa2400205
	CEHRESULT_BLOCK_END(SILK, DB)

	// Framework Resource Compiler errors
	CEHRESULT_BLOCK_START(SILK, CERC, 3)
        CEHRESULT_ERR(SILK, EXPAT_ERROR)  // 0xa2400301
        CEHRESULT_ERR(SILK, BAD_COMMANDLINE_ARGS)  // 0xa2400302
        CEHRESULT_ERR(SILK, CORRUPT_HEADER_FILE)  // 0xa2400303
        CEHRESULT_ERR(SILK, BAD_INPUTFILE_TYPE)  // 0xa2400304
        CEHRESULT_ERR(SILK, CANT_OPEN_FILE)  // 0xa2400305
        CEHRESULT_ERR(SILK, CANT_INITIALIZE_ATTRIBUTE_TABLE)  // 0xa2400306
        CEHRESULT_ERR(SILK, CANT_INITIALIZE_TAG_TABLE)  // 0xa2400307
        CEHRESULT_ERR(SILK, TAG_NOT_FOUND)  // 0xa2400308
        CEHRESULT_ERR(SILK, ATTRIBUTE_NOT_FOUND)  // 0xa2400309
        CEHRESULT_ERR(SILK, BAD_TYPE)  // 0xa240030a
        CEHRESULT_ERR(SILK, BAD_ATTRIBUTE_VALUE)  // 0xa240030b
        CEHRESULT_ERR(SILK, TAG_DATA)  // 0xa240030c
        CEHRESULT_ERR(SILK, CANT_VALIDATE)  // 0xa240030d
        CEHRESULT_ERR(SILK, NO_ID_ATTRIBUTE)  // 0xa240030e
        CEHRESULT_ERR(SILK, INVALID_ATTRIBUTE)  // 0xa240030f
	CEHRESULT_BLOCK_END(SILK, CERC)

	// plugin errors
	CEHRESULT_BLOCK_START(SILK, PLUGIN, 4)
        CEHRESULT_ERR(SILK, PLUGIN_GENERAL_ERROR)  // 0xa2400401
        CEHRESULT_ERR(SILK, PLUGIN_NOT_FOUND)  // 0xa2400402
        CEHRESULT_ERR(SILK, PLUGIN_CANNOT_LOAD_SHARED_LIBRARY)  // 0xa2400403
        CEHRESULT_ERR(SILK, PLUGIN_ENTRYPOINT_NOT_FOUND)  // 0xa2400404
        CEHRESULT_ERR(SILK, PLUGIN_BAD_CALLBACKS)  // 0xa2400405
	CEHRESULT_BLOCK_END(SILK, PLUGIN)

	// js errors
	CEHRESULT_BLOCK_START(SILK, JS, 5)
        CEHRESULT_ERR(SILK, JS_EXCEPTION_CAUGHT)  // 0xa2400501
        CEHRESULT_ERR(SILK, JS_DISABLED)  // 0xa2400502
        CEHRESULT_ERR(SILK, JS_NOT_EXECUTABLE)  // 0xa2400503
        CEHRESULT_ERR(SILK, JS_ACCESS_DENIED)  // 0xa2400504
        CEHRESULT_ERR(SILK, JS_XHR_SERVER_MOVED_URL)  // 0xa2400505
        CEHRESULT_ERR(SILK, JS_RUNTIME_ERROR)  // 0xa2400506
	CEHRESULT_BLOCK_END(SILK, JS)

CEHRESULT_FACILITY_END(SILK)


////////////////////////////////////////////////////
// Facility_SYSWRAP
////////////////////////////////////////////////////
CEHRESULT_FACILITY_START(SYSWRAP)

	// general errors
	CEHRESULT_BLOCK_START(SYSWRAP, GENERAL, 0)
		CEHRESULT_ERR(SYSWRAP, INVALID_HANDLE)   //  0xa2410001 -- Failed to convert CESysHandle to the corresponding cesyswrap internal object
	CEHRESULT_BLOCK_END(SYSWRAP, GENERAL)

	// I/O errors
	CEHRESULT_BLOCK_START(SYSWRAP, IO, 1)
		CEHRESULT_ERR(SYSWRAP, IO_PENDING)   //  0xa2410101 -- Overlapped I/O has been already in-progress.
		CEHRESULT_ERR(SYSWRAP, IO_CANCELED)  //  0xa2410102 -- Overlapped I/O has been canceled.
	CEHRESULT_BLOCK_END(SYSWRAP, IO)

	// MsgPipe errors
	CEHRESULT_BLOCK_START(SYSWRAP, MSGPIPE, 2)
		CEHRESULT_ERR(SYSWRAP, MSGPIPE_NO_DATA)				// 0xa2410201 -- the message pipe has been already closed at the remote end, when CESysMsgPipeSend() is called
		CEHRESULT_ERR(SYSWRAP, MSGPIPE_BROKEN_PIPE)			// 0xa2410202 -- the message pipe has been already closed at the remote end, when CESysMsgPipeRecv() is called
		CEHRESULT_ERR(SYSWRAP, MSGPIPE_CONNECTED)			// 0xa2410203 -- the message pipe has been already connected
		CEHRESULT_ERR(SYSWRAP, MSGPIPE_NAME_ALREADY_USED)	// 0xa2410204 -- the message pipe name has been already used
		CEHRESULT_ERR(SYSWRAP, MSGPIPE_NAME_NOT_FOUND)		// 0xa2410205 -- the specified name is not found in existing message pipes
		CEHRESULT_ERR(SYSWRAP, MSGPIPE_INVALID_NAME)		// 0xa2410206 -- the message pipe name is invalid
		CEHRESULT_ERR(SYSWRAP, MSGPIPE_INVALID_PARAMETER)	// 0xa2410207 -- the invalid parameter for the message pipe is specified
		CEHRESULT_ERR(SYSWRAP, MSGPIPE_NAME_TOO_LONG)		// 0xa2410208 -- the message pipe name is too long
		CEHRESULT_ERR(SYSWRAP, MSGPIPE_LISTENING)			// 0xa2410209 -- the message pipe is waiting for open from clients
		CEHRESULT_ERR(SYSWRAP, MSGPIPE_NOT_CONNECTED)		// 0xa241020a -- no thread or process at the other end of the message pipe
		CEHRESULT_ERR(SYSWRAP, MSGPIPE_ALREADY_OPENED)		// 0xa241020b -- the message pipe has been already opened exclusively
	CEHRESULT_BLOCK_END(SYSWRAP, MSGPIPE)

	// Socket errors
	CEHRESULT_BLOCK_START(SYSWRAP, SOCKET, 3)
		CEHRESULT_ERR(SYSWRAP, SOCKET_NOT_INITIALIZED)	//  0xa2410301 -- failed to initialize the underlying socket library
	CEHRESULT_BLOCK_END(SYSWRAP, SOCKET)


CEHRESULT_FACILITY_END(SYSWRAP)
