///////////////////////////////////////////////////////////////////////////////
// Copyright 2004,2007 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CESysCriticalSection_h__
#define __CESysCriticalSection_h__

#include "CESysConfig.h"
#include "CESysThread.h"

//#include CESYSCRITICALSECTION_TARGET_H


#ifdef __cplusplus
extern "C"
{
#endif

	typedef struct _CESysCriticalSection
	{
		double reserved[6];
	} CESysCriticalSection;


	CE_DLL_EXPORT void CESysInitializeCriticalSection(CESysCriticalSection* cs, const char* name);
	CE_DLL_EXPORT void CESysDeleteCriticalSection(CESysCriticalSection* cs);
	CE_DLL_EXPORT void CESysEnterCriticalSection(CESysCriticalSection* cs);
	CE_DLL_EXPORT bool CESysTryEnterCriticalSection(CESysCriticalSection* cs);
	CE_DLL_EXPORT void CESysLeaveCriticalSection(CESysCriticalSection* cs);

#ifdef __cplusplus
}
#endif



#endif // __CESysCriticalSection_h__
