///////////////////////////////////////////////////////////////////////////////
// Copyright 2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CESysCompilerSNC_h__
#define __CESysCompilerSNC_h__

/////////////////////////////////////////////
// Compiler name
/////////////////////////////////////////////

#define CE_COMPILER_SNC 1


/////////////////////////////////////
//  Type qualifiers
/////////////////////////////////////

#define CE_COMPILER_SNC 1
#define CE_INLINE __inline__
#define CE_FORCEINLINE __inline__ __attribute__((always_inline))

// FIXME: currently visibility has not been supported.   
#define CE_DLL_EXPORT // __attribute__((visibility("default")))

#define CE_NORETURN  
#define CE_MAY_ALIAS_TYPE(type) type
#define CE_ALIGNED(x)	__attribute__((__aligned__(x)))


/////////////////////////////////////
//  Compiler predefined macros
/////////////////////////////////////

#define CE_LITTLE_ENDIAN 1

#define CEFUNCSIG __PRETTY_FUNCTION__


/////////////////////////////////////
//  Disable typical warnings for generated sources
//  TODO: these pragmas should be moved to idl2h.pl or CESysLibs.h
/////////////////////////////////////

// warning 129: loop is not reachable from preceding code
#pragma diag_suppress=129

//  warning 178: variable "a" was declared but never referenced
#pragma diag_suppress=178

// warning 186: dynamic initialization in unreachable code
#pragma diag_suppress=186

// warning 187: pointless comparison of unsigned integer with zero
#pragma diag_suppress=187

// warning 237: controlling expression is constant
#pragma diag_suppress=237  

// warning 369: class "CLASSNAME" defines no constructor to initialize the following:   const member "CLASSNAME::MEMBERNAME"
#pragma diag_suppress=369

// warning 376: declaration requires a typedef name
#pragma diag_suppress=376

// warning 552: variable "dest" was set but never used
#pragma diag_suppress=552  

// warning 613: overloaded virtual function "CLASSNAME::METHODNAME" is only partially overridden in class "CLASSNAME"
#pragma diag_suppress=613

// warning 1011: function "CLASS::METHOD()" is hidden by "SUBCLASS::METHOD" -- virtual function override intended?
#pragma diag_suppress=1011

// warning 1111: attribute "visibility" ignored
#pragma diag_suppress=1111

// warning 1421: support for trigraphs is disabled
#pragma diag_suppress=1421

// warning 1783: cast increases required alignment to 4
#pragma diag_suppress=1783  // FIXME: this warning SHOULD NOT be ignored!



#endif // __CESysCompilerSNC_h__
