///////////////////////////////////////////////////////////////////////////////
// Copyright 2006,2007,2008,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef CENew_h
#define CENew_h

#include "CESysHeap.h"

#if !defined(DISABLE_ALLOCATOR_OVERRIDE)

////////////////////////////////////////////////////////////////
// Allocator function macros.
////////////////////////////////////////////////////////////////
//#include "CECom.h"

#define CEREALLOC_SOFTLIMIT(p,sz)   CEREALLOC(p,sz)
#define CEMALLOC_PLUGIN(sz)  CEMALLOC(sz)
#define CEFREE_PLUGIN(p)     CEFREE(p)
#define CEFREE_ALL_PLUGIN() 


////////////////////////////////////////////////////////////////
// new/delete for basic type.
//   These does not call the constructor and destructor.
////////////////////////////////////////////////////////////////

// general malloc
#define CENEW(TYPE) (reinterpret_cast<TYPE*>(CEMALLOC(sizeof(TYPE))))
#define CEDELETE(VALUE) (CEFREE((VALUE)))
#define CENEW_ARRAY(TYPE, N) (reinterpret_cast<TYPE*>(CEMALLOC(sizeof(TYPE) * (N))))
#define CEDELETE_ARRAY(VALUE) (CEFREE((VALUE)))

#else // !DISABLE_ALLOCATOR_OVERRIDE



////////////////////////////////////////////////////////////////
// Allocator function macros.
////////////////////////////////////////////////////////////////
#define CEMALLOC malloc
#define CEFREE free
#define CEREALLOC realloc
#define CECALLOC calloc
#define CEREALLOC_SOFTLIMIT realloc

////////////////////////////////////////////////////////////////
// new/delete operator override in class.
//   Declare this in the public section in class header.
////////////////////////////////////////////////////////////////
#define CEALLOCATORS // empty.

////////////////////////////////////////////////////////////////
// new/delete for basic type.
//   These does not call the constructor and destructor.
////////////////////////////////////////////////////////////////
#define CENEW(TYPE) (new TYPE)
#define CEDELETE(VALUE) (delete VALUE)
#define CENEW_ARRAY(TYPE, N) (new TYPE[N])
#define CEDELETE_ARRAY(VALUE) (delete [] VALUE)
#define CENEW_SOFTLIMIT(TYPE) (new TYPE)
#define CENEW_ARRAY_SOFTLIMIT(TYPE, N) (new TYPE[N])

#endif // !DISABLE_ALLOCATOR_OVERRIDE

#endif // CENew_h
