///////////////////////////////////////////////////////////////////////////////
// Copyright 2006,2007,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef CEFSPathnameUtil_h
#define CEFSPathnameUtil_h

#include "CECom.h"
#include "CEApiFSPathname.h"

inline CEHResult ICEFSPathnameCreate(ICEUString* strPath, ICEFSPathname** pathOut, UINT32 clsid = CEComStdClassID_CEFSPathnameFactory)
{
	CEComICEClassFactoryRef cfRef = 0;

	CEHResult hr = CEComGetClassObject(clsid, CEComIID_ICEClassFactory, (void**)&cfRef);
	if ( CESucceeded(hr) )
	{
		if ( cfRef )
		{
			union
			{
			    ICEFSPathname* iPathname;
			    void* ptr;
			} uPath;
			uPath.iPathname = 0;
			hr = cfRef.createInstance(0, CEComIID_ICEFSPathname, &uPath.ptr);
			if ( CESucceeded(hr) )
			{
				hr = uPath.iPathname->_vtbl->_init(uPath.iPathname, strPath);
				if ( CEFailed(hr) )
				{
					uPath.iPathname->_vtbl->_release(uPath.iPathname);
				}
				else
				{
					*pathOut = uPath.iPathname;
				}
			}
		}
	}
	return hr;
}

inline CEHResult ICEFSPathnameClone(ICEFSPathname* src, ICEFSPathname** pathOut, UINT32 clsid = CEComStdClassID_CEFSPathnameFactory)
{
	CEU_VALIDATE_PTR(src);
	CEU_VALIDATE_PTR(pathOut);

	CEHResult hr = CE_S_OK;
	if ( src )
	{
		CEComICEUStringRef istr;
		hr = src->_vtbl->_toString(src, &istr);
		if ( CESucceeded(hr) )
		{
			hr = ICEFSPathnameCreate(istr, pathOut, clsid);
		}
	}
	return hr;
}

#endif // CEFSPathnameUtil_h
