///////////////////////////////////////////////////////////////////////////////
// Copyright 2004,2005,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef CEComDebugServices_h
#define CEComDebugServices_h

///////////////////////////////////////////////////////////////////////////////
// Includes
///////////////////////////////////////////////////////////////////////////////

#include "CESysDefs.h"


///////////////////////////////////////////////////////////////////////////////
// Interfaces
///////////////////////////////////////////////////////////////////////////////

#ifdef __cplusplus
extern "C"
{
#endif

	//////////////////////////////////////
	//  Debug Service Callback Functions
	//////////////////////////////////////

	typedef void (*CEComDebugWriteUTF16CStrProc)(const CEUtf16Char* pUtf16CStr);
	typedef void (*CEComDebugWriteAsciiCStrProc)(const char* pCStr);

	typedef struct CEComDebugServiceRec
	{
		CEComDebugWriteUTF16CStrProc	writeUTF16CStr;
		CEComDebugWriteAsciiCStrProc	writeAsciiCStr;
	} CEComDebugServiceRec;

	////////////////////////////////////
	//  debug service functions.
	////////////////////////////////////

	//! This function formats given arguments with the specified format and outputs it to the debug console
	//!
	//! \remarks
	//! The acceptable format is very similar to ANSI-printf like:
	//!
	//!   % [0-9]* {d | x | p | s | c | hs}
	//!
	//! '%s' means the UTF16 string. 
	//! '%hs' means the ASCII string.
	CE_DLL_EXPORT void CEComDebugPrintf(const char* format, ...);
	CE_DLL_EXPORT void CEComDebugVPrintf(const char* format, va_list args);

#ifdef __cplusplus
}

#endif // __cplusplus

#endif // CEComDebugServices_h
