#
# Source file list generator.
#
#   Usage: gensrclist.pl file.vcproj outfile
#

use strict;
require 'idlfuncs.pl';

{
    my($DOM) = &gslReadVcproj($ARGV[0]);

    my(@FILES);
    &gslFindFile($DOM->{'Files'}, \@FILES);

#    use Data::Dumper;
#    print Dumper($DOM);

    &gslWriteMakefile(\@FILES, $ARGV[1]);
}

sub gslReadVcproj
{
    my($VCPROJ) = @_;
    my($PARSER);
    if ($VCPROJ)
    {
	open(FP, $VCPROJ) || die("Error: Can not open file '$VCPROJ' as input\n");
	my($XML) = join('', <FP>);
	close(FP);

	use XML::Simple;
	my($XS) = new XML::Simple();
	$PARSER = $XS->XMLin($XML);
    }

    return $PARSER;
}

sub gslFindFile
{
    my($OBJ, $FILES_REF) = @_;
    if (ref($OBJ))
    {
	if (ref($OBJ) eq 'HASH')
	{
	    my(%HASH) = %{$OBJ};
	    foreach my $KEY (keys(%HASH))
	    {
		if ($KEY eq 'File')
		{
		    if (ref($HASH{$KEY}) eq 'HASH')
		    {
			&gslGetFileName($HASH{$KEY}, $FILES_REF);
		    }
		    elsif (ref($HASH{$KEY}) eq 'ARRAY')
		    {
			my(@ARRAY) = @{$HASH{$KEY}};
			for (my $i = 0; $i < $#ARRAY + 1; $i++)
			{
			    &gslGetFileName($ARRAY[$i], $FILES_REF);
			}
		    }
		    else
		    {
			&gslFindFile($HASH{$KEY}, $FILES_REF);
		    }
		}
		else
		{
		    &gslFindFile($HASH{$KEY}, $FILES_REF);
		}
	    }
	}
	elsif (ref($OBJ) eq 'ARRAY')
	{
	    my(@ARRAY) = @{$OBJ};
	    for (my $i = 0; $i < $#ARRAY + 1; $i++)
	    {
		&gslFindFile($ARRAY[$i], $FILES_REF);
	    }
	}
	elsif (ref($OBJ) eq 'SCALAR')
	{
	    &gslFindFile($$OBJ, $FILES_REF);
	}
    }

}

sub gslGetFileName
{
    my($OBJ, $FILES_REF) = @_;
    my($FILE);
    my($RESULT) = &gslGetFileNameImpl($OBJ, \$FILE);
    if (!$RESULT && $FILE)
    {
	push(@{$FILES_REF}, $FILE);
    }
}

sub gslGetFileNameImpl
{
    my($OBJ, $FILE_REF) = @_;
    my($RESULT) = 0;
    if (ref($OBJ))
    {
	if (ref($OBJ) eq 'HASH')
	{
	    my(%HASH) = %{$OBJ};
	    foreach my $KEY (keys(%HASH))
	    {
		if ($KEY eq 'RelativePath')
		{
		    $$FILE_REF = $HASH{$KEY};
		}
		elsif ($KEY eq 'ExcludedFromBuild')
		{
		    $RESULT = $HASH{$KEY} eq 'true';
		}
		else
		{
		    $RESULT += &gslGetFileNameImpl($HASH{$KEY}, $FILE_REF);
		}
	    }
	}
	elsif (ref($OBJ) eq 'ARRAY')
	{
	    my(@ARRAY) = @{$OBJ};
	    for (my $i = 0; $i < $#ARRAY + 1 && !$RESULT; $i++)
	    {
		$RESULT += &gslGetFileNameImpl($ARRAY[$i], $FILE_REF);
	    }
	}
	elsif (ref($OBJ) eq 'SCALAR')
	{
	    $RESULT += &gslGetFileNameImpl($$OBJ, $FILE_REF);
	}
    }

    return $RESULT;
}

sub gslWriteMakefile
{
    my($FULLPATHS, $OUTFILE) = @_;
    if ($OUTFILE)
    {
	open(FPW, ">$OUTFILE") || die("Error: Can not open file $OUTFILE as output\n");
    }

    &gslWriteGencomclsList($FULLPATHS, 'ccd', 'GENCOMCLS');
    &gslWriteGencomclsList($FULLPATHS, 'csd', 'GENCOMSRV');
    &gslWriteObjectList($FULLPATHS);
}

sub gslWriteGencomclsList
{
    my($FULLPATHS, $SUFFIX, $PREFIX) = @_;

    my(@FILES) = grep(/\.$SUFFIX$/, @{$FULLPATHS});
    my(@BASES);
    foreach my $FILE (@FILES)
    {
	$FILE =~ s/\.\w*$//;
	$FILE =~ tr/\\/\//;
	push(@BASES, $FILE);
    }

    if (@BASES)
    {
	$SUFFIX =~ tr/[a-z]/[A-Z]/;

	# write gencomcls parameters
	&writeString("######################################################################\n");
	&writeString("# setup gencomcls\n");
	&writeString("######################################################################\n");
	&writeString("${PREFIX}_FLAGS\t= -I../../WebKitSilkLibraries\$(OUTDIR)/IDL\n");
	&writeString("${PREFIX}_OUTDIR\t= .\n");
	&writeString("${PREFIX}_${SUFFIX}_PATH\t= .\n");
	&writeString("${PREFIX}_BASE_NAMES = \\\n");
	foreach my $BASE (@BASES)
	{
	    &writeString("\t$BASE \\\n");
	}
	&writeString("\n");
    }
}
    
sub gslWriteObjectList
{
    my($FULLPATHS) = @_;
    my(@CS) = grep(/\.(cpp|c)$/, @{$FULLPATHS});

    my(@FILES);
    my(%PATH_HASH);
    foreach my $C (@CS)
    {
	$C =~ s/ProjectName/MODULE_NAME/;
	my(@STRINGS) = split(/\\/, $C);

	# make file list
	push(@FILES, pop(@STRINGS));

	# make unique path list
	my($PATH) = join('/', @STRINGS);
	$PATH_HASH{$PATH} = 1;
    }

    
    # write VPATH
    my(@VPATHS);
    my(@GTKS);
    foreach my $VPATH (sort(keys(%PATH_HASH)))
    {
	if ($VPATH =~ /(gtk)/)
	{
	    push(@GTKS, $VPATH);
	}
	else
	{
	    push(@VPATHS, $VPATH);
	}
    }
    push(@VPATHS, @GTKS);

    &writeString("######################################################################\n");
    &writeString("# setup the source directories\n");
    &writeString("######################################################################\n");
    &writeString("VPATH = \\\n");
    foreach my $VPATH (@VPATHS)
    {
	&writeString("\t$VPATH \\\n");
    }
    &writeString("\n");

    # write OBJ_FILES
    &writeString("######################################################################\n");
    &writeString("# objects\n");
    &writeString("######################################################################\n");
    &writeString("OBJ_FILES = \\\n");
    foreach my $FILE (@FILES)
    {
	$FILE =~ s/(cpp|c)$/o/;
	&writeString("\t$FILE \\\n");
    }
    &writeString("\n");
}
