use strict;

########################################################################################################
### output class(Java)
########################################################################################################
###
########################################################################################################

sub createInterfaceClass
{
    my($PAC_DIR, $INTERFACE_NAME_OL) = @_;

    open(FPI, ">./$INTERFACE_NAME_OL.java") || die("Error: Can not open file /classes/$INTERFACE_NAME_OL as output\n");
    &writeStringDispatch("package $PAC_DIR;\n\n","FPI");
    &writeStringDispatch("public interface $INTERFACE_NAME_OL {\n","FPI");
}

sub createClassClass
{
    my($PAC_DIR, $CLASS_REF_OL) = @_;

    open(FPC, ">./$CLASS_REF_OL->{'name'}.java") || die("Error: Can not open file /classes/$CLASS_REF_OL->{'name'} as output\n");
    &writeStringDispatch("package $PAC_DIR;\n\n","FPC");
    &writeStringDispatch("public class $CLASS_REF_OL->{'name'} ","FPC");

}

sub writeClassHead
{
    my($ICE_NAME, $CLASS_REF, $PAC_DIR) = @_;
    my($CLASS_NAME) = $CLASS_REF->{'name'};
    my($MODULE_NAME);
    if($CLASS_REF->{'java-to-c'})
    {
	&writeStringDispatch("implements ${ICE_NAME} ","FPC");
    }
    &writeStringDispatch("{\n","FPC");

    if($CLASS_REF->{'java-to-c'})
    {
	#get MODULE_NAME from current Makefile.
	open(FPM, "<./Makefile") || die("Error: Can not open file Makefile as input\n");
	my($buf);
	while (my $line = <FPM>)
	{
	    chomp($line);
	    if ($line =~ /\bMODULE_NAME\b/)
	    {
		my($idx) = index($line, '=') + 1;
		$buf = &trim(substr($line, $idx));
	    }
	}
	close(FPM);

	my($MEMBER_NAME) = &getJavaMarshallerInstanceName($CLASS_NAME);
	&writeStringDispatch("\tstatic {\n","FPC");
	&writeStringDispatch("\t\tSystem.loadLibrary(\"$buf\");\n","FPC");
	&writeStringDispatch("\t}\n","FPC");
	&writeStringDispatch("\n","FPC");
	&writeStringDispatch("\tprivate int ${MEMBER_NAME};\n\n","FPC");
	&writeStringDispatch("\tpublic ${CLASS_NAME} (int ice){\n","FPC");
	&writeStringDispatch("\t\tthis.${MEMBER_NAME} = ice;\n","FPC");
	&writeStringDispatch("\t}\n\n","FPC");
    }
    if($CLASS_REF->{'c-to-java'})
    {
	my @ICES = split(/,/, $ICE_NAME);
	my($PARAM_NUM) = 0;
	foreach my $ICE (@ICES)
	{
	    $ICE =~ s/${PAC_DIR}\.//;
	    my $ICE_INSTANCE_NAME = $ICE;
	    $ICE_INSTANCE_NAME = &getJavaInterfaceInstanceName($ICE_INSTANCE_NAME);
	    &writeStringDispatch("\tprivate $ICE $ICE_INSTANCE_NAME;\n","FPC");
	    $PARAM_NUM++;
	}
	&writeStringDispatch("\n","FPC");
	foreach my $ICE (@ICES)
	{
	    my $ICE_INSTANCE_NAME = $ICE;
	    $ICE_INSTANCE_NAME = &getJavaInterfaceInstanceName($ICE_INSTANCE_NAME);
	    &writeStringDispatch("\tpublic $CLASS_NAME ($ICE $ICE_INSTANCE_NAME){\n","FPC");
	    foreach my $ICE_TMP (@ICES)
	    {
		my $ICE_MEM_INS_NAME = $ICE_TMP;
		$ICE_MEM_INS_NAME = &getJavaInterfaceInstanceName($ICE_TMP);
		&writeStringDispatch("\t\tthis.$ICE_MEM_INS_NAME = ($ICE_TMP)$ICE_INSTANCE_NAME;\n","FPC");
	    }
	    &writeStringDispatch("\t}\n","FPC");
	    &writeStringDispatch("\n","FPC");
	}
    }
}

sub writeInterfaceFunction
{
    my($FUNC_IMPL_NAME, $FUNC_RETRUN, $PARAM_NO_THIS, $CLASS_REF) = @_;

    if ($FUNC_RETRUN eq "void")
    {
	&writeStringDispatch("\tpublic abstract void $FUNC_IMPL_NAME\n","FPI");
    }
    else
    {
	my($J_TYPE) = &convertType($FUNC_RETRUN);
	&writeStringDispatch("\tpublic abstract $J_TYPE $FUNC_IMPL_NAME\n","FPI");
    }
    if ($PARAM_NO_THIS)
    {
	my($NEW_PARAM) = &createParams($PARAM_NO_THIS, $CLASS_REF);
	&writeStringDispatch("\t\t($NEW_PARAM);\n","FPI");
    }
    else
    {
	&writeStringDispatch("\t\t();\n","FPI");
    }
    &writeStringDispatch("\n","FPI");
}

sub writeClassFunction
{
    my($FUNC_IMPL_NAME, $FUNC_RETRUN, $PARAM_NO_THIS, $IFACE_NAME, $CLASS_REF) = @_;
    my($CLASS_NAME) = $CLASS_REF->{'name'};
    if($CLASS_REF->{'c-to-java'})
    {
	if ($FUNC_RETRUN eq "void")
	{
	    &writeStringDispatch("\tpublic void $FUNC_IMPL_NAME\n","FPC");
	}
	else
	{
	    my($J_TYPE) = &convertType($FUNC_RETRUN, $CLASS_REF);
	    &writeStringDispatch("\tpublic  $J_TYPE $FUNC_IMPL_NAME\n","FPC");
	}
	if ($PARAM_NO_THIS)
	{
            $CLASS_NAME = &getJavaMarshallerInstanceName($CLASS_NAME);
	    my($NEW_PARAM) = &createParams($PARAM_NO_THIS, $CLASS_REF);
	    &writeStringDispatch("\t\t($NEW_PARAM){\n","FPC");
	    $IFACE_NAME = &getJavaInterfaceInstanceName($IFACE_NAME);
	    my @PARAMS = split(/,/, $NEW_PARAM);
	    my $JPARAMS;
	    my($PARAM_NUM) = 0;
	    foreach my $PARAM (@PARAMS)
	    {
		my($P_VAL) = &getValue($PARAM);
		@$JPARAMS[$PARAM_NUM] = "$P_VAL";
		$PARAM_NUM++;
	    }
	    my($JPARAM) = join ', ' ,(@{$JPARAMS});
	    &writeStringDispatch("\t\treturn ${IFACE_NAME}.${FUNC_IMPL_NAME}(${JPARAM});\n","FPC");
	    &writeStringDispatch("\t}\n","FPC");
	}
	else
	{
	    $IFACE_NAME = &getJavaInterfaceInstanceName($IFACE_NAME);
	    &writeStringDispatch("\t\t(){\n","FPC");
	    &writeStringDispatch("\t\treturn $IFACE_NAME.$FUNC_IMPL_NAME();\n","FPC");
	    &writeStringDispatch("\t}\n","FPC");
	}
	&writeStringDispatch("\n","FPC");
    }
    else
    {
	if ($FUNC_RETRUN eq "void")
	{
	    &writeStringDispatch("\tpublic native void $FUNC_IMPL_NAME\n","FPC");
	}
	else
	{
	    my($J_TYPE) = &convertType($FUNC_RETRUN, $CLASS_REF);
	    &writeStringDispatch("\tpublic native $J_TYPE $FUNC_IMPL_NAME\n","FPC");
	}
	if ($PARAM_NO_THIS)
	{
	    my($NEW_PARAM) = &createParams($PARAM_NO_THIS, $CLASS_REF);
	    &writeStringDispatch("\t\t(int ice, $NEW_PARAM);\n","FPC");
	}
	else
	{
	    &writeStringDispatch("\t\t(int ice);\n","FPC");
	}
	&writeStringDispatch("\n","FPC");

	if ($FUNC_RETRUN eq "void")
	{
	    &writeStringDispatch("\tpublic native void $FUNC_IMPL_NAME\n","FPC");
	}
	else
	{
	    my($J_TYPE) = &convertType($FUNC_RETRUN, $CLASS_REF);
	    &writeStringDispatch("\tpublic $J_TYPE $FUNC_IMPL_NAME\n","FPC");
	}
	if ($PARAM_NO_THIS)
	{
	    $CLASS_NAME = &getJavaMarshallerInstanceName($CLASS_NAME);
	    my($NEW_PARAM) = &createParams($PARAM_NO_THIS, $CLASS_REF);
	    &writeStringDispatch("\t\t($NEW_PARAM) {\n","FPC");
	    my @PARAMS = split(/,/, $NEW_PARAM);
	    my $JPARAMS;
	    my($PARAM_NUM) = 0;
	    foreach my $PARAM (@PARAMS)
	    {
		my($P_VAL) = &getValue($PARAM);
		@$JPARAMS[$PARAM_NUM] = "$P_VAL";
		$PARAM_NUM++;
	    }
	    my($JPARAM) = join ', ' ,(@{$JPARAMS});
	    &writeStringDispatch("\t\treturn $FUNC_IMPL_NAME($CLASS_NAME, $JPARAM);\n","FPC");
	    &writeStringDispatch("\t}\n","FPC");
	}
	else
	{
	    $CLASS_NAME = &getJavaMarshallerInstanceName($CLASS_NAME);
	    &writeStringDispatch("\t\t() {\n","FPC");
	    &writeStringDispatch("\t\treturn $FUNC_IMPL_NAME($CLASS_NAME);\n","FPC");
	    &writeStringDispatch("\t}\n","FPC");
	}
	&writeStringDispatch("\n","FPC");
    }
}

sub createParams
{
    my($PARAM_NO_THIS, $CLASS_REF) = @_;

    my(@PARAMS_OL) = split(',', $PARAM_NO_THIS);
    my($NEW_PARAMS);
    my($PARAM_NUM) = 0;
    foreach my $PARAM_OL (@PARAMS_OL)
    {
	my($P_TYPE) = &getType($PARAM_OL);
	my($P_VAL) = &getValue($PARAM_OL);
	my($Ja_TYPE) = &convertType($P_TYPE, $CLASS_REF);
	@$NEW_PARAMS[$PARAM_NUM] = "$Ja_TYPE $P_VAL";
	$PARAM_NUM++;
    }
    my($NEW_PARAM) = join ', ' ,(@{$NEW_PARAMS});

    return $NEW_PARAM;
}

sub closeInterfaceClass
{
    &writeStringDispatch("}\n","FPI");
    close(FPI);
}

sub closeClassClass
{
    &writeStringDispatch("}\n","FPC");
    close(FPC);
}

sub create_implements
{
    my($PAC_DIR, $INTERFACES_REF_OL) = @_;

    my($ICE_NAME);
    my($MTD_NUM) = 0;
    my($WK_ICE_NAME);
    my($INTERFACE_REF_OL);

    foreach $INTERFACE_REF_OL (@{$INTERFACES_REF_OL})
    {
	my($INTERFACE_NAME_OL) = $INTERFACE_REF_OL->{'name'};
	@$WK_ICE_NAME[$MTD_NUM] = $PAC_DIR . '.' . $INTERFACE_NAME_OL;
	$MTD_NUM++;
    }
    $ICE_NAME = join ',' ,(@{$WK_ICE_NAME});

    return $ICE_NAME;
}

#convert C++ -> Java.
sub convertType
{
    my($C_TYPE, $CLASS_REF) = @_;
    my($J_TYPE) = rtrim($C_TYPE);

    my($C_TYPE_CLASS_NAME) = $C_TYPE;
    $C_TYPE_CLASS_NAME =~ s/struct//;
    $C_TYPE_CLASS_NAME =~ s/\*//;
    $C_TYPE_CLASS_NAME =~ s/ //g;

    SWITCH: {
	if ($C_TYPE eq "CEHResult") { $J_TYPE = "int"; last SWITCH; }#for return-type.
	if (index($C_TYPE ,'double') > -1) { $J_TYPE = "double"; last SWITCH; }
	if (index($C_TYPE ,'bool') > -1) { $J_TYPE = "boolean"; last SWITCH; }
	if (index($C_TYPE ,'UINT32ARRAY_BUF') > -1) { $J_TYPE = "byte[]"; last SWITCH; }
	if (index($C_TYPE ,'UINT32ARRAY_LEN') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'UINT32') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'UINT16') > -1) { $J_TYPE = "short"; last SWITCH; }
	if (index($C_TYPE ,'INT64') > -1) { $J_TYPE = "long"; last SWITCH; }
	if (index($C_TYPE ,'INT32') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'INT_PTR *') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'void*') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'void *') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'DATA_BUF') > -1) { $J_TYPE = "byte[]"; last SWITCH; }
	if (index($C_TYPE ,'DATA_LEN') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'STR_BUF') > -1) { $J_TYPE = "String"; last SWITCH; }
	if (index($C_TYPE ,'STR_LEN') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'USIZE_T') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'RECT_X') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'RECT_Y') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'RECT_W') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'RECT_H') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'STRARRAY_BUF') > -1) { $J_TYPE = "byte[]"; last SWITCH; }
	if (index($C_TYPE ,'STRARRAY_LEN') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEConnectionType') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CESpecificPath') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEDefaultColor') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEFocusRendererType') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEScrollbarRendererType') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEWsysType') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEFontLibType') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEFocusNavigationType') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'eFontLibEmulationMode') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'eCEKeyboardEventType') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'eCEVirtualKey') > -1) { $J_TYPE = "byte"; last SWITCH; }
	if (index($C_TYPE ,'eCEKeyModifier') > -1) { $J_TYPE = "byte"; last SWITCH; }
	if (index($C_TYPE ,'eCEFocusEventType') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEApxUserAgentType') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEApxAcceptLanguage') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEApxScrollbarPolicy') > -1) { $J_TYPE = "long"; last SWITCH; }
	if (index($C_TYPE ,'CEApxCertErrCode') > -1) { $J_TYPE = "long"; last SWITCH; }
	if (index($C_TYPE ,'CEApxDatabaseVendor') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEApxApiFocusNavigationBehavior') > -1) { $J_TYPE = "long"; last SWITCH; }
	if (index($C_TYPE ,'CEApxApiErrorHandlingMode') > -1) { $J_TYPE = "long"; last SWITCH; }
	if (index($C_TYPE ,'CEApxApiSecureWarningPolicy') > -1) { $J_TYPE = "long"; last SWITCH; }
	if (index($C_TYPE ,'CEApxDownloadContentType') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEApxInvokerType') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEApxPlayFileSoundType') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEApxEnableFeature') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEApxNavigationStatus') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEApxSecurityStatus') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEApxDownloadStatus') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEApxNavigationWarningEventType') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEApxCancelGuideKeyType') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEApxPixelFormat') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEApxCharSize') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEApxCharEncoding') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEApxSuspendedFeature') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEDim *const') > -1) { $J_TYPE = "Object"; last SWITCH; }
	if (index($C_TYPE ,'eFocusCursorMode *const') > -1) { $J_TYPE = "Object"; last SWITCH; }
	if (index($C_TYPE ,'eCEDpyWindowLevel') > -1) { $J_TYPE = "int"; last SWITCH; }
	if (index($C_TYPE ,'CEPixelFormat* *const') > -1) { $J_TYPE = "Object"; last SWITCH; }
	if (index($C_TYPE ,'struct ICESpxBrowserManagerFactoryPeer*') > -1) { $J_TYPE = "$C_TYPE_CLASS_NAME"; last SWITCH; }
	if (index($C_TYPE ,'struct ICESpxBrowserManagerPeer*') > -1) { $J_TYPE = "$C_TYPE_CLASS_NAME"; last SWITCH; }
	if (index($C_TYPE ,'struct ICESpxBrowserComponentPeer*') > -1) { $J_TYPE = "$C_TYPE_CLASS_NAME"; last SWITCH; }
	if ($CLASS_REF->{'java-to-c'})
	{
	    if (index($C_TYPE ,'struct ICESpxBrowserConfiguration*') > -1) { $J_TYPE = "int"; last SWITCH; }
	    if (index($C_TYPE ,'struct ICESpxBrowserManager*') > -1) { $J_TYPE = "int"; last SWITCH; }
	    if (index($C_TYPE ,'struct ICESpxBrowserComponent*') > -1) { $J_TYPE = "int"; last SWITCH; }
	}
	else
	{
	    if (index($C_TYPE ,'struct ICESpxBrowserConfiguration*') > -1) { $J_TYPE = "$C_TYPE_CLASS_NAME"; last SWITCH; }
	    if (index($C_TYPE ,'struct ICESpxBrowserManager*') > -1) { $J_TYPE = "$C_TYPE_CLASS_NAME"; last SWITCH; }
	    if (index($C_TYPE ,'struct ICESpxBrowserComponent*') > -1) { $J_TYPE = "$C_TYPE_CLASS_NAME"; last SWITCH; }
	}
	if (index($C_TYPE ,'struct ICE') > -1) { $J_TYPE = "int"; last SWITCH; }
#	$nothing = 1;
    }
    return $J_TYPE;
}

#convert Java -> Native Type.
sub convertNativeType
{
    my($J_TYPE) = @_;
    my($N_TYPE) = rtrim($J_TYPE);

    SWITCH: {
	if (index($J_TYPE ,'byte[]') > -1) { $N_TYPE = "jbyteArray"; last SWITCH; }
	if (index($J_TYPE ,'byte') > -1) { $N_TYPE = "jbyte"; last SWITCH; }
	if (index($J_TYPE ,'short') > -1) { $N_TYPE = "jshort"; last SWITCH; }
	if (index($J_TYPE ,'int') > -1) { $N_TYPE = "jint"; last SWITCH; }
	if (index($J_TYPE ,'long') > -1) { $N_TYPE = "jlong"; last SWITCH; }
	if (index($J_TYPE ,'float') > -1) { $N_TYPE = "jfloat"; last SWITCH; }
	if (index($J_TYPE ,'double') > -1) { $N_TYPE = "jdouble"; last SWITCH; }
	if (index($J_TYPE ,'char') > -1) { $N_TYPE = "jchar"; last SWITCH; }
	if (index($J_TYPE ,'boolean') > -1) { $N_TYPE = "jboolean"; last SWITCH; }
	if (index($J_TYPE ,'void') > -1) { $N_TYPE = "void"; last SWITCH; }
	if (index($J_TYPE ,'Object') > -1) { $N_TYPE = "jobject"; last SWITCH; }
	if (index($J_TYPE ,'Class') > -1) { $N_TYPE = "jclass"; last SWITCH; }
	if (index($J_TYPE ,'String') > -1) { $N_TYPE = "jstring"; last SWITCH; }
	if (index($J_TYPE ,'ICE') > -1) { $N_TYPE = "jobject"; last SWITCH; }
#	$nothing = 1;
    }
    return $N_TYPE;
}

#convert Java -> Java-Signature.
sub convertSignature
{
    my($J_TYPE) = @_;
    my ${PREFIX} = "ApmProxyStub";
    my($S_TYPE) = rtrim($J_TYPE);

    SWITCH: {
	if (index($J_TYPE ,'double') > -1) { $S_TYPE = "D"; last SWITCH; }
	if (index($J_TYPE ,'boolean') > -1) { $S_TYPE = "Z"; last SWITCH; }
	if (index($J_TYPE ,'int') > -1) { $S_TYPE = "I"; last SWITCH; }
	if (index($J_TYPE ,'long') > -1) { $S_TYPE = "J"; last SWITCH; }
	if (index($J_TYPE ,'short') > -1) { $S_TYPE = "S"; last SWITCH; }
	if (index($J_TYPE ,'Object') > -1) { $S_TYPE = "Ljava/lang/Object;"; last SWITCH; }
	if (index($J_TYPE ,'String') > -1) { $S_TYPE = "Ljava/lang/String;"; last SWITCH; }
	if (index($J_TYPE ,'byte[]') > -1) { $S_TYPE = "[B"; last SWITCH; }
	if (index($J_TYPE ,'byte') > -1) { $S_TYPE = "B"; last SWITCH; }
	if (index($J_TYPE ,'ICESpxBrowserManagerFactoryPeer') > -1) { $S_TYPE = "L${PREFIX}/ICESpxBrowserManagerFactoryPeer;"; last SWITCH; }
	if (index($J_TYPE ,'ICESpxBrowserManagerPeer') > -1) { $S_TYPE = "L${PREFIX}/ICESpxBrowserManagerPeer;"; last SWITCH; }
	if (index($J_TYPE ,'ICESpxBrowserComponentPeer') > -1) { $S_TYPE = "L${PREFIX}/ICESpxBrowserComponentPeer;"; last SWITCH; }
	if (index($J_TYPE ,'ICESpxBrowserConfiguration') > -1) { $S_TYPE = "L${PREFIX}/ICESpxBrowserConfiguration;"; last SWITCH; }
	if (index($J_TYPE ,'ICESpxBrowserManager') > -1) { $S_TYPE = "L${PREFIX}/ICESpxBrowserManager;"; last SWITCH; }
	if (index($J_TYPE ,'ICESpxBrowserComponent') > -1) { $S_TYPE = "L${PREFIX}/ICESpxBrowserComponent;"; last SWITCH; }
#	$nothing = 1;
    }
    return $S_TYPE;
}

sub trim
{
    my $val = shift;
    $val =~ s/^ *(.*?) *$/$1/;
    return $val;
}

sub rtrim
{
    my $val = shift;
    $val =~ s/\s*$//;
    return $val;
}

1; ### for required call.
