///////////////////////////////////////////////////////////////////////////////
// Copyright 2008,2009 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#include "WebKitSilkPrefix.h"

#include "CESysDefs.h"
#include "CECom.h"
#include "CEWebKitClassFactory.h"


#if 0 //CE_OS(XAI)
// DBL_{EPSILON|MAX|MIN} support
#include <float.h>

_C_STD_BEGIN
_C_LIB_DECL
_Dvals _Dbl;
_END_C_LIB_DECL
_C_STD_END
#endif


/////////////////////////////////////
//  class object implementation
/////////////////////////////////////

extern "C" 
{
	CE_DLL_EXPORT CEHResult CECOM_DLL_FUNC(WebKitSilk, CEDllGetClassObject)(UINT32 clsid, UINT32 iid, CEComAllocatorRec* pAllocatorRec, void** ppv);
	CE_DLL_EXPORT bool CECOM_DLL_FUNC(WebKitSilk, CEDllCanUnloadNow)();
	CE_DLL_EXPORT bool CECOM_DLL_FUNC(WebKitSilk, CEDllMain)(CEDllHandle hDLL, UINT32 reason, void* param);
};

CE_DLL_EXPORT CEHResult CECOM_DLL_FUNC(WebKitSilk, CEDllGetClassObject)(UINT32 clsid, UINT32 iid, CEComAllocatorRec* pAllocatorRec, void** ppv)
{
	CEHResult hr = CEWebKitClassFactoryImpl::getClassFactory(clsid, iid, ppv);
	return hr;
}

CE_DLL_EXPORT bool CECOM_DLL_FUNC(WebKitSilk, CEDllCanUnloadNow)()
{
	bool canUnloadNow = CEWebKitClassFactoryImpl::canUnloadNow();
	return canUnloadNow;
}

CE_DLL_EXPORT bool CECOM_DLL_FUNC(WebKitSilk, CEDllMain)(CEDllHandle hDLL, UINT32 reason, void* param)
{
	switch (reason)
	{
	case CEDLL_PROCESS_ATTACH:		
#if 0 //CE_OS(XAI)
        _CSTD _Dbl._Ddig = DBL_DIG;
        _CSTD _Dbl._Dmdig = DBL_MANT_DIG;
        _CSTD _Dbl._Dmax10e = DBL_MAX_10_EXP;
        _CSTD _Dbl._Dmaxe = DBL_MAX_EXP;
        _CSTD _Dbl._Dmin10e = DBL_MIN_10_EXP;
        _CSTD _Dbl._Dmine = DBL_MIN_EXP;
        _CSTD _Dbl._Deps._Double = 0x8p-55;
        _CSTD _Dbl._Dmax._Double = 0xf.ffffffffffff8p+1020;
        _CSTD _Dbl._Dmin._Double = 0x8p-1025;
#endif
        break;
	case CEDLL_PROCESS_DETACH:
		break;
	default:
		;
	}
	return true;
}

//////////////////////////////////////////////////////////////////
//! platform specific implementations.
//////////////////////////////////////////////////////////////////
#if CE_OS(WIN32)
extern "C" 
{
	CE_DLL_EXPORT BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)  
	{
		return CECOM_DLL_FUNC(WebKitSilk, CEDllMain)(hinstDLL, fdwReason, lpvReserved);
	}
} // extern C
#elif CE_OS(LINUX) || CE_OS(HYDRA) || CE_OS(ANDROID) || CE_OS(XAI)
// nothing
#elif 0
    #ifdef __cplusplus
    extern "C" {
    #endif
        static void __attribute__ ((constructor)) dll_init(void) {}
        static void __attribute__ ((destructor)) dll_fini(void) {}
    #ifdef __cplusplus
    } // extern C
    #endif
#else
#error unknown or unspecified development platform
#endif

#if 0 //CE_OS(XAI)
extern "C"
{
void WebKitSilk_GetProcs(CEDllGetClassObjectProc* getClassObjectProcOut, CEDllCanUnloadNowProc* canUnloadNowProcOut, CEDllMainProc* mainProcOut)
{
	*getClassObjectProcOut = WebKitSilk_CEDllGetClassObject;
	*canUnloadNowProcOut = WebKitSilk_CEDllCanUnloadNow;
	*mainProcOut = WebKitSilk_CEDllMain;
}
};

struct uso_double { char c[8]; } __attribute__ ((aligned (sizeof(double)))) _Nan = { {   0x7F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } };

#include <math.h>
#include <bits/f_fmodf.h>

_C_LIB_DECL
float fmodf(float x, float y)  { return f_fmodf(x, y); }
long int lround(double x) { return lroundf(x); }
double round(double x) { return lroundf(x); }
double trunc(double x) { if (x < 0) return ceil(x); else return floor(x); }

double nextafter(double x, double y) { return y; }
float nextafterf(float x, float y) { return y; }

double nan(const char *tagp) { return *reinterpret_cast<double*>(&_Nan); }
short _FDtest(float *);
short _Dtest(double* d) { float f = *d; return _FDtest(&f); }
int _Dsign(double d) { return (d < 0.0);}
_END_C_LIB_DECL

#endif

